% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Spectra-class.R, R/ASICSResults-class.R,
%   R/PureLibrary-class.R
\name{combineAndSubset-methods}
\alias{combineAndSubset-methods}
\alias{[,Spectra,ANY,ANY,ANY-method}
\alias{[.Spectra}
\alias{c,Spectra-method}
\alias{c.Spectra}
\alias{[,ASICSResults,ANY,ANY,ANY-method}
\alias{[.ASICSResults}
\alias{c,ASICSResults-method}
\alias{c.ASICSResults}
\alias{[,PureLibrary,ANY,ANY,ANY-method}
\alias{[.PureLibrary}
\alias{c,PureLibrary-method}
\alias{c.PureLibrary}
\title{Combine or subset functions}
\usage{
\S4method{[}{Spectra,ANY,ANY,ANY}(x, i)

\S4method{c}{Spectra}(x, ...)

\S4method{[}{ASICSResults,ANY,ANY,ANY}(x, i)

\S4method{c}{ASICSResults}(x, ...)

\S4method{[}{PureLibrary,ANY,ANY,ANY}(x, i)

\S4method{c}{PureLibrary}(x, ...)
}
\arguments{
\item{x}{An object of class \linkS4class{Spectra},
\linkS4class{PureLibrary} or \linkS4class{ASICSResults}.}

\item{i}{vector of indices specifying which elements to extract}

\item{...}{objects to be concatenated}
}
\value{
A \linkS4class{Spectra} object containing a part of the original
object or combining other \linkS4class{Spectra} objects
}
\description{
Methods available to combine multiple objects or to extract a subset of one
object in ASICS package.
}
\examples{
# Import data and create object
current_path <- file.path(system.file("extdata", package = "ASICS"),
                          "spectra_example.txt")
spectra_data <- read.table(current_path, header = TRUE, row.names = 1)
spectra_obj <- createSpectra(spectra_data)

# Extract the first sample
spectra_obj[1]
}
