% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Spectra-class.R, R/ASICSResults-class.R,
%   R/AnalysisResults-class.R, R/PureLibrary-class.R
\name{accessors-methods}
\alias{accessors-methods}
\alias{getSampleName,Spectra-method}
\alias{getSampleName}
\alias{getPpmGrid,Spectra-method}
\alias{getPpmGrid}
\alias{getSpectra,Spectra-method}
\alias{getSpectra}
\alias{getNormMethod,Spectra-method}
\alias{getNormMethod}
\alias{getNormParams,Spectra-method}
\alias{getNormParams}
\alias{getReconstructedSpectra,ASICSResults-method}
\alias{getReconstructedSpectra}
\alias{getQuantification,ASICSResults-method}
\alias{getQuantification}
\alias{getDeformedLibrary,ASICSResults-method}
\alias{getDeformedLibrary}
\alias{getTypeAnalysis,AnalysisResults-method}
\alias{getTypeAnalysis}
\alias{getTypeData,AnalysisResults-method}
\alias{getTypeData}
\alias{getDataset,AnalysisResults-method}
\alias{getDataset}
\alias{getResults,AnalysisResults-method}
\alias{getResults}
\alias{getBestModel,AnalysisResults-method}
\alias{getBestModel}
\alias{getCVError,AnalysisResults-method}
\alias{getCVError}
\alias{getMeanByGroup,AnalysisResults-method}
\alias{getMeanByGroup}
\alias{getNbProtons,PureLibrary-method}
\alias{getNbProtons}
\title{Accessors}
\usage{
\S4method{getSampleName}{Spectra}(object)

\S4method{getPpmGrid}{Spectra}(object)

\S4method{getSpectra}{Spectra}(object)

\S4method{getNormMethod}{Spectra}(object)

\S4method{getNormParams}{Spectra}(object)

\S4method{getReconstructedSpectra}{ASICSResults}(object)

\S4method{getQuantification}{ASICSResults}(object)

\S4method{getDeformedLibrary}{ASICSResults}(object)

\S4method{getTypeAnalysis}{AnalysisResults}(object)

\S4method{getTypeData}{AnalysisResults}(object)

\S4method{getDataset}{AnalysisResults}(object)

\S4method{getResults}{AnalysisResults}(object)

\S4method{getBestModel}{AnalysisResults}(object)

\S4method{getCVError}{AnalysisResults}(object)

\S4method{getMeanByGroup}{AnalysisResults}(object)

\S4method{getNbProtons}{PureLibrary}(object)
}
\arguments{
\item{object}{An object of class \linkS4class{Spectra},
\linkS4class{PureLibrary}, \linkS4class{ASICSResults} or
\linkS4class{AnalysisResults}.}
}
\value{
The wanted accessor
}
\description{
List of available accessors for each slot of all S4 classes present in the
package.
}
\examples{
# Import data and create object
current_path <- file.path(system.file("extdata", package = "ASICS"),
                          "spectra_example.txt")
spectra_data <- read.table(current_path, header = TRUE, row.names = 1)
spectra_obj <- createSpectra(spectra_data)

# Sample names
getSampleName(spectra_obj)
# Spectra
getSpectra(spectra_obj)
}
