% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AnalysisResults-class.R
\docType{class}
\name{AnalysisResults-class}
\alias{AnalysisResults-class}
\title{Class \linkS4class{AnalysisResults}}
\description{
Objects of class \linkS4class{AnalysisResults} contains results of analyses
performed with the functions \code{\link{pca}}, \code{\link{oplsda}} and
\code{\link{kruskalWallis}}.
}
\section{Slots}{

\describe{
\item{\code{type.analysis}}{Name of the analysis (\emph{e.g.,} \code{"PCA"},
\code{"OPLS-DA"}, ...).}

\item{\code{type.data}}{Type of data used for the analyses (\emph{e.g.,}
\code{"quantification"}, \code{"buckets"}...).}

\item{\code{dataset}}{The object of type \code{\link{SummarizedExperiment}} used for
the analysis.}

\item{\code{results}}{Results of the analysis. Can be a data frame for test results
or an object of class \code{\link{opls}} from \code{\link{ropls}} for PCA and
OPLS-DA.}

\item{\code{best.model}}{Best model (only for OPLS-DA analyses).}

\item{\code{cv.error}}{Cross validation error (only for OPLS-DA analyses).}

\item{\code{mean.by.group}}{Data frame with means by group and a variable indicating
if there is a significant difference between groups for tests and if the VIP
associated to the variable is superior to the given threshold for OPLS-DA.}
}}

\section{Methods}{

  Multiple methods can be applied on \linkS4class{AnalysisResults} objects.
  \itemize{
    \item As usual for S4 object, show and summary methods are available, see
    \link[=summary-methods]{Object summary}
    \item All slots have an accessor \code{get_slot name}, see
    \link[=accessors-methods]{Accessors}
    \item All results contained in an object can be represent in a plot, see
    \link[=visualisation-methods-analyses]{Visualisation methods}
  }
}

