% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apl.R
\name{permutation_cutoff}
\alias{permutation_cutoff}
\title{Calculates permuted association plot coordinates}
\usage{
permutation_cutoff(
  caobj,
  mat,
  group = caobj@group,
  dims = caobj@dims,
  reps = 10,
  store_perm = FALSE,
  python = TRUE
)
}
\arguments{
\item{caobj}{A "cacomp" object with principal row coordinates and
standardized column coordinates calculated.}

\item{mat}{A numeric matrix. For sequencing a count matrix, gene expression
values with genes in rows and samples/cells in columns.
Should contain row and column names.}

\item{group}{Vector of indices of the columns to calculate centroid/x-axis
direction.}

\item{dims}{Integer. Number of CA dimensions to retain. Needs to be the same
as in caobj!}

\item{reps}{Integer. Number of permutations to perform.}

\item{store_perm}{Logical. Whether permuted data should be stored in the CA
object.
This implementation dramatically speeds up computation compared to `svd()`
in R.}

\item{python}{DEPRACTED. A logical value indicating whether to use singular-value
decomposition from the python package torch.}
}
\value{
List with permuted apl coordinates ("apl_perm") and, a list of saved ca
components ("saved_ca") that allow for quick recomputation of the CA results.
 For random_direction_cutoff this saved_ca is empty.
}
\description{
Calculates matrix of apl coordinates when permuting the original data.
}
