% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SpectralClustering.R
\name{spectral_clustering}
\alias{spectral_clustering}
\title{spectral_clustering}
\usage{
spectral_clustering(A, k, type = c("rw", "sym", "unnormalized"),
  verbose = FALSE)
}
\arguments{
\item{A}{affinity matrix}

\item{k}{the number of clusters}

\item{type}{choose one of three versions of graph Laplacian:
"unnormalized": unnormalized graph Laplacian matrix (L = D - W);
"rw": normalization closely related to random walk (L = I - D^(-1)*W); (default choice)
"sym": normalized symmetric matrix (L = I - D^(-0.5) * W * D^(-0.5))
For more information: 
https://www.cs.cmu.edu/~aarti/Class/10701/readings/Luxburg06_TR.pdf}

\item{verbose}{logical(1); if true, print user-friendly information}
}
\value{
a numeric vector as class labels
}
\description{
spectral_clustering
}
\examples{
D = matrix(runif(400), nrow = 20)
A = affinity_matrix(D, 5)
labels = spectral_clustering(A, k=2)
}
