/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.search;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.biojava.bio.Annotatable;
import org.biojava.bio.Annotation;
import org.biojava.bio.search.SeqSimilaritySearchResult;
import org.biojava.bio.seq.db.SequenceDB;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.AbstractChangeable;
import org.biojava.utils.ChangeListener;
import org.biojava.utils.ObjectUtil;
import org.biojava.utils.contract.Contract;

public class SequenceDBSearchResult
extends AbstractChangeable
implements SeqSimilaritySearchResult,
Annotatable {
    private SequenceDB sequenceDB;
    private Map searchParameters;
    private SymbolList querySeq;
    private List hits;
    private Annotation annotation;

    public SequenceDBSearchResult(SequenceDB sequenceDB, Map map, SymbolList symbolList, Annotation annotation, List list) {
        Contract.pre(symbolList != null, "querySeq was null");
        Contract.pre(sequenceDB != null, "sequenceDB was null");
        Contract.pre(annotation != null, "annotation was null");
        Contract.pre(list != null, "hits was null");
        this.sequenceDB = sequenceDB;
        this.searchParameters = map;
        this.querySeq = symbolList;
        this.hits = list;
        this.annotation = annotation;
        this.sequenceDB.addChangeListener(ChangeListener.ALWAYS_VETO);
        this.querySeq.addChangeListener(ChangeListener.ALWAYS_VETO);
        this.annotation.addChangeListener(ChangeListener.ALWAYS_VETO);
    }

    public Object clone() {
        return this;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!object.getClass().equals(this.getClass())) {
            return false;
        }
        SequenceDBSearchResult sequenceDBSearchResult = (SequenceDBSearchResult)object;
        if (!ObjectUtil.equals(this.querySeq, sequenceDBSearchResult.querySeq)) {
            return false;
        }
        if (!ObjectUtil.equals(this.sequenceDB, sequenceDBSearchResult.sequenceDB)) {
            return false;
        }
        if (!ObjectUtil.equals(this.searchParameters, sequenceDBSearchResult.searchParameters)) {
            return false;
        }
        if (!ObjectUtil.equals(this.hits, sequenceDBSearchResult.hits)) {
            return false;
        }
        return ObjectUtil.equals(this.annotation, sequenceDBSearchResult.annotation);
    }

    public Annotation getAnnotation() {
        return this.annotation;
    }

    public List getHits() {
        return Collections.unmodifiableList(this.hits);
    }

    public SymbolList getQuerySequence() {
        return this.querySeq;
    }

    public Map getSearchParameters() {
        return this.searchParameters == null ? null : Collections.unmodifiableMap(this.searchParameters);
    }

    public SequenceDB getSequenceDB() {
        return this.sequenceDB;
    }

    public int hashCode() {
        int n = 0;
        n = ObjectUtil.hashCode(n, this.querySeq);
        n = ObjectUtil.hashCode(n, this.sequenceDB);
        n = ObjectUtil.hashCode(n, this.searchParameters);
        n = ObjectUtil.hashCode(n, this.hits);
        n = ObjectUtil.hashCode(n, this.annotation);
        return n;
    }

    public String toString() {
        return "SequenceDBSearchResult of " + this.getQuerySequence() + " against " + this.getSequenceDB();
    }
}

