/*
 * Decompiled with CFR 0.152.
 */
package eponine;

import eponine.model.EponineXML;
import eponine.model.FastModel;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import org.apache.xerces.parsers.DOMParser;
import org.biojava.bio.program.gff.GFFWriter;
import org.biojava.bio.program.gff.SimpleGFFRecord;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.SequenceIterator;
import org.biojava.bio.seq.StrandedFeature;
import org.biojava.bio.seq.io.SeqIOTools;
import org.biojava.bio.symbol.SymbolList;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import stats.glm.GLMClassificationModel;

public class ScanApp {
    public static final String VERSION = "0.1";
    public static final String DEFAULT_MODEL = "eponine-model.xml";
    static /* synthetic */ Class class$eponine$ScanApp;

    private static void printUsage() {
        System.err.println("usage: java eponine.ScanApp -seq <sequence.fasta> -threshold <threshold> [-model <modelfile.xml>]");
        System.exit(1);
    }

    public static void main(String[] stringArray) throws Exception {
        InputSource inputSource;
        Object object;
        String string = null;
        String string2 = null;
        double d = Double.NEGATIVE_INFINITY;
        try {
            int n = 0;
            while (n < stringArray.length) {
                if (stringArray[n].equals("-seq")) {
                    string = stringArray[++n];
                } else if (stringArray[n].equals("-threshold")) {
                    d = Double.parseDouble(stringArray[++n]);
                } else if (stringArray[n].equals("-model")) {
                    string2 = stringArray[++n];
                }
                ++n;
            }
        }
        catch (Exception exception) {
            ScanApp.printUsage();
        }
        if (string == null) {
            ScanApp.printUsage();
        }
        if (d == Double.NEGATIVE_INFINITY) {
            ScanApp.printUsage();
        }
        if (string2 == null) {
            object = (class$eponine$ScanApp == null ? (class$eponine$ScanApp = ScanApp.class$("eponine.ScanApp")) : class$eponine$ScanApp).getClassLoader().getResourceAsStream(DEFAULT_MODEL);
            if (object == null) {
                System.err.println("No default model available: must specify -model on the command line");
                System.exit(1);
            }
            inputSource = new InputSource((InputStream)object);
        } else {
            inputSource = new InputSource(new FileReader(string2));
        }
        object = new EponineXML();
        DOMParser dOMParser = new DOMParser();
        dOMParser.parse(inputSource);
        Element element = dOMParser.getDocument().getDocumentElement();
        GLMClassificationModel gLMClassificationModel = ((EponineXML)object).xmlToModel(element);
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
        SequenceIterator sequenceIterator = SeqIOTools.readFastaDNA(bufferedReader);
        PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(System.out));
        GFFWriter gFFWriter = new GFFWriter(printWriter);
        gFFWriter.startDocument("");
        gFFWriter.commentLine(" Output from Eponine ScanApp 0.1");
        gFFWriter.commentLine(" Model: " + string2);
        gFFWriter.commentLine(" Threshold: " + d);
        while (sequenceIterator.hasNext()) {
            Sequence sequence = sequenceIterator.nextSequence();
            ScanApp.epoScan(gFFWriter, gLMClassificationModel, sequence, d, false);
            ScanApp.epoScan(gFFWriter, gLMClassificationModel, sequence, d, true);
        }
        printWriter.flush();
    }

    public static void epoScan(GFFWriter gFFWriter, GLMClassificationModel gLMClassificationModel, Sequence sequence, double d, boolean bl) throws Exception {
        SymbolList symbolList = bl ? DNATools.reverseComplement(sequence) : sequence;
        FastModel fastModel = new FastModel(gLMClassificationModel, symbolList, 1000);
        int n = -1000;
        int n2 = -1000;
        double d2 = 0.0;
        int n3 = 1;
        int n4 = 1;
        while (n4 < symbolList.length()) {
            double d3 = fastModel.score(n4);
            if (d3 > d) {
                d2 = Math.max(d2, d3);
                n = n4;
                if (n2 < 0) {
                    n2 = n4;
                }
            } else if (n > 0 && n4 - n > n3) {
                SimpleGFFRecord simpleGFFRecord = new SimpleGFFRecord();
                simpleGFFRecord.setSource("Eponine");
                simpleGFFRecord.setFeature("TSS");
                simpleGFFRecord.setScore(d2);
                simpleGFFRecord.setSeqName(sequence.getName());
                if (bl) {
                    simpleGFFRecord.setEnd(sequence.length() - n2 + 2);
                    simpleGFFRecord.setStart(sequence.length() - n + 2);
                    simpleGFFRecord.setStrand(StrandedFeature.NEGATIVE);
                } else {
                    simpleGFFRecord.setStart(n2);
                    simpleGFFRecord.setEnd(n);
                    simpleGFFRecord.setStrand(StrandedFeature.POSITIVE);
                }
                simpleGFFRecord.setFrame(-1);
                gFFWriter.recordLine(simpleGFFRecord);
                n = -1000;
                n2 = -1000;
                d2 = 0.0;
            }
            ++n4;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

