## ----eval=FALSE---------------------------------------------------------------
# if (!require("BiocManager", quietly=TRUE))
#     install.packages("BiocManager")
# BiocManager::install("h5mread")

## ----message=FALSE------------------------------------------------------------
library(h5mread)

## ----results='hide', message=FALSE--------------------------------------------
set.seed(2009)
m0 <- matrix(runif(105e6), ncol=1500)  # 70,000 x 1,500 matrix
temp0_h5 <- tempfile(fileext=".h5")
HDF5Array::writeHDF5Array(m0, temp0_h5, "m0", chunkdim=c(100, 100))

## -----------------------------------------------------------------------------
h5ls(temp0_h5)
nrow0 <- h5dim(temp0_h5, "m0")[[1L]]
starts <- list(sample(nrow0, 1000), NULL)
m <- h5mread(temp0_h5, "m0", starts=starts)

## -----------------------------------------------------------------------------
stopifnot(identical(m, m0[starts[[1L]], ]))

## ----results='hide'-----------------------------------------------------------
a1 <- poissonSparseArray(c(6100, 960, 75), density=0.5)
a2 <- poissonSparseArray(c(6100, 960, 75), density=0.05)

temp1_h5 <- tempfile(fileext=".h5")
HDF5Array::writeHDF5Array(a1, temp1_h5, "a1", chunkdim=c(50, 40, 5), level=5)
temp2_h5 <- tempfile(fileext=".h5")
HDF5Array::writeHDF5Array(a2, temp2_h5, "a2", chunkdim=c(50, 40, 5), level=5)

## -----------------------------------------------------------------------------
file.size(temp1_h5)
file.size(temp2_h5)

## -----------------------------------------------------------------------------
a21 <- h5mread(temp2_h5, "a2")  # not memory-efficient
object.size(a21)

## -----------------------------------------------------------------------------
a22 <- h5mread(temp2_h5, "a2", as.sparse=TRUE)  # memory-efficient
object.size(a22)

## -----------------------------------------------------------------------------
class(a22)

## -----------------------------------------------------------------------------
stopifnot(
  identical(a21, as.array(a2)),
  is(a22, "COO_SparseArray"),
  identical(as.array(a22), as.array(a2))
)

## -----------------------------------------------------------------------------
a22 <- as(a22, "SVT_SparseArray")
class(a22)

## -----------------------------------------------------------------------------
object.size(a22)

## -----------------------------------------------------------------------------
sessionInfo()

