## ----setup, include = FALSE---------------------------------------------------
knitr::opts_chunk$set(
    collapse = TRUE,
    comment = "#>",
    crop = NULL ## Related to https://stat.ethz.ch/pipermail/bioc-devel/2020-April/016656.html
)

## ----"start", message=FALSE, warning=FALSE------------------------------------
library("spatialLIBD")

## ----"normalized_data_download"-----------------------------------------------
## Grab SpatialExperiment with normalized counts
spe <- fetch_data(type = "visiumStitched_brain_spe")

## Check that spe does contain the "logcounts" assay
assayNames(spe)

## Define white matter marker genes
wm_genes <- rownames(spe)[
    match(c("MBP", "GFAP", "PLP1", "AQP4"), rowData(spe)$gene_name)
]

## ----"rotate", fig.height=4---------------------------------------------------
## Rotate image and gene-expression data by 180 degrees, plotting a combination
## of white-matter genes
vis_gene(
    rotateObject(spe, sample_id = "Br2719", degrees = 180),
    geneid = wm_genes,
    assayname = "counts",
    is_stitched = TRUE,
    spatial = FALSE
)

## ----"mirror", fig.height = 4-------------------------------------------------
## Mirror image and gene-expression data across a vertical axis, plotting a
## combination of white-matter genes
vis_gene(
    mirrorObject(spe, sample_id = "Br2719", axis = "v"),
    geneid = wm_genes,
    assayname = "counts",
    is_stitched = TRUE,
    spatial = FALSE
)

## ----"fetch_norm", fig.height = 4---------------------------------------------
## Plot combination of normalized counts for some white-matter genes
vis_gene(
    spe,
    geneid = wm_genes,
    assayname = "logcounts",
    is_stitched = TRUE,
    spatial = FALSE
)

## ----"unnorm_plot", fig.height = 4--------------------------------------------
## Plot raw counts, which are noisier
## Same plot we made before, but this time with no histology images
vis_gene(
    spe,
    geneid = wm_genes,
    assayname = "counts",
    is_stitched = TRUE,
    spatial = FALSE
)

## ----"merge_overlapping", eval = FALSE----------------------------------------
# spe_merged <- merge_overlapping(spe)

