/*
 * Decompiled with CFR 0.152.
 */
package fr.cea.ig.metatarget.datastructures;

import fr.cea.ig.metatarget.datastructures.ClusterPoisson;
import fr.cea.ig.metatarget.datastructures.ClusterVectorAB;
import fr.cea.ig.metatarget.datastructures.Dictionary;
import fr.cea.ig.metatarget.datastructures.EMasync;
import fr.cea.ig.metatarget.datastructures.EMsync;
import fr.cea.ig.metatarget.datastructures.Sequence;
import fr.cea.ig.metatarget.utils.Utils;
import gnu.trove.iterator.TLongIntIterator;
import java.util.HashSet;

public class VectorUtils {
    public static double cosineSequence2Cluster(Sequence sequence, ClusterVectorAB clusterVector) {
        if (clusterVector == null || clusterVector.isEmpty()) {
            return Double.NEGATIVE_INFINITY;
        }
        double similarity = 0.0;
        double clusterNorm = clusterVector.getNorm();
        double sequenceNorm = 0.0;
        TLongIntIterator it = sequence.iteratorCounts();
        while (it.hasNext()) {
            it.advance();
            long kmerCode = it.key();
            int sequenceKmerCount = it.value();
            double sequenceKmerWeight = sequenceKmerCount;
            sequenceNorm += sequenceKmerWeight * sequenceKmerWeight;
            double clusterKmerWeight = clusterVector.getCountForKmerCode(kmerCode);
            if (clusterKmerWeight == 0.0) continue;
            similarity += clusterKmerWeight * sequenceKmerWeight;
        }
        sequenceNorm = Math.sqrt(sequenceNorm);
        if (clusterNorm == 0.0) {
            clusterNorm = 1.0;
        }
        if (sequenceNorm == 0.0) {
            sequenceNorm = 1.0;
        }
        return similarity / (clusterNorm * sequenceNorm);
    }

    public static ClusterPoisson[] createABClusterPoissonsEMsync(int numOfClusters, int excludeMin, int excludeMax, Dictionary dictionary) {
        ClusterPoisson[] clusterPoissons = new ClusterPoisson[numOfClusters];
        EMsync em = new EMsync(numOfClusters, excludeMin, excludeMax, dictionary);
        System.out.println(Utils.time() + " START of EMsync");
        em.performEM();
        System.out.println(Utils.time() + " END of EMsync");
        double[] clusterAbundances = em.getClusterAbundances();
        double[] clusterSizes = em.getClusterSizes();
        for (int i = 0; i < numOfClusters; ++i) {
            int highLimit;
            ClusterPoisson cp;
            double abundance = clusterAbundances[i];
            double size = clusterSizes[i];
            clusterPoissons[i] = cp = new ClusterPoisson(abundance, size);
            double sigma = Math.sqrt(abundance);
            int lowLimit = (int)(abundance - 5.0 * sigma);
            if (lowLimit > (highLimit = (int)(abundance + 5.0 * sigma))) {
                highLimit = lowLimit;
            }
            if (lowLimit < excludeMin) {
                lowLimit = excludeMin;
            }
            if (highLimit > excludeMax && excludeMax != 0) {
                highLimit = excludeMax;
            }
            cp.setHighLimit(highLimit);
            cp.setLowLimit(lowLimit);
        }
        return clusterPoissons;
    }

    public static ClusterPoisson[] createABClusterPoissonsEMasync(int numOfClusters, int excludeMin, int excludeMax, Dictionary dictionary) {
        ClusterPoisson[] clusterPoissons = new ClusterPoisson[numOfClusters];
        EMasync em = new EMasync(numOfClusters, excludeMin, excludeMax, dictionary);
        System.out.println(Utils.time() + " START of EMasync");
        em.performEM();
        System.out.println(Utils.time() + " END of EMasync");
        double[] clusterAbundances = em.getClusterAbundances();
        double[] clusterSizes = em.getClusterSizes();
        for (int i = 0; i < numOfClusters; ++i) {
            int highLimit;
            ClusterPoisson cp;
            double abundance = clusterAbundances[i];
            double size = clusterSizes[i];
            clusterPoissons[i] = cp = new ClusterPoisson(abundance, size);
            double sigma = Math.sqrt(abundance);
            int lowLimit = (int)(abundance - 3.0 * sigma);
            if (lowLimit > (highLimit = (int)(abundance + 3.0 * sigma))) {
                highLimit = lowLimit;
            }
            if (lowLimit < excludeMin) {
                lowLimit = excludeMin;
            }
            if (highLimit > excludeMax && excludeMax != 0) {
                highLimit = excludeMax;
            }
            cp.setHighLimit(highLimit);
            cp.setLowLimit(lowLimit);
        }
        return clusterPoissons;
    }

    public static ClusterPoisson[] filterClusterPoissons(ClusterPoisson[] oldClusterPoissons) {
        HashSet<ClusterPoisson> newClusterPoissons = new HashSet<ClusterPoisson>();
        for (ClusterPoisson oldCp : oldClusterPoissons) {
            if (!newClusterPoissons.isEmpty()) {
                boolean mrgd = false;
                for (ClusterPoisson newCp : newClusterPoissons) {
                    if (!(Math.abs((newCp.getGenomeAbundance() - oldCp.getGenomeAbundance()) / newCp.getGenomeAbundance()) < 0.01)) continue;
                    newClusterPoissons.remove(newCp);
                    ClusterPoisson merged = VectorUtils.merge(newCp, oldCp);
                    newClusterPoissons.add(merged);
                    mrgd = true;
                    break;
                }
                if (mrgd) continue;
                newClusterPoissons.add(oldCp);
                continue;
            }
            newClusterPoissons.add(oldCp);
        }
        ClusterPoisson[] ret = new ClusterPoisson[newClusterPoissons.size()];
        int i = 0;
        for (ClusterPoisson cp : newClusterPoissons) {
            ret[i++] = cp;
        }
        return ret;
    }

    private static ClusterPoisson merge(ClusterPoisson a, ClusterPoisson b) {
        return new ClusterPoisson(a.getGenomeAbundance() > b.getGenomeAbundance() ? a.getGenomeAbundance() : b.getGenomeAbundance(), a.getGenomeLength() > b.getGenomeLength() ? a.getGenomeLength() : b.getGenomeLength());
    }
}

