/*
 * Decompiled with CFR 0.152.
 */
package fr.cea.ig.metatarget.datastructures;

import fr.cea.ig.metatarget.datastructures.ClusterPoisson;
import fr.cea.ig.metatarget.datastructures.Dictionary;
import fr.cea.ig.metatarget.utils.Utils;
import gnu.trove.iterator.TIntLongIterator;
import gnu.trove.map.hash.TIntLongHashMap;
import java.util.concurrent.CountDownLatch;

public class EMsync {
    private static final int maxRuns = 25;
    private static final double CONVERGE_THRESHOLD = 1.0E-5;
    private int numberOfClusters;
    private final TIntLongHashMap countsHisto;
    private final int excludeMin;
    private final int excludeMax;
    private int kmerHighestCount;
    private double kmerThreshold = 0.5;
    private double readThreshold = 0.5;
    private double[] clusterSizes;
    private double[] clusterAbundances;
    private double[] currAbundances;
    private double[] currClassSize;
    private double[] prevClassSize;
    private double[] prevClassAbundance;
    private double[][] countPoissonClass;

    public double[] getClusterAbundances() {
        return this.clusterAbundances;
    }

    public double[] getClusterSizes() {
        return this.clusterSizes;
    }

    public EMsync(int numberOfClusters, int excludeMin, int excludeMax, Dictionary dictionary) {
        this.numberOfClusters = numberOfClusters;
        this.countsHisto = dictionary.getCountsHisto();
        this.excludeMin = excludeMin;
        this.excludeMax = excludeMax;
        this.kmerHighestCount = dictionary.getMaxCount();
        if (excludeMax != 0 && this.kmerHighestCount > excludeMax) {
            this.kmerHighestCount = excludeMax;
        }
        this.kmerThreshold = 1.0 / (double)numberOfClusters;
        this.clusterSizes = new double[numberOfClusters];
        this.clusterAbundances = new double[numberOfClusters];
        this.currAbundances = new double[numberOfClusters];
        this.currClassSize = new double[numberOfClusters];
        this.prevClassSize = new double[numberOfClusters];
        this.prevClassAbundance = new double[numberOfClusters];
        int j = 10 * (numberOfClusters - 1);
        for (int i = 0; i < numberOfClusters; ++i) {
            this.clusterAbundances[i] = j;
            this.prevClassAbundance[i] = this.clusterAbundances[i];
            if ((j -= 10) == 0) {
                j = 1;
            }
            this.clusterSizes[i] = 1.0;
            this.prevClassSize[i] = this.clusterSizes[i];
        }
        this.countPoissonClass = new double[this.kmerHighestCount + 1][numberOfClusters];
    }

    private double safeDivideWith(double div) {
        return div == 0.0 ? 1.0 : div;
    }

    public void performEM() {
        try {
            CountDownLatch doneSignal = new CountDownLatch(1);
            Thread t = new Thread(new EMThread(doneSignal));
            t.start();
            doneSignal.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private class EMThread
    implements Runnable {
        private CountDownLatch doneSignal;

        private EMThread(CountDownLatch doneSignal) {
            this.doneSignal = doneSignal;
        }

        @Override
        public void run() {
            int convflag;
            boolean zeroflag;
            int k = 0;
            do {
                int i;
                System.out.println("\tRun=" + ++k);
                for (i = 0; i < EMsync.this.numberOfClusters; ++i) {
                    ((EMsync)EMsync.this).currAbundances[i] = EMsync.this.clusterAbundances[i];
                    ((EMsync)EMsync.this).currClassSize[i] = EMsync.this.clusterSizes[i];
                }
                for (int cnt = 1; cnt <= EMsync.this.kmerHighestCount; ++cnt) {
                    if (cnt < EMsync.this.excludeMin || EMsync.this.excludeMax != 0 && cnt > EMsync.this.excludeMax) continue;
                    for (i = 0; i < EMsync.this.numberOfClusters; ++i) {
                        ((EMsync)EMsync.this).countPoissonClass[cnt][i] = 0.0;
                        for (int j = 0; j < EMsync.this.numberOfClusters; ++j) {
                            double lnSum = ClusterPoisson.lnPoissonProbabilitySum(EMsync.this.currAbundances[j], EMsync.this.currAbundances[i], cnt, EMsync.this.currClassSize[j]);
                            double tempSum = Math.exp(lnSum);
                            if (Double.isInfinite(tempSum)) {
                                ((EMsync)EMsync.this).countPoissonClass[cnt][i] = Double.POSITIVE_INFINITY;
                                break;
                            }
                            double[] dArray = EMsync.this.countPoissonClass[cnt];
                            int n = i;
                            dArray[n] = dArray[n] + tempSum;
                        }
                        ((EMsync)EMsync.this).countPoissonClass[cnt][i] = EMsync.this.currClassSize[i] / EMsync.this.countPoissonClass[cnt][i];
                    }
                }
                for (i = 0; i < EMsync.this.numberOfClusters; ++i) {
                    ((EMsync)EMsync.this).prevClassSize[i] = EMsync.this.clusterSizes[i];
                    ((EMsync)EMsync.this).clusterSizes[i] = 0.0;
                    ((EMsync)EMsync.this).prevClassAbundance[i] = EMsync.this.clusterAbundances[i];
                    ((EMsync)EMsync.this).clusterAbundances[i] = 0.0;
                }
                TIntLongIterator it = EMsync.this.countsHisto.iterator();
                while (it.hasNext()) {
                    it.advance();
                    int count = it.key();
                    long countAbundance = it.value();
                    if (count < EMsync.this.excludeMin || EMsync.this.excludeMax != 0 && count > EMsync.this.excludeMax) continue;
                    for (i = 0; i < EMsync.this.numberOfClusters; ++i) {
                        double[] dArray = EMsync.this.clusterSizes;
                        int n = i;
                        dArray[n] = dArray[n] + (double)countAbundance * EMsync.this.countPoissonClass[count][i];
                        double[] dArray2 = EMsync.this.clusterAbundances;
                        int n2 = i;
                        dArray2[n2] = dArray2[n2] + (double)countAbundance * (EMsync.this.countPoissonClass[count][i] * (double)count);
                    }
                }
                for (i = 0; i < EMsync.this.numberOfClusters; ++i) {
                    double[] dArray = EMsync.this.clusterAbundances;
                    int n = i;
                    dArray[n] = dArray[n] / EMsync.this.safeDivideWith(EMsync.this.clusterSizes[i]);
                }
                zeroflag = false;
                convflag = 0;
                for (i = 0; i < EMsync.this.numberOfClusters; ++i) {
                    if (EMsync.this.clusterAbundances[i] == 0.0 || EMsync.this.clusterSizes[i] == 0.0) {
                        zeroflag = true;
                        continue;
                    }
                    double fTemp = (EMsync.this.clusterAbundances[i] - EMsync.this.prevClassAbundance[i]) / EMsync.this.safeDivideWith(EMsync.this.prevClassAbundance[i]);
                    if (fTemp < 0.0) {
                        fTemp *= -1.0;
                    }
                    if (fTemp < 1.0E-5) {
                        ++convflag;
                    }
                    if ((fTemp = (EMsync.this.clusterSizes[i] - EMsync.this.prevClassSize[i]) / EMsync.this.safeDivideWith(EMsync.this.prevClassSize[i])) < 0.0) {
                        fTemp *= -1.0;
                    }
                    if (!(fTemp < 1.0E-5)) continue;
                    ++convflag;
                }
            } while (!zeroflag && convflag != 2 * EMsync.this.numberOfClusters && k < 25);
            System.out.println(Utils.time() + "\tRuns=" + k);
            this.doneSignal.countDown();
        }
    }
}

