## ----setup, include=FALSE-----------------------------------------------------
knitr::opts_chunk$set(echo = TRUE)

## ----installation, eval = FALSE-----------------------------------------------
# if (!require("BiocManager"))
#     install.packages("BiocManager")
# BiocManager::install("ggtreeSpace")

## ----library, message=FALSE, warning=FALSE------------------------------------
library(ggtree)
library(ggtreeSpace)
library(phytools)
library(ggplot2)
library(dplyr)

## ----example0-----------------------------------------------------------------
tr <- rtree(15)
td <- fastBM(tr, nsim = 2)

tda1 <- fastAnc(tr, td[, 1])
tda2 <- fastAnc(tr, td[, 2])
tda <- cbind(tda1, tda2)
tdn <- rbind(td, tda)


trd <- fortify(tr)
trd <- trd |>
        select(-c("x", "y")) |>
        mutate(
            x = tdn[, 1],
            y = tdn[, 2])

p <- ggtree(tr = trd,
            layout = "unrooted") +
        theme_bw()

p

## ----example1-----------------------------------------------------------------
ggtreespace(tr, td) +
    geom_tippoint()

## ----example2-----------------------------------------------------------------
tr1 <- rtree(15)
td1 <- fastBM(tr1, nsim = 2)
ggplot() +
    geom_treespace(tr1, td1)

## ----example3-----------------------------------------------------------------
tr <- rtree(15)
td <- fastBM(tr, nsim = 2, bounds = c(0, Inf))
col <- colorRampPalette(c(
    "#FFFFCC", "#FFEDA0", "#FED976", "#FEB24C",
    "#FD8D3C", "#FC4E2A", "#E31A1C", "#B10026"
))(24)
tdex <- data.frame(
    z = fastBM(tr, nsim = 1, bounds = c(0, Inf)),
    node = 1:15
)
p <- ggtreespace(tr, td)
p %<+% tdex +
    geom_tippoint() +
    geom_tsheatmap(
        trait = "z", alpha = 0.7,
        resolution = 0.01, bin = 24
    ) +
    scale_fill_manual(
        values = col,
        guide = guide_colorsteps(show.limits = TRUE)
    ) +
    theme_treespace2() +
    theme(
        legend.key.height = unit(1, "null"),
        legend.justification.top = "right"
    )

## ----echo=FALSE---------------------------------------------------------------
sessionInfo()

