/*
 * Decompiled with CFR 0.152.
 */
package com.gkano.bioinfo.javautils;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.MissingCommandException;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.gkano.bioinfo.javautils.UtilDIST2Clusters;
import com.gkano.bioinfo.javautils.UtilDIST2TREE;
import com.gkano.bioinfo.javautils.UtilFASTA2DIST;
import com.gkano.bioinfo.javautils.UtilVCF2DIST;
import com.gkano.bioinfo.javautils.UtilVCF2ISTATS;
import com.gkano.bioinfo.javautils.UtilVCF2TREE;
import com.gkano.bioinfo.javautils.VersionInfo;
import com.gkano.bioinfo.var.Logger;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class JavaUtils {
    @Parameter(names={"--version"})
    private boolean version;
    @Parameter(names={"--usage", "--help"})
    private boolean usage;

    public void go(String[] args) {
        JCommander jc = JCommander.newBuilder().addObject(this).addCommand(UtilVCF2DIST.getUtilName(), new UtilVCF2DIST(), new String[0]).addCommand(UtilVCF2TREE.getUtilName(), new UtilVCF2TREE(), new String[0]).addCommand(UtilDIST2TREE.getUtilName(), new UtilDIST2TREE(), new String[0]).addCommand(UtilDIST2Clusters.getUtilName(), new UtilDIST2Clusters(), new String[0]).addCommand(UtilFASTA2DIST.getUtilName(), new UtilFASTA2DIST(), new String[0]).addCommand(UtilVCF2ISTATS.getUtilName(), new UtilVCF2ISTATS(), new String[0]).build();
        try {
            jc.parse(args);
            String command = jc.getParsedCommand();
            JCommander jCommand = jc.getCommands().get(command);
            if (this.version) {
                System.out.println(this.getClass().getName() + (String)(command == null ? "" : " " + command));
                System.out.println("Version: " + VersionInfo.VERSION);
                System.out.println("Build Time: " + VersionInfo.BUILD_TIME);
                return;
            }
            if (this.usage) {
                System.out.println(this.getClass().getName());
                jc.usage();
                return;
            }
            Class<?> utilClass = Class.forName(JavaUtils.class.getPackage().getName() + ".Util" + command);
            Method goMethod = utilClass.getMethod("go", new Class[0]);
            Object util = jCommand.getObjects().get(0);
            Field f = utilClass.getDeclaredField("help");
            f.setAccessible(true);
            boolean help = f.getBoolean(util);
            if (help) {
                jCommand.usage();
                return;
            }
            System.err.println(command);
            System.err.println("Version: " + VersionInfo.VERSION);
            System.err.println("Build Time: " + VersionInfo.BUILD_TIME);
            goMethod.invoke(util, new Object[0]);
        }
        catch (MissingCommandException | ClassNotFoundException e) {
            Logger.warn(this, "Invalid JavaUtil selection!");
            Logger.warn(this, "Use one of: " + String.valueOf(jc.getCommands().keySet()));
        }
        catch (ParameterException | IllegalAccessException | IllegalArgumentException | NoSuchFieldException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            Logger.error(this, e.getMessage());
        }
    }

    public static void main(String[] args) {
        JavaUtils ju = new JavaUtils();
        ju.go(args);
    }
}

