(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory() :
    typeof define === 'function' && define.amd ? define(factory) :
    (global = typeof globalThis !== 'undefined' ? globalThis : global || self, global.igv = factory());
})(this, (function () { 'use strict';

    /*!
     * jQuery JavaScript Library v3.3.1 -ajax,-ajax/jsonp,-ajax/load,-ajax/parseXML,-ajax/script,-ajax/var/location,-ajax/var/nonce,-ajax/var/rquery,-ajax/xhr,-manipulation/_evalUrl,-event/ajax,-effects,-effects/Tween,-effects/animatedSelector
     * https://jquery.com/
     *
     * Includes Sizzle.js
     * https://sizzlejs.com/
     *
     * Copyright JS Foundation and other contributors
     * Released under the MIT license
     * https://jquery.org/license
     *
     * Date: 2018-01-20T17:24Z
     */

    var arr = [];
    var document$2 = window.document;
    var getProto = Object.getPrototypeOf;
    var slice = arr.slice;
    var concat$1 = arr.concat;
    var push$1 = arr.push;
    var indexOf$1 = arr.indexOf;
    var class2type = {};
    var toString$3 = class2type.toString;
    var hasOwn = class2type.hasOwnProperty;
    var fnToString = hasOwn.toString;
    var ObjectFunctionString = fnToString.call(Object);
    var support = {};

    var isFunction = function isFunction(obj) {
      // Support: Chrome <=57, Firefox <=52
      // In some browsers, typeof returns "function" for HTML <object> elements
      // (i.e., `typeof document.createElement( "object" ) === "function"`).
      // We don't want to classify *any* DOM node as a function.
      return typeof obj === "function" && typeof obj.nodeType !== "number";
    };

    var isWindow = function isWindow(obj) {
      return obj != null && obj === obj.window;
    };

    var preservedScriptAttributes = {
      type: true,
      src: true,
      noModule: true
    };

    function DOMEval(code, doc, node) {
      doc = doc || document$2;
      var i,
          script = doc.createElement("script");
      script.text = code;

      if (node) {
        for (i in preservedScriptAttributes) {
          if (node[i]) {
            script[i] = node[i];
          }
        }
      }

      doc.head.appendChild(script).parentNode.removeChild(script);
    }

    function toType(obj) {
      if (obj == null) {
        return obj + "";
      } // Support: Android <=2.3 only (functionish RegExp)


      return typeof obj === "object" || typeof obj === "function" ? class2type[toString$3.call(obj)] || "object" : typeof obj;
    } // global Symbol
    // Defining this global in .eslintrc.json would create a danger of using the global
    // unguarded in another place, it seems safer to define global only for this module


    var version$2 = "3.3.1 -ajax,-ajax/jsonp,-ajax/load,-ajax/parseXML,-ajax/script,-ajax/var/location,-ajax/var/nonce,-ajax/var/rquery,-ajax/xhr,-manipulation/_evalUrl,-event/ajax,-effects,-effects/Tween,-effects/animatedSelector",
        // Define a local copy of jQuery
    jQuery = function (selector, context) {
      // The jQuery object is actually just the init constructor 'enhanced'
      // Need init if jQuery is called (just allow error to be thrown if not included)
      return new jQuery.fn.init(selector, context);
    },
        // Support: Android <=4.0 only
    // Make sure we trim BOM and NBSP
    rtrim = /^[\s\uFEFF\xA0]+|[\s\uFEFF\xA0]+$/g;

    jQuery.fn = jQuery.prototype = {
      // The current version of jQuery being used
      jquery: version$2,
      constructor: jQuery,
      // The default length of a jQuery object is 0
      length: 0,
      toArray: function () {
        return slice.call(this);
      },
      // Get the Nth element in the matched element set OR
      // Get the whole matched element set as a clean array
      get: function (num) {
        // Return all the elements in a clean array
        if (num == null) {
          return slice.call(this);
        } // Return just the one element from the set


        return num < 0 ? this[num + this.length] : this[num];
      },
      // Take an array of elements and push it onto the stack
      // (returning the new matched element set)
      pushStack: function (elems) {
        // Build a new jQuery matched element set
        var ret = jQuery.merge(this.constructor(), elems); // Add the old object onto the stack (as a reference)

        ret.prevObject = this; // Return the newly-formed element set

        return ret;
      },
      // Execute a callback for every element in the matched set.
      each: function (callback) {
        return jQuery.each(this, callback);
      },
      map: function (callback) {
        return this.pushStack(jQuery.map(this, function (elem, i) {
          return callback.call(elem, i, elem);
        }));
      },
      slice: function () {
        return this.pushStack(slice.apply(this, arguments));
      },
      first: function () {
        return this.eq(0);
      },
      last: function () {
        return this.eq(-1);
      },
      eq: function (i) {
        var len = this.length,
            j = +i + (i < 0 ? len : 0);
        return this.pushStack(j >= 0 && j < len ? [this[j]] : []);
      },
      end: function () {
        return this.prevObject || this.constructor();
      },
      // For internal use only.
      // Behaves like an Array's method, not like a jQuery method.
      push: push$1,
      sort: arr.sort,
      splice: arr.splice
    };

    jQuery.extend = jQuery.fn.extend = function () {
      var options,
          name,
          src,
          copy,
          copyIsArray,
          clone,
          target = arguments[0] || {},
          i = 1,
          length = arguments.length,
          deep = false; // Handle a deep copy situation

      if (typeof target === "boolean") {
        deep = target; // Skip the boolean and the target

        target = arguments[i] || {};
        i++;
      } // Handle case when target is a string or something (possible in deep copy)


      if (typeof target !== "object" && !isFunction(target)) {
        target = {};
      } // Extend jQuery itself if only one argument is passed


      if (i === length) {
        target = this;
        i--;
      }

      for (; i < length; i++) {
        // Only deal with non-null/undefined values
        if ((options = arguments[i]) != null) {
          // Extend the base object
          for (name in options) {
            src = target[name];
            copy = options[name]; // Prevent never-ending loop

            if (target === copy) {
              continue;
            } // Recurse if we're merging plain objects or arrays


            if (deep && copy && (jQuery.isPlainObject(copy) || (copyIsArray = Array.isArray(copy)))) {
              if (copyIsArray) {
                copyIsArray = false;
                clone = src && Array.isArray(src) ? src : [];
              } else {
                clone = src && jQuery.isPlainObject(src) ? src : {};
              } // Never move original objects, clone them


              target[name] = jQuery.extend(deep, clone, copy); // Don't bring in undefined values
            } else if (copy !== undefined) {
              target[name] = copy;
            }
          }
        }
      } // Return the modified object


      return target;
    };

    jQuery.extend({
      // Unique for each copy of jQuery on the page
      expando: "jQuery" + (version$2 + Math.random()).replace(/\D/g, ""),
      // Assume jQuery is ready without the ready module
      isReady: true,
      error: function (msg) {
        throw new Error(msg);
      },
      noop: function () {},
      isPlainObject: function (obj) {
        var proto, Ctor; // Detect obvious negatives
        // Use toString instead of jQuery.type to catch host objects

        if (!obj || toString$3.call(obj) !== "[object Object]") {
          return false;
        }

        proto = getProto(obj); // Objects with no prototype (e.g., `Object.create( null )`) are plain

        if (!proto) {
          return true;
        } // Objects with prototype are plain iff they were constructed by a global Object function


        Ctor = hasOwn.call(proto, "constructor") && proto.constructor;
        return typeof Ctor === "function" && fnToString.call(Ctor) === ObjectFunctionString;
      },
      isEmptyObject: function (obj) {
        /* eslint-disable no-unused-vars */
        // See https://github.com/eslint/eslint/issues/6125
        var name;

        for (name in obj) {
          return false;
        }

        return true;
      },
      // Evaluates a script in a global context
      globalEval: function (code) {
        DOMEval(code);
      },
      each: function (obj, callback) {
        var length,
            i = 0;

        if (isArrayLike(obj)) {
          length = obj.length;

          for (; i < length; i++) {
            if (callback.call(obj[i], i, obj[i]) === false) {
              break;
            }
          }
        } else {
          for (i in obj) {
            if (callback.call(obj[i], i, obj[i]) === false) {
              break;
            }
          }
        }

        return obj;
      },
      // Support: Android <=4.0 only
      trim: function (text) {
        return text == null ? "" : (text + "").replace(rtrim, "");
      },
      // results is for internal usage only
      makeArray: function (arr, results) {
        var ret = results || [];

        if (arr != null) {
          if (isArrayLike(Object(arr))) {
            jQuery.merge(ret, typeof arr === "string" ? [arr] : arr);
          } else {
            push$1.call(ret, arr);
          }
        }

        return ret;
      },
      inArray: function (elem, arr, i) {
        return arr == null ? -1 : indexOf$1.call(arr, elem, i);
      },
      // Support: Android <=4.0 only, PhantomJS 1 only
      // push.apply(_, arraylike) throws on ancient WebKit
      merge: function (first, second) {
        var len = +second.length,
            j = 0,
            i = first.length;

        for (; j < len; j++) {
          first[i++] = second[j];
        }

        first.length = i;
        return first;
      },
      grep: function (elems, callback, invert) {
        var callbackInverse,
            matches = [],
            i = 0,
            length = elems.length,
            callbackExpect = !invert; // Go through the array, only saving the items
        // that pass the validator function

        for (; i < length; i++) {
          callbackInverse = !callback(elems[i], i);

          if (callbackInverse !== callbackExpect) {
            matches.push(elems[i]);
          }
        }

        return matches;
      },
      // arg is for internal usage only
      map: function (elems, callback, arg) {
        var length,
            value,
            i = 0,
            ret = []; // Go through the array, translating each of the items to their new values

        if (isArrayLike(elems)) {
          length = elems.length;

          for (; i < length; i++) {
            value = callback(elems[i], i, arg);

            if (value != null) {
              ret.push(value);
            }
          } // Go through every key on the object,

        } else {
          for (i in elems) {
            value = callback(elems[i], i, arg);

            if (value != null) {
              ret.push(value);
            }
          }
        } // Flatten any nested arrays


        return concat$1.apply([], ret);
      },
      // A global GUID counter for objects
      guid: 1,
      // jQuery.support is not used in Core but other projects attach their
      // properties to it so it needs to exist.
      support: support
    });

    if (typeof Symbol === "function") {
      jQuery.fn[Symbol.iterator] = arr[Symbol.iterator];
    } // Populate the class2type map


    jQuery.each("Boolean Number String Function Array Date RegExp Object Error Symbol".split(" "), function (i, name) {
      class2type["[object " + name + "]"] = name.toLowerCase();
    });

    function isArrayLike(obj) {
      // Support: real iOS 8.2 only (not reproducible in simulator)
      // `in` check used to prevent JIT error (gh-2145)
      // hasOwn isn't used here due to false negatives
      // regarding Nodelist length in IE
      var length = !!obj && "length" in obj && obj.length,
          type = toType(obj);

      if (isFunction(obj) || isWindow(obj)) {
        return false;
      }

      return type === "array" || length === 0 || typeof length === "number" && length > 0 && length - 1 in obj;
    }

    var Sizzle =
    /*!
    * Sizzle CSS Selector Engine v2.3.3
    * https://sizzlejs.com/
    *
    * Copyright jQuery Foundation and other contributors
    * Released under the MIT license
    * http://jquery.org/license
    *
    * Date: 2016-08-08
    */
    function (window) {
      var i,
          support,
          Expr,
          getText,
          isXML,
          tokenize,
          compile,
          select,
          outermostContext,
          sortInput,
          hasDuplicate,
          // Local document vars
      setDocument,
          document,
          docElem,
          documentIsHTML,
          rbuggyQSA,
          rbuggyMatches,
          matches,
          contains,
          // Instance-specific data
      expando = "sizzle" + 1 * new Date(),
          preferredDoc = window.document,
          dirruns = 0,
          done = 0,
          classCache = createCache(),
          tokenCache = createCache(),
          compilerCache = createCache(),
          sortOrder = function (a, b) {
        if (a === b) {
          hasDuplicate = true;
        }

        return 0;
      },
          // Instance methods
      hasOwn = {}.hasOwnProperty,
          arr = [],
          pop = arr.pop,
          push_native = arr.push,
          push = arr.push,
          slice = arr.slice,
          // Use a stripped-down indexOf as it's faster than native
      // https://jsperf.com/thor-indexof-vs-for/5
      indexOf = function (list, elem) {
        var i = 0,
            len = list.length;

        for (; i < len; i++) {
          if (list[i] === elem) {
            return i;
          }
        }

        return -1;
      },
          booleans = "checked|selected|async|autofocus|autoplay|controls|defer|disabled|hidden|ismap|loop|multiple|open|readonly|required|scoped",
          // Regular expressions
      // http://www.w3.org/TR/css3-selectors/#whitespace
      whitespace = "[\\x20\\t\\r\\n\\f]",
          // http://www.w3.org/TR/CSS21/syndata.html#value-def-identifier
      identifier = "(?:\\\\.|[\\w-]|[^\0-\\xa0])+",
          // Attribute selectors: http://www.w3.org/TR/selectors/#attribute-selectors
      attributes = "\\[" + whitespace + "*(" + identifier + ")(?:" + whitespace + // Operator (capture 2)
      "*([*^$|!~]?=)" + whitespace + // "Attribute values must be CSS identifiers [capture 5] or strings [capture 3 or capture 4]"
      "*(?:'((?:\\\\.|[^\\\\'])*)'|\"((?:\\\\.|[^\\\\\"])*)\"|(" + identifier + "))|)" + whitespace + "*\\]",
          pseudos = ":(" + identifier + ")(?:\\((" + // To reduce the number of selectors needing tokenize in the preFilter, prefer arguments:
      // 1. quoted (capture 3; capture 4 or capture 5)
      "('((?:\\\\.|[^\\\\'])*)'|\"((?:\\\\.|[^\\\\\"])*)\")|" + // 2. simple (capture 6)
      "((?:\\\\.|[^\\\\()[\\]]|" + attributes + ")*)|" + // 3. anything else (capture 2)
      ".*" + ")\\)|)",
          // Leading and non-escaped trailing whitespace, capturing some non-whitespace characters preceding the latter
      rwhitespace = new RegExp(whitespace + "+", "g"),
          rtrim = new RegExp("^" + whitespace + "+|((?:^|[^\\\\])(?:\\\\.)*)" + whitespace + "+$", "g"),
          rcomma = new RegExp("^" + whitespace + "*," + whitespace + "*"),
          rcombinators = new RegExp("^" + whitespace + "*([>+~]|" + whitespace + ")" + whitespace + "*"),
          rattributeQuotes = new RegExp("=" + whitespace + "*([^\\]'\"]*?)" + whitespace + "*\\]", "g"),
          rpseudo = new RegExp(pseudos),
          ridentifier = new RegExp("^" + identifier + "$"),
          matchExpr = {
        "ID": new RegExp("^#(" + identifier + ")"),
        "CLASS": new RegExp("^\\.(" + identifier + ")"),
        "TAG": new RegExp("^(" + identifier + "|[*])"),
        "ATTR": new RegExp("^" + attributes),
        "PSEUDO": new RegExp("^" + pseudos),
        "CHILD": new RegExp("^:(only|first|last|nth|nth-last)-(child|of-type)(?:\\(" + whitespace + "*(even|odd|(([+-]|)(\\d*)n|)" + whitespace + "*(?:([+-]|)" + whitespace + "*(\\d+)|))" + whitespace + "*\\)|)", "i"),
        "bool": new RegExp("^(?:" + booleans + ")$", "i"),
        // For use in libraries implementing .is()
        // We use this for POS matching in `select`
        "needsContext": new RegExp("^" + whitespace + "*[>+~]|:(even|odd|eq|gt|lt|nth|first|last)(?:\\(" + whitespace + "*((?:-\\d)?\\d*)" + whitespace + "*\\)|)(?=[^-]|$)", "i")
      },
          rinputs = /^(?:input|select|textarea|button)$/i,
          rheader = /^h\d$/i,
          rnative = /^[^{]+\{\s*\[native \w/,
          // Easily-parseable/retrievable ID or TAG or CLASS selectors
      rquickExpr = /^(?:#([\w-]+)|(\w+)|\.([\w-]+))$/,
          rsibling = /[+~]/,
          // CSS escapes
      // http://www.w3.org/TR/CSS21/syndata.html#escaped-characters
      runescape = new RegExp("\\\\([\\da-f]{1,6}" + whitespace + "?|(" + whitespace + ")|.)", "ig"),
          funescape = function (_, escaped, escapedWhitespace) {
        var high = "0x" + escaped - 0x10000; // NaN means non-codepoint
        // Support: Firefox<24
        // Workaround erroneous numeric interpretation of +"0x"

        return high !== high || escapedWhitespace ? escaped : high < 0 ? // BMP codepoint
        String.fromCharCode(high + 0x10000) : // Supplemental Plane codepoint (surrogate pair)
        String.fromCharCode(high >> 10 | 0xD800, high & 0x3FF | 0xDC00);
      },
          // CSS string/identifier serialization
      // https://drafts.csswg.org/cssom/#common-serializing-idioms
      // eslint-disable-next-line no-control-regex
      rcssescape = /([\0-\x1f\x7f]|^-?\d)|^-$|[^\0-\x1f\x7f-\uFFFF\w-]/g,
          fcssescape = function (ch, asCodePoint) {
        if (asCodePoint) {
          // U+0000 NULL becomes U+FFFD REPLACEMENT CHARACTER
          if (ch === "\0") {
            return "\uFFFD";
          } // Control characters and (dependent upon position) numbers get escaped as code points


          return ch.slice(0, -1) + "\\" + ch.charCodeAt(ch.length - 1).toString(16) + " ";
        } // Other potentially-special ASCII characters get backslash-escaped


        return "\\" + ch;
      },
          // Used for iframes
      // See setDocument()
      // Removing the function wrapper causes a "Permission Denied"
      // error in IE
      unloadHandler = function () {
        setDocument();
      },
          disabledAncestor = addCombinator(function (elem) {
        return elem.disabled === true && ("form" in elem || "label" in elem);
      }, {
        dir: "parentNode",
        next: "legend"
      }); // Optimize for push.apply( _, NodeList )


      try {
        push.apply(arr = slice.call(preferredDoc.childNodes), preferredDoc.childNodes); // Support: Android<4.0
        // Detect silently failing push.apply

        arr[preferredDoc.childNodes.length].nodeType;
      } catch (e) {
        push = {
          apply: arr.length ? // Leverage slice if possible
          function (target, els) {
            push_native.apply(target, slice.call(els));
          } : // Support: IE<9
          // Otherwise append directly
          function (target, els) {
            var j = target.length,
                i = 0; // Can't trust NodeList.length

            while (target[j++] = els[i++]) {}

            target.length = j - 1;
          }
        };
      }

      function Sizzle(selector, context, results, seed) {
        var m,
            i,
            elem,
            nid,
            match,
            groups,
            newSelector,
            newContext = context && context.ownerDocument,
            // nodeType defaults to 9, since context defaults to document
        nodeType = context ? context.nodeType : 9;
        results = results || []; // Return early from calls with invalid selector or context

        if (typeof selector !== "string" || !selector || nodeType !== 1 && nodeType !== 9 && nodeType !== 11) {
          return results;
        } // Try to shortcut find operations (as opposed to filters) in HTML documents


        if (!seed) {
          if ((context ? context.ownerDocument || context : preferredDoc) !== document) {
            setDocument(context);
          }

          context = context || document;

          if (documentIsHTML) {
            // If the selector is sufficiently simple, try using a "get*By*" DOM method
            // (excepting DocumentFragment context, where the methods don't exist)
            if (nodeType !== 11 && (match = rquickExpr.exec(selector))) {
              // ID selector
              if (m = match[1]) {
                // Document context
                if (nodeType === 9) {
                  if (elem = context.getElementById(m)) {
                    // Support: IE, Opera, Webkit
                    // TODO: identify versions
                    // getElementById can match elements by name instead of ID
                    if (elem.id === m) {
                      results.push(elem);
                      return results;
                    }
                  } else {
                    return results;
                  } // Element context

                } else {
                  // Support: IE, Opera, Webkit
                  // TODO: identify versions
                  // getElementById can match elements by name instead of ID
                  if (newContext && (elem = newContext.getElementById(m)) && contains(context, elem) && elem.id === m) {
                    results.push(elem);
                    return results;
                  }
                } // Type selector

              } else if (match[2]) {
                push.apply(results, context.getElementsByTagName(selector));
                return results; // Class selector
              } else if ((m = match[3]) && support.getElementsByClassName && context.getElementsByClassName) {
                push.apply(results, context.getElementsByClassName(m));
                return results;
              }
            } // Take advantage of querySelectorAll


            if (support.qsa && !compilerCache[selector + " "] && (!rbuggyQSA || !rbuggyQSA.test(selector))) {
              if (nodeType !== 1) {
                newContext = context;
                newSelector = selector; // qSA looks outside Element context, which is not what we want
                // Thanks to Andrew Dupont for this workaround technique
                // Support: IE <=8
                // Exclude object elements
              } else if (context.nodeName.toLowerCase() !== "object") {
                // Capture the context ID, setting it first if necessary
                if (nid = context.getAttribute("id")) {
                  nid = nid.replace(rcssescape, fcssescape);
                } else {
                  context.setAttribute("id", nid = expando);
                } // Prefix every selector in the list


                groups = tokenize(selector);
                i = groups.length;

                while (i--) {
                  groups[i] = "#" + nid + " " + toSelector(groups[i]);
                }

                newSelector = groups.join(","); // Expand context for sibling selectors

                newContext = rsibling.test(selector) && testContext(context.parentNode) || context;
              }

              if (newSelector) {
                try {
                  push.apply(results, newContext.querySelectorAll(newSelector));
                  return results;
                } catch (qsaError) {} finally {
                  if (nid === expando) {
                    context.removeAttribute("id");
                  }
                }
              }
            }
          }
        } // All others


        return select(selector.replace(rtrim, "$1"), context, results, seed);
      }
      /**
       * Create key-value caches of limited size
       * @returns {function(string, object)} Returns the Object data after storing it on itself with
       *    property name the (space-suffixed) string and (if the cache is larger than Expr.cacheLength)
       *    deleting the oldest entry
       */


      function createCache() {
        var keys = [];

        function cache(key, value) {
          // Use (key + " ") to avoid collision with native prototype properties (see Issue #157)
          if (keys.push(key + " ") > Expr.cacheLength) {
            // Only keep the most recent entries
            delete cache[keys.shift()];
          }

          return cache[key + " "] = value;
        }

        return cache;
      }
      /**
       * Mark a function for special use by Sizzle
       * @param {Function} fn The function to mark
       */


      function markFunction(fn) {
        fn[expando] = true;
        return fn;
      }
      /**
       * Support testing using an element
       * @param {Function} fn Passed the created element and returns a boolean result
       */


      function assert(fn) {
        var el = document.createElement("fieldset");

        try {
          return !!fn(el);
        } catch (e) {
          return false;
        } finally {
          // Remove from its parent by default
          if (el.parentNode) {
            el.parentNode.removeChild(el);
          } // release memory in IE


          el = null;
        }
      }
      /**
       * Checks document order of two siblings
       * @param {Element} a
       * @param {Element} b
       * @returns {Number} Returns less than 0 if a precedes b, greater than 0 if a follows b
       */


      function siblingCheck(a, b) {
        var cur = b && a,
            diff = cur && a.nodeType === 1 && b.nodeType === 1 && a.sourceIndex - b.sourceIndex; // Use IE sourceIndex if available on both nodes

        if (diff) {
          return diff;
        } // Check if b follows a


        if (cur) {
          while (cur = cur.nextSibling) {
            if (cur === b) {
              return -1;
            }
          }
        }

        return a ? 1 : -1;
      }
      /**
       * Returns a function to use in pseudos for input types
       * @param {String} type
       */


      function createInputPseudo(type) {
        return function (elem) {
          var name = elem.nodeName.toLowerCase();
          return name === "input" && elem.type === type;
        };
      }
      /**
       * Returns a function to use in pseudos for buttons
       * @param {String} type
       */


      function createButtonPseudo(type) {
        return function (elem) {
          var name = elem.nodeName.toLowerCase();
          return (name === "input" || name === "button") && elem.type === type;
        };
      }
      /**
       * Returns a function to use in pseudos for :enabled/:disabled
       * @param {Boolean} disabled true for :disabled; false for :enabled
       */


      function createDisabledPseudo(disabled) {
        // Known :disabled false positives: fieldset[disabled] > legend:nth-of-type(n+2) :can-disable
        return function (elem) {
          // Only certain elements can match :enabled or :disabled
          // https://html.spec.whatwg.org/multipage/scripting.html#selector-enabled
          // https://html.spec.whatwg.org/multipage/scripting.html#selector-disabled
          if ("form" in elem) {
            // Check for inherited disabledness on relevant non-disabled elements:
            // * listed form-associated elements in a disabled fieldset
            //   https://html.spec.whatwg.org/multipage/forms.html#category-listed
            //   https://html.spec.whatwg.org/multipage/forms.html#concept-fe-disabled
            // * option elements in a disabled optgroup
            //   https://html.spec.whatwg.org/multipage/forms.html#concept-option-disabled
            // All such elements have a "form" property.
            if (elem.parentNode && elem.disabled === false) {
              // Option elements defer to a parent optgroup if present
              if ("label" in elem) {
                if ("label" in elem.parentNode) {
                  return elem.parentNode.disabled === disabled;
                } else {
                  return elem.disabled === disabled;
                }
              } // Support: IE 6 - 11
              // Use the isDisabled shortcut property to check for disabled fieldset ancestors


              return elem.isDisabled === disabled || // Where there is no isDisabled, check manually

              /* jshint -W018 */
              elem.isDisabled !== !disabled && disabledAncestor(elem) === disabled;
            }

            return elem.disabled === disabled; // Try to winnow out elements that can't be disabled before trusting the disabled property.
            // Some victims get caught in our net (label, legend, menu, track), but it shouldn't
            // even exist on them, let alone have a boolean value.
          } else if ("label" in elem) {
            return elem.disabled === disabled;
          } // Remaining elements are neither :enabled nor :disabled


          return false;
        };
      }
      /**
       * Returns a function to use in pseudos for positionals
       * @param {Function} fn
       */


      function createPositionalPseudo(fn) {
        return markFunction(function (argument) {
          argument = +argument;
          return markFunction(function (seed, matches) {
            var j,
                matchIndexes = fn([], seed.length, argument),
                i = matchIndexes.length; // Match elements found at the specified indexes

            while (i--) {
              if (seed[j = matchIndexes[i]]) {
                seed[j] = !(matches[j] = seed[j]);
              }
            }
          });
        });
      }
      /**
       * Checks a node for validity as a Sizzle context
       * @param {Element|Object=} context
       * @returns {Element|Object|Boolean} The input node if acceptable, otherwise a falsy value
       */


      function testContext(context) {
        return context && typeof context.getElementsByTagName !== "undefined" && context;
      } // Expose support vars for convenience


      support = Sizzle.support = {};
      /**
       * Detects XML nodes
       * @param {Element|Object} elem An element or a document
       * @returns {Boolean} True iff elem is a non-HTML XML node
       */

      isXML = Sizzle.isXML = function (elem) {
        // documentElement is verified for cases where it doesn't yet exist
        // (such as loading iframes in IE - #4833)
        var documentElement = elem && (elem.ownerDocument || elem).documentElement;
        return documentElement ? documentElement.nodeName !== "HTML" : false;
      };
      /**
       * Sets document-related variables once based on the current document
       * @param {Element|Object} [doc] An element or document object to use to set the document
       * @returns {Object} Returns the current document
       */


      setDocument = Sizzle.setDocument = function (node) {
        var hasCompare,
            subWindow,
            doc = node ? node.ownerDocument || node : preferredDoc; // Return early if doc is invalid or already selected

        if (doc === document || doc.nodeType !== 9 || !doc.documentElement) {
          return document;
        } // Update global variables


        document = doc;
        docElem = document.documentElement;
        documentIsHTML = !isXML(document); // Support: IE 9-11, Edge
        // Accessing iframe documents after unload throws "permission denied" errors (jQuery #13936)

        if (preferredDoc !== document && (subWindow = document.defaultView) && subWindow.top !== subWindow) {
          // Support: IE 11, Edge
          if (subWindow.addEventListener) {
            subWindow.addEventListener("unload", unloadHandler, false); // Support: IE 9 - 10 only
          } else if (subWindow.attachEvent) {
            subWindow.attachEvent("onunload", unloadHandler);
          }
        }
        /* Attributes
        ---------------------------------------------------------------------- */
        // Support: IE<8
        // Verify that getAttribute really returns attributes and not properties
        // (excepting IE8 booleans)


        support.attributes = assert(function (el) {
          el.className = "i";
          return !el.getAttribute("className");
        });
        /* getElement(s)By*
        ---------------------------------------------------------------------- */
        // Check if getElementsByTagName("*") returns only elements

        support.getElementsByTagName = assert(function (el) {
          el.appendChild(document.createComment(""));
          return !el.getElementsByTagName("*").length;
        }); // Support: IE<9

        support.getElementsByClassName = rnative.test(document.getElementsByClassName); // Support: IE<10
        // Check if getElementById returns elements by name
        // The broken getElementById methods don't pick up programmatically-set names,
        // so use a roundabout getElementsByName test

        support.getById = assert(function (el) {
          docElem.appendChild(el).id = expando;
          return !document.getElementsByName || !document.getElementsByName(expando).length;
        }); // ID filter and find

        if (support.getById) {
          Expr.filter["ID"] = function (id) {
            var attrId = id.replace(runescape, funescape);
            return function (elem) {
              return elem.getAttribute("id") === attrId;
            };
          };

          Expr.find["ID"] = function (id, context) {
            if (typeof context.getElementById !== "undefined" && documentIsHTML) {
              var elem = context.getElementById(id);
              return elem ? [elem] : [];
            }
          };
        } else {
          Expr.filter["ID"] = function (id) {
            var attrId = id.replace(runescape, funescape);
            return function (elem) {
              var node = typeof elem.getAttributeNode !== "undefined" && elem.getAttributeNode("id");
              return node && node.value === attrId;
            };
          }; // Support: IE 6 - 7 only
          // getElementById is not reliable as a find shortcut


          Expr.find["ID"] = function (id, context) {
            if (typeof context.getElementById !== "undefined" && documentIsHTML) {
              var node,
                  i,
                  elems,
                  elem = context.getElementById(id);

              if (elem) {
                // Verify the id attribute
                node = elem.getAttributeNode("id");

                if (node && node.value === id) {
                  return [elem];
                } // Fall back on getElementsByName


                elems = context.getElementsByName(id);
                i = 0;

                while (elem = elems[i++]) {
                  node = elem.getAttributeNode("id");

                  if (node && node.value === id) {
                    return [elem];
                  }
                }
              }

              return [];
            }
          };
        } // Tag


        Expr.find["TAG"] = support.getElementsByTagName ? function (tag, context) {
          if (typeof context.getElementsByTagName !== "undefined") {
            return context.getElementsByTagName(tag); // DocumentFragment nodes don't have gEBTN
          } else if (support.qsa) {
            return context.querySelectorAll(tag);
          }
        } : function (tag, context) {
          var elem,
              tmp = [],
              i = 0,
              // By happy coincidence, a (broken) gEBTN appears on DocumentFragment nodes too
          results = context.getElementsByTagName(tag); // Filter out possible comments

          if (tag === "*") {
            while (elem = results[i++]) {
              if (elem.nodeType === 1) {
                tmp.push(elem);
              }
            }

            return tmp;
          }

          return results;
        }; // Class

        Expr.find["CLASS"] = support.getElementsByClassName && function (className, context) {
          if (typeof context.getElementsByClassName !== "undefined" && documentIsHTML) {
            return context.getElementsByClassName(className);
          }
        };
        /* QSA/matchesSelector
        ---------------------------------------------------------------------- */
        // QSA and matchesSelector support
        // matchesSelector(:active) reports false when true (IE9/Opera 11.5)


        rbuggyMatches = []; // qSa(:focus) reports false when true (Chrome 21)
        // We allow this because of a bug in IE8/9 that throws an error
        // whenever `document.activeElement` is accessed on an iframe
        // So, we allow :focus to pass through QSA all the time to avoid the IE error
        // See https://bugs.jquery.com/ticket/13378

        rbuggyQSA = [];

        if (support.qsa = rnative.test(document.querySelectorAll)) {
          // Build QSA regex
          // Regex strategy adopted from Diego Perini
          assert(function (el) {
            // Select is set to empty string on purpose
            // This is to test IE's treatment of not explicitly
            // setting a boolean content attribute,
            // since its presence should be enough
            // https://bugs.jquery.com/ticket/12359
            docElem.appendChild(el).innerHTML = "<a id='" + expando + "'></a>" + "<select id='" + expando + "-\r\\' msallowcapture=''>" + "<option selected=''></option></select>"; // Support: IE8, Opera 11-12.16
            // Nothing should be selected when empty strings follow ^= or $= or *=
            // The test attribute must be unknown in Opera but "safe" for WinRT
            // https://msdn.microsoft.com/en-us/library/ie/hh465388.aspx#attribute_section

            if (el.querySelectorAll("[msallowcapture^='']").length) {
              rbuggyQSA.push("[*^$]=" + whitespace + "*(?:''|\"\")");
            } // Support: IE8
            // Boolean attributes and "value" are not treated correctly


            if (!el.querySelectorAll("[selected]").length) {
              rbuggyQSA.push("\\[" + whitespace + "*(?:value|" + booleans + ")");
            } // Support: Chrome<29, Android<4.4, Safari<7.0+, iOS<7.0+, PhantomJS<1.9.8+


            if (!el.querySelectorAll("[id~=" + expando + "-]").length) {
              rbuggyQSA.push("~=");
            } // Webkit/Opera - :checked should return selected option elements
            // http://www.w3.org/TR/2011/REC-css3-selectors-20110929/#checked
            // IE8 throws error here and will not see later tests


            if (!el.querySelectorAll(":checked").length) {
              rbuggyQSA.push(":checked");
            } // Support: Safari 8+, iOS 8+
            // https://bugs.webkit.org/show_bug.cgi?id=136851
            // In-page `selector#id sibling-combinator selector` fails


            if (!el.querySelectorAll("a#" + expando + "+*").length) {
              rbuggyQSA.push(".#.+[+~]");
            }
          });
          assert(function (el) {
            el.innerHTML = "<a href='' disabled='disabled'></a>" + "<select disabled='disabled'><option/></select>"; // Support: Windows 8 Native Apps
            // The type and name attributes are restricted during .innerHTML assignment

            var input = document.createElement("input");
            input.setAttribute("type", "hidden");
            el.appendChild(input).setAttribute("name", "D"); // Support: IE8
            // Enforce case-sensitivity of name attribute

            if (el.querySelectorAll("[name=d]").length) {
              rbuggyQSA.push("name" + whitespace + "*[*^$|!~]?=");
            } // FF 3.5 - :enabled/:disabled and hidden elements (hidden elements are still enabled)
            // IE8 throws error here and will not see later tests


            if (el.querySelectorAll(":enabled").length !== 2) {
              rbuggyQSA.push(":enabled", ":disabled");
            } // Support: IE9-11+
            // IE's :disabled selector does not pick up the children of disabled fieldsets


            docElem.appendChild(el).disabled = true;

            if (el.querySelectorAll(":disabled").length !== 2) {
              rbuggyQSA.push(":enabled", ":disabled");
            } // Opera 10-11 does not throw on post-comma invalid pseudos


            el.querySelectorAll("*,:x");
            rbuggyQSA.push(",.*:");
          });
        }

        if (support.matchesSelector = rnative.test(matches = docElem.matches || docElem.webkitMatchesSelector || docElem.mozMatchesSelector || docElem.oMatchesSelector || docElem.msMatchesSelector)) {
          assert(function (el) {
            // Check to see if it's possible to do matchesSelector
            // on a disconnected node (IE 9)
            support.disconnectedMatch = matches.call(el, "*"); // This should fail with an exception
            // Gecko does not error, returns false instead

            matches.call(el, "[s!='']:x");
            rbuggyMatches.push("!=", pseudos);
          });
        }

        rbuggyQSA = rbuggyQSA.length && new RegExp(rbuggyQSA.join("|"));
        rbuggyMatches = rbuggyMatches.length && new RegExp(rbuggyMatches.join("|"));
        /* Contains
        ---------------------------------------------------------------------- */

        hasCompare = rnative.test(docElem.compareDocumentPosition); // Element contains another
        // Purposefully self-exclusive
        // As in, an element does not contain itself

        contains = hasCompare || rnative.test(docElem.contains) ? function (a, b) {
          var adown = a.nodeType === 9 ? a.documentElement : a,
              bup = b && b.parentNode;
          return a === bup || !!(bup && bup.nodeType === 1 && (adown.contains ? adown.contains(bup) : a.compareDocumentPosition && a.compareDocumentPosition(bup) & 16));
        } : function (a, b) {
          if (b) {
            while (b = b.parentNode) {
              if (b === a) {
                return true;
              }
            }
          }

          return false;
        };
        /* Sorting
        ---------------------------------------------------------------------- */
        // Document order sorting

        sortOrder = hasCompare ? function (a, b) {
          // Flag for duplicate removal
          if (a === b) {
            hasDuplicate = true;
            return 0;
          } // Sort on method existence if only one input has compareDocumentPosition


          var compare = !a.compareDocumentPosition - !b.compareDocumentPosition;

          if (compare) {
            return compare;
          } // Calculate position if both inputs belong to the same document


          compare = (a.ownerDocument || a) === (b.ownerDocument || b) ? a.compareDocumentPosition(b) : // Otherwise we know they are disconnected
          1; // Disconnected nodes

          if (compare & 1 || !support.sortDetached && b.compareDocumentPosition(a) === compare) {
            // Choose the first element that is related to our preferred document
            if (a === document || a.ownerDocument === preferredDoc && contains(preferredDoc, a)) {
              return -1;
            }

            if (b === document || b.ownerDocument === preferredDoc && contains(preferredDoc, b)) {
              return 1;
            } // Maintain original order


            return sortInput ? indexOf(sortInput, a) - indexOf(sortInput, b) : 0;
          }

          return compare & 4 ? -1 : 1;
        } : function (a, b) {
          // Exit early if the nodes are identical
          if (a === b) {
            hasDuplicate = true;
            return 0;
          }

          var cur,
              i = 0,
              aup = a.parentNode,
              bup = b.parentNode,
              ap = [a],
              bp = [b]; // Parentless nodes are either documents or disconnected

          if (!aup || !bup) {
            return a === document ? -1 : b === document ? 1 : aup ? -1 : bup ? 1 : sortInput ? indexOf(sortInput, a) - indexOf(sortInput, b) : 0; // If the nodes are siblings, we can do a quick check
          } else if (aup === bup) {
            return siblingCheck(a, b);
          } // Otherwise we need full lists of their ancestors for comparison


          cur = a;

          while (cur = cur.parentNode) {
            ap.unshift(cur);
          }

          cur = b;

          while (cur = cur.parentNode) {
            bp.unshift(cur);
          } // Walk down the tree looking for a discrepancy


          while (ap[i] === bp[i]) {
            i++;
          }

          return i ? // Do a sibling check if the nodes have a common ancestor
          siblingCheck(ap[i], bp[i]) : // Otherwise nodes in our document sort first
          ap[i] === preferredDoc ? -1 : bp[i] === preferredDoc ? 1 : 0;
        };
        return document;
      };

      Sizzle.matches = function (expr, elements) {
        return Sizzle(expr, null, null, elements);
      };

      Sizzle.matchesSelector = function (elem, expr) {
        // Set document vars if needed
        if ((elem.ownerDocument || elem) !== document) {
          setDocument(elem);
        } // Make sure that attribute selectors are quoted


        expr = expr.replace(rattributeQuotes, "='$1']");

        if (support.matchesSelector && documentIsHTML && !compilerCache[expr + " "] && (!rbuggyMatches || !rbuggyMatches.test(expr)) && (!rbuggyQSA || !rbuggyQSA.test(expr))) {
          try {
            var ret = matches.call(elem, expr); // IE 9's matchesSelector returns false on disconnected nodes

            if (ret || support.disconnectedMatch || // As well, disconnected nodes are said to be in a document
            // fragment in IE 9
            elem.document && elem.document.nodeType !== 11) {
              return ret;
            }
          } catch (e) {}
        }

        return Sizzle(expr, document, null, [elem]).length > 0;
      };

      Sizzle.contains = function (context, elem) {
        // Set document vars if needed
        if ((context.ownerDocument || context) !== document) {
          setDocument(context);
        }

        return contains(context, elem);
      };

      Sizzle.attr = function (elem, name) {
        // Set document vars if needed
        if ((elem.ownerDocument || elem) !== document) {
          setDocument(elem);
        }

        var fn = Expr.attrHandle[name.toLowerCase()],
            // Don't get fooled by Object.prototype properties (jQuery #13807)
        val = fn && hasOwn.call(Expr.attrHandle, name.toLowerCase()) ? fn(elem, name, !documentIsHTML) : undefined;
        return val !== undefined ? val : support.attributes || !documentIsHTML ? elem.getAttribute(name) : (val = elem.getAttributeNode(name)) && val.specified ? val.value : null;
      };

      Sizzle.escape = function (sel) {
        return (sel + "").replace(rcssescape, fcssescape);
      };

      Sizzle.error = function (msg) {
        throw new Error("Syntax error, unrecognized expression: " + msg);
      };
      /**
       * Document sorting and removing duplicates
       * @param {ArrayLike} results
       */


      Sizzle.uniqueSort = function (results) {
        var elem,
            duplicates = [],
            j = 0,
            i = 0; // Unless we *know* we can detect duplicates, assume their presence

        hasDuplicate = !support.detectDuplicates;
        sortInput = !support.sortStable && results.slice(0);
        results.sort(sortOrder);

        if (hasDuplicate) {
          while (elem = results[i++]) {
            if (elem === results[i]) {
              j = duplicates.push(i);
            }
          }

          while (j--) {
            results.splice(duplicates[j], 1);
          }
        } // Clear input after sorting to release objects
        // See https://github.com/jquery/sizzle/pull/225


        sortInput = null;
        return results;
      };
      /**
       * Utility function for retrieving the text value of an array of DOM nodes
       * @param {Array|Element} elem
       */


      getText = Sizzle.getText = function (elem) {
        var node,
            ret = "",
            i = 0,
            nodeType = elem.nodeType;

        if (!nodeType) {
          // If no nodeType, this is expected to be an array
          while (node = elem[i++]) {
            // Do not traverse comment nodes
            ret += getText(node);
          }
        } else if (nodeType === 1 || nodeType === 9 || nodeType === 11) {
          // Use textContent for elements
          // innerText usage removed for consistency of new lines (jQuery #11153)
          if (typeof elem.textContent === "string") {
            return elem.textContent;
          } else {
            // Traverse its children
            for (elem = elem.firstChild; elem; elem = elem.nextSibling) {
              ret += getText(elem);
            }
          }
        } else if (nodeType === 3 || nodeType === 4) {
          return elem.nodeValue;
        } // Do not include comment or processing instruction nodes


        return ret;
      };

      Expr = Sizzle.selectors = {
        // Can be adjusted by the user
        cacheLength: 50,
        createPseudo: markFunction,
        match: matchExpr,
        attrHandle: {},
        find: {},
        relative: {
          ">": {
            dir: "parentNode",
            first: true
          },
          " ": {
            dir: "parentNode"
          },
          "+": {
            dir: "previousSibling",
            first: true
          },
          "~": {
            dir: "previousSibling"
          }
        },
        preFilter: {
          "ATTR": function (match) {
            match[1] = match[1].replace(runescape, funescape); // Move the given value to match[3] whether quoted or unquoted

            match[3] = (match[3] || match[4] || match[5] || "").replace(runescape, funescape);

            if (match[2] === "~=") {
              match[3] = " " + match[3] + " ";
            }

            return match.slice(0, 4);
          },
          "CHILD": function (match) {
            /* matches from matchExpr["CHILD"]
            1 type (only|nth|...)
            2 what (child|of-type)
            3 argument (even|odd|\d*|\d*n([+-]\d+)?|...)
            4 xn-component of xn+y argument ([+-]?\d*n|)
            5 sign of xn-component
            6 x of xn-component
            7 sign of y-component
            8 y of y-component
            */
            match[1] = match[1].toLowerCase();

            if (match[1].slice(0, 3) === "nth") {
              // nth-* requires argument
              if (!match[3]) {
                Sizzle.error(match[0]);
              } // numeric x and y parameters for Expr.filter.CHILD
              // remember that false/true cast respectively to 0/1


              match[4] = +(match[4] ? match[5] + (match[6] || 1) : 2 * (match[3] === "even" || match[3] === "odd"));
              match[5] = +(match[7] + match[8] || match[3] === "odd"); // other types prohibit arguments
            } else if (match[3]) {
              Sizzle.error(match[0]);
            }

            return match;
          },
          "PSEUDO": function (match) {
            var excess,
                unquoted = !match[6] && match[2];

            if (matchExpr["CHILD"].test(match[0])) {
              return null;
            } // Accept quoted arguments as-is


            if (match[3]) {
              match[2] = match[4] || match[5] || ""; // Strip excess characters from unquoted arguments
            } else if (unquoted && rpseudo.test(unquoted) && ( // Get excess from tokenize (recursively)
            excess = tokenize(unquoted, true)) && ( // advance to the next closing parenthesis
            excess = unquoted.indexOf(")", unquoted.length - excess) - unquoted.length)) {
              // excess is a negative index
              match[0] = match[0].slice(0, excess);
              match[2] = unquoted.slice(0, excess);
            } // Return only captures needed by the pseudo filter method (type and argument)


            return match.slice(0, 3);
          }
        },
        filter: {
          "TAG": function (nodeNameSelector) {
            var nodeName = nodeNameSelector.replace(runescape, funescape).toLowerCase();
            return nodeNameSelector === "*" ? function () {
              return true;
            } : function (elem) {
              return elem.nodeName && elem.nodeName.toLowerCase() === nodeName;
            };
          },
          "CLASS": function (className) {
            var pattern = classCache[className + " "];
            return pattern || (pattern = new RegExp("(^|" + whitespace + ")" + className + "(" + whitespace + "|$)")) && classCache(className, function (elem) {
              return pattern.test(typeof elem.className === "string" && elem.className || typeof elem.getAttribute !== "undefined" && elem.getAttribute("class") || "");
            });
          },
          "ATTR": function (name, operator, check) {
            return function (elem) {
              var result = Sizzle.attr(elem, name);

              if (result == null) {
                return operator === "!=";
              }

              if (!operator) {
                return true;
              }

              result += "";
              return operator === "=" ? result === check : operator === "!=" ? result !== check : operator === "^=" ? check && result.indexOf(check) === 0 : operator === "*=" ? check && result.indexOf(check) > -1 : operator === "$=" ? check && result.slice(-check.length) === check : operator === "~=" ? (" " + result.replace(rwhitespace, " ") + " ").indexOf(check) > -1 : operator === "|=" ? result === check || result.slice(0, check.length + 1) === check + "-" : false;
            };
          },
          "CHILD": function (type, what, argument, first, last) {
            var simple = type.slice(0, 3) !== "nth",
                forward = type.slice(-4) !== "last",
                ofType = what === "of-type";
            return first === 1 && last === 0 ? // Shortcut for :nth-*(n)
            function (elem) {
              return !!elem.parentNode;
            } : function (elem, context, xml) {
              var cache,
                  uniqueCache,
                  outerCache,
                  node,
                  nodeIndex,
                  start,
                  dir = simple !== forward ? "nextSibling" : "previousSibling",
                  parent = elem.parentNode,
                  name = ofType && elem.nodeName.toLowerCase(),
                  useCache = !xml && !ofType,
                  diff = false;

              if (parent) {
                // :(first|last|only)-(child|of-type)
                if (simple) {
                  while (dir) {
                    node = elem;

                    while (node = node[dir]) {
                      if (ofType ? node.nodeName.toLowerCase() === name : node.nodeType === 1) {
                        return false;
                      }
                    } // Reverse direction for :only-* (if we haven't yet done so)


                    start = dir = type === "only" && !start && "nextSibling";
                  }

                  return true;
                }

                start = [forward ? parent.firstChild : parent.lastChild]; // non-xml :nth-child(...) stores cache data on `parent`

                if (forward && useCache) {
                  // Seek `elem` from a previously-cached index
                  // ...in a gzip-friendly way
                  node = parent;
                  outerCache = node[expando] || (node[expando] = {}); // Support: IE <9 only
                  // Defend against cloned attroperties (jQuery gh-1709)

                  uniqueCache = outerCache[node.uniqueID] || (outerCache[node.uniqueID] = {});
                  cache = uniqueCache[type] || [];
                  nodeIndex = cache[0] === dirruns && cache[1];
                  diff = nodeIndex && cache[2];
                  node = nodeIndex && parent.childNodes[nodeIndex];

                  while (node = ++nodeIndex && node && node[dir] || ( // Fallback to seeking `elem` from the start
                  diff = nodeIndex = 0) || start.pop()) {
                    // When found, cache indexes on `parent` and break
                    if (node.nodeType === 1 && ++diff && node === elem) {
                      uniqueCache[type] = [dirruns, nodeIndex, diff];
                      break;
                    }
                  }
                } else {
                  // Use previously-cached element index if available
                  if (useCache) {
                    // ...in a gzip-friendly way
                    node = elem;
                    outerCache = node[expando] || (node[expando] = {}); // Support: IE <9 only
                    // Defend against cloned attroperties (jQuery gh-1709)

                    uniqueCache = outerCache[node.uniqueID] || (outerCache[node.uniqueID] = {});
                    cache = uniqueCache[type] || [];
                    nodeIndex = cache[0] === dirruns && cache[1];
                    diff = nodeIndex;
                  } // xml :nth-child(...)
                  // or :nth-last-child(...) or :nth(-last)?-of-type(...)


                  if (diff === false) {
                    // Use the same loop as above to seek `elem` from the start
                    while (node = ++nodeIndex && node && node[dir] || (diff = nodeIndex = 0) || start.pop()) {
                      if ((ofType ? node.nodeName.toLowerCase() === name : node.nodeType === 1) && ++diff) {
                        // Cache the index of each encountered element
                        if (useCache) {
                          outerCache = node[expando] || (node[expando] = {}); // Support: IE <9 only
                          // Defend against cloned attroperties (jQuery gh-1709)

                          uniqueCache = outerCache[node.uniqueID] || (outerCache[node.uniqueID] = {});
                          uniqueCache[type] = [dirruns, diff];
                        }

                        if (node === elem) {
                          break;
                        }
                      }
                    }
                  }
                } // Incorporate the offset, then check against cycle size


                diff -= last;
                return diff === first || diff % first === 0 && diff / first >= 0;
              }
            };
          },
          "PSEUDO": function (pseudo, argument) {
            // pseudo-class names are case-insensitive
            // http://www.w3.org/TR/selectors/#pseudo-classes
            // Prioritize by case sensitivity in case custom pseudos are added with uppercase letters
            // Remember that setFilters inherits from pseudos
            var args,
                fn = Expr.pseudos[pseudo] || Expr.setFilters[pseudo.toLowerCase()] || Sizzle.error("unsupported pseudo: " + pseudo); // The user may use createPseudo to indicate that
            // arguments are needed to create the filter function
            // just as Sizzle does

            if (fn[expando]) {
              return fn(argument);
            } // But maintain support for old signatures


            if (fn.length > 1) {
              args = [pseudo, pseudo, "", argument];
              return Expr.setFilters.hasOwnProperty(pseudo.toLowerCase()) ? markFunction(function (seed, matches) {
                var idx,
                    matched = fn(seed, argument),
                    i = matched.length;

                while (i--) {
                  idx = indexOf(seed, matched[i]);
                  seed[idx] = !(matches[idx] = matched[i]);
                }
              }) : function (elem) {
                return fn(elem, 0, args);
              };
            }

            return fn;
          }
        },
        pseudos: {
          // Potentially complex pseudos
          "not": markFunction(function (selector) {
            // Trim the selector passed to compile
            // to avoid treating leading and trailing
            // spaces as combinators
            var input = [],
                results = [],
                matcher = compile(selector.replace(rtrim, "$1"));
            return matcher[expando] ? markFunction(function (seed, matches, context, xml) {
              var elem,
                  unmatched = matcher(seed, null, xml, []),
                  i = seed.length; // Match elements unmatched by `matcher`

              while (i--) {
                if (elem = unmatched[i]) {
                  seed[i] = !(matches[i] = elem);
                }
              }
            }) : function (elem, context, xml) {
              input[0] = elem;
              matcher(input, null, xml, results); // Don't keep the element (issue #299)

              input[0] = null;
              return !results.pop();
            };
          }),
          "has": markFunction(function (selector) {
            return function (elem) {
              return Sizzle(selector, elem).length > 0;
            };
          }),
          "contains": markFunction(function (text) {
            text = text.replace(runescape, funescape);
            return function (elem) {
              return (elem.textContent || elem.innerText || getText(elem)).indexOf(text) > -1;
            };
          }),
          // "Whether an element is represented by a :lang() selector
          // is based solely on the element's language value
          // being equal to the identifier C,
          // or beginning with the identifier C immediately followed by "-".
          // The matching of C against the element's language value is performed case-insensitively.
          // The identifier C does not have to be a valid language name."
          // http://www.w3.org/TR/selectors/#lang-pseudo
          "lang": markFunction(function (lang) {
            // lang value must be a valid identifier
            if (!ridentifier.test(lang || "")) {
              Sizzle.error("unsupported lang: " + lang);
            }

            lang = lang.replace(runescape, funescape).toLowerCase();
            return function (elem) {
              var elemLang;

              do {
                if (elemLang = documentIsHTML ? elem.lang : elem.getAttribute("xml:lang") || elem.getAttribute("lang")) {
                  elemLang = elemLang.toLowerCase();
                  return elemLang === lang || elemLang.indexOf(lang + "-") === 0;
                }
              } while ((elem = elem.parentNode) && elem.nodeType === 1);

              return false;
            };
          }),
          // Miscellaneous
          "target": function (elem) {
            var hash = window.location && window.location.hash;
            return hash && hash.slice(1) === elem.id;
          },
          "root": function (elem) {
            return elem === docElem;
          },
          "focus": function (elem) {
            return elem === document.activeElement && (!document.hasFocus || document.hasFocus()) && !!(elem.type || elem.href || ~elem.tabIndex);
          },
          // Boolean properties
          "enabled": createDisabledPseudo(false),
          "disabled": createDisabledPseudo(true),
          "checked": function (elem) {
            // In CSS3, :checked should return both checked and selected elements
            // http://www.w3.org/TR/2011/REC-css3-selectors-20110929/#checked
            var nodeName = elem.nodeName.toLowerCase();
            return nodeName === "input" && !!elem.checked || nodeName === "option" && !!elem.selected;
          },
          "selected": function (elem) {
            // Accessing this property makes selected-by-default
            // options in Safari work properly
            if (elem.parentNode) {
              elem.parentNode.selectedIndex;
            }

            return elem.selected === true;
          },
          // Contents
          "empty": function (elem) {
            // http://www.w3.org/TR/selectors/#empty-pseudo
            // :empty is negated by element (1) or content nodes (text: 3; cdata: 4; entity ref: 5),
            //   but not by others (comment: 8; processing instruction: 7; etc.)
            // nodeType < 6 works because attributes (2) do not appear as children
            for (elem = elem.firstChild; elem; elem = elem.nextSibling) {
              if (elem.nodeType < 6) {
                return false;
              }
            }

            return true;
          },
          "parent": function (elem) {
            return !Expr.pseudos["empty"](elem);
          },
          // Element/input types
          "header": function (elem) {
            return rheader.test(elem.nodeName);
          },
          "input": function (elem) {
            return rinputs.test(elem.nodeName);
          },
          "button": function (elem) {
            var name = elem.nodeName.toLowerCase();
            return name === "input" && elem.type === "button" || name === "button";
          },
          "text": function (elem) {
            var attr;
            return elem.nodeName.toLowerCase() === "input" && elem.type === "text" && ( // Support: IE<8
            // New HTML5 attribute values (e.g., "search") appear with elem.type === "text"
            (attr = elem.getAttribute("type")) == null || attr.toLowerCase() === "text");
          },
          // Position-in-collection
          "first": createPositionalPseudo(function () {
            return [0];
          }),
          "last": createPositionalPseudo(function (matchIndexes, length) {
            return [length - 1];
          }),
          "eq": createPositionalPseudo(function (matchIndexes, length, argument) {
            return [argument < 0 ? argument + length : argument];
          }),
          "even": createPositionalPseudo(function (matchIndexes, length) {
            var i = 0;

            for (; i < length; i += 2) {
              matchIndexes.push(i);
            }

            return matchIndexes;
          }),
          "odd": createPositionalPseudo(function (matchIndexes, length) {
            var i = 1;

            for (; i < length; i += 2) {
              matchIndexes.push(i);
            }

            return matchIndexes;
          }),
          "lt": createPositionalPseudo(function (matchIndexes, length, argument) {
            var i = argument < 0 ? argument + length : argument;

            for (; --i >= 0;) {
              matchIndexes.push(i);
            }

            return matchIndexes;
          }),
          "gt": createPositionalPseudo(function (matchIndexes, length, argument) {
            var i = argument < 0 ? argument + length : argument;

            for (; ++i < length;) {
              matchIndexes.push(i);
            }

            return matchIndexes;
          })
        }
      };
      Expr.pseudos["nth"] = Expr.pseudos["eq"]; // Add button/input type pseudos

      for (i in {
        radio: true,
        checkbox: true,
        file: true,
        password: true,
        image: true
      }) {
        Expr.pseudos[i] = createInputPseudo(i);
      }

      for (i in {
        submit: true,
        reset: true
      }) {
        Expr.pseudos[i] = createButtonPseudo(i);
      } // Easy API for creating new setFilters


      function setFilters() {}

      setFilters.prototype = Expr.filters = Expr.pseudos;
      Expr.setFilters = new setFilters();

      tokenize = Sizzle.tokenize = function (selector, parseOnly) {
        var matched,
            match,
            tokens,
            type,
            soFar,
            groups,
            preFilters,
            cached = tokenCache[selector + " "];

        if (cached) {
          return parseOnly ? 0 : cached.slice(0);
        }

        soFar = selector;
        groups = [];
        preFilters = Expr.preFilter;

        while (soFar) {
          // Comma and first run
          if (!matched || (match = rcomma.exec(soFar))) {
            if (match) {
              // Don't consume trailing commas as valid
              soFar = soFar.slice(match[0].length) || soFar;
            }

            groups.push(tokens = []);
          }

          matched = false; // Combinators

          if (match = rcombinators.exec(soFar)) {
            matched = match.shift();
            tokens.push({
              value: matched,
              // Cast descendant combinators to space
              type: match[0].replace(rtrim, " ")
            });
            soFar = soFar.slice(matched.length);
          } // Filters


          for (type in Expr.filter) {
            if ((match = matchExpr[type].exec(soFar)) && (!preFilters[type] || (match = preFilters[type](match)))) {
              matched = match.shift();
              tokens.push({
                value: matched,
                type: type,
                matches: match
              });
              soFar = soFar.slice(matched.length);
            }
          }

          if (!matched) {
            break;
          }
        } // Return the length of the invalid excess
        // if we're just parsing
        // Otherwise, throw an error or return tokens


        return parseOnly ? soFar.length : soFar ? Sizzle.error(selector) : // Cache the tokens
        tokenCache(selector, groups).slice(0);
      };

      function toSelector(tokens) {
        var i = 0,
            len = tokens.length,
            selector = "";

        for (; i < len; i++) {
          selector += tokens[i].value;
        }

        return selector;
      }

      function addCombinator(matcher, combinator, base) {
        var dir = combinator.dir,
            skip = combinator.next,
            key = skip || dir,
            checkNonElements = base && key === "parentNode",
            doneName = done++;
        return combinator.first ? // Check against closest ancestor/preceding element
        function (elem, context, xml) {
          while (elem = elem[dir]) {
            if (elem.nodeType === 1 || checkNonElements) {
              return matcher(elem, context, xml);
            }
          }

          return false;
        } : // Check against all ancestor/preceding elements
        function (elem, context, xml) {
          var oldCache,
              uniqueCache,
              outerCache,
              newCache = [dirruns, doneName]; // We can't set arbitrary data on XML nodes, so they don't benefit from combinator caching

          if (xml) {
            while (elem = elem[dir]) {
              if (elem.nodeType === 1 || checkNonElements) {
                if (matcher(elem, context, xml)) {
                  return true;
                }
              }
            }
          } else {
            while (elem = elem[dir]) {
              if (elem.nodeType === 1 || checkNonElements) {
                outerCache = elem[expando] || (elem[expando] = {}); // Support: IE <9 only
                // Defend against cloned attroperties (jQuery gh-1709)

                uniqueCache = outerCache[elem.uniqueID] || (outerCache[elem.uniqueID] = {});

                if (skip && skip === elem.nodeName.toLowerCase()) {
                  elem = elem[dir] || elem;
                } else if ((oldCache = uniqueCache[key]) && oldCache[0] === dirruns && oldCache[1] === doneName) {
                  // Assign to newCache so results back-propagate to previous elements
                  return newCache[2] = oldCache[2];
                } else {
                  // Reuse newcache so results back-propagate to previous elements
                  uniqueCache[key] = newCache; // A match means we're done; a fail means we have to keep checking

                  if (newCache[2] = matcher(elem, context, xml)) {
                    return true;
                  }
                }
              }
            }
          }

          return false;
        };
      }

      function elementMatcher(matchers) {
        return matchers.length > 1 ? function (elem, context, xml) {
          var i = matchers.length;

          while (i--) {
            if (!matchers[i](elem, context, xml)) {
              return false;
            }
          }

          return true;
        } : matchers[0];
      }

      function multipleContexts(selector, contexts, results) {
        var i = 0,
            len = contexts.length;

        for (; i < len; i++) {
          Sizzle(selector, contexts[i], results);
        }

        return results;
      }

      function condense(unmatched, map, filter, context, xml) {
        var elem,
            newUnmatched = [],
            i = 0,
            len = unmatched.length,
            mapped = map != null;

        for (; i < len; i++) {
          if (elem = unmatched[i]) {
            if (!filter || filter(elem, context, xml)) {
              newUnmatched.push(elem);

              if (mapped) {
                map.push(i);
              }
            }
          }
        }

        return newUnmatched;
      }

      function setMatcher(preFilter, selector, matcher, postFilter, postFinder, postSelector) {
        if (postFilter && !postFilter[expando]) {
          postFilter = setMatcher(postFilter);
        }

        if (postFinder && !postFinder[expando]) {
          postFinder = setMatcher(postFinder, postSelector);
        }

        return markFunction(function (seed, results, context, xml) {
          var temp,
              i,
              elem,
              preMap = [],
              postMap = [],
              preexisting = results.length,
              // Get initial elements from seed or context
          elems = seed || multipleContexts(selector || "*", context.nodeType ? [context] : context, []),
              // Prefilter to get matcher input, preserving a map for seed-results synchronization
          matcherIn = preFilter && (seed || !selector) ? condense(elems, preMap, preFilter, context, xml) : elems,
              matcherOut = matcher ? // If we have a postFinder, or filtered seed, or non-seed postFilter or preexisting results,
          postFinder || (seed ? preFilter : preexisting || postFilter) ? // ...intermediate processing is necessary
          [] : // ...otherwise use results directly
          results : matcherIn; // Find primary matches

          if (matcher) {
            matcher(matcherIn, matcherOut, context, xml);
          } // Apply postFilter


          if (postFilter) {
            temp = condense(matcherOut, postMap);
            postFilter(temp, [], context, xml); // Un-match failing elements by moving them back to matcherIn

            i = temp.length;

            while (i--) {
              if (elem = temp[i]) {
                matcherOut[postMap[i]] = !(matcherIn[postMap[i]] = elem);
              }
            }
          }

          if (seed) {
            if (postFinder || preFilter) {
              if (postFinder) {
                // Get the final matcherOut by condensing this intermediate into postFinder contexts
                temp = [];
                i = matcherOut.length;

                while (i--) {
                  if (elem = matcherOut[i]) {
                    // Restore matcherIn since elem is not yet a final match
                    temp.push(matcherIn[i] = elem);
                  }
                }

                postFinder(null, matcherOut = [], temp, xml);
              } // Move matched elements from seed to results to keep them synchronized


              i = matcherOut.length;

              while (i--) {
                if ((elem = matcherOut[i]) && (temp = postFinder ? indexOf(seed, elem) : preMap[i]) > -1) {
                  seed[temp] = !(results[temp] = elem);
                }
              }
            } // Add elements to results, through postFinder if defined

          } else {
            matcherOut = condense(matcherOut === results ? matcherOut.splice(preexisting, matcherOut.length) : matcherOut);

            if (postFinder) {
              postFinder(null, results, matcherOut, xml);
            } else {
              push.apply(results, matcherOut);
            }
          }
        });
      }

      function matcherFromTokens(tokens) {
        var checkContext,
            matcher,
            j,
            len = tokens.length,
            leadingRelative = Expr.relative[tokens[0].type],
            implicitRelative = leadingRelative || Expr.relative[" "],
            i = leadingRelative ? 1 : 0,
            // The foundational matcher ensures that elements are reachable from top-level context(s)
        matchContext = addCombinator(function (elem) {
          return elem === checkContext;
        }, implicitRelative, true),
            matchAnyContext = addCombinator(function (elem) {
          return indexOf(checkContext, elem) > -1;
        }, implicitRelative, true),
            matchers = [function (elem, context, xml) {
          var ret = !leadingRelative && (xml || context !== outermostContext) || ((checkContext = context).nodeType ? matchContext(elem, context, xml) : matchAnyContext(elem, context, xml)); // Avoid hanging onto element (issue #299)

          checkContext = null;
          return ret;
        }];

        for (; i < len; i++) {
          if (matcher = Expr.relative[tokens[i].type]) {
            matchers = [addCombinator(elementMatcher(matchers), matcher)];
          } else {
            matcher = Expr.filter[tokens[i].type].apply(null, tokens[i].matches); // Return special upon seeing a positional matcher

            if (matcher[expando]) {
              // Find the next relative operator (if any) for proper handling
              j = ++i;

              for (; j < len; j++) {
                if (Expr.relative[tokens[j].type]) {
                  break;
                }
              }

              return setMatcher(i > 1 && elementMatcher(matchers), i > 1 && toSelector( // If the preceding token was a descendant combinator, insert an implicit any-element `*`
              tokens.slice(0, i - 1).concat({
                value: tokens[i - 2].type === " " ? "*" : ""
              })).replace(rtrim, "$1"), matcher, i < j && matcherFromTokens(tokens.slice(i, j)), j < len && matcherFromTokens(tokens = tokens.slice(j)), j < len && toSelector(tokens));
            }

            matchers.push(matcher);
          }
        }

        return elementMatcher(matchers);
      }

      function matcherFromGroupMatchers(elementMatchers, setMatchers) {
        var bySet = setMatchers.length > 0,
            byElement = elementMatchers.length > 0,
            superMatcher = function (seed, context, xml, results, outermost) {
          var elem,
              j,
              matcher,
              matchedCount = 0,
              i = "0",
              unmatched = seed && [],
              setMatched = [],
              contextBackup = outermostContext,
              // We must always have either seed elements or outermost context
          elems = seed || byElement && Expr.find["TAG"]("*", outermost),
              // Use integer dirruns iff this is the outermost matcher
          dirrunsUnique = dirruns += contextBackup == null ? 1 : Math.random() || 0.1,
              len = elems.length;

          if (outermost) {
            outermostContext = context === document || context || outermost;
          } // Add elements passing elementMatchers directly to results
          // Support: IE<9, Safari
          // Tolerate NodeList properties (IE: "length"; Safari: <number>) matching elements by id


          for (; i !== len && (elem = elems[i]) != null; i++) {
            if (byElement && elem) {
              j = 0;

              if (!context && elem.ownerDocument !== document) {
                setDocument(elem);
                xml = !documentIsHTML;
              }

              while (matcher = elementMatchers[j++]) {
                if (matcher(elem, context || document, xml)) {
                  results.push(elem);
                  break;
                }
              }

              if (outermost) {
                dirruns = dirrunsUnique;
              }
            } // Track unmatched elements for set filters


            if (bySet) {
              // They will have gone through all possible matchers
              if (elem = !matcher && elem) {
                matchedCount--;
              } // Lengthen the array for every element, matched or not


              if (seed) {
                unmatched.push(elem);
              }
            }
          } // `i` is now the count of elements visited above, and adding it to `matchedCount`
          // makes the latter nonnegative.


          matchedCount += i; // Apply set filters to unmatched elements
          // NOTE: This can be skipped if there are no unmatched elements (i.e., `matchedCount`
          // equals `i`), unless we didn't visit _any_ elements in the above loop because we have
          // no element matchers and no seed.
          // Incrementing an initially-string "0" `i` allows `i` to remain a string only in that
          // case, which will result in a "00" `matchedCount` that differs from `i` but is also
          // numerically zero.

          if (bySet && i !== matchedCount) {
            j = 0;

            while (matcher = setMatchers[j++]) {
              matcher(unmatched, setMatched, context, xml);
            }

            if (seed) {
              // Reintegrate element matches to eliminate the need for sorting
              if (matchedCount > 0) {
                while (i--) {
                  if (!(unmatched[i] || setMatched[i])) {
                    setMatched[i] = pop.call(results);
                  }
                }
              } // Discard index placeholder values to get only actual matches


              setMatched = condense(setMatched);
            } // Add matches to results


            push.apply(results, setMatched); // Seedless set matches succeeding multiple successful matchers stipulate sorting

            if (outermost && !seed && setMatched.length > 0 && matchedCount + setMatchers.length > 1) {
              Sizzle.uniqueSort(results);
            }
          } // Override manipulation of globals by nested matchers


          if (outermost) {
            dirruns = dirrunsUnique;
            outermostContext = contextBackup;
          }

          return unmatched;
        };

        return bySet ? markFunction(superMatcher) : superMatcher;
      }

      compile = Sizzle.compile = function (selector, match
      /* Internal Use Only */
      ) {
        var i,
            setMatchers = [],
            elementMatchers = [],
            cached = compilerCache[selector + " "];

        if (!cached) {
          // Generate a function of recursive functions that can be used to check each element
          if (!match) {
            match = tokenize(selector);
          }

          i = match.length;

          while (i--) {
            cached = matcherFromTokens(match[i]);

            if (cached[expando]) {
              setMatchers.push(cached);
            } else {
              elementMatchers.push(cached);
            }
          } // Cache the compiled function


          cached = compilerCache(selector, matcherFromGroupMatchers(elementMatchers, setMatchers)); // Save selector and tokenization

          cached.selector = selector;
        }

        return cached;
      };
      /**
       * A low-level selection function that works with Sizzle's compiled
       *  selector functions
       * @param {String|Function} selector A selector or a pre-compiled
       *  selector function built with Sizzle.compile
       * @param {Element} context
       * @param {Array} [results]
       * @param {Array} [seed] A set of elements to match against
       */


      select = Sizzle.select = function (selector, context, results, seed) {
        var i,
            tokens,
            token,
            type,
            find,
            compiled = typeof selector === "function" && selector,
            match = !seed && tokenize(selector = compiled.selector || selector);
        results = results || []; // Try to minimize operations if there is only one selector in the list and no seed
        // (the latter of which guarantees us context)

        if (match.length === 1) {
          // Reduce context if the leading compound selector is an ID
          tokens = match[0] = match[0].slice(0);

          if (tokens.length > 2 && (token = tokens[0]).type === "ID" && context.nodeType === 9 && documentIsHTML && Expr.relative[tokens[1].type]) {
            context = (Expr.find["ID"](token.matches[0].replace(runescape, funescape), context) || [])[0];

            if (!context) {
              return results; // Precompiled matchers will still verify ancestry, so step up a level
            } else if (compiled) {
              context = context.parentNode;
            }

            selector = selector.slice(tokens.shift().value.length);
          } // Fetch a seed set for right-to-left matching


          i = matchExpr["needsContext"].test(selector) ? 0 : tokens.length;

          while (i--) {
            token = tokens[i]; // Abort if we hit a combinator

            if (Expr.relative[type = token.type]) {
              break;
            }

            if (find = Expr.find[type]) {
              // Search, expanding context for leading sibling combinators
              if (seed = find(token.matches[0].replace(runescape, funescape), rsibling.test(tokens[0].type) && testContext(context.parentNode) || context)) {
                // If seed is empty or no tokens remain, we can return early
                tokens.splice(i, 1);
                selector = seed.length && toSelector(tokens);

                if (!selector) {
                  push.apply(results, seed);
                  return results;
                }

                break;
              }
            }
          }
        } // Compile and execute a filtering function if one is not provided
        // Provide `match` to avoid retokenization if we modified the selector above


        (compiled || compile(selector, match))(seed, context, !documentIsHTML, results, !context || rsibling.test(selector) && testContext(context.parentNode) || context);
        return results;
      }; // One-time assignments
      // Sort stability


      support.sortStable = expando.split("").sort(sortOrder).join("") === expando; // Support: Chrome 14-35+
      // Always assume duplicates if they aren't passed to the comparison function

      support.detectDuplicates = !!hasDuplicate; // Initialize against the default document

      setDocument();
      return Sizzle;
    }(window);

    jQuery.find = Sizzle;
    jQuery.expr = Sizzle.selectors; // Deprecated

    jQuery.expr[":"] = jQuery.expr.pseudos;
    jQuery.uniqueSort = jQuery.unique = Sizzle.uniqueSort;
    jQuery.text = Sizzle.getText;
    jQuery.isXMLDoc = Sizzle.isXML;
    jQuery.contains = Sizzle.contains;
    jQuery.escapeSelector = Sizzle.escape;

    var dir = function (elem, dir, until) {
      var matched = [],
          truncate = until !== undefined;

      while ((elem = elem[dir]) && elem.nodeType !== 9) {
        if (elem.nodeType === 1) {
          if (truncate && jQuery(elem).is(until)) {
            break;
          }

          matched.push(elem);
        }
      }

      return matched;
    };

    var siblings = function (n, elem) {
      var matched = [];

      for (; n; n = n.nextSibling) {
        if (n.nodeType === 1 && n !== elem) {
          matched.push(n);
        }
      }

      return matched;
    };

    var rneedsContext = jQuery.expr.match.needsContext;

    function nodeName(elem, name) {
      return elem.nodeName && elem.nodeName.toLowerCase() === name.toLowerCase();
    }

    var rsingleTag = /^<([a-z][^\/\0>:\x20\t\r\n\f]*)[\x20\t\r\n\f]*\/?>(?:<\/\1>|)$/i; // Implement the identical functionality for filter and not

    function winnow(elements, qualifier, not) {
      if (isFunction(qualifier)) {
        return jQuery.grep(elements, function (elem, i) {
          return !!qualifier.call(elem, i, elem) !== not;
        });
      } // Single element


      if (qualifier.nodeType) {
        return jQuery.grep(elements, function (elem) {
          return elem === qualifier !== not;
        });
      } // Arraylike of elements (jQuery, arguments, Array)


      if (typeof qualifier !== "string") {
        return jQuery.grep(elements, function (elem) {
          return indexOf$1.call(qualifier, elem) > -1 !== not;
        });
      } // Filtered directly for both simple and complex selectors


      return jQuery.filter(qualifier, elements, not);
    }

    jQuery.filter = function (expr, elems, not) {
      var elem = elems[0];

      if (not) {
        expr = ":not(" + expr + ")";
      }

      if (elems.length === 1 && elem.nodeType === 1) {
        return jQuery.find.matchesSelector(elem, expr) ? [elem] : [];
      }

      return jQuery.find.matches(expr, jQuery.grep(elems, function (elem) {
        return elem.nodeType === 1;
      }));
    };

    jQuery.fn.extend({
      find: function (selector) {
        var i,
            ret,
            len = this.length,
            self = this;

        if (typeof selector !== "string") {
          return this.pushStack(jQuery(selector).filter(function () {
            for (i = 0; i < len; i++) {
              if (jQuery.contains(self[i], this)) {
                return true;
              }
            }
          }));
        }

        ret = this.pushStack([]);

        for (i = 0; i < len; i++) {
          jQuery.find(selector, self[i], ret);
        }

        return len > 1 ? jQuery.uniqueSort(ret) : ret;
      },
      filter: function (selector) {
        return this.pushStack(winnow(this, selector || [], false));
      },
      not: function (selector) {
        return this.pushStack(winnow(this, selector || [], true));
      },
      is: function (selector) {
        return !!winnow(this, // If this is a positional/relative selector, check membership in the returned set
        // so $("p:first").is("p:last") won't return true for a doc with two "p".
        typeof selector === "string" && rneedsContext.test(selector) ? jQuery(selector) : selector || [], false).length;
      }
    }); // Initialize a jQuery object
    // A central reference to the root jQuery(document)

    var rootjQuery,
        // A simple way to check for HTML strings
    // Prioritize #id over <tag> to avoid XSS via location.hash (#9521)
    // Strict HTML recognition (#11290: must start with <)
    // Shortcut simple #id case for speed
    rquickExpr = /^(?:\s*(<[\w\W]+>)[^>]*|#([\w-]+))$/,
        init$2 = jQuery.fn.init = function (selector, context, root) {
      var match, elem; // HANDLE: $(""), $(null), $(undefined), $(false)

      if (!selector) {
        return this;
      } // Method init() accepts an alternate rootjQuery
      // so migrate can support jQuery.sub (gh-2101)


      root = root || rootjQuery; // Handle HTML strings

      if (typeof selector === "string") {
        if (selector[0] === "<" && selector[selector.length - 1] === ">" && selector.length >= 3) {
          // Assume that strings that start and end with <> are HTML and skip the regex check
          match = [null, selector, null];
        } else {
          match = rquickExpr.exec(selector);
        } // Match html or make sure no context is specified for #id


        if (match && (match[1] || !context)) {
          // HANDLE: $(html) -> $(array)
          if (match[1]) {
            context = context instanceof jQuery ? context[0] : context; // Option to run scripts is true for back-compat
            // Intentionally let the error be thrown if parseHTML is not present

            jQuery.merge(this, jQuery.parseHTML(match[1], context && context.nodeType ? context.ownerDocument || context : document$2, true)); // HANDLE: $(html, props)

            if (rsingleTag.test(match[1]) && jQuery.isPlainObject(context)) {
              for (match in context) {
                // Properties of context are called as methods if possible
                if (isFunction(this[match])) {
                  this[match](context[match]); // ...and otherwise set as attributes
                } else {
                  this.attr(match, context[match]);
                }
              }
            }

            return this; // HANDLE: $(#id)
          } else {
            elem = document$2.getElementById(match[2]);

            if (elem) {
              // Inject the element directly into the jQuery object
              this[0] = elem;
              this.length = 1;
            }

            return this;
          } // HANDLE: $(expr, $(...))

        } else if (!context || context.jquery) {
          return (context || root).find(selector); // HANDLE: $(expr, context)
          // (which is just equivalent to: $(context).find(expr)
        } else {
          return this.constructor(context).find(selector);
        } // HANDLE: $(DOMElement)

      } else if (selector.nodeType) {
        this[0] = selector;
        this.length = 1;
        return this; // HANDLE: $(function)
        // Shortcut for document ready
      } else if (isFunction(selector)) {
        return root.ready !== undefined ? root.ready(selector) : // Execute immediately if ready is not present
        selector(jQuery);
      }

      return jQuery.makeArray(selector, this);
    }; // Give the init function the jQuery prototype for later instantiation


    init$2.prototype = jQuery.fn; // Initialize central reference

    rootjQuery = jQuery(document$2);
    var rparentsprev = /^(?:parents|prev(?:Until|All))/,
        // Methods guaranteed to produce a unique set when starting from a unique set
    guaranteedUnique = {
      children: true,
      contents: true,
      next: true,
      prev: true
    };
    jQuery.fn.extend({
      has: function (target) {
        var targets = jQuery(target, this),
            l = targets.length;
        return this.filter(function () {
          var i = 0;

          for (; i < l; i++) {
            if (jQuery.contains(this, targets[i])) {
              return true;
            }
          }
        });
      },
      closest: function (selectors, context) {
        var cur,
            i = 0,
            l = this.length,
            matched = [],
            targets = typeof selectors !== "string" && jQuery(selectors); // Positional selectors never match, since there's no _selection_ context

        if (!rneedsContext.test(selectors)) {
          for (; i < l; i++) {
            for (cur = this[i]; cur && cur !== context; cur = cur.parentNode) {
              // Always skip document fragments
              if (cur.nodeType < 11 && (targets ? targets.index(cur) > -1 : // Don't pass non-elements to Sizzle
              cur.nodeType === 1 && jQuery.find.matchesSelector(cur, selectors))) {
                matched.push(cur);
                break;
              }
            }
          }
        }

        return this.pushStack(matched.length > 1 ? jQuery.uniqueSort(matched) : matched);
      },
      // Determine the position of an element within the set
      index: function (elem) {
        // No argument, return index in parent
        if (!elem) {
          return this[0] && this[0].parentNode ? this.first().prevAll().length : -1;
        } // Index in selector


        if (typeof elem === "string") {
          return indexOf$1.call(jQuery(elem), this[0]);
        } // Locate the position of the desired element


        return indexOf$1.call(this, // If it receives a jQuery object, the first element is used
        elem.jquery ? elem[0] : elem);
      },
      add: function (selector, context) {
        return this.pushStack(jQuery.uniqueSort(jQuery.merge(this.get(), jQuery(selector, context))));
      },
      addBack: function (selector) {
        return this.add(selector == null ? this.prevObject : this.prevObject.filter(selector));
      }
    });

    function sibling(cur, dir) {
      while ((cur = cur[dir]) && cur.nodeType !== 1) {}

      return cur;
    }

    jQuery.each({
      parent: function (elem) {
        var parent = elem.parentNode;
        return parent && parent.nodeType !== 11 ? parent : null;
      },
      parents: function (elem) {
        return dir(elem, "parentNode");
      },
      parentsUntil: function (elem, i, until) {
        return dir(elem, "parentNode", until);
      },
      next: function (elem) {
        return sibling(elem, "nextSibling");
      },
      prev: function (elem) {
        return sibling(elem, "previousSibling");
      },
      nextAll: function (elem) {
        return dir(elem, "nextSibling");
      },
      prevAll: function (elem) {
        return dir(elem, "previousSibling");
      },
      nextUntil: function (elem, i, until) {
        return dir(elem, "nextSibling", until);
      },
      prevUntil: function (elem, i, until) {
        return dir(elem, "previousSibling", until);
      },
      siblings: function (elem) {
        return siblings((elem.parentNode || {}).firstChild, elem);
      },
      children: function (elem) {
        return siblings(elem.firstChild);
      },
      contents: function (elem) {
        if (nodeName(elem, "iframe")) {
          return elem.contentDocument;
        } // Support: IE 9 - 11 only, iOS 7 only, Android Browser <=4.3 only
        // Treat the template element as a regular one in browsers that
        // don't support it.


        if (nodeName(elem, "template")) {
          elem = elem.content || elem;
        }

        return jQuery.merge([], elem.childNodes);
      }
    }, function (name, fn) {
      jQuery.fn[name] = function (until, selector) {
        var matched = jQuery.map(this, fn, until);

        if (name.slice(-5) !== "Until") {
          selector = until;
        }

        if (selector && typeof selector === "string") {
          matched = jQuery.filter(selector, matched);
        }

        if (this.length > 1) {
          // Remove duplicates
          if (!guaranteedUnique[name]) {
            jQuery.uniqueSort(matched);
          } // Reverse order for parents* and prev-derivatives


          if (rparentsprev.test(name)) {
            matched.reverse();
          }
        }

        return this.pushStack(matched);
      };
    });
    var rnothtmlwhite = /[^\x20\t\r\n\f]+/g; // Convert String-formatted options into Object-formatted ones

    function createOptions(options) {
      var object = {};
      jQuery.each(options.match(rnothtmlwhite) || [], function (_, flag) {
        object[flag] = true;
      });
      return object;
    }
    /*
     * Create a callback list using the following parameters:
     *
     *	options: an optional list of space-separated options that will change how
     *			the callback list behaves or a more traditional option object
     *
     * By default a callback list will act like an event callback list and can be
     * "fired" multiple times.
     *
     * Possible options:
     *
     *	once:			will ensure the callback list can only be fired once (like a Deferred)
     *
     *	memory:			will keep track of previous values and will call any callback added
     *					after the list has been fired right away with the latest "memorized"
     *					values (like a Deferred)
     *
     *	unique:			will ensure a callback can only be added once (no duplicate in the list)
     *
     *	stopOnFalse:	interrupt callings when a callback returns false
     *
     */


    jQuery.Callbacks = function (options) {
      // Convert options from String-formatted to Object-formatted if needed
      // (we check in cache first)
      options = typeof options === "string" ? createOptions(options) : jQuery.extend({}, options);

      var // Flag to know if list is currently firing
      firing,
          // Last fire value for non-forgettable lists
      memory,
          // Flag to know if list was already fired
      fired,
          // Flag to prevent firing
      locked,
          // Actual callback list
      list = [],
          // Queue of execution data for repeatable lists
      queue = [],
          // Index of currently firing callback (modified by add/remove as needed)
      firingIndex = -1,
          // Fire callbacks
      fire = function () {
        // Enforce single-firing
        locked = locked || options.once; // Execute callbacks for all pending executions,
        // respecting firingIndex overrides and runtime changes

        fired = firing = true;

        for (; queue.length; firingIndex = -1) {
          memory = queue.shift();

          while (++firingIndex < list.length) {
            // Run callback and check for early termination
            if (list[firingIndex].apply(memory[0], memory[1]) === false && options.stopOnFalse) {
              // Jump to end and forget the data so .add doesn't re-fire
              firingIndex = list.length;
              memory = false;
            }
          }
        } // Forget the data if we're done with it


        if (!options.memory) {
          memory = false;
        }

        firing = false; // Clean up if we're done firing for good

        if (locked) {
          // Keep an empty list if we have data for future add calls
          if (memory) {
            list = []; // Otherwise, this object is spent
          } else {
            list = "";
          }
        }
      },
          // Actual Callbacks object
      self = {
        // Add a callback or a collection of callbacks to the list
        add: function () {
          if (list) {
            // If we have memory from a past run, we should fire after adding
            if (memory && !firing) {
              firingIndex = list.length - 1;
              queue.push(memory);
            }

            (function add(args) {
              jQuery.each(args, function (_, arg) {
                if (isFunction(arg)) {
                  if (!options.unique || !self.has(arg)) {
                    list.push(arg);
                  }
                } else if (arg && arg.length && toType(arg) !== "string") {
                  // Inspect recursively
                  add(arg);
                }
              });
            })(arguments);

            if (memory && !firing) {
              fire();
            }
          }

          return this;
        },
        // Remove a callback from the list
        remove: function () {
          jQuery.each(arguments, function (_, arg) {
            var index;

            while ((index = jQuery.inArray(arg, list, index)) > -1) {
              list.splice(index, 1); // Handle firing indexes

              if (index <= firingIndex) {
                firingIndex--;
              }
            }
          });
          return this;
        },
        // Check if a given callback is in the list.
        // If no argument is given, return whether or not list has callbacks attached.
        has: function (fn) {
          return fn ? jQuery.inArray(fn, list) > -1 : list.length > 0;
        },
        // Remove all callbacks from the list
        empty: function () {
          if (list) {
            list = [];
          }

          return this;
        },
        // Disable .fire and .add
        // Abort any current/pending executions
        // Clear all callbacks and values
        disable: function () {
          locked = queue = [];
          list = memory = "";
          return this;
        },
        disabled: function () {
          return !list;
        },
        // Disable .fire
        // Also disable .add unless we have memory (since it would have no effect)
        // Abort any pending executions
        lock: function () {
          locked = queue = [];

          if (!memory && !firing) {
            list = memory = "";
          }

          return this;
        },
        locked: function () {
          return !!locked;
        },
        // Call all callbacks with the given context and arguments
        fireWith: function (context, args) {
          if (!locked) {
            args = args || [];
            args = [context, args.slice ? args.slice() : args];
            queue.push(args);

            if (!firing) {
              fire();
            }
          }

          return this;
        },
        // Call all the callbacks with the given arguments
        fire: function () {
          self.fireWith(this, arguments);
          return this;
        },
        // To know if the callbacks have already been called at least once
        fired: function () {
          return !!fired;
        }
      };

      return self;
    };

    function Identity(v) {
      return v;
    }

    function Thrower(ex) {
      throw ex;
    }

    function adoptValue(value, resolve, reject, noValue) {
      var method;

      try {
        // Check for promise aspect first to privilege synchronous behavior
        if (value && isFunction(method = value.promise)) {
          method.call(value).done(resolve).fail(reject); // Other thenables
        } else if (value && isFunction(method = value.then)) {
          method.call(value, resolve, reject); // Other non-thenables
        } else {
          // Control `resolve` arguments by letting Array#slice cast boolean `noValue` to integer:
          // * false: [ value ].slice( 0 ) => resolve( value )
          // * true: [ value ].slice( 1 ) => resolve()
          resolve.apply(undefined, [value].slice(noValue));
        } // For Promises/A+, convert exceptions into rejections
        // Since jQuery.when doesn't unwrap thenables, we can skip the extra checks appearing in
        // Deferred#then to conditionally suppress rejection.

      } catch (value) {
        // Support: Android 4.0 only
        // Strict mode functions invoked without .call/.apply get global-object context
        reject.apply(undefined, [value]);
      }
    }

    jQuery.extend({
      Deferred: function (func) {
        var tuples = [// action, add listener, callbacks,
        // ... .then handlers, argument index, [final state]
        ["notify", "progress", jQuery.Callbacks("memory"), jQuery.Callbacks("memory"), 2], ["resolve", "done", jQuery.Callbacks("once memory"), jQuery.Callbacks("once memory"), 0, "resolved"], ["reject", "fail", jQuery.Callbacks("once memory"), jQuery.Callbacks("once memory"), 1, "rejected"]],
            state = "pending",
            promise = {
          state: function () {
            return state;
          },
          always: function () {
            deferred.done(arguments).fail(arguments);
            return this;
          },
          "catch": function (fn) {
            return promise.then(null, fn);
          },
          // Keep pipe for back-compat
          pipe: function
            /* fnDone, fnFail, fnProgress */
          () {
            var fns = arguments;
            return jQuery.Deferred(function (newDefer) {
              jQuery.each(tuples, function (i, tuple) {
                // Map tuples (progress, done, fail) to arguments (done, fail, progress)
                var fn = isFunction(fns[tuple[4]]) && fns[tuple[4]]; // deferred.progress(function() { bind to newDefer or newDefer.notify })
                // deferred.done(function() { bind to newDefer or newDefer.resolve })
                // deferred.fail(function() { bind to newDefer or newDefer.reject })

                deferred[tuple[1]](function () {
                  var returned = fn && fn.apply(this, arguments);

                  if (returned && isFunction(returned.promise)) {
                    returned.promise().progress(newDefer.notify).done(newDefer.resolve).fail(newDefer.reject);
                  } else {
                    newDefer[tuple[0] + "With"](this, fn ? [returned] : arguments);
                  }
                });
              });
              fns = null;
            }).promise();
          },
          then: function (onFulfilled, onRejected, onProgress) {
            var maxDepth = 0;

            function resolve(depth, deferred, handler, special) {
              return function () {
                var that = this,
                    args = arguments,
                    mightThrow = function () {
                  var returned, then; // Support: Promises/A+ section 2.3.3.3.3
                  // https://promisesaplus.com/#point-59
                  // Ignore double-resolution attempts

                  if (depth < maxDepth) {
                    return;
                  }

                  returned = handler.apply(that, args); // Support: Promises/A+ section 2.3.1
                  // https://promisesaplus.com/#point-48

                  if (returned === deferred.promise()) {
                    throw new TypeError("Thenable self-resolution");
                  } // Support: Promises/A+ sections 2.3.3.1, 3.5
                  // https://promisesaplus.com/#point-54
                  // https://promisesaplus.com/#point-75
                  // Retrieve `then` only once


                  then = returned && ( // Support: Promises/A+ section 2.3.4
                  // https://promisesaplus.com/#point-64
                  // Only check objects and functions for thenability
                  typeof returned === "object" || typeof returned === "function") && returned.then; // Handle a returned thenable

                  if (isFunction(then)) {
                    // Special processors (notify) just wait for resolution
                    if (special) {
                      then.call(returned, resolve(maxDepth, deferred, Identity, special), resolve(maxDepth, deferred, Thrower, special)); // Normal processors (resolve) also hook into progress
                    } else {
                      // ...and disregard older resolution values
                      maxDepth++;
                      then.call(returned, resolve(maxDepth, deferred, Identity, special), resolve(maxDepth, deferred, Thrower, special), resolve(maxDepth, deferred, Identity, deferred.notifyWith));
                    } // Handle all other returned values

                  } else {
                    // Only substitute handlers pass on context
                    // and multiple values (non-spec behavior)
                    if (handler !== Identity) {
                      that = undefined;
                      args = [returned];
                    } // Process the value(s)
                    // Default process is resolve


                    (special || deferred.resolveWith)(that, args);
                  }
                },
                    // Only normal processors (resolve) catch and reject exceptions
                process = special ? mightThrow : function () {
                  try {
                    mightThrow();
                  } catch (e) {
                    if (jQuery.Deferred.exceptionHook) {
                      jQuery.Deferred.exceptionHook(e, process.stackTrace);
                    } // Support: Promises/A+ section 2.3.3.3.4.1
                    // https://promisesaplus.com/#point-61
                    // Ignore post-resolution exceptions


                    if (depth + 1 >= maxDepth) {
                      // Only substitute handlers pass on context
                      // and multiple values (non-spec behavior)
                      if (handler !== Thrower) {
                        that = undefined;
                        args = [e];
                      }

                      deferred.rejectWith(that, args);
                    }
                  }
                }; // Support: Promises/A+ section 2.3.3.3.1
                // https://promisesaplus.com/#point-57
                // Re-resolve promises immediately to dodge false rejection from
                // subsequent errors


                if (depth) {
                  process();
                } else {
                  // Call an optional hook to record the stack, in case of exception
                  // since it's otherwise lost when execution goes async
                  if (jQuery.Deferred.getStackHook) {
                    process.stackTrace = jQuery.Deferred.getStackHook();
                  }

                  window.setTimeout(process);
                }
              };
            }

            return jQuery.Deferred(function (newDefer) {
              // progress_handlers.add( ... )
              tuples[0][3].add(resolve(0, newDefer, isFunction(onProgress) ? onProgress : Identity, newDefer.notifyWith)); // fulfilled_handlers.add( ... )

              tuples[1][3].add(resolve(0, newDefer, isFunction(onFulfilled) ? onFulfilled : Identity)); // rejected_handlers.add( ... )

              tuples[2][3].add(resolve(0, newDefer, isFunction(onRejected) ? onRejected : Thrower));
            }).promise();
          },
          // Get a promise for this deferred
          // If obj is provided, the promise aspect is added to the object
          promise: function (obj) {
            return obj != null ? jQuery.extend(obj, promise) : promise;
          }
        },
            deferred = {}; // Add list-specific methods

        jQuery.each(tuples, function (i, tuple) {
          var list = tuple[2],
              stateString = tuple[5]; // promise.progress = list.add
          // promise.done = list.add
          // promise.fail = list.add

          promise[tuple[1]] = list.add; // Handle state

          if (stateString) {
            list.add(function () {
              // state = "resolved" (i.e., fulfilled)
              // state = "rejected"
              state = stateString;
            }, // rejected_callbacks.disable
            // fulfilled_callbacks.disable
            tuples[3 - i][2].disable, // rejected_handlers.disable
            // fulfilled_handlers.disable
            tuples[3 - i][3].disable, // progress_callbacks.lock
            tuples[0][2].lock, // progress_handlers.lock
            tuples[0][3].lock);
          } // progress_handlers.fire
          // fulfilled_handlers.fire
          // rejected_handlers.fire


          list.add(tuple[3].fire); // deferred.notify = function() { deferred.notifyWith(...) }
          // deferred.resolve = function() { deferred.resolveWith(...) }
          // deferred.reject = function() { deferred.rejectWith(...) }

          deferred[tuple[0]] = function () {
            deferred[tuple[0] + "With"](this === deferred ? undefined : this, arguments);
            return this;
          }; // deferred.notifyWith = list.fireWith
          // deferred.resolveWith = list.fireWith
          // deferred.rejectWith = list.fireWith


          deferred[tuple[0] + "With"] = list.fireWith;
        }); // Make the deferred a promise

        promise.promise(deferred); // Call given func if any

        if (func) {
          func.call(deferred, deferred);
        } // All done!


        return deferred;
      },
      // Deferred helper
      when: function (singleValue) {
        var // count of uncompleted subordinates
        remaining = arguments.length,
            // count of unprocessed arguments
        i = remaining,
            // subordinate fulfillment data
        resolveContexts = Array(i),
            resolveValues = slice.call(arguments),
            // the master Deferred
        master = jQuery.Deferred(),
            // subordinate callback factory
        updateFunc = function (i) {
          return function (value) {
            resolveContexts[i] = this;
            resolveValues[i] = arguments.length > 1 ? slice.call(arguments) : value;

            if (! --remaining) {
              master.resolveWith(resolveContexts, resolveValues);
            }
          };
        }; // Single- and empty arguments are adopted like Promise.resolve


        if (remaining <= 1) {
          adoptValue(singleValue, master.done(updateFunc(i)).resolve, master.reject, !remaining); // Use .then() to unwrap secondary thenables (cf. gh-3000)

          if (master.state() === "pending" || isFunction(resolveValues[i] && resolveValues[i].then)) {
            return master.then();
          }
        } // Multiple arguments are aggregated like Promise.all array elements


        while (i--) {
          adoptValue(resolveValues[i], updateFunc(i), master.reject);
        }

        return master.promise();
      }
    }); // These usually indicate a programmer mistake during development,
    // warn about them ASAP rather than swallowing them by default.

    var rerrorNames = /^(Eval|Internal|Range|Reference|Syntax|Type|URI)Error$/;

    jQuery.Deferred.exceptionHook = function (error, stack) {
      // Support: IE 8 - 9 only
      // Console exists when dev tools are open, which can happen at any time
      if (window.console && window.console.warn && error && rerrorNames.test(error.name)) {
        window.console.warn("jQuery.Deferred exception: " + error.message, error.stack, stack);
      }
    };

    jQuery.readyException = function (error) {
      window.setTimeout(function () {
        throw error;
      });
    }; // The deferred used on DOM ready


    var readyList = jQuery.Deferred();

    jQuery.fn.ready = function (fn) {
      readyList.then(fn) // Wrap jQuery.readyException in a function so that the lookup
      // happens at the time of error handling instead of callback
      // registration.
      .catch(function (error) {
        jQuery.readyException(error);
      });
      return this;
    };

    jQuery.extend({
      // Is the DOM ready to be used? Set to true once it occurs.
      isReady: false,
      // A counter to track how many items to wait for before
      // the ready event fires. See #6781
      readyWait: 1,
      // Handle when the DOM is ready
      ready: function (wait) {
        // Abort if there are pending holds or we're already ready
        if (wait === true ? --jQuery.readyWait : jQuery.isReady) {
          return;
        } // Remember that the DOM is ready


        jQuery.isReady = true; // If a normal DOM Ready event fired, decrement, and wait if need be

        if (wait !== true && --jQuery.readyWait > 0) {
          return;
        } // If there are functions bound, to execute


        readyList.resolveWith(document$2, [jQuery]);
      }
    });
    jQuery.ready.then = readyList.then; // The ready event handler and self cleanup method

    function completed() {
      document$2.removeEventListener("DOMContentLoaded", completed);
      window.removeEventListener("load", completed);
      jQuery.ready();
    } // Catch cases where $(document).ready() is called
    // after the browser event has already occurred.
    // Support: IE <=9 - 10 only
    // Older IE sometimes signals "interactive" too soon


    if (document$2.readyState === "complete" || document$2.readyState !== "loading" && !document$2.documentElement.doScroll) {
      // Handle it asynchronously to allow scripts the opportunity to delay ready
      window.setTimeout(jQuery.ready);
    } else {
      // Use the handy event callback
      document$2.addEventListener("DOMContentLoaded", completed); // A fallback to window.onload, that will always work

      window.addEventListener("load", completed);
    } // Multifunctional method to get and set values of a collection
    // The value/s can optionally be executed if it's a function


    var access = function (elems, fn, key, value, chainable, emptyGet, raw) {
      var i = 0,
          len = elems.length,
          bulk = key == null; // Sets many values

      if (toType(key) === "object") {
        chainable = true;

        for (i in key) {
          access(elems, fn, i, key[i], true, emptyGet, raw);
        } // Sets one value

      } else if (value !== undefined) {
        chainable = true;

        if (!isFunction(value)) {
          raw = true;
        }

        if (bulk) {
          // Bulk operations run against the entire set
          if (raw) {
            fn.call(elems, value);
            fn = null; // ...except when executing function values
          } else {
            bulk = fn;

            fn = function (elem, key, value) {
              return bulk.call(jQuery(elem), value);
            };
          }
        }

        if (fn) {
          for (; i < len; i++) {
            fn(elems[i], key, raw ? value : value.call(elems[i], i, fn(elems[i], key)));
          }
        }
      }

      if (chainable) {
        return elems;
      } // Gets


      if (bulk) {
        return fn.call(elems);
      }

      return len ? fn(elems[0], key) : emptyGet;
    }; // Matches dashed string for camelizing


    var rmsPrefix = /^-ms-/,
        rdashAlpha = /-([a-z])/g; // Used by camelCase as callback to replace()

    function fcamelCase(all, letter) {
      return letter.toUpperCase();
    } // Convert dashed to camelCase; used by the css and data modules
    // Support: IE <=9 - 11, Edge 12 - 15
    // Microsoft forgot to hump their vendor prefix (#9572)


    function camelCase(string) {
      return string.replace(rmsPrefix, "ms-").replace(rdashAlpha, fcamelCase);
    }

    var acceptData = function (owner) {
      // Accepts only:
      //  - Node
      //    - Node.ELEMENT_NODE
      //    - Node.DOCUMENT_NODE
      //  - Object
      //    - Any
      return owner.nodeType === 1 || owner.nodeType === 9 || !+owner.nodeType;
    };

    function Data() {
      this.expando = jQuery.expando + Data.uid++;
    }

    Data.uid = 1;
    Data.prototype = {
      cache: function (owner) {
        // Check if the owner object already has a cache
        var value = owner[this.expando]; // If not, create one

        if (!value) {
          value = {}; // We can accept data for non-element nodes in modern browsers,
          // but we should not, see #8335.
          // Always return an empty object.

          if (acceptData(owner)) {
            // If it is a node unlikely to be stringify-ed or looped over
            // use plain assignment
            if (owner.nodeType) {
              owner[this.expando] = value; // Otherwise secure it in a non-enumerable property
              // configurable must be true to allow the property to be
              // deleted when data is removed
            } else {
              Object.defineProperty(owner, this.expando, {
                value: value,
                configurable: true
              });
            }
          }
        }

        return value;
      },
      set: function (owner, data, value) {
        var prop,
            cache = this.cache(owner); // Handle: [ owner, key, value ] args
        // Always use camelCase key (gh-2257)

        if (typeof data === "string") {
          cache[camelCase(data)] = value; // Handle: [ owner, { properties } ] args
        } else {
          // Copy the properties one-by-one to the cache object
          for (prop in data) {
            cache[camelCase(prop)] = data[prop];
          }
        }

        return cache;
      },
      get: function (owner, key) {
        return key === undefined ? this.cache(owner) : // Always use camelCase key (gh-2257)
        owner[this.expando] && owner[this.expando][camelCase(key)];
      },
      access: function (owner, key, value) {
        // In cases where either:
        //
        //   1. No key was specified
        //   2. A string key was specified, but no value provided
        //
        // Take the "read" path and allow the get method to determine
        // which value to return, respectively either:
        //
        //   1. The entire cache object
        //   2. The data stored at the key
        //
        if (key === undefined || key && typeof key === "string" && value === undefined) {
          return this.get(owner, key);
        } // When the key is not a string, or both a key and value
        // are specified, set or extend (existing objects) with either:
        //
        //   1. An object of properties
        //   2. A key and value
        //


        this.set(owner, key, value); // Since the "set" path can have two possible entry points
        // return the expected data based on which path was taken[*]

        return value !== undefined ? value : key;
      },
      remove: function (owner, key) {
        var i,
            cache = owner[this.expando];

        if (cache === undefined) {
          return;
        }

        if (key !== undefined) {
          // Support array or space separated string of keys
          if (Array.isArray(key)) {
            // If key is an array of keys...
            // We always set camelCase keys, so remove that.
            key = key.map(camelCase);
          } else {
            key = camelCase(key); // If a key with the spaces exists, use it.
            // Otherwise, create an array by matching non-whitespace

            key = key in cache ? [key] : key.match(rnothtmlwhite) || [];
          }

          i = key.length;

          while (i--) {
            delete cache[key[i]];
          }
        } // Remove the expando if there's no more data


        if (key === undefined || jQuery.isEmptyObject(cache)) {
          // Support: Chrome <=35 - 45
          // Webkit & Blink performance suffers when deleting properties
          // from DOM nodes, so set to undefined instead
          // https://bugs.chromium.org/p/chromium/issues/detail?id=378607 (bug restricted)
          if (owner.nodeType) {
            owner[this.expando] = undefined;
          } else {
            delete owner[this.expando];
          }
        }
      },
      hasData: function (owner) {
        var cache = owner[this.expando];
        return cache !== undefined && !jQuery.isEmptyObject(cache);
      }
    };
    var dataPriv = new Data();
    var dataUser = new Data(); //	Implementation Summary
    //
    //	1. Enforce API surface and semantic compatibility with 1.9.x branch
    //	2. Improve the module's maintainability by reducing the storage
    //		paths to a single mechanism.
    //	3. Use the same single mechanism to support "private" and "user" data.
    //	4. _Never_ expose "private" data to user code (TODO: Drop _data, _removeData)
    //	5. Avoid exposing implementation details on user objects (eg. expando properties)
    //	6. Provide a clear path for implementation upgrade to WeakMap in 2014

    var rbrace = /^(?:\{[\w\W]*\}|\[[\w\W]*\])$/,
        rmultiDash = /[A-Z]/g;

    function getData(data) {
      if (data === "true") {
        return true;
      }

      if (data === "false") {
        return false;
      }

      if (data === "null") {
        return null;
      } // Only convert to a number if it doesn't change the string


      if (data === +data + "") {
        return +data;
      }

      if (rbrace.test(data)) {
        return JSON.parse(data);
      }

      return data;
    }

    function dataAttr(elem, key, data) {
      var name; // If nothing was found internally, try to fetch any
      // data from the HTML5 data-* attribute

      if (data === undefined && elem.nodeType === 1) {
        name = "data-" + key.replace(rmultiDash, "-$&").toLowerCase();
        data = elem.getAttribute(name);

        if (typeof data === "string") {
          try {
            data = getData(data);
          } catch (e) {} // Make sure we set the data so it isn't changed later


          dataUser.set(elem, key, data);
        } else {
          data = undefined;
        }
      }

      return data;
    }

    jQuery.extend({
      hasData: function (elem) {
        return dataUser.hasData(elem) || dataPriv.hasData(elem);
      },
      data: function (elem, name, data) {
        return dataUser.access(elem, name, data);
      },
      removeData: function (elem, name) {
        dataUser.remove(elem, name);
      },
      // TODO: Now that all calls to _data and _removeData have been replaced
      // with direct calls to dataPriv methods, these can be deprecated.
      _data: function (elem, name, data) {
        return dataPriv.access(elem, name, data);
      },
      _removeData: function (elem, name) {
        dataPriv.remove(elem, name);
      }
    });
    jQuery.fn.extend({
      data: function (key, value) {
        var i,
            name,
            data,
            elem = this[0],
            attrs = elem && elem.attributes; // Gets all values

        if (key === undefined) {
          if (this.length) {
            data = dataUser.get(elem);

            if (elem.nodeType === 1 && !dataPriv.get(elem, "hasDataAttrs")) {
              i = attrs.length;

              while (i--) {
                // Support: IE 11 only
                // The attrs elements can be null (#14894)
                if (attrs[i]) {
                  name = attrs[i].name;

                  if (name.indexOf("data-") === 0) {
                    name = camelCase(name.slice(5));
                    dataAttr(elem, name, data[name]);
                  }
                }
              }

              dataPriv.set(elem, "hasDataAttrs", true);
            }
          }

          return data;
        } // Sets multiple values


        if (typeof key === "object") {
          return this.each(function () {
            dataUser.set(this, key);
          });
        }

        return access(this, function (value) {
          var data; // The calling jQuery object (element matches) is not empty
          // (and therefore has an element appears at this[ 0 ]) and the
          // `value` parameter was not undefined. An empty jQuery object
          // will result in `undefined` for elem = this[ 0 ] which will
          // throw an exception if an attempt to read a data cache is made.

          if (elem && value === undefined) {
            // Attempt to get data from the cache
            // The key will always be camelCased in Data
            data = dataUser.get(elem, key);

            if (data !== undefined) {
              return data;
            } // Attempt to "discover" the data in
            // HTML5 custom data-* attrs


            data = dataAttr(elem, key);

            if (data !== undefined) {
              return data;
            } // We tried really hard, but the data doesn't exist.


            return;
          } // Set the data...


          this.each(function () {
            // We always store the camelCased key
            dataUser.set(this, key, value);
          });
        }, null, value, arguments.length > 1, null, true);
      },
      removeData: function (key) {
        return this.each(function () {
          dataUser.remove(this, key);
        });
      }
    });
    jQuery.extend({
      queue: function (elem, type, data) {
        var queue;

        if (elem) {
          type = (type || "fx") + "queue";
          queue = dataPriv.get(elem, type); // Speed up dequeue by getting out quickly if this is just a lookup

          if (data) {
            if (!queue || Array.isArray(data)) {
              queue = dataPriv.access(elem, type, jQuery.makeArray(data));
            } else {
              queue.push(data);
            }
          }

          return queue || [];
        }
      },
      dequeue: function (elem, type) {
        type = type || "fx";

        var queue = jQuery.queue(elem, type),
            startLength = queue.length,
            fn = queue.shift(),
            hooks = jQuery._queueHooks(elem, type),
            next = function () {
          jQuery.dequeue(elem, type);
        }; // If the fx queue is dequeued, always remove the progress sentinel


        if (fn === "inprogress") {
          fn = queue.shift();
          startLength--;
        }

        if (fn) {
          // Add a progress sentinel to prevent the fx queue from being
          // automatically dequeued
          if (type === "fx") {
            queue.unshift("inprogress");
          } // Clear up the last queue stop function


          delete hooks.stop;
          fn.call(elem, next, hooks);
        }

        if (!startLength && hooks) {
          hooks.empty.fire();
        }
      },
      // Not public - generate a queueHooks object, or return the current one
      _queueHooks: function (elem, type) {
        var key = type + "queueHooks";
        return dataPriv.get(elem, key) || dataPriv.access(elem, key, {
          empty: jQuery.Callbacks("once memory").add(function () {
            dataPriv.remove(elem, [type + "queue", key]);
          })
        });
      }
    });
    jQuery.fn.extend({
      queue: function (type, data) {
        var setter = 2;

        if (typeof type !== "string") {
          data = type;
          type = "fx";
          setter--;
        }

        if (arguments.length < setter) {
          return jQuery.queue(this[0], type);
        }

        return data === undefined ? this : this.each(function () {
          var queue = jQuery.queue(this, type, data); // Ensure a hooks for this queue

          jQuery._queueHooks(this, type);

          if (type === "fx" && queue[0] !== "inprogress") {
            jQuery.dequeue(this, type);
          }
        });
      },
      dequeue: function (type) {
        return this.each(function () {
          jQuery.dequeue(this, type);
        });
      },
      clearQueue: function (type) {
        return this.queue(type || "fx", []);
      },
      // Get a promise resolved when queues of a certain type
      // are emptied (fx is the type by default)
      promise: function (type, obj) {
        var tmp,
            count = 1,
            defer = jQuery.Deferred(),
            elements = this,
            i = this.length,
            resolve = function () {
          if (! --count) {
            defer.resolveWith(elements, [elements]);
          }
        };

        if (typeof type !== "string") {
          obj = type;
          type = undefined;
        }

        type = type || "fx";

        while (i--) {
          tmp = dataPriv.get(elements[i], type + "queueHooks");

          if (tmp && tmp.empty) {
            count++;
            tmp.empty.add(resolve);
          }
        }

        resolve();
        return defer.promise(obj);
      }
    });
    var pnum = /[+-]?(?:\d*\.|)\d+(?:[eE][+-]?\d+|)/.source;
    var rcssNum = new RegExp("^(?:([+-])=|)(" + pnum + ")([a-z%]*)$", "i");
    var cssExpand = ["Top", "Right", "Bottom", "Left"];

    var isHiddenWithinTree = function (elem, el) {
      // isHiddenWithinTree might be called from jQuery#filter function;
      // in that case, element will be second argument
      elem = el || elem; // Inline style trumps all

      return elem.style.display === "none" || elem.style.display === "" && // Otherwise, check computed style
      // Support: Firefox <=43 - 45
      // Disconnected elements can have computed display: none, so first confirm that elem is
      // in the document.
      jQuery.contains(elem.ownerDocument, elem) && jQuery.css(elem, "display") === "none";
    };

    var swap = function (elem, options, callback, args) {
      var ret,
          name,
          old = {}; // Remember the old values, and insert the new ones

      for (name in options) {
        old[name] = elem.style[name];
        elem.style[name] = options[name];
      }

      ret = callback.apply(elem, args || []); // Revert the old values

      for (name in options) {
        elem.style[name] = old[name];
      }

      return ret;
    };

    function adjustCSS(elem, prop, valueParts, tween) {
      var adjusted,
          scale,
          maxIterations = 20,
          currentValue = tween ? function () {
        return tween.cur();
      } : function () {
        return jQuery.css(elem, prop, "");
      },
          initial = currentValue(),
          unit = valueParts && valueParts[3] || (jQuery.cssNumber[prop] ? "" : "px"),
          // Starting value computation is required for potential unit mismatches
      initialInUnit = (jQuery.cssNumber[prop] || unit !== "px" && +initial) && rcssNum.exec(jQuery.css(elem, prop));

      if (initialInUnit && initialInUnit[3] !== unit) {
        // Support: Firefox <=54
        // Halve the iteration target value to prevent interference from CSS upper bounds (gh-2144)
        initial = initial / 2; // Trust units reported by jQuery.css

        unit = unit || initialInUnit[3]; // Iteratively approximate from a nonzero starting point

        initialInUnit = +initial || 1;

        while (maxIterations--) {
          // Evaluate and update our best guess (doubling guesses that zero out).
          // Finish if the scale equals or crosses 1 (making the old*new product non-positive).
          jQuery.style(elem, prop, initialInUnit + unit);

          if ((1 - scale) * (1 - (scale = currentValue() / initial || 0.5)) <= 0) {
            maxIterations = 0;
          }

          initialInUnit = initialInUnit / scale;
        }

        initialInUnit = initialInUnit * 2;
        jQuery.style(elem, prop, initialInUnit + unit); // Make sure we update the tween properties later on

        valueParts = valueParts || [];
      }

      if (valueParts) {
        initialInUnit = +initialInUnit || +initial || 0; // Apply relative offset (+=/-=) if specified

        adjusted = valueParts[1] ? initialInUnit + (valueParts[1] + 1) * valueParts[2] : +valueParts[2];

        if (tween) {
          tween.unit = unit;
          tween.start = initialInUnit;
          tween.end = adjusted;
        }
      }

      return adjusted;
    }

    var defaultDisplayMap = {};

    function getDefaultDisplay(elem) {
      var temp,
          doc = elem.ownerDocument,
          nodeName = elem.nodeName,
          display = defaultDisplayMap[nodeName];

      if (display) {
        return display;
      }

      temp = doc.body.appendChild(doc.createElement(nodeName));
      display = jQuery.css(temp, "display");
      temp.parentNode.removeChild(temp);

      if (display === "none") {
        display = "block";
      }

      defaultDisplayMap[nodeName] = display;
      return display;
    }

    function showHide(elements, show) {
      var display,
          elem,
          values = [],
          index = 0,
          length = elements.length; // Determine new display value for elements that need to change

      for (; index < length; index++) {
        elem = elements[index];

        if (!elem.style) {
          continue;
        }

        display = elem.style.display;

        if (show) {
          // Since we force visibility upon cascade-hidden elements, an immediate (and slow)
          // check is required in this first loop unless we have a nonempty display value (either
          // inline or about-to-be-restored)
          if (display === "none") {
            values[index] = dataPriv.get(elem, "display") || null;

            if (!values[index]) {
              elem.style.display = "";
            }
          }

          if (elem.style.display === "" && isHiddenWithinTree(elem)) {
            values[index] = getDefaultDisplay(elem);
          }
        } else {
          if (display !== "none") {
            values[index] = "none"; // Remember what we're overwriting

            dataPriv.set(elem, "display", display);
          }
        }
      } // Set the display of the elements in a second loop to avoid constant reflow


      for (index = 0; index < length; index++) {
        if (values[index] != null) {
          elements[index].style.display = values[index];
        }
      }

      return elements;
    }

    jQuery.fn.extend({
      show: function () {
        return showHide(this, true);
      },
      hide: function () {
        return showHide(this);
      },
      toggle: function (state) {
        if (typeof state === "boolean") {
          return state ? this.show() : this.hide();
        }

        return this.each(function () {
          if (isHiddenWithinTree(this)) {
            jQuery(this).show();
          } else {
            jQuery(this).hide();
          }
        });
      }
    });
    var rcheckableType = /^(?:checkbox|radio)$/i;
    var rtagName = /<([a-z][^\/\0>\x20\t\r\n\f]+)/i;
    var rscriptType = /^$|^module$|\/(?:java|ecma)script/i; // We have to close these tags to support XHTML (#13200)

    var wrapMap = {
      // Support: IE <=9 only
      option: [1, "<select multiple='multiple'>", "</select>"],
      // XHTML parsers do not magically insert elements in the
      // same way that tag soup parsers do. So we cannot shorten
      // this by omitting <tbody> or other required elements.
      thead: [1, "<table>", "</table>"],
      col: [2, "<table><colgroup>", "</colgroup></table>"],
      tr: [2, "<table><tbody>", "</tbody></table>"],
      td: [3, "<table><tbody><tr>", "</tr></tbody></table>"],
      _default: [0, "", ""]
    }; // Support: IE <=9 only

    wrapMap.optgroup = wrapMap.option;
    wrapMap.tbody = wrapMap.tfoot = wrapMap.colgroup = wrapMap.caption = wrapMap.thead;
    wrapMap.th = wrapMap.td;

    function getAll(context, tag) {
      // Support: IE <=9 - 11 only
      // Use typeof to avoid zero-argument method invocation on host objects (#15151)
      var ret;

      if (typeof context.getElementsByTagName !== "undefined") {
        ret = context.getElementsByTagName(tag || "*");
      } else if (typeof context.querySelectorAll !== "undefined") {
        ret = context.querySelectorAll(tag || "*");
      } else {
        ret = [];
      }

      if (tag === undefined || tag && nodeName(context, tag)) {
        return jQuery.merge([context], ret);
      }

      return ret;
    } // Mark scripts as having already been evaluated


    function setGlobalEval(elems, refElements) {
      var i = 0,
          l = elems.length;

      for (; i < l; i++) {
        dataPriv.set(elems[i], "globalEval", !refElements || dataPriv.get(refElements[i], "globalEval"));
      }
    }

    var rhtml = /<|&#?\w+;/;

    function buildFragment(elems, context, scripts, selection, ignored) {
      var elem,
          tmp,
          tag,
          wrap,
          contains,
          j,
          fragment = context.createDocumentFragment(),
          nodes = [],
          i = 0,
          l = elems.length;

      for (; i < l; i++) {
        elem = elems[i];

        if (elem || elem === 0) {
          // Add nodes directly
          if (toType(elem) === "object") {
            // Support: Android <=4.0 only, PhantomJS 1 only
            // push.apply(_, arraylike) throws on ancient WebKit
            jQuery.merge(nodes, elem.nodeType ? [elem] : elem); // Convert non-html into a text node
          } else if (!rhtml.test(elem)) {
            nodes.push(context.createTextNode(elem)); // Convert html into DOM nodes
          } else {
            tmp = tmp || fragment.appendChild(context.createElement("div")); // Deserialize a standard representation

            tag = (rtagName.exec(elem) || ["", ""])[1].toLowerCase();
            wrap = wrapMap[tag] || wrapMap._default;
            tmp.innerHTML = wrap[1] + jQuery.htmlPrefilter(elem) + wrap[2]; // Descend through wrappers to the right content

            j = wrap[0];

            while (j--) {
              tmp = tmp.lastChild;
            } // Support: Android <=4.0 only, PhantomJS 1 only
            // push.apply(_, arraylike) throws on ancient WebKit


            jQuery.merge(nodes, tmp.childNodes); // Remember the top-level container

            tmp = fragment.firstChild; // Ensure the created nodes are orphaned (#12392)

            tmp.textContent = "";
          }
        }
      } // Remove wrapper from fragment


      fragment.textContent = "";
      i = 0;

      while (elem = nodes[i++]) {
        // Skip elements already in the context collection (trac-4087)
        if (selection && jQuery.inArray(elem, selection) > -1) {
          if (ignored) {
            ignored.push(elem);
          }

          continue;
        }

        contains = jQuery.contains(elem.ownerDocument, elem); // Append to fragment

        tmp = getAll(fragment.appendChild(elem), "script"); // Preserve script evaluation history

        if (contains) {
          setGlobalEval(tmp);
        } // Capture executables


        if (scripts) {
          j = 0;

          while (elem = tmp[j++]) {
            if (rscriptType.test(elem.type || "")) {
              scripts.push(elem);
            }
          }
        }
      }

      return fragment;
    }

    (function () {
      var fragment = document$2.createDocumentFragment(),
          div = fragment.appendChild(document$2.createElement("div")),
          input = document$2.createElement("input"); // Support: Android 4.0 - 4.3 only
      // Check state lost if the name is set (#11217)
      // Support: Windows Web Apps (WWA)
      // `name` and `type` must use .setAttribute for WWA (#14901)

      input.setAttribute("type", "radio");
      input.setAttribute("checked", "checked");
      input.setAttribute("name", "t");
      div.appendChild(input); // Support: Android <=4.1 only
      // Older WebKit doesn't clone checked state correctly in fragments

      support.checkClone = div.cloneNode(true).cloneNode(true).lastChild.checked; // Support: IE <=11 only
      // Make sure textarea (and checkbox) defaultValue is properly cloned

      div.innerHTML = "<textarea>x</textarea>";
      support.noCloneChecked = !!div.cloneNode(true).lastChild.defaultValue;
    })();

    var documentElement = document$2.documentElement;
    var rkeyEvent = /^key/,
        rmouseEvent = /^(?:mouse|pointer|contextmenu|drag|drop)|click/,
        rtypenamespace = /^([^.]*)(?:\.(.+)|)/;

    function returnTrue() {
      return true;
    }

    function returnFalse() {
      return false;
    } // Support: IE <=9 only
    // See #13393 for more info


    function safeActiveElement() {
      try {
        return document$2.activeElement;
      } catch (err) {}
    }

    function on(elem, types, selector, data, fn, one) {
      var origFn, type; // Types can be a map of types/handlers

      if (typeof types === "object") {
        // ( types-Object, selector, data )
        if (typeof selector !== "string") {
          // ( types-Object, data )
          data = data || selector;
          selector = undefined;
        }

        for (type in types) {
          on(elem, type, selector, data, types[type], one);
        }

        return elem;
      }

      if (data == null && fn == null) {
        // ( types, fn )
        fn = selector;
        data = selector = undefined;
      } else if (fn == null) {
        if (typeof selector === "string") {
          // ( types, selector, fn )
          fn = data;
          data = undefined;
        } else {
          // ( types, data, fn )
          fn = data;
          data = selector;
          selector = undefined;
        }
      }

      if (fn === false) {
        fn = returnFalse;
      } else if (!fn) {
        return elem;
      }

      if (one === 1) {
        origFn = fn;

        fn = function (event) {
          // Can use an empty set, since event contains the info
          jQuery().off(event);
          return origFn.apply(this, arguments);
        }; // Use same guid so caller can remove using origFn


        fn.guid = origFn.guid || (origFn.guid = jQuery.guid++);
      }

      return elem.each(function () {
        jQuery.event.add(this, types, fn, data, selector);
      });
    }
    /*
     * Helper functions for managing events -- not part of the public interface.
     * Props to Dean Edwards' addEvent library for many of the ideas.
     */


    jQuery.event = {
      global: {},
      add: function (elem, types, handler, data, selector) {
        var handleObjIn,
            eventHandle,
            tmp,
            events,
            t,
            handleObj,
            special,
            handlers,
            type,
            namespaces,
            origType,
            elemData = dataPriv.get(elem); // Don't attach events to noData or text/comment nodes (but allow plain objects)

        if (!elemData) {
          return;
        } // Caller can pass in an object of custom data in lieu of the handler


        if (handler.handler) {
          handleObjIn = handler;
          handler = handleObjIn.handler;
          selector = handleObjIn.selector;
        } // Ensure that invalid selectors throw exceptions at attach time
        // Evaluate against documentElement in case elem is a non-element node (e.g., document)


        if (selector) {
          jQuery.find.matchesSelector(documentElement, selector);
        } // Make sure that the handler has a unique ID, used to find/remove it later


        if (!handler.guid) {
          handler.guid = jQuery.guid++;
        } // Init the element's event structure and main handler, if this is the first


        if (!(events = elemData.events)) {
          events = elemData.events = {};
        }

        if (!(eventHandle = elemData.handle)) {
          eventHandle = elemData.handle = function (e) {
            // Discard the second event of a jQuery.event.trigger() and
            // when an event is called after a page has unloaded
            return typeof jQuery !== "undefined" && jQuery.event.triggered !== e.type ? jQuery.event.dispatch.apply(elem, arguments) : undefined;
          };
        } // Handle multiple events separated by a space


        types = (types || "").match(rnothtmlwhite) || [""];
        t = types.length;

        while (t--) {
          tmp = rtypenamespace.exec(types[t]) || [];
          type = origType = tmp[1];
          namespaces = (tmp[2] || "").split(".").sort(); // There *must* be a type, no attaching namespace-only handlers

          if (!type) {
            continue;
          } // If event changes its type, use the special event handlers for the changed type


          special = jQuery.event.special[type] || {}; // If selector defined, determine special event api type, otherwise given type

          type = (selector ? special.delegateType : special.bindType) || type; // Update special based on newly reset type

          special = jQuery.event.special[type] || {}; // handleObj is passed to all event handlers

          handleObj = jQuery.extend({
            type: type,
            origType: origType,
            data: data,
            handler: handler,
            guid: handler.guid,
            selector: selector,
            needsContext: selector && jQuery.expr.match.needsContext.test(selector),
            namespace: namespaces.join(".")
          }, handleObjIn); // Init the event handler queue if we're the first

          if (!(handlers = events[type])) {
            handlers = events[type] = [];
            handlers.delegateCount = 0; // Only use addEventListener if the special events handler returns false

            if (!special.setup || special.setup.call(elem, data, namespaces, eventHandle) === false) {
              if (elem.addEventListener) {
                elem.addEventListener(type, eventHandle);
              }
            }
          }

          if (special.add) {
            special.add.call(elem, handleObj);

            if (!handleObj.handler.guid) {
              handleObj.handler.guid = handler.guid;
            }
          } // Add to the element's handler list, delegates in front


          if (selector) {
            handlers.splice(handlers.delegateCount++, 0, handleObj);
          } else {
            handlers.push(handleObj);
          } // Keep track of which events have ever been used, for event optimization


          jQuery.event.global[type] = true;
        }
      },
      // Detach an event or set of events from an element
      remove: function (elem, types, handler, selector, mappedTypes) {
        var j,
            origCount,
            tmp,
            events,
            t,
            handleObj,
            special,
            handlers,
            type,
            namespaces,
            origType,
            elemData = dataPriv.hasData(elem) && dataPriv.get(elem);

        if (!elemData || !(events = elemData.events)) {
          return;
        } // Once for each type.namespace in types; type may be omitted


        types = (types || "").match(rnothtmlwhite) || [""];
        t = types.length;

        while (t--) {
          tmp = rtypenamespace.exec(types[t]) || [];
          type = origType = tmp[1];
          namespaces = (tmp[2] || "").split(".").sort(); // Unbind all events (on this namespace, if provided) for the element

          if (!type) {
            for (type in events) {
              jQuery.event.remove(elem, type + types[t], handler, selector, true);
            }

            continue;
          }

          special = jQuery.event.special[type] || {};
          type = (selector ? special.delegateType : special.bindType) || type;
          handlers = events[type] || [];
          tmp = tmp[2] && new RegExp("(^|\\.)" + namespaces.join("\\.(?:.*\\.|)") + "(\\.|$)"); // Remove matching events

          origCount = j = handlers.length;

          while (j--) {
            handleObj = handlers[j];

            if ((mappedTypes || origType === handleObj.origType) && (!handler || handler.guid === handleObj.guid) && (!tmp || tmp.test(handleObj.namespace)) && (!selector || selector === handleObj.selector || selector === "**" && handleObj.selector)) {
              handlers.splice(j, 1);

              if (handleObj.selector) {
                handlers.delegateCount--;
              }

              if (special.remove) {
                special.remove.call(elem, handleObj);
              }
            }
          } // Remove generic event handler if we removed something and no more handlers exist
          // (avoids potential for endless recursion during removal of special event handlers)


          if (origCount && !handlers.length) {
            if (!special.teardown || special.teardown.call(elem, namespaces, elemData.handle) === false) {
              jQuery.removeEvent(elem, type, elemData.handle);
            }

            delete events[type];
          }
        } // Remove data and the expando if it's no longer used


        if (jQuery.isEmptyObject(events)) {
          dataPriv.remove(elem, "handle events");
        }
      },
      dispatch: function (nativeEvent) {
        // Make a writable jQuery.Event from the native event object
        var event = jQuery.event.fix(nativeEvent);
        var i,
            j,
            ret,
            matched,
            handleObj,
            handlerQueue,
            args = new Array(arguments.length),
            handlers = (dataPriv.get(this, "events") || {})[event.type] || [],
            special = jQuery.event.special[event.type] || {}; // Use the fix-ed jQuery.Event rather than the (read-only) native event

        args[0] = event;

        for (i = 1; i < arguments.length; i++) {
          args[i] = arguments[i];
        }

        event.delegateTarget = this; // Call the preDispatch hook for the mapped type, and let it bail if desired

        if (special.preDispatch && special.preDispatch.call(this, event) === false) {
          return;
        } // Determine handlers


        handlerQueue = jQuery.event.handlers.call(this, event, handlers); // Run delegates first; they may want to stop propagation beneath us

        i = 0;

        while ((matched = handlerQueue[i++]) && !event.isPropagationStopped()) {
          event.currentTarget = matched.elem;
          j = 0;

          while ((handleObj = matched.handlers[j++]) && !event.isImmediatePropagationStopped()) {
            // Triggered event must either 1) have no namespace, or 2) have namespace(s)
            // a subset or equal to those in the bound event (both can have no namespace).
            if (!event.rnamespace || event.rnamespace.test(handleObj.namespace)) {
              event.handleObj = handleObj;
              event.data = handleObj.data;
              ret = ((jQuery.event.special[handleObj.origType] || {}).handle || handleObj.handler).apply(matched.elem, args);

              if (ret !== undefined) {
                if ((event.result = ret) === false) {
                  event.preventDefault();
                  event.stopPropagation();
                }
              }
            }
          }
        } // Call the postDispatch hook for the mapped type


        if (special.postDispatch) {
          special.postDispatch.call(this, event);
        }

        return event.result;
      },
      handlers: function (event, handlers) {
        var i,
            handleObj,
            sel,
            matchedHandlers,
            matchedSelectors,
            handlerQueue = [],
            delegateCount = handlers.delegateCount,
            cur = event.target; // Find delegate handlers

        if (delegateCount && // Support: IE <=9
        // Black-hole SVG <use> instance trees (trac-13180)
        cur.nodeType && // Support: Firefox <=42
        // Suppress spec-violating clicks indicating a non-primary pointer button (trac-3861)
        // https://www.w3.org/TR/DOM-Level-3-Events/#event-type-click
        // Support: IE 11 only
        // ...but not arrow key "clicks" of radio inputs, which can have `button` -1 (gh-2343)
        !(event.type === "click" && event.button >= 1)) {
          for (; cur !== this; cur = cur.parentNode || this) {
            // Don't check non-elements (#13208)
            // Don't process clicks on disabled elements (#6911, #8165, #11382, #11764)
            if (cur.nodeType === 1 && !(event.type === "click" && cur.disabled === true)) {
              matchedHandlers = [];
              matchedSelectors = {};

              for (i = 0; i < delegateCount; i++) {
                handleObj = handlers[i]; // Don't conflict with Object.prototype properties (#13203)

                sel = handleObj.selector + " ";

                if (matchedSelectors[sel] === undefined) {
                  matchedSelectors[sel] = handleObj.needsContext ? jQuery(sel, this).index(cur) > -1 : jQuery.find(sel, this, null, [cur]).length;
                }

                if (matchedSelectors[sel]) {
                  matchedHandlers.push(handleObj);
                }
              }

              if (matchedHandlers.length) {
                handlerQueue.push({
                  elem: cur,
                  handlers: matchedHandlers
                });
              }
            }
          }
        } // Add the remaining (directly-bound) handlers


        cur = this;

        if (delegateCount < handlers.length) {
          handlerQueue.push({
            elem: cur,
            handlers: handlers.slice(delegateCount)
          });
        }

        return handlerQueue;
      },
      addProp: function (name, hook) {
        Object.defineProperty(jQuery.Event.prototype, name, {
          enumerable: true,
          configurable: true,
          get: isFunction(hook) ? function () {
            if (this.originalEvent) {
              return hook(this.originalEvent);
            }
          } : function () {
            if (this.originalEvent) {
              return this.originalEvent[name];
            }
          },
          set: function (value) {
            Object.defineProperty(this, name, {
              enumerable: true,
              configurable: true,
              writable: true,
              value: value
            });
          }
        });
      },
      fix: function (originalEvent) {
        return originalEvent[jQuery.expando] ? originalEvent : new jQuery.Event(originalEvent);
      },
      special: {
        load: {
          // Prevent triggered image.load events from bubbling to window.load
          noBubble: true
        },
        focus: {
          // Fire native event if possible so blur/focus sequence is correct
          trigger: function () {
            if (this !== safeActiveElement() && this.focus) {
              this.focus();
              return false;
            }
          },
          delegateType: "focusin"
        },
        blur: {
          trigger: function () {
            if (this === safeActiveElement() && this.blur) {
              this.blur();
              return false;
            }
          },
          delegateType: "focusout"
        },
        click: {
          // For checkbox, fire native event so checked state will be right
          trigger: function () {
            if (this.type === "checkbox" && this.click && nodeName(this, "input")) {
              this.click();
              return false;
            }
          },
          // For cross-browser consistency, don't fire native .click() on links
          _default: function (event) {
            return nodeName(event.target, "a");
          }
        },
        beforeunload: {
          postDispatch: function (event) {
            // Support: Firefox 20+
            // Firefox doesn't alert if the returnValue field is not set.
            if (event.result !== undefined && event.originalEvent) {
              event.originalEvent.returnValue = event.result;
            }
          }
        }
      }
    };

    jQuery.removeEvent = function (elem, type, handle) {
      // This "if" is needed for plain objects
      if (elem.removeEventListener) {
        elem.removeEventListener(type, handle);
      }
    };

    jQuery.Event = function (src, props) {
      // Allow instantiation without the 'new' keyword
      if (!(this instanceof jQuery.Event)) {
        return new jQuery.Event(src, props);
      } // Event object


      if (src && src.type) {
        this.originalEvent = src;
        this.type = src.type; // Events bubbling up the document may have been marked as prevented
        // by a handler lower down the tree; reflect the correct value.

        this.isDefaultPrevented = src.defaultPrevented || src.defaultPrevented === undefined && // Support: Android <=2.3 only
        src.returnValue === false ? returnTrue : returnFalse; // Create target properties
        // Support: Safari <=6 - 7 only
        // Target should not be a text node (#504, #13143)

        this.target = src.target && src.target.nodeType === 3 ? src.target.parentNode : src.target;
        this.currentTarget = src.currentTarget;
        this.relatedTarget = src.relatedTarget; // Event type
      } else {
        this.type = src;
      } // Put explicitly provided properties onto the event object


      if (props) {
        jQuery.extend(this, props);
      } // Create a timestamp if incoming event doesn't have one


      this.timeStamp = src && src.timeStamp || Date.now(); // Mark it as fixed

      this[jQuery.expando] = true;
    }; // jQuery.Event is based on DOM3 Events as specified by the ECMAScript Language Binding
    // https://www.w3.org/TR/2003/WD-DOM-Level-3-Events-20030331/ecma-script-binding.html


    jQuery.Event.prototype = {
      constructor: jQuery.Event,
      isDefaultPrevented: returnFalse,
      isPropagationStopped: returnFalse,
      isImmediatePropagationStopped: returnFalse,
      isSimulated: false,
      preventDefault: function () {
        var e = this.originalEvent;
        this.isDefaultPrevented = returnTrue;

        if (e && !this.isSimulated) {
          e.preventDefault();
        }
      },
      stopPropagation: function () {
        var e = this.originalEvent;
        this.isPropagationStopped = returnTrue;

        if (e && !this.isSimulated) {
          e.stopPropagation();
        }
      },
      stopImmediatePropagation: function () {
        var e = this.originalEvent;
        this.isImmediatePropagationStopped = returnTrue;

        if (e && !this.isSimulated) {
          e.stopImmediatePropagation();
        }

        this.stopPropagation();
      }
    }; // Includes all common event props including KeyEvent and MouseEvent specific props

    jQuery.each({
      altKey: true,
      bubbles: true,
      cancelable: true,
      changedTouches: true,
      ctrlKey: true,
      detail: true,
      eventPhase: true,
      metaKey: true,
      pageX: true,
      pageY: true,
      shiftKey: true,
      view: true,
      "char": true,
      charCode: true,
      key: true,
      keyCode: true,
      button: true,
      buttons: true,
      clientX: true,
      clientY: true,
      offsetX: true,
      offsetY: true,
      pointerId: true,
      pointerType: true,
      screenX: true,
      screenY: true,
      targetTouches: true,
      toElement: true,
      touches: true,
      which: function (event) {
        var button = event.button; // Add which for key events

        if (event.which == null && rkeyEvent.test(event.type)) {
          return event.charCode != null ? event.charCode : event.keyCode;
        } // Add which for click: 1 === left; 2 === middle; 3 === right


        if (!event.which && button !== undefined && rmouseEvent.test(event.type)) {
          if (button & 1) {
            return 1;
          }

          if (button & 2) {
            return 3;
          }

          if (button & 4) {
            return 2;
          }

          return 0;
        }

        return event.which;
      }
    }, jQuery.event.addProp); // Create mouseenter/leave events using mouseover/out and event-time checks
    // so that event delegation works in jQuery.
    // Do the same for pointerenter/pointerleave and pointerover/pointerout
    //
    // Support: Safari 7 only
    // Safari sends mouseenter too often; see:
    // https://bugs.chromium.org/p/chromium/issues/detail?id=470258
    // for the description of the bug (it existed in older Chrome versions as well).

    jQuery.each({
      mouseenter: "mouseover",
      mouseleave: "mouseout",
      pointerenter: "pointerover",
      pointerleave: "pointerout"
    }, function (orig, fix) {
      jQuery.event.special[orig] = {
        delegateType: fix,
        bindType: fix,
        handle: function (event) {
          var ret,
              target = this,
              related = event.relatedTarget,
              handleObj = event.handleObj; // For mouseenter/leave call the handler if related is outside the target.
          // NB: No relatedTarget if the mouse left/entered the browser window

          if (!related || related !== target && !jQuery.contains(target, related)) {
            event.type = handleObj.origType;
            ret = handleObj.handler.apply(this, arguments);
            event.type = fix;
          }

          return ret;
        }
      };
    });
    jQuery.fn.extend({
      on: function (types, selector, data, fn) {
        return on(this, types, selector, data, fn);
      },
      one: function (types, selector, data, fn) {
        return on(this, types, selector, data, fn, 1);
      },
      off: function (types, selector, fn) {
        var handleObj, type;

        if (types && types.preventDefault && types.handleObj) {
          // ( event )  dispatched jQuery.Event
          handleObj = types.handleObj;
          jQuery(types.delegateTarget).off(handleObj.namespace ? handleObj.origType + "." + handleObj.namespace : handleObj.origType, handleObj.selector, handleObj.handler);
          return this;
        }

        if (typeof types === "object") {
          // ( types-object [, selector] )
          for (type in types) {
            this.off(type, selector, types[type]);
          }

          return this;
        }

        if (selector === false || typeof selector === "function") {
          // ( types [, fn] )
          fn = selector;
          selector = undefined;
        }

        if (fn === false) {
          fn = returnFalse;
        }

        return this.each(function () {
          jQuery.event.remove(this, types, fn, selector);
        });
      }
    });
    var
    /* eslint-disable max-len */
    // See https://github.com/eslint/eslint/issues/3229
    rxhtmlTag = /<(?!area|br|col|embed|hr|img|input|link|meta|param)(([a-z][^\/\0>\x20\t\r\n\f]*)[^>]*)\/>/gi,

    /* eslint-enable */
    // Support: IE <=10 - 11, Edge 12 - 13 only
    // In IE/Edge using regex groups here causes severe slowdowns.
    // See https://connect.microsoft.com/IE/feedback/details/1736512/
    rnoInnerhtml = /<script|<style|<link/i,
        // checked="checked" or checked
    rchecked = /checked\s*(?:[^=]|=\s*.checked.)/i,
        rcleanScript = /^\s*<!(?:\[CDATA\[|--)|(?:\]\]|--)>\s*$/g; // Prefer a tbody over its parent table for containing new rows

    function manipulationTarget(elem, content) {
      if (nodeName(elem, "table") && nodeName(content.nodeType !== 11 ? content : content.firstChild, "tr")) {
        return jQuery(elem).children("tbody")[0] || elem;
      }

      return elem;
    } // Replace/restore the type attribute of script elements for safe DOM manipulation


    function disableScript(elem) {
      elem.type = (elem.getAttribute("type") !== null) + "/" + elem.type;
      return elem;
    }

    function restoreScript(elem) {
      if ((elem.type || "").slice(0, 5) === "true/") {
        elem.type = elem.type.slice(5);
      } else {
        elem.removeAttribute("type");
      }

      return elem;
    }

    function cloneCopyEvent(src, dest) {
      var i, l, type, pdataOld, pdataCur, udataOld, udataCur, events;

      if (dest.nodeType !== 1) {
        return;
      } // 1. Copy private data: events, handlers, etc.


      if (dataPriv.hasData(src)) {
        pdataOld = dataPriv.access(src);
        pdataCur = dataPriv.set(dest, pdataOld);
        events = pdataOld.events;

        if (events) {
          delete pdataCur.handle;
          pdataCur.events = {};

          for (type in events) {
            for (i = 0, l = events[type].length; i < l; i++) {
              jQuery.event.add(dest, type, events[type][i]);
            }
          }
        }
      } // 2. Copy user data


      if (dataUser.hasData(src)) {
        udataOld = dataUser.access(src);
        udataCur = jQuery.extend({}, udataOld);
        dataUser.set(dest, udataCur);
      }
    } // Fix IE bugs, see support tests


    function fixInput(src, dest) {
      var nodeName = dest.nodeName.toLowerCase(); // Fails to persist the checked state of a cloned checkbox or radio button.

      if (nodeName === "input" && rcheckableType.test(src.type)) {
        dest.checked = src.checked; // Fails to return the selected option to the default selected state when cloning options
      } else if (nodeName === "input" || nodeName === "textarea") {
        dest.defaultValue = src.defaultValue;
      }
    }

    function domManip(collection, args, callback, ignored) {
      // Flatten any nested arrays
      args = concat$1.apply([], args);
      var fragment,
          first,
          scripts,
          hasScripts,
          node,
          doc,
          i = 0,
          l = collection.length,
          iNoClone = l - 1,
          value = args[0],
          valueIsFunction = isFunction(value); // We can't cloneNode fragments that contain checked, in WebKit

      if (valueIsFunction || l > 1 && typeof value === "string" && !support.checkClone && rchecked.test(value)) {
        return collection.each(function (index) {
          var self = collection.eq(index);

          if (valueIsFunction) {
            args[0] = value.call(this, index, self.html());
          }

          domManip(self, args, callback, ignored);
        });
      }

      if (l) {
        fragment = buildFragment(args, collection[0].ownerDocument, false, collection, ignored);
        first = fragment.firstChild;

        if (fragment.childNodes.length === 1) {
          fragment = first;
        } // Require either new content or an interest in ignored elements to invoke the callback


        if (first || ignored) {
          scripts = jQuery.map(getAll(fragment, "script"), disableScript);
          hasScripts = scripts.length; // Use the original fragment for the last item
          // instead of the first because it can end up
          // being emptied incorrectly in certain situations (#8070).

          for (; i < l; i++) {
            node = fragment;

            if (i !== iNoClone) {
              node = jQuery.clone(node, true, true); // Keep references to cloned scripts for later restoration

              if (hasScripts) {
                // Support: Android <=4.0 only, PhantomJS 1 only
                // push.apply(_, arraylike) throws on ancient WebKit
                jQuery.merge(scripts, getAll(node, "script"));
              }
            }

            callback.call(collection[i], node, i);
          }

          if (hasScripts) {
            doc = scripts[scripts.length - 1].ownerDocument; // Reenable scripts

            jQuery.map(scripts, restoreScript); // Evaluate executable scripts on first document insertion

            for (i = 0; i < hasScripts; i++) {
              node = scripts[i];

              if (rscriptType.test(node.type || "") && !dataPriv.access(node, "globalEval") && jQuery.contains(doc, node)) {
                if (node.src && (node.type || "").toLowerCase() !== "module") {
                  // Optional AJAX dependency, but won't run scripts if not present
                  if (jQuery._evalUrl) {
                    jQuery._evalUrl(node.src);
                  }
                } else {
                  DOMEval(node.textContent.replace(rcleanScript, ""), doc, node);
                }
              }
            }
          }
        }
      }

      return collection;
    }

    function remove(elem, selector, keepData) {
      var node,
          nodes = selector ? jQuery.filter(selector, elem) : elem,
          i = 0;

      for (; (node = nodes[i]) != null; i++) {
        if (!keepData && node.nodeType === 1) {
          jQuery.cleanData(getAll(node));
        }

        if (node.parentNode) {
          if (keepData && jQuery.contains(node.ownerDocument, node)) {
            setGlobalEval(getAll(node, "script"));
          }

          node.parentNode.removeChild(node);
        }
      }

      return elem;
    }

    jQuery.extend({
      htmlPrefilter: function (html) {
        return html.replace(rxhtmlTag, "<$1></$2>");
      },
      clone: function (elem, dataAndEvents, deepDataAndEvents) {
        var i,
            l,
            srcElements,
            destElements,
            clone = elem.cloneNode(true),
            inPage = jQuery.contains(elem.ownerDocument, elem); // Fix IE cloning issues

        if (!support.noCloneChecked && (elem.nodeType === 1 || elem.nodeType === 11) && !jQuery.isXMLDoc(elem)) {
          // We eschew Sizzle here for performance reasons: https://jsperf.com/getall-vs-sizzle/2
          destElements = getAll(clone);
          srcElements = getAll(elem);

          for (i = 0, l = srcElements.length; i < l; i++) {
            fixInput(srcElements[i], destElements[i]);
          }
        } // Copy the events from the original to the clone


        if (dataAndEvents) {
          if (deepDataAndEvents) {
            srcElements = srcElements || getAll(elem);
            destElements = destElements || getAll(clone);

            for (i = 0, l = srcElements.length; i < l; i++) {
              cloneCopyEvent(srcElements[i], destElements[i]);
            }
          } else {
            cloneCopyEvent(elem, clone);
          }
        } // Preserve script evaluation history


        destElements = getAll(clone, "script");

        if (destElements.length > 0) {
          setGlobalEval(destElements, !inPage && getAll(elem, "script"));
        } // Return the cloned set


        return clone;
      },
      cleanData: function (elems) {
        var data,
            elem,
            type,
            special = jQuery.event.special,
            i = 0;

        for (; (elem = elems[i]) !== undefined; i++) {
          if (acceptData(elem)) {
            if (data = elem[dataPriv.expando]) {
              if (data.events) {
                for (type in data.events) {
                  if (special[type]) {
                    jQuery.event.remove(elem, type); // This is a shortcut to avoid jQuery.event.remove's overhead
                  } else {
                    jQuery.removeEvent(elem, type, data.handle);
                  }
                }
              } // Support: Chrome <=35 - 45+
              // Assign undefined instead of using delete, see Data#remove


              elem[dataPriv.expando] = undefined;
            }

            if (elem[dataUser.expando]) {
              // Support: Chrome <=35 - 45+
              // Assign undefined instead of using delete, see Data#remove
              elem[dataUser.expando] = undefined;
            }
          }
        }
      }
    });
    jQuery.fn.extend({
      detach: function (selector) {
        return remove(this, selector, true);
      },
      remove: function (selector) {
        return remove(this, selector);
      },
      text: function (value) {
        return access(this, function (value) {
          return value === undefined ? jQuery.text(this) : this.empty().each(function () {
            if (this.nodeType === 1 || this.nodeType === 11 || this.nodeType === 9) {
              this.textContent = value;
            }
          });
        }, null, value, arguments.length);
      },
      append: function () {
        return domManip(this, arguments, function (elem) {
          if (this.nodeType === 1 || this.nodeType === 11 || this.nodeType === 9) {
            var target = manipulationTarget(this, elem);
            target.appendChild(elem);
          }
        });
      },
      prepend: function () {
        return domManip(this, arguments, function (elem) {
          if (this.nodeType === 1 || this.nodeType === 11 || this.nodeType === 9) {
            var target = manipulationTarget(this, elem);
            target.insertBefore(elem, target.firstChild);
          }
        });
      },
      before: function () {
        return domManip(this, arguments, function (elem) {
          if (this.parentNode) {
            this.parentNode.insertBefore(elem, this);
          }
        });
      },
      after: function () {
        return domManip(this, arguments, function (elem) {
          if (this.parentNode) {
            this.parentNode.insertBefore(elem, this.nextSibling);
          }
        });
      },
      empty: function () {
        var elem,
            i = 0;

        for (; (elem = this[i]) != null; i++) {
          if (elem.nodeType === 1) {
            // Prevent memory leaks
            jQuery.cleanData(getAll(elem, false)); // Remove any remaining nodes

            elem.textContent = "";
          }
        }

        return this;
      },
      clone: function (dataAndEvents, deepDataAndEvents) {
        dataAndEvents = dataAndEvents == null ? false : dataAndEvents;
        deepDataAndEvents = deepDataAndEvents == null ? dataAndEvents : deepDataAndEvents;
        return this.map(function () {
          return jQuery.clone(this, dataAndEvents, deepDataAndEvents);
        });
      },
      html: function (value) {
        return access(this, function (value) {
          var elem = this[0] || {},
              i = 0,
              l = this.length;

          if (value === undefined && elem.nodeType === 1) {
            return elem.innerHTML;
          } // See if we can take a shortcut and just use innerHTML


          if (typeof value === "string" && !rnoInnerhtml.test(value) && !wrapMap[(rtagName.exec(value) || ["", ""])[1].toLowerCase()]) {
            value = jQuery.htmlPrefilter(value);

            try {
              for (; i < l; i++) {
                elem = this[i] || {}; // Remove element nodes and prevent memory leaks

                if (elem.nodeType === 1) {
                  jQuery.cleanData(getAll(elem, false));
                  elem.innerHTML = value;
                }
              }

              elem = 0; // If using innerHTML throws an exception, use the fallback method
            } catch (e) {}
          }

          if (elem) {
            this.empty().append(value);
          }
        }, null, value, arguments.length);
      },
      replaceWith: function () {
        var ignored = []; // Make the changes, replacing each non-ignored context element with the new content

        return domManip(this, arguments, function (elem) {
          var parent = this.parentNode;

          if (jQuery.inArray(this, ignored) < 0) {
            jQuery.cleanData(getAll(this));

            if (parent) {
              parent.replaceChild(elem, this);
            }
          } // Force callback invocation

        }, ignored);
      }
    });
    jQuery.each({
      appendTo: "append",
      prependTo: "prepend",
      insertBefore: "before",
      insertAfter: "after",
      replaceAll: "replaceWith"
    }, function (name, original) {
      jQuery.fn[name] = function (selector) {
        var elems,
            ret = [],
            insert = jQuery(selector),
            last = insert.length - 1,
            i = 0;

        for (; i <= last; i++) {
          elems = i === last ? this : this.clone(true);
          jQuery(insert[i])[original](elems); // Support: Android <=4.0 only, PhantomJS 1 only
          // .get() because push.apply(_, arraylike) throws on ancient WebKit

          push$1.apply(ret, elems.get());
        }

        return this.pushStack(ret);
      };
    });
    var rnumnonpx = new RegExp("^(" + pnum + ")(?!px)[a-z%]+$", "i");

    var getStyles = function (elem) {
      // Support: IE <=11 only, Firefox <=30 (#15098, #14150)
      // IE throws on elements created in popups
      // FF meanwhile throws on frame elements through "defaultView.getComputedStyle"
      var view = elem.ownerDocument.defaultView;

      if (!view || !view.opener) {
        view = window;
      }

      return view.getComputedStyle(elem);
    };

    var rboxStyle = new RegExp(cssExpand.join("|"), "i");

    (function () {
      // Executing both pixelPosition & boxSizingReliable tests require only one layout
      // so they're executed at the same time to save the second computation.
      function computeStyleTests() {
        // This is a singleton, we need to execute it only once
        if (!div) {
          return;
        }

        container.style.cssText = "position:absolute;left:-11111px;width:60px;" + "margin-top:1px;padding:0;border:0";
        div.style.cssText = "position:relative;display:block;box-sizing:border-box;overflow:scroll;" + "margin:auto;border:1px;padding:1px;" + "width:60%;top:1%";
        documentElement.appendChild(container).appendChild(div);
        var divStyle = window.getComputedStyle(div);
        pixelPositionVal = divStyle.top !== "1%"; // Support: Android 4.0 - 4.3 only, Firefox <=3 - 44

        reliableMarginLeftVal = roundPixelMeasures(divStyle.marginLeft) === 12; // Support: Android 4.0 - 4.3 only, Safari <=9.1 - 10.1, iOS <=7.0 - 9.3
        // Some styles come back with percentage values, even though they shouldn't

        div.style.right = "60%";
        pixelBoxStylesVal = roundPixelMeasures(divStyle.right) === 36; // Support: IE 9 - 11 only
        // Detect misreporting of content dimensions for box-sizing:border-box elements

        boxSizingReliableVal = roundPixelMeasures(divStyle.width) === 36; // Support: IE 9 only
        // Detect overflow:scroll screwiness (gh-3699)

        div.style.position = "absolute";
        scrollboxSizeVal = div.offsetWidth === 36 || "absolute";
        documentElement.removeChild(container); // Nullify the div so it wouldn't be stored in the memory and
        // it will also be a sign that checks already performed

        div = null;
      }

      function roundPixelMeasures(measure) {
        return Math.round(parseFloat(measure));
      }

      var pixelPositionVal,
          boxSizingReliableVal,
          scrollboxSizeVal,
          pixelBoxStylesVal,
          reliableMarginLeftVal,
          container = document$2.createElement("div"),
          div = document$2.createElement("div"); // Finish early in limited (non-browser) environments

      if (!div.style) {
        return;
      } // Support: IE <=9 - 11 only
      // Style of cloned element affects source element cloned (#8908)


      div.style.backgroundClip = "content-box";
      div.cloneNode(true).style.backgroundClip = "";
      support.clearCloneStyle = div.style.backgroundClip === "content-box";
      jQuery.extend(support, {
        boxSizingReliable: function () {
          computeStyleTests();
          return boxSizingReliableVal;
        },
        pixelBoxStyles: function () {
          computeStyleTests();
          return pixelBoxStylesVal;
        },
        pixelPosition: function () {
          computeStyleTests();
          return pixelPositionVal;
        },
        reliableMarginLeft: function () {
          computeStyleTests();
          return reliableMarginLeftVal;
        },
        scrollboxSize: function () {
          computeStyleTests();
          return scrollboxSizeVal;
        }
      });
    })();

    function curCSS(elem, name, computed) {
      var width,
          minWidth,
          maxWidth,
          ret,
          // Support: Firefox 51+
      // Retrieving style before computed somehow
      // fixes an issue with getting wrong values
      // on detached elements
      style = elem.style;
      computed = computed || getStyles(elem); // getPropertyValue is needed for:
      //   .css('filter') (IE 9 only, #12537)
      //   .css('--customProperty) (#3144)

      if (computed) {
        ret = computed.getPropertyValue(name) || computed[name];

        if (ret === "" && !jQuery.contains(elem.ownerDocument, elem)) {
          ret = jQuery.style(elem, name);
        } // A tribute to the "awesome hack by Dean Edwards"
        // Android Browser returns percentage for some values,
        // but width seems to be reliably pixels.
        // This is against the CSSOM draft spec:
        // https://drafts.csswg.org/cssom/#resolved-values


        if (!support.pixelBoxStyles() && rnumnonpx.test(ret) && rboxStyle.test(name)) {
          // Remember the original values
          width = style.width;
          minWidth = style.minWidth;
          maxWidth = style.maxWidth; // Put in the new values to get a computed value out

          style.minWidth = style.maxWidth = style.width = ret;
          ret = computed.width; // Revert the changed values

          style.width = width;
          style.minWidth = minWidth;
          style.maxWidth = maxWidth;
        }
      }

      return ret !== undefined ? // Support: IE <=9 - 11 only
      // IE returns zIndex value as an integer.
      ret + "" : ret;
    }

    function addGetHookIf(conditionFn, hookFn) {
      // Define the hook, we'll check on the first run if it's really needed.
      return {
        get: function () {
          if (conditionFn()) {
            // Hook not needed (or it's not possible to use it due
            // to missing dependency), remove it.
            delete this.get;
            return;
          } // Hook needed; redefine it so that the support test is not executed again.


          return (this.get = hookFn).apply(this, arguments);
        }
      };
    }

    var // Swappable if display is none or starts with table
    // except "table", "table-cell", or "table-caption"
    // See here for display values: https://developer.mozilla.org/en-US/docs/CSS/display
    rdisplayswap = /^(none|table(?!-c[ea]).+)/,
        rcustomProp = /^--/,
        cssShow = {
      position: "absolute",
      visibility: "hidden",
      display: "block"
    },
        cssNormalTransform = {
      letterSpacing: "0",
      fontWeight: "400"
    },
        cssPrefixes = ["Webkit", "Moz", "ms"],
        emptyStyle = document$2.createElement("div").style; // Return a css property mapped to a potentially vendor prefixed property

    function vendorPropName(name) {
      // Shortcut for names that are not vendor prefixed
      if (name in emptyStyle) {
        return name;
      } // Check for vendor prefixed names


      var capName = name[0].toUpperCase() + name.slice(1),
          i = cssPrefixes.length;

      while (i--) {
        name = cssPrefixes[i] + capName;

        if (name in emptyStyle) {
          return name;
        }
      }
    } // Return a property mapped along what jQuery.cssProps suggests or to
    // a vendor prefixed property.


    function finalPropName(name) {
      var ret = jQuery.cssProps[name];

      if (!ret) {
        ret = jQuery.cssProps[name] = vendorPropName(name) || name;
      }

      return ret;
    }

    function setPositiveNumber(elem, value, subtract) {
      // Any relative (+/-) values have already been
      // normalized at this point
      var matches = rcssNum.exec(value);
      return matches ? // Guard against undefined "subtract", e.g., when used as in cssHooks
      Math.max(0, matches[2] - (subtract || 0)) + (matches[3] || "px") : value;
    }

    function boxModelAdjustment(elem, dimension, box, isBorderBox, styles, computedVal) {
      var i = dimension === "width" ? 1 : 0,
          extra = 0,
          delta = 0; // Adjustment may not be necessary

      if (box === (isBorderBox ? "border" : "content")) {
        return 0;
      }

      for (; i < 4; i += 2) {
        // Both box models exclude margin
        if (box === "margin") {
          delta += jQuery.css(elem, box + cssExpand[i], true, styles);
        } // If we get here with a content-box, we're seeking "padding" or "border" or "margin"


        if (!isBorderBox) {
          // Add padding
          delta += jQuery.css(elem, "padding" + cssExpand[i], true, styles); // For "border" or "margin", add border

          if (box !== "padding") {
            delta += jQuery.css(elem, "border" + cssExpand[i] + "Width", true, styles); // But still keep track of it otherwise
          } else {
            extra += jQuery.css(elem, "border" + cssExpand[i] + "Width", true, styles);
          } // If we get here with a border-box (content + padding + border), we're seeking "content" or
          // "padding" or "margin"

        } else {
          // For "content", subtract padding
          if (box === "content") {
            delta -= jQuery.css(elem, "padding" + cssExpand[i], true, styles);
          } // For "content" or "padding", subtract border


          if (box !== "margin") {
            delta -= jQuery.css(elem, "border" + cssExpand[i] + "Width", true, styles);
          }
        }
      } // Account for positive content-box scroll gutter when requested by providing computedVal


      if (!isBorderBox && computedVal >= 0) {
        // offsetWidth/offsetHeight is a rounded sum of content, padding, scroll gutter, and border
        // Assuming integer scroll gutter, subtract the rest and round down
        delta += Math.max(0, Math.ceil(elem["offset" + dimension[0].toUpperCase() + dimension.slice(1)] - computedVal - delta - extra - 0.5));
      }

      return delta;
    }

    function getWidthOrHeight(elem, dimension, extra) {
      // Start with computed style
      var styles = getStyles(elem),
          val = curCSS(elem, dimension, styles),
          isBorderBox = jQuery.css(elem, "boxSizing", false, styles) === "border-box",
          valueIsBorderBox = isBorderBox; // Support: Firefox <=54
      // Return a confounding non-pixel value or feign ignorance, as appropriate.

      if (rnumnonpx.test(val)) {
        if (!extra) {
          return val;
        }

        val = "auto";
      } // Check for style in case a browser which returns unreliable values
      // for getComputedStyle silently falls back to the reliable elem.style


      valueIsBorderBox = valueIsBorderBox && (support.boxSizingReliable() || val === elem.style[dimension]); // Fall back to offsetWidth/offsetHeight when value is "auto"
      // This happens for inline elements with no explicit setting (gh-3571)
      // Support: Android <=4.1 - 4.3 only
      // Also use offsetWidth/offsetHeight for misreported inline dimensions (gh-3602)

      if (val === "auto" || !parseFloat(val) && jQuery.css(elem, "display", false, styles) === "inline") {
        val = elem["offset" + dimension[0].toUpperCase() + dimension.slice(1)]; // offsetWidth/offsetHeight provide border-box values

        valueIsBorderBox = true;
      } // Normalize "" and auto


      val = parseFloat(val) || 0; // Adjust for the element's box model

      return val + boxModelAdjustment(elem, dimension, extra || (isBorderBox ? "border" : "content"), valueIsBorderBox, styles, // Provide the current computed size to request scroll gutter calculation (gh-3589)
      val) + "px";
    }

    jQuery.extend({
      // Add in style property hooks for overriding the default
      // behavior of getting and setting a style property
      cssHooks: {
        opacity: {
          get: function (elem, computed) {
            if (computed) {
              // We should always get a number back from opacity
              var ret = curCSS(elem, "opacity");
              return ret === "" ? "1" : ret;
            }
          }
        }
      },
      // Don't automatically add "px" to these possibly-unitless properties
      cssNumber: {
        "animationIterationCount": true,
        "columnCount": true,
        "fillOpacity": true,
        "flexGrow": true,
        "flexShrink": true,
        "fontWeight": true,
        "lineHeight": true,
        "opacity": true,
        "order": true,
        "orphans": true,
        "widows": true,
        "zIndex": true,
        "zoom": true
      },
      // Add in properties whose names you wish to fix before
      // setting or getting the value
      cssProps: {},
      // Get and set the style property on a DOM Node
      style: function (elem, name, value, extra) {
        // Don't set styles on text and comment nodes
        if (!elem || elem.nodeType === 3 || elem.nodeType === 8 || !elem.style) {
          return;
        } // Make sure that we're working with the right name


        var ret,
            type,
            hooks,
            origName = camelCase(name),
            isCustomProp = rcustomProp.test(name),
            style = elem.style; // Make sure that we're working with the right name. We don't
        // want to query the value if it is a CSS custom property
        // since they are user-defined.

        if (!isCustomProp) {
          name = finalPropName(origName);
        } // Gets hook for the prefixed version, then unprefixed version


        hooks = jQuery.cssHooks[name] || jQuery.cssHooks[origName]; // Check if we're setting a value

        if (value !== undefined) {
          type = typeof value; // Convert "+=" or "-=" to relative numbers (#7345)

          if (type === "string" && (ret = rcssNum.exec(value)) && ret[1]) {
            value = adjustCSS(elem, name, ret); // Fixes bug #9237

            type = "number";
          } // Make sure that null and NaN values aren't set (#7116)


          if (value == null || value !== value) {
            return;
          } // If a number was passed in, add the unit (except for certain CSS properties)


          if (type === "number") {
            value += ret && ret[3] || (jQuery.cssNumber[origName] ? "" : "px");
          } // background-* props affect original clone's values


          if (!support.clearCloneStyle && value === "" && name.indexOf("background") === 0) {
            style[name] = "inherit";
          } // If a hook was provided, use that value, otherwise just set the specified value


          if (!hooks || !("set" in hooks) || (value = hooks.set(elem, value, extra)) !== undefined) {
            if (isCustomProp) {
              style.setProperty(name, value);
            } else {
              style[name] = value;
            }
          }
        } else {
          // If a hook was provided get the non-computed value from there
          if (hooks && "get" in hooks && (ret = hooks.get(elem, false, extra)) !== undefined) {
            return ret;
          } // Otherwise just get the value from the style object


          return style[name];
        }
      },
      css: function (elem, name, extra, styles) {
        var val,
            num,
            hooks,
            origName = camelCase(name),
            isCustomProp = rcustomProp.test(name); // Make sure that we're working with the right name. We don't
        // want to modify the value if it is a CSS custom property
        // since they are user-defined.

        if (!isCustomProp) {
          name = finalPropName(origName);
        } // Try prefixed name followed by the unprefixed name


        hooks = jQuery.cssHooks[name] || jQuery.cssHooks[origName]; // If a hook was provided get the computed value from there

        if (hooks && "get" in hooks) {
          val = hooks.get(elem, true, extra);
        } // Otherwise, if a way to get the computed value exists, use that


        if (val === undefined) {
          val = curCSS(elem, name, styles);
        } // Convert "normal" to computed value


        if (val === "normal" && name in cssNormalTransform) {
          val = cssNormalTransform[name];
        } // Make numeric if forced or a qualifier was provided and val looks numeric


        if (extra === "" || extra) {
          num = parseFloat(val);
          return extra === true || isFinite(num) ? num || 0 : val;
        }

        return val;
      }
    });
    jQuery.each(["height", "width"], function (i, dimension) {
      jQuery.cssHooks[dimension] = {
        get: function (elem, computed, extra) {
          if (computed) {
            // Certain elements can have dimension info if we invisibly show them
            // but it must have a current display style that would benefit
            return rdisplayswap.test(jQuery.css(elem, "display")) && ( // Support: Safari 8+
            // Table columns in Safari have non-zero offsetWidth & zero
            // getBoundingClientRect().width unless display is changed.
            // Support: IE <=11 only
            // Running getBoundingClientRect on a disconnected node
            // in IE throws an error.
            !elem.getClientRects().length || !elem.getBoundingClientRect().width) ? swap(elem, cssShow, function () {
              return getWidthOrHeight(elem, dimension, extra);
            }) : getWidthOrHeight(elem, dimension, extra);
          }
        },
        set: function (elem, value, extra) {
          var matches,
              styles = getStyles(elem),
              isBorderBox = jQuery.css(elem, "boxSizing", false, styles) === "border-box",
              subtract = extra && boxModelAdjustment(elem, dimension, extra, isBorderBox, styles); // Account for unreliable border-box dimensions by comparing offset* to computed and
          // faking a content-box to get border and padding (gh-3699)

          if (isBorderBox && support.scrollboxSize() === styles.position) {
            subtract -= Math.ceil(elem["offset" + dimension[0].toUpperCase() + dimension.slice(1)] - parseFloat(styles[dimension]) - boxModelAdjustment(elem, dimension, "border", false, styles) - 0.5);
          } // Convert to pixels if value adjustment is needed


          if (subtract && (matches = rcssNum.exec(value)) && (matches[3] || "px") !== "px") {
            elem.style[dimension] = value;
            value = jQuery.css(elem, dimension);
          }

          return setPositiveNumber(elem, value, subtract);
        }
      };
    });
    jQuery.cssHooks.marginLeft = addGetHookIf(support.reliableMarginLeft, function (elem, computed) {
      if (computed) {
        return (parseFloat(curCSS(elem, "marginLeft")) || elem.getBoundingClientRect().left - swap(elem, {
          marginLeft: 0
        }, function () {
          return elem.getBoundingClientRect().left;
        })) + "px";
      }
    }); // These hooks are used by animate to expand properties

    jQuery.each({
      margin: "",
      padding: "",
      border: "Width"
    }, function (prefix, suffix) {
      jQuery.cssHooks[prefix + suffix] = {
        expand: function (value) {
          var i = 0,
              expanded = {},
              // Assumes a single number if not a string
          parts = typeof value === "string" ? value.split(" ") : [value];

          for (; i < 4; i++) {
            expanded[prefix + cssExpand[i] + suffix] = parts[i] || parts[i - 2] || parts[0];
          }

          return expanded;
        }
      };

      if (prefix !== "margin") {
        jQuery.cssHooks[prefix + suffix].set = setPositiveNumber;
      }
    });
    jQuery.fn.extend({
      css: function (name, value) {
        return access(this, function (elem, name, value) {
          var styles,
              len,
              map = {},
              i = 0;

          if (Array.isArray(name)) {
            styles = getStyles(elem);
            len = name.length;

            for (; i < len; i++) {
              map[name[i]] = jQuery.css(elem, name[i], false, styles);
            }

            return map;
          }

          return value !== undefined ? jQuery.style(elem, name, value) : jQuery.css(elem, name);
        }, name, value, arguments.length > 1);
      }
    }); // Based off of the plugin by Clint Helfers, with permission.
    // https://web.archive.org/web/20100324014747/http://blindsignals.com/index.php/2009/07/jquery-delay/

    jQuery.fn.delay = function (time, type) {
      time = jQuery.fx ? jQuery.fx.speeds[time] || time : time;
      type = type || "fx";
      return this.queue(type, function (next, hooks) {
        var timeout = window.setTimeout(next, time);

        hooks.stop = function () {
          window.clearTimeout(timeout);
        };
      });
    };

    (function () {
      var input = document$2.createElement("input"),
          select = document$2.createElement("select"),
          opt = select.appendChild(document$2.createElement("option"));
      input.type = "checkbox"; // Support: Android <=4.3 only
      // Default value for a checkbox should be "on"

      support.checkOn = input.value !== ""; // Support: IE <=11 only
      // Must access selectedIndex to make default options select

      support.optSelected = opt.selected; // Support: IE <=11 only
      // An input loses its value after becoming a radio

      input = document$2.createElement("input");
      input.value = "t";
      input.type = "radio";
      support.radioValue = input.value === "t";
    })();

    var boolHook,
        attrHandle = jQuery.expr.attrHandle;
    jQuery.fn.extend({
      attr: function (name, value) {
        return access(this, jQuery.attr, name, value, arguments.length > 1);
      },
      removeAttr: function (name) {
        return this.each(function () {
          jQuery.removeAttr(this, name);
        });
      }
    });
    jQuery.extend({
      attr: function (elem, name, value) {
        var ret,
            hooks,
            nType = elem.nodeType; // Don't get/set attributes on text, comment and attribute nodes

        if (nType === 3 || nType === 8 || nType === 2) {
          return;
        } // Fallback to prop when attributes are not supported


        if (typeof elem.getAttribute === "undefined") {
          return jQuery.prop(elem, name, value);
        } // Attribute hooks are determined by the lowercase version
        // Grab necessary hook if one is defined


        if (nType !== 1 || !jQuery.isXMLDoc(elem)) {
          hooks = jQuery.attrHooks[name.toLowerCase()] || (jQuery.expr.match.bool.test(name) ? boolHook : undefined);
        }

        if (value !== undefined) {
          if (value === null) {
            jQuery.removeAttr(elem, name);
            return;
          }

          if (hooks && "set" in hooks && (ret = hooks.set(elem, value, name)) !== undefined) {
            return ret;
          }

          elem.setAttribute(name, value + "");
          return value;
        }

        if (hooks && "get" in hooks && (ret = hooks.get(elem, name)) !== null) {
          return ret;
        }

        ret = jQuery.find.attr(elem, name); // Non-existent attributes return null, we normalize to undefined

        return ret == null ? undefined : ret;
      },
      attrHooks: {
        type: {
          set: function (elem, value) {
            if (!support.radioValue && value === "radio" && nodeName(elem, "input")) {
              var val = elem.value;
              elem.setAttribute("type", value);

              if (val) {
                elem.value = val;
              }

              return value;
            }
          }
        }
      },
      removeAttr: function (elem, value) {
        var name,
            i = 0,
            // Attribute names can contain non-HTML whitespace characters
        // https://html.spec.whatwg.org/multipage/syntax.html#attributes-2
        attrNames = value && value.match(rnothtmlwhite);

        if (attrNames && elem.nodeType === 1) {
          while (name = attrNames[i++]) {
            elem.removeAttribute(name);
          }
        }
      }
    }); // Hooks for boolean attributes

    boolHook = {
      set: function (elem, value, name) {
        if (value === false) {
          // Remove boolean attributes when set to false
          jQuery.removeAttr(elem, name);
        } else {
          elem.setAttribute(name, name);
        }

        return name;
      }
    };
    jQuery.each(jQuery.expr.match.bool.source.match(/\w+/g), function (i, name) {
      var getter = attrHandle[name] || jQuery.find.attr;

      attrHandle[name] = function (elem, name, isXML) {
        var ret,
            handle,
            lowercaseName = name.toLowerCase();

        if (!isXML) {
          // Avoid an infinite loop by temporarily removing this function from the getter
          handle = attrHandle[lowercaseName];
          attrHandle[lowercaseName] = ret;
          ret = getter(elem, name, isXML) != null ? lowercaseName : null;
          attrHandle[lowercaseName] = handle;
        }

        return ret;
      };
    });
    var rfocusable = /^(?:input|select|textarea|button)$/i,
        rclickable = /^(?:a|area)$/i;
    jQuery.fn.extend({
      prop: function (name, value) {
        return access(this, jQuery.prop, name, value, arguments.length > 1);
      },
      removeProp: function (name) {
        return this.each(function () {
          delete this[jQuery.propFix[name] || name];
        });
      }
    });
    jQuery.extend({
      prop: function (elem, name, value) {
        var ret,
            hooks,
            nType = elem.nodeType; // Don't get/set properties on text, comment and attribute nodes

        if (nType === 3 || nType === 8 || nType === 2) {
          return;
        }

        if (nType !== 1 || !jQuery.isXMLDoc(elem)) {
          // Fix name and attach hooks
          name = jQuery.propFix[name] || name;
          hooks = jQuery.propHooks[name];
        }

        if (value !== undefined) {
          if (hooks && "set" in hooks && (ret = hooks.set(elem, value, name)) !== undefined) {
            return ret;
          }

          return elem[name] = value;
        }

        if (hooks && "get" in hooks && (ret = hooks.get(elem, name)) !== null) {
          return ret;
        }

        return elem[name];
      },
      propHooks: {
        tabIndex: {
          get: function (elem) {
            // Support: IE <=9 - 11 only
            // elem.tabIndex doesn't always return the
            // correct value when it hasn't been explicitly set
            // https://web.archive.org/web/20141116233347/http://fluidproject.org/blog/2008/01/09/getting-setting-and-removing-tabindex-values-with-javascript/
            // Use proper attribute retrieval(#12072)
            var tabindex = jQuery.find.attr(elem, "tabindex");

            if (tabindex) {
              return parseInt(tabindex, 10);
            }

            if (rfocusable.test(elem.nodeName) || rclickable.test(elem.nodeName) && elem.href) {
              return 0;
            }

            return -1;
          }
        }
      },
      propFix: {
        "for": "htmlFor",
        "class": "className"
      }
    }); // Support: IE <=11 only
    // Accessing the selectedIndex property
    // forces the browser to respect setting selected
    // on the option
    // The getter ensures a default option is selected
    // when in an optgroup
    // eslint rule "no-unused-expressions" is disabled for this code
    // since it considers such accessions noop

    if (!support.optSelected) {
      jQuery.propHooks.selected = {
        get: function (elem) {
          /* eslint no-unused-expressions: "off" */
          var parent = elem.parentNode;

          if (parent && parent.parentNode) {
            parent.parentNode.selectedIndex;
          }

          return null;
        },
        set: function (elem) {
          /* eslint no-unused-expressions: "off" */
          var parent = elem.parentNode;

          if (parent) {
            parent.selectedIndex;

            if (parent.parentNode) {
              parent.parentNode.selectedIndex;
            }
          }
        }
      };
    }

    jQuery.each(["tabIndex", "readOnly", "maxLength", "cellSpacing", "cellPadding", "rowSpan", "colSpan", "useMap", "frameBorder", "contentEditable"], function () {
      jQuery.propFix[this.toLowerCase()] = this;
    }); // Strip and collapse whitespace according to HTML spec
    // https://infra.spec.whatwg.org/#strip-and-collapse-ascii-whitespace

    function stripAndCollapse(value) {
      var tokens = value.match(rnothtmlwhite) || [];
      return tokens.join(" ");
    }

    function getClass(elem) {
      return elem.getAttribute && elem.getAttribute("class") || "";
    }

    function classesToArray(value) {
      if (Array.isArray(value)) {
        return value;
      }

      if (typeof value === "string") {
        return value.match(rnothtmlwhite) || [];
      }

      return [];
    }

    jQuery.fn.extend({
      addClass: function (value) {
        var classes,
            elem,
            cur,
            curValue,
            clazz,
            j,
            finalValue,
            i = 0;

        if (isFunction(value)) {
          return this.each(function (j) {
            jQuery(this).addClass(value.call(this, j, getClass(this)));
          });
        }

        classes = classesToArray(value);

        if (classes.length) {
          while (elem = this[i++]) {
            curValue = getClass(elem);
            cur = elem.nodeType === 1 && " " + stripAndCollapse(curValue) + " ";

            if (cur) {
              j = 0;

              while (clazz = classes[j++]) {
                if (cur.indexOf(" " + clazz + " ") < 0) {
                  cur += clazz + " ";
                }
              } // Only assign if different to avoid unneeded rendering.


              finalValue = stripAndCollapse(cur);

              if (curValue !== finalValue) {
                elem.setAttribute("class", finalValue);
              }
            }
          }
        }

        return this;
      },
      removeClass: function (value) {
        var classes,
            elem,
            cur,
            curValue,
            clazz,
            j,
            finalValue,
            i = 0;

        if (isFunction(value)) {
          return this.each(function (j) {
            jQuery(this).removeClass(value.call(this, j, getClass(this)));
          });
        }

        if (!arguments.length) {
          return this.attr("class", "");
        }

        classes = classesToArray(value);

        if (classes.length) {
          while (elem = this[i++]) {
            curValue = getClass(elem); // This expression is here for better compressibility (see addClass)

            cur = elem.nodeType === 1 && " " + stripAndCollapse(curValue) + " ";

            if (cur) {
              j = 0;

              while (clazz = classes[j++]) {
                // Remove *all* instances
                while (cur.indexOf(" " + clazz + " ") > -1) {
                  cur = cur.replace(" " + clazz + " ", " ");
                }
              } // Only assign if different to avoid unneeded rendering.


              finalValue = stripAndCollapse(cur);

              if (curValue !== finalValue) {
                elem.setAttribute("class", finalValue);
              }
            }
          }
        }

        return this;
      },
      toggleClass: function (value, stateVal) {
        var type = typeof value,
            isValidValue = type === "string" || Array.isArray(value);

        if (typeof stateVal === "boolean" && isValidValue) {
          return stateVal ? this.addClass(value) : this.removeClass(value);
        }

        if (isFunction(value)) {
          return this.each(function (i) {
            jQuery(this).toggleClass(value.call(this, i, getClass(this), stateVal), stateVal);
          });
        }

        return this.each(function () {
          var className, i, self, classNames;

          if (isValidValue) {
            // Toggle individual class names
            i = 0;
            self = jQuery(this);
            classNames = classesToArray(value);

            while (className = classNames[i++]) {
              // Check each className given, space separated list
              if (self.hasClass(className)) {
                self.removeClass(className);
              } else {
                self.addClass(className);
              }
            } // Toggle whole class name

          } else if (value === undefined || type === "boolean") {
            className = getClass(this);

            if (className) {
              // Store className if set
              dataPriv.set(this, "__className__", className);
            } // If the element has a class name or if we're passed `false`,
            // then remove the whole classname (if there was one, the above saved it).
            // Otherwise bring back whatever was previously saved (if anything),
            // falling back to the empty string if nothing was stored.


            if (this.setAttribute) {
              this.setAttribute("class", className || value === false ? "" : dataPriv.get(this, "__className__") || "");
            }
          }
        });
      },
      hasClass: function (selector) {
        var className,
            elem,
            i = 0;
        className = " " + selector + " ";

        while (elem = this[i++]) {
          if (elem.nodeType === 1 && (" " + stripAndCollapse(getClass(elem)) + " ").indexOf(className) > -1) {
            return true;
          }
        }

        return false;
      }
    });
    var rreturn = /\r/g;
    jQuery.fn.extend({
      val: function (value) {
        var hooks,
            ret,
            valueIsFunction,
            elem = this[0];

        if (!arguments.length) {
          if (elem) {
            hooks = jQuery.valHooks[elem.type] || jQuery.valHooks[elem.nodeName.toLowerCase()];

            if (hooks && "get" in hooks && (ret = hooks.get(elem, "value")) !== undefined) {
              return ret;
            }

            ret = elem.value; // Handle most common string cases

            if (typeof ret === "string") {
              return ret.replace(rreturn, "");
            } // Handle cases where value is null/undef or number


            return ret == null ? "" : ret;
          }

          return;
        }

        valueIsFunction = isFunction(value);
        return this.each(function (i) {
          var val;

          if (this.nodeType !== 1) {
            return;
          }

          if (valueIsFunction) {
            val = value.call(this, i, jQuery(this).val());
          } else {
            val = value;
          } // Treat null/undefined as ""; convert numbers to string


          if (val == null) {
            val = "";
          } else if (typeof val === "number") {
            val += "";
          } else if (Array.isArray(val)) {
            val = jQuery.map(val, function (value) {
              return value == null ? "" : value + "";
            });
          }

          hooks = jQuery.valHooks[this.type] || jQuery.valHooks[this.nodeName.toLowerCase()]; // If set returns undefined, fall back to normal setting

          if (!hooks || !("set" in hooks) || hooks.set(this, val, "value") === undefined) {
            this.value = val;
          }
        });
      }
    });
    jQuery.extend({
      valHooks: {
        option: {
          get: function (elem) {
            var val = jQuery.find.attr(elem, "value");
            return val != null ? val : // Support: IE <=10 - 11 only
            // option.text throws exceptions (#14686, #14858)
            // Strip and collapse whitespace
            // https://html.spec.whatwg.org/#strip-and-collapse-whitespace
            stripAndCollapse(jQuery.text(elem));
          }
        },
        select: {
          get: function (elem) {
            var value,
                option,
                i,
                options = elem.options,
                index = elem.selectedIndex,
                one = elem.type === "select-one",
                values = one ? null : [],
                max = one ? index + 1 : options.length;

            if (index < 0) {
              i = max;
            } else {
              i = one ? index : 0;
            } // Loop through all the selected options


            for (; i < max; i++) {
              option = options[i]; // Support: IE <=9 only
              // IE8-9 doesn't update selected after form reset (#2551)

              if ((option.selected || i === index) && // Don't return options that are disabled or in a disabled optgroup
              !option.disabled && (!option.parentNode.disabled || !nodeName(option.parentNode, "optgroup"))) {
                // Get the specific value for the option
                value = jQuery(option).val(); // We don't need an array for one selects

                if (one) {
                  return value;
                } // Multi-Selects return an array


                values.push(value);
              }
            }

            return values;
          },
          set: function (elem, value) {
            var optionSet,
                option,
                options = elem.options,
                values = jQuery.makeArray(value),
                i = options.length;

            while (i--) {
              option = options[i];
              /* eslint-disable no-cond-assign */

              if (option.selected = jQuery.inArray(jQuery.valHooks.option.get(option), values) > -1) {
                optionSet = true;
              }
              /* eslint-enable no-cond-assign */

            } // Force browsers to behave consistently when non-matching value is set


            if (!optionSet) {
              elem.selectedIndex = -1;
            }

            return values;
          }
        }
      }
    }); // Radios and checkboxes getter/setter

    jQuery.each(["radio", "checkbox"], function () {
      jQuery.valHooks[this] = {
        set: function (elem, value) {
          if (Array.isArray(value)) {
            return elem.checked = jQuery.inArray(jQuery(elem).val(), value) > -1;
          }
        }
      };

      if (!support.checkOn) {
        jQuery.valHooks[this].get = function (elem) {
          return elem.getAttribute("value") === null ? "on" : elem.value;
        };
      }
    }); // Return jQuery for attributes-only inclusion

    support.focusin = "onfocusin" in window;

    var rfocusMorph = /^(?:focusinfocus|focusoutblur)$/,
        stopPropagationCallback = function (e) {
      e.stopPropagation();
    };

    jQuery.extend(jQuery.event, {
      trigger: function (event, data, elem, onlyHandlers) {
        var i,
            cur,
            tmp,
            bubbleType,
            ontype,
            handle,
            special,
            lastElement,
            eventPath = [elem || document$2],
            type = hasOwn.call(event, "type") ? event.type : event,
            namespaces = hasOwn.call(event, "namespace") ? event.namespace.split(".") : [];
        cur = lastElement = tmp = elem = elem || document$2; // Don't do events on text and comment nodes

        if (elem.nodeType === 3 || elem.nodeType === 8) {
          return;
        } // focus/blur morphs to focusin/out; ensure we're not firing them right now


        if (rfocusMorph.test(type + jQuery.event.triggered)) {
          return;
        }

        if (type.indexOf(".") > -1) {
          // Namespaced trigger; create a regexp to match event type in handle()
          namespaces = type.split(".");
          type = namespaces.shift();
          namespaces.sort();
        }

        ontype = type.indexOf(":") < 0 && "on" + type; // Caller can pass in a jQuery.Event object, Object, or just an event type string

        event = event[jQuery.expando] ? event : new jQuery.Event(type, typeof event === "object" && event); // Trigger bitmask: & 1 for native handlers; & 2 for jQuery (always true)

        event.isTrigger = onlyHandlers ? 2 : 3;
        event.namespace = namespaces.join(".");
        event.rnamespace = event.namespace ? new RegExp("(^|\\.)" + namespaces.join("\\.(?:.*\\.|)") + "(\\.|$)") : null; // Clean up the event in case it is being reused

        event.result = undefined;

        if (!event.target) {
          event.target = elem;
        } // Clone any incoming data and prepend the event, creating the handler arg list


        data = data == null ? [event] : jQuery.makeArray(data, [event]); // Allow special events to draw outside the lines

        special = jQuery.event.special[type] || {};

        if (!onlyHandlers && special.trigger && special.trigger.apply(elem, data) === false) {
          return;
        } // Determine event propagation path in advance, per W3C events spec (#9951)
        // Bubble up to document, then to window; watch for a global ownerDocument var (#9724)


        if (!onlyHandlers && !special.noBubble && !isWindow(elem)) {
          bubbleType = special.delegateType || type;

          if (!rfocusMorph.test(bubbleType + type)) {
            cur = cur.parentNode;
          }

          for (; cur; cur = cur.parentNode) {
            eventPath.push(cur);
            tmp = cur;
          } // Only add window if we got to document (e.g., not plain obj or detached DOM)


          if (tmp === (elem.ownerDocument || document$2)) {
            eventPath.push(tmp.defaultView || tmp.parentWindow || window);
          }
        } // Fire handlers on the event path


        i = 0;

        while ((cur = eventPath[i++]) && !event.isPropagationStopped()) {
          lastElement = cur;
          event.type = i > 1 ? bubbleType : special.bindType || type; // jQuery handler

          handle = (dataPriv.get(cur, "events") || {})[event.type] && dataPriv.get(cur, "handle");

          if (handle) {
            handle.apply(cur, data);
          } // Native handler


          handle = ontype && cur[ontype];

          if (handle && handle.apply && acceptData(cur)) {
            event.result = handle.apply(cur, data);

            if (event.result === false) {
              event.preventDefault();
            }
          }
        }

        event.type = type; // If nobody prevented the default action, do it now

        if (!onlyHandlers && !event.isDefaultPrevented()) {
          if ((!special._default || special._default.apply(eventPath.pop(), data) === false) && acceptData(elem)) {
            // Call a native DOM method on the target with the same name as the event.
            // Don't do default actions on window, that's where global variables be (#6170)
            if (ontype && isFunction(elem[type]) && !isWindow(elem)) {
              // Don't re-trigger an onFOO event when we call its FOO() method
              tmp = elem[ontype];

              if (tmp) {
                elem[ontype] = null;
              } // Prevent re-triggering of the same event, since we already bubbled it above


              jQuery.event.triggered = type;

              if (event.isPropagationStopped()) {
                lastElement.addEventListener(type, stopPropagationCallback);
              }

              elem[type]();

              if (event.isPropagationStopped()) {
                lastElement.removeEventListener(type, stopPropagationCallback);
              }

              jQuery.event.triggered = undefined;

              if (tmp) {
                elem[ontype] = tmp;
              }
            }
          }
        }

        return event.result;
      },
      // Piggyback on a donor event to simulate a different one
      // Used only for `focus(in | out)` events
      simulate: function (type, elem, event) {
        var e = jQuery.extend(new jQuery.Event(), event, {
          type: type,
          isSimulated: true
        });
        jQuery.event.trigger(e, null, elem);
      }
    });
    jQuery.fn.extend({
      trigger: function (type, data) {
        return this.each(function () {
          jQuery.event.trigger(type, data, this);
        });
      },
      triggerHandler: function (type, data) {
        var elem = this[0];

        if (elem) {
          return jQuery.event.trigger(type, data, elem, true);
        }
      }
    }); // Support: Firefox <=44
    // Firefox doesn't have focus(in | out) events
    // Related ticket - https://bugzilla.mozilla.org/show_bug.cgi?id=687787
    //
    // Support: Chrome <=48 - 49, Safari <=9.0 - 9.1
    // focus(in | out) events fire after focus & blur events,
    // which is spec violation - http://www.w3.org/TR/DOM-Level-3-Events/#events-focusevent-event-order
    // Related ticket - https://bugs.chromium.org/p/chromium/issues/detail?id=449857

    if (!support.focusin) {
      jQuery.each({
        focus: "focusin",
        blur: "focusout"
      }, function (orig, fix) {
        // Attach a single capturing handler on the document while someone wants focusin/focusout
        var handler = function (event) {
          jQuery.event.simulate(fix, event.target, jQuery.event.fix(event));
        };

        jQuery.event.special[fix] = {
          setup: function () {
            var doc = this.ownerDocument || this,
                attaches = dataPriv.access(doc, fix);

            if (!attaches) {
              doc.addEventListener(orig, handler, true);
            }

            dataPriv.access(doc, fix, (attaches || 0) + 1);
          },
          teardown: function () {
            var doc = this.ownerDocument || this,
                attaches = dataPriv.access(doc, fix) - 1;

            if (!attaches) {
              doc.removeEventListener(orig, handler, true);
              dataPriv.remove(doc, fix);
            } else {
              dataPriv.access(doc, fix, attaches);
            }
          }
        };
      });
    }

    var rbracket = /\[\]$/,
        rCRLF = /\r?\n/g,
        rsubmitterTypes = /^(?:submit|button|image|reset|file)$/i,
        rsubmittable = /^(?:input|select|textarea|keygen)/i;

    function buildParams(prefix, obj, traditional, add) {
      var name;

      if (Array.isArray(obj)) {
        // Serialize array item.
        jQuery.each(obj, function (i, v) {
          if (traditional || rbracket.test(prefix)) {
            // Treat each array item as a scalar.
            add(prefix, v);
          } else {
            // Item is non-scalar (array or object), encode its numeric index.
            buildParams(prefix + "[" + (typeof v === "object" && v != null ? i : "") + "]", v, traditional, add);
          }
        });
      } else if (!traditional && toType(obj) === "object") {
        // Serialize object item.
        for (name in obj) {
          buildParams(prefix + "[" + name + "]", obj[name], traditional, add);
        }
      } else {
        // Serialize scalar item.
        add(prefix, obj);
      }
    } // Serialize an array of form elements or a set of
    // key/values into a query string


    jQuery.param = function (a, traditional) {
      var prefix,
          s = [],
          add = function (key, valueOrFunction) {
        // If value is a function, invoke it and use its return value
        var value = isFunction(valueOrFunction) ? valueOrFunction() : valueOrFunction;
        s[s.length] = encodeURIComponent(key) + "=" + encodeURIComponent(value == null ? "" : value);
      }; // If an array was passed in, assume that it is an array of form elements.


      if (Array.isArray(a) || a.jquery && !jQuery.isPlainObject(a)) {
        // Serialize the form elements
        jQuery.each(a, function () {
          add(this.name, this.value);
        });
      } else {
        // If traditional, encode the "old" way (the way 1.3.2 or older
        // did it), otherwise encode params recursively.
        for (prefix in a) {
          buildParams(prefix, a[prefix], traditional, add);
        }
      } // Return the resulting serialization


      return s.join("&");
    };

    jQuery.fn.extend({
      serialize: function () {
        return jQuery.param(this.serializeArray());
      },
      serializeArray: function () {
        return this.map(function () {
          // Can add propHook for "elements" to filter or add form elements
          var elements = jQuery.prop(this, "elements");
          return elements ? jQuery.makeArray(elements) : this;
        }).filter(function () {
          var type = this.type; // Use .is( ":disabled" ) so that fieldset[disabled] works

          return this.name && !jQuery(this).is(":disabled") && rsubmittable.test(this.nodeName) && !rsubmitterTypes.test(type) && (this.checked || !rcheckableType.test(type));
        }).map(function (i, elem) {
          var val = jQuery(this).val();

          if (val == null) {
            return null;
          }

          if (Array.isArray(val)) {
            return jQuery.map(val, function (val) {
              return {
                name: elem.name,
                value: val.replace(rCRLF, "\r\n")
              };
            });
          }

          return {
            name: elem.name,
            value: val.replace(rCRLF, "\r\n")
          };
        }).get();
      }
    });
    jQuery.fn.extend({
      wrapAll: function (html) {
        var wrap;

        if (this[0]) {
          if (isFunction(html)) {
            html = html.call(this[0]);
          } // The elements to wrap the target around


          wrap = jQuery(html, this[0].ownerDocument).eq(0).clone(true);

          if (this[0].parentNode) {
            wrap.insertBefore(this[0]);
          }

          wrap.map(function () {
            var elem = this;

            while (elem.firstElementChild) {
              elem = elem.firstElementChild;
            }

            return elem;
          }).append(this);
        }

        return this;
      },
      wrapInner: function (html) {
        if (isFunction(html)) {
          return this.each(function (i) {
            jQuery(this).wrapInner(html.call(this, i));
          });
        }

        return this.each(function () {
          var self = jQuery(this),
              contents = self.contents();

          if (contents.length) {
            contents.wrapAll(html);
          } else {
            self.append(html);
          }
        });
      },
      wrap: function (html) {
        var htmlIsFunction = isFunction(html);
        return this.each(function (i) {
          jQuery(this).wrapAll(htmlIsFunction ? html.call(this, i) : html);
        });
      },
      unwrap: function (selector) {
        this.parent(selector).not("body").each(function () {
          jQuery(this).replaceWith(this.childNodes);
        });
        return this;
      }
    });

    jQuery.expr.pseudos.hidden = function (elem) {
      return !jQuery.expr.pseudos.visible(elem);
    };

    jQuery.expr.pseudos.visible = function (elem) {
      return !!(elem.offsetWidth || elem.offsetHeight || elem.getClientRects().length);
    }; // Support: Safari 8 only
    // In Safari 8 documents created via document.implementation.createHTMLDocument
    // collapse sibling forms: the second one becomes a child of the first one.
    // Because of that, this security measure has to be disabled in Safari 8.
    // https://bugs.webkit.org/show_bug.cgi?id=137337


    support.createHTMLDocument = function () {
      var body = document$2.implementation.createHTMLDocument("").body;
      body.innerHTML = "<form></form><form></form>";
      return body.childNodes.length === 2;
    }(); // Argument "data" should be string of html
    // context (optional): If specified, the fragment will be created in this context,
    // defaults to document
    // keepScripts (optional): If true, will include scripts passed in the html string


    jQuery.parseHTML = function (data, context, keepScripts) {
      if (typeof data !== "string") {
        return [];
      }

      if (typeof context === "boolean") {
        keepScripts = context;
        context = false;
      }

      var base, parsed, scripts;

      if (!context) {
        // Stop scripts or inline event handlers from being executed immediately
        // by using document.implementation
        if (support.createHTMLDocument) {
          context = document$2.implementation.createHTMLDocument(""); // Set the base href for the created document
          // so any parsed elements with URLs
          // are based on the document's URL (gh-2965)

          base = context.createElement("base");
          base.href = document$2.location.href;
          context.head.appendChild(base);
        } else {
          context = document$2;
        }
      }

      parsed = rsingleTag.exec(data);
      scripts = !keepScripts && []; // Single tag

      if (parsed) {
        return [context.createElement(parsed[1])];
      }

      parsed = buildFragment([data], context, scripts);

      if (scripts && scripts.length) {
        jQuery(scripts).remove();
      }

      return jQuery.merge([], parsed.childNodes);
    };

    jQuery.offset = {
      setOffset: function (elem, options, i) {
        var curPosition,
            curLeft,
            curCSSTop,
            curTop,
            curOffset,
            curCSSLeft,
            calculatePosition,
            position = jQuery.css(elem, "position"),
            curElem = jQuery(elem),
            props = {}; // Set position first, in-case top/left are set even on static elem

        if (position === "static") {
          elem.style.position = "relative";
        }

        curOffset = curElem.offset();
        curCSSTop = jQuery.css(elem, "top");
        curCSSLeft = jQuery.css(elem, "left");
        calculatePosition = (position === "absolute" || position === "fixed") && (curCSSTop + curCSSLeft).indexOf("auto") > -1; // Need to be able to calculate position if either
        // top or left is auto and position is either absolute or fixed

        if (calculatePosition) {
          curPosition = curElem.position();
          curTop = curPosition.top;
          curLeft = curPosition.left;
        } else {
          curTop = parseFloat(curCSSTop) || 0;
          curLeft = parseFloat(curCSSLeft) || 0;
        }

        if (isFunction(options)) {
          // Use jQuery.extend here to allow modification of coordinates argument (gh-1848)
          options = options.call(elem, i, jQuery.extend({}, curOffset));
        }

        if (options.top != null) {
          props.top = options.top - curOffset.top + curTop;
        }

        if (options.left != null) {
          props.left = options.left - curOffset.left + curLeft;
        }

        if ("using" in options) {
          options.using.call(elem, props);
        } else {
          curElem.css(props);
        }
      }
    };
    jQuery.fn.extend({
      // offset() relates an element's border box to the document origin
      offset: function (options) {
        // Preserve chaining for setter
        if (arguments.length) {
          return options === undefined ? this : this.each(function (i) {
            jQuery.offset.setOffset(this, options, i);
          });
        }

        var rect,
            win,
            elem = this[0];

        if (!elem) {
          return;
        } // Return zeros for disconnected and hidden (display: none) elements (gh-2310)
        // Support: IE <=11 only
        // Running getBoundingClientRect on a
        // disconnected node in IE throws an error


        if (!elem.getClientRects().length) {
          return {
            top: 0,
            left: 0
          };
        } // Get document-relative position by adding viewport scroll to viewport-relative gBCR


        rect = elem.getBoundingClientRect();
        win = elem.ownerDocument.defaultView;
        return {
          top: rect.top + win.pageYOffset,
          left: rect.left + win.pageXOffset
        };
      },
      // position() relates an element's margin box to its offset parent's padding box
      // This corresponds to the behavior of CSS absolute positioning
      position: function () {
        if (!this[0]) {
          return;
        }

        var offsetParent,
            offset,
            doc,
            elem = this[0],
            parentOffset = {
          top: 0,
          left: 0
        }; // position:fixed elements are offset from the viewport, which itself always has zero offset

        if (jQuery.css(elem, "position") === "fixed") {
          // Assume position:fixed implies availability of getBoundingClientRect
          offset = elem.getBoundingClientRect();
        } else {
          offset = this.offset(); // Account for the *real* offset parent, which can be the document or its root element
          // when a statically positioned element is identified

          doc = elem.ownerDocument;
          offsetParent = elem.offsetParent || doc.documentElement;

          while (offsetParent && (offsetParent === doc.body || offsetParent === doc.documentElement) && jQuery.css(offsetParent, "position") === "static") {
            offsetParent = offsetParent.parentNode;
          }

          if (offsetParent && offsetParent !== elem && offsetParent.nodeType === 1) {
            // Incorporate borders into its offset, since they are outside its content origin
            parentOffset = jQuery(offsetParent).offset();
            parentOffset.top += jQuery.css(offsetParent, "borderTopWidth", true);
            parentOffset.left += jQuery.css(offsetParent, "borderLeftWidth", true);
          }
        } // Subtract parent offsets and element margins


        return {
          top: offset.top - parentOffset.top - jQuery.css(elem, "marginTop", true),
          left: offset.left - parentOffset.left - jQuery.css(elem, "marginLeft", true)
        };
      },
      // This method will return documentElement in the following cases:
      // 1) For the element inside the iframe without offsetParent, this method will return
      //    documentElement of the parent window
      // 2) For the hidden or detached element
      // 3) For body or html element, i.e. in case of the html node - it will return itself
      //
      // but those exceptions were never presented as a real life use-cases
      // and might be considered as more preferable results.
      //
      // This logic, however, is not guaranteed and can change at any point in the future
      offsetParent: function () {
        return this.map(function () {
          var offsetParent = this.offsetParent;

          while (offsetParent && jQuery.css(offsetParent, "position") === "static") {
            offsetParent = offsetParent.offsetParent;
          }

          return offsetParent || documentElement;
        });
      }
    }); // Create scrollLeft and scrollTop methods

    jQuery.each({
      scrollLeft: "pageXOffset",
      scrollTop: "pageYOffset"
    }, function (method, prop) {
      var top = "pageYOffset" === prop;

      jQuery.fn[method] = function (val) {
        return access(this, function (elem, method, val) {
          // Coalesce documents and windows
          var win;

          if (isWindow(elem)) {
            win = elem;
          } else if (elem.nodeType === 9) {
            win = elem.defaultView;
          }

          if (val === undefined) {
            return win ? win[prop] : elem[method];
          }

          if (win) {
            win.scrollTo(!top ? val : win.pageXOffset, top ? val : win.pageYOffset);
          } else {
            elem[method] = val;
          }
        }, method, val, arguments.length);
      };
    }); // Support: Safari <=7 - 9.1, Chrome <=37 - 49
    // Add the top/left cssHooks using jQuery.fn.position
    // Webkit bug: https://bugs.webkit.org/show_bug.cgi?id=29084
    // Blink bug: https://bugs.chromium.org/p/chromium/issues/detail?id=589347
    // getComputedStyle returns percent when specified for top/left/bottom/right;
    // rather than make the css module depend on the offset module, just check for it here

    jQuery.each(["top", "left"], function (i, prop) {
      jQuery.cssHooks[prop] = addGetHookIf(support.pixelPosition, function (elem, computed) {
        if (computed) {
          computed = curCSS(elem, prop); // If curCSS returns percentage, fallback to offset

          return rnumnonpx.test(computed) ? jQuery(elem).position()[prop] + "px" : computed;
        }
      });
    }); // Create innerHeight, innerWidth, height, width, outerHeight and outerWidth methods

    jQuery.each({
      Height: "height",
      Width: "width"
    }, function (name, type) {
      jQuery.each({
        padding: "inner" + name,
        content: type,
        "": "outer" + name
      }, function (defaultExtra, funcName) {
        // Margin is only for outerHeight, outerWidth
        jQuery.fn[funcName] = function (margin, value) {
          var chainable = arguments.length && (defaultExtra || typeof margin !== "boolean"),
              extra = defaultExtra || (margin === true || value === true ? "margin" : "border");
          return access(this, function (elem, type, value) {
            var doc;

            if (isWindow(elem)) {
              // $( window ).outerWidth/Height return w/h including scrollbars (gh-1729)
              return funcName.indexOf("outer") === 0 ? elem["inner" + name] : elem.document.documentElement["client" + name];
            } // Get document width or height


            if (elem.nodeType === 9) {
              doc = elem.documentElement; // Either scroll[Width/Height] or offset[Width/Height] or client[Width/Height],
              // whichever is greatest

              return Math.max(elem.body["scroll" + name], doc["scroll" + name], elem.body["offset" + name], doc["offset" + name], doc["client" + name]);
            }

            return value === undefined ? // Get width or height on the element, requesting but not forcing parseFloat
            jQuery.css(elem, type, extra) : // Set width or height on the element
            jQuery.style(elem, type, value, extra);
          }, type, chainable ? margin : undefined, chainable);
        };
      });
    });
    jQuery.each(("blur focus focusin focusout resize scroll click dblclick " + "mousedown mouseup mousemove mouseover mouseout mouseenter mouseleave " + "change select submit keydown keypress keyup contextmenu").split(" "), function (i, name) {
      // Handle event binding
      jQuery.fn[name] = function (data, fn) {
        return arguments.length > 0 ? this.on(name, null, data, fn) : this.trigger(name);
      };
    });
    jQuery.fn.extend({
      hover: function (fnOver, fnOut) {
        return this.mouseenter(fnOver).mouseleave(fnOut || fnOver);
      }
    });
    jQuery.fn.extend({
      bind: function (types, data, fn) {
        return this.on(types, null, data, fn);
      },
      unbind: function (types, fn) {
        return this.off(types, null, fn);
      },
      delegate: function (selector, types, data, fn) {
        return this.on(types, selector, data, fn);
      },
      undelegate: function (selector, types, fn) {
        // ( namespace ) or ( selector, types [, fn] )
        return arguments.length === 1 ? this.off(selector, "**") : this.off(types, selector || "**", fn);
      }
    }); // Bind a function to a context, optionally partially applying any
    // arguments.
    // jQuery.proxy is deprecated to promote standards (specifically Function#bind)
    // However, it is not slated for removal any time soon

    jQuery.proxy = function (fn, context) {
      var tmp, args, proxy;

      if (typeof context === "string") {
        tmp = fn[context];
        context = fn;
        fn = tmp;
      } // Quick check to determine if target is callable, in the spec
      // this throws a TypeError, but we will just return undefined.


      if (!isFunction(fn)) {
        return undefined;
      } // Simulated bind


      args = slice.call(arguments, 2);

      proxy = function () {
        return fn.apply(context || this, args.concat(slice.call(arguments)));
      }; // Set the guid of unique handler to the same of original handler, so it can be removed


      proxy.guid = fn.guid = fn.guid || jQuery.guid++;
      return proxy;
    };

    jQuery.holdReady = function (hold) {
      if (hold) {
        jQuery.readyWait++;
      } else {
        jQuery.ready(true);
      }
    };

    jQuery.isArray = Array.isArray;
    jQuery.parseJSON = JSON.parse;
    jQuery.nodeName = nodeName;
    jQuery.isFunction = isFunction;
    jQuery.isWindow = isWindow;
    jQuery.camelCase = camelCase;
    jQuery.type = toType;
    jQuery.now = Date.now;

    jQuery.isNumeric = function (obj) {
      // As of jQuery 3.0, isNumeric is limited to
      // strings and numbers (primitives or objects)
      // that can be coerced to finite numbers (gh-2662)
      var type = jQuery.type(obj);
      return (type === "number" || type === "string") && // parseFloat NaNs numeric-cast false positives ("")
      // ...but misinterprets leading-number strings, particularly hex literals ("0x...")
      // subtraction forces infinities to NaN
      !isNaN(obj - parseFloat(obj));
    };

    const $$1 = jQuery;

    function div$1(options) {
      return create$1("div", options);
    }

    function create$1(tag, options) {
      const elem = document.createElement(tag);

      if (options) {
        if (options.class) {
          elem.classList.add(options.class);
        }

        if (options.id) {
          elem.id = options.id;
        }

        if (options.style) {
          applyStyle$1(elem, options.style);
        }
      }

      return elem;
    }

    function hide$1(elem) {
      const cssStyle = getComputedStyle(elem);

      if (cssStyle.display !== "none") {
        elem._initialDisplay = cssStyle.display;
      }

      elem.style.display = "none";
    }

    function offset$1(elem) {
      // Return zeros for disconnected and hidden (display: none) elements (gh-2310)
      // Support: IE <=11 only
      // Running getBoundingClientRect on a
      // disconnected node in IE throws an error
      if (!elem.getClientRects().length) {
        return {
          top: 0,
          left: 0
        };
      } // Get document-relative position by adding viewport scroll to viewport-relative gBCR


      const rect = elem.getBoundingClientRect();
      const win = elem.ownerDocument.defaultView;
      return {
        top: rect.top + win.pageYOffset,
        left: rect.left + win.pageXOffset
      };
    }

    function pageCoordinates$1(e) {
      if (e.type.startsWith("touch")) {
        const touch = e.touches[0];
        return {
          x: touch.pageX,
          y: touch.pageY
        };
      } else {
        return {
          x: e.pageX,
          y: e.pageY
        };
      }
    }

    const relativeDOMBBox = (parentElement, childElement) => {
      const {
        x: x_p,
        y: y_p,
        width: width_p,
        height: height_p
      } = parentElement.getBoundingClientRect();
      const {
        x: x_c,
        y: y_c,
        width: width_c,
        height: height_c
      } = childElement.getBoundingClientRect();
      return {
        x: x_c - x_p,
        y: y_c - y_p,
        width: width_c,
        height: height_c
      };
    };

    function applyStyle$1(elem, style) {
      for (let key of Object.keys(style)) {
        elem.style[key] = style[key];
      }
    }

    function guid$2() {
      return ("0000" + (Math.random() * Math.pow(36, 4) << 0).toString(36)).slice(-4);
    }

    let getMouseXY$1 = (domElement, {
      clientX,
      clientY
    }) => {
      // DOMRect object with eight properties: left, top, right, bottom, x, y, width, height
      const {
        left,
        top,
        width,
        height
      } = domElement.getBoundingClientRect();
      const x = clientX - left;
      const y = clientY - top;
      return {
        x,
        y,
        xNormalized: x / width,
        yNormalized: y / height,
        width,
        height
      };
    };
    /**
     * Translate the mouse coordinates for the event to the coordinates for the given target element
     * @param event
     * @param domElement
     * @returns {{x: number, y: number}}
     */


    function translateMouseCoordinates$1(event, domElement) {
      const {
        clientX,
        clientY
      } = event;
      return getMouseXY$1(domElement, {
        clientX,
        clientY
      });
    }

    function createIcon$1(name, color) {
      return iconMarkup$1(name, color);
    }

    function iconMarkup$1(name, color) {
      color = color || "currentColor";
      let icon = icons$1[name];

      if (!icon) {
        console.error(`No icon named: ${name}`);
        icon = icons$1["question"];
      }

      const svg = document.createElementNS("http://www.w3.org/2000/svg", "svg");
      svg.setAttributeNS(null, 'viewBox', '0 0 ' + icon[0] + ' ' + icon[1]);
      const path = document.createElementNS("http://www.w3.org/2000/svg", "path");
      path.setAttributeNS(null, 'fill', color);
      path.setAttributeNS(null, 'd', icon[4]);
      svg.appendChild(path);
      return svg;
    }

    const icons$1 = {
      "check": [512, 512, [], "f00c", "M173.898 439.404l-166.4-166.4c-9.997-9.997-9.997-26.206 0-36.204l36.203-36.204c9.997-9.998 26.207-9.998 36.204 0L192 312.69 432.095 72.596c9.997-9.997 26.207-9.997 36.204 0l36.203 36.204c9.997 9.997 9.997 26.206 0 36.204l-294.4 294.401c-9.998 9.997-26.207 9.997-36.204-.001z"],
      "cog": [512, 512, [], "f013", "M444.788 291.1l42.616 24.599c4.867 2.809 7.126 8.618 5.459 13.985-11.07 35.642-29.97 67.842-54.689 94.586a12.016 12.016 0 0 1-14.832 2.254l-42.584-24.595a191.577 191.577 0 0 1-60.759 35.13v49.182a12.01 12.01 0 0 1-9.377 11.718c-34.956 7.85-72.499 8.256-109.219.007-5.49-1.233-9.403-6.096-9.403-11.723v-49.184a191.555 191.555 0 0 1-60.759-35.13l-42.584 24.595a12.016 12.016 0 0 1-14.832-2.254c-24.718-26.744-43.619-58.944-54.689-94.586-1.667-5.366.592-11.175 5.459-13.985L67.212 291.1a193.48 193.48 0 0 1 0-70.199l-42.616-24.599c-4.867-2.809-7.126-8.618-5.459-13.985 11.07-35.642 29.97-67.842 54.689-94.586a12.016 12.016 0 0 1 14.832-2.254l42.584 24.595a191.577 191.577 0 0 1 60.759-35.13V25.759a12.01 12.01 0 0 1 9.377-11.718c34.956-7.85 72.499-8.256 109.219-.007 5.49 1.233 9.403 6.096 9.403 11.723v49.184a191.555 191.555 0 0 1 60.759 35.13l42.584-24.595a12.016 12.016 0 0 1 14.832 2.254c24.718 26.744 43.619 58.944 54.689 94.586 1.667 5.366-.592 11.175-5.459 13.985L444.788 220.9a193.485 193.485 0 0 1 0 70.2zM336 256c0-44.112-35.888-80-80-80s-80 35.888-80 80 35.888 80 80 80 80-35.888 80-80z"],
      "exclamation": [192, 512, [], "f12a", "M176 432c0 44.112-35.888 80-80 80s-80-35.888-80-80 35.888-80 80-80 80 35.888 80 80zM25.26 25.199l13.6 272C39.499 309.972 50.041 320 62.83 320h66.34c12.789 0 23.331-10.028 23.97-22.801l13.6-272C167.425 11.49 156.496 0 142.77 0H49.23C35.504 0 24.575 11.49 25.26 25.199z"],
      "exclamation-circle": [512, 512, [], "f06a", "M504 256c0 136.997-111.043 248-248 248S8 392.997 8 256C8 119.083 119.043 8 256 8s248 111.083 248 248zm-248 50c-25.405 0-46 20.595-46 46s20.595 46 46 46 46-20.595 46-46-20.595-46-46-46zm-43.673-165.346l7.418 136c.347 6.364 5.609 11.346 11.982 11.346h48.546c6.373 0 11.635-4.982 11.982-11.346l7.418-136c.375-6.874-5.098-12.654-11.982-12.654h-63.383c-6.884 0-12.356 5.78-11.981 12.654z"],
      "exclamation-triangle": [576, 512, [], "f071", "M569.517 440.013C587.975 472.007 564.806 512 527.94 512H48.054c-36.937 0-59.999-40.055-41.577-71.987L246.423 23.985c18.467-32.009 64.72-31.951 83.154 0l239.94 416.028zM288 354c-25.405 0-46 20.595-46 46s20.595 46 46 46 46-20.595 46-46-20.595-46-46-46zm-43.673-165.346l7.418 136c.347 6.364 5.609 11.346 11.982 11.346h48.546c6.373 0 11.635-4.982 11.982-11.346l7.418-136c.375-6.874-5.098-12.654-11.982-12.654h-63.383c-6.884 0-12.356 5.78-11.981 12.654z"],
      "minus": [448, 512, [], "f068", "M424 318.2c13.3 0 24-10.7 24-24v-76.4c0-13.3-10.7-24-24-24H24c-13.3 0-24 10.7-24 24v76.4c0 13.3 10.7 24 24 24h400z"],
      "minus-circle": [512, 512, [], "f056", "M256 8C119 8 8 119 8 256s111 248 248 248 248-111 248-248S393 8 256 8zM124 296c-6.6 0-12-5.4-12-12v-56c0-6.6 5.4-12 12-12h264c6.6 0 12 5.4 12 12v56c0 6.6-5.4 12-12 12H124z"],
      "minus-square": [448, 512, [], "f146", "M400 32H48C21.5 32 0 53.5 0 80v352c0 26.5 21.5 48 48 48h352c26.5 0 48-21.5 48-48V80c0-26.5-21.5-48-48-48zM92 296c-6.6 0-12-5.4-12-12v-56c0-6.6 5.4-12 12-12h264c6.6 0 12 5.4 12 12v56c0 6.6-5.4 12-12 12H92z"],
      "plus": [448, 512, [], "f067", "M448 294.2v-76.4c0-13.3-10.7-24-24-24H286.2V56c0-13.3-10.7-24-24-24h-76.4c-13.3 0-24 10.7-24 24v137.8H24c-13.3 0-24 10.7-24 24v76.4c0 13.3 10.7 24 24 24h137.8V456c0 13.3 10.7 24 24 24h76.4c13.3 0 24-10.7 24-24V318.2H424c13.3 0 24-10.7 24-24z"],
      "plus-circle": [512, 512, [], "f055", "M256 8C119 8 8 119 8 256s111 248 248 248 248-111 248-248S393 8 256 8zm144 276c0 6.6-5.4 12-12 12h-92v92c0 6.6-5.4 12-12 12h-56c-6.6 0-12-5.4-12-12v-92h-92c-6.6 0-12-5.4-12-12v-56c0-6.6 5.4-12 12-12h92v-92c0-6.6 5.4-12 12-12h56c6.6 0 12 5.4 12 12v92h92c6.6 0 12 5.4 12 12v56z"],
      "plus-square": [448, 512, [], "f0fe", "M400 32H48C21.5 32 0 53.5 0 80v352c0 26.5 21.5 48 48 48h352c26.5 0 48-21.5 48-48V80c0-26.5-21.5-48-48-48zm-32 252c0 6.6-5.4 12-12 12h-92v92c0 6.6-5.4 12-12 12h-56c-6.6 0-12-5.4-12-12v-92H92c-6.6 0-12-5.4-12-12v-56c0-6.6 5.4-12 12-12h92v-92c0-6.6 5.4-12 12-12h56c6.6 0 12 5.4 12 12v92h92c6.6 0 12 5.4 12 12v56z"],
      "question": [384, 512, [], "f128", "M202.021 0C122.202 0 70.503 32.703 29.914 91.026c-7.363 10.58-5.093 25.086 5.178 32.874l43.138 32.709c10.373 7.865 25.132 6.026 33.253-4.148 25.049-31.381 43.63-49.449 82.757-49.449 30.764 0 68.816 19.799 68.816 49.631 0 22.552-18.617 34.134-48.993 51.164-35.423 19.86-82.299 44.576-82.299 106.405V320c0 13.255 10.745 24 24 24h72.471c13.255 0 24-10.745 24-24v-5.773c0-42.86 125.268-44.645 125.268-160.627C377.504 66.256 286.902 0 202.021 0zM192 373.459c-38.196 0-69.271 31.075-69.271 69.271 0 38.195 31.075 69.27 69.271 69.27s69.271-31.075 69.271-69.271-31.075-69.27-69.271-69.27z"],
      "save": [448, 512, [], "f0c7", "M433.941 129.941l-83.882-83.882A48 48 0 0 0 316.118 32H48C21.49 32 0 53.49 0 80v352c0 26.51 21.49 48 48 48h352c26.51 0 48-21.49 48-48V163.882a48 48 0 0 0-14.059-33.941zM224 416c-35.346 0-64-28.654-64-64 0-35.346 28.654-64 64-64s64 28.654 64 64c0 35.346-28.654 64-64 64zm96-304.52V212c0 6.627-5.373 12-12 12H76c-6.627 0-12-5.373-12-12V108c0-6.627 5.373-12 12-12h228.52c3.183 0 6.235 1.264 8.485 3.515l3.48 3.48A11.996 11.996 0 0 1 320 111.48z"],
      "search": [512, 512, [], "f002", "M505 442.7L405.3 343c-4.5-4.5-10.6-7-17-7H372c27.6-35.3 44-79.7 44-128C416 93.1 322.9 0 208 0S0 93.1 0 208s93.1 208 208 208c48.3 0 92.7-16.4 128-44v16.3c0 6.4 2.5 12.5 7 17l99.7 99.7c9.4 9.4 24.6 9.4 33.9 0l28.3-28.3c9.4-9.4 9.4-24.6.1-34zM208 336c-70.7 0-128-57.2-128-128 0-70.7 57.2-128 128-128 70.7 0 128 57.2 128 128 0 70.7-57.2 128-128 128z"],
      "share": [512, 512, [], "f064", "M503.691 189.836L327.687 37.851C312.281 24.546 288 35.347 288 56.015v80.053C127.371 137.907 0 170.1 0 322.326c0 61.441 39.581 122.309 83.333 154.132 13.653 9.931 33.111-2.533 28.077-18.631C66.066 312.814 132.917 274.316 288 272.085V360c0 20.7 24.3 31.453 39.687 18.164l176.004-152c11.071-9.562 11.086-26.753 0-36.328z"],
      "spinner": [512, 512, [], "f110", "M304 48c0 26.51-21.49 48-48 48s-48-21.49-48-48 21.49-48 48-48 48 21.49 48 48zm-48 368c-26.51 0-48 21.49-48 48s21.49 48 48 48 48-21.49 48-48-21.49-48-48-48zm208-208c-26.51 0-48 21.49-48 48s21.49 48 48 48 48-21.49 48-48-21.49-48-48-48zM96 256c0-26.51-21.49-48-48-48S0 229.49 0 256s21.49 48 48 48 48-21.49 48-48zm12.922 99.078c-26.51 0-48 21.49-48 48s21.49 48 48 48 48-21.49 48-48c0-26.509-21.491-48-48-48zm294.156 0c-26.51 0-48 21.49-48 48s21.49 48 48 48 48-21.49 48-48c0-26.509-21.49-48-48-48zM108.922 60.922c-26.51 0-48 21.49-48 48s21.49 48 48 48 48-21.49 48-48-21.491-48-48-48z"],
      "square": [448, 512, [], "f0c8", "M400 32H48C21.5 32 0 53.5 0 80v352c0 26.5 21.5 48 48 48h352c26.5 0 48-21.5 48-48V80c0-26.5-21.5-48-48-48z"],
      "square-full": [512, 512, [], "f45c", "M512 512H0V0h512v512z"],
      "times": [384, 512, [], "f00d", "M323.1 441l53.9-53.9c9.4-9.4 9.4-24.5 0-33.9L279.8 256l97.2-97.2c9.4-9.4 9.4-24.5 0-33.9L323.1 71c-9.4-9.4-24.5-9.4-33.9 0L192 168.2 94.8 71c-9.4-9.4-24.5-9.4-33.9 0L7 124.9c-9.4 9.4-9.4 24.5 0 33.9l97.2 97.2L7 353.2c-9.4 9.4-9.4 24.5 0 33.9L60.9 441c9.4 9.4 24.5 9.4 33.9 0l97.2-97.2 97.2 97.2c9.3 9.3 24.5 9.3 33.9 0z"],
      "times-circle": [512, 512, [], "f057", "M256 8C119 8 8 119 8 256s111 248 248 248 248-111 248-248S393 8 256 8zm121.6 313.1c4.7 4.7 4.7 12.3 0 17L338 377.6c-4.7 4.7-12.3 4.7-17 0L256 312l-65.1 65.6c-4.7 4.7-12.3 4.7-17 0L134.4 338c-4.7-4.7-4.7-12.3 0-17l65.6-65-65.6-65.1c-4.7-4.7-4.7-12.3 0-17l39.6-39.6c4.7-4.7 12.3-4.7 17 0l65 65.7 65.1-65.6c4.7-4.7 12.3-4.7 17 0l39.6 39.6c4.7 4.7 4.7 12.3 0 17L312 256l65.6 65.1z"],
      "wrench": [512, 512, [], "f0ad", "M481.156 200c9.3 0 15.12 10.155 10.325 18.124C466.295 259.992 420.419 288 368 288c-79.222 0-143.501-63.974-143.997-143.079C223.505 65.469 288.548-.001 368.002 0c52.362.001 98.196 27.949 123.4 69.743C496.24 77.766 490.523 88 481.154 88H376l-40 56 40 56h105.156zm-171.649 93.003L109.255 493.255c-24.994 24.993-65.515 24.994-90.51 0-24.993-24.994-24.993-65.516 0-90.51L218.991 202.5c16.16 41.197 49.303 74.335 90.516 90.503zM104 432c0-13.255-10.745-24-24-24s-24 10.745-24 24 10.745 24 24 24 24-10.745 24-24z"]
    };

    function attachDialogCloseHandlerWithParent$1(parent, closeHandler) {
      var container = document.createElement("div");
      parent.appendChild(container);
      container.appendChild(createIcon$1("times"));
      container.addEventListener('click', function (e) {
        e.preventDefault();
        e.stopPropagation();
        closeHandler();
      });
    }

    /**
     * Covers string literals and String objects
     * @param x
     * @returns {boolean}
     */
    function isString$3(x) {
      return typeof x === "string" || x instanceof String;
    } // StackOverflow: http://stackoverflow.com/a/10810674/116169


    function numberFormatter$1(rawNumber) {
      var dec = String(rawNumber).split(/[.,]/),
          sep = ',',
          decsep = '.';
      return dec[0].split('').reverse().reduce(function (prev, now, i) {
        return i % 3 === 0 ? prev + sep + now : prev + now;
      }).split('').reverse().join('') + (dec[1] ? decsep + dec[1] : '');
    }

    const splitLines$5 = function (string) {
      return string.split(/\n|\r\n|\r/g);
    };

    function splitStringRespectingQuotes(string, delim) {
      var tokens = [],
          len = string.length,
          i,
          n = 0,
          quote = false,
          c;

      if (len > 0) {
        tokens[n] = string.charAt(0);

        for (i = 1; i < len; i++) {
          c = string.charAt(i);

          if (c === '"') {
            quote = !quote;
          } else if (!quote && c === delim) {
            n++;
            tokens[n] = "";
          } else {
            tokens[n] += c;
          }
        }
      }

      return tokens;
    }

    function stripQuotes$1(str) {
      if (str === undefined) {
        return str;
      }

      if (str.startsWith("'") || str.startsWith('"')) {
        str = str.substring(1);
      }

      if (str.endsWith("'") || str.endsWith('"')) {
        str = str.substring(0, str.length - 1);
      }

      return str;
    }

    function hashCode$1(s) {
      return s.split("").reduce(function (a, b) {
        a = (a << 5) - a + b.charCodeAt(0);
        return a & a;
      }, 0);
    }

    function capitalize(str) {
      return str.length > 0 ? str.charAt(0).toUpperCase() + str.slice(1) : str;
    }
    /**
     * Parse a locus string and return a range object.  Locus string is of the form chr:start-end.  End is optional
     *
     */


    function parseLocusString$1(string) {
      const t1 = string.split(":");
      const t2 = t1[1].split("-");
      const range = {
        chr: t1[0],
        start: Number.parseInt(t2[0].replace(/,/g, '')) - 1
      };

      if (t2.length > 1) {
        range.end = Number.parseInt(t2[1].replace(/,/g, ''));
      } else {
        range.end = range.start + 1;
      }

      return range;
    }

    function isGoogleURL(url) {
      return url.includes("googleapis") && !url.includes("urlshortener") || isGoogleStorageURL(url) || isGoogleDriveURL(url);
    }

    function isGoogleStorageURL(url) {
      return url.startsWith("gs://") || url.startsWith("https://www.googleapis.com/storage") || url.startsWith("https://storage.cloud.google.com") || url.startsWith("https://storage.googleapis.com");
    }

    function isGoogleDriveURL(url) {
      return url.indexOf("drive.google.com") >= 0 || url.indexOf("www.googleapis.com/drive") > 0;
    }
    /**
     * Translate gs:// urls to https
     * See https://cloud.google.com/storage/docs/json_api/v1
     * @param gsUrl
     * @returns {string|*}
     */


    function translateGoogleCloudURL(gsUrl) {
      let {
        bucket,
        object
      } = parseBucketName(gsUrl);
      object = encode(object);
      const qIdx = gsUrl.indexOf('?');
      const paramString = qIdx > 0 ? gsUrl.substring(qIdx) + "&alt=media" : "?alt=media";
      return `https://storage.googleapis.com/storage/v1/b/${bucket}/o/${object}${paramString}`;
    }
    /**
     * Parse a google bucket and object name from a google storage URL.  Known forms include
     *
     * gs://BUCKET_NAME/OBJECT_NAME
     * https://storage.googleapis.com/BUCKET_NAME/OBJECT_NAME
     * https://storage.googleapis.com/storage/v1/b/BUCKET_NAME/o/OBJECT_NAME
     * https://www.googleapis.com/storage/v1/b/BUCKET_NAME/o/OBJECT_NAME"
     * https://storage.googleapis.com/download/storage/v1/b/BUCKET_NAME/o/OBJECT_NAME
     *
     * @param url
     */


    function parseBucketName(url) {
      let bucket;
      let object;

      if (url.startsWith("gs://")) {
        const i = url.indexOf('/', 5);

        if (i >= 0) {
          bucket = url.substring(5, i);
          const qIdx = url.indexOf('?');
          object = qIdx < 0 ? url.substring(i + 1) : url.substring(i + 1, qIdx);
        }
      } else if (url.startsWith("https://storage.googleapis.com") || url.startsWith("https://storage.cloud.google.com")) {
        const bucketIdx = url.indexOf("/v1/b/", 8);

        if (bucketIdx > 0) {
          const objIdx = url.indexOf("/o/", bucketIdx);

          if (objIdx > 0) {
            const queryIdx = url.indexOf("?", objIdx);
            bucket = url.substring(bucketIdx + 6, objIdx);
            object = queryIdx > 0 ? url.substring(objIdx + 3, queryIdx) : url.substring(objIdx + 3);
          }
        } else {
          const idx1 = url.indexOf("/", 8);
          const idx2 = url.indexOf("/", idx1 + 1);
          const idx3 = url.indexOf("?", idx2);

          if (idx2 > 0) {
            bucket = url.substring(idx1 + 1, idx2);
            object = idx3 < 0 ? url.substring(idx2 + 1) : url.substring(idx2 + 1, idx3);
          }
        }
      } else if (url.startsWith("https://www.googleapis.com/storage/v1/b")) {
        const bucketIdx = url.indexOf("/v1/b/", 8);
        const objIdx = url.indexOf("/o/", bucketIdx);

        if (objIdx > 0) {
          const queryIdx = url.indexOf("?", objIdx);
          bucket = url.substring(bucketIdx + 6, objIdx);
          object = queryIdx > 0 ? url.substring(objIdx + 3, queryIdx) : url.substring(objIdx + 3);
        }
      }

      if (bucket && object) {
        return {
          bucket,
          object
        };
      } else {
        throw Error(`Unrecognized Google Storage URI: ${url}`);
      }
    }

    function driveDownloadURL(link) {
      // Return a google drive download url for the sharable link
      //https://drive.google.com/open?id=0B-lleX9c2pZFbDJ4VVRxakJzVGM
      //https://drive.google.com/file/d/1_FC4kCeO8E3V4dJ1yIW7A0sn1yURKIX-/view?usp=sharing
      var id = getGoogleDriveFileID(link);
      return id ? "https://www.googleapis.com/drive/v3/files/" + id + "?alt=media&supportsTeamDrives=true" : link;
    }

    function getGoogleDriveFileID(link) {
      //https://drive.google.com/file/d/1_FC4kCeO8E3V4dJ1yIW7A0sn1yURKIX-/view?usp=sharing
      //https://www.googleapis.com/drive/v3/files/1w-tvo6p1SH4p1OaQSVxpkV_EJgGIstWF?alt=media&supportsTeamDrives=true"
      if (link.includes("/open?id=")) {
        const i1 = link.indexOf("/open?id=") + 9;
        const i2 = link.indexOf("&");

        if (i1 > 0 && i2 > i1) {
          return link.substring(i1, i2);
        } else if (i1 > 0) {
          return link.substring(i1);
        }
      } else if (link.includes("/file/d/")) {
        const i1 = link.indexOf("/file/d/") + 8;
        const i2 = link.lastIndexOf("/");
        return link.substring(i1, i2);
      } else if (link.startsWith("https://www.googleapis.com/drive")) {
        let i1 = link.indexOf("/files/");
        const i2 = link.indexOf("?");

        if (i1 > 0) {
          i1 += 7;
          return i2 > 0 ? link.substring(i1, i2) : link.substring(i1);
        }
      }

      throw Error("Unknown Google Drive url format: " + link);
    }
    /**
     * Percent a GCS object name.  See https://cloud.google.com/storage/docs/request-endpoints
     * Specific characters to encode:
     *   !, #, $, &, ', (, ), *, +, ,, /, :, ;, =, ?, @, [, ], and space characters.
     * @param obj
     */


    function encode(objectName) {
      let result = '';
      objectName.split('').forEach(function (letter) {
        if (encodings.has(letter)) {
          result += encodings.get(letter);
        } else {
          result += letter;
        }
      });
      return result;
    } //	%23	%24	%25	%26	%27	%28	%29	%2A	%2B	%2C	%2F	%3A	%3B	%3D	%3F	%40	%5B	%5D


    const encodings = new Map();
    encodings.set("!", "%21");
    encodings.set("#", "%23");
    encodings.set("$", "%24");
    encodings.set("%", "%25");
    encodings.set("&", "%26");
    encodings.set("'", "%27");
    encodings.set("(", "%28");
    encodings.set(")", "%29");
    encodings.set("*", "%2A");
    encodings.set("+", "%2B");
    encodings.set(",", "%2C");
    encodings.set("/", "%2F");
    encodings.set(":", "%3A");
    encodings.set(";", "%3B");
    encodings.set("=", "%3D");
    encodings.set("?", "%3F");
    encodings.set("@", "%40");
    encodings.set("[", "%5B");
    encodings.set("]", "%5D");
    encodings.set(" ", "%20"); // For testing

    // Convenience functions for the gapi oAuth library.
    const FIVE_MINUTES = 5 * 60 * 1000;

    async function load$1(library) {
      return new Promise(function (resolve, reject) {
        gapi.load(library, {
          callback: resolve,
          onerror: reject
        });
      });
    }

    async function init$1(config) {
      if (isInitialized()) {
        console.warn("oAuth has already been initialized");
        return;
      }

      gapi.apiKey = config.apiKey; // copy config, gapi will modify it

      const configCopy = Object.assign({}, config);

      if (!configCopy.scope) {
        configCopy.scope = 'profile';
      }

      if (!config.client_id) {
        config.client_id = config.clientId;
      }

      await load$1("auth2");
      return new Promise(function (resolve, reject) {
        gapi.auth2.init(configCopy).then(resolve, reject);
      });
    }

    function isInitialized() {
      return typeof gapi !== "undefined" && gapi.auth2 && gapi.auth2.getAuthInstance();
    }

    let inProgress = false;

    async function getAccessToken(scope) {
      if (typeof gapi === "undefined") {
        throw Error("Google authentication requires the 'gapi' library");
      }

      if (!gapi.auth2) {
        throw Error("Google 'auth2' has not been initialized");
      }

      if (inProgress) {
        return new Promise(function (resolve, reject) {
          let intervalID;

          const checkForToken = () => {
            // Wait for inProgress to equal "false"
            try {
              if (inProgress === false) {
                //console.log("Delayed resolution for " + scope);
                resolve(getAccessToken(scope));
                clearInterval(intervalID);
              }
            } catch (e) {
              clearInterval(intervalID);
              reject(e);
            }
          };

          intervalID = setInterval(checkForToken, 100);
        });
      } else {
        inProgress = true;

        try {
          let currentUser = gapi.auth2.getAuthInstance().currentUser.get();
          let token;

          if (currentUser.isSignedIn()) {
            if (!currentUser.hasGrantedScopes(scope)) {
              await currentUser.grant({
                scope
              });
            }

            const {
              access_token,
              expires_at
            } = currentUser.getAuthResponse();

            if (Date.now() < expires_at - FIVE_MINUTES) {
              token = {
                access_token,
                expires_at
              };
            } else {
              const {
                access_token,
                expires_at
              } = currentUser.reloadAuthResponse();
              token = {
                access_token,
                expires_at
              };
            }
          } else {
            currentUser = await signIn(scope);
            const {
              access_token,
              expires_at
            } = currentUser.getAuthResponse();
            token = {
              access_token,
              expires_at
            };
          }

          return token;
        } finally {
          inProgress = false;
        }
      }
    }
    /**
     * Return the current access token if the user is signed in, or undefined otherwise.  This function does not
     * attempt a signIn or request any specfic scopes.
     *
     * @returns access_token || undefined
     */


    function getCurrentAccessToken() {
      let currentUser = gapi.auth2.getAuthInstance().currentUser.get();

      if (currentUser && currentUser.isSignedIn()) {
        const {
          access_token,
          expires_at
        } = currentUser.getAuthResponse();
        return {
          access_token,
          expires_at
        };
      } else {
        return undefined;
      }
    }

    async function signIn(scope) {
      const options = new gapi.auth2.SigninOptionsBuilder();
      options.setPrompt('select_account');
      options.setScope(scope);
      return gapi.auth2.getAuthInstance().signIn(options);
    }

    function getScopeForURL(url) {
      if (isGoogleDriveURL(url)) {
        return "https://www.googleapis.com/auth/drive.file";
      } else if (isGoogleStorageURL(url)) {
        return "https://www.googleapis.com/auth/devstorage.read_only";
      } else {
        return 'https://www.googleapis.com/auth/userinfo.profile';
      }
    }

    function getApiKey() {
      return gapi.apiKey;
    }

    async function getDriveFileInfo(googleDriveURL) {
      const id = getGoogleDriveFileID(googleDriveURL);
      let endPoint = "https://www.googleapis.com/drive/v3/files/" + id + "?supportsTeamDrives=true";
      const apiKey = getApiKey();

      if (apiKey) {
        endPoint += "&key=" + apiKey;
      }

      const response = await fetch(endPoint);
      let json = await response.json();

      if (json.error && json.error.code === 404) {
        const {
          access_token
        } = await getAccessToken("https://www.googleapis.com/auth/drive.readonly");

        if (access_token) {
          const response = await fetch(endPoint, {
            headers: {
              'Authorization': `Bearer ${access_token}`
            }
          });
          json = await response.json();

          if (json.error) {
            throw Error(json.error);
          }
        } else {
          throw Error(json.error);
        }
      }

      return json;
    }

    if (typeof process === 'object' && typeof window === 'undefined') {
      global.atob = function (str) {
        return Buffer.from(str, 'base64').toString('binary');
      };
    }

    function parseUri(str) {
      var o = options,
          m = o.parser["loose"].exec(str),
          uri = {},
          i = 14;

      while (i--) uri[o.key[i]] = m[i] || "";

      uri[o.q.name] = {};
      uri[o.key[12]].replace(o.q.parser, function ($0, $1, $2) {
        if ($1) uri[o.q.name][$1] = $2;
      });
      return uri;
    }

    const options = {
      strictMode: false,
      key: ["source", "protocol", "authority", "userInfo", "user", "password", "host", "port", "relative", "path", "directory", "file", "query", "anchor"],
      q: {
        name: "queryKey",
        parser: /(?:^|&)([^&=]*)=?([^&]*)/g
      },
      parser: {
        strict: /^(?:([^:\/?#]+):)?(?:\/\/((?:(([^:@]*)(?::([^:@]*))?)?@)?([^:\/?#]*)(?::(\d*))?))?((((?:[^?#\/]*\/)*)([^?#]*))(?:\?([^#]*))?(?:#(.*))?)/,
        loose: /^(?:(?![^:@]+:[^:@\/]*@)([^:\/?#.]+):)?(?:\/\/)?((?:(([^:@]*)(?::([^:@]*))?)?@)?([^:\/?#]*)(?::(\d*))?)(((\/(?:[^?#](?![^?#\/]*\.[^?#\/.]+(?:[?#]|$)))*\/?)?([^?#\/]*))(?:\?([^#]*))?(?:#(.*))?)/
      }
    };
    /**
     * Resolve a url, which might be a string, function (that returns a string or Promse), or Promise (that resolves to a string)
     *
     * @param url
     * @returns {Promise<*>}
     */


    async function resolveURL(url) {
      return typeof url === 'function' ? url() : url;
    }

    /**
     * Return the filename from the path.   Example
     *   https://foo.com/bar.bed?param=2   => bar.bed
     * @param urlOrFile
     */


    function getFilename$1(urlOrFile) {
      if (urlOrFile.name !== undefined) {
        return urlOrFile.name;
      } else if (isString$3(urlOrFile)) {
        let index = urlOrFile.lastIndexOf("/");
        let filename = index < 0 ? urlOrFile : urlOrFile.substr(index + 1); //Strip parameters -- handle local files later

        index = filename.indexOf("?");

        if (index > 0) {
          filename = filename.substr(0, index);
        }

        return filename;
      } else {
        throw Error(`Expected File or string, got ${typeof urlOrFile}`);
      }
    }
    /**
     * Test if object is a File or File-like object.
     *
     * @param object
     */


    function isFile(object) {
      if (!object) {
        return false;
      }

      return typeof object !== 'function' && (object instanceof File || object.hasOwnProperty("name") && typeof object.slice === 'function' && typeof object.arrayBuffer === 'function');
    }

    const isFilePath = isFile; // deprecated

    function download(filename, data) {
      const element = document.createElement('a');
      element.setAttribute('href', data);
      element.setAttribute('download', filename);
      element.style.display = 'none';
      document.body.appendChild(element);
      element.click();
      document.body.removeChild(element);
    }

    // Ths file is a modification of the pako distribution https://github.com/nodeca/pako.   The modifications
    // consists of simple changes to create an ES6 module, specifically commenting out the function wrapper and
    // adding an ES6 export statement.
    // **************  COMMENTED OUT BY JTR ******************//

    /*! pako 2.0.4 https://github.com/nodeca/pako @license (MIT AND Zlib) */
    // (function (global, factory) {
    //   typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports) :
    //   typeof define === 'function' && define.amd ? define(['exports'], factory) :
    //   (global = typeof globalThis !== 'undefined' ? globalThis : global || self, factory(global.pako = {}));
    // }(this, (function (exports) { 'use strict';
    // **************  COMMENTED OUT BY JTR ******************//
    // (C) 1995-2013 Jean-loup Gailly and Mark Adler
    // (C) 2014-2017 Vitaly Puzrin and Andrey Tupitsin
    //
    // This software is provided 'as-is', without any express or implied
    // warranty. In no event will the authors be held liable for any damages
    // arising from the use of this software.
    //
    // Permission is granted to anyone to use this software for any purpose,
    // including commercial applications, and to alter it and redistribute it
    // freely, subject to the following restrictions:
    //
    // 1. The origin of this software must not be misrepresented; you must not
    //   claim that you wrote the original software. If you use this software
    //   in a product, an acknowledgment in the product documentation would be
    //   appreciated but is not required.
    // 2. Altered source versions must be plainly marked as such, and must not be
    //   misrepresented as being the original software.
    // 3. This notice may not be removed or altered from any source distribution.

    /* eslint-disable space-unary-ops */

    /* Public constants ==========================================================*/

    /* ===========================================================================*/
    //const Z_FILTERED          = 1;
    //const Z_HUFFMAN_ONLY      = 2;
    //const Z_RLE               = 3;
    const Z_FIXED$1 = 4; //const Z_DEFAULT_STRATEGY  = 0;

    /* Possible values of the data_type field (though see inflate()) */

    const Z_BINARY = 0;
    const Z_TEXT = 1; //const Z_ASCII             = 1; // = Z_TEXT

    const Z_UNKNOWN$1 = 2;
    /*============================================================================*/

    function zero$1(buf) {
      let len = buf.length;

      while (--len >= 0) {
        buf[len] = 0;
      }
    } // From zutil.h


    const STORED_BLOCK = 0;
    const STATIC_TREES = 1;
    const DYN_TREES = 2;
    /* The three kinds of block type */

    const MIN_MATCH$1 = 3;
    const MAX_MATCH$1 = 258;
    /* The minimum and maximum match lengths */
    // From deflate.h

    /* ===========================================================================
     * Internal compression state.
     */

    const LENGTH_CODES$1 = 29;
    /* number of length codes, not counting the special END_BLOCK code */

    const LITERALS$1 = 256;
    /* number of literal bytes 0..255 */

    const L_CODES$1 = LITERALS$1 + 1 + LENGTH_CODES$1;
    /* number of Literal or Length codes, including the END_BLOCK code */

    const D_CODES$1 = 30;
    /* number of distance codes */

    const BL_CODES$1 = 19;
    /* number of codes used to transfer the bit lengths */

    const HEAP_SIZE$1 = 2 * L_CODES$1 + 1;
    /* maximum heap size */

    const MAX_BITS$1 = 15;
    /* All codes must not exceed MAX_BITS bits */

    const Buf_size = 16;
    /* size of bit buffer in bi_buf */

    /* ===========================================================================
     * Constants
     */

    const MAX_BL_BITS = 7;
    /* Bit length codes must not exceed MAX_BL_BITS bits */

    const END_BLOCK = 256;
    /* end of block literal code */

    const REP_3_6 = 16;
    /* repeat previous bit length 3-6 times (2 bits of repeat count) */

    const REPZ_3_10 = 17;
    /* repeat a zero length 3-10 times  (3 bits of repeat count) */

    const REPZ_11_138 = 18;
    /* repeat a zero length 11-138 times  (7 bits of repeat count) */

    /* eslint-disable comma-spacing,array-bracket-spacing */

    const extra_lbits =
    /* extra bits for each length code */
    new Uint8Array([0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4, 4, 5, 5, 5, 5, 0]);
    const extra_dbits =
    /* extra bits for each distance code */
    new Uint8Array([0, 0, 0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13]);
    const extra_blbits =
    /* extra bits for each bit length code */
    new Uint8Array([0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 3, 7]);
    const bl_order = new Uint8Array([16, 17, 18, 0, 8, 7, 9, 6, 10, 5, 11, 4, 12, 3, 13, 2, 14, 1, 15]);
    /* eslint-enable comma-spacing,array-bracket-spacing */

    /* The lengths of the bit length codes are sent in order of decreasing
     * probability, to avoid transmitting the lengths for unused bit length codes.
     */

    /* ===========================================================================
     * Local data. These are initialized only once.
     */
    // We pre-fill arrays with 0 to avoid uninitialized gaps

    const DIST_CODE_LEN = 512;
    /* see definition of array dist_code below */
    // !!!! Use flat array instead of structure, Freq = i*2, Len = i*2+1

    const static_ltree = new Array((L_CODES$1 + 2) * 2);
    zero$1(static_ltree);
    /* The static literal tree. Since the bit lengths are imposed, there is no
     * need for the L_CODES extra codes used during heap construction. However
     * The codes 286 and 287 are needed to build a canonical tree (see _tr_init
     * below).
     */

    const static_dtree = new Array(D_CODES$1 * 2);
    zero$1(static_dtree);
    /* The static distance tree. (Actually a trivial tree since all codes use
     * 5 bits.)
     */

    const _dist_code = new Array(DIST_CODE_LEN);

    zero$1(_dist_code);
    /* Distance codes. The first 256 values correspond to the distances
     * 3 .. 258, the last 256 values correspond to the top 8 bits of
     * the 15 bit distances.
     */

    const _length_code = new Array(MAX_MATCH$1 - MIN_MATCH$1 + 1);

    zero$1(_length_code);
    /* length code for each normalized match length (0 == MIN_MATCH) */

    const base_length = new Array(LENGTH_CODES$1);
    zero$1(base_length);
    /* First normalized length for each code (0 = MIN_MATCH) */

    const base_dist = new Array(D_CODES$1);
    zero$1(base_dist);
    /* First normalized distance for each code (0 = distance of 1) */

    function StaticTreeDesc(static_tree, extra_bits, extra_base, elems, max_length) {
      this.static_tree = static_tree;
      /* static tree or NULL */

      this.extra_bits = extra_bits;
      /* extra bits for each code or NULL */

      this.extra_base = extra_base;
      /* base index for extra_bits */

      this.elems = elems;
      /* max number of elements in the tree */

      this.max_length = max_length;
      /* max bit length for the codes */
      // show if `static_tree` has data or dummy - needed for monomorphic objects

      this.has_stree = static_tree && static_tree.length;
    }

    let static_l_desc;
    let static_d_desc;
    let static_bl_desc;

    function TreeDesc(dyn_tree, stat_desc) {
      this.dyn_tree = dyn_tree;
      /* the dynamic tree */

      this.max_code = 0;
      /* largest code with non zero frequency */

      this.stat_desc = stat_desc;
      /* the corresponding static tree */
    }

    const d_code = dist => {
      return dist < 256 ? _dist_code[dist] : _dist_code[256 + (dist >>> 7)];
    };
    /* ===========================================================================
     * Output a short LSB first on the stream.
     * IN assertion: there is enough room in pendingBuf.
     */


    const put_short = (s, w) => {
      //    put_byte(s, (uch)((w) & 0xff));
      //    put_byte(s, (uch)((ush)(w) >> 8));
      s.pending_buf[s.pending++] = w & 0xff;
      s.pending_buf[s.pending++] = w >>> 8 & 0xff;
    };
    /* ===========================================================================
     * Send a value on a given number of bits.
     * IN assertion: length <= 16 and value fits in length bits.
     */


    const send_bits = (s, value, length) => {
      if (s.bi_valid > Buf_size - length) {
        s.bi_buf |= value << s.bi_valid & 0xffff;
        put_short(s, s.bi_buf);
        s.bi_buf = value >> Buf_size - s.bi_valid;
        s.bi_valid += length - Buf_size;
      } else {
        s.bi_buf |= value << s.bi_valid & 0xffff;
        s.bi_valid += length;
      }
    };

    const send_code = (s, c, tree) => {
      send_bits(s, tree[c * 2]
      /*.Code*/
      , tree[c * 2 + 1]
      /*.Len*/
      );
    };
    /* ===========================================================================
     * Reverse the first len bits of a code, using straightforward code (a faster
     * method would use a table)
     * IN assertion: 1 <= len <= 15
     */


    const bi_reverse = (code, len) => {
      let res = 0;

      do {
        res |= code & 1;
        code >>>= 1;
        res <<= 1;
      } while (--len > 0);

      return res >>> 1;
    };
    /* ===========================================================================
     * Flush the bit buffer, keeping at most 7 bits in it.
     */


    const bi_flush = s => {
      if (s.bi_valid === 16) {
        put_short(s, s.bi_buf);
        s.bi_buf = 0;
        s.bi_valid = 0;
      } else if (s.bi_valid >= 8) {
        s.pending_buf[s.pending++] = s.bi_buf & 0xff;
        s.bi_buf >>= 8;
        s.bi_valid -= 8;
      }
    };
    /* ===========================================================================
     * Compute the optimal bit lengths for a tree and update the total bit length
     * for the current block.
     * IN assertion: the fields freq and dad are set, heap[heap_max] and
     *    above are the tree nodes sorted by increasing frequency.
     * OUT assertions: the field len is set to the optimal bit length, the
     *     array bl_count contains the frequencies for each bit length.
     *     The length opt_len is updated; static_len is also updated if stree is
     *     not null.
     */


    const gen_bitlen = (s, desc) => //    deflate_state *s;
    //    tree_desc *desc;    /* the tree descriptor */
    {
      const tree = desc.dyn_tree;
      const max_code = desc.max_code;
      const stree = desc.stat_desc.static_tree;
      const has_stree = desc.stat_desc.has_stree;
      const extra = desc.stat_desc.extra_bits;
      const base = desc.stat_desc.extra_base;
      const max_length = desc.stat_desc.max_length;
      let h;
      /* heap index */

      let n, m;
      /* iterate over the tree elements */

      let bits;
      /* bit length */

      let xbits;
      /* extra bits */

      let f;
      /* frequency */

      let overflow = 0;
      /* number of elements with bit length too large */

      for (bits = 0; bits <= MAX_BITS$1; bits++) {
        s.bl_count[bits] = 0;
      }
      /* In a first pass, compute the optimal bit lengths (which may
       * overflow in the case of the bit length tree).
       */


      tree[s.heap[s.heap_max] * 2 + 1]
      /*.Len*/
      = 0;
      /* root of the heap */

      for (h = s.heap_max + 1; h < HEAP_SIZE$1; h++) {
        n = s.heap[h];
        bits = tree[tree[n * 2 + 1]
        /*.Dad*/
        * 2 + 1]
        /*.Len*/
        + 1;

        if (bits > max_length) {
          bits = max_length;
          overflow++;
        }

        tree[n * 2 + 1]
        /*.Len*/
        = bits;
        /* We overwrite tree[n].Dad which is no longer needed */

        if (n > max_code) {
          continue;
        }
        /* not a leaf node */


        s.bl_count[bits]++;
        xbits = 0;

        if (n >= base) {
          xbits = extra[n - base];
        }

        f = tree[n * 2]
        /*.Freq*/
        ;
        s.opt_len += f * (bits + xbits);

        if (has_stree) {
          s.static_len += f * (stree[n * 2 + 1]
          /*.Len*/
          + xbits);
        }
      }

      if (overflow === 0) {
        return;
      } // Trace((stderr,"\nbit length overflow\n"));

      /* This happens for example on obj2 and pic of the Calgary corpus */

      /* Find the first bit length which could increase: */


      do {
        bits = max_length - 1;

        while (s.bl_count[bits] === 0) {
          bits--;
        }

        s.bl_count[bits]--;
        /* move one leaf down the tree */

        s.bl_count[bits + 1] += 2;
        /* move one overflow item as its brother */

        s.bl_count[max_length]--;
        /* The brother of the overflow item also moves one step up,
         * but this does not affect bl_count[max_length]
         */

        overflow -= 2;
      } while (overflow > 0);
      /* Now recompute all bit lengths, scanning in increasing frequency.
       * h is still equal to HEAP_SIZE. (It is simpler to reconstruct all
       * lengths instead of fixing only the wrong ones. This idea is taken
       * from 'ar' written by Haruhiko Okumura.)
       */


      for (bits = max_length; bits !== 0; bits--) {
        n = s.bl_count[bits];

        while (n !== 0) {
          m = s.heap[--h];

          if (m > max_code) {
            continue;
          }

          if (tree[m * 2 + 1]
          /*.Len*/
          !== bits) {
            // Trace((stderr,"code %d bits %d->%d\n", m, tree[m].Len, bits));
            s.opt_len += (bits - tree[m * 2 + 1]
            /*.Len*/
            ) * tree[m * 2]
            /*.Freq*/
            ;
            tree[m * 2 + 1]
            /*.Len*/
            = bits;
          }

          n--;
        }
      }
    };
    /* ===========================================================================
     * Generate the codes for a given tree and bit counts (which need not be
     * optimal).
     * IN assertion: the array bl_count contains the bit length statistics for
     * the given tree and the field len is set for all tree elements.
     * OUT assertion: the field code is set for all tree elements of non
     *     zero code length.
     */


    const gen_codes = (tree, max_code, bl_count) => //    ct_data *tree;             /* the tree to decorate */
    //    int max_code;              /* largest code with non zero frequency */
    //    ushf *bl_count;            /* number of codes at each bit length */
    {
      const next_code = new Array(MAX_BITS$1 + 1);
      /* next code value for each bit length */

      let code = 0;
      /* running code value */

      let bits;
      /* bit index */

      let n;
      /* code index */

      /* The distribution counts are first used to generate the code values
       * without bit reversal.
       */

      for (bits = 1; bits <= MAX_BITS$1; bits++) {
        next_code[bits] = code = code + bl_count[bits - 1] << 1;
      }
      /* Check that the bit counts in bl_count are consistent. The last code
       * must be all ones.
       */
      //Assert (code + bl_count[MAX_BITS]-1 == (1<<MAX_BITS)-1,
      //        "inconsistent bit counts");
      //Tracev((stderr,"\ngen_codes: max_code %d ", max_code));


      for (n = 0; n <= max_code; n++) {
        let len = tree[n * 2 + 1]
        /*.Len*/
        ;

        if (len === 0) {
          continue;
        }
        /* Now reverse the bits */


        tree[n * 2]
        /*.Code*/
        = bi_reverse(next_code[len]++, len); //Tracecv(tree != static_ltree, (stderr,"\nn %3d %c l %2d c %4x (%x) ",
        //     n, (isgraph(n) ? n : ' '), len, tree[n].Code, next_code[len]-1));
      }
    };
    /* ===========================================================================
     * Initialize the various 'constant' tables.
     */


    const tr_static_init = () => {
      let n;
      /* iterates over tree elements */

      let bits;
      /* bit counter */

      let length;
      /* length value */

      let code;
      /* code value */

      let dist;
      /* distance index */

      const bl_count = new Array(MAX_BITS$1 + 1);
      /* number of codes at each bit length for an optimal tree */
      // do check in _tr_init()
      //if (static_init_done) return;

      /* For some embedded targets, global variables are not initialized: */

      /*#ifdef NO_INIT_GLOBAL_POINTERS
        static_l_desc.static_tree = static_ltree;
        static_l_desc.extra_bits = extra_lbits;
        static_d_desc.static_tree = static_dtree;
        static_d_desc.extra_bits = extra_dbits;
        static_bl_desc.extra_bits = extra_blbits;
      #endif*/

      /* Initialize the mapping length (0..255) -> length code (0..28) */

      length = 0;

      for (code = 0; code < LENGTH_CODES$1 - 1; code++) {
        base_length[code] = length;

        for (n = 0; n < 1 << extra_lbits[code]; n++) {
          _length_code[length++] = code;
        }
      } //Assert (length == 256, "tr_static_init: length != 256");

      /* Note that the length 255 (match length 258) can be represented
       * in two different ways: code 284 + 5 bits or code 285, so we
       * overwrite length_code[255] to use the best encoding:
       */


      _length_code[length - 1] = code;
      /* Initialize the mapping dist (0..32K) -> dist code (0..29) */

      dist = 0;

      for (code = 0; code < 16; code++) {
        base_dist[code] = dist;

        for (n = 0; n < 1 << extra_dbits[code]; n++) {
          _dist_code[dist++] = code;
        }
      } //Assert (dist == 256, "tr_static_init: dist != 256");


      dist >>= 7;
      /* from now on, all distances are divided by 128 */

      for (; code < D_CODES$1; code++) {
        base_dist[code] = dist << 7;

        for (n = 0; n < 1 << extra_dbits[code] - 7; n++) {
          _dist_code[256 + dist++] = code;
        }
      } //Assert (dist == 256, "tr_static_init: 256+dist != 512");

      /* Construct the codes of the static literal tree */


      for (bits = 0; bits <= MAX_BITS$1; bits++) {
        bl_count[bits] = 0;
      }

      n = 0;

      while (n <= 143) {
        static_ltree[n * 2 + 1]
        /*.Len*/
        = 8;
        n++;
        bl_count[8]++;
      }

      while (n <= 255) {
        static_ltree[n * 2 + 1]
        /*.Len*/
        = 9;
        n++;
        bl_count[9]++;
      }

      while (n <= 279) {
        static_ltree[n * 2 + 1]
        /*.Len*/
        = 7;
        n++;
        bl_count[7]++;
      }

      while (n <= 287) {
        static_ltree[n * 2 + 1]
        /*.Len*/
        = 8;
        n++;
        bl_count[8]++;
      }
      /* Codes 286 and 287 do not exist, but we must include them in the
       * tree construction to get a canonical Huffman tree (longest code
       * all ones)
       */


      gen_codes(static_ltree, L_CODES$1 + 1, bl_count);
      /* The static distance tree is trivial: */

      for (n = 0; n < D_CODES$1; n++) {
        static_dtree[n * 2 + 1]
        /*.Len*/
        = 5;
        static_dtree[n * 2]
        /*.Code*/
        = bi_reverse(n, 5);
      } // Now data ready and we can init static trees


      static_l_desc = new StaticTreeDesc(static_ltree, extra_lbits, LITERALS$1 + 1, L_CODES$1, MAX_BITS$1);
      static_d_desc = new StaticTreeDesc(static_dtree, extra_dbits, 0, D_CODES$1, MAX_BITS$1);
      static_bl_desc = new StaticTreeDesc(new Array(0), extra_blbits, 0, BL_CODES$1, MAX_BL_BITS); //static_init_done = true;
    };
    /* ===========================================================================
     * Initialize a new block.
     */


    const init_block = s => {
      let n;
      /* iterates over tree elements */

      /* Initialize the trees. */

      for (n = 0; n < L_CODES$1; n++) {
        s.dyn_ltree[n * 2]
        /*.Freq*/
        = 0;
      }

      for (n = 0; n < D_CODES$1; n++) {
        s.dyn_dtree[n * 2]
        /*.Freq*/
        = 0;
      }

      for (n = 0; n < BL_CODES$1; n++) {
        s.bl_tree[n * 2]
        /*.Freq*/
        = 0;
      }

      s.dyn_ltree[END_BLOCK * 2]
      /*.Freq*/
      = 1;
      s.opt_len = s.static_len = 0;
      s.last_lit = s.matches = 0;
    };
    /* ===========================================================================
     * Flush the bit buffer and align the output on a byte boundary
     */


    const bi_windup = s => {
      if (s.bi_valid > 8) {
        put_short(s, s.bi_buf);
      } else if (s.bi_valid > 0) {
        //put_byte(s, (Byte)s->bi_buf);
        s.pending_buf[s.pending++] = s.bi_buf;
      }

      s.bi_buf = 0;
      s.bi_valid = 0;
    };
    /* ===========================================================================
     * Copy a stored block, storing first the length and its
     * one's complement if requested.
     */


    const copy_block = (s, buf, len, header) => //DeflateState *s;
    //charf    *buf;    /* the input data */
    //unsigned len;     /* its length */
    //int      header;  /* true if block header must be written */
    {
      bi_windup(s);
      /* align on byte boundary */

      if (header) {
        put_short(s, len);
        put_short(s, ~len);
      } //  while (len--) {
      //    put_byte(s, *buf++);
      //  }


      s.pending_buf.set(s.window.subarray(buf, buf + len), s.pending);
      s.pending += len;
    };
    /* ===========================================================================
     * Compares to subtrees, using the tree depth as tie breaker when
     * the subtrees have equal frequency. This minimizes the worst case length.
     */


    const smaller = (tree, n, m, depth) => {
      const _n2 = n * 2;

      const _m2 = m * 2;

      return tree[_n2]
      /*.Freq*/
      < tree[_m2]
      /*.Freq*/
      || tree[_n2]
      /*.Freq*/
      === tree[_m2]
      /*.Freq*/
      && depth[n] <= depth[m];
    };
    /* ===========================================================================
     * Restore the heap property by moving down the tree starting at node k,
     * exchanging a node with the smallest of its two sons if necessary, stopping
     * when the heap property is re-established (each father smaller than its
     * two sons).
     */


    const pqdownheap = (s, tree, k) => //    deflate_state *s;
    //    ct_data *tree;  /* the tree to restore */
    //    int k;               /* node to move down */
    {
      const v = s.heap[k];
      let j = k << 1;
      /* left son of k */

      while (j <= s.heap_len) {
        /* Set j to the smallest of the two sons: */
        if (j < s.heap_len && smaller(tree, s.heap[j + 1], s.heap[j], s.depth)) {
          j++;
        }
        /* Exit if v is smaller than both sons */


        if (smaller(tree, v, s.heap[j], s.depth)) {
          break;
        }
        /* Exchange v with the smallest son */


        s.heap[k] = s.heap[j];
        k = j;
        /* And continue down the tree, setting j to the left son of k */

        j <<= 1;
      }

      s.heap[k] = v;
    }; // inlined manually
    // const SMALLEST = 1;

    /* ===========================================================================
     * Send the block data compressed using the given Huffman trees
     */


    const compress_block = (s, ltree, dtree) => //    deflate_state *s;
    //    const ct_data *ltree; /* literal tree */
    //    const ct_data *dtree; /* distance tree */
    {
      let dist;
      /* distance of matched string */

      let lc;
      /* match length or unmatched char (if dist == 0) */

      let lx = 0;
      /* running index in l_buf */

      let code;
      /* the code to send */

      let extra;
      /* number of extra bits to send */

      if (s.last_lit !== 0) {
        do {
          dist = s.pending_buf[s.d_buf + lx * 2] << 8 | s.pending_buf[s.d_buf + lx * 2 + 1];
          lc = s.pending_buf[s.l_buf + lx];
          lx++;

          if (dist === 0) {
            send_code(s, lc, ltree);
            /* send a literal byte */
            //Tracecv(isgraph(lc), (stderr," '%c' ", lc));
          } else {
            /* Here, lc is the match length - MIN_MATCH */
            code = _length_code[lc];
            send_code(s, code + LITERALS$1 + 1, ltree);
            /* send the length code */

            extra = extra_lbits[code];

            if (extra !== 0) {
              lc -= base_length[code];
              send_bits(s, lc, extra);
              /* send the extra length bits */
            }

            dist--;
            /* dist is now the match distance - 1 */

            code = d_code(dist); //Assert (code < D_CODES, "bad d_code");

            send_code(s, code, dtree);
            /* send the distance code */

            extra = extra_dbits[code];

            if (extra !== 0) {
              dist -= base_dist[code];
              send_bits(s, dist, extra);
              /* send the extra distance bits */
            }
          }
          /* literal or match pair ? */

          /* Check that the overlay between pending_buf and d_buf+l_buf is ok: */
          //Assert((uInt)(s->pending) < s->lit_bufsize + 2*lx,
          //       "pendingBuf overflow");

        } while (lx < s.last_lit);
      }

      send_code(s, END_BLOCK, ltree);
    };
    /* ===========================================================================
     * Construct one Huffman tree and assigns the code bit strings and lengths.
     * Update the total bit length for the current block.
     * IN assertion: the field freq is set for all tree elements.
     * OUT assertions: the fields len and code are set to the optimal bit length
     *     and corresponding code. The length opt_len is updated; static_len is
     *     also updated if stree is not null. The field max_code is set.
     */


    const build_tree = (s, desc) => //    deflate_state *s;
    //    tree_desc *desc; /* the tree descriptor */
    {
      const tree = desc.dyn_tree;
      const stree = desc.stat_desc.static_tree;
      const has_stree = desc.stat_desc.has_stree;
      const elems = desc.stat_desc.elems;
      let n, m;
      /* iterate over heap elements */

      let max_code = -1;
      /* largest code with non zero frequency */

      let node;
      /* new node being created */

      /* Construct the initial heap, with least frequent element in
       * heap[SMALLEST]. The sons of heap[n] are heap[2*n] and heap[2*n+1].
       * heap[0] is not used.
       */

      s.heap_len = 0;
      s.heap_max = HEAP_SIZE$1;

      for (n = 0; n < elems; n++) {
        if (tree[n * 2]
        /*.Freq*/
        !== 0) {
          s.heap[++s.heap_len] = max_code = n;
          s.depth[n] = 0;
        } else {
          tree[n * 2 + 1]
          /*.Len*/
          = 0;
        }
      }
      /* The pkzip format requires that at least one distance code exists,
       * and that at least one bit should be sent even if there is only one
       * possible code. So to avoid special checks later on we force at least
       * two codes of non zero frequency.
       */


      while (s.heap_len < 2) {
        node = s.heap[++s.heap_len] = max_code < 2 ? ++max_code : 0;
        tree[node * 2]
        /*.Freq*/
        = 1;
        s.depth[node] = 0;
        s.opt_len--;

        if (has_stree) {
          s.static_len -= stree[node * 2 + 1]
          /*.Len*/
          ;
        }
        /* node is 0 or 1 so it does not have extra bits */

      }

      desc.max_code = max_code;
      /* The elements heap[heap_len/2+1 .. heap_len] are leaves of the tree,
       * establish sub-heaps of increasing lengths:
       */

      for (n = s.heap_len >> 1
      /*int /2*/
      ; n >= 1; n--) {
        pqdownheap(s, tree, n);
      }
      /* Construct the Huffman tree by repeatedly combining the least two
       * frequent nodes.
       */


      node = elems;
      /* next internal node of the tree */

      do {
        //pqremove(s, tree, n);  /* n = node of least frequency */

        /*** pqremove ***/
        n = s.heap[1
        /*SMALLEST*/
        ];
        s.heap[1
        /*SMALLEST*/
        ] = s.heap[s.heap_len--];
        pqdownheap(s, tree, 1
        /*SMALLEST*/
        );
        /***/

        m = s.heap[1
        /*SMALLEST*/
        ];
        /* m = node of next least frequency */

        s.heap[--s.heap_max] = n;
        /* keep the nodes sorted by frequency */

        s.heap[--s.heap_max] = m;
        /* Create a new node father of n and m */

        tree[node * 2]
        /*.Freq*/
        = tree[n * 2]
        /*.Freq*/
        + tree[m * 2]
        /*.Freq*/
        ;
        s.depth[node] = (s.depth[n] >= s.depth[m] ? s.depth[n] : s.depth[m]) + 1;
        tree[n * 2 + 1]
        /*.Dad*/
        = tree[m * 2 + 1]
        /*.Dad*/
        = node;
        /* and insert the new node in the heap */

        s.heap[1
        /*SMALLEST*/
        ] = node++;
        pqdownheap(s, tree, 1
        /*SMALLEST*/
        );
      } while (s.heap_len >= 2);

      s.heap[--s.heap_max] = s.heap[1
      /*SMALLEST*/
      ];
      /* At this point, the fields freq and dad are set. We can now
       * generate the bit lengths.
       */

      gen_bitlen(s, desc);
      /* The field len is now set, we can generate the bit codes */

      gen_codes(tree, max_code, s.bl_count);
    };
    /* ===========================================================================
     * Scan a literal or distance tree to determine the frequencies of the codes
     * in the bit length tree.
     */


    const scan_tree = (s, tree, max_code) => //    deflate_state *s;
    //    ct_data *tree;   /* the tree to be scanned */
    //    int max_code;    /* and its largest code of non zero frequency */
    {
      let n;
      /* iterates over all tree elements */

      let prevlen = -1;
      /* last emitted length */

      let curlen;
      /* length of current code */

      let nextlen = tree[0 * 2 + 1]
      /*.Len*/
      ;
      /* length of next code */

      let count = 0;
      /* repeat count of the current code */

      let max_count = 7;
      /* max repeat count */

      let min_count = 4;
      /* min repeat count */

      if (nextlen === 0) {
        max_count = 138;
        min_count = 3;
      }

      tree[(max_code + 1) * 2 + 1]
      /*.Len*/
      = 0xffff;
      /* guard */

      for (n = 0; n <= max_code; n++) {
        curlen = nextlen;
        nextlen = tree[(n + 1) * 2 + 1]
        /*.Len*/
        ;

        if (++count < max_count && curlen === nextlen) {
          continue;
        } else if (count < min_count) {
          s.bl_tree[curlen * 2]
          /*.Freq*/
          += count;
        } else if (curlen !== 0) {
          if (curlen !== prevlen) {
            s.bl_tree[curlen * 2] /*.Freq*/++;
          }

          s.bl_tree[REP_3_6 * 2] /*.Freq*/++;
        } else if (count <= 10) {
          s.bl_tree[REPZ_3_10 * 2] /*.Freq*/++;
        } else {
          s.bl_tree[REPZ_11_138 * 2] /*.Freq*/++;
        }

        count = 0;
        prevlen = curlen;

        if (nextlen === 0) {
          max_count = 138;
          min_count = 3;
        } else if (curlen === nextlen) {
          max_count = 6;
          min_count = 3;
        } else {
          max_count = 7;
          min_count = 4;
        }
      }
    };
    /* ===========================================================================
     * Send a literal or distance tree in compressed form, using the codes in
     * bl_tree.
     */


    const send_tree = (s, tree, max_code) => //    deflate_state *s;
    //    ct_data *tree; /* the tree to be scanned */
    //    int max_code;       /* and its largest code of non zero frequency */
    {
      let n;
      /* iterates over all tree elements */

      let prevlen = -1;
      /* last emitted length */

      let curlen;
      /* length of current code */

      let nextlen = tree[0 * 2 + 1]
      /*.Len*/
      ;
      /* length of next code */

      let count = 0;
      /* repeat count of the current code */

      let max_count = 7;
      /* max repeat count */

      let min_count = 4;
      /* min repeat count */

      /* tree[max_code+1].Len = -1; */

      /* guard already set */

      if (nextlen === 0) {
        max_count = 138;
        min_count = 3;
      }

      for (n = 0; n <= max_code; n++) {
        curlen = nextlen;
        nextlen = tree[(n + 1) * 2 + 1]
        /*.Len*/
        ;

        if (++count < max_count && curlen === nextlen) {
          continue;
        } else if (count < min_count) {
          do {
            send_code(s, curlen, s.bl_tree);
          } while (--count !== 0);
        } else if (curlen !== 0) {
          if (curlen !== prevlen) {
            send_code(s, curlen, s.bl_tree);
            count--;
          } //Assert(count >= 3 && count <= 6, " 3_6?");


          send_code(s, REP_3_6, s.bl_tree);
          send_bits(s, count - 3, 2);
        } else if (count <= 10) {
          send_code(s, REPZ_3_10, s.bl_tree);
          send_bits(s, count - 3, 3);
        } else {
          send_code(s, REPZ_11_138, s.bl_tree);
          send_bits(s, count - 11, 7);
        }

        count = 0;
        prevlen = curlen;

        if (nextlen === 0) {
          max_count = 138;
          min_count = 3;
        } else if (curlen === nextlen) {
          max_count = 6;
          min_count = 3;
        } else {
          max_count = 7;
          min_count = 4;
        }
      }
    };
    /* ===========================================================================
     * Construct the Huffman tree for the bit lengths and return the index in
     * bl_order of the last bit length code to send.
     */


    const build_bl_tree = s => {
      let max_blindex;
      /* index of last bit length code of non zero freq */

      /* Determine the bit length frequencies for literal and distance trees */

      scan_tree(s, s.dyn_ltree, s.l_desc.max_code);
      scan_tree(s, s.dyn_dtree, s.d_desc.max_code);
      /* Build the bit length tree: */

      build_tree(s, s.bl_desc);
      /* opt_len now includes the length of the tree representations, except
       * the lengths of the bit lengths codes and the 5+5+4 bits for the counts.
       */

      /* Determine the number of bit length codes to send. The pkzip format
       * requires that at least 4 bit length codes be sent. (appnote.txt says
       * 3 but the actual value used is 4.)
       */

      for (max_blindex = BL_CODES$1 - 1; max_blindex >= 3; max_blindex--) {
        if (s.bl_tree[bl_order[max_blindex] * 2 + 1]
        /*.Len*/
        !== 0) {
          break;
        }
      }
      /* Update opt_len to include the bit length tree and counts */


      s.opt_len += 3 * (max_blindex + 1) + 5 + 5 + 4; //Tracev((stderr, "\ndyn trees: dyn %ld, stat %ld",
      //        s->opt_len, s->static_len));

      return max_blindex;
    };
    /* ===========================================================================
     * Send the header for a block using dynamic Huffman trees: the counts, the
     * lengths of the bit length codes, the literal tree and the distance tree.
     * IN assertion: lcodes >= 257, dcodes >= 1, blcodes >= 4.
     */


    const send_all_trees = (s, lcodes, dcodes, blcodes) => //    deflate_state *s;
    //    int lcodes, dcodes, blcodes; /* number of codes for each tree */
    {
      let rank;
      /* index in bl_order */
      //Assert (lcodes >= 257 && dcodes >= 1 && blcodes >= 4, "not enough codes");
      //Assert (lcodes <= L_CODES && dcodes <= D_CODES && blcodes <= BL_CODES,
      //        "too many codes");
      //Tracev((stderr, "\nbl counts: "));

      send_bits(s, lcodes - 257, 5);
      /* not +255 as stated in appnote.txt */

      send_bits(s, dcodes - 1, 5);
      send_bits(s, blcodes - 4, 4);
      /* not -3 as stated in appnote.txt */

      for (rank = 0; rank < blcodes; rank++) {
        //Tracev((stderr, "\nbl code %2d ", bl_order[rank]));
        send_bits(s, s.bl_tree[bl_order[rank] * 2 + 1]
        /*.Len*/
        , 3);
      } //Tracev((stderr, "\nbl tree: sent %ld", s->bits_sent));


      send_tree(s, s.dyn_ltree, lcodes - 1);
      /* literal tree */
      //Tracev((stderr, "\nlit tree: sent %ld", s->bits_sent));

      send_tree(s, s.dyn_dtree, dcodes - 1);
      /* distance tree */
      //Tracev((stderr, "\ndist tree: sent %ld", s->bits_sent));
    };
    /* ===========================================================================
     * Check if the data type is TEXT or BINARY, using the following algorithm:
     * - TEXT if the two conditions below are satisfied:
     *    a) There are no non-portable control characters belonging to the
     *       "black list" (0..6, 14..25, 28..31).
     *    b) There is at least one printable character belonging to the
     *       "white list" (9 {TAB}, 10 {LF}, 13 {CR}, 32..255).
     * - BINARY otherwise.
     * - The following partially-portable control characters form a
     *   "gray list" that is ignored in this detection algorithm:
     *   (7 {BEL}, 8 {BS}, 11 {VT}, 12 {FF}, 26 {SUB}, 27 {ESC}).
     * IN assertion: the fields Freq of dyn_ltree are set.
     */


    const detect_data_type = s => {
      /* black_mask is the bit mask of black-listed bytes
       * set bits 0..6, 14..25, and 28..31
       * 0xf3ffc07f = binary 11110011111111111100000001111111
       */
      let black_mask = 0xf3ffc07f;
      let n;
      /* Check for non-textual ("black-listed") bytes. */

      for (n = 0; n <= 31; n++, black_mask >>>= 1) {
        if (black_mask & 1 && s.dyn_ltree[n * 2]
        /*.Freq*/
        !== 0) {
          return Z_BINARY;
        }
      }
      /* Check for textual ("white-listed") bytes. */


      if (s.dyn_ltree[9 * 2]
      /*.Freq*/
      !== 0 || s.dyn_ltree[10 * 2]
      /*.Freq*/
      !== 0 || s.dyn_ltree[13 * 2]
      /*.Freq*/
      !== 0) {
        return Z_TEXT;
      }

      for (n = 32; n < LITERALS$1; n++) {
        if (s.dyn_ltree[n * 2]
        /*.Freq*/
        !== 0) {
          return Z_TEXT;
        }
      }
      /* There are no "black-listed" or "white-listed" bytes:
       * this stream either is empty or has tolerated ("gray-listed") bytes only.
       */


      return Z_BINARY;
    };

    let static_init_done = false;
    /* ===========================================================================
     * Initialize the tree data structures for a new zlib stream.
     */

    const _tr_init$1 = s => {
      if (!static_init_done) {
        tr_static_init();
        static_init_done = true;
      }

      s.l_desc = new TreeDesc(s.dyn_ltree, static_l_desc);
      s.d_desc = new TreeDesc(s.dyn_dtree, static_d_desc);
      s.bl_desc = new TreeDesc(s.bl_tree, static_bl_desc);
      s.bi_buf = 0;
      s.bi_valid = 0;
      /* Initialize the first block of the first file: */

      init_block(s);
    };
    /* ===========================================================================
     * Send a stored block
     */


    const _tr_stored_block$1 = (s, buf, stored_len, last) => //DeflateState *s;
    //charf *buf;       /* input block */
    //ulg stored_len;   /* length of input block */
    //int last;         /* one if this is the last block for a file */
    {
      send_bits(s, (STORED_BLOCK << 1) + (last ? 1 : 0), 3);
      /* send block type */

      copy_block(s, buf, stored_len, true);
      /* with header */
    };
    /* ===========================================================================
     * Send one empty static block to give enough lookahead for inflate.
     * This takes 10 bits, of which 7 may remain in the bit buffer.
     */


    const _tr_align$1 = s => {
      send_bits(s, STATIC_TREES << 1, 3);
      send_code(s, END_BLOCK, static_ltree);
      bi_flush(s);
    };
    /* ===========================================================================
     * Determine the best encoding for the current block: dynamic trees, static
     * trees or store, and output the encoded block to the zip file.
     */


    const _tr_flush_block$1 = (s, buf, stored_len, last) => //DeflateState *s;
    //charf *buf;       /* input block, or NULL if too old */
    //ulg stored_len;   /* length of input block */
    //int last;         /* one if this is the last block for a file */
    {
      let opt_lenb, static_lenb;
      /* opt_len and static_len in bytes */

      let max_blindex = 0;
      /* index of last bit length code of non zero freq */

      /* Build the Huffman trees unless a stored block is forced */

      if (s.level > 0) {
        /* Check if the file is binary or text */
        if (s.strm.data_type === Z_UNKNOWN$1) {
          s.strm.data_type = detect_data_type(s);
        }
        /* Construct the literal and distance trees */


        build_tree(s, s.l_desc); // Tracev((stderr, "\nlit data: dyn %ld, stat %ld", s->opt_len,
        //        s->static_len));

        build_tree(s, s.d_desc); // Tracev((stderr, "\ndist data: dyn %ld, stat %ld", s->opt_len,
        //        s->static_len));

        /* At this point, opt_len and static_len are the total bit lengths of
         * the compressed block data, excluding the tree representations.
         */

        /* Build the bit length tree for the above two trees, and get the index
         * in bl_order of the last bit length code to send.
         */

        max_blindex = build_bl_tree(s);
        /* Determine the best encoding. Compute the block lengths in bytes. */

        opt_lenb = s.opt_len + 3 + 7 >>> 3;
        static_lenb = s.static_len + 3 + 7 >>> 3; // Tracev((stderr, "\nopt %lu(%lu) stat %lu(%lu) stored %lu lit %u ",
        //        opt_lenb, s->opt_len, static_lenb, s->static_len, stored_len,
        //        s->last_lit));

        if (static_lenb <= opt_lenb) {
          opt_lenb = static_lenb;
        }
      } else {
        // Assert(buf != (char*)0, "lost buf");
        opt_lenb = static_lenb = stored_len + 5;
        /* force a stored block */
      }

      if (stored_len + 4 <= opt_lenb && buf !== -1) {
        /* 4: two words for the lengths */

        /* The test buf != NULL is only necessary if LIT_BUFSIZE > WSIZE.
         * Otherwise we can't have processed more than WSIZE input bytes since
         * the last block flush, because compression would have been
         * successful. If LIT_BUFSIZE <= WSIZE, it is never too late to
         * transform a block into a stored block.
         */
        _tr_stored_block$1(s, buf, stored_len, last);
      } else if (s.strategy === Z_FIXED$1 || static_lenb === opt_lenb) {
        send_bits(s, (STATIC_TREES << 1) + (last ? 1 : 0), 3);
        compress_block(s, static_ltree, static_dtree);
      } else {
        send_bits(s, (DYN_TREES << 1) + (last ? 1 : 0), 3);
        send_all_trees(s, s.l_desc.max_code + 1, s.d_desc.max_code + 1, max_blindex + 1);
        compress_block(s, s.dyn_ltree, s.dyn_dtree);
      } // Assert (s->compressed_len == s->bits_sent, "bad compressed size");

      /* The above check is made mod 2^32, for files larger than 512 MB
       * and uLong implemented on 32 bits.
       */


      init_block(s);

      if (last) {
        bi_windup(s);
      } // Tracev((stderr,"\ncomprlen %lu(%lu) ", s->compressed_len>>3,
      //       s->compressed_len-7*last));

    };
    /* ===========================================================================
     * Save the match info and tally the frequency counts. Return true if
     * the current block must be flushed.
     */


    const _tr_tally$1 = (s, dist, lc) => //    deflate_state *s;
    //    unsigned dist;  /* distance of matched string */
    //    unsigned lc;    /* match length-MIN_MATCH or unmatched char (if dist==0) */
    {
      //let out_length, in_length, dcode;
      s.pending_buf[s.d_buf + s.last_lit * 2] = dist >>> 8 & 0xff;
      s.pending_buf[s.d_buf + s.last_lit * 2 + 1] = dist & 0xff;
      s.pending_buf[s.l_buf + s.last_lit] = lc & 0xff;
      s.last_lit++;

      if (dist === 0) {
        /* lc is the unmatched char */
        s.dyn_ltree[lc * 2] /*.Freq*/++;
      } else {
        s.matches++;
        /* Here, lc is the match length - MIN_MATCH */

        dist--;
        /* dist = match distance - 1 */
        //Assert((ush)dist < (ush)MAX_DIST(s) &&
        //       (ush)lc <= (ush)(MAX_MATCH-MIN_MATCH) &&
        //       (ush)d_code(dist) < (ush)D_CODES,  "_tr_tally: bad match");

        s.dyn_ltree[(_length_code[lc] + LITERALS$1 + 1) * 2] /*.Freq*/++;
        s.dyn_dtree[d_code(dist) * 2] /*.Freq*/++;
      } // (!) This block is disabled in zlib defaults,
      // don't enable it for binary compatibility
      //#ifdef TRUNCATE_BLOCK
      //  /* Try to guess if it is profitable to stop the current block here */
      //  if ((s.last_lit & 0x1fff) === 0 && s.level > 2) {
      //    /* Compute an upper bound for the compressed length */
      //    out_length = s.last_lit*8;
      //    in_length = s.strstart - s.block_start;
      //
      //    for (dcode = 0; dcode < D_CODES; dcode++) {
      //      out_length += s.dyn_dtree[dcode*2]/*.Freq*/ * (5 + extra_dbits[dcode]);
      //    }
      //    out_length >>>= 3;
      //    //Tracev((stderr,"\nlast_lit %u, in %ld, out ~%ld(%ld%%) ",
      //    //       s->last_lit, in_length, out_length,
      //    //       100L - out_length*100L/in_length));
      //    if (s.matches < (s.last_lit>>1)/*int /2*/ && out_length < (in_length>>1)/*int /2*/) {
      //      return true;
      //    }
      //  }
      //#endif


      return s.last_lit === s.lit_bufsize - 1;
      /* We avoid equality with lit_bufsize because of wraparound at 64K
       * on 16 bit machines and because stored blocks are restricted to
       * 64K-1 bytes.
       */
    };

    var _tr_init_1 = _tr_init$1;
    var _tr_stored_block_1 = _tr_stored_block$1;
    var _tr_flush_block_1 = _tr_flush_block$1;
    var _tr_tally_1 = _tr_tally$1;
    var _tr_align_1 = _tr_align$1;
    var trees = {
      _tr_init: _tr_init_1,
      _tr_stored_block: _tr_stored_block_1,
      _tr_flush_block: _tr_flush_block_1,
      _tr_tally: _tr_tally_1,
      _tr_align: _tr_align_1
    }; // Note: adler32 takes 12% for level 0 and 2% for level 6.
    // It isn't worth it to make additional optimizations as in original.
    // Small size is preferable.
    // (C) 1995-2013 Jean-loup Gailly and Mark Adler
    // (C) 2014-2017 Vitaly Puzrin and Andrey Tupitsin
    //
    // This software is provided 'as-is', without any express or implied
    // warranty. In no event will the authors be held liable for any damages
    // arising from the use of this software.
    //
    // Permission is granted to anyone to use this software for any purpose,
    // including commercial applications, and to alter it and redistribute it
    // freely, subject to the following restrictions:
    //
    // 1. The origin of this software must not be misrepresented; you must not
    //   claim that you wrote the original software. If you use this software
    //   in a product, an acknowledgment in the product documentation would be
    //   appreciated but is not required.
    // 2. Altered source versions must be plainly marked as such, and must not be
    //   misrepresented as being the original software.
    // 3. This notice may not be removed or altered from any source distribution.

    const adler32 = (adler, buf, len, pos) => {
      let s1 = adler & 0xffff | 0,
          s2 = adler >>> 16 & 0xffff | 0,
          n = 0;

      while (len !== 0) {
        // Set limit ~ twice less than 5552, to keep
        // s2 in 31-bits, because we force signed ints.
        // in other case %= will fail.
        n = len > 2000 ? 2000 : len;
        len -= n;

        do {
          s1 = s1 + buf[pos++] | 0;
          s2 = s2 + s1 | 0;
        } while (--n);

        s1 %= 65521;
        s2 %= 65521;
      }

      return s1 | s2 << 16 | 0;
    };

    var adler32_1 = adler32; // Note: we can't get significant speed boost here.
    // So write code to minimize size - no pregenerated tables
    // and array tools dependencies.
    // (C) 1995-2013 Jean-loup Gailly and Mark Adler
    // (C) 2014-2017 Vitaly Puzrin and Andrey Tupitsin
    //
    // This software is provided 'as-is', without any express or implied
    // warranty. In no event will the authors be held liable for any damages
    // arising from the use of this software.
    //
    // Permission is granted to anyone to use this software for any purpose,
    // including commercial applications, and to alter it and redistribute it
    // freely, subject to the following restrictions:
    //
    // 1. The origin of this software must not be misrepresented; you must not
    //   claim that you wrote the original software. If you use this software
    //   in a product, an acknowledgment in the product documentation would be
    //   appreciated but is not required.
    // 2. Altered source versions must be plainly marked as such, and must not be
    //   misrepresented as being the original software.
    // 3. This notice may not be removed or altered from any source distribution.
    // Use ordinary array, since untyped makes no boost here

    const makeTable = () => {
      let c,
          table = [];

      for (var n = 0; n < 256; n++) {
        c = n;

        for (var k = 0; k < 8; k++) {
          c = c & 1 ? 0xEDB88320 ^ c >>> 1 : c >>> 1;
        }

        table[n] = c;
      }

      return table;
    }; // Create table on load. Just 255 signed longs. Not a problem.


    const crcTable = new Uint32Array(makeTable());

    const crc32 = (crc, buf, len, pos) => {
      const t = crcTable;
      const end = pos + len;
      crc ^= -1;

      for (let i = pos; i < end; i++) {
        crc = crc >>> 8 ^ t[(crc ^ buf[i]) & 0xFF];
      }

      return crc ^ -1; // >>> 0;
    };

    var crc32_1 = crc32; // (C) 1995-2013 Jean-loup Gailly and Mark Adler
    // (C) 2014-2017 Vitaly Puzrin and Andrey Tupitsin
    //
    // This software is provided 'as-is', without any express or implied
    // warranty. In no event will the authors be held liable for any damages
    // arising from the use of this software.
    //
    // Permission is granted to anyone to use this software for any purpose,
    // including commercial applications, and to alter it and redistribute it
    // freely, subject to the following restrictions:
    //
    // 1. The origin of this software must not be misrepresented; you must not
    //   claim that you wrote the original software. If you use this software
    //   in a product, an acknowledgment in the product documentation would be
    //   appreciated but is not required.
    // 2. Altered source versions must be plainly marked as such, and must not be
    //   misrepresented as being the original software.
    // 3. This notice may not be removed or altered from any source distribution.

    var messages = {
      2: 'need dictionary',

      /* Z_NEED_DICT       2  */
      1: 'stream end',

      /* Z_STREAM_END      1  */
      0: '',

      /* Z_OK              0  */
      '-1': 'file error',

      /* Z_ERRNO         (-1) */
      '-2': 'stream error',

      /* Z_STREAM_ERROR  (-2) */
      '-3': 'data error',

      /* Z_DATA_ERROR    (-3) */
      '-4': 'insufficient memory',

      /* Z_MEM_ERROR     (-4) */
      '-5': 'buffer error',

      /* Z_BUF_ERROR     (-5) */
      '-6': 'incompatible version'
      /* Z_VERSION_ERROR (-6) */

    }; // (C) 1995-2013 Jean-loup Gailly and Mark Adler
    // (C) 2014-2017 Vitaly Puzrin and Andrey Tupitsin
    //
    // This software is provided 'as-is', without any express or implied
    // warranty. In no event will the authors be held liable for any damages
    // arising from the use of this software.
    //
    // Permission is granted to anyone to use this software for any purpose,
    // including commercial applications, and to alter it and redistribute it
    // freely, subject to the following restrictions:
    //
    // 1. The origin of this software must not be misrepresented; you must not
    //   claim that you wrote the original software. If you use this software
    //   in a product, an acknowledgment in the product documentation would be
    //   appreciated but is not required.
    // 2. Altered source versions must be plainly marked as such, and must not be
    //   misrepresented as being the original software.
    // 3. This notice may not be removed or altered from any source distribution.

    var constants$2 = {
      /* Allowed flush values; see deflate() and inflate() below for details */
      Z_NO_FLUSH: 0,
      Z_PARTIAL_FLUSH: 1,
      Z_SYNC_FLUSH: 2,
      Z_FULL_FLUSH: 3,
      Z_FINISH: 4,
      Z_BLOCK: 5,
      Z_TREES: 6,

      /* Return codes for the compression/decompression functions. Negative values
      * are errors, positive values are used for special but normal events.
      */
      Z_OK: 0,
      Z_STREAM_END: 1,
      Z_NEED_DICT: 2,
      Z_ERRNO: -1,
      Z_STREAM_ERROR: -2,
      Z_DATA_ERROR: -3,
      Z_MEM_ERROR: -4,
      Z_BUF_ERROR: -5,
      //Z_VERSION_ERROR: -6,

      /* compression levels */
      Z_NO_COMPRESSION: 0,
      Z_BEST_SPEED: 1,
      Z_BEST_COMPRESSION: 9,
      Z_DEFAULT_COMPRESSION: -1,
      Z_FILTERED: 1,
      Z_HUFFMAN_ONLY: 2,
      Z_RLE: 3,
      Z_FIXED: 4,
      Z_DEFAULT_STRATEGY: 0,

      /* Possible values of the data_type field (though see inflate()) */
      Z_BINARY: 0,
      Z_TEXT: 1,
      //Z_ASCII:                1, // = Z_TEXT (deprecated)
      Z_UNKNOWN: 2,

      /* The deflate compression method */
      Z_DEFLATED: 8 //Z_NULL:                 null // Use -1 or null inline, depending on var type

    }; // (C) 1995-2013 Jean-loup Gailly and Mark Adler
    // (C) 2014-2017 Vitaly Puzrin and Andrey Tupitsin
    //
    // This software is provided 'as-is', without any express or implied
    // warranty. In no event will the authors be held liable for any damages
    // arising from the use of this software.
    //
    // Permission is granted to anyone to use this software for any purpose,
    // including commercial applications, and to alter it and redistribute it
    // freely, subject to the following restrictions:
    //
    // 1. The origin of this software must not be misrepresented; you must not
    //   claim that you wrote the original software. If you use this software
    //   in a product, an acknowledgment in the product documentation would be
    //   appreciated but is not required.
    // 2. Altered source versions must be plainly marked as such, and must not be
    //   misrepresented as being the original software.
    // 3. This notice may not be removed or altered from any source distribution.

    const {
      _tr_init,
      _tr_stored_block,
      _tr_flush_block,
      _tr_tally,
      _tr_align
    } = trees;
    /* Public constants ==========================================================*/

    /* ===========================================================================*/

    const {
      Z_NO_FLUSH: Z_NO_FLUSH$2,
      Z_PARTIAL_FLUSH,
      Z_FULL_FLUSH: Z_FULL_FLUSH$1,
      Z_FINISH: Z_FINISH$3,
      Z_BLOCK: Z_BLOCK$1,
      Z_OK: Z_OK$3,
      Z_STREAM_END: Z_STREAM_END$3,
      Z_STREAM_ERROR: Z_STREAM_ERROR$2,
      Z_DATA_ERROR: Z_DATA_ERROR$2,
      Z_BUF_ERROR: Z_BUF_ERROR$1,
      Z_DEFAULT_COMPRESSION: Z_DEFAULT_COMPRESSION$1,
      Z_FILTERED,
      Z_HUFFMAN_ONLY,
      Z_RLE,
      Z_FIXED,
      Z_DEFAULT_STRATEGY: Z_DEFAULT_STRATEGY$1,
      Z_UNKNOWN,
      Z_DEFLATED: Z_DEFLATED$2
    } = constants$2;
    /*============================================================================*/

    const MAX_MEM_LEVEL = 9;
    /* Maximum value for memLevel in deflateInit2 */

    const MAX_WBITS$1 = 15;
    /* 32K LZ77 window */

    const DEF_MEM_LEVEL = 8;
    const LENGTH_CODES = 29;
    /* number of length codes, not counting the special END_BLOCK code */

    const LITERALS = 256;
    /* number of literal bytes 0..255 */

    const L_CODES = LITERALS + 1 + LENGTH_CODES;
    /* number of Literal or Length codes, including the END_BLOCK code */

    const D_CODES = 30;
    /* number of distance codes */

    const BL_CODES = 19;
    /* number of codes used to transfer the bit lengths */

    const HEAP_SIZE = 2 * L_CODES + 1;
    /* maximum heap size */

    const MAX_BITS = 15;
    /* All codes must not exceed MAX_BITS bits */

    const MIN_MATCH = 3;
    const MAX_MATCH = 258;
    const MIN_LOOKAHEAD = MAX_MATCH + MIN_MATCH + 1;
    const PRESET_DICT = 0x20;
    const INIT_STATE = 42;
    const EXTRA_STATE = 69;
    const NAME_STATE = 73;
    const COMMENT_STATE = 91;
    const HCRC_STATE = 103;
    const BUSY_STATE = 113;
    const FINISH_STATE = 666;
    const BS_NEED_MORE = 1;
    /* block not completed, need more input or more output */

    const BS_BLOCK_DONE = 2;
    /* block flush performed */

    const BS_FINISH_STARTED = 3;
    /* finish started, need only more output at next deflate */

    const BS_FINISH_DONE = 4;
    /* finish done, accept no more input or output */

    const OS_CODE = 0x03; // Unix :) . Don't detect, use this default.

    const err = (strm, errorCode) => {
      strm.msg = messages[errorCode];
      return errorCode;
    };

    const rank = f => {
      return (f << 1) - (f > 4 ? 9 : 0);
    };

    const zero = buf => {
      let len = buf.length;

      while (--len >= 0) {
        buf[len] = 0;
      }
    };
    /* eslint-disable new-cap */


    let HASH_ZLIB = (s, prev, data) => (prev << s.hash_shift ^ data) & s.hash_mask; // This hash causes less collisions, https://github.com/nodeca/pako/issues/135
    // But breaks binary compatibility
    //let HASH_FAST = (s, prev, data) => ((prev << 8) + (prev >> 8) + (data << 4)) & s.hash_mask;


    let HASH = HASH_ZLIB;
    /* =========================================================================
     * Flush as much pending output as possible. All deflate() output goes
     * through this function so some applications may wish to modify it
     * to avoid allocating a large strm->output buffer and copying into it.
     * (See also read_buf()).
     */

    const flush_pending = strm => {
      const s = strm.state; //_tr_flush_bits(s);

      let len = s.pending;

      if (len > strm.avail_out) {
        len = strm.avail_out;
      }

      if (len === 0) {
        return;
      }

      strm.output.set(s.pending_buf.subarray(s.pending_out, s.pending_out + len), strm.next_out);
      strm.next_out += len;
      s.pending_out += len;
      strm.total_out += len;
      strm.avail_out -= len;
      s.pending -= len;

      if (s.pending === 0) {
        s.pending_out = 0;
      }
    };

    const flush_block_only = (s, last) => {
      _tr_flush_block(s, s.block_start >= 0 ? s.block_start : -1, s.strstart - s.block_start, last);

      s.block_start = s.strstart;
      flush_pending(s.strm);
    };

    const put_byte = (s, b) => {
      s.pending_buf[s.pending++] = b;
    };
    /* =========================================================================
     * Put a short in the pending buffer. The 16-bit value is put in MSB order.
     * IN assertion: the stream state is correct and there is enough room in
     * pending_buf.
     */


    const putShortMSB = (s, b) => {
      //  put_byte(s, (Byte)(b >> 8));
      //  put_byte(s, (Byte)(b & 0xff));
      s.pending_buf[s.pending++] = b >>> 8 & 0xff;
      s.pending_buf[s.pending++] = b & 0xff;
    };
    /* ===========================================================================
     * Read a new buffer from the current input stream, update the adler32
     * and total number of bytes read.  All deflate() input goes through
     * this function so some applications may wish to modify it to avoid
     * allocating a large strm->input buffer and copying from it.
     * (See also flush_pending()).
     */


    const read_buf = (strm, buf, start, size) => {
      let len = strm.avail_in;

      if (len > size) {
        len = size;
      }

      if (len === 0) {
        return 0;
      }

      strm.avail_in -= len; // zmemcpy(buf, strm->next_in, len);

      buf.set(strm.input.subarray(strm.next_in, strm.next_in + len), start);

      if (strm.state.wrap === 1) {
        strm.adler = adler32_1(strm.adler, buf, len, start);
      } else if (strm.state.wrap === 2) {
        strm.adler = crc32_1(strm.adler, buf, len, start);
      }

      strm.next_in += len;
      strm.total_in += len;
      return len;
    };
    /* ===========================================================================
     * Set match_start to the longest match starting at the given string and
     * return its length. Matches shorter or equal to prev_length are discarded,
     * in which case the result is equal to prev_length and match_start is
     * garbage.
     * IN assertions: cur_match is the head of the hash chain for the current
     *   string (strstart) and its distance is <= MAX_DIST, and prev_length >= 1
     * OUT assertion: the match length is not greater than s->lookahead.
     */


    const longest_match = (s, cur_match) => {
      let chain_length = s.max_chain_length;
      /* max hash chain length */

      let scan = s.strstart;
      /* current string */

      let match;
      /* matched string */

      let len;
      /* length of current match */

      let best_len = s.prev_length;
      /* best match length so far */

      let nice_match = s.nice_match;
      /* stop if match long enough */

      const limit = s.strstart > s.w_size - MIN_LOOKAHEAD ? s.strstart - (s.w_size - MIN_LOOKAHEAD) : 0
      /*NIL*/
      ;
      const _win = s.window; // shortcut

      const wmask = s.w_mask;
      const prev = s.prev;
      /* Stop when cur_match becomes <= limit. To simplify the code,
       * we prevent matches with the string of window index 0.
       */

      const strend = s.strstart + MAX_MATCH;
      let scan_end1 = _win[scan + best_len - 1];
      let scan_end = _win[scan + best_len];
      /* The code is optimized for HASH_BITS >= 8 and MAX_MATCH-2 multiple of 16.
       * It is easy to get rid of this optimization if necessary.
       */
      // Assert(s->hash_bits >= 8 && MAX_MATCH == 258, "Code too clever");

      /* Do not waste too much time if we already have a good match: */

      if (s.prev_length >= s.good_match) {
        chain_length >>= 2;
      }
      /* Do not look for matches beyond the end of the input. This is necessary
       * to make deflate deterministic.
       */


      if (nice_match > s.lookahead) {
        nice_match = s.lookahead;
      } // Assert((ulg)s->strstart <= s->window_size-MIN_LOOKAHEAD, "need lookahead");


      do {
        // Assert(cur_match < s->strstart, "no future");
        match = cur_match;
        /* Skip to next match if the match length cannot increase
         * or if the match length is less than 2.  Note that the checks below
         * for insufficient lookahead only occur occasionally for performance
         * reasons.  Therefore uninitialized memory will be accessed, and
         * conditional jumps will be made that depend on those values.
         * However the length of the match is limited to the lookahead, so
         * the output of deflate is not affected by the uninitialized values.
         */

        if (_win[match + best_len] !== scan_end || _win[match + best_len - 1] !== scan_end1 || _win[match] !== _win[scan] || _win[++match] !== _win[scan + 1]) {
          continue;
        }
        /* The check at best_len-1 can be removed because it will be made
         * again later. (This heuristic is not always a win.)
         * It is not necessary to compare scan[2] and match[2] since they
         * are always equal when the other bytes match, given that
         * the hash keys are equal and that HASH_BITS >= 8.
         */


        scan += 2;
        match++; // Assert(*scan == *match, "match[2]?");

        /* We check for insufficient lookahead only every 8th comparison;
         * the 256th check will be made at strstart+258.
         */

        do {
          /*jshint noempty:false*/
        } while (_win[++scan] === _win[++match] && _win[++scan] === _win[++match] && _win[++scan] === _win[++match] && _win[++scan] === _win[++match] && _win[++scan] === _win[++match] && _win[++scan] === _win[++match] && _win[++scan] === _win[++match] && _win[++scan] === _win[++match] && scan < strend); // Assert(scan <= s->window+(unsigned)(s->window_size-1), "wild scan");


        len = MAX_MATCH - (strend - scan);
        scan = strend - MAX_MATCH;

        if (len > best_len) {
          s.match_start = cur_match;
          best_len = len;

          if (len >= nice_match) {
            break;
          }

          scan_end1 = _win[scan + best_len - 1];
          scan_end = _win[scan + best_len];
        }
      } while ((cur_match = prev[cur_match & wmask]) > limit && --chain_length !== 0);

      if (best_len <= s.lookahead) {
        return best_len;
      }

      return s.lookahead;
    };
    /* ===========================================================================
     * Fill the window when the lookahead becomes insufficient.
     * Updates strstart and lookahead.
     *
     * IN assertion: lookahead < MIN_LOOKAHEAD
     * OUT assertions: strstart <= window_size-MIN_LOOKAHEAD
     *    At least one byte has been read, or avail_in == 0; reads are
     *    performed for at least two bytes (required for the zip translate_eol
     *    option -- not supported here).
     */


    const fill_window = s => {
      const _w_size = s.w_size;
      let p, n, m, more, str; //Assert(s->lookahead < MIN_LOOKAHEAD, "already enough lookahead");

      do {
        more = s.window_size - s.lookahead - s.strstart; // JS ints have 32 bit, block below not needed

        /* Deal with !@#$% 64K limit: */
        //if (sizeof(int) <= 2) {
        //    if (more == 0 && s->strstart == 0 && s->lookahead == 0) {
        //        more = wsize;
        //
        //  } else if (more == (unsigned)(-1)) {
        //        /* Very unlikely, but possible on 16 bit machine if
        //         * strstart == 0 && lookahead == 1 (input done a byte at time)
        //         */
        //        more--;
        //    }
        //}

        /* If the window is almost full and there is insufficient lookahead,
         * move the upper half to the lower one to make room in the upper half.
         */

        if (s.strstart >= _w_size + (_w_size - MIN_LOOKAHEAD)) {
          s.window.set(s.window.subarray(_w_size, _w_size + _w_size), 0);
          s.match_start -= _w_size;
          s.strstart -= _w_size;
          /* we now have strstart >= MAX_DIST */

          s.block_start -= _w_size;
          /* Slide the hash table (could be avoided with 32 bit values
           at the expense of memory usage). We slide even when level == 0
           to keep the hash table consistent if we switch back to level > 0
           later. (Using level 0 permanently is not an optimal usage of
           zlib, so we don't care about this pathological case.)
           */

          n = s.hash_size;
          p = n;

          do {
            m = s.head[--p];
            s.head[p] = m >= _w_size ? m - _w_size : 0;
          } while (--n);

          n = _w_size;
          p = n;

          do {
            m = s.prev[--p];
            s.prev[p] = m >= _w_size ? m - _w_size : 0;
            /* If n is not on any hash chain, prev[n] is garbage but
             * its value will never be used.
             */
          } while (--n);

          more += _w_size;
        }

        if (s.strm.avail_in === 0) {
          break;
        }
        /* If there was no sliding:
         *    strstart <= WSIZE+MAX_DIST-1 && lookahead <= MIN_LOOKAHEAD - 1 &&
         *    more == window_size - lookahead - strstart
         * => more >= window_size - (MIN_LOOKAHEAD-1 + WSIZE + MAX_DIST-1)
         * => more >= window_size - 2*WSIZE + 2
         * In the BIG_MEM or MMAP case (not yet supported),
         *   window_size == input_size + MIN_LOOKAHEAD  &&
         *   strstart + s->lookahead <= input_size => more >= MIN_LOOKAHEAD.
         * Otherwise, window_size == 2*WSIZE so more >= 2.
         * If there was sliding, more >= WSIZE. So in all cases, more >= 2.
         */
        //Assert(more >= 2, "more < 2");


        n = read_buf(s.strm, s.window, s.strstart + s.lookahead, more);
        s.lookahead += n;
        /* Initialize the hash value now that we have some input: */

        if (s.lookahead + s.insert >= MIN_MATCH) {
          str = s.strstart - s.insert;
          s.ins_h = s.window[str];
          /* UPDATE_HASH(s, s->ins_h, s->window[str + 1]); */

          s.ins_h = HASH(s, s.ins_h, s.window[str + 1]); //#if MIN_MATCH != 3
          //        Call update_hash() MIN_MATCH-3 more times
          //#endif

          while (s.insert) {
            /* UPDATE_HASH(s, s->ins_h, s->window[str + MIN_MATCH-1]); */
            s.ins_h = HASH(s, s.ins_h, s.window[str + MIN_MATCH - 1]);
            s.prev[str & s.w_mask] = s.head[s.ins_h];
            s.head[s.ins_h] = str;
            str++;
            s.insert--;

            if (s.lookahead + s.insert < MIN_MATCH) {
              break;
            }
          }
        }
        /* If the whole input has less than MIN_MATCH bytes, ins_h is garbage,
         * but this is not important since only literal bytes will be emitted.
         */

      } while (s.lookahead < MIN_LOOKAHEAD && s.strm.avail_in !== 0);
      /* If the WIN_INIT bytes after the end of the current data have never been
       * written, then zero those bytes in order to avoid memory check reports of
       * the use of uninitialized (or uninitialised as Julian writes) bytes by
       * the longest match routines.  Update the high water mark for the next
       * time through here.  WIN_INIT is set to MAX_MATCH since the longest match
       * routines allow scanning to strstart + MAX_MATCH, ignoring lookahead.
       */
      //  if (s.high_water < s.window_size) {
      //    const curr = s.strstart + s.lookahead;
      //    let init = 0;
      //
      //    if (s.high_water < curr) {
      //      /* Previous high water mark below current data -- zero WIN_INIT
      //       * bytes or up to end of window, whichever is less.
      //       */
      //      init = s.window_size - curr;
      //      if (init > WIN_INIT)
      //        init = WIN_INIT;
      //      zmemzero(s->window + curr, (unsigned)init);
      //      s->high_water = curr + init;
      //    }
      //    else if (s->high_water < (ulg)curr + WIN_INIT) {
      //      /* High water mark at or above current data, but below current data
      //       * plus WIN_INIT -- zero out to current data plus WIN_INIT, or up
      //       * to end of window, whichever is less.
      //       */
      //      init = (ulg)curr + WIN_INIT - s->high_water;
      //      if (init > s->window_size - s->high_water)
      //        init = s->window_size - s->high_water;
      //      zmemzero(s->window + s->high_water, (unsigned)init);
      //      s->high_water += init;
      //    }
      //  }
      //
      //  Assert((ulg)s->strstart <= s->window_size - MIN_LOOKAHEAD,
      //    "not enough room for search");

    };
    /* ===========================================================================
     * Copy without compression as much as possible from the input stream, return
     * the current block state.
     * This function does not insert new strings in the dictionary since
     * uncompressible data is probably not useful. This function is used
     * only for the level=0 compression option.
     * NOTE: this function should be optimized to avoid extra copying from
     * window to pending_buf.
     */


    const deflate_stored = (s, flush) => {
      /* Stored blocks are limited to 0xffff bytes, pending_buf is limited
       * to pending_buf_size, and each stored block has a 5 byte header:
       */
      let max_block_size = 0xffff;

      if (max_block_size > s.pending_buf_size - 5) {
        max_block_size = s.pending_buf_size - 5;
      }
      /* Copy as much as possible from input to output: */


      for (;;) {
        /* Fill the window as much as possible: */
        if (s.lookahead <= 1) {
          //Assert(s->strstart < s->w_size+MAX_DIST(s) ||
          //  s->block_start >= (long)s->w_size, "slide too late");
          //      if (!(s.strstart < s.w_size + (s.w_size - MIN_LOOKAHEAD) ||
          //        s.block_start >= s.w_size)) {
          //        throw  new Error("slide too late");
          //      }
          fill_window(s);

          if (s.lookahead === 0 && flush === Z_NO_FLUSH$2) {
            return BS_NEED_MORE;
          }

          if (s.lookahead === 0) {
            break;
          }
          /* flush the current block */

        } //Assert(s->block_start >= 0L, "block gone");
        //    if (s.block_start < 0) throw new Error("block gone");


        s.strstart += s.lookahead;
        s.lookahead = 0;
        /* Emit a stored block if pending_buf will be full: */

        const max_start = s.block_start + max_block_size;

        if (s.strstart === 0 || s.strstart >= max_start) {
          /* strstart == 0 is possible when wraparound on 16-bit machine */
          s.lookahead = s.strstart - max_start;
          s.strstart = max_start;
          /*** FLUSH_BLOCK(s, 0); ***/

          flush_block_only(s, false);

          if (s.strm.avail_out === 0) {
            return BS_NEED_MORE;
          }
          /***/

        }
        /* Flush if we may have to slide, otherwise block_start may become
         * negative and the data will be gone:
         */


        if (s.strstart - s.block_start >= s.w_size - MIN_LOOKAHEAD) {
          /*** FLUSH_BLOCK(s, 0); ***/
          flush_block_only(s, false);

          if (s.strm.avail_out === 0) {
            return BS_NEED_MORE;
          }
          /***/

        }
      }

      s.insert = 0;

      if (flush === Z_FINISH$3) {
        /*** FLUSH_BLOCK(s, 1); ***/
        flush_block_only(s, true);

        if (s.strm.avail_out === 0) {
          return BS_FINISH_STARTED;
        }
        /***/


        return BS_FINISH_DONE;
      }

      if (s.strstart > s.block_start) {
        /*** FLUSH_BLOCK(s, 0); ***/
        flush_block_only(s, false);

        if (s.strm.avail_out === 0) {
          return BS_NEED_MORE;
        }
        /***/

      }

      return BS_NEED_MORE;
    };
    /* ===========================================================================
     * Compress as much as possible from the input stream, return the current
     * block state.
     * This function does not perform lazy evaluation of matches and inserts
     * new strings in the dictionary only for unmatched strings or for short
     * matches. It is used only for the fast compression options.
     */


    const deflate_fast = (s, flush) => {
      let hash_head;
      /* head of the hash chain */

      let bflush;
      /* set if current block must be flushed */

      for (;;) {
        /* Make sure that we always have enough lookahead, except
         * at the end of the input file. We need MAX_MATCH bytes
         * for the next match, plus MIN_MATCH bytes to insert the
         * string following the next match.
         */
        if (s.lookahead < MIN_LOOKAHEAD) {
          fill_window(s);

          if (s.lookahead < MIN_LOOKAHEAD && flush === Z_NO_FLUSH$2) {
            return BS_NEED_MORE;
          }

          if (s.lookahead === 0) {
            break;
            /* flush the current block */
          }
        }
        /* Insert the string window[strstart .. strstart+2] in the
         * dictionary, and set hash_head to the head of the hash chain:
         */


        hash_head = 0
        /*NIL*/
        ;

        if (s.lookahead >= MIN_MATCH) {
          /*** INSERT_STRING(s, s.strstart, hash_head); ***/
          s.ins_h = HASH(s, s.ins_h, s.window[s.strstart + MIN_MATCH - 1]);
          hash_head = s.prev[s.strstart & s.w_mask] = s.head[s.ins_h];
          s.head[s.ins_h] = s.strstart;
          /***/
        }
        /* Find the longest match, discarding those <= prev_length.
         * At this point we have always match_length < MIN_MATCH
         */


        if (hash_head !== 0
        /*NIL*/
        && s.strstart - hash_head <= s.w_size - MIN_LOOKAHEAD) {
          /* To simplify the code, we prevent matches with the string
           * of window index 0 (in particular we have to avoid a match
           * of the string with itself at the start of the input file).
           */
          s.match_length = longest_match(s, hash_head);
          /* longest_match() sets match_start */
        }

        if (s.match_length >= MIN_MATCH) {
          // check_match(s, s.strstart, s.match_start, s.match_length); // for debug only

          /*** _tr_tally_dist(s, s.strstart - s.match_start,
                         s.match_length - MIN_MATCH, bflush); ***/
          bflush = _tr_tally(s, s.strstart - s.match_start, s.match_length - MIN_MATCH);
          s.lookahead -= s.match_length;
          /* Insert new strings in the hash table only if the match length
           * is not too large. This saves time but degrades compression.
           */

          if (s.match_length <= s.max_lazy_match
          /*max_insert_length*/
          && s.lookahead >= MIN_MATCH) {
            s.match_length--;
            /* string at strstart already in table */

            do {
              s.strstart++;
              /*** INSERT_STRING(s, s.strstart, hash_head); ***/

              s.ins_h = HASH(s, s.ins_h, s.window[s.strstart + MIN_MATCH - 1]);
              hash_head = s.prev[s.strstart & s.w_mask] = s.head[s.ins_h];
              s.head[s.ins_h] = s.strstart;
              /***/

              /* strstart never exceeds WSIZE-MAX_MATCH, so there are
               * always MIN_MATCH bytes ahead.
               */
            } while (--s.match_length !== 0);

            s.strstart++;
          } else {
            s.strstart += s.match_length;
            s.match_length = 0;
            s.ins_h = s.window[s.strstart];
            /* UPDATE_HASH(s, s.ins_h, s.window[s.strstart+1]); */

            s.ins_h = HASH(s, s.ins_h, s.window[s.strstart + 1]); //#if MIN_MATCH != 3
            //                Call UPDATE_HASH() MIN_MATCH-3 more times
            //#endif

            /* If lookahead < MIN_MATCH, ins_h is garbage, but it does not
             * matter since it will be recomputed at next deflate call.
             */
          }
        } else {
          /* No match, output a literal byte */
          //Tracevv((stderr,"%c", s.window[s.strstart]));

          /*** _tr_tally_lit(s, s.window[s.strstart], bflush); ***/
          bflush = _tr_tally(s, 0, s.window[s.strstart]);
          s.lookahead--;
          s.strstart++;
        }

        if (bflush) {
          /*** FLUSH_BLOCK(s, 0); ***/
          flush_block_only(s, false);

          if (s.strm.avail_out === 0) {
            return BS_NEED_MORE;
          }
          /***/

        }
      }

      s.insert = s.strstart < MIN_MATCH - 1 ? s.strstart : MIN_MATCH - 1;

      if (flush === Z_FINISH$3) {
        /*** FLUSH_BLOCK(s, 1); ***/
        flush_block_only(s, true);

        if (s.strm.avail_out === 0) {
          return BS_FINISH_STARTED;
        }
        /***/


        return BS_FINISH_DONE;
      }

      if (s.last_lit) {
        /*** FLUSH_BLOCK(s, 0); ***/
        flush_block_only(s, false);

        if (s.strm.avail_out === 0) {
          return BS_NEED_MORE;
        }
        /***/

      }

      return BS_BLOCK_DONE;
    };
    /* ===========================================================================
     * Same as above, but achieves better compression. We use a lazy
     * evaluation for matches: a match is finally adopted only if there is
     * no better match at the next window position.
     */


    const deflate_slow = (s, flush) => {
      let hash_head;
      /* head of hash chain */

      let bflush;
      /* set if current block must be flushed */

      let max_insert;
      /* Process the input block. */

      for (;;) {
        /* Make sure that we always have enough lookahead, except
         * at the end of the input file. We need MAX_MATCH bytes
         * for the next match, plus MIN_MATCH bytes to insert the
         * string following the next match.
         */
        if (s.lookahead < MIN_LOOKAHEAD) {
          fill_window(s);

          if (s.lookahead < MIN_LOOKAHEAD && flush === Z_NO_FLUSH$2) {
            return BS_NEED_MORE;
          }

          if (s.lookahead === 0) {
            break;
          }
          /* flush the current block */

        }
        /* Insert the string window[strstart .. strstart+2] in the
         * dictionary, and set hash_head to the head of the hash chain:
         */


        hash_head = 0
        /*NIL*/
        ;

        if (s.lookahead >= MIN_MATCH) {
          /*** INSERT_STRING(s, s.strstart, hash_head); ***/
          s.ins_h = HASH(s, s.ins_h, s.window[s.strstart + MIN_MATCH - 1]);
          hash_head = s.prev[s.strstart & s.w_mask] = s.head[s.ins_h];
          s.head[s.ins_h] = s.strstart;
          /***/
        }
        /* Find the longest match, discarding those <= prev_length.
         */


        s.prev_length = s.match_length;
        s.prev_match = s.match_start;
        s.match_length = MIN_MATCH - 1;

        if (hash_head !== 0
        /*NIL*/
        && s.prev_length < s.max_lazy_match && s.strstart - hash_head <= s.w_size - MIN_LOOKAHEAD
        /*MAX_DIST(s)*/
        ) {
          /* To simplify the code, we prevent matches with the string
           * of window index 0 (in particular we have to avoid a match
           * of the string with itself at the start of the input file).
           */
          s.match_length = longest_match(s, hash_head);
          /* longest_match() sets match_start */

          if (s.match_length <= 5 && (s.strategy === Z_FILTERED || s.match_length === MIN_MATCH && s.strstart - s.match_start > 4096
          /*TOO_FAR*/
          )) {
            /* If prev_match is also MIN_MATCH, match_start is garbage
             * but we will ignore the current match anyway.
             */
            s.match_length = MIN_MATCH - 1;
          }
        }
        /* If there was a match at the previous step and the current
         * match is not better, output the previous match:
         */


        if (s.prev_length >= MIN_MATCH && s.match_length <= s.prev_length) {
          max_insert = s.strstart + s.lookahead - MIN_MATCH;
          /* Do not insert strings in hash table beyond this. */
          //check_match(s, s.strstart-1, s.prev_match, s.prev_length);

          /***_tr_tally_dist(s, s.strstart - 1 - s.prev_match,
                         s.prev_length - MIN_MATCH, bflush);***/

          bflush = _tr_tally(s, s.strstart - 1 - s.prev_match, s.prev_length - MIN_MATCH);
          /* Insert in hash table all strings up to the end of the match.
           * strstart-1 and strstart are already inserted. If there is not
           * enough lookahead, the last two strings are not inserted in
           * the hash table.
           */

          s.lookahead -= s.prev_length - 1;
          s.prev_length -= 2;

          do {
            if (++s.strstart <= max_insert) {
              /*** INSERT_STRING(s, s.strstart, hash_head); ***/
              s.ins_h = HASH(s, s.ins_h, s.window[s.strstart + MIN_MATCH - 1]);
              hash_head = s.prev[s.strstart & s.w_mask] = s.head[s.ins_h];
              s.head[s.ins_h] = s.strstart;
              /***/
            }
          } while (--s.prev_length !== 0);

          s.match_available = 0;
          s.match_length = MIN_MATCH - 1;
          s.strstart++;

          if (bflush) {
            /*** FLUSH_BLOCK(s, 0); ***/
            flush_block_only(s, false);

            if (s.strm.avail_out === 0) {
              return BS_NEED_MORE;
            }
            /***/

          }
        } else if (s.match_available) {
          /* If there was no match at the previous position, output a
           * single literal. If there was a match but the current match
           * is longer, truncate the previous match to a single literal.
           */
          //Tracevv((stderr,"%c", s->window[s->strstart-1]));

          /*** _tr_tally_lit(s, s.window[s.strstart-1], bflush); ***/
          bflush = _tr_tally(s, 0, s.window[s.strstart - 1]);

          if (bflush) {
            /*** FLUSH_BLOCK_ONLY(s, 0) ***/
            flush_block_only(s, false);
            /***/
          }

          s.strstart++;
          s.lookahead--;

          if (s.strm.avail_out === 0) {
            return BS_NEED_MORE;
          }
        } else {
          /* There is no previous match to compare with, wait for
           * the next step to decide.
           */
          s.match_available = 1;
          s.strstart++;
          s.lookahead--;
        }
      } //Assert (flush != Z_NO_FLUSH, "no flush?");


      if (s.match_available) {
        //Tracevv((stderr,"%c", s->window[s->strstart-1]));

        /*** _tr_tally_lit(s, s.window[s.strstart-1], bflush); ***/
        bflush = _tr_tally(s, 0, s.window[s.strstart - 1]);
        s.match_available = 0;
      }

      s.insert = s.strstart < MIN_MATCH - 1 ? s.strstart : MIN_MATCH - 1;

      if (flush === Z_FINISH$3) {
        /*** FLUSH_BLOCK(s, 1); ***/
        flush_block_only(s, true);

        if (s.strm.avail_out === 0) {
          return BS_FINISH_STARTED;
        }
        /***/


        return BS_FINISH_DONE;
      }

      if (s.last_lit) {
        /*** FLUSH_BLOCK(s, 0); ***/
        flush_block_only(s, false);

        if (s.strm.avail_out === 0) {
          return BS_NEED_MORE;
        }
        /***/

      }

      return BS_BLOCK_DONE;
    };
    /* ===========================================================================
     * For Z_RLE, simply look for runs of bytes, generate matches only of distance
     * one.  Do not maintain a hash table.  (It will be regenerated if this run of
     * deflate switches away from Z_RLE.)
     */


    const deflate_rle = (s, flush) => {
      let bflush;
      /* set if current block must be flushed */

      let prev;
      /* byte at distance one to match */

      let scan, strend;
      /* scan goes up to strend for length of run */

      const _win = s.window;

      for (;;) {
        /* Make sure that we always have enough lookahead, except
         * at the end of the input file. We need MAX_MATCH bytes
         * for the longest run, plus one for the unrolled loop.
         */
        if (s.lookahead <= MAX_MATCH) {
          fill_window(s);

          if (s.lookahead <= MAX_MATCH && flush === Z_NO_FLUSH$2) {
            return BS_NEED_MORE;
          }

          if (s.lookahead === 0) {
            break;
          }
          /* flush the current block */

        }
        /* See how many times the previous byte repeats */


        s.match_length = 0;

        if (s.lookahead >= MIN_MATCH && s.strstart > 0) {
          scan = s.strstart - 1;
          prev = _win[scan];

          if (prev === _win[++scan] && prev === _win[++scan] && prev === _win[++scan]) {
            strend = s.strstart + MAX_MATCH;

            do {
              /*jshint noempty:false*/
            } while (prev === _win[++scan] && prev === _win[++scan] && prev === _win[++scan] && prev === _win[++scan] && prev === _win[++scan] && prev === _win[++scan] && prev === _win[++scan] && prev === _win[++scan] && scan < strend);

            s.match_length = MAX_MATCH - (strend - scan);

            if (s.match_length > s.lookahead) {
              s.match_length = s.lookahead;
            }
          } //Assert(scan <= s->window+(uInt)(s->window_size-1), "wild scan");

        }
        /* Emit match if have run of MIN_MATCH or longer, else emit literal */


        if (s.match_length >= MIN_MATCH) {
          //check_match(s, s.strstart, s.strstart - 1, s.match_length);

          /*** _tr_tally_dist(s, 1, s.match_length - MIN_MATCH, bflush); ***/
          bflush = _tr_tally(s, 1, s.match_length - MIN_MATCH);
          s.lookahead -= s.match_length;
          s.strstart += s.match_length;
          s.match_length = 0;
        } else {
          /* No match, output a literal byte */
          //Tracevv((stderr,"%c", s->window[s->strstart]));

          /*** _tr_tally_lit(s, s.window[s.strstart], bflush); ***/
          bflush = _tr_tally(s, 0, s.window[s.strstart]);
          s.lookahead--;
          s.strstart++;
        }

        if (bflush) {
          /*** FLUSH_BLOCK(s, 0); ***/
          flush_block_only(s, false);

          if (s.strm.avail_out === 0) {
            return BS_NEED_MORE;
          }
          /***/

        }
      }

      s.insert = 0;

      if (flush === Z_FINISH$3) {
        /*** FLUSH_BLOCK(s, 1); ***/
        flush_block_only(s, true);

        if (s.strm.avail_out === 0) {
          return BS_FINISH_STARTED;
        }
        /***/


        return BS_FINISH_DONE;
      }

      if (s.last_lit) {
        /*** FLUSH_BLOCK(s, 0); ***/
        flush_block_only(s, false);

        if (s.strm.avail_out === 0) {
          return BS_NEED_MORE;
        }
        /***/

      }

      return BS_BLOCK_DONE;
    };
    /* ===========================================================================
     * For Z_HUFFMAN_ONLY, do not look for matches.  Do not maintain a hash table.
     * (It will be regenerated if this run of deflate switches away from Huffman.)
     */


    const deflate_huff = (s, flush) => {
      let bflush;
      /* set if current block must be flushed */

      for (;;) {
        /* Make sure that we have a literal to write. */
        if (s.lookahead === 0) {
          fill_window(s);

          if (s.lookahead === 0) {
            if (flush === Z_NO_FLUSH$2) {
              return BS_NEED_MORE;
            }

            break;
            /* flush the current block */
          }
        }
        /* Output a literal byte */


        s.match_length = 0; //Tracevv((stderr,"%c", s->window[s->strstart]));

        /*** _tr_tally_lit(s, s.window[s.strstart], bflush); ***/

        bflush = _tr_tally(s, 0, s.window[s.strstart]);
        s.lookahead--;
        s.strstart++;

        if (bflush) {
          /*** FLUSH_BLOCK(s, 0); ***/
          flush_block_only(s, false);

          if (s.strm.avail_out === 0) {
            return BS_NEED_MORE;
          }
          /***/

        }
      }

      s.insert = 0;

      if (flush === Z_FINISH$3) {
        /*** FLUSH_BLOCK(s, 1); ***/
        flush_block_only(s, true);

        if (s.strm.avail_out === 0) {
          return BS_FINISH_STARTED;
        }
        /***/


        return BS_FINISH_DONE;
      }

      if (s.last_lit) {
        /*** FLUSH_BLOCK(s, 0); ***/
        flush_block_only(s, false);

        if (s.strm.avail_out === 0) {
          return BS_NEED_MORE;
        }
        /***/

      }

      return BS_BLOCK_DONE;
    };
    /* Values for max_lazy_match, good_match and max_chain_length, depending on
     * the desired pack level (0..9). The values given below have been tuned to
     * exclude worst case performance for pathological files. Better values may be
     * found for specific files.
     */


    function Config(good_length, max_lazy, nice_length, max_chain, func) {
      this.good_length = good_length;
      this.max_lazy = max_lazy;
      this.nice_length = nice_length;
      this.max_chain = max_chain;
      this.func = func;
    }

    const configuration_table = [
    /*      good lazy nice chain */
    new Config(0, 0, 0, 0, deflate_stored),
    /* 0 store only */
    new Config(4, 4, 8, 4, deflate_fast),
    /* 1 max speed, no lazy matches */
    new Config(4, 5, 16, 8, deflate_fast),
    /* 2 */
    new Config(4, 6, 32, 32, deflate_fast),
    /* 3 */
    new Config(4, 4, 16, 16, deflate_slow),
    /* 4 lazy matches */
    new Config(8, 16, 32, 32, deflate_slow),
    /* 5 */
    new Config(8, 16, 128, 128, deflate_slow),
    /* 6 */
    new Config(8, 32, 128, 256, deflate_slow),
    /* 7 */
    new Config(32, 128, 258, 1024, deflate_slow),
    /* 8 */
    new Config(32, 258, 258, 4096, deflate_slow)
    /* 9 max compression */
    ];
    /* ===========================================================================
     * Initialize the "longest match" routines for a new zlib stream
     */

    const lm_init = s => {
      s.window_size = 2 * s.w_size;
      /*** CLEAR_HASH(s); ***/

      zero(s.head); // Fill with NIL (= 0);

      /* Set the default configuration parameters:
       */

      s.max_lazy_match = configuration_table[s.level].max_lazy;
      s.good_match = configuration_table[s.level].good_length;
      s.nice_match = configuration_table[s.level].nice_length;
      s.max_chain_length = configuration_table[s.level].max_chain;
      s.strstart = 0;
      s.block_start = 0;
      s.lookahead = 0;
      s.insert = 0;
      s.match_length = s.prev_length = MIN_MATCH - 1;
      s.match_available = 0;
      s.ins_h = 0;
    };

    function DeflateState() {
      this.strm = null;
      /* pointer back to this zlib stream */

      this.status = 0;
      /* as the name implies */

      this.pending_buf = null;
      /* output still pending */

      this.pending_buf_size = 0;
      /* size of pending_buf */

      this.pending_out = 0;
      /* next pending byte to output to the stream */

      this.pending = 0;
      /* nb of bytes in the pending buffer */

      this.wrap = 0;
      /* bit 0 true for zlib, bit 1 true for gzip */

      this.gzhead = null;
      /* gzip header information to write */

      this.gzindex = 0;
      /* where in extra, name, or comment */

      this.method = Z_DEFLATED$2;
      /* can only be DEFLATED */

      this.last_flush = -1;
      /* value of flush param for previous deflate call */

      this.w_size = 0;
      /* LZ77 window size (32K by default) */

      this.w_bits = 0;
      /* log2(w_size)  (8..16) */

      this.w_mask = 0;
      /* w_size - 1 */

      this.window = null;
      /* Sliding window. Input bytes are read into the second half of the window,
       * and move to the first half later to keep a dictionary of at least wSize
       * bytes. With this organization, matches are limited to a distance of
       * wSize-MAX_MATCH bytes, but this ensures that IO is always
       * performed with a length multiple of the block size.
       */

      this.window_size = 0;
      /* Actual size of window: 2*wSize, except when the user input buffer
       * is directly used as sliding window.
       */

      this.prev = null;
      /* Link to older string with same hash index. To limit the size of this
       * array to 64K, this link is maintained only for the last 32K strings.
       * An index in this array is thus a window index modulo 32K.
       */

      this.head = null;
      /* Heads of the hash chains or NIL. */

      this.ins_h = 0;
      /* hash index of string to be inserted */

      this.hash_size = 0;
      /* number of elements in hash table */

      this.hash_bits = 0;
      /* log2(hash_size) */

      this.hash_mask = 0;
      /* hash_size-1 */

      this.hash_shift = 0;
      /* Number of bits by which ins_h must be shifted at each input
       * step. It must be such that after MIN_MATCH steps, the oldest
       * byte no longer takes part in the hash key, that is:
       *   hash_shift * MIN_MATCH >= hash_bits
       */

      this.block_start = 0;
      /* Window position at the beginning of the current output block. Gets
       * negative when the window is moved backwards.
       */

      this.match_length = 0;
      /* length of best match */

      this.prev_match = 0;
      /* previous match */

      this.match_available = 0;
      /* set if previous match exists */

      this.strstart = 0;
      /* start of string to insert */

      this.match_start = 0;
      /* start of matching string */

      this.lookahead = 0;
      /* number of valid bytes ahead in window */

      this.prev_length = 0;
      /* Length of the best match at previous step. Matches not greater than this
       * are discarded. This is used in the lazy match evaluation.
       */

      this.max_chain_length = 0;
      /* To speed up deflation, hash chains are never searched beyond this
       * length.  A higher limit improves compression ratio but degrades the
       * speed.
       */

      this.max_lazy_match = 0;
      /* Attempt to find a better match only when the current match is strictly
       * smaller than this value. This mechanism is used only for compression
       * levels >= 4.
       */
      // That's alias to max_lazy_match, don't use directly
      //this.max_insert_length = 0;

      /* Insert new strings in the hash table only if the match length is not
       * greater than this length. This saves time but degrades compression.
       * max_insert_length is used only for compression levels <= 3.
       */

      this.level = 0;
      /* compression level (1..9) */

      this.strategy = 0;
      /* favor or force Huffman coding*/

      this.good_match = 0;
      /* Use a faster search when the previous match is longer than this */

      this.nice_match = 0;
      /* Stop searching when current match exceeds this */

      /* used by trees.c: */

      /* Didn't use ct_data typedef below to suppress compiler warning */
      // struct ct_data_s dyn_ltree[HEAP_SIZE];   /* literal and length tree */
      // struct ct_data_s dyn_dtree[2*D_CODES+1]; /* distance tree */
      // struct ct_data_s bl_tree[2*BL_CODES+1];  /* Huffman tree for bit lengths */
      // Use flat array of DOUBLE size, with interleaved fata,
      // because JS does not support effective

      this.dyn_ltree = new Uint16Array(HEAP_SIZE * 2);
      this.dyn_dtree = new Uint16Array((2 * D_CODES + 1) * 2);
      this.bl_tree = new Uint16Array((2 * BL_CODES + 1) * 2);
      zero(this.dyn_ltree);
      zero(this.dyn_dtree);
      zero(this.bl_tree);
      this.l_desc = null;
      /* desc. for literal tree */

      this.d_desc = null;
      /* desc. for distance tree */

      this.bl_desc = null;
      /* desc. for bit length tree */
      //ush bl_count[MAX_BITS+1];

      this.bl_count = new Uint16Array(MAX_BITS + 1);
      /* number of codes at each bit length for an optimal tree */
      //int heap[2*L_CODES+1];      /* heap used to build the Huffman trees */

      this.heap = new Uint16Array(2 * L_CODES + 1);
      /* heap used to build the Huffman trees */

      zero(this.heap);
      this.heap_len = 0;
      /* number of elements in the heap */

      this.heap_max = 0;
      /* element of largest frequency */

      /* The sons of heap[n] are heap[2*n] and heap[2*n+1]. heap[0] is not used.
       * The same heap array is used to build all trees.
       */

      this.depth = new Uint16Array(2 * L_CODES + 1); //uch depth[2*L_CODES+1];

      zero(this.depth);
      /* Depth of each subtree used as tie breaker for trees of equal frequency
       */

      this.l_buf = 0;
      /* buffer index for literals or lengths */

      this.lit_bufsize = 0;
      /* Size of match buffer for literals/lengths.  There are 4 reasons for
       * limiting lit_bufsize to 64K:
       *   - frequencies can be kept in 16 bit counters
       *   - if compression is not successful for the first block, all input
       *     data is still in the window so we can still emit a stored block even
       *     when input comes from standard input.  (This can also be done for
       *     all blocks if lit_bufsize is not greater than 32K.)
       *   - if compression is not successful for a file smaller than 64K, we can
       *     even emit a stored file instead of a stored block (saving 5 bytes).
       *     This is applicable only for zip (not gzip or zlib).
       *   - creating new Huffman trees less frequently may not provide fast
       *     adaptation to changes in the input data statistics. (Take for
       *     example a binary file with poorly compressible code followed by
       *     a highly compressible string table.) Smaller buffer sizes give
       *     fast adaptation but have of course the overhead of transmitting
       *     trees more frequently.
       *   - I can't count above 4
       */

      this.last_lit = 0;
      /* running index in l_buf */

      this.d_buf = 0;
      /* Buffer index for distances. To simplify the code, d_buf and l_buf have
       * the same number of elements. To use different lengths, an extra flag
       * array would be necessary.
       */

      this.opt_len = 0;
      /* bit length of current block with optimal trees */

      this.static_len = 0;
      /* bit length of current block with static trees */

      this.matches = 0;
      /* number of string matches in current block */

      this.insert = 0;
      /* bytes at end of window left to insert */

      this.bi_buf = 0;
      /* Output buffer. bits are inserted starting at the bottom (least
       * significant bits).
       */

      this.bi_valid = 0;
      /* Number of valid bits in bi_buf.  All bits above the last valid bit
       * are always zero.
       */
      // Used for window memory init. We safely ignore it for JS. That makes
      // sense only for pointers and memory check tools.
      //this.high_water = 0;

      /* High water mark offset in window for initialized bytes -- bytes above
       * this are set to zero in order to avoid memory check warnings when
       * longest match routines access bytes past the input.  This is then
       * updated to the new high water mark.
       */
    }

    const deflateResetKeep = strm => {
      if (!strm || !strm.state) {
        return err(strm, Z_STREAM_ERROR$2);
      }

      strm.total_in = strm.total_out = 0;
      strm.data_type = Z_UNKNOWN;
      const s = strm.state;
      s.pending = 0;
      s.pending_out = 0;

      if (s.wrap < 0) {
        s.wrap = -s.wrap;
        /* was made negative by deflate(..., Z_FINISH); */
      }

      s.status = s.wrap ? INIT_STATE : BUSY_STATE;
      strm.adler = s.wrap === 2 ? 0 // crc32(0, Z_NULL, 0)
      : 1; // adler32(0, Z_NULL, 0)

      s.last_flush = Z_NO_FLUSH$2;

      _tr_init(s);

      return Z_OK$3;
    };

    const deflateReset = strm => {
      const ret = deflateResetKeep(strm);

      if (ret === Z_OK$3) {
        lm_init(strm.state);
      }

      return ret;
    };

    const deflateSetHeader = (strm, head) => {
      if (!strm || !strm.state) {
        return Z_STREAM_ERROR$2;
      }

      if (strm.state.wrap !== 2) {
        return Z_STREAM_ERROR$2;
      }

      strm.state.gzhead = head;
      return Z_OK$3;
    };

    const deflateInit2 = (strm, level, method, windowBits, memLevel, strategy) => {
      if (!strm) {
        // === Z_NULL
        return Z_STREAM_ERROR$2;
      }

      let wrap = 1;

      if (level === Z_DEFAULT_COMPRESSION$1) {
        level = 6;
      }

      if (windowBits < 0) {
        /* suppress zlib wrapper */
        wrap = 0;
        windowBits = -windowBits;
      } else if (windowBits > 15) {
        wrap = 2;
        /* write gzip wrapper instead */

        windowBits -= 16;
      }

      if (memLevel < 1 || memLevel > MAX_MEM_LEVEL || method !== Z_DEFLATED$2 || windowBits < 8 || windowBits > 15 || level < 0 || level > 9 || strategy < 0 || strategy > Z_FIXED) {
        return err(strm, Z_STREAM_ERROR$2);
      }

      if (windowBits === 8) {
        windowBits = 9;
      }
      /* until 256-byte window bug fixed */


      const s = new DeflateState();
      strm.state = s;
      s.strm = strm;
      s.wrap = wrap;
      s.gzhead = null;
      s.w_bits = windowBits;
      s.w_size = 1 << s.w_bits;
      s.w_mask = s.w_size - 1;
      s.hash_bits = memLevel + 7;
      s.hash_size = 1 << s.hash_bits;
      s.hash_mask = s.hash_size - 1;
      s.hash_shift = ~~((s.hash_bits + MIN_MATCH - 1) / MIN_MATCH);
      s.window = new Uint8Array(s.w_size * 2);
      s.head = new Uint16Array(s.hash_size);
      s.prev = new Uint16Array(s.w_size); // Don't need mem init magic for JS.
      //s.high_water = 0;  /* nothing written to s->window yet */

      s.lit_bufsize = 1 << memLevel + 6;
      /* 16K elements by default */

      s.pending_buf_size = s.lit_bufsize * 4; //overlay = (ushf *) ZALLOC(strm, s->lit_bufsize, sizeof(ush)+2);
      //s->pending_buf = (uchf *) overlay;

      s.pending_buf = new Uint8Array(s.pending_buf_size); // It is offset from `s.pending_buf` (size is `s.lit_bufsize * 2`)
      //s->d_buf = overlay + s->lit_bufsize/sizeof(ush);

      s.d_buf = 1 * s.lit_bufsize; //s->l_buf = s->pending_buf + (1+sizeof(ush))*s->lit_bufsize;

      s.l_buf = (1 + 2) * s.lit_bufsize;
      s.level = level;
      s.strategy = strategy;
      s.method = method;
      return deflateReset(strm);
    };

    const deflateInit = (strm, level) => {
      return deflateInit2(strm, level, Z_DEFLATED$2, MAX_WBITS$1, DEF_MEM_LEVEL, Z_DEFAULT_STRATEGY$1);
    };

    const deflate$2 = (strm, flush) => {
      let beg, val; // for gzip header write only

      if (!strm || !strm.state || flush > Z_BLOCK$1 || flush < 0) {
        return strm ? err(strm, Z_STREAM_ERROR$2) : Z_STREAM_ERROR$2;
      }

      const s = strm.state;

      if (!strm.output || !strm.input && strm.avail_in !== 0 || s.status === FINISH_STATE && flush !== Z_FINISH$3) {
        return err(strm, strm.avail_out === 0 ? Z_BUF_ERROR$1 : Z_STREAM_ERROR$2);
      }

      s.strm = strm;
      /* just in case */

      const old_flush = s.last_flush;
      s.last_flush = flush;
      /* Write the header */

      if (s.status === INIT_STATE) {
        if (s.wrap === 2) {
          // GZIP header
          strm.adler = 0; //crc32(0L, Z_NULL, 0);

          put_byte(s, 31);
          put_byte(s, 139);
          put_byte(s, 8);

          if (!s.gzhead) {
            // s->gzhead == Z_NULL
            put_byte(s, 0);
            put_byte(s, 0);
            put_byte(s, 0);
            put_byte(s, 0);
            put_byte(s, 0);
            put_byte(s, s.level === 9 ? 2 : s.strategy >= Z_HUFFMAN_ONLY || s.level < 2 ? 4 : 0);
            put_byte(s, OS_CODE);
            s.status = BUSY_STATE;
          } else {
            put_byte(s, (s.gzhead.text ? 1 : 0) + (s.gzhead.hcrc ? 2 : 0) + (!s.gzhead.extra ? 0 : 4) + (!s.gzhead.name ? 0 : 8) + (!s.gzhead.comment ? 0 : 16));
            put_byte(s, s.gzhead.time & 0xff);
            put_byte(s, s.gzhead.time >> 8 & 0xff);
            put_byte(s, s.gzhead.time >> 16 & 0xff);
            put_byte(s, s.gzhead.time >> 24 & 0xff);
            put_byte(s, s.level === 9 ? 2 : s.strategy >= Z_HUFFMAN_ONLY || s.level < 2 ? 4 : 0);
            put_byte(s, s.gzhead.os & 0xff);

            if (s.gzhead.extra && s.gzhead.extra.length) {
              put_byte(s, s.gzhead.extra.length & 0xff);
              put_byte(s, s.gzhead.extra.length >> 8 & 0xff);
            }

            if (s.gzhead.hcrc) {
              strm.adler = crc32_1(strm.adler, s.pending_buf, s.pending, 0);
            }

            s.gzindex = 0;
            s.status = EXTRA_STATE;
          }
        } else // DEFLATE header
          {
            let header = Z_DEFLATED$2 + (s.w_bits - 8 << 4) << 8;
            let level_flags = -1;

            if (s.strategy >= Z_HUFFMAN_ONLY || s.level < 2) {
              level_flags = 0;
            } else if (s.level < 6) {
              level_flags = 1;
            } else if (s.level === 6) {
              level_flags = 2;
            } else {
              level_flags = 3;
            }

            header |= level_flags << 6;

            if (s.strstart !== 0) {
              header |= PRESET_DICT;
            }

            header += 31 - header % 31;
            s.status = BUSY_STATE;
            putShortMSB(s, header);
            /* Save the adler32 of the preset dictionary: */

            if (s.strstart !== 0) {
              putShortMSB(s, strm.adler >>> 16);
              putShortMSB(s, strm.adler & 0xffff);
            }

            strm.adler = 1; // adler32(0L, Z_NULL, 0);
          }
      } //#ifdef GZIP


      if (s.status === EXTRA_STATE) {
        if (s.gzhead.extra
        /* != Z_NULL*/
        ) {
          beg = s.pending;
          /* start of bytes to update crc */

          while (s.gzindex < (s.gzhead.extra.length & 0xffff)) {
            if (s.pending === s.pending_buf_size) {
              if (s.gzhead.hcrc && s.pending > beg) {
                strm.adler = crc32_1(strm.adler, s.pending_buf, s.pending - beg, beg);
              }

              flush_pending(strm);
              beg = s.pending;

              if (s.pending === s.pending_buf_size) {
                break;
              }
            }

            put_byte(s, s.gzhead.extra[s.gzindex] & 0xff);
            s.gzindex++;
          }

          if (s.gzhead.hcrc && s.pending > beg) {
            strm.adler = crc32_1(strm.adler, s.pending_buf, s.pending - beg, beg);
          }

          if (s.gzindex === s.gzhead.extra.length) {
            s.gzindex = 0;
            s.status = NAME_STATE;
          }
        } else {
          s.status = NAME_STATE;
        }
      }

      if (s.status === NAME_STATE) {
        if (s.gzhead.name
        /* != Z_NULL*/
        ) {
          beg = s.pending;
          /* start of bytes to update crc */
          //int val;

          do {
            if (s.pending === s.pending_buf_size) {
              if (s.gzhead.hcrc && s.pending > beg) {
                strm.adler = crc32_1(strm.adler, s.pending_buf, s.pending - beg, beg);
              }

              flush_pending(strm);
              beg = s.pending;

              if (s.pending === s.pending_buf_size) {
                val = 1;
                break;
              }
            } // JS specific: little magic to add zero terminator to end of string


            if (s.gzindex < s.gzhead.name.length) {
              val = s.gzhead.name.charCodeAt(s.gzindex++) & 0xff;
            } else {
              val = 0;
            }

            put_byte(s, val);
          } while (val !== 0);

          if (s.gzhead.hcrc && s.pending > beg) {
            strm.adler = crc32_1(strm.adler, s.pending_buf, s.pending - beg, beg);
          }

          if (val === 0) {
            s.gzindex = 0;
            s.status = COMMENT_STATE;
          }
        } else {
          s.status = COMMENT_STATE;
        }
      }

      if (s.status === COMMENT_STATE) {
        if (s.gzhead.comment
        /* != Z_NULL*/
        ) {
          beg = s.pending;
          /* start of bytes to update crc */
          //int val;

          do {
            if (s.pending === s.pending_buf_size) {
              if (s.gzhead.hcrc && s.pending > beg) {
                strm.adler = crc32_1(strm.adler, s.pending_buf, s.pending - beg, beg);
              }

              flush_pending(strm);
              beg = s.pending;

              if (s.pending === s.pending_buf_size) {
                val = 1;
                break;
              }
            } // JS specific: little magic to add zero terminator to end of string


            if (s.gzindex < s.gzhead.comment.length) {
              val = s.gzhead.comment.charCodeAt(s.gzindex++) & 0xff;
            } else {
              val = 0;
            }

            put_byte(s, val);
          } while (val !== 0);

          if (s.gzhead.hcrc && s.pending > beg) {
            strm.adler = crc32_1(strm.adler, s.pending_buf, s.pending - beg, beg);
          }

          if (val === 0) {
            s.status = HCRC_STATE;
          }
        } else {
          s.status = HCRC_STATE;
        }
      }

      if (s.status === HCRC_STATE) {
        if (s.gzhead.hcrc) {
          if (s.pending + 2 > s.pending_buf_size) {
            flush_pending(strm);
          }

          if (s.pending + 2 <= s.pending_buf_size) {
            put_byte(s, strm.adler & 0xff);
            put_byte(s, strm.adler >> 8 & 0xff);
            strm.adler = 0; //crc32(0L, Z_NULL, 0);

            s.status = BUSY_STATE;
          }
        } else {
          s.status = BUSY_STATE;
        }
      } //#endif

      /* Flush as much pending output as possible */


      if (s.pending !== 0) {
        flush_pending(strm);

        if (strm.avail_out === 0) {
          /* Since avail_out is 0, deflate will be called again with
           * more output space, but possibly with both pending and
           * avail_in equal to zero. There won't be anything to do,
           * but this is not an error situation so make sure we
           * return OK instead of BUF_ERROR at next call of deflate:
           */
          s.last_flush = -1;
          return Z_OK$3;
        }
        /* Make sure there is something to do and avoid duplicate consecutive
         * flushes. For repeated and useless calls with Z_FINISH, we keep
         * returning Z_STREAM_END instead of Z_BUF_ERROR.
         */

      } else if (strm.avail_in === 0 && rank(flush) <= rank(old_flush) && flush !== Z_FINISH$3) {
        return err(strm, Z_BUF_ERROR$1);
      }
      /* User must not provide more input after the first FINISH: */


      if (s.status === FINISH_STATE && strm.avail_in !== 0) {
        return err(strm, Z_BUF_ERROR$1);
      }
      /* Start a new block or continue the current one.
       */


      if (strm.avail_in !== 0 || s.lookahead !== 0 || flush !== Z_NO_FLUSH$2 && s.status !== FINISH_STATE) {
        let bstate = s.strategy === Z_HUFFMAN_ONLY ? deflate_huff(s, flush) : s.strategy === Z_RLE ? deflate_rle(s, flush) : configuration_table[s.level].func(s, flush);

        if (bstate === BS_FINISH_STARTED || bstate === BS_FINISH_DONE) {
          s.status = FINISH_STATE;
        }

        if (bstate === BS_NEED_MORE || bstate === BS_FINISH_STARTED) {
          if (strm.avail_out === 0) {
            s.last_flush = -1;
            /* avoid BUF_ERROR next call, see above */
          }

          return Z_OK$3;
          /* If flush != Z_NO_FLUSH && avail_out == 0, the next call
           * of deflate should use the same flush parameter to make sure
           * that the flush is complete. So we don't have to output an
           * empty block here, this will be done at next call. This also
           * ensures that for a very small output buffer, we emit at most
           * one empty block.
           */
        }

        if (bstate === BS_BLOCK_DONE) {
          if (flush === Z_PARTIAL_FLUSH) {
            _tr_align(s);
          } else if (flush !== Z_BLOCK$1) {
            /* FULL_FLUSH or SYNC_FLUSH */
            _tr_stored_block(s, 0, 0, false);
            /* For a full flush, this empty block will be recognized
             * as a special marker by inflate_sync().
             */


            if (flush === Z_FULL_FLUSH$1) {
              /*** CLEAR_HASH(s); ***/

              /* forget history */
              zero(s.head); // Fill with NIL (= 0);

              if (s.lookahead === 0) {
                s.strstart = 0;
                s.block_start = 0;
                s.insert = 0;
              }
            }
          }

          flush_pending(strm);

          if (strm.avail_out === 0) {
            s.last_flush = -1;
            /* avoid BUF_ERROR at next call, see above */

            return Z_OK$3;
          }
        }
      } //Assert(strm->avail_out > 0, "bug2");
      //if (strm.avail_out <= 0) { throw new Error("bug2");}


      if (flush !== Z_FINISH$3) {
        return Z_OK$3;
      }

      if (s.wrap <= 0) {
        return Z_STREAM_END$3;
      }
      /* Write the trailer */


      if (s.wrap === 2) {
        put_byte(s, strm.adler & 0xff);
        put_byte(s, strm.adler >> 8 & 0xff);
        put_byte(s, strm.adler >> 16 & 0xff);
        put_byte(s, strm.adler >> 24 & 0xff);
        put_byte(s, strm.total_in & 0xff);
        put_byte(s, strm.total_in >> 8 & 0xff);
        put_byte(s, strm.total_in >> 16 & 0xff);
        put_byte(s, strm.total_in >> 24 & 0xff);
      } else {
        putShortMSB(s, strm.adler >>> 16);
        putShortMSB(s, strm.adler & 0xffff);
      }

      flush_pending(strm);
      /* If avail_out is zero, the application will call deflate again
       * to flush the rest.
       */

      if (s.wrap > 0) {
        s.wrap = -s.wrap;
      }
      /* write the trailer only once! */


      return s.pending !== 0 ? Z_OK$3 : Z_STREAM_END$3;
    };

    const deflateEnd = strm => {
      if (!strm
      /*== Z_NULL*/
      || !strm.state
      /*== Z_NULL*/
      ) {
        return Z_STREAM_ERROR$2;
      }

      const status = strm.state.status;

      if (status !== INIT_STATE && status !== EXTRA_STATE && status !== NAME_STATE && status !== COMMENT_STATE && status !== HCRC_STATE && status !== BUSY_STATE && status !== FINISH_STATE) {
        return err(strm, Z_STREAM_ERROR$2);
      }

      strm.state = null;
      return status === BUSY_STATE ? err(strm, Z_DATA_ERROR$2) : Z_OK$3;
    };
    /* =========================================================================
     * Initializes the compression dictionary from the given byte
     * sequence without producing any compressed output.
     */


    const deflateSetDictionary = (strm, dictionary) => {
      let dictLength = dictionary.length;

      if (!strm
      /*== Z_NULL*/
      || !strm.state
      /*== Z_NULL*/
      ) {
        return Z_STREAM_ERROR$2;
      }

      const s = strm.state;
      const wrap = s.wrap;

      if (wrap === 2 || wrap === 1 && s.status !== INIT_STATE || s.lookahead) {
        return Z_STREAM_ERROR$2;
      }
      /* when using zlib wrappers, compute Adler-32 for provided dictionary */


      if (wrap === 1) {
        /* adler32(strm->adler, dictionary, dictLength); */
        strm.adler = adler32_1(strm.adler, dictionary, dictLength, 0);
      }

      s.wrap = 0;
      /* avoid computing Adler-32 in read_buf */

      /* if dictionary would fill window, just replace the history */

      if (dictLength >= s.w_size) {
        if (wrap === 0) {
          /* already empty otherwise */

          /*** CLEAR_HASH(s); ***/
          zero(s.head); // Fill with NIL (= 0);

          s.strstart = 0;
          s.block_start = 0;
          s.insert = 0;
        }
        /* use the tail */
        // dictionary = dictionary.slice(dictLength - s.w_size);


        let tmpDict = new Uint8Array(s.w_size);
        tmpDict.set(dictionary.subarray(dictLength - s.w_size, dictLength), 0);
        dictionary = tmpDict;
        dictLength = s.w_size;
      }
      /* insert dictionary into window and hash */


      const avail = strm.avail_in;
      const next = strm.next_in;
      const input = strm.input;
      strm.avail_in = dictLength;
      strm.next_in = 0;
      strm.input = dictionary;
      fill_window(s);

      while (s.lookahead >= MIN_MATCH) {
        let str = s.strstart;
        let n = s.lookahead - (MIN_MATCH - 1);

        do {
          /* UPDATE_HASH(s, s->ins_h, s->window[str + MIN_MATCH-1]); */
          s.ins_h = HASH(s, s.ins_h, s.window[str + MIN_MATCH - 1]);
          s.prev[str & s.w_mask] = s.head[s.ins_h];
          s.head[s.ins_h] = str;
          str++;
        } while (--n);

        s.strstart = str;
        s.lookahead = MIN_MATCH - 1;
        fill_window(s);
      }

      s.strstart += s.lookahead;
      s.block_start = s.strstart;
      s.insert = s.lookahead;
      s.lookahead = 0;
      s.match_length = s.prev_length = MIN_MATCH - 1;
      s.match_available = 0;
      strm.next_in = next;
      strm.input = input;
      strm.avail_in = avail;
      s.wrap = wrap;
      return Z_OK$3;
    };

    var deflateInit_1 = deflateInit;
    var deflateInit2_1 = deflateInit2;
    var deflateReset_1 = deflateReset;
    var deflateResetKeep_1 = deflateResetKeep;
    var deflateSetHeader_1 = deflateSetHeader;
    var deflate_2$1 = deflate$2;
    var deflateEnd_1 = deflateEnd;
    var deflateSetDictionary_1 = deflateSetDictionary;
    var deflateInfo = 'pako deflate (from Nodeca project)';
    /* Not implemented
    module.exports.deflateBound = deflateBound;
    module.exports.deflateCopy = deflateCopy;
    module.exports.deflateParams = deflateParams;
    module.exports.deflatePending = deflatePending;
    module.exports.deflatePrime = deflatePrime;
    module.exports.deflateTune = deflateTune;
    */

    var deflate_1$2 = {
      deflateInit: deflateInit_1,
      deflateInit2: deflateInit2_1,
      deflateReset: deflateReset_1,
      deflateResetKeep: deflateResetKeep_1,
      deflateSetHeader: deflateSetHeader_1,
      deflate: deflate_2$1,
      deflateEnd: deflateEnd_1,
      deflateSetDictionary: deflateSetDictionary_1,
      deflateInfo: deflateInfo
    };

    const _has = (obj, key) => {
      return Object.prototype.hasOwnProperty.call(obj, key);
    };

    var assign = function (obj
    /*from1, from2, from3, ...*/
    ) {
      const sources = Array.prototype.slice.call(arguments, 1);

      while (sources.length) {
        const source = sources.shift();

        if (!source) {
          continue;
        }

        if (typeof source !== 'object') {
          throw new TypeError(source + 'must be non-object');
        }

        for (const p in source) {
          if (_has(source, p)) {
            obj[p] = source[p];
          }
        }
      }

      return obj;
    }; // Join array of chunks to single array.


    var flattenChunks = chunks => {
      // calculate data length
      let len = 0;

      for (let i = 0, l = chunks.length; i < l; i++) {
        len += chunks[i].length;
      } // join chunks


      const result = new Uint8Array(len);

      for (let i = 0, pos = 0, l = chunks.length; i < l; i++) {
        let chunk = chunks[i];
        result.set(chunk, pos);
        pos += chunk.length;
      }

      return result;
    };

    var common = {
      assign: assign,
      flattenChunks: flattenChunks
    }; // String encode/decode helpers
    // Quick check if we can use fast array to bin string conversion
    //
    // - apply(Array) can fail on Android 2.2
    // - apply(Uint8Array) can fail on iOS 5.1 Safari
    //

    let STR_APPLY_UIA_OK = true;

    try {
      String.fromCharCode.apply(null, new Uint8Array(1));
    } catch (__) {
      STR_APPLY_UIA_OK = false;
    } // Table with utf8 lengths (calculated by first byte of sequence)
    // Note, that 5 & 6-byte values and some 4-byte values can not be represented in JS,
    // because max possible codepoint is 0x10ffff


    const _utf8len = new Uint8Array(256);

    for (let q = 0; q < 256; q++) {
      _utf8len[q] = q >= 252 ? 6 : q >= 248 ? 5 : q >= 240 ? 4 : q >= 224 ? 3 : q >= 192 ? 2 : 1;
    }

    _utf8len[254] = _utf8len[254] = 1; // Invalid sequence start
    // convert string to array (typed, when possible)

    var string2buf = str => {
      if (typeof TextEncoder === 'function' && TextEncoder.prototype.encode) {
        return new TextEncoder().encode(str);
      }

      let buf,
          c,
          c2,
          m_pos,
          i,
          str_len = str.length,
          buf_len = 0; // count binary size

      for (m_pos = 0; m_pos < str_len; m_pos++) {
        c = str.charCodeAt(m_pos);

        if ((c & 0xfc00) === 0xd800 && m_pos + 1 < str_len) {
          c2 = str.charCodeAt(m_pos + 1);

          if ((c2 & 0xfc00) === 0xdc00) {
            c = 0x10000 + (c - 0xd800 << 10) + (c2 - 0xdc00);
            m_pos++;
          }
        }

        buf_len += c < 0x80 ? 1 : c < 0x800 ? 2 : c < 0x10000 ? 3 : 4;
      } // allocate buffer


      buf = new Uint8Array(buf_len); // convert

      for (i = 0, m_pos = 0; i < buf_len; m_pos++) {
        c = str.charCodeAt(m_pos);

        if ((c & 0xfc00) === 0xd800 && m_pos + 1 < str_len) {
          c2 = str.charCodeAt(m_pos + 1);

          if ((c2 & 0xfc00) === 0xdc00) {
            c = 0x10000 + (c - 0xd800 << 10) + (c2 - 0xdc00);
            m_pos++;
          }
        }

        if (c < 0x80) {
          /* one byte */
          buf[i++] = c;
        } else if (c < 0x800) {
          /* two bytes */
          buf[i++] = 0xC0 | c >>> 6;
          buf[i++] = 0x80 | c & 0x3f;
        } else if (c < 0x10000) {
          /* three bytes */
          buf[i++] = 0xE0 | c >>> 12;
          buf[i++] = 0x80 | c >>> 6 & 0x3f;
          buf[i++] = 0x80 | c & 0x3f;
        } else {
          /* four bytes */
          buf[i++] = 0xf0 | c >>> 18;
          buf[i++] = 0x80 | c >>> 12 & 0x3f;
          buf[i++] = 0x80 | c >>> 6 & 0x3f;
          buf[i++] = 0x80 | c & 0x3f;
        }
      }

      return buf;
    }; // Helper


    const buf2binstring = (buf, len) => {
      // On Chrome, the arguments in a function call that are allowed is `65534`.
      // If the length of the buffer is smaller than that, we can use this optimization,
      // otherwise we will take a slower path.
      if (len < 65534) {
        if (buf.subarray && STR_APPLY_UIA_OK) {
          return String.fromCharCode.apply(null, buf.length === len ? buf : buf.subarray(0, len));
        }
      }

      let result = '';

      for (let i = 0; i < len; i++) {
        result += String.fromCharCode(buf[i]);
      }

      return result;
    }; // convert array to string


    var buf2string = (buf, max) => {
      const len = max || buf.length;

      if (typeof TextDecoder === 'function' && TextDecoder.prototype.decode) {
        return new TextDecoder().decode(buf.subarray(0, max));
      }

      let i, out; // Reserve max possible length (2 words per char)
      // NB: by unknown reasons, Array is significantly faster for
      //     String.fromCharCode.apply than Uint16Array.

      const utf16buf = new Array(len * 2);

      for (out = 0, i = 0; i < len;) {
        let c = buf[i++]; // quick process ascii

        if (c < 0x80) {
          utf16buf[out++] = c;
          continue;
        }

        let c_len = _utf8len[c]; // skip 5 & 6 byte codes

        if (c_len > 4) {
          utf16buf[out++] = 0xfffd;
          i += c_len - 1;
          continue;
        } // apply mask on first byte


        c &= c_len === 2 ? 0x1f : c_len === 3 ? 0x0f : 0x07; // join the rest

        while (c_len > 1 && i < len) {
          c = c << 6 | buf[i++] & 0x3f;
          c_len--;
        } // terminated by end of string?


        if (c_len > 1) {
          utf16buf[out++] = 0xfffd;
          continue;
        }

        if (c < 0x10000) {
          utf16buf[out++] = c;
        } else {
          c -= 0x10000;
          utf16buf[out++] = 0xd800 | c >> 10 & 0x3ff;
          utf16buf[out++] = 0xdc00 | c & 0x3ff;
        }
      }

      return buf2binstring(utf16buf, out);
    }; // Calculate max possible position in utf8 buffer,
    // that will not break sequence. If that's not possible
    // - (very small limits) return max size as is.
    //
    // buf[] - utf8 bytes array
    // max   - length limit (mandatory);


    var utf8border = (buf, max) => {
      max = max || buf.length;

      if (max > buf.length) {
        max = buf.length;
      } // go back from last position, until start of sequence found


      let pos = max - 1;

      while (pos >= 0 && (buf[pos] & 0xC0) === 0x80) {
        pos--;
      } // Very small and broken sequence,
      // return max, because we should return something anyway.


      if (pos < 0) {
        return max;
      } // If we came to start of buffer - that means buffer is too small,
      // return max too.


      if (pos === 0) {
        return max;
      }

      return pos + _utf8len[buf[pos]] > max ? pos : max;
    };

    var strings = {
      string2buf: string2buf,
      buf2string: buf2string,
      utf8border: utf8border
    }; // (C) 1995-2013 Jean-loup Gailly and Mark Adler
    // (C) 2014-2017 Vitaly Puzrin and Andrey Tupitsin
    //
    // This software is provided 'as-is', without any express or implied
    // warranty. In no event will the authors be held liable for any damages
    // arising from the use of this software.
    //
    // Permission is granted to anyone to use this software for any purpose,
    // including commercial applications, and to alter it and redistribute it
    // freely, subject to the following restrictions:
    //
    // 1. The origin of this software must not be misrepresented; you must not
    //   claim that you wrote the original software. If you use this software
    //   in a product, an acknowledgment in the product documentation would be
    //   appreciated but is not required.
    // 2. Altered source versions must be plainly marked as such, and must not be
    //   misrepresented as being the original software.
    // 3. This notice may not be removed or altered from any source distribution.

    function ZStream() {
      /* next input byte */
      this.input = null; // JS specific, because we have no pointers

      this.next_in = 0;
      /* number of bytes available at input */

      this.avail_in = 0;
      /* total number of input bytes read so far */

      this.total_in = 0;
      /* next output byte should be put there */

      this.output = null; // JS specific, because we have no pointers

      this.next_out = 0;
      /* remaining free space at output */

      this.avail_out = 0;
      /* total number of bytes output so far */

      this.total_out = 0;
      /* last error message, NULL if no error */

      this.msg = ''
      /*Z_NULL*/
      ;
      /* not visible by applications */

      this.state = null;
      /* best guess about the data type: binary or text */

      this.data_type = 2
      /*Z_UNKNOWN*/
      ;
      /* adler32 value of the uncompressed data */

      this.adler = 0;
    }

    var zstream = ZStream;
    const toString$1$1 = Object.prototype.toString;
    /* Public constants ==========================================================*/

    /* ===========================================================================*/

    const {
      Z_NO_FLUSH: Z_NO_FLUSH$1,
      Z_SYNC_FLUSH,
      Z_FULL_FLUSH,
      Z_FINISH: Z_FINISH$2,
      Z_OK: Z_OK$2,
      Z_STREAM_END: Z_STREAM_END$2,
      Z_DEFAULT_COMPRESSION,
      Z_DEFAULT_STRATEGY,
      Z_DEFLATED: Z_DEFLATED$1
    } = constants$2;
    /* ===========================================================================*/

    /**
     * class Deflate
     *
     * Generic JS-style wrapper for zlib calls. If you don't need
     * streaming behaviour - use more simple functions: [[deflate]],
     * [[deflateRaw]] and [[gzip]].
     **/

    /* internal
     * Deflate.chunks -> Array
     *
     * Chunks of output data, if [[Deflate#onData]] not overridden.
     **/

    /**
     * Deflate.result -> Uint8Array
     *
     * Compressed result, generated by default [[Deflate#onData]]
     * and [[Deflate#onEnd]] handlers. Filled after you push last chunk
     * (call [[Deflate#push]] with `Z_FINISH` / `true` param).
     **/

    /**
     * Deflate.err -> Number
     *
     * Error code after deflate finished. 0 (Z_OK) on success.
     * You will not need it in real life, because deflate errors
     * are possible only on wrong options or bad `onData` / `onEnd`
     * custom handlers.
     **/

    /**
     * Deflate.msg -> String
     *
     * Error message, if [[Deflate.err]] != 0
     **/

    /**
     * new Deflate(options)
     * - options (Object): zlib deflate options.
     *
     * Creates new deflator instance with specified params. Throws exception
     * on bad params. Supported options:
     *
     * - `level`
     * - `windowBits`
     * - `memLevel`
     * - `strategy`
     * - `dictionary`
     *
     * [http://zlib.net/manual.html#Advanced](http://zlib.net/manual.html#Advanced)
     * for more information on these.
     *
     * Additional options, for internal needs:
     *
     * - `chunkSize` - size of generated data chunks (16K by default)
     * - `raw` (Boolean) - do raw deflate
     * - `gzip` (Boolean) - create gzip wrapper
     * - `header` (Object) - custom header for gzip
     *   - `text` (Boolean) - true if compressed data believed to be text
     *   - `time` (Number) - modification time, unix timestamp
     *   - `os` (Number) - operation system code
     *   - `extra` (Array) - array of bytes with extra data (max 65536)
     *   - `name` (String) - file name (binary string)
     *   - `comment` (String) - comment (binary string)
     *   - `hcrc` (Boolean) - true if header crc should be added
     *
     * ##### Example:
     *
     * ```javascript
     * const pako = require('pako')
     *   , chunk1 = new Uint8Array([1,2,3,4,5,6,7,8,9])
     *   , chunk2 = new Uint8Array([10,11,12,13,14,15,16,17,18,19]);
     *
     * const deflate = new pako.Deflate({ level: 3});
     *
     * deflate.push(chunk1, false);
     * deflate.push(chunk2, true);  // true -> last chunk
     *
     * if (deflate.err) { throw new Error(deflate.err); }
     *
     * console.log(deflate.result);
     * ```
     **/

    function Deflate$1(options) {
      this.options = common.assign({
        level: Z_DEFAULT_COMPRESSION,
        method: Z_DEFLATED$1,
        chunkSize: 16384,
        windowBits: 15,
        memLevel: 8,
        strategy: Z_DEFAULT_STRATEGY
      }, options || {});
      let opt = this.options;

      if (opt.raw && opt.windowBits > 0) {
        opt.windowBits = -opt.windowBits;
      } else if (opt.gzip && opt.windowBits > 0 && opt.windowBits < 16) {
        opt.windowBits += 16;
      }

      this.err = 0; // error code, if happens (0 = Z_OK)

      this.msg = ''; // error message

      this.ended = false; // used to avoid multiple onEnd() calls

      this.chunks = []; // chunks of compressed data

      this.strm = new zstream();
      this.strm.avail_out = 0;
      let status = deflate_1$2.deflateInit2(this.strm, opt.level, opt.method, opt.windowBits, opt.memLevel, opt.strategy);

      if (status !== Z_OK$2) {
        throw new Error(messages[status]);
      }

      if (opt.header) {
        deflate_1$2.deflateSetHeader(this.strm, opt.header);
      }

      if (opt.dictionary) {
        let dict; // Convert data if needed

        if (typeof opt.dictionary === 'string') {
          // If we need to compress text, change encoding to utf8.
          dict = strings.string2buf(opt.dictionary);
        } else if (toString$1$1.call(opt.dictionary) === '[object ArrayBuffer]') {
          dict = new Uint8Array(opt.dictionary);
        } else {
          dict = opt.dictionary;
        }

        status = deflate_1$2.deflateSetDictionary(this.strm, dict);

        if (status !== Z_OK$2) {
          throw new Error(messages[status]);
        }

        this._dict_set = true;
      }
    }
    /**
     * Deflate#push(data[, flush_mode]) -> Boolean
     * - data (Uint8Array|ArrayBuffer|String): input data. Strings will be
     *   converted to utf8 byte sequence.
     * - flush_mode (Number|Boolean): 0..6 for corresponding Z_NO_FLUSH..Z_TREE modes.
     *   See constants. Skipped or `false` means Z_NO_FLUSH, `true` means Z_FINISH.
     *
     * Sends input data to deflate pipe, generating [[Deflate#onData]] calls with
     * new compressed chunks. Returns `true` on success. The last data block must
     * have `flush_mode` Z_FINISH (or `true`). That will flush internal pending
     * buffers and call [[Deflate#onEnd]].
     *
     * On fail call [[Deflate#onEnd]] with error code and return false.
     *
     * ##### Example
     *
     * ```javascript
     * push(chunk, false); // push one of data chunks
     * ...
     * push(chunk, true);  // push last chunk
     * ```
     **/


    Deflate$1.prototype.push = function (data, flush_mode) {
      const strm = this.strm;
      const chunkSize = this.options.chunkSize;

      let status, _flush_mode;

      if (this.ended) {
        return false;
      }

      if (flush_mode === ~~flush_mode) _flush_mode = flush_mode;else _flush_mode = flush_mode === true ? Z_FINISH$2 : Z_NO_FLUSH$1; // Convert data if needed

      if (typeof data === 'string') {
        // If we need to compress text, change encoding to utf8.
        strm.input = strings.string2buf(data);
      } else if (toString$1$1.call(data) === '[object ArrayBuffer]') {
        strm.input = new Uint8Array(data);
      } else {
        strm.input = data;
      }

      strm.next_in = 0;
      strm.avail_in = strm.input.length;

      for (;;) {
        if (strm.avail_out === 0) {
          strm.output = new Uint8Array(chunkSize);
          strm.next_out = 0;
          strm.avail_out = chunkSize;
        } // Make sure avail_out > 6 to avoid repeating markers


        if ((_flush_mode === Z_SYNC_FLUSH || _flush_mode === Z_FULL_FLUSH) && strm.avail_out <= 6) {
          this.onData(strm.output.subarray(0, strm.next_out));
          strm.avail_out = 0;
          continue;
        }

        status = deflate_1$2.deflate(strm, _flush_mode); // Ended => flush and finish

        if (status === Z_STREAM_END$2) {
          if (strm.next_out > 0) {
            this.onData(strm.output.subarray(0, strm.next_out));
          }

          status = deflate_1$2.deflateEnd(this.strm);
          this.onEnd(status);
          this.ended = true;
          return status === Z_OK$2;
        } // Flush if out buffer full


        if (strm.avail_out === 0) {
          this.onData(strm.output);
          continue;
        } // Flush if requested and has data


        if (_flush_mode > 0 && strm.next_out > 0) {
          this.onData(strm.output.subarray(0, strm.next_out));
          strm.avail_out = 0;
          continue;
        }

        if (strm.avail_in === 0) break;
      }

      return true;
    };
    /**
     * Deflate#onData(chunk) -> Void
     * - chunk (Uint8Array): output data.
     *
     * By default, stores data blocks in `chunks[]` property and glue
     * those in `onEnd`. Override this handler, if you need another behaviour.
     **/


    Deflate$1.prototype.onData = function (chunk) {
      this.chunks.push(chunk);
    };
    /**
     * Deflate#onEnd(status) -> Void
     * - status (Number): deflate status. 0 (Z_OK) on success,
     *   other if not.
     *
     * Called once after you tell deflate that the input stream is
     * complete (Z_FINISH). By default - join collected chunks,
     * free memory and fill `results` / `err` properties.
     **/


    Deflate$1.prototype.onEnd = function (status) {
      // On success - join
      if (status === Z_OK$2) {
        this.result = common.flattenChunks(this.chunks);
      }

      this.chunks = [];
      this.err = status;
      this.msg = this.strm.msg;
    };
    /**
     * deflate(data[, options]) -> Uint8Array
     * - data (Uint8Array|String): input data to compress.
     * - options (Object): zlib deflate options.
     *
     * Compress `data` with deflate algorithm and `options`.
     *
     * Supported options are:
     *
     * - level
     * - windowBits
     * - memLevel
     * - strategy
     * - dictionary
     *
     * [http://zlib.net/manual.html#Advanced](http://zlib.net/manual.html#Advanced)
     * for more information on these.
     *
     * Sugar (options):
     *
     * - `raw` (Boolean) - say that we work with raw stream, if you don't wish to specify
     *   negative windowBits implicitly.
     *
     * ##### Example:
     *
     * ```javascript
     * const pako = require('pako')
     * const data = new Uint8Array([1,2,3,4,5,6,7,8,9]);
     *
     * console.log(pako.deflate(data));
     * ```
     **/


    function deflate$1(input, options) {
      const deflator = new Deflate$1(options);
      deflator.push(input, true); // That will never happens, if you don't cheat with options :)

      if (deflator.err) {
        throw deflator.msg || messages[deflator.err];
      }

      return deflator.result;
    }
    /**
     * deflateRaw(data[, options]) -> Uint8Array
     * - data (Uint8Array|String): input data to compress.
     * - options (Object): zlib deflate options.
     *
     * The same as [[deflate]], but creates raw data, without wrapper
     * (header and adler32 crc).
     **/


    function deflateRaw$1(input, options) {
      options = options || {};
      options.raw = true;
      return deflate$1(input, options);
    }
    /**
     * gzip(data[, options]) -> Uint8Array
     * - data (Uint8Array|String): input data to compress.
     * - options (Object): zlib deflate options.
     *
     * The same as [[deflate]], but create gzip wrapper instead of
     * deflate one.
     **/


    function gzip$1(input, options) {
      options = options || {};
      options.gzip = true;
      return deflate$1(input, options);
    }

    var Deflate_1$1 = Deflate$1;
    var deflate_2 = deflate$1;
    var deflateRaw_1$1 = deflateRaw$1;
    var gzip_1$1 = gzip$1;
    var constants$1 = constants$2;
    var deflate_1$1 = {
      Deflate: Deflate_1$1,
      deflate: deflate_2,
      deflateRaw: deflateRaw_1$1,
      gzip: gzip_1$1,
      constants: constants$1
    }; // (C) 1995-2013 Jean-loup Gailly and Mark Adler
    // (C) 2014-2017 Vitaly Puzrin and Andrey Tupitsin
    //
    // This software is provided 'as-is', without any express or implied
    // warranty. In no event will the authors be held liable for any damages
    // arising from the use of this software.
    //
    // Permission is granted to anyone to use this software for any purpose,
    // including commercial applications, and to alter it and redistribute it
    // freely, subject to the following restrictions:
    //
    // 1. The origin of this software must not be misrepresented; you must not
    //   claim that you wrote the original software. If you use this software
    //   in a product, an acknowledgment in the product documentation would be
    //   appreciated but is not required.
    // 2. Altered source versions must be plainly marked as such, and must not be
    //   misrepresented as being the original software.
    // 3. This notice may not be removed or altered from any source distribution.
    // See state defs from inflate.js

    const BAD$1 = 30;
    /* got a data error -- remain here until reset */

    const TYPE$1 = 12;
    /* i: waiting for type bits, including last-flag bit */

    /*
       Decode literal, length, and distance codes and write out the resulting
       literal and match bytes until either not enough input or output is
       available, an end-of-block is encountered, or a data error is encountered.
       When large enough input and output buffers are supplied to inflate(), for
       example, a 16K input buffer and a 64K output buffer, more than 95% of the
       inflate execution time is spent in this routine.
        Entry assumptions:
             state.mode === LEN
            strm.avail_in >= 6
            strm.avail_out >= 258
            start >= strm.avail_out
            state.bits < 8
        On return, state.mode is one of:
             LEN -- ran out of enough output space or enough available input
            TYPE -- reached end of block code, inflate() to interpret next block
            BAD -- error in block data
        Notes:
         - The maximum input bits used by a length/distance pair is 15 bits for the
          length code, 5 bits for the length extra, 15 bits for the distance code,
          and 13 bits for the distance extra.  This totals 48 bits, or six bytes.
          Therefore if strm.avail_in >= 6, then there is enough input to avoid
          checking for available input while decoding.
         - The maximum bytes that a single length/distance pair can output is 258
          bytes, which is the maximum length that can be coded.  inflate_fast()
          requires strm.avail_out >= 258 for each loop to avoid checking for
          output space.
     */

    var inffast = function inflate_fast(strm, start) {
      let _in;
      /* local strm.input */


      let last;
      /* have enough input while in < last */

      let _out;
      /* local strm.output */


      let beg;
      /* inflate()'s initial strm.output */

      let end;
      /* while out < end, enough space available */
      //#ifdef INFLATE_STRICT

      let dmax;
      /* maximum distance from zlib header */
      //#endif

      let wsize;
      /* window size or zero if not using window */

      let whave;
      /* valid bytes in the window */

      let wnext;
      /* window write index */
      // Use `s_window` instead `window`, avoid conflict with instrumentation tools

      let s_window;
      /* allocated sliding window, if wsize != 0 */

      let hold;
      /* local strm.hold */

      let bits;
      /* local strm.bits */

      let lcode;
      /* local strm.lencode */

      let dcode;
      /* local strm.distcode */

      let lmask;
      /* mask for first level of length codes */

      let dmask;
      /* mask for first level of distance codes */

      let here;
      /* retrieved table entry */

      let op;
      /* code bits, operation, extra bits, or */

      /*  window position, window bytes to copy */

      let len;
      /* match length, unused bytes */

      let dist;
      /* match distance */

      let from;
      /* where to copy match from */

      let from_source;
      let input, output; // JS specific, because we have no pointers

      /* copy state to local variables */

      const state = strm.state; //here = state.here;

      _in = strm.next_in;
      input = strm.input;
      last = _in + (strm.avail_in - 5);
      _out = strm.next_out;
      output = strm.output;
      beg = _out - (start - strm.avail_out);
      end = _out + (strm.avail_out - 257); //#ifdef INFLATE_STRICT

      dmax = state.dmax; //#endif

      wsize = state.wsize;
      whave = state.whave;
      wnext = state.wnext;
      s_window = state.window;
      hold = state.hold;
      bits = state.bits;
      lcode = state.lencode;
      dcode = state.distcode;
      lmask = (1 << state.lenbits) - 1;
      dmask = (1 << state.distbits) - 1;
      /* decode literals and length/distances until end-of-block or not enough
         input data or output space */

      top: do {
        if (bits < 15) {
          hold += input[_in++] << bits;
          bits += 8;
          hold += input[_in++] << bits;
          bits += 8;
        }

        here = lcode[hold & lmask];

        dolen: for (;;) {
          // Goto emulation
          op = here >>> 24
          /*here.bits*/
          ;
          hold >>>= op;
          bits -= op;
          op = here >>> 16 & 0xff
          /*here.op*/
          ;

          if (op === 0) {
            /* literal */
            //Tracevv((stderr, here.val >= 0x20 && here.val < 0x7f ?
            //        "inflate:         literal '%c'\n" :
            //        "inflate:         literal 0x%02x\n", here.val));
            output[_out++] = here & 0xffff
            /*here.val*/
            ;
          } else if (op & 16) {
            /* length base */
            len = here & 0xffff
            /*here.val*/
            ;
            op &= 15;
            /* number of extra bits */

            if (op) {
              if (bits < op) {
                hold += input[_in++] << bits;
                bits += 8;
              }

              len += hold & (1 << op) - 1;
              hold >>>= op;
              bits -= op;
            } //Tracevv((stderr, "inflate:         length %u\n", len));


            if (bits < 15) {
              hold += input[_in++] << bits;
              bits += 8;
              hold += input[_in++] << bits;
              bits += 8;
            }

            here = dcode[hold & dmask];

            dodist: for (;;) {
              // goto emulation
              op = here >>> 24
              /*here.bits*/
              ;
              hold >>>= op;
              bits -= op;
              op = here >>> 16 & 0xff
              /*here.op*/
              ;

              if (op & 16) {
                /* distance base */
                dist = here & 0xffff
                /*here.val*/
                ;
                op &= 15;
                /* number of extra bits */

                if (bits < op) {
                  hold += input[_in++] << bits;
                  bits += 8;

                  if (bits < op) {
                    hold += input[_in++] << bits;
                    bits += 8;
                  }
                }

                dist += hold & (1 << op) - 1; //#ifdef INFLATE_STRICT

                if (dist > dmax) {
                  strm.msg = 'invalid distance too far back';
                  state.mode = BAD$1;
                  break top;
                } //#endif


                hold >>>= op;
                bits -= op; //Tracevv((stderr, "inflate:         distance %u\n", dist));

                op = _out - beg;
                /* max distance in output */

                if (dist > op) {
                  /* see if copy from window */
                  op = dist - op;
                  /* distance back in window */

                  if (op > whave) {
                    if (state.sane) {
                      strm.msg = 'invalid distance too far back';
                      state.mode = BAD$1;
                      break top;
                    } // (!) This block is disabled in zlib defaults,
                    // don't enable it for binary compatibility
                    //#ifdef INFLATE_ALLOW_INVALID_DISTANCE_TOOFAR_ARRR
                    //                if (len <= op - whave) {
                    //                  do {
                    //                    output[_out++] = 0;
                    //                  } while (--len);
                    //                  continue top;
                    //                }
                    //                len -= op - whave;
                    //                do {
                    //                  output[_out++] = 0;
                    //                } while (--op > whave);
                    //                if (op === 0) {
                    //                  from = _out - dist;
                    //                  do {
                    //                    output[_out++] = output[from++];
                    //                  } while (--len);
                    //                  continue top;
                    //                }
                    //#endif

                  }

                  from = 0; // window index

                  from_source = s_window;

                  if (wnext === 0) {
                    /* very common case */
                    from += wsize - op;

                    if (op < len) {
                      /* some from window */
                      len -= op;

                      do {
                        output[_out++] = s_window[from++];
                      } while (--op);

                      from = _out - dist;
                      /* rest from output */

                      from_source = output;
                    }
                  } else if (wnext < op) {
                    /* wrap around window */
                    from += wsize + wnext - op;
                    op -= wnext;

                    if (op < len) {
                      /* some from end of window */
                      len -= op;

                      do {
                        output[_out++] = s_window[from++];
                      } while (--op);

                      from = 0;

                      if (wnext < len) {
                        /* some from start of window */
                        op = wnext;
                        len -= op;

                        do {
                          output[_out++] = s_window[from++];
                        } while (--op);

                        from = _out - dist;
                        /* rest from output */

                        from_source = output;
                      }
                    }
                  } else {
                    /* contiguous in window */
                    from += wnext - op;

                    if (op < len) {
                      /* some from window */
                      len -= op;

                      do {
                        output[_out++] = s_window[from++];
                      } while (--op);

                      from = _out - dist;
                      /* rest from output */

                      from_source = output;
                    }
                  }

                  while (len > 2) {
                    output[_out++] = from_source[from++];
                    output[_out++] = from_source[from++];
                    output[_out++] = from_source[from++];
                    len -= 3;
                  }

                  if (len) {
                    output[_out++] = from_source[from++];

                    if (len > 1) {
                      output[_out++] = from_source[from++];
                    }
                  }
                } else {
                  from = _out - dist;
                  /* copy direct from output */

                  do {
                    /* minimum length is three */
                    output[_out++] = output[from++];
                    output[_out++] = output[from++];
                    output[_out++] = output[from++];
                    len -= 3;
                  } while (len > 2);

                  if (len) {
                    output[_out++] = output[from++];

                    if (len > 1) {
                      output[_out++] = output[from++];
                    }
                  }
                }
              } else if ((op & 64) === 0) {
                /* 2nd level distance code */
                here = dcode[(here & 0xffff
                /*here.val*/
                ) + (hold & (1 << op) - 1)];
                continue dodist;
              } else {
                strm.msg = 'invalid distance code';
                state.mode = BAD$1;
                break top;
              }

              break; // need to emulate goto via "continue"
            }
          } else if ((op & 64) === 0) {
            /* 2nd level length code */
            here = lcode[(here & 0xffff
            /*here.val*/
            ) + (hold & (1 << op) - 1)];
            continue dolen;
          } else if (op & 32) {
            /* end-of-block */
            //Tracevv((stderr, "inflate:         end of block\n"));
            state.mode = TYPE$1;
            break top;
          } else {
            strm.msg = 'invalid literal/length code';
            state.mode = BAD$1;
            break top;
          }

          break; // need to emulate goto via "continue"
        }
      } while (_in < last && _out < end);
      /* return unused bytes (on entry, bits < 8, so in won't go too far back) */


      len = bits >> 3;
      _in -= len;
      bits -= len << 3;
      hold &= (1 << bits) - 1;
      /* update state and return */

      strm.next_in = _in;
      strm.next_out = _out;
      strm.avail_in = _in < last ? 5 + (last - _in) : 5 - (_in - last);
      strm.avail_out = _out < end ? 257 + (end - _out) : 257 - (_out - end);
      state.hold = hold;
      state.bits = bits;
      return;
    }; // (C) 1995-2013 Jean-loup Gailly and Mark Adler
    // (C) 2014-2017 Vitaly Puzrin and Andrey Tupitsin
    //
    // This software is provided 'as-is', without any express or implied
    // warranty. In no event will the authors be held liable for any damages
    // arising from the use of this software.
    //
    // Permission is granted to anyone to use this software for any purpose,
    // including commercial applications, and to alter it and redistribute it
    // freely, subject to the following restrictions:
    //
    // 1. The origin of this software must not be misrepresented; you must not
    //   claim that you wrote the original software. If you use this software
    //   in a product, an acknowledgment in the product documentation would be
    //   appreciated but is not required.
    // 2. Altered source versions must be plainly marked as such, and must not be
    //   misrepresented as being the original software.
    // 3. This notice may not be removed or altered from any source distribution.


    const MAXBITS = 15;
    const ENOUGH_LENS$1 = 852;
    const ENOUGH_DISTS$1 = 592; //const ENOUGH = (ENOUGH_LENS+ENOUGH_DISTS);

    const CODES$1 = 0;
    const LENS$1 = 1;
    const DISTS$1 = 2;
    const lbase = new Uint16Array([
    /* Length codes 257..285 base */
    3, 4, 5, 6, 7, 8, 9, 10, 11, 13, 15, 17, 19, 23, 27, 31, 35, 43, 51, 59, 67, 83, 99, 115, 131, 163, 195, 227, 258, 0, 0]);
    const lext = new Uint8Array([
    /* Length codes 257..285 extra */
    16, 16, 16, 16, 16, 16, 16, 16, 17, 17, 17, 17, 18, 18, 18, 18, 19, 19, 19, 19, 20, 20, 20, 20, 21, 21, 21, 21, 16, 72, 78]);
    const dbase = new Uint16Array([
    /* Distance codes 0..29 base */
    1, 2, 3, 4, 5, 7, 9, 13, 17, 25, 33, 49, 65, 97, 129, 193, 257, 385, 513, 769, 1025, 1537, 2049, 3073, 4097, 6145, 8193, 12289, 16385, 24577, 0, 0]);
    const dext = new Uint8Array([
    /* Distance codes 0..29 extra */
    16, 16, 16, 16, 17, 17, 18, 18, 19, 19, 20, 20, 21, 21, 22, 22, 23, 23, 24, 24, 25, 25, 26, 26, 27, 27, 28, 28, 29, 29, 64, 64]);

    const inflate_table = (type, lens, lens_index, codes, table, table_index, work, opts) => {
      const bits = opts.bits; //here = opts.here; /* table entry for duplication */

      let len = 0;
      /* a code's length in bits */

      let sym = 0;
      /* index of code symbols */

      let min = 0,
          max = 0;
      /* minimum and maximum code lengths */

      let root = 0;
      /* number of index bits for root table */

      let curr = 0;
      /* number of index bits for current table */

      let drop = 0;
      /* code bits to drop for sub-table */

      let left = 0;
      /* number of prefix codes available */

      let used = 0;
      /* code entries in table used */

      let huff = 0;
      /* Huffman code */

      let incr;
      /* for incrementing code, index */

      let fill;
      /* index for replicating entries */

      let low;
      /* low bits for current root entry */

      let mask;
      /* mask for low root bits */

      let next;
      /* next available space in table */

      let base = null;
      /* base value table to use */

      let base_index = 0; //  let shoextra;    /* extra bits table to use */

      let end;
      /* use base and extra for symbol > end */

      const count = new Uint16Array(MAXBITS + 1); //[MAXBITS+1];    /* number of codes of each length */

      const offs = new Uint16Array(MAXBITS + 1); //[MAXBITS+1];     /* offsets in table for each length */

      let extra = null;
      let extra_index = 0;
      let here_bits, here_op, here_val;
      /*
       Process a set of code lengths to create a canonical Huffman code.  The
       code lengths are lens[0..codes-1].  Each length corresponds to the
       symbols 0..codes-1.  The Huffman code is generated by first sorting the
       symbols by length from short to long, and retaining the symbol order
       for codes with equal lengths.  Then the code starts with all zero bits
       for the first code of the shortest length, and the codes are integer
       increments for the same length, and zeros are appended as the length
       increases.  For the deflate format, these bits are stored backwards
       from their more natural integer increment ordering, and so when the
       decoding tables are built in the large loop below, the integer codes
       are incremented backwards.
        This routine assumes, but does not check, that all of the entries in
       lens[] are in the range 0..MAXBITS.  The caller must assure this.
       1..MAXBITS is interpreted as that code length.  zero means that that
       symbol does not occur in this code.
        The codes are sorted by computing a count of codes for each length,
       creating from that a table of starting indices for each length in the
       sorted table, and then entering the symbols in order in the sorted
       table.  The sorted table is work[], with that space being provided by
       the caller.
        The length counts are used for other purposes as well, i.e. finding
       the minimum and maximum length codes, determining if there are any
       codes at all, checking for a valid set of lengths, and looking ahead
       at length counts to determine sub-table sizes when building the
       decoding tables.
       */

      /* accumulate lengths for codes (assumes lens[] all in 0..MAXBITS) */

      for (len = 0; len <= MAXBITS; len++) {
        count[len] = 0;
      }

      for (sym = 0; sym < codes; sym++) {
        count[lens[lens_index + sym]]++;
      }
      /* bound code lengths, force root to be within code lengths */


      root = bits;

      for (max = MAXBITS; max >= 1; max--) {
        if (count[max] !== 0) {
          break;
        }
      }

      if (root > max) {
        root = max;
      }

      if (max === 0) {
        /* no symbols to code at all */
        //table.op[opts.table_index] = 64;  //here.op = (var char)64;    /* invalid code marker */
        //table.bits[opts.table_index] = 1;   //here.bits = (var char)1;
        //table.val[opts.table_index++] = 0;   //here.val = (var short)0;
        table[table_index++] = 1 << 24 | 64 << 16 | 0; //table.op[opts.table_index] = 64;
        //table.bits[opts.table_index] = 1;
        //table.val[opts.table_index++] = 0;

        table[table_index++] = 1 << 24 | 64 << 16 | 0;
        opts.bits = 1;
        return 0;
        /* no symbols, but wait for decoding to report error */
      }

      for (min = 1; min < max; min++) {
        if (count[min] !== 0) {
          break;
        }
      }

      if (root < min) {
        root = min;
      }
      /* check for an over-subscribed or incomplete set of lengths */


      left = 1;

      for (len = 1; len <= MAXBITS; len++) {
        left <<= 1;
        left -= count[len];

        if (left < 0) {
          return -1;
        }
        /* over-subscribed */

      }

      if (left > 0 && (type === CODES$1 || max !== 1)) {
        return -1;
        /* incomplete set */
      }
      /* generate offsets into symbol table for each length for sorting */


      offs[1] = 0;

      for (len = 1; len < MAXBITS; len++) {
        offs[len + 1] = offs[len] + count[len];
      }
      /* sort symbols by length, by symbol order within each length */


      for (sym = 0; sym < codes; sym++) {
        if (lens[lens_index + sym] !== 0) {
          work[offs[lens[lens_index + sym]]++] = sym;
        }
      }
      /*
       Create and fill in decoding tables.  In this loop, the table being
       filled is at next and has curr index bits.  The code being used is huff
       with length len.  That code is converted to an index by dropping drop
       bits off of the bottom.  For codes where len is less than drop + curr,
       those top drop + curr - len bits are incremented through all values to
       fill the table with replicated entries.
        root is the number of index bits for the root table.  When len exceeds
       root, sub-tables are created pointed to by the root entry with an index
       of the low root bits of huff.  This is saved in low to check for when a
       new sub-table should be started.  drop is zero when the root table is
       being filled, and drop is root when sub-tables are being filled.
        When a new sub-table is needed, it is necessary to look ahead in the
       code lengths to determine what size sub-table is needed.  The length
       counts are used for this, and so count[] is decremented as codes are
       entered in the tables.
        used keeps track of how many table entries have been allocated from the
       provided *table space.  It is checked for LENS and DIST tables against
       the constants ENOUGH_LENS and ENOUGH_DISTS to guard against changes in
       the initial root table size constants.  See the comments in inftrees.h
       for more information.
        sym increments through all symbols, and the loop terminates when
       all codes of length max, i.e. all codes, have been processed.  This
       routine permits incomplete codes, so another loop after this one fills
       in the rest of the decoding tables with invalid code markers.
       */

      /* set up for code type */
      // poor man optimization - use if-else instead of switch,
      // to avoid deopts in old v8


      if (type === CODES$1) {
        base = extra = work;
        /* dummy value--not used */

        end = 19;
      } else if (type === LENS$1) {
        base = lbase;
        base_index -= 257;
        extra = lext;
        extra_index -= 257;
        end = 256;
      } else {
        /* DISTS */
        base = dbase;
        extra = dext;
        end = -1;
      }
      /* initialize opts for loop */


      huff = 0;
      /* starting code */

      sym = 0;
      /* starting code symbol */

      len = min;
      /* starting code length */

      next = table_index;
      /* current table to fill in */

      curr = root;
      /* current table index bits */

      drop = 0;
      /* current bits to drop from code for index */

      low = -1;
      /* trigger new sub-table when len > root */

      used = 1 << root;
      /* use root table entries */

      mask = used - 1;
      /* mask for comparing low */

      /* check available table space */

      if (type === LENS$1 && used > ENOUGH_LENS$1 || type === DISTS$1 && used > ENOUGH_DISTS$1) {
        return 1;
      }
      /* process all codes and make table entries */


      for (;;) {
        /* create table entry */
        here_bits = len - drop;

        if (work[sym] < end) {
          here_op = 0;
          here_val = work[sym];
        } else if (work[sym] > end) {
          here_op = extra[extra_index + work[sym]];
          here_val = base[base_index + work[sym]];
        } else {
          here_op = 32 + 64;
          /* end of block */

          here_val = 0;
        }
        /* replicate for those indices with low len bits equal to huff */


        incr = 1 << len - drop;
        fill = 1 << curr;
        min = fill;
        /* save offset to next table */

        do {
          fill -= incr;
          table[next + (huff >> drop) + fill] = here_bits << 24 | here_op << 16 | here_val | 0;
        } while (fill !== 0);
        /* backwards increment the len-bit code huff */


        incr = 1 << len - 1;

        while (huff & incr) {
          incr >>= 1;
        }

        if (incr !== 0) {
          huff &= incr - 1;
          huff += incr;
        } else {
          huff = 0;
        }
        /* go to next symbol, update count, len */


        sym++;

        if (--count[len] === 0) {
          if (len === max) {
            break;
          }

          len = lens[lens_index + work[sym]];
        }
        /* create new sub-table if needed */


        if (len > root && (huff & mask) !== low) {
          /* if first time, transition to sub-tables */
          if (drop === 0) {
            drop = root;
          }
          /* increment past last table */


          next += min;
          /* here min is 1 << curr */

          /* determine length of next table */

          curr = len - drop;
          left = 1 << curr;

          while (curr + drop < max) {
            left -= count[curr + drop];

            if (left <= 0) {
              break;
            }

            curr++;
            left <<= 1;
          }
          /* check for enough space */


          used += 1 << curr;

          if (type === LENS$1 && used > ENOUGH_LENS$1 || type === DISTS$1 && used > ENOUGH_DISTS$1) {
            return 1;
          }
          /* point entry in root table to sub-table */


          low = huff & mask;
          /*table.op[low] = curr;
          table.bits[low] = root;
          table.val[low] = next - opts.table_index;*/

          table[low] = root << 24 | curr << 16 | next - table_index | 0;
        }
      }
      /* fill in remaining table entry if code is incomplete (guaranteed to have
       at most one remaining entry, since if the code is incomplete, the
       maximum code length that was allowed to get this far is one bit) */


      if (huff !== 0) {
        //table.op[next + huff] = 64;            /* invalid code marker */
        //table.bits[next + huff] = len - drop;
        //table.val[next + huff] = 0;
        table[next + huff] = len - drop << 24 | 64 << 16 | 0;
      }
      /* set return parameters */
      //opts.table_index += used;


      opts.bits = root;
      return 0;
    };

    var inftrees = inflate_table; // (C) 1995-2013 Jean-loup Gailly and Mark Adler
    // (C) 2014-2017 Vitaly Puzrin and Andrey Tupitsin
    //
    // This software is provided 'as-is', without any express or implied
    // warranty. In no event will the authors be held liable for any damages
    // arising from the use of this software.
    //
    // Permission is granted to anyone to use this software for any purpose,
    // including commercial applications, and to alter it and redistribute it
    // freely, subject to the following restrictions:
    //
    // 1. The origin of this software must not be misrepresented; you must not
    //   claim that you wrote the original software. If you use this software
    //   in a product, an acknowledgment in the product documentation would be
    //   appreciated but is not required.
    // 2. Altered source versions must be plainly marked as such, and must not be
    //   misrepresented as being the original software.
    // 3. This notice may not be removed or altered from any source distribution.

    const CODES = 0;
    const LENS = 1;
    const DISTS = 2;
    /* Public constants ==========================================================*/

    /* ===========================================================================*/

    const {
      Z_FINISH: Z_FINISH$1,
      Z_BLOCK,
      Z_TREES,
      Z_OK: Z_OK$1,
      Z_STREAM_END: Z_STREAM_END$1,
      Z_NEED_DICT: Z_NEED_DICT$1,
      Z_STREAM_ERROR: Z_STREAM_ERROR$1,
      Z_DATA_ERROR: Z_DATA_ERROR$1,
      Z_MEM_ERROR: Z_MEM_ERROR$1,
      Z_BUF_ERROR,
      Z_DEFLATED
    } = constants$2;
    /* STATES ====================================================================*/

    /* ===========================================================================*/

    const HEAD = 1;
    /* i: waiting for magic header */

    const FLAGS = 2;
    /* i: waiting for method and flags (gzip) */

    const TIME = 3;
    /* i: waiting for modification time (gzip) */

    const OS = 4;
    /* i: waiting for extra flags and operating system (gzip) */

    const EXLEN = 5;
    /* i: waiting for extra length (gzip) */

    const EXTRA = 6;
    /* i: waiting for extra bytes (gzip) */

    const NAME$1 = 7;
    /* i: waiting for end of file name (gzip) */

    const COMMENT = 8;
    /* i: waiting for end of comment (gzip) */

    const HCRC = 9;
    /* i: waiting for header crc (gzip) */

    const DICTID = 10;
    /* i: waiting for dictionary check value */

    const DICT = 11;
    /* waiting for inflateSetDictionary() call */

    const TYPE = 12;
    /* i: waiting for type bits, including last-flag bit */

    const TYPEDO = 13;
    /* i: same, but skip check to exit inflate on new block */

    const STORED = 14;
    /* i: waiting for stored size (length and complement) */

    const COPY_ = 15;
    /* i/o: same as COPY below, but only first time in */

    const COPY = 16;
    /* i/o: waiting for input or output to copy stored block */

    const TABLE = 17;
    /* i: waiting for dynamic block table lengths */

    const LENLENS = 18;
    /* i: waiting for code length code lengths */

    const CODELENS = 19;
    /* i: waiting for length/lit and distance code lengths */

    const LEN_ = 20;
    /* i: same as LEN below, but only first time in */

    const LEN = 21;
    /* i: waiting for length/lit/eob code */

    const LENEXT = 22;
    /* i: waiting for length extra bits */

    const DIST = 23;
    /* i: waiting for distance code */

    const DISTEXT = 24;
    /* i: waiting for distance extra bits */

    const MATCH = 25;
    /* o: waiting for output space to copy string */

    const LIT = 26;
    /* o: waiting for output space to write literal */

    const CHECK = 27;
    /* i: waiting for 32-bit check value */

    const LENGTH = 28;
    /* i: waiting for 32-bit length (gzip) */

    const DONE = 29;
    /* finished check, done -- remain here until reset */

    const BAD = 30;
    /* got a data error -- remain here until reset */

    const MEM = 31;
    /* got an inflate() memory error -- remain here until reset */

    const SYNC = 32;
    /* looking for synchronization bytes to restart inflate() */

    /* ===========================================================================*/

    const ENOUGH_LENS = 852;
    const ENOUGH_DISTS = 592; //const ENOUGH =  (ENOUGH_LENS+ENOUGH_DISTS);

    const MAX_WBITS = 15;
    /* 32K LZ77 window */

    const DEF_WBITS = MAX_WBITS;

    const zswap32 = q => {
      return (q >>> 24 & 0xff) + (q >>> 8 & 0xff00) + ((q & 0xff00) << 8) + ((q & 0xff) << 24);
    };

    function InflateState() {
      this.mode = 0;
      /* current inflate mode */

      this.last = false;
      /* true if processing last block */

      this.wrap = 0;
      /* bit 0 true for zlib, bit 1 true for gzip */

      this.havedict = false;
      /* true if dictionary provided */

      this.flags = 0;
      /* gzip header method and flags (0 if zlib) */

      this.dmax = 0;
      /* zlib header max distance (INFLATE_STRICT) */

      this.check = 0;
      /* protected copy of check value */

      this.total = 0;
      /* protected copy of output count */
      // TODO: may be {}

      this.head = null;
      /* where to save gzip header information */

      /* sliding window */

      this.wbits = 0;
      /* log base 2 of requested window size */

      this.wsize = 0;
      /* window size or zero if not using window */

      this.whave = 0;
      /* valid bytes in the window */

      this.wnext = 0;
      /* window write index */

      this.window = null;
      /* allocated sliding window, if needed */

      /* bit accumulator */

      this.hold = 0;
      /* input bit accumulator */

      this.bits = 0;
      /* number of bits in "in" */

      /* for string and stored block copying */

      this.length = 0;
      /* literal or length of data to copy */

      this.offset = 0;
      /* distance back to copy string from */

      /* for table and code decoding */

      this.extra = 0;
      /* extra bits needed */

      /* fixed and dynamic code tables */

      this.lencode = null;
      /* starting table for length/literal codes */

      this.distcode = null;
      /* starting table for distance codes */

      this.lenbits = 0;
      /* index bits for lencode */

      this.distbits = 0;
      /* index bits for distcode */

      /* dynamic table building */

      this.ncode = 0;
      /* number of code length code lengths */

      this.nlen = 0;
      /* number of length code lengths */

      this.ndist = 0;
      /* number of distance code lengths */

      this.have = 0;
      /* number of code lengths in lens[] */

      this.next = null;
      /* next available space in codes[] */

      this.lens = new Uint16Array(320);
      /* temporary storage for code lengths */

      this.work = new Uint16Array(288);
      /* work area for code table building */

      /*
       because we don't have pointers in js, we use lencode and distcode directly
       as buffers so we don't need codes
      */
      //this.codes = new Int32Array(ENOUGH);       /* space for code tables */

      this.lendyn = null;
      /* dynamic table for length/literal codes (JS specific) */

      this.distdyn = null;
      /* dynamic table for distance codes (JS specific) */

      this.sane = 0;
      /* if false, allow invalid distance too far */

      this.back = 0;
      /* bits back of last unprocessed length/lit */

      this.was = 0;
      /* initial length of match */
    }

    const inflateResetKeep = strm => {
      if (!strm || !strm.state) {
        return Z_STREAM_ERROR$1;
      }

      const state = strm.state;
      strm.total_in = strm.total_out = state.total = 0;
      strm.msg = '';
      /*Z_NULL*/

      if (state.wrap) {
        /* to support ill-conceived Java test suite */
        strm.adler = state.wrap & 1;
      }

      state.mode = HEAD;
      state.last = 0;
      state.havedict = 0;
      state.dmax = 32768;
      state.head = null
      /*Z_NULL*/
      ;
      state.hold = 0;
      state.bits = 0; //state.lencode = state.distcode = state.next = state.codes;

      state.lencode = state.lendyn = new Int32Array(ENOUGH_LENS);
      state.distcode = state.distdyn = new Int32Array(ENOUGH_DISTS);
      state.sane = 1;
      state.back = -1; //Tracev((stderr, "inflate: reset\n"));

      return Z_OK$1;
    };

    const inflateReset = strm => {
      if (!strm || !strm.state) {
        return Z_STREAM_ERROR$1;
      }

      const state = strm.state;
      state.wsize = 0;
      state.whave = 0;
      state.wnext = 0;
      return inflateResetKeep(strm);
    };

    const inflateReset2 = (strm, windowBits) => {
      let wrap;
      /* get the state */

      if (!strm || !strm.state) {
        return Z_STREAM_ERROR$1;
      }

      const state = strm.state;
      /* extract wrap request from windowBits parameter */

      if (windowBits < 0) {
        wrap = 0;
        windowBits = -windowBits;
      } else {
        wrap = (windowBits >> 4) + 1;

        if (windowBits < 48) {
          windowBits &= 15;
        }
      }
      /* set number of window bits, free window if different */


      if (windowBits && (windowBits < 8 || windowBits > 15)) {
        return Z_STREAM_ERROR$1;
      }

      if (state.window !== null && state.wbits !== windowBits) {
        state.window = null;
      }
      /* update state and reset the rest of it */


      state.wrap = wrap;
      state.wbits = windowBits;
      return inflateReset(strm);
    };

    const inflateInit2 = (strm, windowBits) => {
      if (!strm) {
        return Z_STREAM_ERROR$1;
      } //strm.msg = Z_NULL;                 /* in case we return an error */


      const state = new InflateState(); //if (state === Z_NULL) return Z_MEM_ERROR;
      //Tracev((stderr, "inflate: allocated\n"));

      strm.state = state;
      state.window = null
      /*Z_NULL*/
      ;
      const ret = inflateReset2(strm, windowBits);

      if (ret !== Z_OK$1) {
        strm.state = null
        /*Z_NULL*/
        ;
      }

      return ret;
    };

    const inflateInit = strm => {
      return inflateInit2(strm, DEF_WBITS);
    };
    /*
     Return state with length and distance decoding tables and index sizes set to
     fixed code decoding.  Normally this returns fixed tables from inffixed.h.
     If BUILDFIXED is defined, then instead this routine builds the tables the
     first time it's called, and returns those tables the first time and
     thereafter.  This reduces the size of the code by about 2K bytes, in
     exchange for a little execution time.  However, BUILDFIXED should not be
     used for threaded applications, since the rewriting of the tables and virgin
     may not be thread-safe.
     */


    let virgin = true;
    let lenfix, distfix; // We have no pointers in JS, so keep tables separate

    const fixedtables = state => {
      /* build fixed huffman tables if first call (may not be thread safe) */
      if (virgin) {
        lenfix = new Int32Array(512);
        distfix = new Int32Array(32);
        /* literal/length table */

        let sym = 0;

        while (sym < 144) {
          state.lens[sym++] = 8;
        }

        while (sym < 256) {
          state.lens[sym++] = 9;
        }

        while (sym < 280) {
          state.lens[sym++] = 7;
        }

        while (sym < 288) {
          state.lens[sym++] = 8;
        }

        inftrees(LENS, state.lens, 0, 288, lenfix, 0, state.work, {
          bits: 9
        });
        /* distance table */

        sym = 0;

        while (sym < 32) {
          state.lens[sym++] = 5;
        }

        inftrees(DISTS, state.lens, 0, 32, distfix, 0, state.work, {
          bits: 5
        });
        /* do this just once */

        virgin = false;
      }

      state.lencode = lenfix;
      state.lenbits = 9;
      state.distcode = distfix;
      state.distbits = 5;
    };
    /*
     Update the window with the last wsize (normally 32K) bytes written before
     returning.  If window does not exist yet, create it.  This is only called
     when a window is already in use, or when output has been written during this
     inflate call, but the end of the deflate stream has not been reached yet.
     It is also called to create a window for dictionary data when a dictionary
     is loaded.
      Providing output buffers larger than 32K to inflate() should provide a speed
     advantage, since only the last 32K of output is copied to the sliding window
     upon return from inflate(), and since all distances after the first 32K of
     output will fall in the output data, making match copies simpler and faster.
     The advantage may be dependent on the size of the processor's data caches.
     */


    const updatewindow = (strm, src, end, copy) => {
      let dist;
      const state = strm.state;
      /* if it hasn't been done already, allocate space for the window */

      if (state.window === null) {
        state.wsize = 1 << state.wbits;
        state.wnext = 0;
        state.whave = 0;
        state.window = new Uint8Array(state.wsize);
      }
      /* copy state->wsize or less output bytes into the circular window */


      if (copy >= state.wsize) {
        state.window.set(src.subarray(end - state.wsize, end), 0);
        state.wnext = 0;
        state.whave = state.wsize;
      } else {
        dist = state.wsize - state.wnext;

        if (dist > copy) {
          dist = copy;
        } //zmemcpy(state->window + state->wnext, end - copy, dist);


        state.window.set(src.subarray(end - copy, end - copy + dist), state.wnext);
        copy -= dist;

        if (copy) {
          //zmemcpy(state->window, end - copy, copy);
          state.window.set(src.subarray(end - copy, end), 0);
          state.wnext = copy;
          state.whave = state.wsize;
        } else {
          state.wnext += dist;

          if (state.wnext === state.wsize) {
            state.wnext = 0;
          }

          if (state.whave < state.wsize) {
            state.whave += dist;
          }
        }
      }

      return 0;
    };

    const inflate$2 = (strm, flush) => {
      let state;
      let input, output; // input/output buffers

      let next;
      /* next input INDEX */

      let put;
      /* next output INDEX */

      let have, left;
      /* available input and output */

      let hold;
      /* bit buffer */

      let bits;
      /* bits in bit buffer */

      let _in, _out;
      /* save starting available input and output */


      let copy;
      /* number of stored or match bytes to copy */

      let from;
      /* where to copy match bytes from */

      let from_source;
      let here = 0;
      /* current decoding table entry */

      let here_bits, here_op, here_val; // paked "here" denormalized (JS specific)
      //let last;                   /* parent table entry */

      let last_bits, last_op, last_val; // paked "last" denormalized (JS specific)

      let len;
      /* length to copy for repeats, bits to drop */

      let ret;
      /* return code */

      const hbuf = new Uint8Array(4);
      /* buffer for gzip header crc calculation */

      let opts;
      let n; // temporary variable for NEED_BITS

      const order =
      /* permutation of code lengths */
      new Uint8Array([16, 17, 18, 0, 8, 7, 9, 6, 10, 5, 11, 4, 12, 3, 13, 2, 14, 1, 15]);

      if (!strm || !strm.state || !strm.output || !strm.input && strm.avail_in !== 0) {
        return Z_STREAM_ERROR$1;
      }

      state = strm.state;

      if (state.mode === TYPE) {
        state.mode = TYPEDO;
      }
      /* skip check */
      //--- LOAD() ---


      put = strm.next_out;
      output = strm.output;
      left = strm.avail_out;
      next = strm.next_in;
      input = strm.input;
      have = strm.avail_in;
      hold = state.hold;
      bits = state.bits; //---

      _in = have;
      _out = left;
      ret = Z_OK$1;

      inf_leave: // goto emulation
      for (;;) {
        switch (state.mode) {
          case HEAD:
            if (state.wrap === 0) {
              state.mode = TYPEDO;
              break;
            } //=== NEEDBITS(16);


            while (bits < 16) {
              if (have === 0) {
                break inf_leave;
              }

              have--;
              hold += input[next++] << bits;
              bits += 8;
            } //===//


            if (state.wrap & 2 && hold === 0x8b1f) {
              /* gzip header */
              state.check = 0
              /*crc32(0L, Z_NULL, 0)*/
              ; //=== CRC2(state.check, hold);

              hbuf[0] = hold & 0xff;
              hbuf[1] = hold >>> 8 & 0xff;
              state.check = crc32_1(state.check, hbuf, 2, 0); //===//
              //=== INITBITS();

              hold = 0;
              bits = 0; //===//

              state.mode = FLAGS;
              break;
            }

            state.flags = 0;
            /* expect zlib header */

            if (state.head) {
              state.head.done = false;
            }

            if (!(state.wrap & 1) ||
            /* check if zlib header allowed */
            (((hold & 0xff
            /*BITS(8)*/
            ) << 8) + (hold >> 8)) % 31) {
              strm.msg = 'incorrect header check';
              state.mode = BAD;
              break;
            }

            if ((hold & 0x0f
            /*BITS(4)*/
            ) !== Z_DEFLATED) {
              strm.msg = 'unknown compression method';
              state.mode = BAD;
              break;
            } //--- DROPBITS(4) ---//


            hold >>>= 4;
            bits -= 4; //---//

            len = (hold & 0x0f
            /*BITS(4)*/
            ) + 8;

            if (state.wbits === 0) {
              state.wbits = len;
            } else if (len > state.wbits) {
              strm.msg = 'invalid window size';
              state.mode = BAD;
              break;
            } // !!! pako patch. Force use `options.windowBits` if passed.
            // Required to always use max window size by default.


            state.dmax = 1 << state.wbits; //state.dmax = 1 << len;
            //Tracev((stderr, "inflate:   zlib header ok\n"));

            strm.adler = state.check = 1
            /*adler32(0L, Z_NULL, 0)*/
            ;
            state.mode = hold & 0x200 ? DICTID : TYPE; //=== INITBITS();

            hold = 0;
            bits = 0; //===//

            break;

          case FLAGS:
            //=== NEEDBITS(16); */
            while (bits < 16) {
              if (have === 0) {
                break inf_leave;
              }

              have--;
              hold += input[next++] << bits;
              bits += 8;
            } //===//


            state.flags = hold;

            if ((state.flags & 0xff) !== Z_DEFLATED) {
              strm.msg = 'unknown compression method';
              state.mode = BAD;
              break;
            }

            if (state.flags & 0xe000) {
              strm.msg = 'unknown header flags set';
              state.mode = BAD;
              break;
            }

            if (state.head) {
              state.head.text = hold >> 8 & 1;
            }

            if (state.flags & 0x0200) {
              //=== CRC2(state.check, hold);
              hbuf[0] = hold & 0xff;
              hbuf[1] = hold >>> 8 & 0xff;
              state.check = crc32_1(state.check, hbuf, 2, 0); //===//
            } //=== INITBITS();


            hold = 0;
            bits = 0; //===//

            state.mode = TIME;

          /* falls through */

          case TIME:
            //=== NEEDBITS(32); */
            while (bits < 32) {
              if (have === 0) {
                break inf_leave;
              }

              have--;
              hold += input[next++] << bits;
              bits += 8;
            } //===//


            if (state.head) {
              state.head.time = hold;
            }

            if (state.flags & 0x0200) {
              //=== CRC4(state.check, hold)
              hbuf[0] = hold & 0xff;
              hbuf[1] = hold >>> 8 & 0xff;
              hbuf[2] = hold >>> 16 & 0xff;
              hbuf[3] = hold >>> 24 & 0xff;
              state.check = crc32_1(state.check, hbuf, 4, 0); //===
            } //=== INITBITS();


            hold = 0;
            bits = 0; //===//

            state.mode = OS;

          /* falls through */

          case OS:
            //=== NEEDBITS(16); */
            while (bits < 16) {
              if (have === 0) {
                break inf_leave;
              }

              have--;
              hold += input[next++] << bits;
              bits += 8;
            } //===//


            if (state.head) {
              state.head.xflags = hold & 0xff;
              state.head.os = hold >> 8;
            }

            if (state.flags & 0x0200) {
              //=== CRC2(state.check, hold);
              hbuf[0] = hold & 0xff;
              hbuf[1] = hold >>> 8 & 0xff;
              state.check = crc32_1(state.check, hbuf, 2, 0); //===//
            } //=== INITBITS();


            hold = 0;
            bits = 0; //===//

            state.mode = EXLEN;

          /* falls through */

          case EXLEN:
            if (state.flags & 0x0400) {
              //=== NEEDBITS(16); */
              while (bits < 16) {
                if (have === 0) {
                  break inf_leave;
                }

                have--;
                hold += input[next++] << bits;
                bits += 8;
              } //===//


              state.length = hold;

              if (state.head) {
                state.head.extra_len = hold;
              }

              if (state.flags & 0x0200) {
                //=== CRC2(state.check, hold);
                hbuf[0] = hold & 0xff;
                hbuf[1] = hold >>> 8 & 0xff;
                state.check = crc32_1(state.check, hbuf, 2, 0); //===//
              } //=== INITBITS();


              hold = 0;
              bits = 0; //===//
            } else if (state.head) {
              state.head.extra = null
              /*Z_NULL*/
              ;
            }

            state.mode = EXTRA;

          /* falls through */

          case EXTRA:
            if (state.flags & 0x0400) {
              copy = state.length;

              if (copy > have) {
                copy = have;
              }

              if (copy) {
                if (state.head) {
                  len = state.head.extra_len - state.length;

                  if (!state.head.extra) {
                    // Use untyped array for more convenient processing later
                    state.head.extra = new Uint8Array(state.head.extra_len);
                  }

                  state.head.extra.set(input.subarray(next, // extra field is limited to 65536 bytes
                  // - no need for additional size check
                  next + copy),
                  /*len + copy > state.head.extra_max - len ? state.head.extra_max : copy,*/
                  len); //zmemcpy(state.head.extra + len, next,
                  //        len + copy > state.head.extra_max ?
                  //        state.head.extra_max - len : copy);
                }

                if (state.flags & 0x0200) {
                  state.check = crc32_1(state.check, input, copy, next);
                }

                have -= copy;
                next += copy;
                state.length -= copy;
              }

              if (state.length) {
                break inf_leave;
              }
            }

            state.length = 0;
            state.mode = NAME$1;

          /* falls through */

          case NAME$1:
            if (state.flags & 0x0800) {
              if (have === 0) {
                break inf_leave;
              }

              copy = 0;

              do {
                // TODO: 2 or 1 bytes?
                len = input[next + copy++];
                /* use constant limit because in js we should not preallocate memory */

                if (state.head && len && state.length < 65536
                /*state.head.name_max*/
                ) {
                  state.head.name += String.fromCharCode(len);
                }
              } while (len && copy < have);

              if (state.flags & 0x0200) {
                state.check = crc32_1(state.check, input, copy, next);
              }

              have -= copy;
              next += copy;

              if (len) {
                break inf_leave;
              }
            } else if (state.head) {
              state.head.name = null;
            }

            state.length = 0;
            state.mode = COMMENT;

          /* falls through */

          case COMMENT:
            if (state.flags & 0x1000) {
              if (have === 0) {
                break inf_leave;
              }

              copy = 0;

              do {
                len = input[next + copy++];
                /* use constant limit because in js we should not preallocate memory */

                if (state.head && len && state.length < 65536
                /*state.head.comm_max*/
                ) {
                  state.head.comment += String.fromCharCode(len);
                }
              } while (len && copy < have);

              if (state.flags & 0x0200) {
                state.check = crc32_1(state.check, input, copy, next);
              }

              have -= copy;
              next += copy;

              if (len) {
                break inf_leave;
              }
            } else if (state.head) {
              state.head.comment = null;
            }

            state.mode = HCRC;

          /* falls through */

          case HCRC:
            if (state.flags & 0x0200) {
              //=== NEEDBITS(16); */
              while (bits < 16) {
                if (have === 0) {
                  break inf_leave;
                }

                have--;
                hold += input[next++] << bits;
                bits += 8;
              } //===//


              if (hold !== (state.check & 0xffff)) {
                strm.msg = 'header crc mismatch';
                state.mode = BAD;
                break;
              } //=== INITBITS();


              hold = 0;
              bits = 0; //===//
            }

            if (state.head) {
              state.head.hcrc = state.flags >> 9 & 1;
              state.head.done = true;
            }

            strm.adler = state.check = 0;
            state.mode = TYPE;
            break;

          case DICTID:
            //=== NEEDBITS(32); */
            while (bits < 32) {
              if (have === 0) {
                break inf_leave;
              }

              have--;
              hold += input[next++] << bits;
              bits += 8;
            } //===//


            strm.adler = state.check = zswap32(hold); //=== INITBITS();

            hold = 0;
            bits = 0; //===//

            state.mode = DICT;

          /* falls through */

          case DICT:
            if (state.havedict === 0) {
              //--- RESTORE() ---
              strm.next_out = put;
              strm.avail_out = left;
              strm.next_in = next;
              strm.avail_in = have;
              state.hold = hold;
              state.bits = bits; //---

              return Z_NEED_DICT$1;
            }

            strm.adler = state.check = 1
            /*adler32(0L, Z_NULL, 0)*/
            ;
            state.mode = TYPE;

          /* falls through */

          case TYPE:
            if (flush === Z_BLOCK || flush === Z_TREES) {
              break inf_leave;
            }

          /* falls through */

          case TYPEDO:
            if (state.last) {
              //--- BYTEBITS() ---//
              hold >>>= bits & 7;
              bits -= bits & 7; //---//

              state.mode = CHECK;
              break;
            } //=== NEEDBITS(3); */


            while (bits < 3) {
              if (have === 0) {
                break inf_leave;
              }

              have--;
              hold += input[next++] << bits;
              bits += 8;
            } //===//


            state.last = hold & 0x01
            /*BITS(1)*/
            ; //--- DROPBITS(1) ---//

            hold >>>= 1;
            bits -= 1; //---//

            switch (hold & 0x03
            /*BITS(2)*/
            ) {
              case 0:
                /* stored block */
                //Tracev((stderr, "inflate:     stored block%s\n",
                //        state.last ? " (last)" : ""));
                state.mode = STORED;
                break;

              case 1:
                /* fixed block */
                fixedtables(state); //Tracev((stderr, "inflate:     fixed codes block%s\n",
                //        state.last ? " (last)" : ""));

                state.mode = LEN_;
                /* decode codes */

                if (flush === Z_TREES) {
                  //--- DROPBITS(2) ---//
                  hold >>>= 2;
                  bits -= 2; //---//

                  break inf_leave;
                }

                break;

              case 2:
                /* dynamic block */
                //Tracev((stderr, "inflate:     dynamic codes block%s\n",
                //        state.last ? " (last)" : ""));
                state.mode = TABLE;
                break;

              case 3:
                strm.msg = 'invalid block type';
                state.mode = BAD;
            } //--- DROPBITS(2) ---//


            hold >>>= 2;
            bits -= 2; //---//

            break;

          case STORED:
            //--- BYTEBITS() ---// /* go to byte boundary */
            hold >>>= bits & 7;
            bits -= bits & 7; //---//
            //=== NEEDBITS(32); */

            while (bits < 32) {
              if (have === 0) {
                break inf_leave;
              }

              have--;
              hold += input[next++] << bits;
              bits += 8;
            } //===//


            if ((hold & 0xffff) !== (hold >>> 16 ^ 0xffff)) {
              strm.msg = 'invalid stored block lengths';
              state.mode = BAD;
              break;
            }

            state.length = hold & 0xffff; //Tracev((stderr, "inflate:       stored length %u\n",
            //        state.length));
            //=== INITBITS();

            hold = 0;
            bits = 0; //===//

            state.mode = COPY_;

            if (flush === Z_TREES) {
              break inf_leave;
            }

          /* falls through */

          case COPY_:
            state.mode = COPY;

          /* falls through */

          case COPY:
            copy = state.length;

            if (copy) {
              if (copy > have) {
                copy = have;
              }

              if (copy > left) {
                copy = left;
              }

              if (copy === 0) {
                break inf_leave;
              } //--- zmemcpy(put, next, copy); ---


              output.set(input.subarray(next, next + copy), put); //---//

              have -= copy;
              next += copy;
              left -= copy;
              put += copy;
              state.length -= copy;
              break;
            } //Tracev((stderr, "inflate:       stored end\n"));


            state.mode = TYPE;
            break;

          case TABLE:
            //=== NEEDBITS(14); */
            while (bits < 14) {
              if (have === 0) {
                break inf_leave;
              }

              have--;
              hold += input[next++] << bits;
              bits += 8;
            } //===//


            state.nlen = (hold & 0x1f
            /*BITS(5)*/
            ) + 257; //--- DROPBITS(5) ---//

            hold >>>= 5;
            bits -= 5; //---//

            state.ndist = (hold & 0x1f
            /*BITS(5)*/
            ) + 1; //--- DROPBITS(5) ---//

            hold >>>= 5;
            bits -= 5; //---//

            state.ncode = (hold & 0x0f
            /*BITS(4)*/
            ) + 4; //--- DROPBITS(4) ---//

            hold >>>= 4;
            bits -= 4; //---//
            //#ifndef PKZIP_BUG_WORKAROUND

            if (state.nlen > 286 || state.ndist > 30) {
              strm.msg = 'too many length or distance symbols';
              state.mode = BAD;
              break;
            } //#endif
            //Tracev((stderr, "inflate:       table sizes ok\n"));


            state.have = 0;
            state.mode = LENLENS;

          /* falls through */

          case LENLENS:
            while (state.have < state.ncode) {
              //=== NEEDBITS(3);
              while (bits < 3) {
                if (have === 0) {
                  break inf_leave;
                }

                have--;
                hold += input[next++] << bits;
                bits += 8;
              } //===//


              state.lens[order[state.have++]] = hold & 0x07; //BITS(3);
              //--- DROPBITS(3) ---//

              hold >>>= 3;
              bits -= 3; //---//
            }

            while (state.have < 19) {
              state.lens[order[state.have++]] = 0;
            } // We have separate tables & no pointers. 2 commented lines below not needed.
            //state.next = state.codes;
            //state.lencode = state.next;
            // Switch to use dynamic table


            state.lencode = state.lendyn;
            state.lenbits = 7;
            opts = {
              bits: state.lenbits
            };
            ret = inftrees(CODES, state.lens, 0, 19, state.lencode, 0, state.work, opts);
            state.lenbits = opts.bits;

            if (ret) {
              strm.msg = 'invalid code lengths set';
              state.mode = BAD;
              break;
            } //Tracev((stderr, "inflate:       code lengths ok\n"));


            state.have = 0;
            state.mode = CODELENS;

          /* falls through */

          case CODELENS:
            while (state.have < state.nlen + state.ndist) {
              for (;;) {
                here = state.lencode[hold & (1 << state.lenbits) - 1];
                /*BITS(state.lenbits)*/

                here_bits = here >>> 24;
                here_op = here >>> 16 & 0xff;
                here_val = here & 0xffff;

                if (here_bits <= bits) {
                  break;
                } //--- PULLBYTE() ---//


                if (have === 0) {
                  break inf_leave;
                }

                have--;
                hold += input[next++] << bits;
                bits += 8; //---//
              }

              if (here_val < 16) {
                //--- DROPBITS(here.bits) ---//
                hold >>>= here_bits;
                bits -= here_bits; //---//

                state.lens[state.have++] = here_val;
              } else {
                if (here_val === 16) {
                  //=== NEEDBITS(here.bits + 2);
                  n = here_bits + 2;

                  while (bits < n) {
                    if (have === 0) {
                      break inf_leave;
                    }

                    have--;
                    hold += input[next++] << bits;
                    bits += 8;
                  } //===//
                  //--- DROPBITS(here.bits) ---//


                  hold >>>= here_bits;
                  bits -= here_bits; //---//

                  if (state.have === 0) {
                    strm.msg = 'invalid bit length repeat';
                    state.mode = BAD;
                    break;
                  }

                  len = state.lens[state.have - 1];
                  copy = 3 + (hold & 0x03); //BITS(2);
                  //--- DROPBITS(2) ---//

                  hold >>>= 2;
                  bits -= 2; //---//
                } else if (here_val === 17) {
                  //=== NEEDBITS(here.bits + 3);
                  n = here_bits + 3;

                  while (bits < n) {
                    if (have === 0) {
                      break inf_leave;
                    }

                    have--;
                    hold += input[next++] << bits;
                    bits += 8;
                  } //===//
                  //--- DROPBITS(here.bits) ---//


                  hold >>>= here_bits;
                  bits -= here_bits; //---//

                  len = 0;
                  copy = 3 + (hold & 0x07); //BITS(3);
                  //--- DROPBITS(3) ---//

                  hold >>>= 3;
                  bits -= 3; //---//
                } else {
                  //=== NEEDBITS(here.bits + 7);
                  n = here_bits + 7;

                  while (bits < n) {
                    if (have === 0) {
                      break inf_leave;
                    }

                    have--;
                    hold += input[next++] << bits;
                    bits += 8;
                  } //===//
                  //--- DROPBITS(here.bits) ---//


                  hold >>>= here_bits;
                  bits -= here_bits; //---//

                  len = 0;
                  copy = 11 + (hold & 0x7f); //BITS(7);
                  //--- DROPBITS(7) ---//

                  hold >>>= 7;
                  bits -= 7; //---//
                }

                if (state.have + copy > state.nlen + state.ndist) {
                  strm.msg = 'invalid bit length repeat';
                  state.mode = BAD;
                  break;
                }

                while (copy--) {
                  state.lens[state.have++] = len;
                }
              }
            }
            /* handle error breaks in while */


            if (state.mode === BAD) {
              break;
            }
            /* check for end-of-block code (better have one) */


            if (state.lens[256] === 0) {
              strm.msg = 'invalid code -- missing end-of-block';
              state.mode = BAD;
              break;
            }
            /* build code tables -- note: do not change the lenbits or distbits
               values here (9 and 6) without reading the comments in inftrees.h
               concerning the ENOUGH constants, which depend on those values */


            state.lenbits = 9;
            opts = {
              bits: state.lenbits
            };
            ret = inftrees(LENS, state.lens, 0, state.nlen, state.lencode, 0, state.work, opts); // We have separate tables & no pointers. 2 commented lines below not needed.
            // state.next_index = opts.table_index;

            state.lenbits = opts.bits; // state.lencode = state.next;

            if (ret) {
              strm.msg = 'invalid literal/lengths set';
              state.mode = BAD;
              break;
            }

            state.distbits = 6; //state.distcode.copy(state.codes);
            // Switch to use dynamic table

            state.distcode = state.distdyn;
            opts = {
              bits: state.distbits
            };
            ret = inftrees(DISTS, state.lens, state.nlen, state.ndist, state.distcode, 0, state.work, opts); // We have separate tables & no pointers. 2 commented lines below not needed.
            // state.next_index = opts.table_index;

            state.distbits = opts.bits; // state.distcode = state.next;

            if (ret) {
              strm.msg = 'invalid distances set';
              state.mode = BAD;
              break;
            } //Tracev((stderr, 'inflate:       codes ok\n'));


            state.mode = LEN_;

            if (flush === Z_TREES) {
              break inf_leave;
            }

          /* falls through */

          case LEN_:
            state.mode = LEN;

          /* falls through */

          case LEN:
            if (have >= 6 && left >= 258) {
              //--- RESTORE() ---
              strm.next_out = put;
              strm.avail_out = left;
              strm.next_in = next;
              strm.avail_in = have;
              state.hold = hold;
              state.bits = bits; //---

              inffast(strm, _out); //--- LOAD() ---

              put = strm.next_out;
              output = strm.output;
              left = strm.avail_out;
              next = strm.next_in;
              input = strm.input;
              have = strm.avail_in;
              hold = state.hold;
              bits = state.bits; //---

              if (state.mode === TYPE) {
                state.back = -1;
              }

              break;
            }

            state.back = 0;

            for (;;) {
              here = state.lencode[hold & (1 << state.lenbits) - 1];
              /*BITS(state.lenbits)*/

              here_bits = here >>> 24;
              here_op = here >>> 16 & 0xff;
              here_val = here & 0xffff;

              if (here_bits <= bits) {
                break;
              } //--- PULLBYTE() ---//


              if (have === 0) {
                break inf_leave;
              }

              have--;
              hold += input[next++] << bits;
              bits += 8; //---//
            }

            if (here_op && (here_op & 0xf0) === 0) {
              last_bits = here_bits;
              last_op = here_op;
              last_val = here_val;

              for (;;) {
                here = state.lencode[last_val + ((hold & (1 << last_bits + last_op) - 1
                /*BITS(last.bits + last.op)*/
                ) >> last_bits)];
                here_bits = here >>> 24;
                here_op = here >>> 16 & 0xff;
                here_val = here & 0xffff;

                if (last_bits + here_bits <= bits) {
                  break;
                } //--- PULLBYTE() ---//


                if (have === 0) {
                  break inf_leave;
                }

                have--;
                hold += input[next++] << bits;
                bits += 8; //---//
              } //--- DROPBITS(last.bits) ---//


              hold >>>= last_bits;
              bits -= last_bits; //---//

              state.back += last_bits;
            } //--- DROPBITS(here.bits) ---//


            hold >>>= here_bits;
            bits -= here_bits; //---//

            state.back += here_bits;
            state.length = here_val;

            if (here_op === 0) {
              //Tracevv((stderr, here.val >= 0x20 && here.val < 0x7f ?
              //        "inflate:         literal '%c'\n" :
              //        "inflate:         literal 0x%02x\n", here.val));
              state.mode = LIT;
              break;
            }

            if (here_op & 32) {
              //Tracevv((stderr, "inflate:         end of block\n"));
              state.back = -1;
              state.mode = TYPE;
              break;
            }

            if (here_op & 64) {
              strm.msg = 'invalid literal/length code';
              state.mode = BAD;
              break;
            }

            state.extra = here_op & 15;
            state.mode = LENEXT;

          /* falls through */

          case LENEXT:
            if (state.extra) {
              //=== NEEDBITS(state.extra);
              n = state.extra;

              while (bits < n) {
                if (have === 0) {
                  break inf_leave;
                }

                have--;
                hold += input[next++] << bits;
                bits += 8;
              } //===//


              state.length += hold & (1 << state.extra) - 1
              /*BITS(state.extra)*/
              ; //--- DROPBITS(state.extra) ---//

              hold >>>= state.extra;
              bits -= state.extra; //---//

              state.back += state.extra;
            } //Tracevv((stderr, "inflate:         length %u\n", state.length));


            state.was = state.length;
            state.mode = DIST;

          /* falls through */

          case DIST:
            for (;;) {
              here = state.distcode[hold & (1 << state.distbits) - 1];
              /*BITS(state.distbits)*/

              here_bits = here >>> 24;
              here_op = here >>> 16 & 0xff;
              here_val = here & 0xffff;

              if (here_bits <= bits) {
                break;
              } //--- PULLBYTE() ---//


              if (have === 0) {
                break inf_leave;
              }

              have--;
              hold += input[next++] << bits;
              bits += 8; //---//
            }

            if ((here_op & 0xf0) === 0) {
              last_bits = here_bits;
              last_op = here_op;
              last_val = here_val;

              for (;;) {
                here = state.distcode[last_val + ((hold & (1 << last_bits + last_op) - 1
                /*BITS(last.bits + last.op)*/
                ) >> last_bits)];
                here_bits = here >>> 24;
                here_op = here >>> 16 & 0xff;
                here_val = here & 0xffff;

                if (last_bits + here_bits <= bits) {
                  break;
                } //--- PULLBYTE() ---//


                if (have === 0) {
                  break inf_leave;
                }

                have--;
                hold += input[next++] << bits;
                bits += 8; //---//
              } //--- DROPBITS(last.bits) ---//


              hold >>>= last_bits;
              bits -= last_bits; //---//

              state.back += last_bits;
            } //--- DROPBITS(here.bits) ---//


            hold >>>= here_bits;
            bits -= here_bits; //---//

            state.back += here_bits;

            if (here_op & 64) {
              strm.msg = 'invalid distance code';
              state.mode = BAD;
              break;
            }

            state.offset = here_val;
            state.extra = here_op & 15;
            state.mode = DISTEXT;

          /* falls through */

          case DISTEXT:
            if (state.extra) {
              //=== NEEDBITS(state.extra);
              n = state.extra;

              while (bits < n) {
                if (have === 0) {
                  break inf_leave;
                }

                have--;
                hold += input[next++] << bits;
                bits += 8;
              } //===//


              state.offset += hold & (1 << state.extra) - 1
              /*BITS(state.extra)*/
              ; //--- DROPBITS(state.extra) ---//

              hold >>>= state.extra;
              bits -= state.extra; //---//

              state.back += state.extra;
            } //#ifdef INFLATE_STRICT


            if (state.offset > state.dmax) {
              strm.msg = 'invalid distance too far back';
              state.mode = BAD;
              break;
            } //#endif
            //Tracevv((stderr, "inflate:         distance %u\n", state.offset));


            state.mode = MATCH;

          /* falls through */

          case MATCH:
            if (left === 0) {
              break inf_leave;
            }

            copy = _out - left;

            if (state.offset > copy) {
              /* copy from window */
              copy = state.offset - copy;

              if (copy > state.whave) {
                if (state.sane) {
                  strm.msg = 'invalid distance too far back';
                  state.mode = BAD;
                  break;
                } // (!) This block is disabled in zlib defaults,
                // don't enable it for binary compatibility
                //#ifdef INFLATE_ALLOW_INVALID_DISTANCE_TOOFAR_ARRR
                //          Trace((stderr, "inflate.c too far\n"));
                //          copy -= state.whave;
                //          if (copy > state.length) { copy = state.length; }
                //          if (copy > left) { copy = left; }
                //          left -= copy;
                //          state.length -= copy;
                //          do {
                //            output[put++] = 0;
                //          } while (--copy);
                //          if (state.length === 0) { state.mode = LEN; }
                //          break;
                //#endif

              }

              if (copy > state.wnext) {
                copy -= state.wnext;
                from = state.wsize - copy;
              } else {
                from = state.wnext - copy;
              }

              if (copy > state.length) {
                copy = state.length;
              }

              from_source = state.window;
            } else {
              /* copy from output */
              from_source = output;
              from = put - state.offset;
              copy = state.length;
            }

            if (copy > left) {
              copy = left;
            }

            left -= copy;
            state.length -= copy;

            do {
              output[put++] = from_source[from++];
            } while (--copy);

            if (state.length === 0) {
              state.mode = LEN;
            }

            break;

          case LIT:
            if (left === 0) {
              break inf_leave;
            }

            output[put++] = state.length;
            left--;
            state.mode = LEN;
            break;

          case CHECK:
            if (state.wrap) {
              //=== NEEDBITS(32);
              while (bits < 32) {
                if (have === 0) {
                  break inf_leave;
                }

                have--; // Use '|' instead of '+' to make sure that result is signed

                hold |= input[next++] << bits;
                bits += 8;
              } //===//


              _out -= left;
              strm.total_out += _out;
              state.total += _out;

              if (_out) {
                strm.adler = state.check =
                /*UPDATE(state.check, put - _out, _out);*/
                state.flags ? crc32_1(state.check, output, _out, put - _out) : adler32_1(state.check, output, _out, put - _out);
              }

              _out = left; // NB: crc32 stored as signed 32-bit int, zswap32 returns signed too

              if ((state.flags ? hold : zswap32(hold)) !== state.check) {
                strm.msg = 'incorrect data check';
                state.mode = BAD;
                break;
              } //=== INITBITS();


              hold = 0;
              bits = 0; //===//
              //Tracev((stderr, "inflate:   check matches trailer\n"));
            }

            state.mode = LENGTH;

          /* falls through */

          case LENGTH:
            if (state.wrap && state.flags) {
              //=== NEEDBITS(32);
              while (bits < 32) {
                if (have === 0) {
                  break inf_leave;
                }

                have--;
                hold += input[next++] << bits;
                bits += 8;
              } //===//


              if (hold !== (state.total & 0xffffffff)) {
                strm.msg = 'incorrect length check';
                state.mode = BAD;
                break;
              } //=== INITBITS();


              hold = 0;
              bits = 0; //===//
              //Tracev((stderr, "inflate:   length matches trailer\n"));
            }

            state.mode = DONE;

          /* falls through */

          case DONE:
            ret = Z_STREAM_END$1;
            break inf_leave;

          case BAD:
            ret = Z_DATA_ERROR$1;
            break inf_leave;

          case MEM:
            return Z_MEM_ERROR$1;

          case SYNC:
          /* falls through */

          default:
            return Z_STREAM_ERROR$1;
        }
      } // inf_leave <- here is real place for "goto inf_leave", emulated via "break inf_leave"

      /*
         Return from inflate(), updating the total counts and the check value.
         If there was no progress during the inflate() call, return a buffer
         error.  Call updatewindow() to create and/or update the window state.
         Note: a memory error from inflate() is non-recoverable.
       */
      //--- RESTORE() ---


      strm.next_out = put;
      strm.avail_out = left;
      strm.next_in = next;
      strm.avail_in = have;
      state.hold = hold;
      state.bits = bits; //---

      if (state.wsize || _out !== strm.avail_out && state.mode < BAD && (state.mode < CHECK || flush !== Z_FINISH$1)) {
        if (updatewindow(strm, strm.output, strm.next_out, _out - strm.avail_out)) ;
      }

      _in -= strm.avail_in;
      _out -= strm.avail_out;
      strm.total_in += _in;
      strm.total_out += _out;
      state.total += _out;

      if (state.wrap && _out) {
        strm.adler = state.check =
        /*UPDATE(state.check, strm.next_out - _out, _out);*/
        state.flags ? crc32_1(state.check, output, _out, strm.next_out - _out) : adler32_1(state.check, output, _out, strm.next_out - _out);
      }

      strm.data_type = state.bits + (state.last ? 64 : 0) + (state.mode === TYPE ? 128 : 0) + (state.mode === LEN_ || state.mode === COPY_ ? 256 : 0);

      if ((_in === 0 && _out === 0 || flush === Z_FINISH$1) && ret === Z_OK$1) {
        ret = Z_BUF_ERROR;
      }

      return ret;
    };

    const inflateEnd = strm => {
      if (!strm || !strm.state
      /*|| strm->zfree == (free_func)0*/
      ) {
        return Z_STREAM_ERROR$1;
      }

      let state = strm.state;

      if (state.window) {
        state.window = null;
      }

      strm.state = null;
      return Z_OK$1;
    };

    const inflateGetHeader = (strm, head) => {
      /* check state */
      if (!strm || !strm.state) {
        return Z_STREAM_ERROR$1;
      }

      const state = strm.state;

      if ((state.wrap & 2) === 0) {
        return Z_STREAM_ERROR$1;
      }
      /* save header structure */


      state.head = head;
      head.done = false;
      return Z_OK$1;
    };

    const inflateSetDictionary = (strm, dictionary) => {
      const dictLength = dictionary.length;
      let state;
      let dictid;
      let ret;
      /* check state */

      if (!strm
      /* == Z_NULL */
      || !strm.state
      /* == Z_NULL */
      ) {
        return Z_STREAM_ERROR$1;
      }

      state = strm.state;

      if (state.wrap !== 0 && state.mode !== DICT) {
        return Z_STREAM_ERROR$1;
      }
      /* check for correct dictionary identifier */


      if (state.mode === DICT) {
        dictid = 1;
        /* adler32(0, null, 0)*/

        /* dictid = adler32(dictid, dictionary, dictLength); */

        dictid = adler32_1(dictid, dictionary, dictLength, 0);

        if (dictid !== state.check) {
          return Z_DATA_ERROR$1;
        }
      }
      /* copy dictionary to window using updatewindow(), which will amend the
       existing dictionary if appropriate */


      ret = updatewindow(strm, dictionary, dictLength, dictLength);

      if (ret) {
        state.mode = MEM;
        return Z_MEM_ERROR$1;
      }

      state.havedict = 1; // Tracev((stderr, "inflate:   dictionary set\n"));

      return Z_OK$1;
    };

    var inflateReset_1 = inflateReset;
    var inflateReset2_1 = inflateReset2;
    var inflateResetKeep_1 = inflateResetKeep;
    var inflateInit_1 = inflateInit;
    var inflateInit2_1 = inflateInit2;
    var inflate_2$1 = inflate$2;
    var inflateEnd_1 = inflateEnd;
    var inflateGetHeader_1 = inflateGetHeader;
    var inflateSetDictionary_1 = inflateSetDictionary;
    var inflateInfo = 'pako inflate (from Nodeca project)';
    /* Not implemented
    module.exports.inflateCopy = inflateCopy;
    module.exports.inflateGetDictionary = inflateGetDictionary;
    module.exports.inflateMark = inflateMark;
    module.exports.inflatePrime = inflatePrime;
    module.exports.inflateSync = inflateSync;
    module.exports.inflateSyncPoint = inflateSyncPoint;
    module.exports.inflateUndermine = inflateUndermine;
    */

    var inflate_1$2 = {
      inflateReset: inflateReset_1,
      inflateReset2: inflateReset2_1,
      inflateResetKeep: inflateResetKeep_1,
      inflateInit: inflateInit_1,
      inflateInit2: inflateInit2_1,
      inflate: inflate_2$1,
      inflateEnd: inflateEnd_1,
      inflateGetHeader: inflateGetHeader_1,
      inflateSetDictionary: inflateSetDictionary_1,
      inflateInfo: inflateInfo
    }; // (C) 1995-2013 Jean-loup Gailly and Mark Adler
    // (C) 2014-2017 Vitaly Puzrin and Andrey Tupitsin
    //
    // This software is provided 'as-is', without any express or implied
    // warranty. In no event will the authors be held liable for any damages
    // arising from the use of this software.
    //
    // Permission is granted to anyone to use this software for any purpose,
    // including commercial applications, and to alter it and redistribute it
    // freely, subject to the following restrictions:
    //
    // 1. The origin of this software must not be misrepresented; you must not
    //   claim that you wrote the original software. If you use this software
    //   in a product, an acknowledgment in the product documentation would be
    //   appreciated but is not required.
    // 2. Altered source versions must be plainly marked as such, and must not be
    //   misrepresented as being the original software.
    // 3. This notice may not be removed or altered from any source distribution.

    function GZheader() {
      /* true if compressed data believed to be text */
      this.text = 0;
      /* modification time */

      this.time = 0;
      /* extra flags (not used when writing a gzip file) */

      this.xflags = 0;
      /* operating system */

      this.os = 0;
      /* pointer to extra field or Z_NULL if none */

      this.extra = null;
      /* extra field length (valid if extra != Z_NULL) */

      this.extra_len = 0; // Actually, we don't need it in JS,
      // but leave for few code modifications
      //
      // Setup limits is not necessary because in js we should not preallocate memory
      // for inflate use constant limit in 65536 bytes
      //

      /* space at extra (only when reading header) */
      // this.extra_max  = 0;

      /* pointer to zero-terminated file name or Z_NULL */

      this.name = '';
      /* space at name (only when reading header) */
      // this.name_max   = 0;

      /* pointer to zero-terminated comment or Z_NULL */

      this.comment = '';
      /* space at comment (only when reading header) */
      // this.comm_max   = 0;

      /* true if there was or will be a header crc */

      this.hcrc = 0;
      /* true when done reading gzip header (not used when writing a gzip file) */

      this.done = false;
    }

    var gzheader = GZheader;
    const toString$2 = Object.prototype.toString;
    /* Public constants ==========================================================*/

    /* ===========================================================================*/

    const {
      Z_NO_FLUSH,
      Z_FINISH,
      Z_OK,
      Z_STREAM_END,
      Z_NEED_DICT,
      Z_STREAM_ERROR,
      Z_DATA_ERROR,
      Z_MEM_ERROR
    } = constants$2;
    /* ===========================================================================*/

    /**
     * class Inflate
     *
     * Generic JS-style wrapper for zlib calls. If you don't need
     * streaming behaviour - use more simple functions: [[inflate]]
     * and [[inflateRaw]].
     **/

    /* internal
     * inflate.chunks -> Array
     *
     * Chunks of output data, if [[Inflate#onData]] not overridden.
     **/

    /**
     * Inflate.result -> Uint8Array|String
     *
     * Uncompressed result, generated by default [[Inflate#onData]]
     * and [[Inflate#onEnd]] handlers. Filled after you push last chunk
     * (call [[Inflate#push]] with `Z_FINISH` / `true` param).
     **/

    /**
     * Inflate.err -> Number
     *
     * Error code after inflate finished. 0 (Z_OK) on success.
     * Should be checked if broken data possible.
     **/

    /**
     * Inflate.msg -> String
     *
     * Error message, if [[Inflate.err]] != 0
     **/

    /**
     * new Inflate(options)
     * - options (Object): zlib inflate options.
     *
     * Creates new inflator instance with specified params. Throws exception
     * on bad params. Supported options:
     *
     * - `windowBits`
     * - `dictionary`
     *
     * [http://zlib.net/manual.html#Advanced](http://zlib.net/manual.html#Advanced)
     * for more information on these.
     *
     * Additional options, for internal needs:
     *
     * - `chunkSize` - size of generated data chunks (16K by default)
     * - `raw` (Boolean) - do raw inflate
     * - `to` (String) - if equal to 'string', then result will be converted
     *   from utf8 to utf16 (javascript) string. When string output requested,
     *   chunk length can differ from `chunkSize`, depending on content.
     *
     * By default, when no options set, autodetect deflate/gzip data format via
     * wrapper header.
     *
     * ##### Example:
     *
     * ```javascript
     * const pako = require('pako')
     * const chunk1 = new Uint8Array([1,2,3,4,5,6,7,8,9])
     * const chunk2 = new Uint8Array([10,11,12,13,14,15,16,17,18,19]);
     *
     * const inflate = new pako.Inflate({ level: 3});
     *
     * inflate.push(chunk1, false);
     * inflate.push(chunk2, true);  // true -> last chunk
     *
     * if (inflate.err) { throw new Error(inflate.err); }
     *
     * console.log(inflate.result);
     * ```
     **/

    function Inflate$1(options) {
      this.options = common.assign({
        chunkSize: 1024 * 64,
        windowBits: 15,
        to: ''
      }, options || {});
      const opt = this.options; // Force window size for `raw` data, if not set directly,
      // because we have no header for autodetect.

      if (opt.raw && opt.windowBits >= 0 && opt.windowBits < 16) {
        opt.windowBits = -opt.windowBits;

        if (opt.windowBits === 0) {
          opt.windowBits = -15;
        }
      } // If `windowBits` not defined (and mode not raw) - set autodetect flag for gzip/deflate


      if (opt.windowBits >= 0 && opt.windowBits < 16 && !(options && options.windowBits)) {
        opt.windowBits += 32;
      } // Gzip header has no info about windows size, we can do autodetect only
      // for deflate. So, if window size not set, force it to max when gzip possible


      if (opt.windowBits > 15 && opt.windowBits < 48) {
        // bit 3 (16) -> gzipped data
        // bit 4 (32) -> autodetect gzip/deflate
        if ((opt.windowBits & 15) === 0) {
          opt.windowBits |= 15;
        }
      }

      this.err = 0; // error code, if happens (0 = Z_OK)

      this.msg = ''; // error message

      this.ended = false; // used to avoid multiple onEnd() calls

      this.chunks = []; // chunks of compressed data

      this.strm = new zstream();
      this.strm.avail_out = 0;
      let status = inflate_1$2.inflateInit2(this.strm, opt.windowBits);

      if (status !== Z_OK) {
        throw new Error(messages[status]);
      }

      this.header = new gzheader();
      inflate_1$2.inflateGetHeader(this.strm, this.header); // Setup dictionary

      if (opt.dictionary) {
        // Convert data if needed
        if (typeof opt.dictionary === 'string') {
          opt.dictionary = strings.string2buf(opt.dictionary);
        } else if (toString$2.call(opt.dictionary) === '[object ArrayBuffer]') {
          opt.dictionary = new Uint8Array(opt.dictionary);
        }

        if (opt.raw) {
          //In raw mode we need to set the dictionary early
          status = inflate_1$2.inflateSetDictionary(this.strm, opt.dictionary);

          if (status !== Z_OK) {
            throw new Error(messages[status]);
          }
        }
      }
    }
    /**
     * Inflate#push(data[, flush_mode]) -> Boolean
     * - data (Uint8Array|ArrayBuffer): input data
     * - flush_mode (Number|Boolean): 0..6 for corresponding Z_NO_FLUSH..Z_TREE
     *   flush modes. See constants. Skipped or `false` means Z_NO_FLUSH,
     *   `true` means Z_FINISH.
     *
     * Sends input data to inflate pipe, generating [[Inflate#onData]] calls with
     * new output chunks. Returns `true` on success. If end of stream detected,
     * [[Inflate#onEnd]] will be called.
     *
     * `flush_mode` is not needed for normal operation, because end of stream
     * detected automatically. You may try to use it for advanced things, but
     * this functionality was not tested.
     *
     * On fail call [[Inflate#onEnd]] with error code and return false.
     *
     * ##### Example
     *
     * ```javascript
     * push(chunk, false); // push one of data chunks
     * ...
     * push(chunk, true);  // push last chunk
     * ```
     **/


    Inflate$1.prototype.push = function (data, flush_mode) {
      const strm = this.strm;
      const chunkSize = this.options.chunkSize;
      const dictionary = this.options.dictionary;

      let status, _flush_mode, last_avail_out;

      if (this.ended) return false;
      if (flush_mode === ~~flush_mode) _flush_mode = flush_mode;else _flush_mode = flush_mode === true ? Z_FINISH : Z_NO_FLUSH; // Convert data if needed

      if (toString$2.call(data) === '[object ArrayBuffer]') {
        strm.input = new Uint8Array(data);
      } else {
        strm.input = data;
      }

      strm.next_in = 0;
      strm.avail_in = strm.input.length;

      for (;;) {
        if (strm.avail_out === 0) {
          strm.output = new Uint8Array(chunkSize);
          strm.next_out = 0;
          strm.avail_out = chunkSize;
        }

        status = inflate_1$2.inflate(strm, _flush_mode);

        if (status === Z_NEED_DICT && dictionary) {
          status = inflate_1$2.inflateSetDictionary(strm, dictionary);

          if (status === Z_OK) {
            status = inflate_1$2.inflate(strm, _flush_mode);
          } else if (status === Z_DATA_ERROR) {
            // Replace code with more verbose
            status = Z_NEED_DICT;
          }
        } // Skip snyc markers if more data follows and not raw mode


        while (strm.avail_in > 0 && status === Z_STREAM_END && strm.state.wrap > 0 && data[strm.next_in] !== 0) {
          inflate_1$2.inflateReset(strm);
          status = inflate_1$2.inflate(strm, _flush_mode);
        }

        switch (status) {
          case Z_STREAM_ERROR:
          case Z_DATA_ERROR:
          case Z_NEED_DICT:
          case Z_MEM_ERROR:
            this.onEnd(status);
            this.ended = true;
            return false;
        } // Remember real `avail_out` value, because we may patch out buffer content
        // to align utf8 strings boundaries.


        last_avail_out = strm.avail_out;

        if (strm.next_out) {
          if (strm.avail_out === 0 || status === Z_STREAM_END) {
            if (this.options.to === 'string') {
              let next_out_utf8 = strings.utf8border(strm.output, strm.next_out);
              let tail = strm.next_out - next_out_utf8;
              let utf8str = strings.buf2string(strm.output, next_out_utf8); // move tail & realign counters

              strm.next_out = tail;
              strm.avail_out = chunkSize - tail;
              if (tail) strm.output.set(strm.output.subarray(next_out_utf8, next_out_utf8 + tail), 0);
              this.onData(utf8str);
            } else {
              this.onData(strm.output.length === strm.next_out ? strm.output : strm.output.subarray(0, strm.next_out));
            }
          }
        } // Must repeat iteration if out buffer is full


        if (status === Z_OK && last_avail_out === 0) continue; // Finalize if end of stream reached.

        if (status === Z_STREAM_END) {
          status = inflate_1$2.inflateEnd(this.strm);
          this.onEnd(status);
          this.ended = true;
          return true;
        }

        if (strm.avail_in === 0) break;
      }

      return true;
    };
    /**
     * Inflate#onData(chunk) -> Void
     * - chunk (Uint8Array|String): output data. When string output requested,
     *   each chunk will be string.
     *
     * By default, stores data blocks in `chunks[]` property and glue
     * those in `onEnd`. Override this handler, if you need another behaviour.
     **/


    Inflate$1.prototype.onData = function (chunk) {
      this.chunks.push(chunk);
    };
    /**
     * Inflate#onEnd(status) -> Void
     * - status (Number): inflate status. 0 (Z_OK) on success,
     *   other if not.
     *
     * Called either after you tell inflate that the input stream is
     * complete (Z_FINISH). By default - join collected chunks,
     * free memory and fill `results` / `err` properties.
     **/


    Inflate$1.prototype.onEnd = function (status) {
      // On success - join
      if (status === Z_OK) {
        if (this.options.to === 'string') {
          this.result = this.chunks.join('');
        } else {
          this.result = common.flattenChunks(this.chunks);
        }
      }

      this.chunks = [];
      this.err = status;
      this.msg = this.strm.msg;
    };
    /**
     * inflate(data[, options]) -> Uint8Array|String
     * - data (Uint8Array): input data to decompress.
     * - options (Object): zlib inflate options.
     *
     * Decompress `data` with inflate/ungzip and `options`. Autodetect
     * format via wrapper header by default. That's why we don't provide
     * separate `ungzip` method.
     *
     * Supported options are:
     *
     * - windowBits
     *
     * [http://zlib.net/manual.html#Advanced](http://zlib.net/manual.html#Advanced)
     * for more information.
     *
     * Sugar (options):
     *
     * - `raw` (Boolean) - say that we work with raw stream, if you don't wish to specify
     *   negative windowBits implicitly.
     * - `to` (String) - if equal to 'string', then result will be converted
     *   from utf8 to utf16 (javascript) string. When string output requested,
     *   chunk length can differ from `chunkSize`, depending on content.
     *
     *
     * ##### Example:
     *
     * ```javascript
     * const pako = require('pako');
     * const input = pako.deflate(new Uint8Array([1,2,3,4,5,6,7,8,9]));
     * let output;
     *
     * try {
     *   output = pako.inflate(input);
     * } catch (err) {
     *   console.log(err);
     * }
     * ```
     **/


    function inflate$1(input, options) {
      const inflator = new Inflate$1(options);
      inflator.push(input); // That will never happens, if you don't cheat with options :)

      if (inflator.err) throw inflator.msg || messages[inflator.err];
      return inflator.result;
    }
    /**
     * inflateRaw(data[, options]) -> Uint8Array|String
     * - data (Uint8Array): input data to decompress.
     * - options (Object): zlib inflate options.
     *
     * The same as [[inflate]], but creates raw data, without wrapper
     * (header and adler32 crc).
     **/


    function inflateRaw$1(input, options) {
      options = options || {};
      options.raw = true;
      return inflate$1(input, options);
    }
    /**
     * ungzip(data[, options]) -> Uint8Array|String
     * - data (Uint8Array): input data to decompress.
     * - options (Object): zlib inflate options.
     *
     * Just shortcut to [[inflate]], because it autodetects format
     * by header.content. Done for convenience.
     **/


    var Inflate_1$1 = Inflate$1;
    var inflate_2 = inflate$1;
    var inflateRaw_1$1 = inflateRaw$1;
    var ungzip$1 = inflate$1;
    var constants = constants$2;
    var inflate_1$1 = {
      Inflate: Inflate_1$1,
      inflate: inflate_2,
      inflateRaw: inflateRaw_1$1,
      ungzip: ungzip$1,
      constants: constants
    };
    const {
      Deflate,
      deflate,
      deflateRaw,
      gzip
    } = deflate_1$1;
    const {
      Inflate,
      inflate: inflate$3,
      inflateRaw,
      ungzip: ungzip$2
    } = inflate_1$1;
    var Deflate_1 = Deflate;
    var deflate_1 = deflate;
    var deflateRaw_1 = deflateRaw;
    var gzip_1 = gzip;
    var Inflate_1 = Inflate;
    var inflate_1 = inflate$3;
    var inflateRaw_1 = inflateRaw;
    var ungzip_1 = ungzip$2;
    var constants_1 = constants$2;
    var pako = {
      Deflate: Deflate_1,
      deflate: deflate_1,
      deflateRaw: deflateRaw_1,
      gzip: gzip_1,
      Inflate: Inflate_1,
      inflate: inflate_1,
      inflateRaw: inflateRaw_1,
      ungzip: ungzip_1,
      constants: constants_1
    }; // Added by JTR
    // exports.Deflate = Deflate_1;
    // exports.Inflate = Inflate_1;
    // exports.constants = constants_1;
    // exports['default'] = pako;
    // exports.deflate = deflate_1;
    // exports.deflateRaw = deflateRaw_1;
    // exports.gzip = gzip_1;
    // exports.inflate = inflate_1;
    // exports.inflateRaw = inflateRaw_1;
    // exports.ungzip = ungzip_1;
    //   Object.defineProperty(exports, '__esModule', { value: true });
    //
    // })));

    pako.deflateRaw;
    pako.deflate;
    pako.inflateRaw;
    const inflate = pako.inflate;
    pako.gzip;
    const FEXTRA = 4; // gzip spec F.EXTRA flag

    function isgzipped(data) {
      const b = ArrayBuffer.isView(data) ? data : new Uint8Array(data);
      return b[0] === 31 && b[1] === 139;
    }
    /**
     * Pako does not properly ungzip block compressed files if > 1 block is present.  Test for bgzip and use wrapper.
     */


    function ungzip(data) {
      const ba = ArrayBuffer.isView(data) ? data : new Uint8Array(data);
      const b = ba[3] & FEXTRA;

      if (b !== 0 && ba[12] === 66 && ba[13] === 67) {
        return unbgzf(ba.buffer);
      } else {
        return pako.ungzip(ba);
      }
    } // Uncompress data,  assumed to be series of bgzipped blocks


    function unbgzf(data, lim) {
      const oBlockList = [];
      let ptr = 0;
      let totalSize = 0;
      lim = lim || data.byteLength - 18;

      while (ptr < lim) {
        try {
          const ba = ArrayBuffer.isView(data) ? data : new Uint8Array(data, ptr, 18);
          const xlen = ba[11] << 8 | ba[10];
          const flg = ba[3];
          const fextra = flg & FEXTRA;
          const si1 = ba[12];
          const si2 = ba[13];
          const slen = ba[15] << 8 | ba[14];
          const bsize = (ba[17] << 8 | ba[16]) + 1;
          const start = 12 + xlen + ptr; // Start of CDATA

          const bytesLeft = data.byteLength - start;
          const cDataSize = bsize - xlen - 19;
          if (bytesLeft < cDataSize || cDataSize <= 0) break;
          const a = new Uint8Array(data, start, cDataSize);
          const unc = pako.inflateRaw(a); // const inflate = new Zlib.RawInflate(a);
          // const unc = inflate.decompress();

          ptr += cDataSize - 1 + 26; //inflate.ip + 26

          totalSize += unc.byteLength;
          oBlockList.push(unc);
        } catch (e) {
          console.error(e);
          break;
        }
      } // Concatenate decompressed blocks


      if (oBlockList.length === 1) {
        return oBlockList[0];
      } else {
        const out = new Uint8Array(totalSize);
        let cursor = 0;

        for (let i = 0; i < oBlockList.length; ++i) {
          var b = new Uint8Array(oBlockList[i]);
          arrayCopy(b, 0, out, cursor, b.length);
          cursor += b.length;
        }

        return out;
      }
    }

    function bgzBlockSize(data) {
      const ba = ArrayBuffer.isView(data) ? data : new Uint8Array(data);
      const bsize = (ba[17] << 8 | ba[16]) + 1;
      return bsize;
    } // From Thomas Down's zlib implementation


    const testArray = new Uint8Array(1);
    const hasSubarray = typeof testArray.subarray === 'function';
    /* (typeof testArray.slice === 'function'); */
    // Chrome slice performance is so dire that we're currently not using it...

    function arrayCopy(src, srcOffset, dest, destOffset, count) {
      if (count === 0) {
        return;
      }

      if (!src) {
        throw "Undef src";
      } else if (!dest) {
        throw "Undef dest";
      }

      if (srcOffset === 0 && count === src.length) {
        arrayCopy_fast(src, dest, destOffset);
      } else if (hasSubarray) {
        arrayCopy_fast(src.subarray(srcOffset, srcOffset + count), dest, destOffset);
      } else if (src.BYTES_PER_ELEMENT === 1 && count > 100) {
        arrayCopy_fast(new Uint8Array(src.buffer, src.byteOffset + srcOffset, count), dest, destOffset);
      } else {
        arrayCopy_slow(src, srcOffset, dest, destOffset, count);
      }
    }

    function arrayCopy_slow(src, srcOffset, dest, destOffset, count) {
      for (let i = 0; i < count; ++i) {
        dest[destOffset + i] = src[srcOffset + i];
      }
    }

    function arrayCopy_fast(src, dest, destOffset) {
      dest.set(src, destOffset);
    }
    /**
     * Compress string and encode in a url safe form
     * @param s
     */


    function compressString(str) {
      const bytes = new Uint8Array(str.length);

      for (var i = 0; i < str.length; i++) {
        bytes[i] = str.charCodeAt(i);
      }

      const compressedBytes = new pako.deflateRaw(bytes); // UInt8Arry

      const compressedString = String.fromCharCode.apply(null, compressedBytes); // Convert to string

      let enc = btoa(compressedString);
      return enc.replace(/\+/g, '.').replace(/\//g, '_').replace(/=/g, '-'); // URL safe
    }
    /**
     * Uncompress the url-safe encoded compressed string, presumably created by compressString above
     *
     * @param enc
     * @returns {string}
     */


    function uncompressString(enc) {
      enc = enc.replace(/\./g, '+').replace(/_/g, '/').replace(/-/g, '=');
      const compressedString = atob(enc);
      const compressedBytes = [];

      for (let i = 0; i < compressedString.length; i++) {
        compressedBytes.push(compressedString.charCodeAt(i));
      } //const bytes = new Zlib.RawInflate(compressedBytes).decompress();


      const bytes = pako.inflateRaw(compressedBytes);
      let str = '';

      for (let b of bytes) {
        str += String.fromCharCode(b);
      }

      return str;
    }
    /**
     * @param dataURI
     * @returns {Array<number>|Uint8Array}
     */


    function decodeDataURI$1(dataURI, gzip) {
      const split = dataURI.split(',');
      const info = split[0].split(':')[1];
      let dataString = split[1];

      if (info.indexOf('base64') >= 0) {
        dataString = atob(dataString);
        const bytes = new Uint8Array(dataString.length);

        for (let i = 0; i < dataString.length; i++) {
          bytes[i] = dataString.charCodeAt(i);
        }

        let plain;

        if (gzip || info.indexOf('gzip') > 0) {
          plain = pako.ungzip(bytes);
        } else {
          plain = bytes;
        }

        return plain;
      } else {
        return decodeURIComponent(dataString); // URL encoded string -- not currently used or tested
      }
    }

    /*
     * The MIT License (MIT)
     *
     * Copyright (c) 2016-2017 The Regents of the University of California
     * Author: Jim Robinson
     *
     * Permission is hereby granted, free of charge, to any person obtaining a copy
     * of this software and associated documentation files (the "Software"), to deal
     * in the Software without restriction, including without limitation the rights
     * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
     * copies of the Software, and to permit persons to whom the Software is
     * furnished to do so, subject to the following conditions:
     *
     * The above copyright notice and this permission notice shall be included in
     * all copies or substantial portions of the Software.
     *
     *
     * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
     * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
     * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
     * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
     * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
     * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
     * THE SOFTWARE.
     */
    const IGVMath = {
      lerp: (v0, v1, t) => {
        return (1 - t) * v0 + t * v1;
      },
      mean: function (array) {
        var t = 0,
            n = 0,
            i;

        for (i = 0; i < array.length; i++) {
          if (!isNaN(array[i])) {
            t += array[i];
            n++;
          }
        }

        return n > 0 ? t / n : 0;
      },
      meanAndStdev: function (array) {
        var v,
            t = 0,
            t2 = 0,
            n = 0,
            i;

        for (i = 0; i < array.length; i++) {
          v = array[i];

          if (!isNaN(v)) {
            t += v;
            t2 += v * v;
            n++;
          }
        }

        return n > 0 ? {
          mean: t / n,
          stdev: Math.sqrt(t2 - t * t / n)
        } : {
          mean: 0,
          stdev: 0
        };
      },
      median: function (numbers) {
        // median of [3, 5, 4, 4, 1, 1, 2, 3] = 3
        var median = 0,
            numsLen = numbers.length;
        numbers.sort();

        if (numsLen % 2 === 0 // is even
        ) {
          // average of two middle numbers
          median = (numbers[numsLen / 2 - 1] + numbers[numsLen / 2]) / 2;
        } else {
          // is odd
          // middle number only
          median = numbers[(numsLen - 1) / 2];
        }

        return median;
      },
      // Fast percentile function for "p" near edges.  This needs profiled for p in middle (e.g. median)
      percentile: function (array, p) {
        if (array.length === 0) return undefined;
        var k = Math.floor(array.length * ((100 - p) / 100));

        if (k === 0) {
          array.sort(function (a, b) {
            return b - a;
          });
          return array[k];
        } else {
          return selectElement(array, k);
        }
      },
      clamp: function (value, min, max) {
        return Math.min(Math.max(value, min), max);
      },
      log2: function (x) {
        return Math.log(x) / Math.LN2;
      }
    };

    function selectElement(array, k) {
      // Credit Steve Hanov http://stevehanov.ca/blog/index.php?id=122
      var heap = new BinaryHeap(),
          i;

      for (i = 0; i < array.length; i++) {
        var item = array[i]; // If we have not yet found k items, or the current item is larger than
        // the smallest item on the heap, add current item

        if (heap.content.length < k || item > heap.content[0]) {
          // If the heap is full, remove the smallest element on the heap.
          if (heap.content.length === k) {
            heap.pop();
          }

          heap.push(item);
        }
      }

      return heap.content[0];
    }

    function BinaryHeap() {
      this.content = [];
    }

    BinaryHeap.prototype = {
      push: function (element) {
        // Add the new element to the end of the array.
        this.content.push(element); // Allow it to bubble up.

        this.bubbleUp(this.content.length - 1);
      },
      pop: function () {
        // Store the first element so we can return it later.
        var result = this.content[0]; // Get the element at the end of the array.

        var end = this.content.pop(); // If there are any elements left, put the end element at the
        // start, and let it sink down.

        if (this.content.length > 0) {
          this.content[0] = end;
          this.sinkDown(0);
        }

        return result;
      },
      remove: function (node) {
        var length = this.content.length; // To remove a value, we must search through the array to find
        // it.

        for (var i = 0; i < length; i++) {
          if (this.content[i] !== node) continue; // When it is found, the process seen in 'pop' is repeated
          // to fill up the hole.

          var end = this.content.pop(); // If the element we popped was the one we needed to remove,
          // we're done.

          if (i === length - 1) break; // Otherwise, we replace the removed element with the popped
          // one, and allow it to float up or sink down as appropriate.

          this.content[i] = end;
          this.bubbleUp(i);
          this.sinkDown(i);
          break;
        }
      },
      size: function () {
        return this.content.length;
      },
      bubbleUp: function (n) {
        // Fetch the element that has to be moved.
        var element = this.content[n],
            score = element; // When at 0, an element can not go up any further.

        while (n > 0) {
          // Compute the parent element's index, and fetch it.
          var parentN = Math.floor((n + 1) / 2) - 1,
              parent = this.content[parentN]; // If the parent has a lesser score, things are in order and we
          // are done.

          if (score >= parent) break; // Otherwise, swap the parent with the current element and
          // continue.

          this.content[parentN] = element;
          this.content[n] = parent;
          n = parentN;
        }
      },
      sinkDown: function (n) {
        // Look up the target element and its score.
        var length = this.content.length,
            element = this.content[n],
            elemScore = element;

        while (true) {
          // Compute the indices of the child elements.
          var child2N = (n + 1) * 2,
              child1N = child2N - 1; // This is used to store the new position of the element,
          // if any.

          var swap = null; // If the first child exists (is inside the array)...

          if (child1N < length) {
            // Look it up and compute its score.
            var child1 = this.content[child1N],
                child1Score = child1; // If the score is less than our element's, we need to swap.

            if (child1Score < elemScore) swap = child1N;
          } // Do the same checks for the other child.


          if (child2N < length) {
            var child2 = this.content[child2N],
                child2Score = child2;
            if (child2Score < (swap == null ? elemScore : child1Score)) swap = child2N;
          } // No need to swap further, we are done.


          if (swap == null) break; // Otherwise, swap and continue.

          this.content[n] = this.content[swap];
          this.content[swap] = element;
          n = swap;
        }
      }
    };

    /*
     * The MIT License (MIT)
     *
     * Copyright (c) 2014 Broad Institute
     *
     * Permission is hereby granted, free of charge, to any person obtaining a copy
     * of this software and associated documentation files (the "Software"), to deal
     * in the Software without restriction, including without limitation the rights
     * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
     * copies of the Software, and to permit persons to whom the Software is
     * furnished to do so, subject to the following conditions:
     *
     * The above copyright notice and this permission notice shall be included in
     * all copies or substantial portions of the Software.
     *
     *
     * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
     * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
     * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
     * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
     * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
     * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
     * THE SOFTWARE.
     */

    function _random(min, max) {
      return Math.random() * (max - min) + min;
    }

    const IGVColor = {
      rgbListFromHSV: () => {
        let s = 1;
        let accumulation = [];

        for (let v = 1; v >= 0.5; v -= .1) {
          for (let h = 0; h < 1; h += 1 / 28) {
            const r = "rgb(" + IGVColor.hsvToRgb(h, s, v).join(",") + ")";
            accumulation.push(r);
          }
        } // add black


        accumulation.pop();
        accumulation.push(IGVColor.rgbColor(16, 16, 16));
        return accumulation;
      },
      rgbToHex: function (rgb) {
        rgb = rgb.match(/^rgba?[\s+]?\([\s+]?(\d+)[\s+]?,[\s+]?(\d+)[\s+]?,[\s+]?(\d+)[\s+]?/i);
        return rgb && rgb.length === 4 ? "#" + ("0" + parseInt(rgb[1], 10).toString(16)).slice(-2) + ("0" + parseInt(rgb[2], 10).toString(16)).slice(-2) + ("0" + parseInt(rgb[3], 10).toString(16)).slice(-2) : '';
      },
      hexToRgb: function (hex) {
        var cooked = /^#?([a-f\d]{2})([a-f\d]{2})([a-f\d]{2})$/i.exec(hex);

        if (null === cooked) {
          return undefined;
        }

        return "rgb(" + parseInt(cooked[1], 16) + "," + parseInt(cooked[2], 16) + "," + parseInt(cooked[3], 16) + ")";
      },

      /**
       * Converts an HSV color value to RGB. Conversion formula
       * adapted from http://en.wikipedia.org/wiki/HSV_color_space.
       * Assumes h, s, and v are contained in the set [0, 1] and
       * returns r, g, and b in the set [0, 255].
       *
       * Credit: https://gist.githubusercontent.com/mjackson/5311256
       *
       * @param   h       The hue
       * @param   s       The saturation
       * @param   v       The value
       * @return  Array   The RGB representation
       */
      hsvToRgb: function (h, s, v) {
        var r, g, b;
        var i = Math.floor(h * 6);
        var f = h * 6 - i;
        var p = v * (1 - s);
        var q = v * (1 - f * s);
        var t = v * (1 - (1 - f) * s);

        switch (i % 6) {
          case 0:
            r = v, g = t, b = p;
            break;

          case 1:
            r = q, g = v, b = p;
            break;

          case 2:
            r = p, g = v, b = t;
            break;

          case 3:
            r = p, g = q, b = v;
            break;

          case 4:
            r = t, g = p, b = v;
            break;

          case 5:
            r = v, g = p, b = q;
            break;
        }

        return [Math.floor(r * 255), Math.floor(g * 255), Math.floor(b * 255)];
      },

      /**
       * Converts an HSL color value to RGB. Conversion formula
       * adapted from http://en.wikipedia.org/wiki/HSL_color_space.
       * Assumes h, s, and l are contained in the set [0, 1] and
       * returns r, g, and b in the set [0, 255].
       *
       * Credit: https://gist.githubusercontent.com/mjackson/5311256
       *
       * @param   h       The hue
       * @param   s       The saturation
       * @param   l       The lightness
       * @return  Array   The RGB representation
       */
      hslToRgb: function (h, s, l) {
        var r, g, b;

        if (s === 0) {
          r = g = b = l; // achromatic
        } else {
          var q = l < 0.5 ? l * (1 + s) : l + s - l * s;
          var p = 2 * l - q;
          r = IGVColor.hue2rgb(p, q, h + 1 / 3);
          g = IGVColor.hue2rgb(p, q, h);
          b = IGVColor.hue2rgb(p, q, h - 1 / 3);
        }

        return [r * 255, g * 255, b * 255];
      },
      hue2rgb: (p, q, t) => {
        if (t < 0) t += 1;
        if (t > 1) t -= 1;
        if (t < 1 / 6) return p + (q - p) * 6 * t;
        if (t < 1 / 2) return q;
        if (t < 2 / 3) return p + (q - p) * (2 / 3 - t) * 6;
        return p;
      },
      rgbaColor: function (r, g, b, a) {
        r = IGVMath.clamp(r, 0, 255);
        g = IGVMath.clamp(g, 0, 255);
        b = IGVMath.clamp(b, 0, 255);
        a = IGVMath.clamp(a, 0.0, 1.0);
        return "rgba(" + r + "," + g + "," + b + "," + a + ")";
      },
      rgbColor: function (r, g, b) {
        r = IGVMath.clamp(r, 0, 255);
        g = IGVMath.clamp(g, 0, 255);
        b = IGVMath.clamp(b, 0, 255);
        return "rgb(" + r + "," + g + "," + b + ")";
      },
      greyScale: function (value) {
        var grey = IGVMath.clamp(value, 0, 255);
        return "rgb(" + grey + "," + grey + "," + grey + ")";
      },
      randomGrey: function (min, max) {
        min = IGVMath.clamp(min, 0, 255);
        max = IGVMath.clamp(max, 0, 255);
        var g = Math.round(_random(min, max)).toString(10);
        return "rgb(" + g + "," + g + "," + g + ")";
      },
      randomRGB: function (min, max) {
        min = IGVMath.clamp(min, 0, 255);
        max = IGVMath.clamp(max, 0, 255);
        var r = Math.round(_random(min, max)).toString(10);
        var g = Math.round(_random(min, max)).toString(10);
        var b = Math.round(_random(min, max)).toString(10);
        return "rgb(" + r + "," + g + "," + b + ")";
      },
      randomRGBConstantAlpha: function (min, max, alpha) {
        min = IGVMath.clamp(min, 0, 255);
        max = IGVMath.clamp(max, 0, 255);
        var r = Math.round(_random(min, max)).toString(10);
        var g = Math.round(_random(min, max)).toString(10);
        var b = Math.round(_random(min, max)).toString(10);
        return "rgba(" + r + "," + g + "," + b + "," + alpha + ")";
      },
      addAlpha: function (color, alpha) {
        if (color === "0" || color === ".") {
          color = "rgb(0,0,0)";
        } else {
          const c = this.colorNameToHex(color);

          if (c) {
            color = c;
          }
        }

        var isHex = /(^#[0-9A-F]{6}$)|(^#[0-9A-F]{3}$)/i.test(color);

        if (color.startsWith("rgba")) {
          const idx = color.lastIndexOf(",");
          return color.substring(0, idx + 1) + alpha.toString() + ")";
        }

        if (isHex) {
          color = IGVColor.hexToRgb(color);
        }

        if (color.startsWith("rgb")) {
          return color.replace("rgb", "rgba").replace(")", ", " + alpha + ")");
        } else {
          console.log(color + " is not an rgb style string");
          return color;
        }
      },
      rgbComponents: function (color) {
        if (color === "0" || color === ".") {
          return [0, 0, 0];
        }

        const isHex = /(^#[0-9A-F]{6}$)|(^#[0-9A-F]{3}$)/i.test(color);

        if (isHex) {
          color = IGVColor.hexToRgb(color);
        } else {
          if (!color.startsWith("rgb")) {
            const hex = this.colorNameToHex(color);
            color = this.hexToRgb(hex);
          }
        }

        if (color.startsWith("rgb(")) {
          return color.substring(4, color.length - 1).split(",").map(s => Number.parseInt(s.trim()));
        } else if (color.startsWith("rgba(")) {
          return color.substring(5, color.length - 1).split(",").map((s, i) => {
            s = s.trim();
            return i === 3 ? Number.parseFloat(s) : Number.parseInt(s);
          });
        } else {
          throw Error("Unrecognized color string: color");
        }
      },

      /**
       *
       * @param dest  RGB components as an array
       * @param src  RGB components as an array
       * @param alpha   alpha transparancy in the range 0-1
       * @returns {}
       */
      getCompositeColor: function (dest, src, alpha) {
        var r = Math.floor(alpha * src[0] + (1 - alpha) * dest[0]),
            g = Math.floor(alpha * src[1] + (1 - alpha) * dest[1]),
            b = Math.floor(alpha * src[2] + (1 - alpha) * dest[2]);
        return "rgb(" + r + "," + g + "," + b + ")";
      },
      createColorString: function (str) {
        // Excel will quote color strings, strip all quotes
        str = stripQuotes$1(str);

        if (str.includes(",")) {
          return str.startsWith("rgb") ? str : "rgb(" + str + ")";
        } else {
          return str;
        }
      },
      darkenLighten: function (color, amt) {
        let src;
        let hexColor = this.colorNameToHex(color);

        if (hexColor) {
          src = IGVColor.hexToRgb(hexColor);
        } else {
          src = color.startsWith('rgb(') ? color : IGVColor.hexToRgb(color);
        }

        const components = src.replace(")", "").substring(4).split(",");
        const r = Math.max(0, Math.min(255, Number.parseInt(components[0].trim()) + amt));
        const g = Math.max(0, Math.min(255, Number.parseInt(components[1].trim()) + amt));
        const b = Math.max(0, Math.min(255, Number.parseInt(components[2].trim()) + amt));
        return 'rgb(' + r.toString() + ',' + g.toString() + ',' + b.toString() + ')';
      },

      /**
       * Convert html/css color name to hex value.  Adapted from https://gist.github.com/mxfh/4719348
       * @param colorName
       * @returns {*}
       */
      colorNameToHex: function (colorName) {
        // color list from http://stackoverflow.com/q/1573053/731179  with added gray/gray
        const definedColorNames = {
          "aliceblue": "#f0f8ff",
          "antiquewhite": "#faebd7",
          "aqua": "#00ffff",
          "aquamarine": "#7fffd4",
          "azure": "#f0ffff",
          "beige": "#f5f5dc",
          "bisque": "#ffe4c4",
          "black": "#000000",
          "blanchedalmond": "#ffebcd",
          "blue": "#0000ff",
          "blueviolet": "#8a2be2",
          "brown": "#a52a2a",
          "burlywood": "#deb887",
          "cadetblue": "#5f9ea0",
          "chartreuse": "#7fff00",
          "chocolate": "#d2691e",
          "coral": "#ff7f50",
          "cornflowerblue": "#6495ed",
          "cornsilk": "#fff8dc",
          "crimson": "#dc143c",
          "cyan": "#00ffff",
          "darkblue": "#00008b",
          "darkcyan": "#008b8b",
          "darkgoldenrod": "#b8860b",
          "darkgray": "#a9a9a9",
          "darkgreen": "#006400",
          "darkkhaki": "#bdb76b",
          "darkmagenta": "#8b008b",
          "darkolivegreen": "#556b2f",
          "darkorange": "#ff8c00",
          "darkorchid": "#9932cc",
          "darkred": "#8b0000",
          "darksalmon": "#e9967a",
          "darkseagreen": "#8fbc8f",
          "darkslateblue": "#483d8b",
          "darkslategray": "#2f4f4f",
          "darkturquoise": "#00ced1",
          "darkviolet": "#9400d3",
          "deeppink": "#ff1493",
          "deepskyblue": "#00bfff",
          "dimgray": "#696969",
          "dodgerblue": "#1e90ff",
          "firebrick": "#b22222",
          "floralwhite": "#fffaf0",
          "forestgreen": "#228b22",
          "fuchsia": "#ff00ff",
          "gainsboro": "#dcdcdc",
          "ghostwhite": "#f8f8ff",
          "gold": "#ffd700",
          "goldenrod": "#daa520",
          "gray": "#808080",
          "green": "#008000",
          "greenyellow": "#adff2f",
          "honeydew": "#f0fff0",
          "hotpink": "#ff69b4",
          "indianred ": "#cd5c5c",
          "indigo ": "#4b0082",
          "ivory": "#fffff0",
          "khaki": "#f0e68c",
          "lavender": "#e6e6fa",
          "lavenderblush": "#fff0f5",
          "lawngreen": "#7cfc00",
          "lemonchiffon": "#fffacd",
          "lightblue": "#add8e6",
          "lightcoral": "#f08080",
          "lightcyan": "#e0ffff",
          "lightgoldenrodyellow": "#fafad2",
          "lightgrey": "#d3d3d3",
          "lightgreen": "#90ee90",
          "lightpink": "#ffb6c1",
          "lightsalmon": "#ffa07a",
          "lightseagreen": "#20b2aa",
          "lightskyblue": "#87cefa",
          "lightslategray": "#778899",
          "lightsteelblue": "#b0c4de",
          "lightyellow": "#ffffe0",
          "lime": "#00ff00",
          "limegreen": "#32cd32",
          "linen": "#faf0e6",
          "magenta": "#ff00ff",
          "maroon": "#800000",
          "mediumaquamarine": "#66cdaa",
          "mediumblue": "#0000cd",
          "mediumorchid": "#ba55d3",
          "mediumpurple": "#9370d8",
          "mediumseagreen": "#3cb371",
          "mediumslateblue": "#7b68ee",
          "mediumspringgreen": "#00fa9a",
          "mediumturquoise": "#48d1cc",
          "mediumvioletred": "#c71585",
          "midnightblue": "#191970",
          "mintcream": "#f5fffa",
          "mistyrose": "#ffe4e1",
          "moccasin": "#ffe4b5",
          "navajowhite": "#ffdead",
          "navy": "#000080",
          "oldlace": "#fdf5e6",
          "olive": "#808000",
          "olivedrab": "#6b8e23",
          "orange": "#ffa500",
          "orangered": "#ff4500",
          "orchid": "#da70d6",
          "palegoldenrod": "#eee8aa",
          "palegreen": "#98fb98",
          "paleturquoise": "#afeeee",
          "palevioletred": "#d87093",
          "papayawhip": "#ffefd5",
          "peachpuff": "#ffdab9",
          "peru": "#cd853f",
          "pink": "#ffc0cb",
          "plum": "#dda0dd",
          "powderblue": "#b0e0e6",
          "purple": "#800080",
          "red": "#ff0000",
          "rosybrown": "#bc8f8f",
          "royalblue": "#4169e1",
          "saddlebrown": "#8b4513",
          "salmon": "#fa8072",
          "sandybrown": "#f4a460",
          "seagreen": "#2e8b57",
          "seashell": "#fff5ee",
          "sienna": "#a0522d",
          "silver": "#c0c0c0",
          "skyblue": "#87ceeb",
          "slateblue": "#6a5acd",
          "slategray": "#708090",
          "snow": "#fffafa",
          "springgreen": "#00ff7f",
          "steelblue": "#4682b4",
          "tan": "#d2b48c",
          "teal": "#008080",
          "thistle": "#d8bfd8",
          "tomato": "#ff6347",
          "turquoise": "#40e0d0",
          "violet": "#ee82ee",
          "wheat": "#f5deb3",
          "white": "#ffffff",
          "whitesmoke": "#f5f5f5",
          "yellow": "#ffff00",
          "yellowgreen": "#9acd32",
          "darkgrey": "#a9a9a9",
          "darkslategrey": "#2f4f4f",
          "dimgrey": "#696969",
          "grey": "#808080",
          "lightgray": "#d3d3d3",
          "lightslategrey": "#778899",
          "slategrey": "#708090"
        };
        return definedColorNames[colorName];
      }
    };

    /**
     * Make the target element movable by clicking and dragging on the handle.  This is not a general purprose function,
     * it makes several options specific to igv dialogs, the primary one being that the
     * target is absolutely positioned in pixel coordinates

     */
    let dragData$1; // Its assumed we are only dragging one element at a time.

    let bbox = undefined;

    function makeDraggable$1(target, handle, constraint) {
      if (constraint) {
        bbox = Object.assign({}, constraint);
      }

      handle.addEventListener('mousedown', dragStart$1.bind(target));
    }

    function dragStart$1(event) {
      event.stopPropagation();
      event.preventDefault();
      offset$1(this);
      const dragFunction = drag$1.bind(this);
      const dragEndFunction = dragEnd$1.bind(this);
      const computedStyle = getComputedStyle(this);
      const top = parseInt(computedStyle.top.replace("px", ""));
      const left = parseInt(computedStyle.left.replace("px", ""));
      dragData$1 = {
        dragFunction: dragFunction,
        dragEndFunction: dragEndFunction,
        screenX: event.screenX,
        screenY: event.screenY,
        top: top,
        left: left
      };
      document.addEventListener('mousemove', dragFunction);
      document.addEventListener('mouseup', dragEndFunction);
      document.addEventListener('mouseleave', dragEndFunction);
      document.addEventListener('mouseexit', dragEndFunction);
    }

    function drag$1(event) {
      if (!dragData$1) {
        console.log("No drag data!");
        return;
      }

      event.stopPropagation();
      event.preventDefault();
      const dx = event.screenX - dragData$1.screenX;
      const dy = event.screenY - dragData$1.screenY; // const left = bbox ? Math.max(bbox.minX, dragData.left + dx) : dragData.left + dx

      const left = dragData$1.left + dx;
      const top = bbox ? Math.max(bbox.minY, dragData$1.top + dy) : dragData$1.top + dy;
      this.style.left = `${left}px`;
      this.style.top = `${top}px`;
    }

    function dragEnd$1(event) {
      if (!dragData$1) {
        console.log("No drag data!");
        return;
      }

      event.stopPropagation();
      event.preventDefault();
      const dragFunction = dragData$1.dragFunction;
      const dragEndFunction = dragData$1.dragEndFunction;
      document.removeEventListener('mousemove', dragFunction);
      document.removeEventListener('mouseup', dragEndFunction);
      document.removeEventListener('mouseleave', dragEndFunction);
      document.removeEventListener('mouseexit', dragEndFunction);
      dragData$1 = undefined;
    }

    const appleCrayonPalette$1 = {
      licorice: "#000000",
      lead: "#1e1e1e",
      tungsten: "#3a3a3a",
      iron: "#545453",
      steel: "#6e6e6e",
      tin: "#878687",
      nickel: "#888787",
      aluminum: "#a09fa0",
      magnesium: "#b8b8b8",
      silver: "#d0d0d0",
      mercury: "#e8e8e8",
      snow: "#ffffff",
      //
      cayenne: "#891100",
      mocha: "#894800",
      aspargus: "#888501",
      fern: "#458401",
      clover: "#028401",
      moss: "#018448",
      teal: "#008688",
      ocean: "#004a88",
      midnight: "#001888",
      eggplant: "#491a88",
      plum: "#891e88",
      maroon: "#891648",
      //
      maraschino: "#ff2101",
      tangerine: "#ff8802",
      lemon: "#fffa03",
      lime: "#83f902",
      spring: "#05f802",
      seam_foam: "#03f987",
      turquoise: "#00fdff",
      aqua: "#008cff",
      blueberry: "#002eff",
      grape: "#8931ff",
      magenta: "#ff39ff",
      strawberry: "#ff2987",
      //
      salmon: "#ff726e",
      cantaloupe: "#ffce6e",
      banana: "#fffb6d",
      honeydew: "#cefa6e",
      flora: "#68f96e",
      spindrift: "#68fbd0",
      ice: "#68fdff",
      sky: "#6acfff",
      orchid: "#6e76ff",
      lavender: "#d278ff",
      bubblegum: "#ff7aff",
      carnation: "#ff7fd3"
    };

    // Support for oauth token based authorization
    // This class supports explicit setting of an oauth token either globally or for specific hosts.
    //
    // The variable oauth.google.access_token, which becomes igv.oauth.google.access_token on ES5 conversion is
    // supported for backward compatibility
    const DEFAULT_HOST = "googleapis";
    const oauth = {
      oauthTokens: {},
      setToken: function (token, host) {
        host = host || DEFAULT_HOST;
        this.oauthTokens[host] = token;

        if (host === DEFAULT_HOST) {
          this.google.access_token = token; // legacy support
        }
      },
      getToken: function (host) {
        host = host || DEFAULT_HOST;
        let token;

        for (let key of Object.keys(this.oauthTokens)) {
          const regex = wildcardToRegExp(key);

          if (regex.test(host)) {
            token = this.oauthTokens[key];
            break;
          }
        }

        return token;
      },
      removeToken: function (host) {
        host = host || DEFAULT_HOST;

        for (let key of Object.keys(this.oauthTokens)) {
          const regex = wildcardToRegExp(key);

          if (regex.test(host)) {
            this.oauthTokens[key] = undefined;
          }
        }

        if (host === DEFAULT_HOST) {
          this.google.access_token = undefined; // legacy support
        }
      },
      // Special object for google -- legacy support
      google: {
        setToken: function (token) {
          oauth.setToken(token);
        }
      }
    };
    /**
     * Creates a RegExp from the given string, converting asterisks to .* expressions,
     * and escaping all other characters.
     *
     * credit https://gist.github.com/donmccurdy/6d073ce2c6f3951312dfa45da14a420f
     */

    function wildcardToRegExp(s) {
      return new RegExp('^' + s.split(/\*+/).map(regExpEscape).join('.*') + '$');
    }
    /**
     * RegExp-escapes all characters in the given string.
     *
     * credit https://gist.github.com/donmccurdy/6d073ce2c6f3951312dfa45da14a420f
     */


    function regExpEscape(s) {
      return s.replace(/[|\\{}()[\]^$+*?.]/g, '\\$&');
    }

    // The MIT License (MIT)
    /**
     * @constructor
     * @param {Object} options A set op options to pass to the throttle function
     *        @param {number} requestsPerSecond The amount of requests per second
     *                                          the library will limit to
     */

    class Throttle {
      constructor(options) {
        this.requestsPerSecond = options.requestsPerSecond || 10;
        this.lastStartTime = 0;
        this.queued = [];
      }
      /**
       * Adds a promise
       * @param {Function} async function to be executed
       * @param {Object} options A set of options.
       * @return {Promise} A promise
       */


      add(asyncFunction, options) {
        var self = this;
        return new Promise(function (resolve, reject) {
          self.queued.push({
            resolve: resolve,
            reject: reject,
            asyncFunction: asyncFunction
          });
          self.dequeue();
        });
      }
      /**
       * Adds all the promises passed as parameters
       * @param {Function} promises An array of functions that return a promise
       * @param {Object} options A set of options.
       * @param {number} options.signal An AbortSignal object that can be used to abort the returned promise
       * @param {number} options.weight A "weight" of each operation resolving by array of promises
       * @return {Promise} A promise that succeeds when all the promises passed as options do
       */


      addAll(promises, options) {
        var addedPromises = promises.map(function (promise) {
          return this.add(promise, options);
        }.bind(this));
        return Promise.all(addedPromises);
      }

      /**
       * Dequeues a promise
       * @return {void}
       */
      dequeue() {
        if (this.queued.length > 0) {
          var now = new Date(),
              inc = 1000 / this.requestsPerSecond + 1,
              elapsed = now - this.lastStartTime;

          if (elapsed >= inc) {
            this._execute();
          } else {
            // we have reached the limit, schedule a dequeue operation
            setTimeout(function () {
              this.dequeue();
            }.bind(this), inc - elapsed);
          }
        }
      }
      /**
       * Executes the promise
       * @private
       * @return {void}
       */


      async _execute() {
        this.lastStartTime = new Date();
        var candidate = this.queued.shift();
        const f = candidate.asyncFunction;

        try {
          const r = await f();
          candidate.resolve(r);
        } catch (e) {
          candidate.reject(e);
        }
      }

    }

    /*
     * The MIT License (MIT)
     *
     * Copyright (c) 2014 Broad Institute
     *
     * Permission is hereby granted, free of charge, to any person obtaining a copy
     * of this software and associated documentation files (the "Software"), to deal
     * in the Software without restriction, including without limitation the rights
     * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
     * copies of the Software, and to permit persons to whom the Software is
     * furnished to do so, subject to the following conditions:
     *
     * The above copyright notice and this permission notice shall be included in
     * all copies or substantial portions of the Software.
     *
     *
     * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
     * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
     * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
     * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
     * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
     * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
     * THE SOFTWARE.
     */
    let RANGE_WARNING_GIVEN = false;
    const googleThrottle = new Throttle({
      requestsPerSecond: 8
    });
    const igvxhr = {
      apiKey: undefined,
      setApiKey: function (key) {
        this.apiKey = key;
      },
      load: load,
      loadArrayBuffer: async function (url, options) {
        options = options || {};

        if (!options.responseType) {
          options.responseType = "arraybuffer";
        }

        if (isFile(url)) {
          return loadFileSlice(url, options);
        } else {
          return load(url, options);
        }
      },
      loadJson: async function (url, options) {
        options = options || {};
        const method = options.method || (options.sendData ? "POST" : "GET");

        if (method === "POST") {
          options.contentType = "application/json";
        }

        const result = await this.loadString(url, options);

        if (result) {
          return JSON.parse(result);
        } else {
          return result;
        }
      },
      loadString: async function (path, options) {
        options = options || {};

        if (path instanceof File) {
          return loadStringFromFile(path, options);
        } else {
          return loadStringFromUrl(path, options);
        }
      }
    };

    async function load(url, options) {
      options = options || {};
      const urlType = typeof url; // Resolve functions, promises, and functions that return promises

      url = await (typeof url === 'function' ? url() : url);

      if (isFile(url)) {
        return loadFileSlice(url, options);
      } else if (typeof url.startsWith === 'function') {
        // Test for string
        if (url.startsWith("data:")) {
          const buffer = decodeDataURI$1(url).buffer;

          if (options.range) {
            const rangeEnd = options.range.size ? options.range.start + options.range.size : buffer.byteLength;
            return buffer.slice(options.range.start, rangeEnd);
          } else {
            return buffer;
          }
        } else {
          if (url.startsWith("https://drive.google.com")) {
            url = driveDownloadURL(url);
          }

          if (isGoogleDriveURL(url) || url.startsWith("https://www.dropbox.com")) {
            return googleThrottle.add(async function () {
              return loadURL(url, options);
            });
          } else {
            return loadURL(url, options);
          }
        }
      } else {
        throw Error(`url must be either a 'File', 'string', 'function', or 'Promise'.  Actual type: ${urlType}`);
      }
    }

    async function loadURL(url, options) {
      //console.log(`${Date.now()}   ${url}`)
      url = mapUrl(url);
      options = options || {};
      let oauthToken = options.oauthToken || getOauthToken(url);

      if (oauthToken) {
        oauthToken = await (typeof oauthToken === 'function' ? oauthToken() : oauthToken);
      }

      return new Promise(function (resolve, reject) {
        // Various Google tansformations
        if (isGoogleURL(url) && !isGoogleStorageSigned(url)) {
          if (isGoogleStorageURL(url)) {
            url = translateGoogleCloudURL(url);
          }

          url = addApiKey(url);

          if (isGoogleDriveURL(url)) {
            addTeamDrive(url);
          } // If we have an access token try it, but don't force a signIn or request for scopes yet


          if (!oauthToken) {
            oauthToken = getCurrentGoogleAccessToken();
          }
        }

        const headers = options.headers || {};

        if (oauthToken) {
          addOauthHeaders(headers, oauthToken);
        }

        const range = options.range;
        const isChrome = navigator.userAgent.indexOf('Chrome') > -1;
        navigator.vendor.indexOf("Apple") === 0 && /\sSafari\//.test(navigator.userAgent);

        if (range && isChrome && !isAmazonV4Signed(url) && !isGoogleStorageSigned(url)) {
          // Hack to prevent caching for byte-ranges. Attempt to fix net:err-cache errors in Chrome
          url += url.includes("?") ? "&" : "?";
          url += "someRandomSeed=" + Math.random().toString(36);
        }

        const xhr = new XMLHttpRequest();
        const sendData = options.sendData || options.body;
        const method = options.method || (sendData ? "POST" : "GET");
        const responseType = options.responseType;
        const contentType = options.contentType;
        const mimeType = options.mimeType;
        xhr.open(method, url);

        if (options.timeout) {
          xhr.timeout = options.timeout;
        }

        if (range) {
          var rangeEnd = range.size ? range.start + range.size - 1 : "";
          xhr.setRequestHeader("Range", "bytes=" + range.start + "-" + rangeEnd); //      xhr.setRequestHeader("Cache-Control", "no-cache");    <= This can cause CORS issues, disabled for now
        }

        if (contentType) {
          xhr.setRequestHeader("Content-Type", contentType);
        }

        if (mimeType) {
          xhr.overrideMimeType(mimeType);
        }

        if (responseType) {
          xhr.responseType = responseType;
        }

        if (headers) {
          for (let key of Object.keys(headers)) {
            const value = headers[key];
            xhr.setRequestHeader(key, value);
          }
        } // NOTE: using withCredentials with servers that return "*" for access-allowed-origin will fail


        if (options.withCredentials === true) {
          xhr.withCredentials = true;
        }

        xhr.onload = async function (event) {
          // when the url points to a local file, the status is 0 but that is not an error
          if (xhr.status === 0 || xhr.status >= 200 && xhr.status <= 300) {
            if (range && xhr.status !== 206 && range.start !== 0) {
              // For small files a range starting at 0 can return the whole file => 200
              // Provide just the slice we asked for, throw out the rest quietly
              // If file is large warn user
              if (xhr.response.length > 100000 && !RANGE_WARNING_GIVEN) {
                alert(`Warning: Range header ignored for URL: ${url}.  This can have performance impacts.`);
              }

              resolve(xhr.response.slice(range.start, range.start + range.size));
            } else {
              resolve(xhr.response);
            }
          } else if (typeof gapi !== "undefined" && (xhr.status === 404 || xhr.status === 401 || xhr.status === 403) && isGoogleURL(url) && !options.retries) {
            tryGoogleAuth();
          } else {
            if (xhr.status === 403) {
              handleError("Access forbidden: " + url);
            } else if (xhr.status === 416) {
              //  Tried to read off the end of the file.   This shouldn't happen, but if it does return an
              handleError("Unsatisfiable range");
            } else {
              handleError(xhr.status);
            }
          }
        };

        xhr.onerror = function (event) {
          if (isGoogleURL(url) && !options.retries) {
            tryGoogleAuth();
          }

          handleError("Error accessing resource: " + url + " Status: " + xhr.status);
        };

        xhr.ontimeout = function (event) {
          handleError("Timed out");
        };

        xhr.onabort = function (event) {
          console.log("Aborted");
          reject(event);
        };

        try {
          xhr.send(sendData);
        } catch (e) {
          reject(e);
        }

        function handleError(error) {
          if (reject) {
            reject(error);
          } else {
            throw error;
          }
        }

        async function tryGoogleAuth() {
          try {
            const accessToken = await fetchGoogleAccessToken(url);
            options.retries = 1;
            options.oauthToken = accessToken;
            const response = await load(url, options);
            resolve(response);
          } catch (e) {
            if (e.error) {
              const msg = e.error.startsWith("popup_blocked") ? "Google login popup blocked by browser." : e.error;
              alert(msg);
            } else {
              handleError(e);
            }
          }
        }
      });
    }

    async function loadFileSlice(localfile, options) {
      let blob = options && options.range ? localfile.slice(options.range.start, options.range.start + options.range.size) : localfile;
      const arrayBuffer = await blob.arrayBuffer();

      if ("arraybuffer" === options.responseType) {
        return arrayBuffer;
      } else {
        return arrayBufferToString(arrayBuffer);
      }
    }

    async function loadStringFromFile(localfile, options) {
      const blob = options.range ? localfile.slice(options.range.start, options.range.start + options.range.size) : localfile;
      const arrayBuffer = await blob.arrayBuffer();
      return arrayBufferToString(arrayBuffer);
    }

    async function loadStringFromUrl(url, options) {
      options = options || {};
      options.responseType = "arraybuffer";
      const data = await igvxhr.load(url, options);
      return arrayBufferToString(data);
    }

    function isAmazonV4Signed(url) {
      return url.indexOf("X-Amz-Signature") > -1;
    }

    function isGoogleStorageSigned(url) {
      return url.indexOf("X-Goog-Signature") > -1;
    }

    function getOauthToken(url) {
      // Google is the default provider, don't try to parse host for google URLs
      const host = isGoogleURL(url) ? undefined : parseUri(url).host;
      let token = oauth.getToken(host);

      if (token) {
        return token;
      } else if (host === undefined) {
        const googleToken = getCurrentGoogleAccessToken();

        if (googleToken && googleToken.expires_at > Date.now()) {
          return googleToken.access_token;
        }
      }
    }
    /**
     * Return a Google oAuth token, triggering a sign in if required.   This method should not be called until we know
     * a token is required, that is until we've tried the url and received a 401, 403, or 404.
     *
     * @param url
     * @returns the oauth token
     */


    async function fetchGoogleAccessToken(url) {
      if (isInitialized()) {
        const scope = getScopeForURL(url);
        const googleToken = await getAccessToken(scope);
        return googleToken ? googleToken.access_token : undefined;
      } else {
        throw Error(`Authorization is required, but Google oAuth has not been initalized. Contact your site administrator for assistance.`);
      }
    }
    /**
     * Return the current google access token, if one exists.  Do not triger signOn or request additional scopes.
     * @returns {undefined|access_token}
     */


    function getCurrentGoogleAccessToken() {
      if (isInitialized()) {
        const googleToken = getCurrentAccessToken();
        return googleToken ? googleToken.access_token : undefined;
      } else {
        return undefined;
      }
    }

    function addOauthHeaders(headers, acToken) {
      if (acToken) {
        headers["Cache-Control"] = "no-cache";
        headers["Authorization"] = "Bearer " + acToken;
      }

      return headers;
    }

    function addApiKey(url) {
      let apiKey = igvxhr.apiKey;

      if (!apiKey && typeof gapi !== "undefined") {
        apiKey = gapi.apiKey;
      }

      if (apiKey !== undefined && !url.includes("key=")) {
        const paramSeparator = url.includes("?") ? "&" : "?";
        url = url + paramSeparator + "key=" + apiKey;
      }

      return url;
    }

    function addTeamDrive(url) {
      if (url.includes("supportsTeamDrive")) {
        return url;
      } else {
        const paramSeparator = url.includes("?") ? "&" : "?";
        url = url + paramSeparator + "supportsTeamDrive=true";
      }
    }
    /**
     * Perform some well-known url mappings.
     * @param url
     */


    function mapUrl(url) {
      if (url.includes("//www.dropbox.com")) {
        return url.replace("//www.dropbox.com", "//dl.dropboxusercontent.com");
      } else if (url.includes("//drive.google.com")) {
        return driveDownloadURL(url);
      } else if (url.includes("//www.broadinstitute.org/igvdata")) {
        return url.replace("//www.broadinstitute.org/igvdata", "//data.broadinstitute.org/igvdata");
      } else if (url.includes("//igvdata.broadinstitute.org")) {
        return url.replace("//igvdata.broadinstitute.org", "https://dn7ywbm9isq8j.cloudfront.net");
      } else if (url.startsWith("ftp://ftp.ncbi.nlm.nih.gov/geo")) {
        return url.replace("ftp://", "https://");
      } else {
        return url;
      }
    }

    function arrayBufferToString(arraybuffer) {
      let plain;

      if (isgzipped(arraybuffer)) {
        plain = ungzip(arraybuffer);
      } else {
        plain = new Uint8Array(arraybuffer);
      }

      if ('TextDecoder' in getGlobalObject()) {
        return new TextDecoder().decode(plain);
      } else {
        return decodeUTF8(plain);
      }
    }
    /**
     * Use when TextDecoder is not available (primarily IE).
     *
     * From: https://gist.github.com/Yaffle/5458286
     *
     * @param octets
     * @returns {string}
     */


    function decodeUTF8(octets) {
      var string = "";
      var i = 0;

      while (i < octets.length) {
        var octet = octets[i];
        var bytesNeeded = 0;
        var codePoint = 0;

        if (octet <= 0x7F) {
          bytesNeeded = 0;
          codePoint = octet & 0xFF;
        } else if (octet <= 0xDF) {
          bytesNeeded = 1;
          codePoint = octet & 0x1F;
        } else if (octet <= 0xEF) {
          bytesNeeded = 2;
          codePoint = octet & 0x0F;
        } else if (octet <= 0xF4) {
          bytesNeeded = 3;
          codePoint = octet & 0x07;
        }

        if (octets.length - i - bytesNeeded > 0) {
          var k = 0;

          while (k < bytesNeeded) {
            octet = octets[i + k + 1];
            codePoint = codePoint << 6 | octet & 0x3F;
            k += 1;
          }
        } else {
          codePoint = 0xFFFD;
          bytesNeeded = octets.length - i;
        }

        string += String.fromCodePoint(codePoint);
        i += bytesNeeded + 1;
      }

      return string;
    }

    function getGlobalObject() {
      if (typeof self !== 'undefined') {
        return self;
      }

      if (typeof global !== 'undefined') {
        return global;
      } else {
        return window;
      }
    }

    /*
     * The MIT License (MIT)
     *
     * Copyright (c) 2014 Broad Institute
     *
     * Permission is hereby granted, free of charge, to any person obtaining a copy
     * of this software and associated documentation files (the "Software"), to deal
     * in the Software without restriction, including without limitation the rights
     * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
     * copies of the Software, and to permit persons to whom the Software is
     * furnished to do so, subject to the following conditions:
     *
     * The above copyright notice and this permission notice shall be included in
     * all copies or substantial portions of the Software.
     *
     *
     * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
     * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
     * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
     * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
     * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
     * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
     * THE SOFTWARE.
     */

    /** An implementation of an interval tree, following the explanation.
     * from CLR.
     *
     * Public interface:
     *   Constructor  IntervalTree
     *   Insertion    insert
     *   Search       findOverlapping
     */
    var BLACK = 1;
    var RED = 2;
    var NIL = {};
    NIL.color = BLACK;
    NIL.parent = NIL;
    NIL.left = NIL;
    NIL.right = NIL;

    class IntervalTree {
      constructor() {
        this.root = NIL;
      }

      insert(start, end, value) {
        var interval = new Interval(start, end, value);
        var x = new Node(interval);
        this.treeInsert(x);
        x.color = RED;

        while (x !== this.root && x.parent.color === RED) {
          if (x.parent === x.parent.parent.left) {
            let y = x.parent.parent.right;

            if (y.color === RED) {
              x.parent.color = BLACK;
              y.color = BLACK;
              x.parent.parent.color = RED;
              x = x.parent.parent;
            } else {
              if (x === x.parent.right) {
                x = x.parent;
                leftRotate.call(this, x);
              }

              x.parent.color = BLACK;
              x.parent.parent.color = RED;
              rightRotate.call(this, x.parent.parent);
            }
          } else {
            let y = x.parent.parent.left;

            if (y.color === RED) {
              x.parent.color = BLACK;
              y.color = BLACK;
              x.parent.parent.color = RED;
              x = x.parent.parent;
            } else {
              if (x === x.parent.left) {
                x = x.parent;
                rightRotate.call(this, x);
              }

              x.parent.color = BLACK;
              x.parent.parent.color = RED;
              leftRotate.call(this, x.parent.parent);
            }
          }
        }

        this.root.color = BLACK;
      }
      /**
       *
       * @param start - query interval
       * @param end - query interval
       * @returns Array of all intervals overlapping the query region
       */


      findOverlapping(start, end) {
        var searchInterval = new Interval(start, end, 0);
        if (this.root === NIL) return [];
        var intervals = searchAll.call(this, searchInterval, this.root, []);

        if (intervals.length > 1) {
          intervals.sort(function (i1, i2) {
            return i1.low - i2.low;
          });
        }

        return intervals;
      }
      /**
       * Dump info on intervals to console.  For debugging.
       */


      logIntervals() {
        logNode(this.root, 0);

        function logNode(node, indent) {
          var space = "";

          for (var i = 0; i < indent; i++) space += " ";

          console.log(space + node.interval.low + " " + node.interval.high); // + " " + (node.interval.value ? node.interval.value : " null"));

          indent += 5;
          if (node.left !== NIL) logNode(node.left, indent);
          if (node.right !== NIL) logNode(node.right, indent);
        }
      }

      mapIntervals(func) {
        applyInterval(this.root);

        function applyInterval(node) {
          func(node.interval);
          if (node.left !== NIL) applyInterval(node.left);
          if (node.right !== NIL) applyInterval(node.right);
        }
      }
      /**
       * Note:  Does not maintain RB constraints,  this is done post insert
       *
       * @param x  a Node
       */


      treeInsert(x) {
        var node = this.root;
        var y = NIL;

        while (node !== NIL) {
          y = node;

          if (x.interval.low <= node.interval.low) {
            node = node.left;
          } else {
            node = node.right;
          }
        }

        x.parent = y;

        if (y === NIL) {
          this.root = x;
          x.left = x.right = NIL;
        } else {
          if (x.interval.low <= y.interval.low) {
            y.left = x;
          } else {
            y.right = x;
          }
        }

        applyUpdate.call(this, x);
      }

    }

    function searchAll(interval, node, results) {
      if (node.interval.overlaps(interval)) {
        results.push(node.interval);
      }

      if (node.left !== NIL && node.left.max >= interval.low) {
        searchAll.call(this, interval, node.left, results);
      }

      if (node.right !== NIL && node.right.min <= interval.high) {
        searchAll.call(this, interval, node.right, results);
      }

      return results;
    }

    function leftRotate(x) {
      var y = x.right;
      x.right = y.left;

      if (y.left !== NIL) {
        y.left.parent = x;
      }

      y.parent = x.parent;

      if (x.parent === NIL) {
        this.root = y;
      } else {
        if (x.parent.left === x) {
          x.parent.left = y;
        } else {
          x.parent.right = y;
        }
      }

      y.left = x;
      x.parent = y;
      applyUpdate.call(this, x); // no need to apply update on y, since it'll y is an ancestor
      // of x, and will be touched by applyUpdate().
    }

    function rightRotate(x) {
      var y = x.left;
      x.left = y.right;

      if (y.right !== NIL) {
        y.right.parent = x;
      }

      y.parent = x.parent;

      if (x.parent === NIL) {
        this.root = y;
      } else {
        if (x.parent.right === x) {
          x.parent.right = y;
        } else {
          x.parent.left = y;
        }
      }

      y.right = x;
      x.parent = y;
      applyUpdate.call(this, x); // no need to apply update on y, since it'll y is an ancestor
      // of x, and will be touched by applyUpdate().
    } // Applies the statistic update on the node and its ancestors.


    function applyUpdate(node) {
      while (node !== NIL) {
        var nodeMax = node.left.max > node.right.max ? node.left.max : node.right.max;
        var intervalHigh = node.interval.high;
        node.max = nodeMax > intervalHigh ? nodeMax : intervalHigh;
        var nodeMin = node.left.min < node.right.min ? node.left.min : node.right.min;
        var intervalLow = node.interval.low;
        node.min = nodeMin < intervalLow ? nodeMin : intervalLow;
        node = node.parent;
      }
    }

    class Interval {
      constructor(low, high, value) {
        this.low = low;
        this.high = high;
        this.value = value;
      }

      equals(other) {
        if (!other) {
          return false;
        }

        if (this === other) {
          return true;
        }

        return this.low === other.low && this.high === other.high;
      }

      compareTo(other) {
        if (this.low < other.low) return -1;
        if (this.low > other.low) return 1;
        if (this.high < other.high) return -1;
        if (this.high > other.high) return 1;
        return 0;
      }
      /**
       * Returns true if this interval overlaps the other.
       */


      overlaps(other) {
        return this.low <= other.high && other.low <= this.high;
      }

    }

    function Node(interval) {
      this.parent = NIL;
      this.left = NIL;
      this.right = NIL;
      this.interval = interval;
      this.color = RED;
    } //

    /*
     * The MIT License (MIT)
     *
     * Copyright (c) 2014 Broad Institute
     *
     * Permission is hereby granted, free of charge, to any person obtaining a copy
     * of this software and associated documentation files (the "Software"), to deal
     * in the Software without restriction, including without limitation the rights
     * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
     * copies of the Software, and to permit persons to whom the Software is
     * furnished to do so, subject to the following conditions:
     *
     * The above copyright notice and this permission notice shall be included in
     * all copies or substantial portions of the Software.
     *
     *
     * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
     * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
     * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
     * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
     * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
     * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
     * THE SOFTWARE.
     */
    /**
     * Object for caching lists of features.  Supports effecient queries for sub-range  (chr, start, end)
     *
     * @param featureList
     * @param The genomic range spanned by featureList (optional)
     * @constructor
     */

    class FeatureCache$1 {
      constructor(featureList, genome, range) {
        featureList = featureList || [];
        this.treeMap = this.buildTreeMap(featureList, genome);
        this.range = range;
        this.count = featureList.length;
      }

      containsRange(genomicRange) {
        // No range means cache contains all features
        return this.range === undefined || this.range.contains(genomicRange.chr, genomicRange.start, genomicRange.end);
      }

      queryFeatures(chr, start, end) {
        const tree = this.treeMap[chr];
        if (!tree) return [];
        const intervals = tree.findOverlapping(start, end);

        if (intervals.length === 0) {
          return [];
        } else {
          // Trim the list of features in the intervals to those
          // overlapping the requested range.
          // Assumption: features are sorted by start position
          const featureList = [];
          const all = this.allFeatures[chr];

          if (all) {
            for (let interval of intervals) {
              const indexRange = interval.value;

              for (let i = indexRange.start; i < indexRange.end; i++) {
                let feature = all[i];
                if (feature.start > end) break;else if (feature.end >= start) {
                  featureList.push(feature);
                }
              }
            }

            featureList.sort(function (a, b) {
              return a.start - b.start;
            });
          }

          return featureList;
        }
      }

      /**
       * Returns all features, unsorted.
       *
       * @returns {Array}
       */
      getAllFeatures() {
        return this.allFeatures;
      }

      buildTreeMap(featureList, genome) {
        const treeMap = {};
        const chromosomes = [];
        this.allFeatures = {};

        if (featureList) {
          for (let feature of featureList) {
            let chr = feature.chr; // Translate to "official" name

            if (genome) {
              chr = genome.getChromosomeName(chr);
            }

            let geneList = this.allFeatures[chr];

            if (!geneList) {
              chromosomes.push(chr);
              geneList = [];
              this.allFeatures[chr] = geneList;
            }

            geneList.push(feature);
          } // Now build interval tree for each chromosome


          for (let chr of chromosomes) {
            const chrFeatures = this.allFeatures[chr];
            chrFeatures.sort(function (f1, f2) {
              return f1.start === f2.start ? 0 : f1.start > f2.start ? 1 : -1;
            });
            treeMap[chr] = buildIntervalTree$1(chrFeatures);
          }
        }

        return treeMap;
      }

    }
    /**
     * Build an interval tree from the feature list for fast interval based queries.   We lump features in groups
     * of 10, or total size / 100,   to reduce size of the tree.
     *
     * @param featureList
     */


    function buildIntervalTree$1(featureList) {
      const tree = new IntervalTree();
      const len = featureList.length;
      const chunkSize = Math.max(10, Math.round(len / 10));

      for (let i = 0; i < len; i += chunkSize) {
        const e = Math.min(len, i + chunkSize);
        const subArray = new IndexRange(i, e); //featureList.slice(i, e);

        const iStart = featureList[i].start; //

        let iEnd = iStart;

        for (let j = i; j < e; j++) {
          iEnd = Math.max(iEnd, featureList[j].end);
        }

        tree.insert(iStart, iEnd, subArray);
      }

      return tree;
    }

    class IndexRange {
      constructor(start, end) {
        this.start = start;
        this.end = end;
      }

    }

    /*
     * The MIT License (MIT)
     *
     * Copyright (c) 2016-2017 The Regents of the University of California
     * Author: Jim Robinson
     *
     * Permission is hereby granted, free of charge, to any person obtaining a copy
     * of this software and associated documentation files (the "Software"), to deal
     * in the Software without restriction, including without limitation the rights
     * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
     * copies of the Software, and to permit persons to whom the Software is
     * furnished to do so, subject to the following conditions:
     *
     * The above copyright notice and this permission notice shall be included in
     * all copies or substantial portions of the Software.
     *
     *
     * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
     * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
     * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
     * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
     * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
     * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
     * THE SOFTWARE.
     */
    const FeatureUtils = {
      packFeatures: function (features, maxRows, sorted) {
        var start;
        var end;
        if (!features) return;
        maxRows = maxRows || 10000;

        if (!sorted) {
          features.sort(function (a, b) {
            return a.start - b.start;
          });
        }

        if (features.length === 0) {
          return [];
        } else {
          var bucketList = [],
              allocatedCount = 0,
              lastAllocatedCount = 0,
              nextStart,
              row,
              index,
              bucket,
              feature,
              gap = 2,
              bucketStart;
          start = features[0].start;
          end = features[features.length - 1].start;
          bucketStart = Math.max(start, features[0].start);
          nextStart = bucketStart;
          features.forEach(function (alignment) {
            var buckListIndex = Math.max(0, alignment.start - bucketStart);

            if (bucketList[buckListIndex] === undefined) {
              bucketList[buckListIndex] = [];
            }

            bucketList[buckListIndex].push(alignment);
          });
          row = 0;

          while (allocatedCount < features.length && row <= maxRows) {
            while (nextStart <= end) {
              bucket = undefined;

              while (!bucket && nextStart <= end) {
                index = nextStart - bucketStart;

                if (bucketList[index] === undefined) {
                  ++nextStart; // No buckets at this index
                } else {
                  bucket = bucketList[index];
                }
              } // while (bucket)


              if (!bucket) {
                break;
              }

              feature = bucket.pop();

              if (0 === bucket.length) {
                bucketList[index] = undefined;
              }

              feature.row = row;
              nextStart = feature.end + gap;
              ++allocatedCount;
            } // while (nextStart)


            row++;
            nextStart = bucketStart;
            if (allocatedCount === lastAllocatedCount) break; // Protect from infinite loops

            lastAllocatedCount = allocatedCount;
          } // while (allocatedCount)

        }
      },

      /**
       * Find features overlapping the given interval.  It is assumed that all features share the same chromosome.
       *
       * TODO -- significant overlap with FeatureCache, refactor to combine
       *
       * @param featureList
       * @param start
       * @param end
       */
      findOverlapping: function (featureList, start, end) {
        if (!featureList || featureList.length === 0) {
          return [];
        } else {
          const tree = buildIntervalTree(featureList);
          const intervals = tree.findOverlapping(start, end);

          if (intervals.length === 0) {
            return [];
          } else {
            // Trim the list of features in the intervals to those
            // overlapping the requested range.
            // Assumption: features are sorted by start position
            featureList = [];
            intervals.forEach(function (interval) {
              const intervalFeatures = interval.value;
              const len = intervalFeatures.length;

              for (let i = 0; i < len; i++) {
                const feature = intervalFeatures[i];
                if (feature.start > end) break;else if (feature.end > start) {
                  featureList.push(feature);
                }
              }
            });
            featureList.sort(function (a, b) {
              return a.start - b.start;
            });
            return featureList;
          }
        }
      }
    };
    /**
     * Build an interval tree from the feature list for fast interval based queries.   We lump features in groups
     * of 10, or total size / 100,   to reduce size of the tree.
     *
     * @param featureList
     */

    function buildIntervalTree(featureList) {
      const tree = new IntervalTree();
      const len = featureList.length;
      const chunkSize = Math.max(10, Math.round(len / 100));
      featureList.sort(function (f1, f2) {
        return f1.start === f2.start ? 0 : f1.start > f2.start ? 1 : -1;
      });

      for (let i = 0; i < len; i += chunkSize) {
        const e = Math.min(len, i + chunkSize);
        const subArray = featureList.slice(i, e);
        const iStart = subArray[0].start;
        let iEnd = iStart;
        subArray.forEach(function (feature) {
          iEnd = Math.max(iEnd, feature.end);
        });
        tree.insert(iStart, iEnd, subArray);
      }

      return tree;
    }

    function createCheckbox$1(name, initialState) {
      const container = div$1({
        class: 'igv-menu-popup-check-container'
      });
      const div = div$1();
      container.appendChild(div);
      const svg = createIcon$1('check', true === initialState ? '#444' : 'transparent');
      div.appendChild(svg);
      const label = div$1();
      label.innerText = name;
      container.appendChild(label);
      return container;
    }

    /**
     * Configure item list for track "gear" menu.
     * @param trackView
     */

    const MenuUtils = {
      trackMenuItemList: function (trackView) {
        const vizWindowTypes = new Set(['alignment', 'annotation', 'variant', 'eqtl', 'snp']);
        const hasVizWindow = trackView.track.config && trackView.track.config.visibilityWindow !== undefined;
        let menuItems = [];

        if (trackView.track.config.type !== 'sequence') {
          menuItems.push(trackRenameMenuItem(trackView));
          menuItems.push(trackHeightMenuItem(trackView));
        }

        if (this.showColorPicker(trackView.track)) {
          menuItems.push('<hr/>');
          menuItems.push(colorPickerMenuItem({
            trackView,
            label: "Set track color",
            option: "color"
          }));
          menuItems.push(unsetColorMenuItem({
            trackView,
            label: "Unset track color"
          }));
          menuItems.push(colorPickerMenuItem({
            trackView,
            label: "Set alt color",
            option: "altColor"
          }));
        }

        if (trackView.track.menuItemList) {
          menuItems = menuItems.concat(trackView.track.menuItemList());
        }

        if (hasVizWindow || vizWindowTypes.has(trackView.track.type)) {
          menuItems.push('<hr/>');
          menuItems.push(visibilityWindowMenuItem(trackView));
        }

        if (trackView.track.removable !== false) {
          menuItems.push('<hr/>');
          menuItems.push(trackRemovalMenuItem(trackView));
        }

        return menuItems;
      },
      numericDataMenuItems: function (trackView) {
        const menuItems = [];
        menuItems.push('<hr/>'); // Data range

        const object = $$1('<div>');
        object.text('Set data range');

        const click = () => {
          trackView.browser.dataRangeDialog.configure(trackView);
          trackView.browser.dataRangeDialog.present($$1(trackView.browser.columnContainer));
        };

        menuItems.push({
          object,
          click
        });

        if (trackView.track.logScale !== undefined) {
          menuItems.push({
            object: $$1(createCheckbox$1("Log scale", trackView.track.logScale)),
            click: () => {
              trackView.track.logScale = !trackView.track.logScale;
              trackView.repaintViews();
            }
          });
        }

        menuItems.push({
          object: $$1(createCheckbox$1("Autoscale", trackView.track.autoscale)),
          click: () => {
            trackView.track.autoscale = !trackView.track.autoscale;
            trackView.updateViews();
          }
        });
        return menuItems;
      },
      trackMenuItemListHelper: function (itemList, menuPopup) {
        var list = [];

        if (itemList.length > 0) {
          list = itemList.map(function (item, i) {
            var $e; // name and object fields checked for backward compatibility

            if (item.name) {
              $e = $$1('<div>');
              $e.text(item.name);
            } else if (item.object) {
              $e = item.object;
            } else if (typeof item.label === 'string') {
              $e = $$1('<div>');
              $e.html(item.label);
            } else if (typeof item === 'string') {
              if (item.startsWith("<")) {
                $e = $$1(item);
              } else {
                $e = $$1("<div>" + item + "</div>");
              }
            }

            if (0 === i) {
              $e.addClass('igv-track-menu-border-top');
            }

            if (item.click) {
              $e.on('click', handleClick);
              $e.on('touchend', function (e) {
                handleClick(e);
              });
              $e.on('mouseup', function (e) {
                e.preventDefault();
                e.stopPropagation();
              }); // eslint-disable-next-line no-inner-declarations

              function handleClick(e) {
                item.click(e);
                menuPopup.hide();
                e.preventDefault();
                e.stopPropagation();
              }
            }

            return {
              object: $e,
              init: item.init || undefined
            };
          });
        }

        return list;
      },

      showColorPicker(track) {
        return undefined === track.type || "bedtype" === track.type || "alignment" === track.type || "annotation" === track.type || "variant" === track.type || "wig" === track.type || 'interact' === track.type;
      },

      createMenuItem(label, action) {
        const object = $$1('<div>');
        object.text(label);
        return {
          object,
          click: action
        };
      }

    };

    function visibilityWindowMenuItem(trackView) {
      const click = e => {
        const callback = () => {
          let value = trackView.browser.inputDialog.input.value;
          value = '' === value || undefined === value ? -1 : value.trim();
          trackView.track.visibilityWindow = Number.parseInt(value);
          trackView.track.config.visibilityWindow = Number.parseInt(value);
          trackView.updateViews();
        };

        const config = {
          label: 'Visibility Window',
          value: trackView.track.visibilityWindow,
          callback
        };
        trackView.browser.inputDialog.present(config, e);
      };

      const object = $$1('<div>');
      object.text('Set visibility window');
      return {
        object,
        click
      };
    }

    function trackRemovalMenuItem(trackView) {
      const object = $$1('<div>');
      object.text('Remove track');
      return {
        object,
        click: () => trackView.browser.removeTrack(trackView.track)
      };
    }

    function colorPickerMenuItem(_ref) {
      let {
        trackView,
        label,
        option
      } = _ref;
      const $e = $$1('<div>');
      $e.text(label);
      return {
        object: $e,
        click: () => trackView.presentColorPicker(option)
      };
    }

    function unsetColorMenuItem(_ref2) {
      let {
        trackView,
        label
      } = _ref2;
      const $e = $$1('<div>');
      $e.text(label);
      return {
        object: $e,
        click: () => {
          trackView.track.color = undefined;
          trackView.repaintViews();
        }
      };
    }

    function trackRenameMenuItem(trackView) {
      const click = e => {
        const callback = function () {
          let value = trackView.browser.inputDialog.input.value;
          value = '' === value || undefined === value ? 'untitled' : value.trim();
          trackView.track.name = value;
        };

        const config = {
          label: 'Track Name',
          value: getTrackLabelText(trackView.track) || 'unnamed',
          callback
        };
        trackView.browser.inputDialog.present(config, e);
      };

      const object = $$1('<div>');
      object.text('Set track name');
      return {
        object,
        click
      };
    }

    function trackHeightMenuItem(trackView) {
      const click = e => {
        const callback = () => {
          const number = Number(trackView.browser.inputDialog.input.value, 10);

          if (undefined !== number) {
            // If explicitly setting the height adust min or max, if neccessary.
            if (trackView.track.minHeight !== undefined && trackView.track.minHeight > number) {
              trackView.track.minHeight = number;
            }

            if (trackView.track.maxHeight !== undefined && trackView.track.maxHeight < number) {
              trackView.track.minHeight = number;
            }

            trackView.setTrackHeight(number, true);
            trackView.checkContentHeight();
            trackView.repaintViews(); // Explicitly setting track height turns off autoHeight

            trackView.track.autoHeight = false;
          }
        };

        const config = {
          label: 'Track Height',
          value: trackView.track.height,
          callback
        };
        trackView.browser.inputDialog.present(config, e);
      };

      const object = $$1('<div>');
      object.text('Set track height');
      return {
        object,
        click
      };
    }

    function getTrackLabelText(track) {
      var vp, txt;
      vp = track.trackView.viewports[0];
      txt = vp.$trackLabel.text();
      return txt;
    }

    function div(options) {
      return create("div", options);
    }

    function create(tag, options) {
      const elem = document.createElement(tag);

      if (options) {
        if (options.class) {
          elem.classList.add(options.class);
        }

        if (options.id) {
          elem.id = options.id;
        }

        if (options.style) {
          applyStyle(elem, options.style);
        }
      }

      return elem;
    }

    function hide(elem) {
      const cssStyle = getComputedStyle(elem);

      if (cssStyle.display !== "none") {
        elem._initialDisplay = cssStyle.display;
      }

      elem.style.display = "none";
    }

    function show(elem) {
      const currentDisplay = getComputedStyle(elem).display;

      if (currentDisplay === "none") {
        const d = elem._initialDisplay || "block";
        elem.style.display = d;
      }
    }

    function offset(elem) {
      // Return zeros for disconnected and hidden (display: none) elements (gh-2310)
      // Support: IE <=11 only
      // Running getBoundingClientRect on a
      // disconnected node in IE throws an error
      if (!elem.getClientRects().length) {
        return {
          top: 0,
          left: 0
        };
      } // Get document-relative position by adding viewport scroll to viewport-relative gBCR


      const rect = elem.getBoundingClientRect();
      const win = elem.ownerDocument.defaultView;
      return {
        top: rect.top + win.pageYOffset,
        left: rect.left + win.pageXOffset
      };
    }

    function pageCoordinates(e) {
      if (e.type.startsWith("touch")) {
        const touch = e.touches[0];
        return {
          x: touch.pageX,
          y: touch.pageY
        };
      } else {
        return {
          x: e.pageX,
          y: e.pageY
        };
      }
    }

    function applyStyle(elem, style) {
      for (let key of Object.keys(style)) {
        elem.style[key] = style[key];
      }
    }

    let getMouseXY = (domElement, {
      clientX,
      clientY
    }) => {
      // DOMRect object with eight properties: left, top, right, bottom, x, y, width, height
      const {
        left,
        top,
        width,
        height
      } = domElement.getBoundingClientRect();
      const x = clientX - left;
      const y = clientY - top;
      return {
        x,
        y,
        xNormalized: x / width,
        yNormalized: y / height,
        width,
        height
      };
    };
    /**
     * Translate the mouse coordinates for the event to the coordinates for the given target element
     * @param event
     * @param domElement
     * @returns {{x: number, y: number}}
     */


    function translateMouseCoordinates(event, domElement) {
      const {
        clientX,
        clientY
      } = event;
      return getMouseXY(domElement, {
        clientX,
        clientY
      });
    }

    function createCheckbox(name, initialState) {
      const container = div({
        class: 'igv-ui-trackgear-popover-check-container'
      });
      const svg = iconMarkup('check', true === initialState ? '#444' : 'transparent');
      svg.style.borderColor = 'gray';
      svg.style.borderWidth = '1px';
      svg.style.borderStyle = 'solid';
      container.appendChild(svg);
      let label = div(); //{ class: 'igv-some-label-class' });

      label.textContent = name;
      container.appendChild(label);
      return container;
    }

    function createIcon(name, color) {
      return iconMarkup(name, color);
    }

    function iconMarkup(name, color) {
      color = color || "currentColor";
      let icon = icons[name];

      if (!icon) {
        console.error(`No icon named: ${name}`);
        icon = icons["question"];
      }

      const svg = document.createElementNS("http://www.w3.org/2000/svg", "svg");
      svg.setAttributeNS(null, 'viewBox', '0 0 ' + icon[0] + ' ' + icon[1]);
      const path = document.createElementNS("http://www.w3.org/2000/svg", "path");
      path.setAttributeNS(null, 'fill', color);
      path.setAttributeNS(null, 'd', icon[4]);
      svg.appendChild(path);
      return svg;
    }

    const icons = {
      "check": [512, 512, [], "f00c", "M173.898 439.404l-166.4-166.4c-9.997-9.997-9.997-26.206 0-36.204l36.203-36.204c9.997-9.998 26.207-9.998 36.204 0L192 312.69 432.095 72.596c9.997-9.997 26.207-9.997 36.204 0l36.203 36.204c9.997 9.997 9.997 26.206 0 36.204l-294.4 294.401c-9.998 9.997-26.207 9.997-36.204-.001z"],
      "cog": [512, 512, [], "f013", "M444.788 291.1l42.616 24.599c4.867 2.809 7.126 8.618 5.459 13.985-11.07 35.642-29.97 67.842-54.689 94.586a12.016 12.016 0 0 1-14.832 2.254l-42.584-24.595a191.577 191.577 0 0 1-60.759 35.13v49.182a12.01 12.01 0 0 1-9.377 11.718c-34.956 7.85-72.499 8.256-109.219.007-5.49-1.233-9.403-6.096-9.403-11.723v-49.184a191.555 191.555 0 0 1-60.759-35.13l-42.584 24.595a12.016 12.016 0 0 1-14.832-2.254c-24.718-26.744-43.619-58.944-54.689-94.586-1.667-5.366.592-11.175 5.459-13.985L67.212 291.1a193.48 193.48 0 0 1 0-70.199l-42.616-24.599c-4.867-2.809-7.126-8.618-5.459-13.985 11.07-35.642 29.97-67.842 54.689-94.586a12.016 12.016 0 0 1 14.832-2.254l42.584 24.595a191.577 191.577 0 0 1 60.759-35.13V25.759a12.01 12.01 0 0 1 9.377-11.718c34.956-7.85 72.499-8.256 109.219-.007 5.49 1.233 9.403 6.096 9.403 11.723v49.184a191.555 191.555 0 0 1 60.759 35.13l42.584-24.595a12.016 12.016 0 0 1 14.832 2.254c24.718 26.744 43.619 58.944 54.689 94.586 1.667 5.366-.592 11.175-5.459 13.985L444.788 220.9a193.485 193.485 0 0 1 0 70.2zM336 256c0-44.112-35.888-80-80-80s-80 35.888-80 80 35.888 80 80 80 80-35.888 80-80z"],
      "exclamation": [192, 512, [], "f12a", "M176 432c0 44.112-35.888 80-80 80s-80-35.888-80-80 35.888-80 80-80 80 35.888 80 80zM25.26 25.199l13.6 272C39.499 309.972 50.041 320 62.83 320h66.34c12.789 0 23.331-10.028 23.97-22.801l13.6-272C167.425 11.49 156.496 0 142.77 0H49.23C35.504 0 24.575 11.49 25.26 25.199z"],
      "exclamation-circle": [512, 512, [], "f06a", "M504 256c0 136.997-111.043 248-248 248S8 392.997 8 256C8 119.083 119.043 8 256 8s248 111.083 248 248zm-248 50c-25.405 0-46 20.595-46 46s20.595 46 46 46 46-20.595 46-46-20.595-46-46-46zm-43.673-165.346l7.418 136c.347 6.364 5.609 11.346 11.982 11.346h48.546c6.373 0 11.635-4.982 11.982-11.346l7.418-136c.375-6.874-5.098-12.654-11.982-12.654h-63.383c-6.884 0-12.356 5.78-11.981 12.654z"],
      "exclamation-triangle": [576, 512, [], "f071", "M569.517 440.013C587.975 472.007 564.806 512 527.94 512H48.054c-36.937 0-59.999-40.055-41.577-71.987L246.423 23.985c18.467-32.009 64.72-31.951 83.154 0l239.94 416.028zM288 354c-25.405 0-46 20.595-46 46s20.595 46 46 46 46-20.595 46-46-20.595-46-46-46zm-43.673-165.346l7.418 136c.347 6.364 5.609 11.346 11.982 11.346h48.546c6.373 0 11.635-4.982 11.982-11.346l7.418-136c.375-6.874-5.098-12.654-11.982-12.654h-63.383c-6.884 0-12.356 5.78-11.981 12.654z"],
      "minus": [448, 512, [], "f068", "M424 318.2c13.3 0 24-10.7 24-24v-76.4c0-13.3-10.7-24-24-24H24c-13.3 0-24 10.7-24 24v76.4c0 13.3 10.7 24 24 24h400z"],
      "minus-circle": [512, 512, [], "f056", "M256 8C119 8 8 119 8 256s111 248 248 248 248-111 248-248S393 8 256 8zM124 296c-6.6 0-12-5.4-12-12v-56c0-6.6 5.4-12 12-12h264c6.6 0 12 5.4 12 12v56c0 6.6-5.4 12-12 12H124z"],
      "minus-square": [448, 512, [], "f146", "M400 32H48C21.5 32 0 53.5 0 80v352c0 26.5 21.5 48 48 48h352c26.5 0 48-21.5 48-48V80c0-26.5-21.5-48-48-48zM92 296c-6.6 0-12-5.4-12-12v-56c0-6.6 5.4-12 12-12h264c6.6 0 12 5.4 12 12v56c0 6.6-5.4 12-12 12H92z"],
      "plus": [448, 512, [], "f067", "M448 294.2v-76.4c0-13.3-10.7-24-24-24H286.2V56c0-13.3-10.7-24-24-24h-76.4c-13.3 0-24 10.7-24 24v137.8H24c-13.3 0-24 10.7-24 24v76.4c0 13.3 10.7 24 24 24h137.8V456c0 13.3 10.7 24 24 24h76.4c13.3 0 24-10.7 24-24V318.2H424c13.3 0 24-10.7 24-24z"],
      "plus-circle": [512, 512, [], "f055", "M256 8C119 8 8 119 8 256s111 248 248 248 248-111 248-248S393 8 256 8zm144 276c0 6.6-5.4 12-12 12h-92v92c0 6.6-5.4 12-12 12h-56c-6.6 0-12-5.4-12-12v-92h-92c-6.6 0-12-5.4-12-12v-56c0-6.6 5.4-12 12-12h92v-92c0-6.6 5.4-12 12-12h56c6.6 0 12 5.4 12 12v92h92c6.6 0 12 5.4 12 12v56z"],
      "plus-square": [448, 512, [], "f0fe", "M400 32H48C21.5 32 0 53.5 0 80v352c0 26.5 21.5 48 48 48h352c26.5 0 48-21.5 48-48V80c0-26.5-21.5-48-48-48zm-32 252c0 6.6-5.4 12-12 12h-92v92c0 6.6-5.4 12-12 12h-56c-6.6 0-12-5.4-12-12v-92H92c-6.6 0-12-5.4-12-12v-56c0-6.6 5.4-12 12-12h92v-92c0-6.6 5.4-12 12-12h56c6.6 0 12 5.4 12 12v92h92c6.6 0 12 5.4 12 12v56z"],
      "question": [384, 512, [], "f128", "M202.021 0C122.202 0 70.503 32.703 29.914 91.026c-7.363 10.58-5.093 25.086 5.178 32.874l43.138 32.709c10.373 7.865 25.132 6.026 33.253-4.148 25.049-31.381 43.63-49.449 82.757-49.449 30.764 0 68.816 19.799 68.816 49.631 0 22.552-18.617 34.134-48.993 51.164-35.423 19.86-82.299 44.576-82.299 106.405V320c0 13.255 10.745 24 24 24h72.471c13.255 0 24-10.745 24-24v-5.773c0-42.86 125.268-44.645 125.268-160.627C377.504 66.256 286.902 0 202.021 0zM192 373.459c-38.196 0-69.271 31.075-69.271 69.271 0 38.195 31.075 69.27 69.271 69.27s69.271-31.075 69.271-69.271-31.075-69.27-69.271-69.27z"],
      "save": [448, 512, [], "f0c7", "M433.941 129.941l-83.882-83.882A48 48 0 0 0 316.118 32H48C21.49 32 0 53.49 0 80v352c0 26.51 21.49 48 48 48h352c26.51 0 48-21.49 48-48V163.882a48 48 0 0 0-14.059-33.941zM224 416c-35.346 0-64-28.654-64-64 0-35.346 28.654-64 64-64s64 28.654 64 64c0 35.346-28.654 64-64 64zm96-304.52V212c0 6.627-5.373 12-12 12H76c-6.627 0-12-5.373-12-12V108c0-6.627 5.373-12 12-12h228.52c3.183 0 6.235 1.264 8.485 3.515l3.48 3.48A11.996 11.996 0 0 1 320 111.48z"],
      "search": [512, 512, [], "f002", "M505 442.7L405.3 343c-4.5-4.5-10.6-7-17-7H372c27.6-35.3 44-79.7 44-128C416 93.1 322.9 0 208 0S0 93.1 0 208s93.1 208 208 208c48.3 0 92.7-16.4 128-44v16.3c0 6.4 2.5 12.5 7 17l99.7 99.7c9.4 9.4 24.6 9.4 33.9 0l28.3-28.3c9.4-9.4 9.4-24.6.1-34zM208 336c-70.7 0-128-57.2-128-128 0-70.7 57.2-128 128-128 70.7 0 128 57.2 128 128 0 70.7-57.2 128-128 128z"],
      "share": [512, 512, [], "f064", "M503.691 189.836L327.687 37.851C312.281 24.546 288 35.347 288 56.015v80.053C127.371 137.907 0 170.1 0 322.326c0 61.441 39.581 122.309 83.333 154.132 13.653 9.931 33.111-2.533 28.077-18.631C66.066 312.814 132.917 274.316 288 272.085V360c0 20.7 24.3 31.453 39.687 18.164l176.004-152c11.071-9.562 11.086-26.753 0-36.328z"],
      "spinner": [512, 512, [], "f110", "M304 48c0 26.51-21.49 48-48 48s-48-21.49-48-48 21.49-48 48-48 48 21.49 48 48zm-48 368c-26.51 0-48 21.49-48 48s21.49 48 48 48 48-21.49 48-48-21.49-48-48-48zm208-208c-26.51 0-48 21.49-48 48s21.49 48 48 48 48-21.49 48-48-21.49-48-48-48zM96 256c0-26.51-21.49-48-48-48S0 229.49 0 256s21.49 48 48 48 48-21.49 48-48zm12.922 99.078c-26.51 0-48 21.49-48 48s21.49 48 48 48 48-21.49 48-48c0-26.509-21.491-48-48-48zm294.156 0c-26.51 0-48 21.49-48 48s21.49 48 48 48 48-21.49 48-48c0-26.509-21.49-48-48-48zM108.922 60.922c-26.51 0-48 21.49-48 48s21.49 48 48 48 48-21.49 48-48-21.491-48-48-48z"],
      "square": [448, 512, [], "f0c8", "M400 32H48C21.5 32 0 53.5 0 80v352c0 26.5 21.5 48 48 48h352c26.5 0 48-21.5 48-48V80c0-26.5-21.5-48-48-48z"],
      "square-full": [512, 512, [], "f45c", "M512 512H0V0h512v512z"],
      "times": [384, 512, [], "f00d", "M323.1 441l53.9-53.9c9.4-9.4 9.4-24.5 0-33.9L279.8 256l97.2-97.2c9.4-9.4 9.4-24.5 0-33.9L323.1 71c-9.4-9.4-24.5-9.4-33.9 0L192 168.2 94.8 71c-9.4-9.4-24.5-9.4-33.9 0L7 124.9c-9.4 9.4-9.4 24.5 0 33.9l97.2 97.2L7 353.2c-9.4 9.4-9.4 24.5 0 33.9L60.9 441c9.4 9.4 24.5 9.4 33.9 0l97.2-97.2 97.2 97.2c9.3 9.3 24.5 9.3 33.9 0z"],
      "times-circle": [512, 512, [], "f057", "M256 8C119 8 8 119 8 256s111 248 248 248 248-111 248-248S393 8 256 8zm121.6 313.1c4.7 4.7 4.7 12.3 0 17L338 377.6c-4.7 4.7-12.3 4.7-17 0L256 312l-65.1 65.6c-4.7 4.7-12.3 4.7-17 0L134.4 338c-4.7-4.7-4.7-12.3 0-17l65.6-65-65.6-65.1c-4.7-4.7-4.7-12.3 0-17l39.6-39.6c4.7-4.7 12.3-4.7 17 0l65 65.7 65.1-65.6c4.7-4.7 12.3-4.7 17 0l39.6 39.6c4.7 4.7 4.7 12.3 0 17L312 256l65.6 65.1z"],
      "wrench": [512, 512, [], "f0ad", "M481.156 200c9.3 0 15.12 10.155 10.325 18.124C466.295 259.992 420.419 288 368 288c-79.222 0-143.501-63.974-143.997-143.079C223.505 65.469 288.548-.001 368.002 0c52.362.001 98.196 27.949 123.4 69.743C496.24 77.766 490.523 88 481.154 88H376l-40 56 40 56h105.156zm-171.649 93.003L109.255 493.255c-24.994 24.993-65.515 24.994-90.51 0-24.993-24.994-24.993-65.516 0-90.51L218.991 202.5c16.16 41.197 49.303 74.335 90.516 90.503zM104 432c0-13.255-10.745-24-24-24s-24 10.745-24 24 10.745 24 24 24 24-10.745 24-24z"]
    };

    function attachDialogCloseHandlerWithParent(parent, closeHandler) {
      var container = document.createElement("div");
      parent.appendChild(container);
      container.appendChild(createIcon("times"));
      container.addEventListener('click', function (e) {
        e.preventDefault();
        e.stopPropagation();
        closeHandler();
      });
    }
    /**
     * Make the target element movable by clicking and dragging on the handle.  This is not a general purprose function,
     * it makes several options specific to igv dialogs, the primary one being that the
     * target is absolutely positioned in pixel coordinates

     */


    let dragData; // Its assumed we are only dragging one element at a time.

    function makeDraggable(target, handle) {
      handle.addEventListener('mousedown', dragStart.bind(target));
    }

    function dragStart(event) {
      event.stopPropagation();
      event.preventDefault();
      offset(this);
      const dragFunction = drag.bind(this);
      const dragEndFunction = dragEnd.bind(this);
      const computedStyle = getComputedStyle(this);
      const top = parseInt(computedStyle.top.replace("px", ""));
      const left = parseInt(computedStyle.left.replace("px", ""));
      dragData = {
        dragFunction: dragFunction,
        dragEndFunction: dragEndFunction,
        screenX: event.screenX,
        screenY: event.screenY,
        top: top,
        left: left
      };
      document.addEventListener('mousemove', dragFunction);
      document.addEventListener('mouseup', dragEndFunction);
      document.addEventListener('mouseleave', dragEndFunction);
      document.addEventListener('mouseexit', dragEndFunction);
    }

    function drag(event) {
      if (!dragData) {
        console.log("No drag data!");
        return;
      }

      event.stopPropagation();
      event.preventDefault();
      const dx = event.screenX - dragData.screenX;
      const dy = event.screenY - dragData.screenY;
      this.style.left = `${dragData.left + dx}px`;
      this.style.top = `${dragData.top + dy}px`;
    }

    function dragEnd(event) {
      if (!dragData) {
        console.log("No drag data!");
        return;
      }

      event.stopPropagation();
      event.preventDefault();
      const dragFunction = dragData.dragFunction;
      const dragEndFunction = dragData.dragEndFunction;
      document.removeEventListener('mousemove', dragFunction);
      document.removeEventListener('mouseup', dragEndFunction);
      document.removeEventListener('mouseleave', dragEndFunction);
      document.removeEventListener('mouseexit', dragEndFunction);
      dragData = undefined;
    }

    const httpMessages = {
      "401": "Access unauthorized",
      "403": "Access forbidden",
      "404": "Not found"
    };

    class AlertDialog {
      /**
       * Initialize a new alert dialog
       * @param parent
       * @param alertProps - Optional - properties such as scroll to error
       */
      constructor(parent, alertProps) {
        this.alertProps = Object.assign({
          /** When an alert is presented - focus occur */
          shouldFocus: true,

          /** When focus occur - scroll into that element in the view */
          preventScroll: false
        }, alertProps); // container

        this.container = div({
          class: "igv-ui-alert-dialog-container"
        });
        parent.appendChild(this.container);
        this.container.setAttribute('tabIndex', '-1'); // header

        const header = div();
        this.container.appendChild(header);
        this.errorHeadline = div();
        header.appendChild(this.errorHeadline);
        this.errorHeadline.textContent = ''; // body container

        let bodyContainer = div({
          class: 'igv-ui-alert-dialog-body'
        });
        this.container.appendChild(bodyContainer); // body copy

        this.body = div({
          class: 'igv-ui-alert-dialog-body-copy'
        });
        bodyContainer.appendChild(this.body); // ok container

        let ok_container = div();
        this.container.appendChild(ok_container); // ok

        this.ok = div();
        ok_container.appendChild(this.ok);
        this.ok.textContent = 'OK';

        const okHandler = () => {
          if (typeof this.callback === 'function') {
            this.callback("OK");
            this.callback = undefined;
          }

          this.body.innerHTML = '';
          hide(this.container);
        };

        this.ok.addEventListener('click', event => {
          event.stopPropagation();
          okHandler();
        });
        this.container.addEventListener('keypress', event => {
          event.stopPropagation();

          if ('Enter' === event.key) {
            okHandler();
          }
        });
        makeDraggable(this.container, header);
        hide(this.container);
      }

      present(alert, callback) {
        this.errorHeadline.textContent = alert.message ? 'ERROR' : '';
        let string = alert.message || alert;

        if (httpMessages.hasOwnProperty(string)) {
          string = httpMessages[string];
        }

        this.body.innerHTML = string;
        this.callback = callback;
        show(this.container);

        if (this.alertProps.shouldFocus) {
          this.container.focus({
            preventScroll: this.alertProps.preventScroll
          });
        }
      }

    }

    let alertDialog;
    const Alert = {
      init(root, config = {}) {
        alertDialog = new AlertDialog(root, config);
      },

      presentAlert(alert, callback) {
        if (!alertDialog) {
          this.init(document.body);
        }

        alertDialog.present(alert, callback);
      }

    };

    class InputDialog {
      constructor(parent) {
        this.parent = parent; // dialog container

        this.container = div({
          class: 'igv-ui-generic-dialog-container'
        });
        parent.appendChild(this.container); // const { x, y, width, height } = this.container.getBoundingClientRect();
        // console.log(`InputDialog - x ${ x } y ${ y } width ${ width } height ${ height }`)
        // dialog header

        const header = div({
          class: 'igv-ui-generic-dialog-header'
        });
        this.container.appendChild(header); // dialog label

        this.label = div({
          class: 'igv-ui-generic-dialog-one-liner'
        });
        this.container.appendChild(this.label);
        this.label.text = 'Unlabeled'; // input container

        this.input_container = div({
          class: 'igv-ui-generic-dialog-input'
        });
        this.container.appendChild(this.input_container); //

        this.input = document.createElement("input");
        this.input_container.appendChild(this.input); // ok | cancel

        const buttons = div({
          class: 'igv-ui-generic-dialog-ok-cancel'
        });
        this.container.appendChild(buttons); // ok

        this.ok = div();
        buttons.appendChild(this.ok);
        this.ok.textContent = 'OK'; // cancel

        this.cancel = div();
        buttons.appendChild(this.cancel);
        this.cancel.textContent = 'Cancel';
        hide(this.container);
        this.input.addEventListener('keyup', e => {
          if (13 === e.keyCode) {
            if (typeof this.callback === 'function') {
              this.callback(this.input.value);
              this.callback = undefined;
            }

            this.input.value = undefined;
            hide(this.container);
          }
        });
        this.ok.addEventListener('click', () => {
          if (typeof this.callback === 'function') {
            this.callback(this.input.value);
            this.callback = undefined;
          }

          this.input.value = undefined;
          hide(this.container);
        });

        const cancel = () => {
          this.input.value = '';
          hide(this.container);
        };

        this.cancel.addEventListener('click', cancel);
        attachDialogCloseHandlerWithParent(header, cancel);
        makeDraggable(this.container, header);
      }

      present(options, e) {
        this.label.textContent = options.label;
        this.input.value = options.value;
        this.callback = options.callback || options.click;
        show(this.container);
        const {
          x,
          y
        } = pageCoordinates(e);
        this.clampLocation(x, y);
      }

      clampLocation(pageX, pageY) {
        const {
          width: w,
          height: h
        } = this.container.getBoundingClientRect();
        const {
          x: px,
          y: py,
          width: pw,
          height: ph
        } = this.parent.getBoundingClientRect();
        const y = Math.min(Math.max(pageY, py), py + ph - h);
        const x = Math.min(Math.max(pageX, px), px + pw - w);
        this.container.style.left = `${x}px`;
        this.container.style.top = `${y}px`;
      }

    }

    const appleCrayonPalette = {
      licorice: "#000000",
      lead: "#1e1e1e",
      tungsten: "#3a3a3a",
      iron: "#545453",
      steel: "#6e6e6e",
      tin: "#878687",
      nickel: "#888787",
      aluminum: "#a09fa0",
      magnesium: "#b8b8b8",
      silver: "#d0d0d0",
      mercury: "#e8e8e8",
      snow: "#ffffff",
      //
      cayenne: "#891100",
      mocha: "#894800",
      aspargus: "#888501",
      fern: "#458401",
      clover: "#028401",
      moss: "#018448",
      teal: "#008688",
      ocean: "#004a88",
      midnight: "#001888",
      eggplant: "#491a88",
      plum: "#891e88",
      maroon: "#891648",
      //
      maraschino: "#ff2101",
      tangerine: "#ff8802",
      lemon: "#fffa03",
      lime: "#83f902",
      spring: "#05f802",
      seam_foam: "#03f987",
      turquoise: "#00fdff",
      aqua: "#008cff",
      blueberry: "#002eff",
      grape: "#8931ff",
      magenta: "#ff39ff",
      strawberry: "#ff2987",
      //
      salmon: "#ff726e",
      cantaloupe: "#ffce6e",
      banana: "#fffb6d",
      honeydew: "#cefa6e",
      flora: "#68f96e",
      spindrift: "#68fbd0",
      ice: "#68fdff",
      sky: "#6acfff",
      orchid: "#6e76ff",
      lavender: "#d278ff",
      bubblegum: "#ff7aff",
      carnation: "#ff7fd3"
    }; //import { DOMUtils, UIUtils, makeDraggable } from '../node_modules/igv-utils/src/index.js'

    class GenericContainer {
      constructor({
        parent,
        top,
        left,
        width,
        height,
        border,
        closeHandler
      }) {
        let container = div({
          class: 'igv-ui-generic-container'
        });
        parent.appendChild(container);
        hide(container);
        this.container = container;

        if (top !== undefined) {
          this.container.style.top = `${top}px`;
        }

        if (left !== undefined) {
          this.container.style.left = `${left}px`;
        }

        if (width !== undefined) {
          this.container.style.width = `${width}px`;
        }

        if (height !== undefined) {
          this.container.style.height = `${height}px`;
        }

        if (border) {
          this.container.style.border = border;
        } //
        // let bbox = parent.getBoundingClientRect();
        // this.origin = {x: bbox.x, y: bbox.y};
        // this.container.offset({left: this.origin.x, top: this.origin.y});
        // header


        const header = div();
        this.container.appendChild(header); // close button

        attachDialogCloseHandlerWithParent(header, e => {
          hide(this.container);

          if (typeof closeHandler === "function") {
            closeHandler(e);
          }
        });
        makeDraggable(this.container, header);
      }

      show() {
        show(this.container);
      }

      hide() {
        hide(this.container);
      }

      dispose() {
        if (this.container.parent) {
          this.container.parent.removeChild(this.container);
        }
      }

    }

    class ColorPicker extends GenericContainer {
      constructor({
        parent,
        top,
        left,
        width,
        height,
        defaultColors,
        colorHandler
      }) {
        super({
          parent,
          top,
          left,
          width,
          height,
          border: '1px solid gray'
        });
        createColorSwatchSelector(this.container, colorHandler, defaultColors);
      }

    }

    const createColorSwatchSelector = (container, colorHandler, defaultColors) => {
      const hexColorStrings = Object.values(appleCrayonPalette);

      for (let hexColorString of hexColorStrings) {
        const swatch = div({
          class: 'igv-ui-color-swatch'
        });
        container.appendChild(swatch);
        decorateSwatch(swatch, hexColorString, colorHandler);
      }

      if (defaultColors) {
        for (let hexColorString of defaultColors) {
          const swatch = div({
            class: 'igv-ui-color-swatch'
          });
          container.appendChild(swatch);
          decorateSwatch(swatch, hexColorString, colorHandler);
        }
      }
    };

    const decorateSwatch = (swatch, hexColorString, colorHandler) => {
      swatch.style.backgroundColor = hexColorString;
      swatch.addEventListener('mouseenter', e => swatch.style.borderColor = hexColorString);
      swatch.addEventListener('mouseleave', e => swatch.style.borderColor = 'white');
      swatch.addEventListener('click', event => {
        event.stopPropagation();
        colorHandler(hexColorString);
      });
      swatch.addEventListener('touchend', event => {
        event.stopPropagation();
        colorHandler(hexColorString);
      });
    };

    class Popover {
      constructor(parent, title) {
        this.parent = parent; // popover

        this.popover = div({
          class: "igv-ui-popover"
        });
        parent.appendChild(this.popover); // header

        const popoverHeader = div();
        this.popover.appendChild(popoverHeader);
        const titleElement = div();
        popoverHeader.appendChild(titleElement);

        if (title) {
          titleElement.textContent = title;
        }

        attachDialogCloseHandlerWithParent(popoverHeader, () => this.hide());
        makeDraggable(this.popover, popoverHeader); // content

        this.popoverContent = div();
        this.popover.appendChild(this.popoverContent);
        this.popover.style.display = 'none';
      }

      presentContentWithEvent(e, content) {
        this.popover.style.display = 'block';
        this.popoverContent.innerHTML = content;
        present$1(e, this.popover, this.popoverContent);
      }

      presentMenu(e, menuItems) {
        if (0 === menuItems.length) {
          return;
        }

        this.popover.style.display = 'block';
        const menuElements = createMenuElements$1(menuItems, this.popover);

        for (let item of menuElements) {
          this.popoverContent.appendChild(item.object);
        }

        present$1(e, this.popover, this.popoverContent);
      }

      hide() {
        this.popover.style.display = 'none';
        this.dispose();
      }

      dispose() {
        if (this.popover) {
          this.popover.parentNode.removeChild(this.popover);
        }

        const keys = Object.keys(this);

        for (let key of keys) {
          this[key] = undefined;
        }
      }

    }

    function present$1(e, popover, popoverContent) {
      const {
        x,
        y,
        width
      } = translateMouseCoordinates(e, popover.parentNode);
      popover.style.top = `${y}px`;
      const {
        width: w
      } = popover.getBoundingClientRect();
      const xmax = x + w;
      const delta = xmax - width;
      popover.style.left = `${xmax > width ? x - delta : x}px`;
      popoverContent.style.maxWidth = `${Math.min(w, width)}px`;
    }

    function createMenuElements$1(itemList, popover) {
      const list = itemList.map(function (item, i) {
        let elem;

        if (typeof item === 'string') {
          elem = div();
          elem.innerHTML = item;
        } else if (typeof item === 'Node') {
          elem = item;
        } else {
          if (typeof item.init === 'function') {
            item.init();
          }

          if ("checkbox" === item.type) {
            elem = createCheckbox("Show all bases", item.value);
          } else if ("color" === item.type) {
            const colorPicker = new ColorPicker({
              parent: popover.parentElement,
              width: 364,
              //defaultColor: 'aqua',
              colorHandler: color => item.click(color)
            });
            elem = div();

            if (typeof item.label === 'string') {
              elem.innerHTML = item.label;
            }

            const clickHandler = e => {
              colorPicker.show();
              hide(popover);
              e.preventDefault();
              e.stopPropagation();
            };

            elem.addEventListener('click', clickHandler);
            elem.addEventListener('touchend', clickHandler);
            elem.addEventListener('mouseup', function (e) {
              e.preventDefault();
              e.stopPropagation();
            });
          } else {
            elem = div();

            if (typeof item.label === 'string') {
              elem.innerHTML = item.label;
            }
          }

          if (item.click && "color" !== item.type) {
            elem.addEventListener('click', handleClick);
            elem.addEventListener('touchend', handleClick);
            elem.addEventListener('mouseup', function (e) {
              e.preventDefault();
              e.stopPropagation();
            }); // eslint-disable-next-line no-inner-declarations

            function handleClick(e) {
              item.click();
              hide(popover);
              e.preventDefault();
              e.stopPropagation();
            }
          }
        }

        return {
          object: elem,
          init: item.init
        };
      });
      return list;
    }

    function embedCSS$2() {
      var css = '.igv-ui-popover {\n  cursor: default;\n  position: absolute;\n  z-index: 2048;\n  border-color: #7F7F7F;\n  border-radius: 4px;\n  border-style: solid;\n  border-width: 1px;\n  font-family: \"Open Sans\", sans-serif;\n  font-size: small;\n  background-color: white; }\n  .igv-ui-popover > div:first-child {\n    display: flex;\n    flex-direction: row;\n    flex-wrap: nowrap;\n    justify-content: space-between;\n    align-items: center;\n    width: 100%;\n    height: 24px;\n    cursor: move;\n    border-top-left-radius: 4px;\n    border-top-right-radius: 4px;\n    border-bottom-color: #7F7F7F;\n    border-bottom-style: solid;\n    border-bottom-width: thin;\n    background-color: #eee; }\n    .igv-ui-popover > div:first-child > div:first-child {\n      margin-left: 4px; }\n    .igv-ui-popover > div:first-child > div:last-child {\n      margin-right: 4px;\n      height: 12px;\n      width: 12px;\n      color: #7F7F7F; }\n    .igv-ui-popover > div:first-child > div:last-child:hover {\n      cursor: pointer;\n      color: #444; }\n  .igv-ui-popover > div:last-child {\n    overflow-y: auto;\n    overflow-x: hidden;\n    max-height: 400px;\n    max-width: 800px;\n    background-color: white; }\n    .igv-ui-popover > div:last-child > div {\n      -webkit-user-select: text;\n      -moz-user-select: text;\n      -ms-user-select: text;\n      user-select: text;\n      margin-left: 4px;\n      margin-right: 4px;\n      min-width: 220px;\n      overflow-x: hidden;\n      text-overflow: ellipsis;\n      white-space: nowrap; }\n      .igv-ui-popover > div:last-child > div > span {\n        font-weight: bolder; }\n    .igv-ui-popover > div:last-child hr {\n      width: 100%; }\n\n.igv-ui-alert-dialog-container {\n  box-sizing: content-box;\n  position: absolute;\n  z-index: 2048;\n  top: 50%;\n  left: 50%;\n  width: 400px;\n  height: 200px;\n  border-color: #7F7F7F;\n  border-radius: 4px;\n  border-style: solid;\n  border-width: thin;\n  outline: none;\n  font-family: \"Open Sans\", sans-serif;\n  font-size: 15px;\n  font-weight: 400;\n  background-color: white;\n  display: flex;\n  flex-flow: column;\n  flex-wrap: nowrap;\n  justify-content: space-between;\n  align-items: center; }\n  .igv-ui-alert-dialog-container > div:first-child {\n    display: flex;\n    flex-flow: row;\n    flex-wrap: nowrap;\n    justify-content: flex-start;\n    align-items: center;\n    width: 100%;\n    height: 24px;\n    cursor: move;\n    border-top-left-radius: 4px;\n    border-top-right-radius: 4px;\n    border-bottom-color: #7F7F7F;\n    border-bottom-style: solid;\n    border-bottom-width: thin;\n    background-color: #eee; }\n    .igv-ui-alert-dialog-container > div:first-child div:first-child {\n      padding-left: 8px; }\n  .igv-ui-alert-dialog-container .igv-ui-alert-dialog-body {\n    -webkit-user-select: text;\n    -moz-user-select: text;\n    -ms-user-select: text;\n    user-select: text;\n    color: #373737;\n    width: 100%;\n    height: calc(100% - 24px - 64px);\n    overflow-y: scroll; }\n    .igv-ui-alert-dialog-container .igv-ui-alert-dialog-body .igv-ui-alert-dialog-body-copy {\n      margin: 16px;\n      width: auto;\n      height: auto;\n      overflow-wrap: break-word;\n      word-break: break-word;\n      background-color: white;\n      border: unset; }\n  .igv-ui-alert-dialog-container > div:last-child {\n    width: 100%;\n    margin-bottom: 10px;\n    background-color: white;\n    display: flex;\n    flex-flow: row;\n    flex-wrap: nowrap;\n    justify-content: center;\n    align-items: center; }\n    .igv-ui-alert-dialog-container > div:last-child div {\n      margin: unset;\n      width: 40px;\n      height: 30px;\n      line-height: 30px;\n      text-align: center;\n      color: white;\n      font-family: \"Open Sans\", sans-serif;\n      font-size: small;\n      font-weight: 400;\n      border-color: #2B81AF;\n      border-style: solid;\n      border-width: thin;\n      border-radius: 4px;\n      background-color: #2B81AF; }\n    .igv-ui-alert-dialog-container > div:last-child div:hover {\n      cursor: pointer;\n      border-color: #25597f;\n      background-color: #25597f; }\n\n.igv-ui-color-swatch {\n  position: relative;\n  box-sizing: content-box;\n  display: flex;\n  flex-flow: row;\n  flex-wrap: wrap;\n  justify-content: center;\n  align-items: center;\n  width: 32px;\n  height: 32px;\n  border-style: solid;\n  border-width: 2px;\n  border-color: white;\n  border-radius: 4px; }\n\n.igv-ui-color-swatch:hover {\n  border-color: dimgray; }\n\n.igv-ui-colorpicker-menu-close-button {\n  display: flex;\n  flex-flow: row;\n  flex-wrap: nowrap;\n  justify-content: flex-end;\n  align-items: center;\n  width: 100%;\n  height: 32px;\n  margin-top: 4px;\n  margin-bottom: 4px;\n  padding-right: 8px; }\n  .igv-ui-colorpicker-menu-close-button i.fa {\n    display: block;\n    margin-left: 4px;\n    margin-right: 4px;\n    color: #5f5f5f; }\n  .igv-ui-colorpicker-menu-close-button i.fa:hover,\n  .igv-ui-colorpicker-menu-close-button i.fa:focus,\n  .igv-ui-colorpicker-menu-close-button i.fa:active {\n    cursor: pointer;\n    color: #0f0f0f; }\n\n.igv-ui-generic-dialog-container {\n  box-sizing: content-box;\n  position: fixed;\n  top: 0;\n  left: 0;\n  width: 300px;\n  height: 200px;\n  border-color: #7F7F7F;\n  border-radius: 4px;\n  border-style: solid;\n  border-width: thin;\n  font-family: \"Open Sans\", sans-serif;\n  font-size: medium;\n  font-weight: 400;\n  z-index: 2048;\n  background-color: white;\n  display: flex;\n  flex-flow: column;\n  flex-wrap: nowrap;\n  justify-content: flex-start;\n  align-items: center; }\n  .igv-ui-generic-dialog-container .igv-ui-generic-dialog-header {\n    display: flex;\n    flex-flow: row;\n    flex-wrap: nowrap;\n    justify-content: flex-end;\n    align-items: center;\n    width: 100%;\n    height: 24px;\n    cursor: move;\n    border-top-left-radius: 4px;\n    border-top-right-radius: 4px;\n    border-bottom-color: #7F7F7F;\n    border-bottom-style: solid;\n    border-bottom-width: thin;\n    background-color: #eee; }\n    .igv-ui-generic-dialog-container .igv-ui-generic-dialog-header div {\n      margin-right: 4px;\n      margin-bottom: 2px;\n      height: 12px;\n      width: 12px;\n      color: #7F7F7F; }\n    .igv-ui-generic-dialog-container .igv-ui-generic-dialog-header div:hover {\n      cursor: pointer;\n      color: #444; }\n  .igv-ui-generic-dialog-container .igv-ui-generic-dialog-one-liner {\n    color: #373737;\n    width: 95%;\n    height: 24px;\n    line-height: 24px;\n    text-align: left;\n    margin-top: 8px;\n    padding-left: 8px;\n    overflow-wrap: break-word;\n    background-color: white; }\n  .igv-ui-generic-dialog-container .igv-ui-generic-dialog-label-input {\n    margin-top: 8px;\n    width: 95%;\n    height: 24px;\n    color: #373737;\n    line-height: 24px;\n    padding-left: 8px;\n    background-color: white;\n    display: flex;\n    flex-flow: row;\n    flex-wrap: nowrap;\n    justify-content: flex-start;\n    align-items: center; }\n    .igv-ui-generic-dialog-container .igv-ui-generic-dialog-label-input div {\n      width: 30%;\n      height: 100%;\n      font-size: 16px;\n      text-align: right;\n      padding-right: 8px;\n      background-color: white; }\n    .igv-ui-generic-dialog-container .igv-ui-generic-dialog-label-input input {\n      display: block;\n      height: 100%;\n      width: 100%;\n      padding-left: 4px;\n      font-family: \"Open Sans\", sans-serif;\n      font-weight: 400;\n      color: #373737;\n      text-align: left;\n      outline: none;\n      border-style: solid;\n      border-width: thin;\n      border-color: #7F7F7F;\n      background-color: white; }\n    .igv-ui-generic-dialog-container .igv-ui-generic-dialog-label-input input {\n      width: 50%;\n      font-size: 16px; }\n  .igv-ui-generic-dialog-container .igv-ui-generic-dialog-input {\n    margin-top: 8px;\n    width: calc(100% - 16px);\n    height: 24px;\n    color: #373737;\n    line-height: 24px;\n    display: flex;\n    flex-flow: row;\n    flex-wrap: nowrap;\n    justify-content: space-around;\n    align-items: center; }\n    .igv-ui-generic-dialog-container .igv-ui-generic-dialog-input input {\n      display: block;\n      height: 100%;\n      width: 100%;\n      padding-left: 4px;\n      font-family: \"Open Sans\", sans-serif;\n      font-weight: 400;\n      color: #373737;\n      text-align: left;\n      outline: none;\n      border-style: solid;\n      border-width: thin;\n      border-color: #7F7F7F;\n      background-color: white; }\n    .igv-ui-generic-dialog-container .igv-ui-generic-dialog-input input {\n      font-size: 16px; }\n  .igv-ui-generic-dialog-container .igv-ui-generic-dialog-ok-cancel {\n    width: 100%;\n    height: 28px;\n    display: flex;\n    flex-flow: row;\n    flex-wrap: nowrap;\n    justify-content: space-around;\n    align-items: center; }\n    .igv-ui-generic-dialog-container .igv-ui-generic-dialog-ok-cancel div {\n      margin-top: 32px;\n      color: white;\n      font-family: \"Open Sans\", sans-serif;\n      font-size: 14px;\n      font-weight: 400;\n      width: 75px;\n      height: 28px;\n      line-height: 28px;\n      text-align: center;\n      border-color: transparent;\n      border-style: solid;\n      border-width: thin;\n      border-radius: 2px; }\n    .igv-ui-generic-dialog-container .igv-ui-generic-dialog-ok-cancel div:first-child {\n      margin-left: 32px;\n      margin-right: 0;\n      background-color: #5ea4e0; }\n    .igv-ui-generic-dialog-container .igv-ui-generic-dialog-ok-cancel div:last-child {\n      margin-left: 0;\n      margin-right: 32px;\n      background-color: #c4c4c4; }\n    .igv-ui-generic-dialog-container .igv-ui-generic-dialog-ok-cancel div:first-child:hover {\n      cursor: pointer;\n      background-color: #3b5c7f; }\n    .igv-ui-generic-dialog-container .igv-ui-generic-dialog-ok-cancel div:last-child:hover {\n      cursor: pointer;\n      background-color: #7f7f7f; }\n  .igv-ui-generic-dialog-container .igv-ui-generic-dialog-ok {\n    width: 100%;\n    height: 36px;\n    margin-top: 32px;\n    display: flex;\n    flex-flow: row;\n    flex-wrap: nowrap;\n    justify-content: space-around;\n    align-items: center; }\n    .igv-ui-generic-dialog-container .igv-ui-generic-dialog-ok div {\n      width: 98px;\n      height: 36px;\n      line-height: 36px;\n      text-align: center;\n      color: white;\n      font-family: \"Open Sans\", sans-serif;\n      font-size: medium;\n      font-weight: 400;\n      border-color: white;\n      border-style: solid;\n      border-width: thin;\n      border-radius: 4px;\n      background-color: #2B81AF; }\n    .igv-ui-generic-dialog-container .igv-ui-generic-dialog-ok div:hover {\n      cursor: pointer;\n      background-color: #25597f; }\n\n.igv-ui-generic-container {\n  box-sizing: content-box;\n  position: absolute;\n  z-index: 2048;\n  background-color: white;\n  cursor: pointer;\n  display: flex;\n  flex-direction: row;\n  flex-wrap: wrap;\n  justify-content: flex-start;\n  align-items: center; }\n  .igv-ui-generic-container > div:first-child {\n    cursor: move;\n    display: flex;\n    flex-flow: row;\n    flex-wrap: nowrap;\n    justify-content: flex-end;\n    align-items: center;\n    height: 24px;\n    width: 100%;\n    background-color: #dddddd; }\n    .igv-ui-generic-container > div:first-child > div {\n      display: block;\n      color: #5f5f5f;\n      cursor: pointer;\n      width: 14px;\n      height: 14px;\n      margin-right: 8px;\n      margin-bottom: 4px; }\n\n.igv-ui-dialog {\n  z-index: 2048;\n  position: fixed;\n  width: fit-content;\n  height: fit-content;\n  display: flex;\n  flex-flow: column;\n  flex-wrap: nowrap;\n  justify-content: flex-start;\n  background-color: white;\n  border-color: #7F7F7F;\n  border-radius: 4px;\n  border-style: solid;\n  border-width: thin;\n  font-family: \"Open Sans\", sans-serif;\n  font-size: medium;\n  font-weight: 400; }\n  .igv-ui-dialog .igv-ui-dialog-header {\n    display: flex;\n    flex-flow: row;\n    flex-wrap: nowrap;\n    justify-content: flex-end;\n    align-items: center;\n    width: 100%;\n    height: 24px;\n    cursor: move;\n    border-top-left-radius: 4px;\n    border-top-right-radius: 4px;\n    border-bottom-color: #7F7F7F;\n    border-bottom-style: solid;\n    border-bottom-width: thin;\n    background-color: #eee; }\n    .igv-ui-dialog .igv-ui-dialog-header div {\n      margin-right: 4px;\n      margin-bottom: 2px;\n      height: 12px;\n      width: 12px;\n      color: #7F7F7F; }\n    .igv-ui-dialog .igv-ui-dialog-header div:hover {\n      cursor: pointer;\n      color: #444; }\n  .igv-ui-dialog .igv-ui-dialog-one-liner {\n    width: 95%;\n    height: 24px;\n    line-height: 24px;\n    text-align: left;\n    margin: 8px;\n    overflow-wrap: break-word;\n    background-color: white;\n    font-weight: bold; }\n  .igv-ui-dialog .igv-ui-dialog-ok-cancel {\n    width: 100%;\n    display: flex;\n    flex-flow: row;\n    flex-wrap: nowrap;\n    justify-content: space-around;\n    align-items: center; }\n    .igv-ui-dialog .igv-ui-dialog-ok-cancel div {\n      margin: 16px;\n      margin-top: 32px;\n      color: white;\n      font-family: \"Open Sans\", sans-serif;\n      font-size: 14px;\n      font-weight: 400;\n      width: 75px;\n      height: 28px;\n      line-height: 28px;\n      text-align: center;\n      border-color: transparent;\n      border-style: solid;\n      border-width: thin;\n      border-radius: 2px; }\n    .igv-ui-dialog .igv-ui-dialog-ok-cancel div:first-child {\n      background-color: #5ea4e0; }\n    .igv-ui-dialog .igv-ui-dialog-ok-cancel div:last-child {\n      background-color: #c4c4c4; }\n    .igv-ui-dialog .igv-ui-dialog-ok-cancel div:first-child:hover {\n      cursor: pointer;\n      background-color: #3b5c7f; }\n    .igv-ui-dialog .igv-ui-dialog-ok-cancel div:last-child:hover {\n      cursor: pointer;\n      background-color: #7f7f7f; }\n  .igv-ui-dialog .igv-ui-dialog-ok {\n    width: 100%;\n    height: 36px;\n    margin-top: 32px;\n    display: flex;\n    flex-flow: row;\n    flex-wrap: nowrap;\n    justify-content: space-around;\n    align-items: center; }\n    .igv-ui-dialog .igv-ui-dialog-ok div {\n      width: 98px;\n      height: 36px;\n      line-height: 36px;\n      text-align: center;\n      color: white;\n      font-family: \"Open Sans\", sans-serif;\n      font-size: medium;\n      font-weight: 400;\n      border-color: white;\n      border-style: solid;\n      border-width: thin;\n      border-radius: 4px;\n      background-color: #2B81AF; }\n    .igv-ui-dialog .igv-ui-dialog-ok div:hover {\n      cursor: pointer;\n      background-color: #25597f; }\n\n.igv-ui-panel, .igv-ui-panel-column, .igv-ui-panel-row {\n  z-index: 2048;\n  background-color: white;\n  font-family: \"Open Sans\", sans-serif;\n  font-size: medium;\n  font-weight: 400;\n  display: flex;\n  justify-content: flex-start;\n  align-items: flex-start; }\n\n.igv-ui-panel-column {\n  display: flex;\n  flex-direction: column; }\n\n.igv-ui-panel-row {\n  display: flex;\n  flex-direction: row; }\n\n.igv-ui-textbox {\n  background-color: white;\n  font-family: \"Open Sans\", sans-serif;\n  font-size: medium;\n  font-weight: 400;\n  display: flex;\n  justify-content: flex-start;\n  align-items: flex-start; }\n\n/*# sourceMappingURL=igv-ui.css.map */\n';
      var style = document.createElement('style');
      style.setAttribute('type', 'text/css');
      style.innerHTML = css;
      document.head.insertBefore(style, document.head.childNodes[document.head.childNodes.length - 1]);
    }

    if (typeof document !== 'undefined') {
      if (!stylesheetExists("igv-ui.css")) {
        // console.log('igv-ui. will call embedCSS() ...');
        embedCSS$2(); // console.log('... done.');
      }

      function stylesheetExists(stylesheetName) {
        for (let ss of document.styleSheets) {
          ss = ss.href ? ss.href.replace(/^.*[\\\/]/, '') : '';

          if (ss === stylesheetName) {
            return true;
          }
        }

        return false;
      }
    }

    /*
     * The MIT License (MIT)
     *
     * Copyright (c) 2016-2017 The Regents of the University of California
     * Author: Jim Robinson
     *
     * Permission is hereby granted, free of charge, to any person obtaining a copy
     * of this software and associated documentation files (the "Software"), to deal
     * in the Software without restriction, including without limitation the rights
     * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
     * copies of the Software, and to permit persons to whom the Software is
     * furnished to do so, subject to the following conditions:
     *
     * The above copyright notice and this permission notice shall be included in
     * all copies or substantial portions of the Software.
     *
     *
     * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
     * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
     * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
     * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
     * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
     * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
     * THE SOFTWARE.
     */

    class DataRangeDialog {
      constructor($parent, alert) {
        // dialog container
        this.$container = $$1("<div>", {
          class: 'igv-generic-dialog-container'
        });
        $parent.append(this.$container);
        this.$container.offset({
          left: 0,
          top: 0
        }); // dialog header

        const $header = $$1("<div>", {
          class: 'igv-generic-dialog-header'
        });
        this.$container.append($header);
        attachDialogCloseHandlerWithParent$1($header[0], () => {
          this.$minimum_input.val(undefined);
          this.$maximum_input.val(undefined);
          this.$container.offset({
            left: 0,
            top: 0
          });
          this.$container.hide();
        }); // minimun

        this.$minimum = $$1("<div>", {
          class: 'igv-generic-dialog-label-input'
        });
        this.$container.append(this.$minimum);
        const $mindiv = $$1('<div>');
        $mindiv.text('Minimum');
        this.$minimum.append($mindiv);
        this.$minimum_input = $$1("<input>");
        this.$minimum.append(this.$minimum_input); // maximum

        this.$maximum = $$1("<div>", {
          class: 'igv-generic-dialog-label-input'
        });
        this.$container.append(this.$maximum);
        const $maxdiv = $$1('<div>');
        $maxdiv.text('Maximum');
        this.$maximum.append($maxdiv);
        this.$maximum_input = $$1("<input>");
        this.$maximum.append(this.$maximum_input); // ok | cancel

        const $buttons = $$1("<div>", {
          class: 'igv-generic-dialog-ok-cancel'
        });
        this.$container.append($buttons); // ok

        this.$ok = $$1("<div>");
        $buttons.append(this.$ok);
        this.$ok.text('OK'); // cancel

        this.$cancel = $$1("<div>");
        $buttons.append(this.$cancel);
        this.$cancel.text('Cancel');
        this.$cancel.on('click', () => {
          this.$minimum_input.val(undefined);
          this.$maximum_input.val(undefined);
          this.$container.offset({
            left: 0,
            top: 0
          });
          this.$container.hide();
        }); //this.$container.draggable({ handle:$header.get(0) });

        makeDraggable$1(this.$container.get(0), $header.get(0));
        this.$container.hide();
      }

      configure(trackView) {
        const dataRange = trackView.dataRange();
        let min;
        let max;

        if (dataRange) {
          min = dataRange.min;
          max = dataRange.max;
        } else {
          min = 0;
          max = 100;
        }

        this.$minimum_input.val(min);
        this.$maximum_input.val(max);
        this.$minimum_input.unbind();
        this.$minimum_input.on('keyup', e => {
          if (13 === e.keyCode) {
            this.processResults(trackView);
          }
        });
        this.$maximum_input.unbind();
        this.$maximum_input.on('keyup', e => {
          if (13 === e.keyCode) {
            this.processResults(trackView);
          }
        });
        this.$ok.unbind();
        this.$ok.on('click', e => {
          this.processResults(trackView);
        });
      }

      processResults(trackView) {
        const min = Number(this.$minimum_input.val());
        const max = Number(this.$maximum_input.val());

        if (isNaN(min) || isNaN(max)) {
          Alert.presentAlert(new Error('Must input numeric values'), undefined);
        } else {
          trackView.setDataRange(min, max);
        }

        this.$minimum_input.val(undefined);
        this.$maximum_input.val(undefined);
        this.$container.offset({
          left: 0,
          top: 0
        });
        this.$container.hide();
      }

      present($parent) {
        const offset_top = $parent.offset().top;
        const scroll_top = $$1('body').scrollTop();
        this.$container.offset({
          left: $parent.width() - this.$container.width(),
          top: offset_top + scroll_top
        });
        this.$container.show();
      }

    }

    /*
     * The MIT License (MIT)
     *
     * Copyright (c) 2014 Broad Institute
     *
     * Permission is hereby granted, free of charge, to any person obtaining a copy
     * of ctx software and associated documentation files (the "Software"), to deal
     * in the Software without restriction, including without limitation the rights
     * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
     * copies of the Software, and to permit persons to whom the Software is
     * furnished to do so, subject to the following conditions:
     *
     * The above copyright notice and ctx permission notice shall be included in
     * all copies or substantial portions of the Software.
     *
     *
     * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
     * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
     * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
     * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
     * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
     * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
     * THE SOFTWARE.
     */

    const IGVGraphics = {
      configureHighDPICanvas: function (ctx, w, h) {
        const scaleFactor = window.devicePixelRatio; // const scaleFactor = 1

        ctx.canvas.style.width = `${w}px`;
        ctx.canvas.width = Math.floor(scaleFactor * w);
        ctx.canvas.style.height = `${h}px`;
        ctx.canvas.height = Math.floor(scaleFactor * h);
        ctx.scale(scaleFactor, scaleFactor);
      },
      setProperties: function (ctx, properties) {
        for (var key in properties) {
          if (properties.hasOwnProperty(key)) {
            var value = properties[key];
            ctx[key] = value;
          }
        }
      },
      strokeLine: function (ctx, x1, y1, x2, y2, properties) {
        x1 = Math.floor(x1) + 0.5;
        y1 = Math.floor(y1) + 0.5;
        x2 = Math.floor(x2) + 0.5;
        y2 = Math.floor(y2) + 0.5;

        if (properties) {
          ctx.save();
          IGVGraphics.setProperties(ctx, properties);
        }

        ctx.beginPath();
        ctx.moveTo(x1, y1);
        ctx.lineTo(x2, y2);
        ctx.stroke();
        if (properties) ctx.restore();
      },
      fillRect: function (ctx, x, y, w, h, properties) {
        x = Math.round(x);
        y = Math.round(y);

        if (properties) {
          ctx.save();
          IGVGraphics.setProperties(ctx, properties);
        }

        ctx.fillRect(x, y, w, h);
        if (properties) ctx.restore();
      },
      fillPolygon: function (ctx, x, y, properties) {
        if (properties) {
          ctx.save();
          IGVGraphics.setProperties(ctx, properties);
        }

        doPath(ctx, x, y);
        ctx.fill();
        if (properties) ctx.restore();
      },
      strokePolygon: function (ctx, x, y, properties) {
        if (properties) {
          ctx.save();
          IGVGraphics.setProperties(ctx, properties);
        }

        doPath(ctx, x, y);
        ctx.stroke();
        if (properties) ctx.restore();
      },
      fillText: function (ctx, text, x, y, properties, transforms) {
        if (properties || transforms) {
          ctx.save();
        }

        if (properties) {
          IGVGraphics.setProperties(ctx, properties);
        }

        if (transforms) {
          // Slow path with context saving and extra translate
          ctx.translate(x, y);

          for (var transform in transforms) {
            var value = transforms[transform]; // TODO: Add error checking for robustness

            if (transform === 'translate') {
              ctx.translate(value['x'], value['y']);
            }

            if (transform === 'rotate') {
              ctx.rotate(value['angle'] * Math.PI / 180);
            }
          }

          ctx.fillText(text, 0, 0);
        } else {
          ctx.fillText(text, x, y);
        }

        if (properties || transforms) ctx.restore();
      },
      strokeText: function (ctx, text, x, y, properties, transforms) {
        if (properties || transforms) {
          ctx.save();
        }

        if (properties) {
          IGVGraphics.setProperties(ctx, properties);
        }

        if (transforms) {
          ctx.translate(x, y);

          for (var transform in transforms) {
            var value = transforms[transform]; // TODO: Add error checking for robustness

            if (transform === 'translate') {
              ctx.translate(value['x'], value['y']);
            }

            if (transform === 'rotate') {
              ctx.rotate(value['angle'] * Math.PI / 180);
            }
          }

          ctx.strokeText(text, 0, 0);
        } else {
          ctx.strokeText(text, x, y);
        }

        if (properties || transforms) ctx.restore();
      },
      strokeCircle: function (ctx, x, y, radius, properties) {
        if (properties) {
          ctx.save();
          IGVGraphics.setProperties(ctx, properties);
        }

        ctx.beginPath();
        ctx.arc(x, y, radius, 0, 2 * Math.PI);
        ctx.stroke();
        if (properties) ctx.restore();
      },
      fillCircle: function (ctx, x, y, radius, properties) {
        if (properties) {
          ctx.save();
          IGVGraphics.setProperties(ctx, properties);
        }

        ctx.beginPath();
        ctx.arc(x, y, radius, 0, 2 * Math.PI);
        ctx.fill();
        if (properties) ctx.restore();
      },
      drawArrowhead: function (ctx, x, y, size, lineWidth) {
        ctx.save();

        if (!size) {
          size = 5;
        }

        if (lineWidth) {
          ctx.lineWidth = lineWidth;
        }

        ctx.beginPath();
        ctx.moveTo(x, y - size / 2);
        ctx.lineTo(x, y + size / 2);
        ctx.lineTo(x + size, y);
        ctx.lineTo(x, y - size / 2);
        ctx.closePath();
        ctx.fill();
        ctx.restore();
      },
      dashedLine: function (ctx, x1, y1, x2, y2, dashLen) {
        let properties = arguments.length > 6 && arguments[6] !== undefined ? arguments[6] : {};
        if (dashLen === undefined) dashLen = 2;
        ctx.setLineDash([dashLen, dashLen]);
        IGVGraphics.strokeLine(ctx, x1, y1, x2, y2, properties);
        ctx.setLineDash([]);
      },
      roundRect: function (ctx, x, y, width, height, radius, fill, stroke) {
        if (typeof stroke == "undefined") {
          stroke = true;
        }

        if (typeof radius === "undefined") {
          radius = 5;
        }

        ctx.beginPath();
        ctx.moveTo(x + radius, y);
        ctx.lineTo(x + width - radius, y);
        ctx.quadraticCurveTo(x + width, y, x + width, y + radius);
        ctx.lineTo(x + width, y + height - radius);
        ctx.quadraticCurveTo(x + width, y + height, x + width - radius, y + height);
        ctx.lineTo(x + radius, y + height);
        ctx.quadraticCurveTo(x, y + height, x, y + height - radius);
        ctx.lineTo(x, y + radius);
        ctx.quadraticCurveTo(x, y, x + radius, y);
        ctx.closePath();

        if (stroke) {
          ctx.stroke();
        }

        if (fill) {
          ctx.fill();
        }
      },
      polygon: function (ctx, x, y, fill, stroke) {
        if (typeof stroke == "undefined") {
          stroke = true;
        }

        ctx.beginPath();
        var len = x.length;
        ctx.moveTo(x[0], y[0]);

        for (var i = 1; i < len; i++) {
          ctx.lineTo(x[i], y[i]); // this.moveTo(x[i], y[i]);
        }

        ctx.closePath();

        if (stroke) {
          ctx.stroke();
        }

        if (fill) {
          ctx.fill();
        }
      }
    };

    function doPath(ctx, x, y) {
      var i,
          len = x.length;

      for (i = 0; i < len; i++) {
        x[i] = Math.round(x[i]);
        y[i] = Math.round(y[i]);
      }

      ctx.beginPath();
      ctx.moveTo(x[0], y[0]);

      for (i = 1; i < len; i++) {
        ctx.lineTo(x[i], y[i]);
      }

      ctx.closePath();
    }

    var commonjsGlobal = typeof globalThis !== 'undefined' ? globalThis : typeof window !== 'undefined' ? window : typeof global !== 'undefined' ? global : typeof self !== 'undefined' ? self : {};

    function createCommonjsModule(fn) {
      var module = { exports: {} };
    	return fn(module, module.exports), module.exports;
    }

    var check = function (it) {
      return it && it.Math == Math && it;
    }; // https://github.com/zloirock/core-js/issues/86#issuecomment-115759028


    var global$1 = // eslint-disable-next-line es-x/no-global-this -- safe
    check(typeof globalThis == 'object' && globalThis) || check(typeof window == 'object' && window) || // eslint-disable-next-line no-restricted-globals -- safe
    check(typeof self == 'object' && self) || check(typeof commonjsGlobal == 'object' && commonjsGlobal) || // eslint-disable-next-line no-new-func -- fallback
    function () {
      return this;
    }() || Function('return this')();

    var fails = function (exec) {
      try {
        return !!exec();
      } catch (error) {
        return true;
      }
    };

    var descriptors = !fails(function () {
      // eslint-disable-next-line es-x/no-object-defineproperty -- required for testing
      return Object.defineProperty({}, 1, {
        get: function () {
          return 7;
        }
      })[1] != 7;
    });

    var functionBindNative = !fails(function () {
      // eslint-disable-next-line es-x/no-function-prototype-bind -- safe
      var test = function () {
        /* empty */
      }.bind(); // eslint-disable-next-line no-prototype-builtins -- safe


      return typeof test != 'function' || test.hasOwnProperty('prototype');
    });

    var call$2 = Function.prototype.call;
    var functionCall = functionBindNative ? call$2.bind(call$2) : function () {
      return call$2.apply(call$2, arguments);
    };

    var $propertyIsEnumerable = {}.propertyIsEnumerable; // eslint-disable-next-line es-x/no-object-getownpropertydescriptor -- safe

    var getOwnPropertyDescriptor$1 = Object.getOwnPropertyDescriptor; // Nashorn ~ JDK8 bug

    var NASHORN_BUG = getOwnPropertyDescriptor$1 && !$propertyIsEnumerable.call({
      1: 2
    }, 1); // `Object.prototype.propertyIsEnumerable` method implementation
    // https://tc39.es/ecma262/#sec-object.prototype.propertyisenumerable

    var f$5 = NASHORN_BUG ? function propertyIsEnumerable(V) {
      var descriptor = getOwnPropertyDescriptor$1(this, V);
      return !!descriptor && descriptor.enumerable;
    } : $propertyIsEnumerable;
    var objectPropertyIsEnumerable = {
      f: f$5
    };

    var createPropertyDescriptor = function (bitmap, value) {
      return {
        enumerable: !(bitmap & 1),
        configurable: !(bitmap & 2),
        writable: !(bitmap & 4),
        value: value
      };
    };

    var FunctionPrototype$2 = Function.prototype;
    var bind$1 = FunctionPrototype$2.bind;
    var call$1 = FunctionPrototype$2.call;
    var uncurryThis = functionBindNative && bind$1.bind(call$1, call$1);
    var functionUncurryThis = functionBindNative ? function (fn) {
      return fn && uncurryThis(fn);
    } : function (fn) {
      return fn && function () {
        return call$1.apply(fn, arguments);
      };
    };

    var toString$1 = functionUncurryThis({}.toString);
    var stringSlice = functionUncurryThis(''.slice);

    var classofRaw = function (it) {
      return stringSlice(toString$1(it), 8, -1);
    };

    var Object$5 = global$1.Object;
    var split = functionUncurryThis(''.split); // fallback for non-array-like ES3 and non-enumerable old V8 strings

    var indexedObject = fails(function () {
      // throws an error in rhino, see https://github.com/mozilla/rhino/issues/346
      // eslint-disable-next-line no-prototype-builtins -- safe
      return !Object$5('z').propertyIsEnumerable(0);
    }) ? function (it) {
      return classofRaw(it) == 'String' ? split(it, '') : Object$5(it);
    } : Object$5;

    var TypeError$a = global$1.TypeError; // `RequireObjectCoercible` abstract operation
    // https://tc39.es/ecma262/#sec-requireobjectcoercible

    var requireObjectCoercible = function (it) {
      if (it == undefined) throw TypeError$a("Can't call method on " + it);
      return it;
    };

    var toIndexedObject = function (it) {
      return indexedObject(requireObjectCoercible(it));
    };

    // `IsCallable` abstract operation
    // https://tc39.es/ecma262/#sec-iscallable
    var isCallable = function (argument) {
      return typeof argument == 'function';
    };

    var isObject = function (it) {
      return typeof it == 'object' ? it !== null : isCallable(it);
    };

    var aFunction = function (argument) {
      return isCallable(argument) ? argument : undefined;
    };

    var getBuiltIn = function (namespace, method) {
      return arguments.length < 2 ? aFunction(global$1[namespace]) : global$1[namespace] && global$1[namespace][method];
    };

    var objectIsPrototypeOf = functionUncurryThis({}.isPrototypeOf);

    var engineUserAgent = getBuiltIn('navigator', 'userAgent') || '';

    var process$2 = global$1.process;
    var Deno = global$1.Deno;
    var versions = process$2 && process$2.versions || Deno && Deno.version;
    var v8 = versions && versions.v8;
    var match, version$1;

    if (v8) {
      match = v8.split('.'); // in old Chrome, versions of V8 isn't V8 = Chrome / 10
      // but their correct versions are not interesting for us

      version$1 = match[0] > 0 && match[0] < 4 ? 1 : +(match[0] + match[1]);
    } // BrowserFS NodeJS `process` polyfill incorrectly set `.v8` to `0.0`
    // so check `userAgent` even if `.v8` exists, but 0


    if (!version$1 && engineUserAgent) {
      match = engineUserAgent.match(/Edge\/(\d+)/);

      if (!match || match[1] >= 74) {
        match = engineUserAgent.match(/Chrome\/(\d+)/);
        if (match) version$1 = +match[1];
      }
    }

    var engineV8Version = version$1;

    /* eslint-disable es-x/no-symbol -- required for testing */

    var nativeSymbol = !!Object.getOwnPropertySymbols && !fails(function () {
      var symbol = Symbol(); // Chrome 38 Symbol has incorrect toString conversion
      // `get-own-property-symbols` polyfill symbols converted to object are not Symbol instances

      return !String(symbol) || !(Object(symbol) instanceof Symbol) || // Chrome 38-40 symbols are not inherited from DOM collections prototypes to instances
      !Symbol.sham && engineV8Version && engineV8Version < 41;
    });

    /* eslint-disable es-x/no-symbol -- required for testing */
    var useSymbolAsUid = nativeSymbol && !Symbol.sham && typeof Symbol.iterator == 'symbol';

    var Object$4 = global$1.Object;
    var isSymbol = useSymbolAsUid ? function (it) {
      return typeof it == 'symbol';
    } : function (it) {
      var $Symbol = getBuiltIn('Symbol');
      return isCallable($Symbol) && objectIsPrototypeOf($Symbol.prototype, Object$4(it));
    };

    var String$4 = global$1.String;

    var tryToString = function (argument) {
      try {
        return String$4(argument);
      } catch (error) {
        return 'Object';
      }
    };

    var TypeError$9 = global$1.TypeError; // `Assert: IsCallable(argument) is true`

    var aCallable = function (argument) {
      if (isCallable(argument)) return argument;
      throw TypeError$9(tryToString(argument) + ' is not a function');
    };

    // https://tc39.es/ecma262/#sec-getmethod

    var getMethod = function (V, P) {
      var func = V[P];
      return func == null ? undefined : aCallable(func);
    };

    var TypeError$8 = global$1.TypeError; // `OrdinaryToPrimitive` abstract operation
    // https://tc39.es/ecma262/#sec-ordinarytoprimitive

    var ordinaryToPrimitive = function (input, pref) {
      var fn, val;
      if (pref === 'string' && isCallable(fn = input.toString) && !isObject(val = functionCall(fn, input))) return val;
      if (isCallable(fn = input.valueOf) && !isObject(val = functionCall(fn, input))) return val;
      if (pref !== 'string' && isCallable(fn = input.toString) && !isObject(val = functionCall(fn, input))) return val;
      throw TypeError$8("Can't convert object to primitive value");
    };

    var defineProperty$1 = Object.defineProperty;

    var setGlobal = function (key, value) {
      try {
        defineProperty$1(global$1, key, {
          value: value,
          configurable: true,
          writable: true
        });
      } catch (error) {
        global$1[key] = value;
      }

      return value;
    };

    var SHARED = '__core-js_shared__';
    var store$1 = global$1[SHARED] || setGlobal(SHARED, {});
    var sharedStore = store$1;

    var shared = createCommonjsModule(function (module) {
      (module.exports = function (key, value) {
        return sharedStore[key] || (sharedStore[key] = value !== undefined ? value : {});
      })('versions', []).push({
        version: '3.22.4',
        mode: 'global',
        copyright: '© 2014-2022 Denis Pushkarev (zloirock.ru)',
        license: 'https://github.com/zloirock/core-js/blob/v3.22.4/LICENSE',
        source: 'https://github.com/zloirock/core-js'
      });
    });

    var Object$3 = global$1.Object; // `ToObject` abstract operation
    // https://tc39.es/ecma262/#sec-toobject

    var toObject = function (argument) {
      return Object$3(requireObjectCoercible(argument));
    };

    var hasOwnProperty = functionUncurryThis({}.hasOwnProperty); // `HasOwnProperty` abstract operation
    // https://tc39.es/ecma262/#sec-hasownproperty
    // eslint-disable-next-line es-x/no-object-hasown -- safe

    var hasOwnProperty_1 = Object.hasOwn || function hasOwn(it, key) {
      return hasOwnProperty(toObject(it), key);
    };

    var id = 0;
    var postfix = Math.random();
    var toString = functionUncurryThis(1.0.toString);

    var uid = function (key) {
      return 'Symbol(' + (key === undefined ? '' : key) + ')_' + toString(++id + postfix, 36);
    };

    var WellKnownSymbolsStore = shared('wks');
    var Symbol$1 = global$1.Symbol;
    var symbolFor = Symbol$1 && Symbol$1['for'];
    var createWellKnownSymbol = useSymbolAsUid ? Symbol$1 : Symbol$1 && Symbol$1.withoutSetter || uid;

    var wellKnownSymbol = function (name) {
      if (!hasOwnProperty_1(WellKnownSymbolsStore, name) || !(nativeSymbol || typeof WellKnownSymbolsStore[name] == 'string')) {
        var description = 'Symbol.' + name;

        if (nativeSymbol && hasOwnProperty_1(Symbol$1, name)) {
          WellKnownSymbolsStore[name] = Symbol$1[name];
        } else if (useSymbolAsUid && symbolFor) {
          WellKnownSymbolsStore[name] = symbolFor(description);
        } else {
          WellKnownSymbolsStore[name] = createWellKnownSymbol(description);
        }
      }

      return WellKnownSymbolsStore[name];
    };

    var TypeError$7 = global$1.TypeError;
    var TO_PRIMITIVE = wellKnownSymbol('toPrimitive'); // `ToPrimitive` abstract operation
    // https://tc39.es/ecma262/#sec-toprimitive

    var toPrimitive = function (input, pref) {
      if (!isObject(input) || isSymbol(input)) return input;
      var exoticToPrim = getMethod(input, TO_PRIMITIVE);
      var result;

      if (exoticToPrim) {
        if (pref === undefined) pref = 'default';
        result = functionCall(exoticToPrim, input, pref);
        if (!isObject(result) || isSymbol(result)) return result;
        throw TypeError$7("Can't convert object to primitive value");
      }

      if (pref === undefined) pref = 'number';
      return ordinaryToPrimitive(input, pref);
    };

    // https://tc39.es/ecma262/#sec-topropertykey

    var toPropertyKey = function (argument) {
      var key = toPrimitive(argument, 'string');
      return isSymbol(key) ? key : key + '';
    };

    var document$1 = global$1.document; // typeof document.createElement is 'object' in old IE

    var EXISTS$1 = isObject(document$1) && isObject(document$1.createElement);

    var documentCreateElement = function (it) {
      return EXISTS$1 ? document$1.createElement(it) : {};
    };

    var ie8DomDefine = !descriptors && !fails(function () {
      // eslint-disable-next-line es-x/no-object-defineproperty -- required for testing
      return Object.defineProperty(documentCreateElement('div'), 'a', {
        get: function () {
          return 7;
        }
      }).a != 7;
    });

    var $getOwnPropertyDescriptor$1 = Object.getOwnPropertyDescriptor; // `Object.getOwnPropertyDescriptor` method
    // https://tc39.es/ecma262/#sec-object.getownpropertydescriptor

    var f$4 = descriptors ? $getOwnPropertyDescriptor$1 : function getOwnPropertyDescriptor(O, P) {
      O = toIndexedObject(O);
      P = toPropertyKey(P);
      if (ie8DomDefine) try {
        return $getOwnPropertyDescriptor$1(O, P);
      } catch (error) {
        /* empty */
      }
      if (hasOwnProperty_1(O, P)) return createPropertyDescriptor(!functionCall(objectPropertyIsEnumerable.f, O, P), O[P]);
    };
    var objectGetOwnPropertyDescriptor = {
      f: f$4
    };

    // https://bugs.chromium.org/p/v8/issues/detail?id=3334

    var v8PrototypeDefineBug = descriptors && fails(function () {
      // eslint-disable-next-line es-x/no-object-defineproperty -- required for testing
      return Object.defineProperty(function () {
        /* empty */
      }, 'prototype', {
        value: 42,
        writable: false
      }).prototype != 42;
    });

    var String$3 = global$1.String;
    var TypeError$6 = global$1.TypeError; // `Assert: Type(argument) is Object`

    var anObject = function (argument) {
      if (isObject(argument)) return argument;
      throw TypeError$6(String$3(argument) + ' is not an object');
    };

    var TypeError$5 = global$1.TypeError; // eslint-disable-next-line es-x/no-object-defineproperty -- safe

    var $defineProperty = Object.defineProperty; // eslint-disable-next-line es-x/no-object-getownpropertydescriptor -- safe

    var $getOwnPropertyDescriptor = Object.getOwnPropertyDescriptor;
    var ENUMERABLE = 'enumerable';
    var CONFIGURABLE$1 = 'configurable';
    var WRITABLE = 'writable'; // `Object.defineProperty` method
    // https://tc39.es/ecma262/#sec-object.defineproperty

    var f$3 = descriptors ? v8PrototypeDefineBug ? function defineProperty(O, P, Attributes) {
      anObject(O);
      P = toPropertyKey(P);
      anObject(Attributes);

      if (typeof O === 'function' && P === 'prototype' && 'value' in Attributes && WRITABLE in Attributes && !Attributes[WRITABLE]) {
        var current = $getOwnPropertyDescriptor(O, P);

        if (current && current[WRITABLE]) {
          O[P] = Attributes.value;
          Attributes = {
            configurable: CONFIGURABLE$1 in Attributes ? Attributes[CONFIGURABLE$1] : current[CONFIGURABLE$1],
            enumerable: ENUMERABLE in Attributes ? Attributes[ENUMERABLE] : current[ENUMERABLE],
            writable: false
          };
        }
      }

      return $defineProperty(O, P, Attributes);
    } : $defineProperty : function defineProperty(O, P, Attributes) {
      anObject(O);
      P = toPropertyKey(P);
      anObject(Attributes);
      if (ie8DomDefine) try {
        return $defineProperty(O, P, Attributes);
      } catch (error) {
        /* empty */
      }
      if ('get' in Attributes || 'set' in Attributes) throw TypeError$5('Accessors not supported');
      if ('value' in Attributes) O[P] = Attributes.value;
      return O;
    };
    var objectDefineProperty = {
      f: f$3
    };

    var createNonEnumerableProperty = descriptors ? function (object, key, value) {
      return objectDefineProperty.f(object, key, createPropertyDescriptor(1, value));
    } : function (object, key, value) {
      object[key] = value;
      return object;
    };

    var FunctionPrototype$1 = Function.prototype; // eslint-disable-next-line es-x/no-object-getownpropertydescriptor -- safe

    var getDescriptor = descriptors && Object.getOwnPropertyDescriptor;
    var EXISTS = hasOwnProperty_1(FunctionPrototype$1, 'name'); // additional protection from minified / mangled / dropped function names

    var PROPER = EXISTS && function something() {
      /* empty */
    }.name === 'something';

    var CONFIGURABLE = EXISTS && (!descriptors || descriptors && getDescriptor(FunctionPrototype$1, 'name').configurable);
    var functionName = {
      EXISTS: EXISTS,
      PROPER: PROPER,
      CONFIGURABLE: CONFIGURABLE
    };

    var functionToString = functionUncurryThis(Function.toString); // this helper broken in `core-js@3.4.1-3.4.4`, so we can't use `shared` helper

    if (!isCallable(sharedStore.inspectSource)) {
      sharedStore.inspectSource = function (it) {
        return functionToString(it);
      };
    }

    var inspectSource = sharedStore.inspectSource;

    var WeakMap$1 = global$1.WeakMap;
    var nativeWeakMap = isCallable(WeakMap$1) && /native code/.test(inspectSource(WeakMap$1));

    var keys = shared('keys');

    var sharedKey = function (key) {
      return keys[key] || (keys[key] = uid(key));
    };

    var hiddenKeys$1 = {};

    var OBJECT_ALREADY_INITIALIZED = 'Object already initialized';
    var TypeError$4 = global$1.TypeError;
    var WeakMap = global$1.WeakMap;
    var set$1, get, has;

    var enforce = function (it) {
      return has(it) ? get(it) : set$1(it, {});
    };

    var getterFor = function (TYPE) {
      return function (it) {
        var state;

        if (!isObject(it) || (state = get(it)).type !== TYPE) {
          throw TypeError$4('Incompatible receiver, ' + TYPE + ' required');
        }

        return state;
      };
    };

    if (nativeWeakMap || sharedStore.state) {
      var store = sharedStore.state || (sharedStore.state = new WeakMap());
      var wmget = functionUncurryThis(store.get);
      var wmhas = functionUncurryThis(store.has);
      var wmset = functionUncurryThis(store.set);

      set$1 = function (it, metadata) {
        if (wmhas(store, it)) throw new TypeError$4(OBJECT_ALREADY_INITIALIZED);
        metadata.facade = it;
        wmset(store, it, metadata);
        return metadata;
      };

      get = function (it) {
        return wmget(store, it) || {};
      };

      has = function (it) {
        return wmhas(store, it);
      };
    } else {
      var STATE = sharedKey('state');
      hiddenKeys$1[STATE] = true;

      set$1 = function (it, metadata) {
        if (hasOwnProperty_1(it, STATE)) throw new TypeError$4(OBJECT_ALREADY_INITIALIZED);
        metadata.facade = it;
        createNonEnumerableProperty(it, STATE, metadata);
        return metadata;
      };

      get = function (it) {
        return hasOwnProperty_1(it, STATE) ? it[STATE] : {};
      };

      has = function (it) {
        return hasOwnProperty_1(it, STATE);
      };
    }

    var internalState = {
      set: set$1,
      get: get,
      has: has,
      enforce: enforce,
      getterFor: getterFor
    };

    var makeBuiltIn_1 = createCommonjsModule(function (module) {
      var defineProperty = objectDefineProperty.f;
      var CONFIGURABLE_FUNCTION_NAME = functionName.CONFIGURABLE;
      var enforceInternalState = internalState.enforce;
      var getInternalState = internalState.get;
      var CONFIGURABLE_LENGTH = !fails(function () {
        return defineProperty(function () {
          /* empty */
        }, 'length', {
          value: 8
        }).length !== 8;
      });
      var TEMPLATE = String(String).split('String');

      var makeBuiltIn = module.exports = function (value, name, options) {
        if (String(name).slice(0, 7) === 'Symbol(') {
          name = '[' + String(name).replace(/^Symbol\(([^)]*)\)/, '$1') + ']';
        }

        if (options && options.getter) name = 'get ' + name;
        if (options && options.setter) name = 'set ' + name;

        if (!hasOwnProperty_1(value, 'name') || CONFIGURABLE_FUNCTION_NAME && value.name !== name) {
          defineProperty(value, 'name', {
            value: name,
            configurable: true
          });
        }

        if (CONFIGURABLE_LENGTH && options && hasOwnProperty_1(options, 'arity') && value.length !== options.arity) {
          defineProperty(value, 'length', {
            value: options.arity
          });
        }

        var state = enforceInternalState(value);

        if (!hasOwnProperty_1(state, 'source')) {
          state.source = TEMPLATE.join(typeof name == 'string' ? name : '');
        }

        return value;
      }; // add fake Function#toString for correct work wrapped methods / constructors with methods like LoDash isNative
      // eslint-disable-next-line no-extend-native -- required


      Function.prototype.toString = makeBuiltIn(function toString() {
        return isCallable(this) && getInternalState(this).source || inspectSource(this);
      }, 'toString');
    });

    var defineBuiltIn = function (O, key, value, options) {
      var unsafe = options ? !!options.unsafe : false;
      var simple = options ? !!options.enumerable : false;
      var noTargetGet = options ? !!options.noTargetGet : false;
      var name = options && options.name !== undefined ? options.name : key;
      if (isCallable(value)) makeBuiltIn_1(value, name, options);

      if (O === global$1) {
        if (simple) O[key] = value;else setGlobal(key, value);
        return O;
      } else if (!unsafe) {
        delete O[key];
      } else if (!noTargetGet && O[key]) {
        simple = true;
      }

      if (simple) O[key] = value;else createNonEnumerableProperty(O, key, value);
      return O;
    };

    var ceil = Math.ceil;
    var floor = Math.floor; // `ToIntegerOrInfinity` abstract operation
    // https://tc39.es/ecma262/#sec-tointegerorinfinity

    var toIntegerOrInfinity = function (argument) {
      var number = +argument; // eslint-disable-next-line no-self-compare -- safe

      return number !== number || number === 0 ? 0 : (number > 0 ? floor : ceil)(number);
    };

    var max = Math.max;
    var min$1 = Math.min; // Helper for a popular repeating case of the spec:
    // Let integer be ? ToInteger(index).
    // If integer < 0, let result be max((length + integer), 0); else let result be min(integer, length).

    var toAbsoluteIndex = function (index, length) {
      var integer = toIntegerOrInfinity(index);
      return integer < 0 ? max(integer + length, 0) : min$1(integer, length);
    };

    var min = Math.min; // `ToLength` abstract operation
    // https://tc39.es/ecma262/#sec-tolength

    var toLength = function (argument) {
      return argument > 0 ? min(toIntegerOrInfinity(argument), 0x1FFFFFFFFFFFFF) : 0; // 2 ** 53 - 1 == 9007199254740991
    };

    // https://tc39.es/ecma262/#sec-lengthofarraylike

    var lengthOfArrayLike = function (obj) {
      return toLength(obj.length);
    };

    var createMethod = function (IS_INCLUDES) {
      return function ($this, el, fromIndex) {
        var O = toIndexedObject($this);
        var length = lengthOfArrayLike(O);
        var index = toAbsoluteIndex(fromIndex, length);
        var value; // Array#includes uses SameValueZero equality algorithm
        // eslint-disable-next-line no-self-compare -- NaN check

        if (IS_INCLUDES && el != el) while (length > index) {
          value = O[index++]; // eslint-disable-next-line no-self-compare -- NaN check

          if (value != value) return true; // Array#indexOf ignores holes, Array#includes - not
        } else for (; length > index; index++) {
          if ((IS_INCLUDES || index in O) && O[index] === el) return IS_INCLUDES || index || 0;
        }
        return !IS_INCLUDES && -1;
      };
    };

    var arrayIncludes = {
      // `Array.prototype.includes` method
      // https://tc39.es/ecma262/#sec-array.prototype.includes
      includes: createMethod(true),
      // `Array.prototype.indexOf` method
      // https://tc39.es/ecma262/#sec-array.prototype.indexof
      indexOf: createMethod(false)
    };

    var indexOf = arrayIncludes.indexOf;
    var push = functionUncurryThis([].push);

    var objectKeysInternal = function (object, names) {
      var O = toIndexedObject(object);
      var i = 0;
      var result = [];
      var key;

      for (key in O) !hasOwnProperty_1(hiddenKeys$1, key) && hasOwnProperty_1(O, key) && push(result, key); // Don't enum bug & hidden keys


      while (names.length > i) if (hasOwnProperty_1(O, key = names[i++])) {
        ~indexOf(result, key) || push(result, key);
      }

      return result;
    };

    // IE8- don't enum bug keys
    var enumBugKeys = ['constructor', 'hasOwnProperty', 'isPrototypeOf', 'propertyIsEnumerable', 'toLocaleString', 'toString', 'valueOf'];

    var hiddenKeys = enumBugKeys.concat('length', 'prototype'); // `Object.getOwnPropertyNames` method
    // https://tc39.es/ecma262/#sec-object.getownpropertynames
    // eslint-disable-next-line es-x/no-object-getownpropertynames -- safe

    var f$2 = Object.getOwnPropertyNames || function getOwnPropertyNames(O) {
      return objectKeysInternal(O, hiddenKeys);
    };

    var objectGetOwnPropertyNames = {
      f: f$2
    };

    // eslint-disable-next-line es-x/no-object-getownpropertysymbols -- safe
    var f$1 = Object.getOwnPropertySymbols;
    var objectGetOwnPropertySymbols = {
      f: f$1
    };

    var concat = functionUncurryThis([].concat); // all object keys, includes non-enumerable and symbols

    var ownKeys = getBuiltIn('Reflect', 'ownKeys') || function ownKeys(it) {
      var keys = objectGetOwnPropertyNames.f(anObject(it));
      var getOwnPropertySymbols = objectGetOwnPropertySymbols.f;
      return getOwnPropertySymbols ? concat(keys, getOwnPropertySymbols(it)) : keys;
    };

    var copyConstructorProperties = function (target, source, exceptions) {
      var keys = ownKeys(source);
      var defineProperty = objectDefineProperty.f;
      var getOwnPropertyDescriptor = objectGetOwnPropertyDescriptor.f;

      for (var i = 0; i < keys.length; i++) {
        var key = keys[i];

        if (!hasOwnProperty_1(target, key) && !(exceptions && hasOwnProperty_1(exceptions, key))) {
          defineProperty(target, key, getOwnPropertyDescriptor(source, key));
        }
      }
    };

    var replacement = /#|\.prototype\./;

    var isForced = function (feature, detection) {
      var value = data[normalize$1(feature)];
      return value == POLYFILL ? true : value == NATIVE ? false : isCallable(detection) ? fails(detection) : !!detection;
    };

    var normalize$1 = isForced.normalize = function (string) {
      return String(string).replace(replacement, '.').toLowerCase();
    };

    var data = isForced.data = {};
    var NATIVE = isForced.NATIVE = 'N';
    var POLYFILL = isForced.POLYFILL = 'P';
    var isForced_1 = isForced;

    var getOwnPropertyDescriptor = objectGetOwnPropertyDescriptor.f;
    /*
      options.target      - name of the target object
      options.global      - target is the global object
      options.stat        - export as static methods of target
      options.proto       - export as prototype methods of target
      options.real        - real prototype method for the `pure` version
      options.forced      - export even if the native feature is available
      options.bind        - bind methods to the target, required for the `pure` version
      options.wrap        - wrap constructors to preventing global pollution, required for the `pure` version
      options.unsafe      - use the simple assignment of property instead of delete + defineProperty
      options.sham        - add a flag to not completely full polyfills
      options.enumerable  - export as enumerable property
      options.noTargetGet - prevent calling a getter on target
      options.name        - the .name of the function if it does not match the key
    */

    var _export = function (options, source) {
      var TARGET = options.target;
      var GLOBAL = options.global;
      var STATIC = options.stat;
      var FORCED, target, key, targetProperty, sourceProperty, descriptor;

      if (GLOBAL) {
        target = global$1;
      } else if (STATIC) {
        target = global$1[TARGET] || setGlobal(TARGET, {});
      } else {
        target = (global$1[TARGET] || {}).prototype;
      }

      if (target) for (key in source) {
        sourceProperty = source[key];

        if (options.noTargetGet) {
          descriptor = getOwnPropertyDescriptor(target, key);
          targetProperty = descriptor && descriptor.value;
        } else targetProperty = target[key];

        FORCED = isForced_1(GLOBAL ? key : TARGET + (STATIC ? '.' : '#') + key, options.forced); // contained in target

        if (!FORCED && targetProperty !== undefined) {
          if (typeof sourceProperty == typeof targetProperty) continue;
          copyConstructorProperties(sourceProperty, targetProperty);
        } // add a flag to not completely full polyfills


        if (options.sham || targetProperty && targetProperty.sham) {
          createNonEnumerableProperty(sourceProperty, 'sham', true);
        }

        defineBuiltIn(target, key, sourceProperty, options);
      }
    };

    // https://tc39.es/ecma262/#sec-object.keys
    // eslint-disable-next-line es-x/no-object-keys -- safe

    var objectKeys = Object.keys || function keys(O) {
      return objectKeysInternal(O, enumBugKeys);
    };

    // https://tc39.es/ecma262/#sec-object.defineproperties
    // eslint-disable-next-line es-x/no-object-defineproperties -- safe

    var f = descriptors && !v8PrototypeDefineBug ? Object.defineProperties : function defineProperties(O, Properties) {
      anObject(O);
      var props = toIndexedObject(Properties);
      var keys = objectKeys(Properties);
      var length = keys.length;
      var index = 0;
      var key;

      while (length > index) objectDefineProperty.f(O, key = keys[index++], props[key]);

      return O;
    };
    var objectDefineProperties = {
      f: f
    };

    var html = getBuiltIn('document', 'documentElement');

    /* global ActiveXObject -- old IE, WSH */
    var GT = '>';
    var LT = '<';
    var PROTOTYPE = 'prototype';
    var SCRIPT = 'script';
    var IE_PROTO$1 = sharedKey('IE_PROTO');

    var EmptyConstructor = function () {
      /* empty */
    };

    var scriptTag = function (content) {
      return LT + SCRIPT + GT + content + LT + '/' + SCRIPT + GT;
    }; // Create object with fake `null` prototype: use ActiveX Object with cleared prototype


    var NullProtoObjectViaActiveX = function (activeXDocument) {
      activeXDocument.write(scriptTag(''));
      activeXDocument.close();
      var temp = activeXDocument.parentWindow.Object;
      activeXDocument = null; // avoid memory leak

      return temp;
    }; // Create object with fake `null` prototype: use iframe Object with cleared prototype


    var NullProtoObjectViaIFrame = function () {
      // Thrash, waste and sodomy: IE GC bug
      var iframe = documentCreateElement('iframe');
      var JS = 'java' + SCRIPT + ':';
      var iframeDocument;
      iframe.style.display = 'none';
      html.appendChild(iframe); // https://github.com/zloirock/core-js/issues/475

      iframe.src = String(JS);
      iframeDocument = iframe.contentWindow.document;
      iframeDocument.open();
      iframeDocument.write(scriptTag('document.F=Object'));
      iframeDocument.close();
      return iframeDocument.F;
    }; // Check for document.domain and active x support
    // No need to use active x approach when document.domain is not set
    // see https://github.com/es-shims/es5-shim/issues/150
    // variation of https://github.com/kitcambridge/es5-shim/commit/4f738ac066346
    // avoid IE GC bug


    var activeXDocument;

    var NullProtoObject = function () {
      try {
        activeXDocument = new ActiveXObject('htmlfile');
      } catch (error) {
        /* ignore */
      }

      NullProtoObject = typeof document != 'undefined' ? document.domain && activeXDocument ? NullProtoObjectViaActiveX(activeXDocument) // old IE
      : NullProtoObjectViaIFrame() : NullProtoObjectViaActiveX(activeXDocument); // WSH

      var length = enumBugKeys.length;

      while (length--) delete NullProtoObject[PROTOTYPE][enumBugKeys[length]];

      return NullProtoObject();
    };

    hiddenKeys$1[IE_PROTO$1] = true; // `Object.create` method
    // https://tc39.es/ecma262/#sec-object.create
    // eslint-disable-next-line es-x/no-object-create -- safe

    var objectCreate = Object.create || function create(O, Properties) {
      var result;

      if (O !== null) {
        EmptyConstructor[PROTOTYPE] = anObject(O);
        result = new EmptyConstructor();
        EmptyConstructor[PROTOTYPE] = null; // add "__proto__" for Object.getPrototypeOf polyfill

        result[IE_PROTO$1] = O;
      } else result = NullProtoObject();

      return Properties === undefined ? result : objectDefineProperties.f(result, Properties);
    };

    var UNSCOPABLES = wellKnownSymbol('unscopables');
    var ArrayPrototype = Array.prototype; // Array.prototype[@@unscopables]
    // https://tc39.es/ecma262/#sec-array.prototype-@@unscopables

    if (ArrayPrototype[UNSCOPABLES] == undefined) {
      objectDefineProperty.f(ArrayPrototype, UNSCOPABLES, {
        configurable: true,
        value: objectCreate(null)
      });
    } // add a key to Array.prototype[@@unscopables]


    var addToUnscopables = function (key) {
      ArrayPrototype[UNSCOPABLES][key] = true;
    };

    var $includes = arrayIncludes.includes; // FF99+ bug

    var BROKEN_ON_SPARSE = fails(function () {
      return !Array(1).includes();
    }); // `Array.prototype.includes` method
    // https://tc39.es/ecma262/#sec-array.prototype.includes

    _export({
      target: 'Array',
      proto: true,
      forced: BROKEN_ON_SPARSE
    }, {
      includes: function includes(el
      /* , fromIndex = 0 */
      ) {
        return $includes(this, el, arguments.length > 1 ? arguments[1] : undefined);
      }
    }); // https://tc39.es/ecma262/#sec-array.prototype-@@unscopables

    addToUnscopables('includes');

    const FileFormats = {
      gwascatalog: {
        fields: ['bin', 'chr', 'start', 'end', 'name', 'pubMedID', 'author', 'pubDate', 'journal', 'title', 'trait', 'initSample', 'replSample', 'region', 'genes', 'riskAllele', 'riskAlFreq', 'pValue', 'pValueDesc', 'orOrBeta', 'ci95', 'platform', 'cnv']
      },
      wgrna: {
        fields: ['bin', 'chr', 'start', 'end', 'name', 'score', 'strand', 'thickStart', 'thickEnd', 'type']
      },
      cpgislandext: {
        fields: ['bin', 'chr', 'start', 'end', 'name', 'length', 'cpgNum', 'gcNum', 'perCpg', 'perGc', 'obsExp']
      },
      clinVarMain: {
        fields: ['chr1', 'start', 'end', 'name', 'score', 'strand', 'thickStart', 'thickEnd', 'reserved', 'blockCount', // Number of blocks
        'blockSizes', // Comma separated list of block sizes
        'chromStarts', // Start positions relative to chromStart
        'origName', // NM_198053.2(CD247):c.462C>T (p.Asp154=)	ClinVar Variation Report
        'clinSign', // Likely benign	Clinical significance
        'reviewStatus', // 	based on: criteria provided,single submitter	Review Status
        'type', // single nucleotide variant	Type of Variant
        'geneId', // CD247	Gene Symbol
        'snpId', //	181656780	dbSNP ID
        'nsvId', //		dbVar ID
        'rcvAcc', //	RCV000642347	ClinVar Allele Submission
        'testedInGtr', //	N	Genetic Testing Registry
        'phenotypeList', //	Immunodeficiency due to defect in cd3-zeta	Phenotypes
        'phenotype', //	MedGen:C1857798, OMIM:610163	Phenotype identifiers
        'origin', //	germline	Data origin
        'assembly', //	GRCh37	Genome assembly
        'cytogenetic', //	1q24.2	Cytogenetic status
        'hgvsCod', //	NM_198053.2:c.462C>T	Nucleotide HGVS
        'hgvsProt', //	NP_932170.1:p.Asp154=	Protein HGVS
        'numSubmit', //	1	Number of submitters
        'lastEval', //	Dec 19,2017	Last evaluation
        'guidelines', //		Guidelines
        'otherIds']
      }
    };

    const knownFileExtensions = new Set(["narrowpeak", "broadpeak", "regionpeak", "peaks", "bedgraph", "wig", "gff3", "gff", "gtf", "fusionjuncspan", "refflat", "seg", "aed", "bed", "vcf", "bb", "bigbed", "biginteract", "biggenepred", "bignarrowpeak", "bw", "bigwig", "bam", "tdf", "refgene", "genepred", "genepredext", "bedpe", "bp", "snp", "rmsk", "cram", "gwas", "maf", "mut"]);
    /**
     * Return a custom format object with the given name.
     * @param name
     * @returns {*}
     */

    function getFormat(name) {
      if (FileFormats && FileFormats[name]) {
        return expandFormat(FileFormats[name]);
      } else {
        return undefined;
      }

      function expandFormat(format) {
        const fields = format.fields;
        const keys = ['chr', 'start', 'end'];

        for (let i = 0; i < fields.length; i++) {
          for (let key of keys) {
            if (key === fields[i]) {
              format[key] = i;
            }
          }
        }

        return format;
      }
    }

    function inferFileFormat(fn) {
      var idx, ext;
      fn = fn.toLowerCase(); // Special case -- UCSC refgene files

      if (fn.endsWith("refgene.txt.gz") || fn.endsWith("refgene.txt.bgz") || fn.endsWith("refgene.txt") || fn.endsWith("refgene.sorted.txt.gz") || fn.endsWith("refgene.sorted.txt.bgz")) {
        return "refgene";
      } //Strip parameters -- handle local files later


      idx = fn.indexOf("?");

      if (idx > 0) {
        fn = fn.substr(0, idx);
      } //Strip aux extensions .gz, .tab, and .txt


      if (fn.endsWith(".gz")) {
        fn = fn.substr(0, fn.length - 3);
      }

      if (fn.endsWith(".txt") || fn.endsWith(".tab") || fn.endsWith(".bgz")) {
        fn = fn.substr(0, fn.length - 4);
      }

      idx = fn.lastIndexOf(".");
      ext = idx < 0 ? fn : fn.substr(idx + 1);

      switch (ext) {
        case "bw":
          return "bigwig";

        case "bb":
          return "bigbed";

        default:
          if (knownFileExtensions.has(ext)) {
            return ext;
          } else {
            return undefined;
          }

      }
    }

    function inferIndexPath(url, extension) {
      if (isString$3(url)) {
        if (url.includes("?")) {
          const idx = url.indexOf("?");
          return url.substring(0, idx) + "." + extension + url.substring(idx);
        } else {
          return url + "." + extension;
        }
      } else {
        return undefined;
      }
    }

    function inferTrackType(config) {
      translateDeprecatedTypes(config);

      if (config.type) {
        return config.type;
      }

      if (config.format) {
        const format = config.format.toLowerCase();

        switch (format) {
          case "bw":
          case "bigwig":
          case "wig":
          case "bedgraph":
          case "tdf":
            return "wig";

          case "vcf":
            return "variant";

          case "seg":
            return "seg";

          case "mut":
          case "maf":
            return "mut";

          case "bam":
          case "cram":
            return "alignment";

          case "bedpe":
          case "bedpe-loop":
          case "biginteract":
            return "interact";

          case "bp":
            return "arc";

          case "gwas":
            return "gwas";

          case "bed":
          case "bigbed":
          case "bb":
          case "biggenepred":
          case "bignarrowpeak":
            return "bedtype";

          default:
            return "annotation";
        }
      }
    }

    function translateDeprecatedTypes(config) {
      if (config.featureType) {
        // Translate deprecated "feature" type
        config.type = config.type || config.featureType;
        config.featureType = undefined;
      }

      if ("junctions" === config.type) {
        config.type = "junction";
      } else if ("bed" === config.type) {
        config.type = "annotation";
        config.format = config.format || "bed";
      } else if ("annotations" === config.type) {
        config.type = "annotation";
      } else if ("alignments" === config.type) {
        config.type = "alignment";
      } else if ("bam" === config.type) {
        config.type = "alignment";
        config.format = "bam";
      } else if ("vcf" === config.type) {
        config.type = "variant";
        config.format = "vcf";
      } else if ("t2d" === config.type) {
        config.type = "gwas";
      } else if ("FusionJuncSpan" === config.type && !config.format) {
        config.format = "fusionjuncspan";
      } else if ("aed" === config.type) {
        config.type = "annotation";
        config.format = config.format || "aed";
      }
    }

    /*
     * The MIT License (MIT)
     *
     * Copyright (c) 2014 Broad Institute
     *
     * Permission is hereby granted, free of charge, to any person obtaining a copy
     * of this software and associated documentation files (the "Software"), to deal
     * in the Software without restriction, including without limitation the rights
     * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
     * copies of the Software, and to permit persons to whom the Software is
     * furnished to do so, subject to the following conditions:
     *
     * The above copyright notice and this permission notice shall be included in
     * all copies or substantial portions of the Software.
     *
     *
     * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
     * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
     * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
     * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
     * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
     * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
     * THE SOFTWARE.
     */
    /**
     * Test if the given value is a string or number.  Not using typeof as it fails on boxed primitives.
     *
     * @param value
     * @returns boolean
     */


    function isSimpleType(value) {
      const simpleTypes = new Set(["boolean", "number", "string", "symbol"]);
      const valueType = typeof value;
      return value !== undefined && (simpleTypes.has(valueType) || value.substring || value.toFixed);
    }

    function buildOptions(config, options) {
      var defaultOptions = {
        oauthToken: config.oauthToken,
        headers: config.headers,
        withCredentials: config.withCredentials,
        filename: config.filename
      };
      return Object.assign(defaultOptions, options);
    }
    /**
     * isMobile test from http://detectmobilebrowsers.com
     * TODO -- improve UI design so this isn't neccessary
     * @returns {boolean}
     */
    // igv.isMobile = function () {
    //
    //     const a = (navigator.userAgent || navigator.vendor || window.opera);
    //     return (/(android|bb\d+|meego).+mobile|avantgo|bada\/|blackberry|blazer|compal|elaine|fennec|hiptop|iemobile|ip(hone|od)|iris|kindle|lge |maemo|midp|mmp|mobile.+firefox|netfront|opera m(ob|in)i|palm( os)?|phone|p(ixi|re)\/|plucker|pocket|psp|series(4|6)0|symbian|treo|up\.(browser|link)|vodafone|wap|windows ce|xda|xiino/i.test(a) ||
    //         /1207|6310|6590|3gso|4thp|50[1-6]i|770s|802s|a wa|abac|ac(er|oo|s\-)|ai(ko|rn)|al(av|ca|co)|amoi|an(ex|ny|yw)|aptu|ar(ch|go)|as(te|us)|attw|au(di|\-m|r |s )|avan|be(ck|ll|nq)|bi(lb|rd)|bl(ac|az)|br(e|v)w|bumb|bw\-(n|u)|c55\/|capi|ccwa|cdm\-|cell|chtm|cldc|cmd\-|co(mp|nd)|craw|da(it|ll|ng)|dbte|dc\-s|devi|dica|dmob|do(c|p)o|ds(12|\-d)|el(49|ai)|em(l2|ul)|er(ic|k0)|esl8|ez([4-7]0|os|wa|ze)|fetc|fly(\-|_)|g1 u|g560|gene|gf\-5|g\-mo|go(\.w|od)|gr(ad|un)|haie|hcit|hd\-(m|p|t)|hei\-|hi(pt|ta)|hp( i|ip)|hs\-c|ht(c(\-| |_|a|g|p|s|t)|tp)|hu(aw|tc)|i\-(20|go|ma)|i230|iac( |\-|\/)|ibro|idea|ig01|ikom|im1k|inno|ipaq|iris|ja(t|v)a|jbro|jemu|jigs|kddi|keji|kgt( |\/)|klon|kpt |kwc\-|kyo(c|k)|le(no|xi)|lg( g|\/(k|l|u)|50|54|\-[a-w])|libw|lynx|m1\-w|m3ga|m50\/|ma(te|ui|xo)|mc(01|21|ca)|m\-cr|me(rc|ri)|mi(o8|oa|ts)|mmef|mo(01|02|bi|de|do|t(\-| |o|v)|zz)|mt(50|p1|v )|mwbp|mywa|n10[0-2]|n20[2-3]|n30(0|2)|n50(0|2|5)|n7(0(0|1)|10)|ne((c|m)\-|on|tf|wf|wg|wt)|nok(6|i)|nzph|o2im|op(ti|wv)|oran|owg1|p800|pan(a|d|t)|pdxg|pg(13|\-([1-8]|c))|phil|pire|pl(ay|uc)|pn\-2|po(ck|rt|se)|prox|psio|pt\-g|qa\-a|qc(07|12|21|32|60|\-[2-7]|i\-)|qtek|r380|r600|raks|rim9|ro(ve|zo)|s55\/|sa(ge|ma|mm|ms|ny|va)|sc(01|h\-|oo|p\-)|sdk\/|se(c(\-|0|1)|47|mc|nd|ri)|sgh\-|shar|sie(\-|m)|sk\-0|sl(45|id)|sm(al|ar|b3|it|t5)|so(ft|ny)|sp(01|h\-|v\-|v )|sy(01|mb)|t2(18|50)|t6(00|10|18)|ta(gt|lk)|tcl\-|tdg\-|tel(i|m)|tim\-|t\-mo|to(pl|sh)|ts(70|m\-|m3|m5)|tx\-9|up(\.b|g1|si)|utst|v400|v750|veri|vi(rg|te)|vk(40|5[0-3]|\-v)|vm40|voda|vulc|vx(52|53|60|61|70|80|81|83|85|98)|w3c(\-| )|webc|whit|wi(g |nc|nw)|wmlb|wonu|x700|yas\-|your|zeto|zte\-/i.test(a.substr(0, 4)))
    //
    // }


    const doAutoscale = function (features) {
      var min, max;

      if (features.length > 0) {
        min = Number.MAX_VALUE;
        max = -Number.MAX_VALUE;
        features.forEach(function (f) {
          if (!Number.isNaN(f.value)) {
            min = Math.min(min, f.value);
            max = Math.max(max, f.value);
          }
        }); // Insure we have a zero baseline

        if (max > 0) min = Math.min(0, min);
        if (max < 0) max = 0;
      } else {
        // No features -- default
        min = 0;
        max = 100;
      }

      return {
        min: min,
        max: max
      };
    };

    const validateLocusExtent = function (chromosomeLengthBP, extent, minimumBP) {
      let ss = extent.start;
      let ee = extent.end;

      if (undefined === ee) {
        ss -= minimumBP / 2;
        ee = ss + minimumBP;

        if (ee > chromosomeLengthBP) {
          ee = chromosomeLengthBP;
          ss = ee - minimumBP;
        } else if (ss < 0) {
          ss = 0;
          ee = minimumBP;
        }
      } else if (ee - ss < minimumBP) {
        const center = (ee + ss) / 2;

        if (center - minimumBP / 2 < 0) {
          ss = 0;
          ee = ss + minimumBP;
        } else if (center + minimumBP / 2 > chromosomeLengthBP) {
          ee = chromosomeLengthBP;
          ss = ee - minimumBP;
        } else {
          ss = center - minimumBP / 2;
          ee = ss + minimumBP;
        }
      }

      extent.start = Math.ceil(ss);
      extent.end = Math.floor(ee);
    };
    /*!
     * is-number <https://github.com/jonschlinkert/is-number>
     *
     * Copyright (c) 2014-present, Jon Schlinkert.
     * Released under the MIT License.
     */


    const isNumber = function (num) {
      if (typeof num === 'number') {
        return num - num === 0;
      }

      if (typeof num === 'string' && num.trim() !== '') {
        return Number.isFinite ? Number.isFinite(+num) : isFinite(+num);
      }

      return false;
    };

    async function getFilename(url) {
      if (isString$3(url) && url.startsWith("https://drive.google.com")) {
        // This will fail if Google API key is not defined
        if (getApiKey() === undefined) {
          throw Error("Google drive is referenced, but API key is not defined.  An API key is required for Google Drive access");
        }

        const json = await getDriveFileInfo(url);
        return json.originalFileName || json.name;
      } else {
        return getFilename$1(url);
      }
    }

    function prettyBasePairNumber(raw) {
      var denom, units, value, floored;

      if (raw > 1e7) {
        denom = 1e6;
        units = " mb";
      } else if (raw > 1e4) {
        denom = 1e3;
        units = " kb";
        value = raw / denom;
        floored = Math.floor(value);
        return numberFormatter$1(floored) + units;
      } else {
        return numberFormatter$1(raw) + " bp";
      }

      value = raw / denom;
      floored = Math.floor(value);
      return floored.toString() + units;
    }

    function isDataURL(obj) {
      return isString$3(obj) && obj.startsWith("data:");
    }

    function createColumn(columnContainer, className) {
      const column = div$1({
        class: className
      });
      columnContainer.appendChild(column);
    }

    function insertElementBefore(element, referenceNode) {
      referenceNode.parentNode.insertBefore(element, referenceNode);
    }

    function insertElementAfter(element, referenceNode) {
      referenceNode.parentNode.insertBefore(element, referenceNode.nextSibling);
    }
    /**
     * Test to see if page is loaded in a secure context, that is by https or is localhost.
     */


    function isSecureContext() {
      return window.location.protocol === "https:" || window.location.hostname === "localhost";
    }

    const pairs = [['A', 'T'], ['G', 'C'], ['Y', 'R'], ['W', 'S'], ['K', 'M'], ['D', 'H'], ['B', 'V']];
    const complements = new Map();

    for (let p of pairs) {
      const p1 = p[0];
      const p2 = p[1];
      complements.set(p1, p2);
      complements.set(p2, p1);
      complements.set(p1.toLowerCase(), p2.toLowerCase());
      complements.set(p2.toLowerCase(), p1.toLowerCase());
    }

    function reverseComplementSequence(sequence) {
      let comp = '';
      let idx = sequence.length;

      while (idx-- > 0) {
        const base = sequence[idx];
        comp += complements.has(base) ? complements.get(base) : base;
      }

      return comp;
    }

    /*
     * The MIT License (MIT)
     *
     * Copyright (c) 2014 Broad Institute
     *
     * Permission is hereby granted, free of charge, to any person obtaining a copy
     * of this software and associated documentation files (the "Software"), to deal
     * in the Software without restriction, including without limitation the rights
     * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
     * copies of the Software, and to permit persons to whom the Software is
     * furnished to do so, subject to the following conditions:
     *
     * The above copyright notice and this permission notice shall be included in
     * all copies or substantial portions of the Software.
     *
     *
     * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
     * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
     * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
     * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
     * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
     * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
     * THE SOFTWARE.
     */
    const defaultSequenceTrackOrder = Number.MIN_SAFE_INTEGER;
    const translationDict = {
      'TTT': 'F',
      'TTC': 'F',
      'TTA': 'L',
      'TTG': 'L',
      'CTT': 'L',
      'CTC': 'L',
      'CTA': 'L',
      'CTG': 'L',
      'ATT': 'I',
      'ATC': 'I',
      'ATA': 'I',
      'ATG': 'M',
      'GTT': 'V',
      'GTC': 'V',
      'GTA': 'V',
      'GTG': 'V',
      'TCT': 'S',
      'TCC': 'S',
      'TCA': 'S',
      'TCG': 'S',
      'CCT': 'P',
      'CCC': 'P',
      'CCA': 'P',
      'CCG': 'P',
      'ACT': 'T',
      'ACC': 'T',
      'ACA': 'T',
      'ACG': 'T',
      'GCT': 'A',
      'GCC': 'A',
      'GCA': 'A',
      'GCG': 'A',
      'TAT': 'Y',
      'TAC': 'Y',
      'TAA': 'STOP',
      'TAG': 'STOP',
      'CAT': 'H',
      'CAC': 'H',
      'CAA': 'Q',
      'CAG': 'Q',
      'AAT': 'N',
      'AAC': 'N',
      'AAA': 'K',
      'AAG': 'K',
      'GAT': 'D',
      'GAC': 'D',
      'GAA': 'E',
      'GAG': 'E',
      'TGT': 'C',
      'TGC': 'C',
      'TGA': 'STOP',
      'TGG': 'W',
      'CGT': 'R',
      'CGC': 'R',
      'CGA': 'R',
      'CGG': 'R',
      'AGT': 'S',
      'AGC': 'S',
      'AGA': 'R',
      'AGG': 'R',
      'GGT': 'G',
      'GGC': 'G',
      'GGA': 'G',
      'GGG': 'G'
    };
    const complement = {};
    const t1 = ['A', 'G', 'C', 'T', 'Y', 'R', 'W', 'S', 'K', 'M', 'D', 'V', 'H', 'B', 'N', 'X'];
    const t2 = ['T', 'C', 'G', 'A', 'R', 'Y', 'W', 'S', 'M', 'K', 'H', 'B', 'D', 'V', 'N', 'X'];

    for (let i = 0; i < t1.length; i++) {
      complement[t1[i]] = t2[i];
      complement[t1[i].toLowerCase()] = t2[i].toLowerCase();
    }

    const DEFAULT_HEIGHT = 25;
    const TRANSLATED_HEIGHT = 115;
    const SEQUENCE_HEIGHT = 15;
    const FRAME_HEIGHT = 25;
    const FRAME_BORDER = 5;

    class SequenceTrack {
      constructor(config, browser) {
        this.type = "sequence";
        this.browser = browser;
        this.removable = false;
        this.config = config;
        this.name = "Sequence";
        this.id = "sequence";
        this.sequenceType = config.sequenceType || "dna"; //   dna | rna | prot

        this.disableButtons = false;
        this.order = config.order || defaultSequenceTrackOrder;
        this.ignoreTrackMenu = false;
        this.reversed = config.reversed === true;
        this.frameTranslate = config.frameTranslate === true;
        this.height = this.frameTranslate ? TRANSLATED_HEIGHT : DEFAULT_HEIGHT;
      }

      menuItemList() {
        return [{
          name: this.reversed ? "Forward" : "Reverse",
          click: () => {
            this.reversed = !this.reversed;
            this.trackView.repaintViews();
          }
        }, {
          name: this.frameTranslate ? "Close Translation" : "Three-frame Translate",
          click: () => {
            this.frameTranslate = !this.frameTranslate;

            if (this.frameTranslate) {
              for (let vp of this.trackView.viewports) {
                vp.setContentHeight(TRANSLATED_HEIGHT);
              }

              this.trackView.setTrackHeight(TRANSLATED_HEIGHT);
            } else {
              for (let vp of this.trackView.viewports) {
                vp.setContentHeight(DEFAULT_HEIGHT);
              }

              this.trackView.setTrackHeight(DEFAULT_HEIGHT);
            }

            this.trackView.repaintViews();
          }
        }];
      }

      contextMenuItemList(clickState) {
        const viewport = clickState.viewport;

        if (viewport.referenceFrame.bpPerPixel <= 1) {
          const pixelWidth = viewport.getWidth();
          const bpWindow = pixelWidth * viewport.referenceFrame.bpPerPixel;
          const chr = viewport.referenceFrame.chr;
          const start = Math.floor(viewport.referenceFrame.start);
          const end = Math.ceil(start + bpWindow);
          const items = [{
            label: this.reversed ? 'View visible sequence (reversed)...' : 'View visible sequence...',
            click: async () => {
              let seq = await this.browser.genome.sequence.getSequence(chr, start, end);

              if (this.reversed) {
                seq = reverseComplementSequence(seq);
              }

              Alert.presentAlert(seq);
            }
          }];

          if (isSecureContext()) {
            items.push({
              label: 'Copy visible sequence',
              click: async () => {
                let seq = await this.browser.genome.sequence.getSequence(chr, start, end);

                if (this.reversed) {
                  seq = reverseComplementSequence(seq);
                }

                try {
                  await navigator.clipboard.writeText(seq);
                } catch (e) {
                  console.error(e);
                  Alert.presentAlert(`error copying sequence to clipboard ${e}`);
                }
              }
            });
          }

          items.push('<hr/>');
          return items;
        } else {
          return undefined;
        }
      }

      translateSequence(seq) {
        const threeFrame = [[], [], []];

        for (let fNum of [0, 1, 2]) {
          let idx = fNum;

          while (seq.length - idx >= 3) {
            let st = seq.slice(idx, idx + 3);

            if (this.reversed) {
              st = st.split('').reverse().join('');
            }

            const aa = translationDict[st.toUpperCase()] || "";
            threeFrame[fNum].push({
              codons: st,
              aminoA: aa
            });
            idx += 3;
          }
        }

        return threeFrame;
      }

      async getFeatures(chr, start, end, bpPerPixel) {
        start = Math.floor(start);
        end = Math.floor(end);

        if (bpPerPixel && bpPerPixel > 1) {
          return null;
        } else {
          const sequence = await this.browser.genome.sequence.getSequence(chr, start, end);
          return {
            bpStart: start,
            sequence: sequence
          };
        }
      }

      draw(options) {
        const ctx = options.context;

        if (options.features) {
          let sequence = options.features.sequence;

          if (this.reversed) {
            sequence = sequence.split('').map(function (cv) {
              return complement[cv];
            }).join('');
          }

          const sequenceBpStart = options.features.bpStart; // genomic position at start of sequence

          const bpEnd = 1 + options.bpStart + options.pixelWidth * options.bpPerPixel;

          for (let bp = Math.floor(options.bpStart); bp <= bpEnd; bp++) {
            const seqIdx = Math.floor(bp - sequenceBpStart);

            if (seqIdx >= 0 && seqIdx < sequence.length) {
              const baseLetter = sequence[seqIdx];
              const offsetBP = bp - options.bpStart;
              const aPixel = offsetBP / options.bpPerPixel;
              const pixelWidth = 1 / options.bpPerPixel;
              const color = this.fillColor(baseLetter);

              if (options.bpPerPixel > 1 / 10) {
                IGVGraphics.fillRect(ctx, aPixel, 5, pixelWidth, SEQUENCE_HEIGHT - 5, {
                  fillStyle: color
                });
              } else {
                let textPixel = aPixel + 0.5 * (pixelWidth - ctx.measureText(baseLetter).width);
                IGVGraphics.strokeText(ctx, baseLetter, textPixel, SEQUENCE_HEIGHT, {
                  strokeStyle: color
                });
              }
            }
          }

          if (this.frameTranslate) {
            let y = SEQUENCE_HEIGHT + 2 * FRAME_BORDER;
            const translatedSequence = this.translateSequence(sequence);

            for (let fNum = 0; fNum < translatedSequence.length; fNum++) {
              // == 3, 1 for each frame
              const aaSequence = translatedSequence[fNum]; // AA sequence for this frame

              for (let idx = 0; idx < aaSequence.length; idx++) {
                let color = 0 === idx % 2 ? 'rgb(160,160,160)' : 'rgb(224,224,224)';
                const cv = aaSequence[idx];
                const bpPos = sequenceBpStart + fNum + idx * 3;
                const bpOffset = bpPos - options.bpStart;
                const p0 = Math.floor(bpOffset / options.bpPerPixel);
                const p1 = Math.floor((bpOffset + 3) / options.bpPerPixel);
                const pc = Math.round((p0 + p1) / 2);

                if (p1 < 0) {
                  continue; // off left edge
                } else if (p0 > options.pixelWidth) {
                  break; // off right edge
                }

                let aaLabel = cv.aminoA;

                if (cv.aminoA.indexOf('STOP') > -1) {
                  color = 'rgb(255, 0, 0)';
                  aaLabel = 'STOP'; //Color blind accessible
                } else if (cv.aminoA === 'M') {
                  color = 'rgb(0, 153, 0)';
                  aaLabel = 'START'; //Color blind accessible
                }

                IGVGraphics.fillRect(ctx, p0, y, p1 - p0, FRAME_HEIGHT, {
                  fillStyle: color
                });

                if (options.bpPerPixel <= 1 / 10) {
                  IGVGraphics.strokeText(ctx, aaLabel, pc - ctx.measureText(aaLabel).width / 2, y + 15);
                }
              }

              y += FRAME_HEIGHT + FRAME_BORDER;
            }
          }
        }
      }

      get supportsWholeGenome() {
        return false;
      }

      computePixelHeight(ignore) {
        this.height = this.frameTranslate ? TRANSLATED_HEIGHT : DEFAULT_HEIGHT;
        return this.height;
      }

      fillColor(index) {
        if (this.color) {
          return this.color;
        } else if ("dna" === this.sequenceType) {
          return this.browser.nucleotideColors[index] || 'gray';
        } else {
          return 'rgb(0, 0, 150)';
        }
      }
      /**
       * Return the current state of the track.  Used to create sessions and bookmarks.
       *
       * @returns {*|{}}
       */


      getState() {
        const config = {
          type: "sequence"
        };

        if (this.order !== defaultSequenceTrackOrder) {
          config.order = this.order;
        }

        if (this.reversed) {
          config.revealed = true;
        }

        return config;
      }

    }

    /*
     * The MIT License (MIT)
     *
     * Copyright (c) 2014 Broad Institute
     *
     * Permission is hereby granted, free of charge, to any person obtaining a copy
     * of this software and associated documentation files (the "Software"), to deal
     * in the Software without restriction, including without limitation the rights
     * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
     * copies of the Software, and to permit persons to whom the Software is
     * furnished to do so, subject to the following conditions:
     *
     * The above copyright notice and this permission notice shall be included in
     * all copies or substantial portions of the Software.
     *
     *
     * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
     * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
     * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
     * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
     * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
     * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
     * THE SOFTWARE.
     */

    class Viewport {
      constructor(trackView, viewportColumn, referenceFrame, width) {
        this.guid = guid$2();
        this.trackView = trackView;
        this.referenceFrame = referenceFrame;
        this.browser = trackView.browser;
        this.$viewport = $$1('<div class="igv-viewport">');
        viewportColumn.appendChild(this.$viewport.get(0));

        if (trackView.track.height) {
          this.$viewport.get(0).style.height = `${trackView.track.height}px`;
        } // Create an alert dialog for the sequence track to copy ref sequence to.


        if (trackView.track instanceof SequenceTrack) {
          this.alert = new AlertDialog(this.$viewport.get(0));
        }

        this.$content = $$1("<div>", {
          class: 'igv-viewport-content'
        });
        this.$viewport.append(this.$content);
        this.$content.height(this.$viewport.height());
        this.contentDiv = this.$content.get(0); // this.$canvas = $('<canvas>')
        // this.$content.append(this.$canvas)
        //
        // this.canvas = this.$canvas.get(0)
        // this.ctx = this.canvas.getContext("2d")

        this.$viewport.width(width);
        this.initializationHelper();
      }

      initializationHelper() {}

      showMessage(message) {
        if (!this.messageDiv) {
          this.messageDiv = document.createElement('div');
          this.messageDiv.className = 'igv-viewport-message';
          this.contentDiv.append(this.messageDiv);
        }

        this.messageDiv.textContent = message;
        this.messageDiv.style.display = 'inline-block';
      }

      hideMessage(message) {
        if (this.messageDiv) this.messageDiv.style.display = 'none';
      }

      setTrackLabel(label) {}

      startSpinner() {}

      stopSpinner() {}

      checkZoomIn() {
        return true;
      }

      shift() {}

      setTop(contentTop) {
        const viewportHeight = this.$viewport.height();
        const viewTop = -contentTop;
        const viewBottom = viewTop + viewportHeight;
        this.$content.css('top', `${contentTop}px`);

        if (undefined === this.canvasVerticalRange || this.canvasVerticalRange.bottom < viewBottom || this.canvasVerticalRange.top > viewTop) {
          this.repaint();
        }
      }

      async loadFeatures() {
        return undefined;
      }

      async repaint() {
        console.log('Viewport - repaint()');
      }

      draw(drawConfiguration, features, roiFeatures) {
        console.log('Viewport - draw(drawConfiguration, features, roiFeatures)');
      }

      checkContentHeight(features) {
        let track = this.trackView.track;
        features = features || this.cachedFeatures;

        if ("FILL" === track.displayMode) {
          this.setContentHeight(this.$viewport.height());
        } else if (typeof track.computePixelHeight === 'function') {
          if (features && features.length > 0) {
            let requiredContentHeight = track.computePixelHeight(features);
            let currentContentHeight = this.$content.height();

            if (requiredContentHeight !== currentContentHeight) {
              this.setContentHeight(requiredContentHeight);
            }
          }
        }
      }

      getContentHeight() {
        return this.$content.height();
      }

      setContentHeight(contentHeight) {
        // Maximum height of a canvas is ~32,000 pixels on Chrome, possibly smaller on other platforms
        contentHeight = Math.min(contentHeight, 32000);
        this.$content.height(contentHeight);
      }

      isLoading() {
        return false;
      }

      saveSVG() {}

      isVisible() {
        return this.$viewport.width();
      }

      setWidth(width) {
        this.$viewport.width(width);
      }

      getWidth() {
        return this.$viewport.width();
      }

      getContentTop() {
        return this.contentDiv.offsetTop;
      }

      containsPosition(chr, position) {
        console.log('Viewport - containsPosition(chr, position)');
      }

      addMouseHandlers() {}

      removeMouseHandlers() {}
      /**
       * Called when the associated track is removed.  Do any needed cleanup here.
       */


      dispose() {
        if (this.popover) {
          this.popover.dispose();
        }

        this.$viewport.get(0).remove(); // Null out all properties -- this should not be neccessary, but just in case there is a
        // reference to self somewhere we want to free memory.

        for (let key of Object.keys(this)) {
          this[key] = undefined;
        }
      }

    }

    /*!!
     *  Canvas 2 Svg v1.0.19
     *  A low level canvas to SVG converter. Uses a mock canvas context to build an SVG document.
     *
     *  Licensed under the MIT license:
     *  http://www.opensource.org/licenses/mit-license.php
     *
     *  Author:
     *  Kerry Liu
     *
     *  Copyright (c) 2014 Gliffy Inc.
     */

    function format(str, args) {
      var keys = Object.keys(args),
          i;

      for (i = 0; i < keys.length; i++) {
        str = str.replace(new RegExp("\\{" + keys[i] + "\\}", "gi"), args[keys[i]]);
      }

      return str;
    } //helper function that generates a random string


    function randomString(holder) {
      var chars, randomstring, i;

      if (!holder) {
        throw new Error("cannot create a random attribute name for an undefined object");
      }

      chars = "ABCDEFGHIJKLMNOPQRSTUVWXTZabcdefghiklmnopqrstuvwxyz";
      randomstring = "";

      do {
        randomstring = "";

        for (i = 0; i < 12; i++) {
          randomstring += chars[Math.floor(Math.random() * chars.length)];
        }
      } while (holder[randomstring]);

      return randomstring;
    } //helper function to map named to numbered entities


    function createNamedToNumberedLookup(items, radix) {
      var i,
          entity,
          lookup = {},
          base10;
      items = items.split(',');
      radix = radix || 10; // Map from named to numbered entities.

      for (i = 0; i < items.length; i += 2) {
        entity = '&' + items[i + 1] + ';';
        base10 = parseInt(items[i], radix);
        lookup[entity] = '&#' + base10 + ';';
      } //FF and IE need to create a regex from hex values ie &nbsp; == \xa0


      lookup["\\xa0"] = '&#160;';
      return lookup;
    } //helper function to map canvas-textAlign to svg-textAnchor


    function getTextAnchor(textAlign) {
      //TODO: support rtl languages
      var mapping = {
        "left": "start",
        "right": "end",
        "center": "middle",
        "start": "start",
        "end": "end"
      };
      return mapping[textAlign] || mapping.start;
    } //helper function to map canvas-textBaseline to svg-dominantBaseline


    function getDominantBaseline(textBaseline) {
      //INFO: not supported in all browsers
      var mapping = {
        "alphabetic": "alphabetic",
        "hanging": "hanging",
        "top": "text-before-edge",
        "bottom": "text-after-edge",
        "middle": "central"
      };
      return mapping[textBaseline] || mapping.alphabetic;
    }
    /**
     * Return a new normalized vector of given vector
     */


    function normalize(vector) {
      var len = Math.sqrt(vector[0] * vector[0] + vector[1] * vector[1]);
      return [vector[0] / len, vector[1] / len];
    }

    function intersectRect(rect1, rect2) {
      return rect1.x < rect2.x + rect2.width && rect1.x + rect1.width > rect2.x && rect1.y < rect2.y + rect2.height && rect1.y + rect1.height > rect2.y;
    } // Unpack entities lookup where the numbers are in radix 32 to reduce the size
    // entity mapping courtesy of tinymce


    const namedEntities = createNamedToNumberedLookup('50,nbsp,51,iexcl,52,cent,53,pound,54,curren,55,yen,56,brvbar,57,sect,58,uml,59,copy,' + '5a,ordf,5b,laquo,5c,not,5d,shy,5e,reg,5f,macr,5g,deg,5h,plusmn,5i,sup2,5j,sup3,5k,acute,' + '5l,micro,5m,para,5n,middot,5o,cedil,5p,sup1,5q,ordm,5r,raquo,5s,frac14,5t,frac12,5u,frac34,' + '5v,iquest,60,Agrave,61,Aacute,62,Acirc,63,Atilde,64,Auml,65,Aring,66,AElig,67,Ccedil,' + '68,Egrave,69,Eacute,6a,Ecirc,6b,Euml,6c,Igrave,6d,Iacute,6e,Icirc,6f,Iuml,6g,ETH,6h,Ntilde,' + '6i,Ograve,6j,Oacute,6k,Ocirc,6l,Otilde,6m,Ouml,6n,times,6o,Oslash,6p,Ugrave,6q,Uacute,' + '6r,Ucirc,6s,Uuml,6t,Yacute,6u,THORN,6v,szlig,70,agrave,71,aacute,72,acirc,73,atilde,74,auml,' + '75,aring,76,aelig,77,ccedil,78,egrave,79,eacute,7a,ecirc,7b,euml,7c,igrave,7d,iacute,7e,icirc,' + '7f,iuml,7g,eth,7h,ntilde,7i,ograve,7j,oacute,7k,ocirc,7l,otilde,7m,ouml,7n,divide,7o,oslash,' + '7p,ugrave,7q,uacute,7r,ucirc,7s,uuml,7t,yacute,7u,thorn,7v,yuml,ci,fnof,sh,Alpha,si,Beta,' + 'sj,Gamma,sk,Delta,sl,Epsilon,sm,Zeta,sn,Eta,so,Theta,sp,Iota,sq,Kappa,sr,Lambda,ss,Mu,' + 'st,Nu,su,Xi,sv,Omicron,t0,Pi,t1,Rho,t3,Sigma,t4,Tau,t5,Upsilon,t6,Phi,t7,Chi,t8,Psi,' + 't9,Omega,th,alpha,ti,beta,tj,gamma,tk,delta,tl,epsilon,tm,zeta,tn,eta,to,theta,tp,iota,' + 'tq,kappa,tr,lambda,ts,mu,tt,nu,tu,xi,tv,omicron,u0,pi,u1,rho,u2,sigmaf,u3,sigma,u4,tau,' + 'u5,upsilon,u6,phi,u7,chi,u8,psi,u9,omega,uh,thetasym,ui,upsih,um,piv,812,bull,816,hellip,' + '81i,prime,81j,Prime,81u,oline,824,frasl,88o,weierp,88h,image,88s,real,892,trade,89l,alefsym,' + '8cg,larr,8ch,uarr,8ci,rarr,8cj,darr,8ck,harr,8dl,crarr,8eg,lArr,8eh,uArr,8ei,rArr,8ej,dArr,' + '8ek,hArr,8g0,forall,8g2,part,8g3,exist,8g5,empty,8g7,nabla,8g8,isin,8g9,notin,8gb,ni,8gf,prod,' + '8gh,sum,8gi,minus,8gn,lowast,8gq,radic,8gt,prop,8gu,infin,8h0,ang,8h7,and,8h8,or,8h9,cap,8ha,cup,' + '8hb,int,8hk,there4,8hs,sim,8i5,cong,8i8,asymp,8j0,ne,8j1,equiv,8j4,le,8j5,ge,8k2,sub,8k3,sup,8k4,' + 'nsub,8k6,sube,8k7,supe,8kl,oplus,8kn,otimes,8l5,perp,8m5,sdot,8o8,lceil,8o9,rceil,8oa,lfloor,8ob,' + 'rfloor,8p9,lang,8pa,rang,9ea,loz,9j0,spades,9j3,clubs,9j5,hearts,9j6,diams,ai,OElig,aj,oelig,b0,' + 'Scaron,b1,scaron,bo,Yuml,m6,circ,ms,tilde,802,ensp,803,emsp,809,thinsp,80c,zwnj,80d,zwj,80e,lrm,' + '80f,rlm,80j,ndash,80k,mdash,80o,lsquo,80p,rsquo,80q,sbquo,80s,ldquo,80t,rdquo,80u,bdquo,810,dagger,' + '811,Dagger,81g,permil,81p,lsaquo,81q,rsaquo,85c,euro', 32); //Some basic mappings for attributes and default values.

    const STYLES = {
      "strokeStyle": {
        svgAttr: "stroke",
        //corresponding svg attribute
        canvas: "#000000",
        //canvas default
        svg: "none",
        //svg default
        apply: "stroke" //apply on stroke() or fill()

      },
      "fillStyle": {
        svgAttr: "fill",
        canvas: "#000000",
        svg: null,
        //svg default is black, but we need to special case this to handle canvas stroke without fill
        apply: "fill"
      },
      "lineCap": {
        svgAttr: "stroke-linecap",
        canvas: "butt",
        svg: "butt",
        apply: "stroke"
      },
      "lineJoin": {
        svgAttr: "stroke-linejoin",
        canvas: "miter",
        svg: "miter",
        apply: "stroke"
      },
      "miterLimit": {
        svgAttr: "stroke-miterlimit",
        canvas: 10,
        svg: 4,
        apply: "stroke"
      },
      "lineWidth": {
        svgAttr: "stroke-width",
        canvas: 1,
        svg: 1,
        apply: "stroke"
      },
      "globalAlpha": {
        svgAttr: "opacity",
        canvas: 1,
        svg: 1,
        apply: "fill stroke"
      },
      "font": {
        //font converts to multiple svg attributes, there is custom logic for this
        canvas: "10px sans-serif"
      },
      "shadowColor": {
        canvas: "#000000"
      },
      "shadowOffsetX": {
        canvas: 0
      },
      "shadowOffsetY": {
        canvas: 0
      },
      "shadowBlur": {
        canvas: 0
      },
      "textAlign": {
        canvas: "start"
      },
      "textBaseline": {
        canvas: "alphabetic"
      },
      "lineDash": {
        svgAttr: "stroke-dasharray",
        canvas: [],
        svg: null,
        apply: "stroke"
      }
    };
    /**
     *
     * @param gradientNode - reference to the gradient
     * @constructor
     */

    class CanvasGradient {
      constructor(gradientNode, ctx) {
        this.__root = gradientNode;
        this.__ctx = ctx;
      }
      /**
       * Adds a color stop to the gradient root
       */


      addColorStop(offset, color) {
        var stop = this.__ctx.__createElement("stop"),
            regex,
            matches;

        stop.setAttribute("offset", offset);

        if (color && color.indexOf("rgba") !== -1) {
          //separate alpha value, since webkit can't handle it
          regex = /rgba\(\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d?\.?\d*)\s*\)/gi;
          matches = regex.exec(color);
          stop.setAttribute("stop-color", format("rgb({r},{g},{b})", {
            r: matches[1],
            g: matches[2],
            b: matches[3]
          }));
          stop.setAttribute("stop-opacity", matches[4]);
        } else {
          stop.setAttribute("stop-color", color);
        }

        this.__root.appendChild(stop);
      }

    }

    class CanvasPattern {
      constructor(pattern, ctx) {
        this.__root = pattern;
        this.__ctx = ctx;
      }

    }
    /**
     * The mock canvas context
     * @param config - options include:
     * ctx - existing Context2D to wrap around
     * width - width of your canvas (defaults to 500)
     * height - height of your canvas (defaults to 500)
     * enableMirroring - enables canvas mirroring (get image data) (defaults to false)
     * document - the document object (defaults to the current document)
     */


    class ctx {
      constructor(config) {
        if (!(this instanceof ctx)) {
          //did someone call this without new?
          return new ctx(config);
        } // clone config


        this.config = config; //setup options

        this.width = config.width;
        this.height = config.height;
        this.enableMirroring = config.enableMirroring || false;
        this.canvas = this; ///point back to this instance!

        this.__document = document; // allow passing in an existing context to wrap around
        // if a context is passed in, we know a canvas already exist

        if (config.ctx) {
          this.__ctx = config.ctx;
        } else {
          this.__canvas = this.__document.createElement("canvas");
          this.__ctx = this.__canvas.getContext("2d");
        } // give this canvas a type


        this.isSVG = true;

        this.__setDefaultStyles();

        this.__stack = [this.__getStyleState()];
        this.__groupStack = []; // root svg element

        this.__root = this.__createElement("svg");

        this.__root.setAttribute("width", this.width);

        this.__root.setAttribute("height", this.height); // allow contents to overflow svg bbox


        this.__root.setAttribute('overflow', 'visible'); // viewbox


        if (config.viewbox) {
          const str = config.viewbox.x + ' ' + config.viewbox.y + ' ' + config.viewbox.width + ' ' + config.viewbox.height;

          this.__root.setAttribute("viewBox", str);

          this.viewbox = config.viewbox;
        } // make sure we don't generate the same ids in defs


        this.__ids = {}; // defs

        this.__defs = this.__createElement("defs");

        this.__root.appendChild(this.__defs);

        this.multiLocusGap = config.multiLocusGap; // svg background color

        let backdropConfig = {
          id: 'svg_output_backdrop',
          width: '100%',
          height: '100%',
          fill: config.backdropColor || 'white'
        };

        let backdropRect = this.__createElement('rect', backdropConfig);

        this.__root.appendChild(backdropRect); // root group


        this.__rootGroup = this.__createElement('g', {
          id: 'root-group'
        });

        this.__root.appendChild(this.__rootGroup); // point current element to root group


        this.__currentElement = this.__rootGroup;
      }

      setWidth(width) {
        this.width = width;

        this.__root.setAttribute("width", this.width);

        const str = this.config.viewbox.x + ' ' + this.config.viewbox.y + ' ' + width + ' ' + this.config.viewbox.height;

        this.__root.setAttribute("viewBox", str);
      }

      setHeight(height) {
        this.height = height;

        this.__root.setAttribute("height", this.height);

        const str = this.config.viewbox.x + ' ' + this.config.viewbox.y + ' ' + this.config.viewbox.width + ' ' + height;

        this.__root.setAttribute("viewBox", str);
      }

      /**
       * Creates the specified svg element
       * @private
       */
      __createElement(elementName, properties, resetFill) {
        if (typeof properties === "undefined") {
          properties = {};
        }

        let element = this.__document.createElementNS("http://www.w3.org/2000/svg", elementName);

        if (resetFill) {
          //if fill or stroke is not specified, the svg element should not display. By default SVG's fill is black.
          element.setAttribute("fill", "none");
          element.setAttribute("stroke", "none");
        }

        for (let key of Object.keys(properties)) {
          element.setAttribute(key, properties[key]);
        }

        return element;
      }

      /**
       * Applies default canvas styles to the context
       * @private
       */
      __setDefaultStyles() {
        //default 2d canvas context properties see:http://www.w3.org/TR/2dcontext/
        var keys = Object.keys(STYLES),
            i,
            key;

        for (i = 0; i < keys.length; i++) {
          key = keys[i];
          this[key] = STYLES[key].canvas;
        }
      }

      /**
       * Applies styles on restore
       * @param styleState
       * @private
       */
      __applyStyleState(styleState) {
        var keys = Object.keys(styleState),
            i,
            key;

        for (i = 0; i < keys.length; i++) {
          key = keys[i];
          this[key] = styleState[key];
        }
      }

      /**
       * Gets the current style state
       * @return {Object}
       * @private
       */
      __getStyleState() {
        var i,
            styleState = {},
            keys = Object.keys(STYLES),
            key;

        for (i = 0; i < keys.length; i++) {
          key = keys[i];
          styleState[key] = this[key];
        }

        return styleState;
      }

      /**
       * Apples the current styles to the current SVG element. On "ctx.fill" or "ctx.stroke"
       * @param type
       * @private
       */
      __applyStyleToCurrentElement(type) {
        var currentElement = this.__currentElement;
        var currentStyleGroup = this.__currentElementsToStyle;

        if (currentStyleGroup) {
          currentElement.setAttribute(type, "");
          currentElement = currentStyleGroup.element;
          currentStyleGroup.children.forEach(function (node) {
            node.setAttribute(type, "");
          });
        }

        var keys = Object.keys(STYLES),
            i,
            style,
            value,
            id,
            regex,
            matches;

        for (i = 0; i < keys.length; i++) {
          style = STYLES[keys[i]];
          value = this[keys[i]];

          if (style.apply) {
            //is this a gradient or pattern?
            if (value instanceof CanvasPattern) {
              //pattern
              if (value.__ctx) {
                //copy over defs
                while (value.__ctx.__defs.childNodes.length) {
                  id = value.__ctx.__defs.childNodes[0].getAttribute("id");
                  this.__ids[id] = id;

                  this.__defs.appendChild(value.__ctx.__defs.childNodes[0]);
                }
              }

              currentElement.setAttribute(style.apply, format("url(#{id})", {
                id: value.__root.getAttribute("id")
              }));
            } else if (value instanceof CanvasGradient) {
              //gradient
              currentElement.setAttribute(style.apply, format("url(#{id})", {
                id: value.__root.getAttribute("id")
              }));
            } else if (style && style.apply.indexOf(type) !== -1 && style.svg !== value) {
              if ((style.svgAttr === "stroke" || style.svgAttr === "fill") && value && value.indexOf("rgba") !== -1) {
                //separate alpha value, since illustrator can't handle it
                regex = /rgba\(\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d?\.?\d*)\s*\)/gi;
                matches = regex.exec(value);
                currentElement.setAttribute(style.svgAttr, format("rgb({r},{g},{b})", {
                  r: matches[1],
                  g: matches[2],
                  b: matches[3]
                })); //should take globalAlpha here

                var opacity = matches[4];
                var globalAlpha = this.globalAlpha;

                if (globalAlpha != null) {
                  opacity *= globalAlpha;
                }

                currentElement.setAttribute(style.svgAttr + "-opacity", opacity);
              } else {
                var attr = style.svgAttr;

                if (keys[i] === 'globalAlpha') {
                  attr = type + '-' + style.svgAttr;

                  if (currentElement.getAttribute(attr)) {
                    //fill-opacity or stroke-opacity has already been set by stroke or fill.
                    continue;
                  }
                } //otherwise only update attribute if right type, and not svg default


                currentElement.setAttribute(attr, value);
              }
            }
          }
        }
      }

      /**
       * Will return the closest group or svg node. May return the current element.
       * @private
       */
      __closestGroupOrSvg(node) {
        node = node || this.__currentElement;

        if (node.nodeName === "g" || node.nodeName === "svg") {
          return node;
        } else {
          return this.__closestGroupOrSvg(node.parentNode);
        }
      }

      /**
       * Returns the serialized value of the svg so far
       * @param fixNamedEntities - Standalone SVG doesn't support named entities, which document.createTextNode encodes.
       *                           If true, we attempt to find all named entities and encode it as a numeric entity.
       * @return serialized svg
       */
      getSerializedSvg(fixNamedEntities) {
        var serialized = new XMLSerializer().serializeToString(this.__root),
            keys,
            i,
            key,
            value,
            regexp;
     //IE search for a duplicate xmnls because they didn't implement setAttributeNS correctly
        // xmlns = /xmlns="http:\/\/www\.w3\.org\/2000\/svg".+xmlns="http:\/\/www\.w3\.org\/2000\/svg/gi;
        // if (xmlns.test(serialized)) {
        //     serialized = serialized.replace('xmlns="http://www.w3.org/2000/svg','xmlns:xlink="http://www.w3.org/1999/xlink');
        // }

        if (fixNamedEntities) {
          keys = Object.keys(namedEntities); //loop over each named entity and replace with the proper equivalent.

          for (i = 0; i < keys.length; i++) {
            key = keys[i];
            value = namedEntities[key];
            regexp = new RegExp(key, "gi");

            if (regexp.test(serialized)) {
              serialized = serialized.replace(regexp, value);
            }
          }
        }

        return serialized;
      }

      /**
       * Returns the root svg
       * @return
       */
      getSvg() {
        return this.__root;
      }

      /**
       * Will generate a group tag.
       */
      saveWithTranslationAndClipRect(id, tx, ty, width, height, clipYOffset) {
        // clip rect
        const clip_id = `${id}_clip_rect`;

        let clipPath = this.__createElement('clipPath', {
          id: clip_id
        });

        this.__defs.appendChild(clipPath);

        const config = {
          x: '0',
          y: clipYOffset.toString(),
          width: width.toString(),
          height: height.toString()
        };
        clipPath.appendChild(this.__createElement('rect', config));

        const group = this.__createElement("g");

        group.setAttribute('transform', format('translate({x},{y})', {
          x: tx,
          y: ty
        }));
        group.setAttribute('clip-path', format('url(#{id})', {
          id: clip_id
        }));

        const parent = this.__closestGroupOrSvg();

        parent.appendChild(group);

        this.__groupStack.push(parent);

        this.__currentElement = group;

        this.__stack.push(this.__getStyleState());
      }

      save() {
        var group = this.__createElement("g");

        var parent = this.__closestGroupOrSvg();

        this.__groupStack.push(parent);

        parent.appendChild(group);
        this.__currentElement = group;

        this.__stack.push(this.__getStyleState());
      }

      /**
       * Sets current element to parent, or just root if already root
       */
      restore() {
        this.__currentElement = this.__groupStack.pop();
        this.__currentElementsToStyle = null; //Clearing canvas will make the poped group invalid, currentElement is set to the root group node.

        if (!this.__currentElement) {
          this.__currentElement = this.__root.childNodes[1];
        }

        var state = this.__stack.pop();

        this.__applyStyleState(state);
      }

      /**
       * Helper method to add transform
       * @private
       */
      __addTransform(t) {
        //if the current element has siblings, add another group
        var parent = this.__closestGroupOrSvg();

        if (parent.childNodes.length > 0) {
          if (this.__currentElement.nodeName === "path") {
            if (!this.__currentElementsToStyle) this.__currentElementsToStyle = {
              element: parent,
              children: []
            };

            this.__currentElementsToStyle.children.push(this.__currentElement);

            this.__applyCurrentDefaultPath();
          }

          var group = this.__createElement("g");

          parent.appendChild(group);
          this.__currentElement = group;
        }

        var transform = this.__currentElement.getAttribute("transform");

        if (transform) {
          transform += " ";
        } else {
          transform = "";
        }

        transform += t;

        this.__currentElement.setAttribute("transform", transform);
      }

      addTrackGroupWithTranslationAndClipRect(id, tx, ty, width, height, clipYOffset) {
        // clip rect
        const clip_id = id + '_clip_rect';

        let clipPath = this.__createElement('clipPath', {
          id: clip_id
        });

        this.__defs.appendChild(clipPath);

        clipPath.appendChild(this.__createElement('rect', {
          x: '0',
          y: clipYOffset.toString(),
          width: width.toString(),
          height: height.toString()
        }));

        let group = this.__createElement('g');

        this.__rootGroup.appendChild(group);

        group.setAttribute('transform', format('translate({x},{y})', {
          x: tx,
          y: ty
        }));
        group.setAttribute('id', id + '_group'); // add clip rect

        group.setAttribute('clip-path', format('url(#{id})', {
          id: clip_id
        }));
        this.__currentElement = group;
      }

      /**
       *  scales the current element
       */
      scale(x, y) {
        if (y === undefined) {
          y = x;
        }

        this.__addTransform(format("scale({x},{y})", {
          x: x,
          y: y
        }));
      }

      /**
       * rotates the current element
       */
      rotate(angle) {
        var degrees = angle * 180 / Math.PI;

        this.__addTransform(format("rotate({angle},{cx},{cy})", {
          angle: degrees,
          cx: 0,
          cy: 0
        }));
      }

      /**
       * translates the current element
       */
      translate(x, y) {
        this.__addTransform(format("translate({x},{y})", {
          x: x,
          y: y
        }));
      }

      /**
       * applies a transform to the current element
       */
      transform(a, b, c, d, e, f) {
        this.__addTransform(format("matrix({a},{b},{c},{d},{e},{f})", {
          a: a,
          b: b,
          c: c,
          d: d,
          e: e,
          f: f
        }));
      }

      /**
       * Create a new Path Element
       */
      beginPath() {
        var path, parent; // Note that there is only one current default path, it is not part of the drawing state.
        // See also: https://html.spec.whatwg.org/multipage/scripting.html#current-default-path

        this.__currentDefaultPath = "";
        this.__currentPosition = {};
        path = this.__createElement("path", {}, true);
        parent = this.__closestGroupOrSvg();
        parent.appendChild(path);
        this.__currentElement = path;
      }

      /**
       * Helper function to apply currentDefaultPath to current path element
       * @private
       */
      __applyCurrentDefaultPath() {
        var currentElement = this.__currentElement;

        if (currentElement.nodeName === "path") {
          currentElement.setAttribute("d", this.__currentDefaultPath);
        } else {
          console.error("Attempted to apply path command to node", currentElement.nodeName);
        }
      }

      /**
       * Helper function to add path command
       * @private
       */
      __addPathCommand(command) {
        this.__currentDefaultPath += " ";
        this.__currentDefaultPath += command;
      }

      /**
       * Adds the move command to the current path element,
       * if the currentPathElement is not empty create a new path element
       */
      moveTo(x, y) {
        if (this.__currentElement.nodeName !== "path") {
          this.beginPath();
        } // creates a new subpath with the given point


        this.__currentPosition = {
          x: x,
          y: y
        };

        this.__addPathCommand(format("M {x} {y}", {
          x: x,
          y: y
        }));
      }

      /**
       * Closes the current path
       */
      closePath() {
        if (this.__currentDefaultPath) {
          this.__addPathCommand("Z");
        }
      }

      /**
       * Adds a line to command
       */
      lineTo(x, y) {
        this.__currentPosition = {
          x: x,
          y: y
        };

        if (this.__currentDefaultPath && this.__currentDefaultPath.indexOf('M') > -1) {
          this.__addPathCommand(format("L {x} {y}", {
            x: x,
            y: y
          }));
        } else {
          this.__addPathCommand(format("M {x} {y}", {
            x: x,
            y: y
          }));
        }
      }

      /**
       * Add a bezier command
       */
      bezierCurveTo(cp1x, cp1y, cp2x, cp2y, x, y) {
        this.__currentPosition = {
          x: x,
          y: y
        };

        this.__addPathCommand(format("C {cp1x} {cp1y} {cp2x} {cp2y} {x} {y}", {
          cp1x: cp1x,
          cp1y: cp1y,
          cp2x: cp2x,
          cp2y: cp2y,
          x: x,
          y: y
        }));
      }

      /**
       * Adds a quadratic curve to command
       */
      quadraticCurveTo(cpx, cpy, x, y) {
        this.__currentPosition = {
          x: x,
          y: y
        };

        this.__addPathCommand(format("Q {cpx} {cpy} {x} {y}", {
          cpx: cpx,
          cpy: cpy,
          x: x,
          y: y
        }));
      }

      /**
       * Adds the arcTo to the current path
       *
       * @see http://www.w3.org/TR/2015/WD-2dcontext-20150514/#dom-context-2d-arcto
       */
      arcTo(x1, y1, x2, y2, radius) {
        // Let the point (x0, y0) be the last point in the subpath.
        var x0 = this.__currentPosition && this.__currentPosition.x;
        var y0 = this.__currentPosition && this.__currentPosition.y; // First ensure there is a subpath for (x1, y1).

        if (typeof x0 == "undefined" || typeof y0 == "undefined") {
          return;
        } // Negative values for radius must cause the implementation to throw an IndexSizeError exception.


        if (radius < 0) {
          throw new Error("IndexSizeError: The radius provided (" + radius + ") is negative.");
        } // If the point (x0, y0) is equal to the point (x1, y1),
        // or if the point (x1, y1) is equal to the point (x2, y2),
        // or if the radius radius is zero,
        // then the method must add the point (x1, y1) to the subpath,
        // and connect that point to the previous point (x0, y0) by a straight line.


        if (x0 === x1 && y0 === y1 || x1 === x2 && y1 === y2 || radius === 0) {
          this.lineTo(x1, y1);
          return;
        } // Otherwise, if the points (x0, y0), (x1, y1), and (x2, y2) all lie on a single straight line,
        // then the method must add the point (x1, y1) to the subpath,
        // and connect that point to the previous point (x0, y0) by a straight line.


        var unit_vec_p1_p0 = normalize([x0 - x1, y0 - y1]);
        var unit_vec_p1_p2 = normalize([x2 - x1, y2 - y1]);

        if (unit_vec_p1_p0[0] * unit_vec_p1_p2[1] === unit_vec_p1_p0[1] * unit_vec_p1_p2[0]) {
          this.lineTo(x1, y1);
          return;
        } // Otherwise, let The Arc be the shortest arc given by circumference of the circle that has radius radius,
        // and that has one point tangent to the half-infinite line that crosses the point (x0, y0) and ends at the point (x1, y1),
        // and that has a different point tangent to the half-infinite line that ends at the point (x1, y1), and crosses the point (x2, y2).
        // The points at which this circle touches these two lines are called the start and end tangent points respectively.
        // note that both vectors are unit vectors, so the length is 1


        var cos = unit_vec_p1_p0[0] * unit_vec_p1_p2[0] + unit_vec_p1_p0[1] * unit_vec_p1_p2[1];
        var theta = Math.acos(Math.abs(cos)); // Calculate origin

        var unit_vec_p1_origin = normalize([unit_vec_p1_p0[0] + unit_vec_p1_p2[0], unit_vec_p1_p0[1] + unit_vec_p1_p2[1]]);
        var len_p1_origin = radius / Math.sin(theta / 2);
        var x = x1 + len_p1_origin * unit_vec_p1_origin[0];
        var y = y1 + len_p1_origin * unit_vec_p1_origin[1]; // Calculate start angle and end angle
        // rotate 90deg clockwise (note that y axis points to its down)

        var unit_vec_origin_start_tangent = [-unit_vec_p1_p0[1], unit_vec_p1_p0[0]]; // rotate 90deg counter clockwise (note that y axis points to its down)

        var unit_vec_origin_end_tangent = [unit_vec_p1_p2[1], -unit_vec_p1_p2[0]];

        var getAngle = function (vector) {
          // get angle (clockwise) between vector and (1, 0)
          var x = vector[0];
          var y = vector[1];

          if (y >= 0) {
            // note that y axis points to its down
            return Math.acos(x);
          } else {
            return -Math.acos(x);
          }
        };

        var startAngle = getAngle(unit_vec_origin_start_tangent);
        var endAngle = getAngle(unit_vec_origin_end_tangent); // Connect the point (x0, y0) to the start tangent point by a straight line

        this.lineTo(x + unit_vec_origin_start_tangent[0] * radius, y + unit_vec_origin_start_tangent[1] * radius); // Connect the start tangent point to the end tangent point by arc
        // and adding the end tangent point to the subpath.

        this.arc(x, y, radius, startAngle, endAngle);
      }

      /**
       * Sets the stroke property on the current element
       */
      stroke() {
        if (this.__currentElement.nodeName === "path") {
          this.__currentElement.setAttribute("paint-order", "fill stroke markers");
        }

        this.__applyCurrentDefaultPath();

        this.__applyStyleToCurrentElement("stroke");
      }

      /**
       * Sets fill properties on the current element
       */
      fill() {
        if (this.__currentElement.nodeName === "path") {
          this.__currentElement.setAttribute("paint-order", "stroke fill markers");
        }

        this.__applyCurrentDefaultPath();

        this.__applyStyleToCurrentElement("fill");
      }

      /**
       *  Adds a rectangle to the path.
       */
      rect(x, y, width, height) {
        if (this.__currentElement.nodeName !== "path") {
          this.beginPath();
        }

        this.moveTo(x, y);
        this.lineTo(x + width, y);
        this.lineTo(x + width, y + height);
        this.lineTo(x, y + height);
        this.lineTo(x, y);
        this.closePath();
      }

      /**
       * adds a rectangle element
       */
      fillRect(x, y, width, height) {
        if (height < 0) {
          y += height;
          height = -height;
        }

        if (width < 0) {
          x += width;
          width = -width;
        } // See if rect intersects current viewbox


        var r2 = {
          x: x,
          y: y,
          width: width,
          height: height
        };

        if (this.viewbox) {
          if (!intersectRect(this.viewbox, r2)) {
            return;
          }
        }

        var rect, parent;
        rect = this.__createElement("rect", r2, true);
        parent = this.__closestGroupOrSvg();
        parent.appendChild(rect);
        this.__currentElement = rect;

        this.__applyStyleToCurrentElement("fill");
      }

      /**
       * Draws a rectangle with no fill
       * @param x
       * @param y
       * @param width
       * @param height
       */
      strokeRect(x, y, width, height) {
        var rect, parent;
        rect = this.__createElement("rect", {
          x: x,
          y: y,
          width: width,
          height: height
        }, true);
        parent = this.__closestGroupOrSvg();
        parent.appendChild(rect);
        this.__currentElement = rect;

        this.__applyStyleToCurrentElement("stroke");
      }

      // stroke ellipse
      strokeEllipse(cx, cy, rx, ry, rotation, startAngle, endAngle, isCCW) {
        this.__ellipse(cx, cy, rx, ry, rotation, startAngle, endAngle, isCCW, 'stroke');
      } // fill ellipse


      fillEllipse(cx, cy, rx, ry, rotation, startAngle, endAngle, isCCW) {
        this.__ellipse(cx, cy, rx, ry, rotation, startAngle, endAngle, isCCW, 'fill');
      } // ellipse helper


      __ellipse(cx, cy, rx, ry, rotation, startAngle, endAngle, isCCW, style) {
        const config = {
          cx,
          cy,
          rx,
          ry
        };

        const element = this.__createElement('ellipse', config, true);

        const parent = this.__closestGroupOrSvg();

        parent.appendChild(element);
        this.__currentElement = element;

        this.__applyStyleToCurrentElement(style);
      }
      /**
       * Clear entire canvas:
       * 1. save current transforms
       * 2. remove all the childNodes of the root g element
       */


      __clearCanvas() {
        var current = this.__closestGroupOrSvg(),
            transform = current.getAttribute("transform");

        var rootGroup = this.__root.childNodes[1];
        var childNodes = rootGroup.childNodes;

        for (var i = childNodes.length - 1; i >= 0; i--) {
          if (childNodes[i]) {
            rootGroup.removeChild(childNodes[i]);
          }
        }

        this.__currentElement = rootGroup; //reset __groupStack as all the child group nodes are all removed.

        this.__groupStack = [];

        if (transform) {
          this.__addTransform(transform);
        }
      }

      /**
       * "Clears" a canvas by just drawing a white rectangle in the current group.
       */
      clearRect(x, y, width, height) {
        //clear entire canvas
        if (x === 0 && y === 0 && width === this.width && height === this.height) {
          this.__clearCanvas();

          return;
        }

        var rect,
            parent = this.__closestGroupOrSvg();

        rect = this.__createElement("rect", {
          x: x,
          y: y,
          width: width,
          height: height,
          fill: "#FFFFFF"
        }, true);
        parent.appendChild(rect);
      }

      /**
       * Adds a linear gradient to a defs tag.
       * Returns a canvas gradient object that has a reference to it's parent def
       */
      createLinearGradient(x1, y1, x2, y2) {
        var grad = this.__createElement("linearGradient", {
          id: randomString(this.__ids),
          x1: x1 + "px",
          x2: x2 + "px",
          y1: y1 + "px",
          y2: y2 + "px",
          "gradientUnits": "userSpaceOnUse"
        }, false);

        this.__defs.appendChild(grad);

        return new CanvasGradient(grad, this);
      }

      /**
       * Adds a radial gradient to a defs tag.
       * Returns a canvas gradient object that has a reference to it's parent def
       */
      createRadialGradient(x0, y0, r0, x1, y1, r1) {
        var grad = this.__createElement("radialGradient", {
          id: randomString(this.__ids),
          cx: x1 + "px",
          cy: y1 + "px",
          r: r1 + "px",
          fx: x0 + "px",
          fy: y0 + "px",
          "gradientUnits": "userSpaceOnUse"
        }, false);

        this.__defs.appendChild(grad);

        return new CanvasGradient(grad, this);
      }

      /**
       * Parses the font string and returns svg mapping
       * @private
       */
      __parseFont() {
        var regex = /^\s*(?=(?:(?:[-a-z]+\s*){0,2}(italic|oblique))?)(?=(?:(?:[-a-z]+\s*){0,2}(small-caps))?)(?=(?:(?:[-a-z]+\s*){0,2}(bold(?:er)?|lighter|[1-9]00))?)(?:(?:normal|\1|\2|\3)\s*){0,3}((?:xx?-)?(?:small|large)|medium|smaller|larger|[.\d]+(?:\%|in|[cem]m|ex|p[ctx]))(?:\s*\/\s*(normal|[.\d]+(?:\%|in|[cem]m|ex|p[ctx])))?\s*([-,\'\"\sa-z0-9]+?)\s*$/i;
        var fontPart = regex.exec(this.font);
        var data = {
          style: fontPart[1] || 'normal',
          size: fontPart[4] || '10px',
          family: fontPart[6] || 'sans-serif',
          weight: fontPart[3] || 'normal',
          decoration: fontPart[2] || 'normal',
          href: null
        }; //canvas doesn't support underline natively, but we can pass this attribute

        if (this.__fontUnderline === "underline") {
          data.decoration = "underline";
        } //canvas also doesn't support linking, but we can pass this as well


        if (this.__fontHref) {
          data.href = this.__fontHref;
        }

        return data;
      }

      /**
       * Helper to link text fragments
       * @param font
       * @param element
       * @return {*}
       * @private
       */
      __wrapTextLink(font, element) {
        if (font.href) {
          var a = this.__createElement("a");

          a.setAttributeNS("http://www.w3.org/1999/xlink", "xlink:href", font.href);
          a.appendChild(element);
          return a;
        }

        return element;
      }

      /**
       * Fills or strokes text
       * @param text
       * @param x
       * @param y
       * @param action - stroke or fill
       * @private
       */
      __applyText(text, x, y, action) {
        var font = this.__parseFont(),
            parent = this.__closestGroupOrSvg(),
            textElement = this.__createElement("text", {
          "font-family": font.family,
          "font-size": font.size,
          "font-style": font.style,
          "font-weight": font.weight,
          "text-decoration": font.decoration,
          "x": x,
          "y": y,
          "text-anchor": getTextAnchor(this.textAlign),
          "dominant-baseline": getDominantBaseline(this.textBaseline)
        }, true);

        textElement.appendChild(this.__document.createTextNode(text));
        this.__currentElement = textElement;

        this.__applyStyleToCurrentElement(action);

        parent.appendChild(this.__wrapTextLink(font, textElement));
      }

      /**
       * Creates a text element
       * @param text
       * @param x
       * @param y
       */
      fillText(text, x, y) {
        this.__applyText(text, x, y, "fill");
      }

      /**
       * Strokes text
       * @param text
       * @param x
       * @param y
       */
      strokeText(text, x, y) {
        this.__applyText(text, x, y, "stroke");
      }

      /**
       * No need to implement this for svg.
       * @param text
       * @return {TextMetrics}
       */
      measureText(text) {
        this.__ctx.font = this.font;
        return this.__ctx.measureText(text);
      }

      /**
       *  Arc command!
       */
      arc(x, y, radius, startAngle, endAngle, counterClockwise) {
        // in canvas no circle is drawn if no angle is provided.
        if (startAngle === endAngle) {
          return;
        }

        startAngle = startAngle % (2 * Math.PI);
        endAngle = endAngle % (2 * Math.PI);

        if (startAngle === endAngle) {
          //circle time! subtract some of the angle so svg is happy (svg elliptical arc can't draw a full circle)
          endAngle = (endAngle + 2 * Math.PI - 0.001 * (counterClockwise ? -1 : 1)) % (2 * Math.PI);
        }

        var endX = x + radius * Math.cos(endAngle),
            endY = y + radius * Math.sin(endAngle),
            startX = x + radius * Math.cos(startAngle),
            startY = y + radius * Math.sin(startAngle),
            sweepFlag = counterClockwise ? 0 : 1,
            largeArcFlag = 0,
            diff = endAngle - startAngle; // https://github.com/gliffy/canvas2svg/issues/4

        if (diff < 0) {
          diff += 2 * Math.PI;
        }

        if (counterClockwise) {
          largeArcFlag = diff > Math.PI ? 0 : 1;
        } else {
          largeArcFlag = diff > Math.PI ? 1 : 0;
        }

        this.lineTo(startX, startY);

        this.__addPathCommand(format("A {rx} {ry} {xAxisRotation} {largeArcFlag} {sweepFlag} {endX} {endY}", {
          rx: radius,
          ry: radius,
          xAxisRotation: 0,
          largeArcFlag: largeArcFlag,
          sweepFlag: sweepFlag,
          endX: endX,
          endY: endY
        }));

        this.__currentPosition = {
          x: endX,
          y: endY
        };
      }

      /**
       * The ellipse() method creates an elliptical arc centered at (x, y) with the radii radiusX and radiusY. The path
       * starts at startAngle and ends at endAngle, and travels in the direction given by counterclockwise (defaulting to clockwise).
       */
      // ellipse (x, y, radiusX, radiusY, rotation, startAngle, endAngle, counterclockwise) {
      //     // TODO -- implement
      // }

      /**
       * Generates a ClipPath from the clip command.
       */
      clip() {
        var group = this.__closestGroupOrSvg(),
            clipPath = this.__createElement("clipPath"),
            id = randomString(this.__ids),
            newGroup = this.__createElement("g");

        this.__applyCurrentDefaultPath();

        group.removeChild(this.__currentElement);
        clipPath.setAttribute("id", id);
        clipPath.appendChild(this.__currentElement);

        this.__defs.appendChild(clipPath); //set the clip path to this group


        group.setAttribute("clip-path", format("url(#{id})", {
          id: id
        })); //clip paths can be scaled and transformed, we need to add another wrapper group to avoid later transformations
        // to this path

        group.appendChild(newGroup);
        this.__currentElement = newGroup;
      }

      /**
       * Draws a canvas, image or mock context to this canvas.
       * Note that all svg dom manipulation uses node.childNodes rather than node.children for IE support.
       * http://www.whatwg.org/specs/web-apps/current-work/multipage/the-canvas-element.html#dom-context-2d-drawimage
       */
      drawImage() {
        //convert arguments to a real array
        var args = Array.prototype.slice.call(arguments),
            image = args[0],
            dx,
            dy,
            dw,
            dh,
            sx = 0,
            sy = 0,
            sw,
            sh,
            parent,
            svg,
            defs,
            group,
            svgImage,
            canvas,
            context,
            id;

        if (args.length === 3) {
          dx = args[1];
          dy = args[2];
          sw = image.width;
          sh = image.height;
          dw = sw;
          dh = sh;
        } else if (args.length === 5) {
          dx = args[1];
          dy = args[2];
          dw = args[3];
          dh = args[4];
          sw = image.width;
          sh = image.height;
        } else if (args.length === 9) {
          sx = args[1];
          sy = args[2];
          sw = args[3];
          sh = args[4];
          dx = args[5];
          dy = args[6];
          dw = args[7];
          dh = args[8];
        } else {
          throw new Error("Invalid number of arguments passed to drawImage: " + arguments.length);
        }

        parent = this.__closestGroupOrSvg();
        var translateDirective = "translate(" + dx + ", " + dy + ")";

        if (image instanceof ctx) {
          //canvas2svg mock canvas context. In the future we may want to clone nodes instead.
          //also I'm currently ignoring dw, dh, sw, sh, sx, sy for a mock context.
          svg = image.getSvg().cloneNode(true);

          if (svg.childNodes && svg.childNodes.length > 1) {
            defs = svg.childNodes[0];

            while (defs.childNodes.length) {
              id = defs.childNodes[0].getAttribute("id");
              this.__ids[id] = id;

              this.__defs.appendChild(defs.childNodes[0]);
            }

            group = svg.childNodes[1];

            if (group) {
              //save original transform
              var originTransform = group.getAttribute("transform");
              var transformDirective;

              if (originTransform) {
                transformDirective = originTransform + " " + translateDirective;
              } else {
                transformDirective = translateDirective;
              }

              group.setAttribute("transform", transformDirective);
              parent.appendChild(group);
            }
          }
        } else if (image.nodeName === "CANVAS" || image.nodeName === "IMG") {
          //canvas or image
          svgImage = this.__createElement("image");
          svgImage.setAttribute("width", dw);
          svgImage.setAttribute("height", dh);
          svgImage.setAttribute("preserveAspectRatio", "none");

          if (sx || sy || sw !== image.width || sh !== image.height) {
            //crop the image using a temporary canvas
            canvas = this.__document.createElement("canvas");
            canvas.width = dw;
            canvas.height = dh;
            context = canvas.getContext("2d");
            context.drawImage(image, sx, sy, sw, sh, 0, 0, dw, dh);
            image = canvas;
          }

          svgImage.setAttribute("transform", translateDirective);
          svgImage.setAttributeNS("http://www.w3.org/1999/xlink", "xlink:href", image.nodeName === "CANVAS" ? image.toDataURL() : image.getAttribute("src"));
          parent.appendChild(svgImage);
        }
      }

      /**
       * Generates a pattern tag
       */
      createPattern(image, repetition) {
        let pattern = this.__document.__createElement("pattern");

        let id = randomString(this.__ids);
        let img;
        pattern.setAttribute("id", id);
        pattern.setAttribute("width", image.width);
        pattern.setAttribute("height", image.height);

        if (image.nodeName === "CANVAS" || image.nodeName === "IMG") {
          img = this.__createElement("image");
          img.setAttribute("width", image.width);
          img.setAttribute("height", image.height);
          img.setAttributeNS("http://www.w3.org/1999/xlink", "xlink:href", image.nodeName === "CANVAS" ? image.toDataURL() : image.getAttribute("src"));
          pattern.appendChild(img);

          this.__defs.appendChild(pattern);
        } else if (image instanceof ctx) {
          pattern.appendChild(image.__root.childNodes[1]);

          this.__defs.appendChild(pattern);
        }

        return new CanvasPattern(pattern, this);
      }

      setLineDash(dashArray) {
        if (dashArray && dashArray.length > 0) {
          this.lineDash = dashArray.join(",");
        } else {
          this.lineDash = null;
        }
      }

      /**
       * Not yet implemented
       */
      drawFocusRing() {}

      createImageData() {}

      getImageData() {}

      putImageData() {}

      globalCompositeOperation() {}

      setTransform() {}

    }

    const Chromosome = function (name, order, bpStart, bpLength, rangeLocus) {
      this.name = name;
      this.order = order;
      this.bpStart = bpStart;
      this.bpLength = bpLength;
      this.rangeLocus = rangeLocus;
    };

    /*
     * The MIT License (MIT)
     *
     * Copyright (c) 2014 Broad Institute
     *
     * Permission is hereby granted, free of charge, to any person obtaining a copy
     * of this software and associated documentation files (the "Software"), to deal
     * in the Software without restriction, including without limitation the rights
     * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
     * copies of the Software, and to permit persons to whom the Software is
     * furnished to do so, subject to the following conditions:
     *
     * The above copyright notice and this permission notice shall be included in
     * all copies or substantial portions of the Software.
     *
     *
     * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
     * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
     * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
     * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
     * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
     * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
     * THE SOFTWARE.
     */
    const splitLines$4 = splitLines$5;
    const reservedProperties$1 = new Set(['fastaURL', 'indexURL', 'cytobandURL', 'indexed']);

    class NonIndexedFasta {
      constructor(reference) {
        this.fastaURL = reference.fastaURL;
        this.withCredentials = reference.withCredentials;
        this.chromosomeNames = [];
        this.chromosomes = {};
        this.sequences = new Map();
        this.offsets = {}; // Build a track-like config object from the referenceObject

        const config = {};

        for (let key in reference) {
          if (reference.hasOwnProperty(key) && !reservedProperties$1.has(key)) {
            config[key] = reference[key];
          }
        }

        this.config = config;
      }

      async init() {
        return this.loadAll();
      }

      async getSequence(chr, start, end) {
        if (this.offsets[chr]) {
          start -= this.offsets[chr];
          end -= this.offsets[chr];
        }

        let prefix = "";

        if (start < 0) {
          for (let i = start; i < Math.min(end, 0); i++) {
            prefix += "*";
          }
        }

        if (end <= 0) {
          return Promise.resolve(prefix);
        }

        const seq = this.sequences.get(chr);
        const seqEnd = Math.min(end, seq.length);
        return prefix + seq.substring(start, seqEnd);
      }

      async loadAll() {
        let data;

        if (isDataURL(this.fastaURL)) {
          let bytes = decodeDataURI$1(this.fastaURL);
          data = "";

          for (let b of bytes) {
            data += String.fromCharCode(b);
          }
        } else {
          data = await igvxhr.load(this.fastaURL, buildOptions(this.config));
        }

        const lines = splitLines$4(data);
        const len = lines.length;
        let lineNo = 0;
        let currentSeq;
        let currentRangeLocus;
        let currentOffset = 0;
        let order = 0;
        let nextLine;
        let currentChr;

        while (lineNo < len) {
          nextLine = lines[lineNo++].trim();

          if (nextLine.startsWith("#") || nextLine.length === 0) ; else if (nextLine.startsWith(">")) {
            // Start the next sequence
            if (currentSeq) {
              this.chromosomeNames.push(currentChr);
              this.sequences.set(currentChr, currentSeq);
              this.chromosomes[currentChr] = new Chromosome(currentChr, order++, currentOffset, currentOffset + currentSeq.length, currentRangeLocus);
            }

            const parts = nextLine.substr(1).split(/\s+/); // Check for samtools style locus string.   This is not perfect, and could fail on weird sequence names

            const nameParts = parts[0].split(':');
            currentChr = nameParts[0];
            currentSeq = "";
            currentOffset = 0;
            currentRangeLocus = undefined;

            if (nameParts.length > 1 && nameParts[1].indexOf('-') > 0) {
              const locusParts = nameParts[1].split('-');

              if (locusParts.length === 2 && /^[0-9]+$/.test(locusParts[0]) && /^[0-9]+$/.test(locusParts[1])) ;

              const from = Number.parseInt(locusParts[0]);
              const to = Number.parseInt(locusParts[1]);

              if (to > from) {
                currentOffset = from - 1;
                this.offsets[currentChr] = currentOffset;
                currentRangeLocus = nameParts[1];
              }
            }
          } else {
            currentSeq += nextLine;
          }
        } // add last seq


        if (currentSeq) {
          this.chromosomeNames.push(currentChr);
          this.sequences.set(currentChr, currentSeq);
          this.chromosomes[currentChr] = new Chromosome(currentChr, order++, currentOffset, currentOffset + currentSeq.length, currentRangeLocus);
        }
      }

    }

    const GenomicInterval = function (chr, start, end, features) {
      this.chr = chr;
      this.start = start;
      this.end = end;
      this.features = features;
    };

    GenomicInterval.prototype.contains = function (chr, start, end) {
      return this.chr === chr && this.start <= start && this.end >= end;
    };

    GenomicInterval.prototype.containsRange = function (range) {
      return this.chr === range.chr && this.start <= range.start && this.end >= range.end;
    };

    /*
     * The MIT License (MIT)
     *
     * Copyright (c) 2014 Broad Institute
     *
     * Permission is hereby granted, free of charge, to any person obtaining a copy
     * of this software and associated documentation files (the "Software"), to deal
     * in the Software without restriction, including without limitation the rights
     * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
     * copies of the Software, and to permit persons to whom the Software is
     * furnished to do so, subject to the following conditions:
     *
     * The above copyright notice and this permission notice shall be included in
     * all copies or substantial portions of the Software.
     *
     *
     * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
     * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
     * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
     * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
     * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
     * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
     * THE SOFTWARE.
     */
    const splitLines$3 = splitLines$5;
    const reservedProperties = new Set(['fastaURL', 'indexURL', 'compressedIndexURL', 'cytobandURL', 'indexed']);

    class FastaSequence {
      constructor(reference) {
        this.file = reference.fastaURL;
        this.indexFile = reference.indexURL || reference.indexFile || this.file + ".fai";
        this.compressedIndexFile = reference.compressedIndexURL || false;
        this.withCredentials = reference.withCredentials;
        this.chromosomeNames = [];
        this.chromosomes = {};
        this.sequences = {};
        this.offsets = {}; // Build a track-like config object from the referenceObject

        const config = {};

        for (let key in reference) {
          if (reference.hasOwnProperty(key) && !reservedProperties.has(key)) {
            config[key] = reference[key];
          }
        }

        this.config = config;
      }

      async init() {
        return this.getIndex();
      }

      async getSequence(chr, start, end) {
        const hasCachedSquence = this.interval && this.interval.contains(chr, start, end);

        if (!hasCachedSquence) {
          // Expand query, to minimum of 50kb
          let qstart = start;
          let qend = end;

          if (end - start < 50000) {
            const w = end - start;
            const center = Math.round(start + w / 2);
            qstart = Math.max(0, center - 25000);
            qend = center + 25000;
          }

          const seqBytes = await this.readSequence(chr, qstart, qend);
          this.interval = new GenomicInterval(chr, qstart, qend, seqBytes);
        }

        const offset = start - this.interval.start;
        const n = end - start;
        const seq = this.interval.features ? this.interval.features.substr(offset, n) : null;
        return seq;
      }

      async getIndex() {
        if (this.index) {
          return this.index;
        } else {
          const data = await igvxhr.load(this.indexFile, buildOptions(this.config));
          const lines = splitLines$3(data);
          const len = lines.length;
          let lineNo = 0;
          let order = 0;
          this.index = {};

          while (lineNo < len) {
            const tokens = lines[lineNo++].split("\t");
            const nTokens = tokens.length;

            if (nTokens === 5) {
              // Parse the index line.
              const chr = tokens[0];
              const size = parseInt(tokens[1]);
              const position = parseInt(tokens[2]);
              const basesPerLine = parseInt(tokens[3]);
              const bytesPerLine = parseInt(tokens[4]);
              const indexEntry = {
                size: size,
                position: position,
                basesPerLine: basesPerLine,
                bytesPerLine: bytesPerLine
              };
              this.chromosomeNames.push(chr);
              this.index[chr] = indexEntry;
              this.chromosomes[chr] = new Chromosome(chr, order++, 0, size);
            }
          }

          return this.index;
        }
      } //Code is losely based on https://github.com/GMOD/bgzf-filehandle
      //Reworked however in orde to work with the igvxhr interface for loading files
      //Additionally, replaced calls to the Long.js interface with standard JS calls for ArrayBuffers and the associated views
      //
      //The compressed index is an array of blocks, with each block being a pair: compressed-position & uncompressed-position (both in bytes)


      async getCompressedIndex() {
        const GZI_NUM_BYTES_OFFSET = 8;
        const GZI_NUM_BYTES_BLOCK = 8;

        if (this.compressedIndex) {
          return this.compressedIndex;
        }

        if (!this.compressedIndexFile) {
          this.compressedIndex = [];
          return this.compressedIndex;
        } //In contrast to the 'normal' reference (for which the index is chromosome based), this index is block-based
        //As such there is not need to make it a hash. An array is sufficient.


        this.compressedIndex = [];
        const gziData = await igvxhr.loadArrayBuffer(this.compressedIndexFile, buildOptions(this.config));
        const givenFileSize = gziData.byteLength;

        if (givenFileSize < GZI_NUM_BYTES_OFFSET) {
          console.log("Cannot parse GZI index file: length (" + givenFileSize + " bytes) is insufficient to determine content of index.");
          return this.compressedIndex;
        } //First 8 bytes are a little endian unsigned bigint (64bit), indicating the number of blocks in the index.


        const numBlocksBuffer = gziData.slice(0, GZI_NUM_BYTES_OFFSET);
        const numBlocks = Number(new DataView(numBlocksBuffer).getBigUint64(0, true)); //The remainder of the gzi content are pairs of little endian unsigned bigint (64bit) numbers.
        //The first of the pair is the compressed position of a block
        //The second of the pair is the uncompressed position of a block
        //Sanity check:
        //Is the size of the array-buffer (of the entire file) correct with regards to the number of blocks detailled by the first 8 bytes of the file?
        //Total file-size should be:
        // 8 + 2*(num_entries*8) bytes, with the first 8 bytes indicating the number of entries

        const expectedFileSize = GZI_NUM_BYTES_OFFSET + numBlocks * 2 * GZI_NUM_BYTES_BLOCK;

        if (givenFileSize != expectedFileSize) {
          console.log("Incorrect file size of reference genome index. Expected : " + expectedFileSize + ". Received : " + givenFileSize);
          return this.compressedIndex;
        } //Push the first block to the index: the first block always has positions 0 for both the compressed and uncompressed file


        this.compressedIndex.push([0, 0]); //Further process all the blocks of the GZI index, and keep them in memory

        for (let blockNumber = 0; blockNumber < numBlocks; blockNumber++) {
          const bufferBlockStart = GZI_NUM_BYTES_OFFSET + blockNumber * 2 * GZI_NUM_BYTES_BLOCK;
          const bufferBlockEnd = GZI_NUM_BYTES_OFFSET + blockNumber * 2 * GZI_NUM_BYTES_BLOCK + 2 * GZI_NUM_BYTES_BLOCK;
          const bufferBlock = gziData.slice(bufferBlockStart, bufferBlockEnd);
          const viewBlock = new DataView(bufferBlock);
          const compressedPosition = Number(viewBlock.getBigUint64(0, true)); //First 8 bytes

          const uncompressedPosition = Number(viewBlock.getBigUint64(GZI_NUM_BYTES_BLOCK, true)); //Last 8 bytes

          this.compressedIndex.push([compressedPosition, uncompressedPosition]);
        }

        return this.compressedIndex;
      } //The Fasta-index gives a byte-position of the chromosomal sequences within the FASTA file.
      //These locations need to be remapped to the locations within the zipped reference genome, using the GZI index
      //This function provides this functionality by 
      //1) taking the indicated start/stop byte locations within the UNCOMPRESSED FASTA file
      //2) remapping these byte locations to the correct blocks (and associated positions) within the COMPRESSED FASTA file
      //Subsequently, the calling method can then extract the correct blocks from the compressed FASTA files and uncompressed the data


      async getRelevantCompressedBlockNumbers(queryPositionStart, queryPositionEnd) {
        const UNCOMPRESSED_POSITION = 1; //Fallback for impossible values

        if (queryPositionStart < 0 || queryPositionEnd < 0 || queryPositionEnd < queryPositionStart) {
          console.log("Incompatible query positions for reference-genome. Start:" + queryPositionStart + " | End:" + queryPositionEnd);
          return [];
        } //Ensure compressed index is loaded


        await this.getCompressedIndex();
        let result = []; //Now search for the correct block-numbers (going from 0 to length(compressed-index)) which overlap with the provided byte-positions

        const lowestBlockNumber = 0;
        const highestBlockNumber = this.compressedIndex.length - 1; //Failsafe if for some reason the compressed index wasn't loaded or doesn't contain any data

        if (this.compressedIndex.length == 0) {
          console.log("Compressed index does not contain any content");
          return [];
        } //Failsafe: if the queryPositionStart is greater than the uncompressed-position of the final block,
        //then this final block is the only possible result


        if (queryPositionStart > this.compressedIndex[highestBlockNumber][UNCOMPRESSED_POSITION]) {
          return [highestBlockNumber];
        } //Rather than doing a linear search over all blocks, a binary search is done for speed considerations
        //We are searching for the highest block number for which its position is smaller than the query start position
        //Afterwards we will simply expand the blocks until the entire query range is covered


        let searchLow = lowestBlockNumber;
        let searchHigh = highestBlockNumber;
        let searchPosition = Math.floor(this.compressedIndex.length / 2);
        let maxIterations = this.compressedIndex.length + 1;
        let solutionFound = false; //instead of doing a while(true), this for-loop prevents eternal loops in case of issues

        for (let iteration = 0; iteration < maxIterations; iteration++) {
          const searchUncompressedPosition = this.compressedIndex[searchPosition][UNCOMPRESSED_POSITION];
          const nextSearchUncompressedPosition = searchPosition < this.compressedIndex.length - 1 ? this.compressedIndex[searchPosition + 1][UNCOMPRESSED_POSITION] : Infinity; //The query position lies within the current search block

          if (searchUncompressedPosition <= queryPositionStart && nextSearchUncompressedPosition > queryPositionStart) {
            solutionFound = true;
            break; //searchPosition is the correct block number index
          } //Current block lies before the query position
          else if (searchUncompressedPosition < queryPositionStart) {
            searchLow = searchPosition + 1;
          } //Current block lies after the query position
          else {
            searchHigh = searchPosition - 1;
          }

          searchPosition = Math.ceil((searchHigh - searchLow) / 2) + searchLow;
        } //If for some reason the binary search did not reveal a correct block index, then we return the empty result


        if (!solutionFound) {
          console.log("No blocks within compressed index found that correspond with query positions " + queryPositionStart + "," + queryPositionEnd);
          console.log(this.compressedIndex);
          return [];
        } //Now extend the result by adding additional blocks until the entire query range is covered


        result.push(searchPosition);

        for (let blockIndex = searchPosition + 1; blockIndex < this.compressedIndex.length; blockIndex++) {
          result.push(blockIndex);
          const blockUncompressedPosition = this.compressedIndex[blockIndex][UNCOMPRESSED_POSITION];

          if (blockUncompressedPosition >= queryPositionEnd) {
            break;
          }
        } //It is possible that the query end position lies AFTER the start of the final block
        //If this is the case, we add a 'fake' negative index which will be interpreted by the loadAndUncompressBlocks method as an indicator
        //to read until the end of the file 


        const finalRelevantBlock = result[result.length - 1];
        const finalIndexBlock = this.compressedIndex.length - 1;

        if (finalRelevantBlock === finalIndexBlock && this.compressedIndex[finalRelevantBlock][UNCOMPRESSED_POSITION] < queryPositionEnd) {
          result.push(-1);
        }

        return result;
      } //Load the content from the blockIndices.
      //This is done on a per-block basis
      //Content of the first block will be trimmed in order to match the expected offset


      async loadAndUncompressBlocks(blockIndices, startByte) {
        const COMPRESSED_POSITION = 0;
        const UNCOMPRESSED_POSITION = 1; //Normally the compressed index should already exist, we're just makeing sure here

        await this.getCompressedIndex();

        if (blockIndices.length == 0) {
          return "";
        } //Storing data in seperate array with indices in order to assert order due to async behaviour of loops


        let resultCache = Array(blockIndices.length - 1);

        for (let i = 0; i < blockIndices.length - 1; i++) {
          const currentBlockNumber = blockIndices[i];
          const currentBlockInfo = this.compressedIndex[currentBlockNumber];
          const currentBlockCompressedPosition = currentBlockInfo[COMPRESSED_POSITION];
          const nextBlockNumber = blockIndices[i + 1];
          let compressedBytes = [];

          if (nextBlockNumber != -1) {
            //default : read current entire block only
            const nextBlockInfo = this.compressedIndex[nextBlockNumber];
            const nextBlockCompressedPosition = nextBlockInfo[COMPRESSED_POSITION];
            const compressedLength = nextBlockCompressedPosition - currentBlockCompressedPosition;
            compressedBytes = await igvxhr.loadArrayBuffer(this.file, buildOptions(this.config, {
              range: {
                start: currentBlockCompressedPosition,
                size: compressedLength
              }
            }));
          } else {
            // special case for query within final block: read until the end of the file
            compressedBytes = await igvxhr.loadArrayBuffer(this.file, buildOptions(this.config, {
              range: {
                start: currentBlockCompressedPosition
              }
            }));
          } //now unzip the compressed bytes, and store them in the resultCache


          const uncompressedBytes = await unbgzf(compressedBytes);
          resultCache[i] = uncompressedBytes;
        } //Iterate over the result cache, create sequences from the data, and create a full sequence string from the data


        let result = "";

        for (let i = 0; i < resultCache.length; i++) {
          for (let j = 0; j < resultCache[i].length; j++) {
            const c = String.fromCharCode(resultCache[i][j]);
            result = result + c;
          }
        } //postprocess this data: because entire blocks are read we need to remove the first N bases of the first used block, 
        //which are not included in the original query positions


        const firstBlockInfo = this.compressedIndex[blockIndices[0]];
        const offset = startByte - firstBlockInfo[UNCOMPRESSED_POSITION];
        result = result.substring(offset);
        return result;
      }

      async readSequence(chr, qstart, qend) {
        await this.getIndex();
        await this.getCompressedIndex(); //This will work even if no compressed index file is set

        const idxEntry = this.index[chr];

        if (!idxEntry) {
          console.log("No index entry for chr: " + chr); // Tag interval with null so we don't try again

          this.interval = new GenomicInterval(chr, qstart, qend, null);
          return null;
        }

        const start = Math.max(0, qstart); // qstart should never be < 0

        const end = Math.min(idxEntry.size, qend);
        const bytesPerLine = idxEntry.bytesPerLine;
        const basesPerLine = idxEntry.basesPerLine;
        const position = idxEntry.position;
        const nEndBytes = bytesPerLine - basesPerLine;
        const startLine = Math.floor(start / basesPerLine);
        const endLine = Math.floor(end / basesPerLine);
        const base0 = startLine * basesPerLine; // Base at beginning of start line

        const offset = start - base0;
        const startByte = position + startLine * bytesPerLine + offset;
        const base1 = endLine * basesPerLine;
        const offset1 = end - base1;
        const endByte = position + endLine * bytesPerLine + offset1 - 1;
        const byteCount = endByte - startByte + 1;

        if (byteCount <= 0) {
          console.error("No sequence for " + chr + ":" + qstart + "-" + qend);
          return null;
        } //If the compressed index file is set, then we are dealing with a compressed genome sequence
        //The selection of startByte/endByte is done for the non-compressed genome sequence.
        //These need to be 'converted' to the correct byte positions in the compressed genome sequence,
        //by making use of the compressed index (GZI file)


        let allBytes;

        if (!this.compressedIndexFile) {
          allBytes = await igvxhr.load(this.file, buildOptions(this.config, {
            range: {
              start: startByte,
              size: byteCount
            }
          }));
        } else {
          let relevantBlockIndices = await this.getRelevantCompressedBlockNumbers(startByte, endByte);

          if (relevantBlockIndices.length === 0) {
            console.log("No blocks in the compressed index that correspond with the requested byte positions (" + startByte + "," + endByte + ")");
            return null;
          }

          allBytes = await this.loadAndUncompressBlocks(relevantBlockIndices, startByte);
        }

        if (!allBytes) {
          return null;
        }

        let nBases,
            seqBytes = "",
            srcPos = 0,
            allBytesLength = allBytes.length;

        if (offset > 0) {
          nBases = Math.min(end - start, basesPerLine - offset);
          seqBytes += allBytes.substr(srcPos, nBases);
          srcPos += nBases + nEndBytes;
        }

        while (srcPos < allBytesLength) {
          nBases = Math.min(basesPerLine, allBytesLength - srcPos);
          seqBytes += allBytes.substr(srcPos, nBases);
          srcPos += nBases + nEndBytes;
        }

        return seqBytes;
      }

    }

    /*
     * The MIT License (MIT)
     *
     * Copyright (c) 2014 Broad Institute
     *
     * Permission is hereby granted, free of charge, to any person obtaining a copy
     * of this software and associated documentation files (the "Software"), to deal
     * in the Software without restriction, including without limitation the rights
     * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
     * copies of the Software, and to permit persons to whom the Software is
     * furnished to do so, subject to the following conditions:
     *
     * The above copyright notice and this permission notice shall be included in
     * all copies or substantial portions of the Software.
     *
     *
     * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
     * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
     * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
     * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
     * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
     * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
     * THE SOFTWARE.
     */
    const splitLines$2 = splitLines$5;

    class ChromSizes {
      constructor(url) {
        this.url = url;
        this.chromosomeNames = [];
        this.chromosomes = {};
      }

      async init() {
        return this.loadAll();
      }

      async getSequence(chr, start, end) {
        return undefined; // TODO -- return array of "N"s?
      }

      async loadAll() {
        let data;

        if (isDataURL(this.url)) {
          let bytes = decodeDataURI$1(this.fastaURL);
          data = "";

          for (let b of bytes) {
            data += String.fromCharCode(b);
          }
        } else {
          data = await igvxhr.load(this.url, {});
        }

        this.chromosomeNames = [];
        this.chromosomes = {};
        const lines = splitLines$2(data);
        let order = 0;

        for (let nextLine of lines) {
          const tokens = nextLine.split('\t');
          this.chromosomeNames.push(tokens[0]);
          const chrLength = Number.parseInt(tokens[1]);
          const chromosome = new Chromosome(tokens[0], order++, 0, chrLength);
          this.chromosomes[tokens[0]] = chromosome;
        }
      }

    }

    async function loadFasta(reference) {
      let fasta;

      if ("chromsizes" === reference.format) {
        fasta = new ChromSizes(reference.fastaURL);
      } else if (isDataURL(reference.fastaURL) || reference.indexed === false) {
        fasta = new NonIndexedFasta(reference);
      } else {
        fasta = new FastaSequence(reference);
      }

      await fasta.init();
      return fasta;
    }

    const Cytoband = function (start, end, name, typestain) {
      this.start = start;
      this.end = end;
      this.name = name;
      this.stain = 0; // Set the type, either p, n, or c

      if (typestain === 'acen') {
        this.type = 'c';
      } else {
        this.type = typestain.charAt(1);

        if (this.type === 'p') {
          this.stain = parseInt(typestain.substring(4));
        }
      }
    };

    const _version = "2.12.6";

    function version() {
      return _version;
    }

    /*
     * The MIT License (MIT)
     *
     * Copyright (c) 2014 Broad Institute
     *
     * Permission is hereby granted, free of charge, to any person obtaining a copy
     * of this software and associated documentation files (the "Software"), to deal
     * in the Software without restriction, including without limitation the rights
     * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
     * copies of the Software, and to permit persons to whom the Software is
     * furnished to do so, subject to the following conditions:
     *
     * The above copyright notice and this permission notice shall be included in
     * all copies or substantial portions of the Software.
     *
     *
     * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
     * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
     * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
     * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
     * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
     * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
     * THE SOFTWARE.
     */
    const DEFAULT_GENOMES_URL = "https://igv.org/genomes/genomes.json";
    const BACKUP_GENOMES_URL = "https://s3.amazonaws.com/igv.org.genomes/genomes.json";
    const splitLines$1 = splitLines$5;
    const GenomeUtils = {
      loadGenome: async function (options) {
        const cytobandUrl = options.cytobandURL;
        const aliasURL = options.aliasURL;
        const sequence = await loadFasta(options);
        let cytobands;

        if (cytobandUrl) {
          cytobands = await loadCytobands(cytobandUrl, sequence.config);
        }

        let aliases;

        if (aliasURL) {
          aliases = await loadAliases(aliasURL, sequence.config);
        }

        return new Genome(options, sequence, cytobands, aliases);
      },
      initializeGenomes: async function (config) {
        if (!GenomeUtils.KNOWN_GENOMES) {
          const table = {}; // Get default genomes

          if (config.loadDefaultGenomes !== false) {
            try {
              const url = DEFAULT_GENOMES_URL + `?randomSeed=${Math.random().toString(36)}&version=${version()}`; // prevent caching

              const jsonArray = await igvxhr.loadJson(url, {
                timeout: 5000
              });
              processJson(jsonArray);
            } catch (e) {
              console.error(e);

              try {
                const url = BACKUP_GENOMES_URL + `?randomSeed=${Math.random().toString(36)}&version=${version()}`; // prevent caching

                const jsonArray = await igvxhr.loadJson(url, {});
                processJson(jsonArray);
              } catch (e) {
                console.error(e);
                console.warn("Errors loading default genome definitions.");
              }
            }
          } // Add user-defined genomes


          const genomeList = config.genomeList || config.genomes;

          if (genomeList) {
            if (typeof genomeList === 'string') {
              const jsonArray = await igvxhr.loadJson(genomeList, {});
              processJson(jsonArray);
            } else {
              processJson(genomeList);
            }
          }

          GenomeUtils.KNOWN_GENOMES = table;

          function processJson(jsonArray) {
            jsonArray.forEach(function (json) {
              table[json.id] = json;
            });
            return table;
          }
        }
      },
      isWholeGenomeView: function (chr) {
        return 'all' === chr.toLowerCase();
      },
      // Expand a genome id to a reference object, if needed
      expandReference: function (idOrConfig) {
        // idOrConfig might be json
        if (isString$3(idOrConfig) && idOrConfig.startsWith("{")) {
          try {
            idOrConfig = JSON.parse(idOrConfig);
          } catch (e) {// Apparently its not json,  could be an ID starting with "{".  Unusual but legal.
          }
        }

        let genomeID;

        if (isString$3(idOrConfig)) {
          genomeID = idOrConfig;
        } else if (idOrConfig.genome) {
          genomeID = idOrConfig.genome;
        } else if (idOrConfig.id !== undefined && idOrConfig.fastaURL === undefined) {
          // Backward compatibility
          genomeID = idOrConfig.id;
        }

        if (genomeID) {
          const knownGenomes = GenomeUtils.KNOWN_GENOMES;
          const reference = knownGenomes[genomeID];

          if (!reference) {
            Alert.presentAlert(new Error(`Unknown genome id: ${genomeID}`), undefined);
          }

          return reference;
        } else {
          return idOrConfig;
        }
      }
    };

    class Genome {
      constructor(config, sequence, ideograms, aliases) {
        this.config = config;
        this.id = config.id || generateGenomeID(config);
        this.sequence = sequence;
        this.chromosomeNames = sequence.chromosomeNames;
        this.chromosomes = sequence.chromosomes; // An object (functions as a dictionary)

        this.ideograms = ideograms;
        this.featureDB = {}; // Hash of name -> feature, used for search function.

        this.wholeGenomeView = config.wholeGenomeView === undefined || config.wholeGenomeView;

        if (this.wholeGenomeView && Object.keys(sequence.chromosomes).length > 1) {
          constructWG(this, config);
        } else {
          this.wgChromosomeNames = sequence.chromosomeNames;
        }
        /**
         * Return the official chromosome name for the (possibly) alias.  Deals with
         * 1 <-> chr1,  chrM <-> MT,  IV <-> chr4, etc.
         * @param str
         */


        var chrAliasTable = {},
            self = this; // The standard mappings

        chrAliasTable["all"] = "all";
        this.chromosomeNames.forEach(function (name) {
          var alias = name.startsWith("chr") ? name.substring(3) : "chr" + name;
          chrAliasTable[alias.toLowerCase()] = name;
          if (name === "chrM") chrAliasTable["mt"] = "chrM";
          if (name === "MT") chrAliasTable["chrm"] = "MT";
          chrAliasTable[name.toLowerCase()] = name;
        }); // Custom mappings

        if (aliases) {
          aliases.forEach(function (array) {
            // Find the official chr name
            var defName, i;

            for (i = 0; i < array.length; i++) {
              if (self.chromosomes[array[i]]) {
                defName = array[i];
                break;
              }
            }

            if (defName) {
              array.forEach(function (alias) {
                if (alias !== defName) {
                  chrAliasTable[alias.toLowerCase()] = defName;
                  chrAliasTable[alias] = defName; // Should not be needed
                }
              });
            }
          });
        }

        this.chrAliasTable = chrAliasTable;
      }

      showWholeGenomeView() {
        return this.config.wholeGenomeView !== false;
      }

      toJSON() {
        return Object.assign({}, this.config, {
          tracks: undefined
        });
      }

      getInitialLocus() {}

      getHomeChromosomeName() {
        if (this.showWholeGenomeView() && this.chromosomes.hasOwnProperty("all")) {
          return "all";
        } else {
          return this.chromosomeNames[0];
        }
      }

      getChromosomeName(str) {
        const chr = str ? this.chrAliasTable[str.toLowerCase()] : str;
        return chr ? chr : str;
      }

      getChromosome(chr) {
        chr = this.getChromosomeName(chr);
        return this.chromosomes[chr];
      }

      getCytobands(chr) {
        return this.ideograms ? this.ideograms[chr] : null;
      }

      getLongestChromosome() {
        var longestChr,
            chromosomes = this.chromosomes;

        for (let key in chromosomes) {
          if (chromosomes.hasOwnProperty(key)) {
            var chr = chromosomes[key];

            if (longestChr === undefined || chr.bpLength > longestChr.bpLength) {
              longestChr = chr;
            }
          }

          return longestChr;
        }
      }

      getChromosomes() {
        return this.chromosomes;
      }
      /**
       * Return the genome coordinate in kb for the give chromosome and position.
       * NOTE: This might return undefined if the chr is filtered from whole genome view.
       */


      getGenomeCoordinate(chr, bp) {
        var offset = this.getCumulativeOffset(chr);
        if (offset === undefined) return undefined;
        return offset + bp;
      }
      /**
       * Return the chromosome and coordinate in bp for the given genome coordinate
       */


      getChromosomeCoordinate(genomeCoordinate) {
        if (this.cumulativeOffsets === undefined) {
          this.cumulativeOffsets = computeCumulativeOffsets.call(this);
        }

        let lastChr = undefined;
        let lastCoord = 0;

        for (let name of this.wgChromosomeNames) {
          const cumulativeOffset = this.cumulativeOffsets[name];

          if (cumulativeOffset > genomeCoordinate) {
            const position = genomeCoordinate - lastCoord;
            return {
              chr: lastChr,
              position: position
            };
          }

          lastChr = name;
          lastCoord = cumulativeOffset;
        } // If we get here off the end


        return {
          chr: this.wgChromosomeNames[this.wgChromosomeNames.length - 1],
          position: 0
        };
      }

      /**
       * Return the offset in genome coordinates (kb) of the start of the given chromosome
       * NOTE:  This might return undefined if the chromosome is filtered from whole genome view.
       */
      getCumulativeOffset(chr) {
        if (this.cumulativeOffsets === undefined) {
          this.cumulativeOffsets = computeCumulativeOffsets.call(this);
        }

        const queryChr = this.getChromosomeName(chr);
        return this.cumulativeOffsets[queryChr];

        function computeCumulativeOffsets() {
          let self = this;
          let acc = {};
          let offset = 0;

          for (let name of self.wgChromosomeNames) {
            acc[name] = Math.floor(offset);
            const chromosome = self.getChromosome(name);
            offset += chromosome.bpLength;
          }

          return acc;
        }
      }
      /**
       * Return the nominal genome length, this is the length of the main chromosomes (no scaffolds, etc).
       */


      getGenomeLength() {
        let self = this;

        if (!this.bpLength) {
          let bpLength = 0;
          self.wgChromosomeNames.forEach(function (cname) {
            let c = self.chromosomes[cname];
            bpLength += c.bpLength;
          });
          this.bpLength = bpLength;
        }

        return this.bpLength;
      }

      async getSequence(chr, start, end) {
        chr = this.getChromosomeName(chr);
        return this.sequence.getSequence(chr, start, end);
      }

    }

    async function loadCytobands(cytobandUrl, config) {
      let data;

      if (isDataURL(cytobandUrl)) {
        const plain = decodeDataURI$1(cytobandUrl);
        data = "";
        const len = plain.length;

        for (let i = 0; i < len; i++) {
          data += String.fromCharCode(plain[i]);
        }
      } else {
        data = await igvxhr.loadString(cytobandUrl, buildOptions(config));
      } // var bands = [],
      //     lastChr,
      //     n = 0,
      //     c = 1,
      //
      //     len = lines.length,


      const cytobands = {};
      let lastChr;
      let bands = [];
      const lines = splitLines$1(data);

      for (let line of lines) {
        var tokens = line.split("\t");
        var chr = tokens[0];
        if (!lastChr) lastChr = chr;

        if (chr !== lastChr) {
          cytobands[lastChr] = bands;
          bands = [];
          lastChr = chr;
        }

        if (tokens.length === 5) {
          //10	0	3000000	p15.3	gneg
          var start = parseInt(tokens[1]);
          var end = parseInt(tokens[2]);
          var name = tokens[3];
          var stain = tokens[4];
          bands.push(new Cytoband(start, end, name, stain));
        }
      }

      return cytobands;
    }

    function loadAliases(aliasURL, config) {
      return igvxhr.loadString(aliasURL, buildOptions(config)).then(function (data) {
        var lines = splitLines$1(data),
            aliases = [];
        lines.forEach(function (line) {
          if (!line.startsWith("#") && line.length > 0) aliases.push(line.split("\t"));
        });
        return aliases;
      });
    }

    function constructWG(genome, config) {
      let wgChromosomes;

      if (config.chromosomeOrder) {
        if (Array.isArray(config.chromosomeOrder)) {
          genome.wgChromosomeNames = config.chromosomeOrder;
        } else {
          genome.wgChromosomeNames = config.chromosomeOrder.split(',').map(nm => nm.trim());
        }

        wgChromosomes = genome.wgChromosomeNames.map(nm => genome.chromosomes[nm]).filter(chr => chr !== undefined);
      } else {
        // Trim small chromosomes.
        const lengths = Object.keys(genome.chromosomes).map(key => genome.chromosomes[key].bpLength);
        const median = lengths.reduce((a, b) => Math.max(a, b));
        const threshold = median / 50;
        wgChromosomes = Object.values(genome.chromosomes).filter(chr => chr.bpLength > threshold); // Sort chromosomes.  First segregate numeric and alpha names, sort numeric, leave alpha as is

        const numericChromosomes = wgChromosomes.filter(chr => isDigit(chr.name.replace('chr', '')));
        const alphaChromosomes = wgChromosomes.filter(chr => !isDigit(chr.name.replace('chr', '')));
        numericChromosomes.sort((a, b) => Number.parseInt(a.name.replace('chr', '')) - Number.parseInt(b.name.replace('chr', '')));
        const wgChromosomeNames = numericChromosomes.map(chr => chr.name);

        for (let chr of alphaChromosomes) {
          wgChromosomeNames.push(chr.name);
        }

        genome.wgChromosomeNames = wgChromosomeNames;
      } // Compute psuedo-chromosome "all"


      const l = wgChromosomes.reduce((accumulator, currentValue) => accumulator += currentValue.bpLength, 0);
      genome.chromosomes["all"] = {
        name: "all",
        bpLength: l
      };

      function isDigit(val) {
        return /^\d+$/.test(val);
      }
    }

    function generateGenomeID(config) {
      if (config.id !== undefined) {
        return config.id;
      } else if (config.fastaURL && isString$3(config.fastaURL)) {
        return config.fastaURL;
      } else if (config.fastaURL && config.fastaURL.name) {
        return config.fastaURL.name;
      } else {
        return ("0000" + (Math.random() * Math.pow(36, 4) << 0).toString(36)).slice(-4);
      }
    }

    /**
     * Created by dat on 9/16/16.
     */
    const NOT_LOADED_MESSAGE = 'Error loading track data';
    let lastClickTime = 0;
    let popupTimerID;

    class TrackViewport extends Viewport {
      constructor(trackView, viewportColumn, referenceFrame, width) {
        super(trackView, viewportColumn, referenceFrame, width);
      }

      initializationHelper() {
        this.$spinner = $$1('<div>', {
          class: 'igv-loading-spinner-container'
        });
        this.$viewport.append(this.$spinner);
        this.$spinner.append($$1('<div>'));
        const track = this.trackView.track;

        if ('sequence' !== track.type) {
          this.$zoomInNotice = this.createZoomInNotice(this.$content);
        }

        if (track.name && "sequence" !== track.id) {
          this.$trackLabel = $$1('<div class="igv-track-label">');
          this.$viewport.append(this.$trackLabel);
          this.setTrackLabel(track.name);

          if (false === this.browser.trackLabelsVisible) {
            this.$trackLabel.hide();
          }
        }

        this.stopSpinner();
        this.addMouseHandlers();
      }

      setContentHeight(contentHeight) {
        super.setContentHeight(contentHeight);
        if (this.featureCache) this.featureCache.redraw = true;
      }

      setTrackLabel(label) {
        this.$trackLabel.empty();
        this.$trackLabel.html(label);
        const txt = this.$trackLabel.text();
        this.$trackLabel.attr('title', txt);
      }

      startSpinner() {
        this.$spinner.show();
      }

      stopSpinner() {
        if (this.$spinner) {
          this.$spinner.hide();
        }
      }
      /**
       * Test to determine if we are zoomed in far enough to see features. Applicable to tracks with visibility windows.
       *
       * As a side effect the viewports canvas is removed if zoomed out.
       *
       * @returns {boolean} true if we are zoomed in past visibility window, false otherwise
       */


      checkZoomIn() {
        const zoomedOutOfWindow = () => {
          if (this.referenceFrame.chr.toLowerCase() === "all" && !this.trackView.track.supportsWholeGenome) {
            return true;
          } else {
            const visibilityWindow = this.trackView.track.visibilityWindow;
            return visibilityWindow !== undefined && visibilityWindow > 0 && this.referenceFrame.bpPerPixel * this.$viewport.width() > visibilityWindow;
          }
        };

        if (this.trackView.track && "sequence" === this.trackView.track.type && this.referenceFrame.bpPerPixel > 1) {
          $$1(this.canvas).remove();
          this.canvas = undefined; //this.featureCache = undefined

          return false;
        }

        if (!this.viewIsReady()) {
          return false;
        }

        if (zoomedOutOfWindow()) {
          // Out of visibility window
          if (this.canvas) {
            $$1(this.canvas).remove();
            this.canvas = undefined; //this.featureCache = undefined
          }

          if (this.trackView.track.autoHeight) {
            const minHeight = this.trackView.minHeight || 0;
            this.setContentHeight(minHeight);
          }

          if (this.$zoomInNotice) {
            this.$zoomInNotice.show();
          }

          return false;
        } else {
          if (this.$zoomInNotice) {
            this.$zoomInNotice.hide();
          }

          return true;
        }
      }
      /**
       * Adjust the canvas to the current genomic state.
       */


      shift() {
        const referenceFrame = this.referenceFrame;

        if (this.canvas && this.canvas._data && this.canvas._data.chr === this.referenceFrame.chr && this.canvas._data.bpPerPixel === referenceFrame.bpPerPixel) {
          const pixelOffset = Math.round((this.canvas._data.startBP - referenceFrame.start) / referenceFrame.bpPerPixel);
          this.canvas.style.left = pixelOffset + "px";
        }
      }

      async loadFeatures() {
        const referenceFrame = this.referenceFrame;
        const chr = referenceFrame.chr; // Expand the requested range so we can pan a bit without reloading.  But not beyond chromosome bounds

        const chrLength = this.browser.genome.getChromosome(chr).bpLength;
        const pixelWidth = this.$content.width(); // * 3;

        const bpWidth = pixelWidth * referenceFrame.bpPerPixel;
        const bpStart = Math.floor(Math.max(0, referenceFrame.start - bpWidth));
        const bpEnd = Math.ceil(Math.min(chrLength, referenceFrame.start + bpWidth + bpWidth)); // Add one screen width to end

        if (this.loading && this.loading.start === bpStart && this.loading.end === bpEnd) {
          return undefined;
        }

        this.loading = {
          start: bpStart,
          end: bpEnd
        };
        this.startSpinner();

        try {
          const track = this.trackView.track;
          const features = await this.getFeatures(track, chr, bpStart, bpEnd, referenceFrame.bpPerPixel);
          let roiFeatures = [];
          const roi = mergeArrays(this.browser.roi, track.roi);

          if (roi) {
            for (let r of roi) {
              const f = await r.getFeatures(chr, bpStart, bpEnd, referenceFrame.bpPerPixel);
              roiFeatures.push({
                track: r,
                features: f
              });
            }
          }

          const mr = track && ("wig" === track.type || "merged" === track.type); // wig tracks are potentially multiresolution (e.g. bigwig)

          this.featureCache = new FeatureCache(chr, bpStart, bpEnd, referenceFrame.bpPerPixel, features, roiFeatures, mr);
          this.loading = false;
          this.hideMessage();
          this.stopSpinner();
          return this.featureCache;
        } catch (error) {
          // Track might have been removed during load
          if (this.trackView && this.trackView.disposed !== true) {
            this.showMessage(NOT_LOADED_MESSAGE);
            Alert.presentAlert(error);
            console.error(error);
          }
        } finally {
          this.loading = false;
          this.stopSpinner();
        }
      }

      repaintDimensions() {
        const isWGV = GenomeUtils.isWholeGenomeView(this.referenceFrame.chr);
        const pixelWidth = isWGV ? this.$viewport.width() : 3 * this.$viewport.width();
        const bpPerPixel = this.referenceFrame.bpPerPixel;
        const startBP = this.referenceFrame.start - (isWGV ? 0 : pixelWidth / 3 * bpPerPixel);
        const endBP = this.referenceFrame.end + (isWGV ? 0 : pixelWidth / 3 * bpPerPixel);
        return {
          startBP,
          endBP,
          pixelWidth
        };
      }
      /**
       * Repaint the canvas using the cached features
       *
       */


      repaint() {
        if (undefined === this.featureCache) {
          return;
        }

        let {
          features,
          roiFeatures
        } = this.featureCache; //this.tile.bpPerPixel = this.referenceFrame.bpPerPixel
        // const isWGV = GenomeUtils.isWholeGenomeView(this.browser.referenceFrameList[0].chr)

        GenomeUtils.isWholeGenomeView(this.referenceFrame.chr); // Canvas dimensions. There is no left-right panning for WGV so canvas width is viewport width.
        // For deep tracks we paint a canvas == 3*viewportHeight centered on the current vertical scroll position

        const {
          startBP,
          endBP,
          pixelWidth
        } = this.repaintDimensions();
        const viewportHeight = this.$viewport.height();
        const contentHeight = this.getContentHeight();
        const minHeight = roiFeatures ? Math.max(contentHeight, viewportHeight) : contentHeight; // Need to fill viewport for ROIs.

        const pixelHeight = Math.min(minHeight, 3 * viewportHeight);

        if (0 === pixelWidth || 0 === pixelHeight) {
          if (this.canvas) {
            $$1(this.canvas).remove();
          }

          return;
        }

        const canvasTop = Math.max(0, -this.$content.position().top - viewportHeight);
        const bpPerPixel = this.referenceFrame.bpPerPixel; //const startBP = this.referenceFrame.start - (isWGV ? 0 : pixelWidth / 3 * bpPerPixel)
        //const endBP = this.referenceFrame.end + (isWGV ? 0 : pixelWidth / 3 * bpPerPixel)

        const pixelXOffset = Math.round((startBP - this.referenceFrame.start) / bpPerPixel);
        const newCanvas = $$1('<canvas class="igv-canvas">').get(0);
        newCanvas.style.width = pixelWidth + "px";
        newCanvas.style.height = pixelHeight + "px";
        newCanvas.style.left = pixelXOffset + "px";
        newCanvas.style.top = canvasTop + "px"; // Always use high DPI if in "FILL" display mode, otherwise use track setting;

        const devicePixelRatio = "FILL" === this.trackView.track.displayMode || this.trackView.track.supportHiDPI !== false ? window.devicePixelRatio : 1;
        newCanvas.width = devicePixelRatio * pixelWidth;
        newCanvas.height = devicePixelRatio * pixelHeight;
        const ctx = newCanvas.getContext("2d");
        ctx.scale(devicePixelRatio, devicePixelRatio);
        ctx.translate(0, -canvasTop);
        const drawConfiguration = {
          context: ctx,
          pixelXOffset,
          pixelWidth,
          pixelHeight,
          pixelTop: canvasTop,
          bpStart: startBP,
          bpEnd: endBP,
          bpPerPixel,
          referenceFrame: this.referenceFrame,
          selection: this.selection,
          viewport: this,
          viewportWidth: this.$viewport.width()
        };
        this.draw(drawConfiguration, features, roiFeatures);
        this.featureCache.canvasTop = canvasTop;
        this.featureCache.height = pixelHeight;

        if (this.canvas) {
          $$1(this.canvas).remove();
        }

        newCanvas._data = {
          chr: this.featureCache.chr,
          bpPerPixel,
          startBP,
          endBP,
          pixelHeight,
          pixelTop: canvasTop
        };
        this.canvas = newCanvas;
        this.$content.append($$1(newCanvas));
      }
      /**
       * Draw the associated track.
       *
       * @param drawConfiguration
       * @param features
       * @param roiFeatures
       */


      draw(drawConfiguration, features, roiFeatures) {
        // console.log(`${ Date.now() } viewport draw(). track ${ this.trackView.track.type }. content-css-top ${ this.$content.css('top') }. canvas-top ${ drawConfiguration.pixelTop }.`)
        if (features) {
          drawConfiguration.features = features;
          this.trackView.track.draw(drawConfiguration);
        }

        if (roiFeatures) {
          for (let r of roiFeatures) {
            drawConfiguration.features = r.features;
            r.track.draw(drawConfiguration);
          }
        }
      }

      containsPosition(chr, position) {
        if (this.referenceFrame.chr === chr && position >= this.referenceFrame.start) {
          return position <= this.referenceFrame.calculateEnd(this.getWidth());
        } else {
          return false;
        }
      }

      isLoading() {
        return this.loading;
      }

      savePNG() {
        if (!this.canvas) return;
        const canvasMetadata = this.featureCache;
        const canvasTop = canvasMetadata ? canvasMetadata.canvasTop : 0;
        const devicePixelRatio = window.devicePixelRatio;
        const w = this.$viewport.width() * devicePixelRatio;
        const h = this.$viewport.height() * devicePixelRatio;
        const x = -$$1(this.canvas).position().left * devicePixelRatio;
        const y = (-this.$content.position().top - canvasTop) * devicePixelRatio;
        const ctx = this.canvas.getContext("2d");
        const imageData = ctx.getImageData(x, y, w, h);
        const exportCanvas = document.createElement('canvas');
        const exportCtx = exportCanvas.getContext('2d');
        exportCanvas.width = imageData.width;
        exportCanvas.height = imageData.height;
        exportCtx.putImageData(imageData, 0, 0); // filename = this.trackView.track.name + ".png";

        const filename = (this.$trackLabel.text() ? this.$trackLabel.text() : "image") + ".png";
        const data = exportCanvas.toDataURL("image/png");
        download(filename, data);
      }

      saveSVG() {
        const {
          width,
          height
        } = this.$viewport.get(0).getBoundingClientRect();
        const config = {
          width,
          height,
          viewbox: {
            x: 0,
            y: -this.$content.position().top,
            width,
            height
          }
        };
        const context = new ctx(config);
        const str = (this.trackView.track.name || this.trackView.track.id).replace(/\W/g, '');
        const index = this.browser.referenceFrameList.indexOf(this.referenceFrame);
        const id = `${str}_referenceFrame_${index}_guid_${guid$2()}`;
        this.drawSVGWithContext(context, width, height, id, 0, 0, 0);
        const svg = context.getSerializedSvg(true);
        const data = URL.createObjectURL(new Blob([svg], {
          type: "application/octet-stream"
        }));
        download(`${id}.svg`, data);
      } // called by trackView.renderSVGContext() when rendering
      // entire browser as SVG


      renderSVGContext(context, _ref) {
        let {
          deltaX,
          deltaY
        } = _ref;

        // Nothing to do if zoomInNotice is active
        if (this.$zoomInNotice && this.$zoomInNotice.is(":visible")) {
          return;
        }

        const str = (this.trackView.track.name || this.trackView.track.id).replace(/\W/g, '');
        const index = this.browser.referenceFrameList.indexOf(this.referenceFrame);
        const id = `${str}_referenceFrame_${index}_guid_${guid$2()}`;
        const {
          top: yScrollDelta
        } = this.$content.position();
        const {
          width,
          height
        } = this.$viewport.get(0).getBoundingClientRect();
        this.drawSVGWithContext(context, width, height, id, deltaX, deltaY + yScrollDelta, -yScrollDelta);

        if (this.$trackLabel && true === this.browser.trackLabelsVisible) {
          const {
            x,
            y,
            width,
            height
          } = relativeDOMBBox(this.$viewport.get(0), this.$trackLabel.get(0));
          this.renderTrackLabelSVG(context, deltaX + x, deltaY + y, width, height);
        }
      } // render track label element called from renderSVGContext()


      renderTrackLabelSVG(context, tx, ty, width, height) {
        const str = (this.trackView.track.name || this.trackView.track.id).replace(/\W/g, '');
        const id = `${str}_track_label_guid_${guid$2()}`;
        context.saveWithTranslationAndClipRect(id, tx, ty, width, height, 0);
        context.fillStyle = "white";
        context.fillRect(0, 0, width, height);
        context.font = "12px Arial";
        context.fillStyle = 'rgb(68, 68, 68)';
        const {
          width: stringWidth
        } = context.measureText(this.$trackLabel.text());
        const dx = 0.25 * (width - stringWidth);
        const dy = 0.7 * (height - 12);
        context.fillText(this.$trackLabel.text(), dx, height - dy);
        context.strokeStyle = 'rgb(68, 68, 68)';
        context.strokeRect(0, 0, width, height);
        context.restore();
      } // called by renderSVGContext()


      drawSVGWithContext(context, width, height, id, x, y, yClipOffset) {
        context.saveWithTranslationAndClipRect(id, x, y, width, height, yClipOffset);
        let {
          start,
          bpPerPixel
        } = this.referenceFrame;
        const config = {
          context,
          viewport: this,
          referenceFrame: this.referenceFrame,
          top: yClipOffset,
          pixelTop: yClipOffset,
          pixelWidth: width,
          pixelHeight: height,
          bpStart: start,
          bpEnd: start + width * bpPerPixel,
          bpPerPixel,
          viewportWidth: width,
          selection: this.selection
        };
        const features = this.featureCache ? this.featureCache.features : [];
        const roiFeatures = this.featureCache ? this.featureCache.roiFeatures : undefined;
        this.draw(config, features, roiFeatures);
        context.restore();
      }

      get cachedFeatures() {
        return this.featureCache ? this.featureCache.features : [];
      }

      async getFeatures(track, chr, start, end, bpPerPixel) {
        if (this.featureCache && this.featureCache.containsRange(chr, start, end, bpPerPixel)) {
          return this.featureCache.features;
        } else if (typeof track.getFeatures === "function") {
          const features = await track.getFeatures(chr, start, end, bpPerPixel, this);
          this.checkContentHeight(features);
          return features;
        } else {
          return undefined;
        }
      }

      needsRepaint() {
        if (!this.canvas) return true;
        const data = this.canvas._data;
        return !data || this.referenceFrame.start < data.startBP || this.referenceFrame.end > data.endBP || this.referenceFrame.chr !== data.chr || this.referenceFrame.bpPerPixel != data.bpPerPixel;
      }

      needsReload() {
        if (!this.featureCache) return true;
        const referenceFrame = this.referenceFrame;
        const chr = this.referenceFrame.chr;
        const bpPerPixel = referenceFrame.bpPerPixel;
        const {
          startBP,
          endBP
        } = this.repaintDimensions();
        return !this.featureCache.containsRange(chr, startBP, endBP, bpPerPixel);
      }

      createZoomInNotice($parent) {
        const $container = $$1('<div>', {
          class: 'igv-zoom-in-notice-container'
        });
        $parent.append($container);
        const $e = $$1('<div>');
        $container.append($e);
        $e.text('Zoom in to see features');
        $container.hide();
        return $container;
      }

      viewIsReady() {
        return this.browser && this.browser.referenceFrameList && this.referenceFrame;
      }

      addMouseHandlers() {
        const viewport = this.$viewport.get(0);
        this.addViewportContextMenuHandler(viewport);

        const md = event => {
          this.enableClick = true;
          this.browser.mouseDownOnViewport(event, this);
          pageCoordinates$1(event);
        };

        viewport.addEventListener('mousedown', md);
        viewport.addEventListener('touchstart', md);

        const mu = event => {
          // Any mouse up cancels drag and scrolling
          if (this.browser.dragObject || this.browser.isScrolling) {
            this.browser.cancelTrackPan(); // event.preventDefault();
            // event.stopPropagation();

            this.enableClick = false; // Until next mouse down
          } else {
            this.browser.cancelTrackPan();
            this.browser.endTrackDrag();
          }
        };

        viewport.addEventListener('mouseup', mu);
        viewport.addEventListener('touchend', mu);
        this.addViewportClickHandler(this.$viewport.get(0));

        if (this.trackView.track.name && "sequence" !== this.trackView.track.config.type) {
          this.addTrackLabelClickHandler(this.$trackLabel.get(0));
        }
      }

      addViewportContextMenuHandler(viewport) {
        viewport.addEventListener('contextmenu', event => {
          // Ignore if we are doing a drag.  This can happen with touch events.
          if (this.browser.dragObject) {
            return false;
          }

          const clickState = createClickState(event, this);

          if (undefined === clickState) {
            return false;
          }

          event.preventDefault(); // Track specific items

          let menuItems = [];

          if (typeof this.trackView.track.contextMenuItemList === "function") {
            const trackMenuItems = this.trackView.track.contextMenuItemList(clickState);

            if (trackMenuItems) {
              menuItems = trackMenuItems;
            }
          } // Add items common to all tracks


          if (menuItems.length > 0) {
            menuItems.push({
              label: $$1('<HR>')
            });
          }

          menuItems.push({
            label: 'Save Image (PNG)',
            click: () => this.savePNG()
          });
          menuItems.push({
            label: 'Save Image (SVG)',
            click: () => this.saveSVG()
          });
          this.browser.menuPopup.presentTrackContextMenu(event, menuItems);
        });
      }

      addViewportClickHandler(viewport) {
        viewport.addEventListener('click', event => {
          if (this.enableClick && this.canvas) {
            if (3 === event.which || event.ctrlKey) {
              return;
            } // Close any currently open popups


            $$1('.igv-popover').hide();

            if (this.browser.dragObject || this.browser.isScrolling) {
              return;
            } // Treat as a mouse click, its either a single or double click.
            // Handle here and stop propogation / default


            event.preventDefault();
            const mouseX = translateMouseCoordinates$1(event, this.$viewport.get(0)).x;
            const mouseXCanvas = translateMouseCoordinates$1(event, this.canvas).x;
            const referenceFrame = this.referenceFrame;
            const xBP = Math.floor(referenceFrame.start + referenceFrame.toBP(mouseXCanvas));
            const time = Date.now();

            if (time - lastClickTime < this.browser.constants.doubleClickDelay) {
              // double-click
              if (popupTimerID) {
                window.clearTimeout(popupTimerID);
                popupTimerID = undefined;
              }

              const centerBP = Math.round(referenceFrame.start + referenceFrame.toBP(mouseX));
              let string;

              if ('all' === this.referenceFrame.chr.toLowerCase()) {
                const chr = this.browser.genome.getChromosomeCoordinate(centerBP).chr;

                if (1 === this.browser.referenceFrameList.length) {
                  string = chr;
                } else {
                  const loci = this.browser.referenceFrameList.map(_ref2 => {
                    let {
                      locusSearchString
                    } = _ref2;
                    return locusSearchString;
                  });
                  const index = this.browser.referenceFrameList.indexOf(this.referenceFrame);
                  loci[index] = chr;
                  string = loci.join(' ');
                }

                this.browser.search(string);
              } else {
                this.browser.zoomWithScaleFactor(0.5, centerBP, this.referenceFrame);
              }
            } else {
              // single-click
              if (event.shiftKey && typeof this.trackView.track.shiftClick === "function") {
                this.trackView.track.shiftClick(xBP, event);
              } else if (typeof this.trackView.track.popupData === "function") {
                popupTimerID = setTimeout(() => {
                  const content = getPopupContent(event, this);

                  if (content) {
                    if (this.popover) this.popover.dispose();
                    this.popover = new Popover(this.browser.columnContainer);
                    this.popover.presentContentWithEvent(event, content);
                  }

                  window.clearTimeout(popupTimerID);
                  popupTimerID = undefined;
                }, this.browser.constants.doubleClickDelay);
              }
            }

            lastClickTime = time;
          }
        });
      }

      addTrackLabelClickHandler(trackLabel) {
        trackLabel.addEventListener('click', event => {
          event.stopPropagation();
          const {
            track
          } = this.trackView;
          let str;

          if (typeof track.description === 'function') {
            str = track.description();
          } else if (track.description) {
            str = `<div>${track.description}</div>`;
          }

          if (str) {
            if (this.popover) {
              this.popover.dispose();
            }

            this.popover = new Popover(this.browser.columnContainer, track.name || '');
            this.popover.presentContentWithEvent(event, str);
          }
        });
      }

    }

    function createClickState(event, viewport) {
      const referenceFrame = viewport.referenceFrame;
      const viewportCoords = translateMouseCoordinates$1(event, viewport.contentDiv);
      const canvasCoords = translateMouseCoordinates$1(event, viewport.canvas);
      const genomicLocation = referenceFrame.start + referenceFrame.toBP(viewportCoords.x);
      return {
        event,
        viewport,
        referenceFrame,
        genomicLocation,
        x: viewportCoords.x,
        y: viewportCoords.y,
        canvasX: canvasCoords.x,
        canvasY: canvasCoords.y
      };
    }

    function getPopupContent(event, viewport) {
      const clickState = createClickState(event, viewport);

      if (undefined === clickState) {
        return;
      }

      let track = viewport.trackView.track;
      const dataList = track.popupData(clickState);
      const popupClickHandlerResult = viewport.browser.fireEvent('trackclick', [track, dataList]);
      let content;

      if (undefined === popupClickHandlerResult || true === popupClickHandlerResult) {
        // Indicates handler did not handle the result, or the handler wishes default behavior to occur
        if (dataList && dataList.length > 0) {
          content = formatPopoverText(dataList);
        }
      } else if (typeof popupClickHandlerResult === 'string') {
        content = popupClickHandlerResult;
      }

      return content;
    }

    function formatPopoverText(nameValues) {
      const rows = nameValues.map(nameValue => {
        if (nameValue.name) {
          const str = `<span>${nameValue.name}</span>&nbsp&nbsp&nbsp${nameValue.value}`;
          return `<div title="${nameValue.value}">${str}</div>`;
        } else if ('<hr>' === nameValue) {
          // this can be retired if nameValue.html is allowed.
          return nameValue;
        } else if (nameValue.html) {
          return nameValue.html;
        } else {
          return `<div title="${nameValue}">${nameValue}</div>`;
        }
      });
      return rows.join('');
    }

    class FeatureCache {
      constructor(chr, tileStart, tileEnd, bpPerPixel, features, roiFeatures, multiresolution) {
        this.chr = chr;
        this.startBP = tileStart;
        this.endBP = tileEnd;
        this.bpPerPixel = bpPerPixel;
        this.features = features;
        this.roiFeatures = roiFeatures;
        this.multiresolution = multiresolution;
      }

      containsRange(chr, start, end, bpPerPixel) {
        // For multi-resolution tracks allow for a 2X change in bpPerPixel
        const r = this.multiresolution ? this.bpPerPixel / bpPerPixel : 1;
        return start >= this.startBP && end <= this.endBP && chr === this.chr && r > 0.5 && r < 2;
      }

      overlapsRange(chr, start, end) {
        return this.chr === chr && end >= this.startBP && start <= this.endBP;
      }

    }
    /**
     * Merge 2 arrays.  a and/or b can be undefined.  If both are undefined, return undefined
     * @param a An array or undefined
     * @param b An array or undefined
     */


    function mergeArrays(a, b) {
      if (a && b) return a.concat(b);else if (a) return a;else return b;
    }

    /*
     * The MIT License (MIT)
     *
     * Copyright (c) 2016-2017 The Regents of the University of California
     * Author: Jim Robinson
     *
     * Permission is hereby granted, free of charge, to any person obtaining a copy
     * of this software and associated documentation files (the "Software"), to deal
     * in the Software without restriction, including without limitation the rights
     * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
     * copies of the Software, and to permit persons to whom the Software is
     * furnished to do so, subject to the following conditions:
     *
     * The above copyright notice and this permission notice shall be included in
     * all copies or substantial portions of the Software.
     *
     *
     * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
     * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
     * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
     * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
     * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
     * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
     * THE SOFTWARE.
     */

    class RulerSweeper {
      constructor(rulerViewport) {
        this.rulerSweeper = div$1({
          class: 'igv-ruler-sweeper'
        });
        rulerViewport.contentDiv.appendChild(this.rulerSweeper);
        this.rulerViewport = rulerViewport;
        this.isMouseHandlers = undefined;
        this.addBrowserObserver();
      }

      addBrowserObserver() {
        // Viewport Content
        this.boundObserverHandler = observerHandler.bind(this);
        this.rulerViewport.browser.on('locuschange', this.boundObserverHandler);

        function observerHandler() {
          if (this.rulerViewport.referenceFrame) {
            if (GenomeUtils.isWholeGenomeView(this.rulerViewport.referenceFrame.chr)) {
              this.removeMouseHandlers();
            } else {
              this.addMouseHandlers();
            }
          }
        }
      }

      removeBrowserObserver() {
        this.rulerViewport.browser.off('locuschange', this.boundObserverHandler);
      }

      addMouseHandlers() {
        if (true === this.isMouseHandlers) {
          return;
        }

        let isMouseDown;
        let isMouseIn;
        let mouseDownX;
        let left;
        let width;
        let dx;
        let threshold = 1; // Viewport Content

        this.boundContentMouseDownHandler = contentMouseDownHandler.bind(this);
        this.rulerViewport.contentDiv.addEventListener('mousedown', this.boundContentMouseDownHandler);

        function contentMouseDownHandler(event) {
          isMouseDown = true;
          isMouseIn = true;
          const {
            x
          } = translateMouseCoordinates$1(event, this.rulerViewport.contentDiv);
          left = mouseDownX = x;
          width = threshold;
          this.rulerSweeper.style.display = 'block';
          this.rulerSweeper.style.left = `${left}px`;
          this.rulerSweeper.style.width = `${width}px`;
        } // Document


        this.boundDocumentMouseMoveHandler = documentMouseMoveHandler.bind(this);
        document.addEventListener('mousemove', this.boundDocumentMouseMoveHandler);

        function documentMouseMoveHandler(event) {
          // console.log(`${ Date.now() } RulerSweeper - documentMouseMoveHandler - target ${ event.target.nodeName }`)
          let mouseCurrentX;

          if (isMouseDown && isMouseIn) {
            const {
              x
            } = translateMouseCoordinates$1(event, this.rulerViewport.contentDiv);
            mouseCurrentX = Math.max(Math.min(x, this.rulerViewport.contentDiv.clientWidth), 0);
            dx = mouseCurrentX - mouseDownX;
            width = Math.abs(dx);
            this.rulerSweeper.style.width = `${width}px`;

            if (dx < 0) {
              left = mouseDownX + dx;
              this.rulerSweeper.style.left = `${left}px`;
            }
          }
        }

        this.boundDocumentMouseUpHandler = documentMouseUpHandler.bind(this);
        document.addEventListener('mouseup', this.boundDocumentMouseUpHandler);

        function documentMouseUpHandler(event) {
          // console.log(`${ Date.now() } RulerSweeper - documentMouseUpHandler - target ${ event.target.nodeName }`)
          let extent;

          if (true === isMouseDown && true === isMouseIn) {
            isMouseDown = isMouseIn = undefined;
            this.rulerSweeper.style.display = 'none';

            if (width > threshold) {
              extent = {
                start: bp(this.rulerViewport.referenceFrame, left),
                end: bp(this.rulerViewport.referenceFrame, left + width)
              };
              validateLocusExtent(this.rulerViewport.browser.genome.getChromosome(this.rulerViewport.referenceFrame.chr).bpLength, extent, this.rulerViewport.browser.minimumBases());
              const newStart = Math.round(extent.start);
              const newEnd = Math.round(extent.end);
              this.rulerViewport.referenceFrame.bpPerPixel = (newEnd - newStart) / this.rulerViewport.contentDiv.clientWidth;
              this.rulerViewport.referenceFrame.start = newStart;
              this.rulerViewport.referenceFrame.end = newEnd;
              this.rulerViewport.browser.updateViews();
            }
          }
        }

        this.isMouseHandlers = true;
      }

      removeMouseHandlers() {
        this.rulerViewport.contentDiv.removeEventListener('mousedown', this.boundContentMouseDownHandler);
        document.removeEventListener('mousemove', this.boundDocumentMouseMoveHandler);
        document.removeEventListener('mouseup', this.boundDocumentMouseUpHandler);
        this.isMouseHandlers = false;
      }

      dispose() {
        this.removeBrowserObserver();
        this.removeMouseHandlers();
        this.rulerSweeper.remove();
      }

    }

    function bp(referenceFrame, pixel) {
      return referenceFrame.start + pixel * referenceFrame.bpPerPixel;
    }

    // eslint-disable-next-line es-x/no-typed-arrays -- safe
    var arrayBufferNative = typeof ArrayBuffer != 'undefined' && typeof DataView != 'undefined';

    var TO_STRING_TAG$2 = wellKnownSymbol('toStringTag');
    var test = {};
    test[TO_STRING_TAG$2] = 'z';
    var toStringTagSupport = String(test) === '[object z]';

    var TO_STRING_TAG$1 = wellKnownSymbol('toStringTag');
    var Object$2 = global$1.Object; // ES3 wrong here

    var CORRECT_ARGUMENTS = classofRaw(function () {
      return arguments;
    }()) == 'Arguments'; // fallback for IE11 Script Access Denied error

    var tryGet = function (it, key) {
      try {
        return it[key];
      } catch (error) {
        /* empty */
      }
    }; // getting tag from ES6+ `Object.prototype.toString`


    var classof = toStringTagSupport ? classofRaw : function (it) {
      var O, tag, result;
      return it === undefined ? 'Undefined' : it === null ? 'Null' // @@toStringTag case
      : typeof (tag = tryGet(O = Object$2(it), TO_STRING_TAG$1)) == 'string' ? tag // builtinTag case
      : CORRECT_ARGUMENTS ? classofRaw(O) // ES3 arguments fallback
      : (result = classofRaw(O)) == 'Object' && isCallable(O.callee) ? 'Arguments' : result;
    };

    var correctPrototypeGetter = !fails(function () {
      function F() {
        /* empty */
      }

      F.prototype.constructor = null; // eslint-disable-next-line es-x/no-object-getprototypeof -- required for testing

      return Object.getPrototypeOf(new F()) !== F.prototype;
    });

    var IE_PROTO = sharedKey('IE_PROTO');
    var Object$1 = global$1.Object;
    var ObjectPrototype$1 = Object$1.prototype; // `Object.getPrototypeOf` method
    // https://tc39.es/ecma262/#sec-object.getprototypeof

    var objectGetPrototypeOf = correctPrototypeGetter ? Object$1.getPrototypeOf : function (O) {
      var object = toObject(O);
      if (hasOwnProperty_1(object, IE_PROTO)) return object[IE_PROTO];
      var constructor = object.constructor;

      if (isCallable(constructor) && object instanceof constructor) {
        return constructor.prototype;
      }

      return object instanceof Object$1 ? ObjectPrototype$1 : null;
    };

    var String$2 = global$1.String;
    var TypeError$3 = global$1.TypeError;

    var aPossiblePrototype = function (argument) {
      if (typeof argument == 'object' || isCallable(argument)) return argument;
      throw TypeError$3("Can't set " + String$2(argument) + ' as a prototype');
    };

    /* eslint-disable no-proto -- safe */
    // https://tc39.es/ecma262/#sec-object.setprototypeof
    // Works with __proto__ only. Old v8 can't work with null proto objects.
    // eslint-disable-next-line es-x/no-object-setprototypeof -- safe

    var objectSetPrototypeOf = Object.setPrototypeOf || ('__proto__' in {} ? function () {
      var CORRECT_SETTER = false;
      var test = {};
      var setter;

      try {
        // eslint-disable-next-line es-x/no-object-getownpropertydescriptor -- safe
        setter = functionUncurryThis(Object.getOwnPropertyDescriptor(Object.prototype, '__proto__').set);
        setter(test, []);
        CORRECT_SETTER = test instanceof Array;
      } catch (error) {
        /* empty */
      }

      return function setPrototypeOf(O, proto) {
        anObject(O);
        aPossiblePrototype(proto);
        if (CORRECT_SETTER) setter(O, proto);else O.__proto__ = proto;
        return O;
      };
    }() : undefined);

    var defineProperty = objectDefineProperty.f;
    var Int8Array$1 = global$1.Int8Array;
    var Int8ArrayPrototype$1 = Int8Array$1 && Int8Array$1.prototype;
    var Uint8ClampedArray$1 = global$1.Uint8ClampedArray;
    var Uint8ClampedArrayPrototype = Uint8ClampedArray$1 && Uint8ClampedArray$1.prototype;
    var TypedArray = Int8Array$1 && objectGetPrototypeOf(Int8Array$1);
    var TypedArrayPrototype = Int8ArrayPrototype$1 && objectGetPrototypeOf(Int8ArrayPrototype$1);
    var ObjectPrototype = Object.prototype;
    var TypeError$2 = global$1.TypeError;
    var TO_STRING_TAG = wellKnownSymbol('toStringTag');
    var TYPED_ARRAY_TAG = uid('TYPED_ARRAY_TAG');
    var TYPED_ARRAY_CONSTRUCTOR = uid('TYPED_ARRAY_CONSTRUCTOR'); // Fixing native typed arrays in Opera Presto crashes the browser, see #595

    var NATIVE_ARRAY_BUFFER_VIEWS = arrayBufferNative && !!objectSetPrototypeOf && classof(global$1.opera) !== 'Opera';
    var TYPED_ARRAY_TAG_REQUIRED = false;
    var NAME, Constructor, Prototype;
    var TypedArrayConstructorsList = {
      Int8Array: 1,
      Uint8Array: 1,
      Uint8ClampedArray: 1,
      Int16Array: 2,
      Uint16Array: 2,
      Int32Array: 4,
      Uint32Array: 4,
      Float32Array: 4,
      Float64Array: 8
    };
    var BigIntArrayConstructorsList = {
      BigInt64Array: 8,
      BigUint64Array: 8
    };

    var isView = function isView(it) {
      if (!isObject(it)) return false;
      var klass = classof(it);
      return klass === 'DataView' || hasOwnProperty_1(TypedArrayConstructorsList, klass) || hasOwnProperty_1(BigIntArrayConstructorsList, klass);
    };

    var isTypedArray = function (it) {
      if (!isObject(it)) return false;
      var klass = classof(it);
      return hasOwnProperty_1(TypedArrayConstructorsList, klass) || hasOwnProperty_1(BigIntArrayConstructorsList, klass);
    };

    var aTypedArray$1 = function (it) {
      if (isTypedArray(it)) return it;
      throw TypeError$2('Target is not a typed array');
    };

    var aTypedArrayConstructor = function (C) {
      if (isCallable(C) && (!objectSetPrototypeOf || objectIsPrototypeOf(TypedArray, C))) return C;
      throw TypeError$2(tryToString(C) + ' is not a typed array constructor');
    };

    var exportTypedArrayMethod$1 = function (KEY, property, forced, options) {
      if (!descriptors) return;
      if (forced) for (var ARRAY in TypedArrayConstructorsList) {
        var TypedArrayConstructor = global$1[ARRAY];
        if (TypedArrayConstructor && hasOwnProperty_1(TypedArrayConstructor.prototype, KEY)) try {
          delete TypedArrayConstructor.prototype[KEY];
        } catch (error) {
          // old WebKit bug - some methods are non-configurable
          try {
            TypedArrayConstructor.prototype[KEY] = property;
          } catch (error2) {
            /* empty */
          }
        }
      }

      if (!TypedArrayPrototype[KEY] || forced) {
        defineBuiltIn(TypedArrayPrototype, KEY, forced ? property : NATIVE_ARRAY_BUFFER_VIEWS && Int8ArrayPrototype$1[KEY] || property, options);
      }
    };

    var exportTypedArrayStaticMethod = function (KEY, property, forced) {
      var ARRAY, TypedArrayConstructor;
      if (!descriptors) return;

      if (objectSetPrototypeOf) {
        if (forced) for (ARRAY in TypedArrayConstructorsList) {
          TypedArrayConstructor = global$1[ARRAY];
          if (TypedArrayConstructor && hasOwnProperty_1(TypedArrayConstructor, KEY)) try {
            delete TypedArrayConstructor[KEY];
          } catch (error) {
            /* empty */
          }
        }

        if (!TypedArray[KEY] || forced) {
          // V8 ~ Chrome 49-50 `%TypedArray%` methods are non-writable non-configurable
          try {
            return defineBuiltIn(TypedArray, KEY, forced ? property : NATIVE_ARRAY_BUFFER_VIEWS && TypedArray[KEY] || property);
          } catch (error) {
            /* empty */
          }
        } else return;
      }

      for (ARRAY in TypedArrayConstructorsList) {
        TypedArrayConstructor = global$1[ARRAY];

        if (TypedArrayConstructor && (!TypedArrayConstructor[KEY] || forced)) {
          defineBuiltIn(TypedArrayConstructor, KEY, property);
        }
      }
    };

    for (NAME in TypedArrayConstructorsList) {
      Constructor = global$1[NAME];
      Prototype = Constructor && Constructor.prototype;
      if (Prototype) createNonEnumerableProperty(Prototype, TYPED_ARRAY_CONSTRUCTOR, Constructor);else NATIVE_ARRAY_BUFFER_VIEWS = false;
    }

    for (NAME in BigIntArrayConstructorsList) {
      Constructor = global$1[NAME];
      Prototype = Constructor && Constructor.prototype;
      if (Prototype) createNonEnumerableProperty(Prototype, TYPED_ARRAY_CONSTRUCTOR, Constructor);
    } // WebKit bug - typed arrays constructors prototype is Object.prototype


    if (!NATIVE_ARRAY_BUFFER_VIEWS || !isCallable(TypedArray) || TypedArray === Function.prototype) {
      // eslint-disable-next-line no-shadow -- safe
      TypedArray = function TypedArray() {
        throw TypeError$2('Incorrect invocation');
      };

      if (NATIVE_ARRAY_BUFFER_VIEWS) for (NAME in TypedArrayConstructorsList) {
        if (global$1[NAME]) objectSetPrototypeOf(global$1[NAME], TypedArray);
      }
    }

    if (!NATIVE_ARRAY_BUFFER_VIEWS || !TypedArrayPrototype || TypedArrayPrototype === ObjectPrototype) {
      TypedArrayPrototype = TypedArray.prototype;
      if (NATIVE_ARRAY_BUFFER_VIEWS) for (NAME in TypedArrayConstructorsList) {
        if (global$1[NAME]) objectSetPrototypeOf(global$1[NAME].prototype, TypedArrayPrototype);
      }
    } // WebKit bug - one more object in Uint8ClampedArray prototype chain


    if (NATIVE_ARRAY_BUFFER_VIEWS && objectGetPrototypeOf(Uint8ClampedArrayPrototype) !== TypedArrayPrototype) {
      objectSetPrototypeOf(Uint8ClampedArrayPrototype, TypedArrayPrototype);
    }

    if (descriptors && !hasOwnProperty_1(TypedArrayPrototype, TO_STRING_TAG)) {
      TYPED_ARRAY_TAG_REQUIRED = true;
      defineProperty(TypedArrayPrototype, TO_STRING_TAG, {
        get: function () {
          return isObject(this) ? this[TYPED_ARRAY_TAG] : undefined;
        }
      });

      for (NAME in TypedArrayConstructorsList) if (global$1[NAME]) {
        createNonEnumerableProperty(global$1[NAME], TYPED_ARRAY_TAG, NAME);
      }
    }

    var arrayBufferViewCore = {
      NATIVE_ARRAY_BUFFER_VIEWS: NATIVE_ARRAY_BUFFER_VIEWS,
      TYPED_ARRAY_CONSTRUCTOR: TYPED_ARRAY_CONSTRUCTOR,
      TYPED_ARRAY_TAG: TYPED_ARRAY_TAG_REQUIRED && TYPED_ARRAY_TAG,
      aTypedArray: aTypedArray$1,
      aTypedArrayConstructor: aTypedArrayConstructor,
      exportTypedArrayMethod: exportTypedArrayMethod$1,
      exportTypedArrayStaticMethod: exportTypedArrayStaticMethod,
      isView: isView,
      isTypedArray: isTypedArray,
      TypedArray: TypedArray,
      TypedArrayPrototype: TypedArrayPrototype
    };

    var RangeError$3 = global$1.RangeError;

    var toPositiveInteger = function (it) {
      var result = toIntegerOrInfinity(it);
      if (result < 0) throw RangeError$3("The argument can't be less than 0");
      return result;
    };

    var RangeError$2 = global$1.RangeError;

    var toOffset = function (it, BYTES) {
      var offset = toPositiveInteger(it);
      if (offset % BYTES) throw RangeError$2('Wrong offset');
      return offset;
    };

    var RangeError$1 = global$1.RangeError;
    var Int8Array = global$1.Int8Array;
    var Int8ArrayPrototype = Int8Array && Int8Array.prototype;
    var $set = Int8ArrayPrototype && Int8ArrayPrototype.set;
    var aTypedArray = arrayBufferViewCore.aTypedArray;
    var exportTypedArrayMethod = arrayBufferViewCore.exportTypedArrayMethod;
    var WORKS_WITH_OBJECTS_AND_GEERIC_ON_TYPED_ARRAYS = !fails(function () {
      // eslint-disable-next-line es-x/no-typed-arrays -- required for testing
      var array = new Uint8ClampedArray(2);
      functionCall($set, array, {
        length: 1,
        0: 3
      }, 1);
      return array[1] !== 3;
    }); // https://bugs.chromium.org/p/v8/issues/detail?id=11294 and other

    var TO_OBJECT_BUG = WORKS_WITH_OBJECTS_AND_GEERIC_ON_TYPED_ARRAYS && arrayBufferViewCore.NATIVE_ARRAY_BUFFER_VIEWS && fails(function () {
      var array = new Int8Array(2);
      array.set(1);
      array.set('2', 1);
      return array[0] !== 0 || array[1] !== 2;
    }); // `%TypedArray%.prototype.set` method
    // https://tc39.es/ecma262/#sec-%typedarray%.prototype.set

    exportTypedArrayMethod('set', function set(arrayLike
    /* , offset */
    ) {
      aTypedArray(this);
      var offset = toOffset(arguments.length > 1 ? arguments[1] : undefined, 1);
      var src = toObject(arrayLike);
      if (WORKS_WITH_OBJECTS_AND_GEERIC_ON_TYPED_ARRAYS) return functionCall($set, this, src, offset);
      var length = this.length;
      var len = lengthOfArrayLike(src);
      var index = 0;
      if (len + offset > length) throw RangeError$1('Wrong length');

      while (index < len) this[offset + index] = src[index++];
    }, !WORKS_WITH_OBJECTS_AND_GEERIC_ON_TYPED_ARRAYS || TO_OBJECT_BUG);

    /*
     * The MIT License (MIT)
     *
     * Copyright (c) 2016 University of California San Diego
     * Author: Jim Robinson
     *
     * Permission is hereby granted, free of charge, to any person obtaining a copy
     * of this software and associated documentation files (the "Software"), to deal
     * in the Software without restriction, including without limitation the rights
     * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
     * copies of the Software, and to permit persons to whom the Software is
     * furnished to do so, subject to the following conditions:
     *
     * The above copyright notice and this permission notice shall be included in
     * all copies or substantial portions of the Software.
     *
     *
     * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
     * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
     * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
     * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
     * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
     * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
     * THE SOFTWARE.
     */
    class PairedAlignment {
      constructor(firstAlignment) {
        this.paired = true;
        this.firstAlignment = firstAlignment;
        this.chr = firstAlignment.chr;
        this.readName = firstAlignment.readName;

        if (firstAlignment.start < firstAlignment.mate.position) {
          this.start = firstAlignment.start;
          this.scStart = firstAlignment.scStart;
          this.connectingStart = firstAlignment.start + firstAlignment.lengthOnRef;
          this.connectingEnd = firstAlignment.mate.position;
        } else {
          this.start = firstAlignment.mate.position;
          this.scStart = this.start;
          this.connectingStart = firstAlignment.mate.position;
          this.connectingEnd = firstAlignment.start;
        }

        this.end = Math.max(firstAlignment.mate.position, firstAlignment.start + firstAlignment.lengthOnRef); // Approximate

        this.lengthOnRef = this.end - this.start;
        let scEnd = Math.max(this.end, firstAlignment.scStart + firstAlignment.scLengthOnRef);
        this.scLengthOnRef = scEnd - this.scStart;
      }

      setSecondAlignment(secondAlignment) {
        // TODO -- check the chrs are equal,  error otherwise
        this.secondAlignment = secondAlignment;
        const firstAlignment = this.firstAlignment;

        if (secondAlignment.start > firstAlignment.start) {
          this.connectingEnd = secondAlignment.start;
        } else {
          this.connectingStart = secondAlignment.start + secondAlignment.lengthOnRef;
        }

        this.start = Math.min(firstAlignment.start, secondAlignment.start);
        this.end = Math.max(firstAlignment.start + firstAlignment.lengthOnRef, secondAlignment.start + secondAlignment.lengthOnRef);
        this.lengthOnRef = this.end - this.start;
        this.scStart = Math.min(firstAlignment.scStart, secondAlignment.scStart);
        const scEnd = Math.max(firstAlignment.scStart + firstAlignment.scLengthOnRef, secondAlignment.scStart + secondAlignment.scLengthOnRef);
        this.scLengthOnRef = scEnd - this.scStart;
      }

      containsLocation(genomicLocation, showSoftClips) {
        const s = showSoftClips ? this.scStart : this.start;
        const l = showSoftClips ? this.scLengthOnRef : this.lengthOnRef;
        return genomicLocation >= s && genomicLocation <= s + l;
      }

      alignmentContaining(genomicLocation, showSoftClips) {
        if (this.firstAlignment.containsLocation(genomicLocation, showSoftClips)) {
          return this.firstAlignment;
        } else if (this.secondAlignment && this.secondAlignment.containsLocation(genomicLocation, showSoftClips)) {
          return this.secondAlignment;
        } else {
          return undefined;
        }
      }

      popupData(genomicLocation) {
        let nameValues = this.firstAlignment.popupData(genomicLocation);

        if (this.secondAlignment) {
          nameValues.push("-------------------------------");
          nameValues = nameValues.concat(this.secondAlignment.popupData(genomicLocation));
        }

        return nameValues;
      }

      isPaired() {
        return true; // By definition
      }

      isMateMapped() {
        return true; // By definition
      }

      isProperPair() {
        return this.firstAlignment.isProperPair();
      }

      get fragmentLength() {
        return Math.abs(this.firstAlignment.fragmentLength);
      }

      firstOfPairStrand() {
        if (this.firstAlignment.isFirstOfPair()) {
          return this.firstAlignment.strand;
        } else if (this.secondAlignment && this.secondAlignment.isFirstOfPair()) {
          return this.secondAlignment.strand;
        } else {
          return this.firstAlignment.mate.strand; // Assumption is mate is first-of-pair
        }
      }

      hasTag(str) {
        return this.firstAlignment.hasTag(str) || this.secondAlignment && this.secondAlignment.hasTag(str);
      }

    }

    /*
     * The MIT License (MIT)
     *
     * Copyright (c) 2014 Broad Institute
     *
     * Permission is hereby granted, free of charge, to any person obtaining a copy
     * of this software and associated documentation files (the "Software"), to deal
     * in the Software without restriction, including without limitation the rights
     * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
     * copies of the Software, and to permit persons to whom the Software is
     * furnished to do so, subject to the following conditions:
     *
     * The above copyright notice and this permission notice shall be included in
     * all copies or substantial portions of the Software.
     *
     *
     * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
     * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
     * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
     * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
     * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
     * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
     * THE SOFTWARE.
     */
    const isString$2 = isString$3;
    const hashCode = hashCode$1;

    class BamAlignmentRow {
      constructor() {
        this.alignments = [];
        this.score = undefined;
      }

      findAlignment(genomicLocation) {
        const alignmentContains = (a, genomicLocation) => {
          return genomicLocation >= a.start && genomicLocation < a.start + a.lengthOnRef;
        }; // find single alignment that overlaps sort location


        let centerAlignment;

        for (let i = 0; i < this.alignments.length; i++) {
          const a = this.alignments[i];

          if (genomicLocation >= a.start && genomicLocation < a.start + a.lengthOnRef) {
            if (a.paired) {
              if (a.firstAlignment && alignmentContains(a.firstAlignment, genomicLocation)) {
                centerAlignment = a.firstAlignment;
              } else if (a.secondAlignment && alignmentContains(a.secondAlignment, genomicLocation)) {
                centerAlignment = a.secondAlignment;
              }
            } else {
              centerAlignment = a;
            }

            break;
          }
        }

        return centerAlignment;
      }

      updateScore(options, alignmentContainer) {
        this.score = this.calculateScore(options, alignmentContainer);
      }

      calculateScore(_ref, alignmentContainer) {
        let {
          position,
          option,
          direction,
          tag
        } = _ref;
        if (!option) option = "BASE";
        const alignment = this.findAlignment(position);

        if (undefined === alignment) {
          return Number.MAX_VALUE * (direction ? 1 : -1);
        }

        let mate;

        switch (option) {
          case "NUCLEOTIDE":
          case "BASE":
            {
              return calculateBaseScore(alignment, alignmentContainer, position);
            }

          case "STRAND":
            return alignment.strand ? 1 : -1;

          case "START":
            return alignment.start;

          case "TAG":
            {
              const tagValue = alignment.tags()[tag];

              if (tagValue !== undefined) {
                return isString$2(tagValue) ? hashCode(tagValue) : tagValue;
              } else {
                return Number.MAX_VALUE;
              }
            }

          case "READ_NAME":
            return hashCode(alignment.readName);

          case "INSERT_SIZE":
            return -Math.abs(alignment.fragmentLength);

          case "GAP_SIZE":
            return -alignment.gapSizeAt(position);

          case "MATE_CHR":
            mate = alignment.mate;

            if (!mate) {
              return Number.MAX_VALUE;
            } else {
              if (mate.chr === alignment.chr) {
                return Number.MAX_VALUE - 1;
              } else {
                return hashCode(mate.chr);
              }
            }

          case "MQ":
            return alignment.mq === undefined ? Number.MAX_VALUE : -alignment.mq;

          default:
            return Number.MAX_VALUE;
        }

        function calculateBaseScore(alignment, alignmentContainer, genomicLocation) {
          let reference;
          const idx = Math.floor(genomicLocation) - alignmentContainer.start;

          if (idx < alignmentContainer.sequence.length) {
            reference = alignmentContainer.sequence.charAt(idx);
          }

          if (!reference) {
            return 0;
          }

          const base = alignment.readBaseAt(genomicLocation);
          const quality = alignment.readBaseQualityAt(genomicLocation);
          const coverageMap = alignmentContainer.coverageMap;
          const coverageMapIndex = Math.floor(genomicLocation - coverageMap.bpStart);
          const coverage = coverageMap.coverage[coverageMapIndex]; // Insertions.  These are additive with base scores as they occur between bases, so you can have a
          // base mismatch AND an insertion

          let baseScore = 0;

          if (alignment.insertions) {
            for (let ins of alignment.insertions) {
              if (ins.start === genomicLocation) {
                baseScore = -coverage.ins;
              }
            }
          }

          if (!base) {
            // Either deletion or skipped (splice junction)
            const delCount = coverage.del;

            if (delCount > 0) {
              baseScore -= delCount;
            } else if (baseScore === 0) {
              // Don't modify insertion score, if any
              baseScore = 1;
            }
          } else {
            reference = reference.toUpperCase();

            if ('N' === base && baseScore === 0) {
              baseScore = 2;
            } else if ((reference === base || '=' === base) && baseScore === 0) {
              baseScore = 4 - quality / 1000;
            } else if ("X" === base || reference !== base) {
              const count = coverage["pos" + base] + coverage["neg" + base];
              baseScore -= count + quality / 1000;
            }
          }

          return baseScore;
        }
      }

    }

    function canBePaired(alignment) {
      return alignment.isPaired() && alignment.mate && alignment.isMateMapped() && alignment.chr === alignment.mate.chr && (alignment.isFirstOfPair() || alignment.isSecondOfPair()) && !(alignment.isSecondary() || alignment.isSupplementary());
    }

    function pairAlignments(rows) {
      const pairCache = {};
      const result = [];

      for (let row of rows) {
        for (let alignment of row.alignments) {
          if (canBePaired(alignment)) {
            let pairedAlignment = pairCache[alignment.readName];

            if (pairedAlignment) {
              pairedAlignment.setSecondAlignment(alignment);
              pairCache[alignment.readName] = undefined; // Don't need to track this anymore.
            } else {
              pairedAlignment = new PairedAlignment(alignment);
              pairCache[alignment.readName] = pairedAlignment;
              result.push(pairedAlignment);
            }
          } else {
            result.push(alignment);
          }
        }
      }

      return result;
    }

    function unpairAlignments(rows) {
      const result = [];

      for (let row of rows) {
        for (let alignment of row.alignments) {
          if (alignment instanceof PairedAlignment) {
            if (alignment.firstAlignment) result.push(alignment.firstAlignment); // shouldn't need the null test

            if (alignment.secondAlignment) result.push(alignment.secondAlignment);
          } else {
            result.push(alignment);
          }
        }
      }

      return result;
    }

    function packAlignmentRows(alignments, start, end, showSoftClips) {
      if (!alignments) {
        return undefined;
      } else if (alignments.length === 0) {
        return [];
      } else {
        alignments.sort(function (a, b) {
          return showSoftClips ? a.scStart - b.scStart : a.start - b.start;
        }); // bucketStart = Math.max(start, alignments[0].start);

        const firstAlignment = alignments[0];
        let bucketStart = Math.max(start, showSoftClips ? firstAlignment.scStart : firstAlignment.start);
        let nextStart = bucketStart;
        const bucketList = [];

        for (let alignment of alignments) {
          //var buckListIndex = Math.max(0, alignment.start - bucketStart);
          const s = showSoftClips ? alignment.scStart : alignment.start;
          const buckListIndex = Math.max(0, s - bucketStart);

          if (bucketList[buckListIndex] === undefined) {
            bucketList[buckListIndex] = [];
          }

          bucketList[buckListIndex].push(alignment);
        }

        let allocatedCount = 0;
        let lastAllocatedCount = 0;
        const packedAlignmentRows = [];
        const alignmentSpace = 2;

        try {
          while (allocatedCount < alignments.length) {
            const alignmentRow = new BamAlignmentRow();

            while (nextStart <= end) {
              let bucket = undefined;
              let index;

              while (!bucket && nextStart <= end) {
                index = nextStart - bucketStart;

                if (bucketList[index] === undefined) {
                  ++nextStart; // No alignments at this index
                } else {
                  bucket = bucketList[index];
                }
              } // while (bucket)


              if (!bucket) {
                break;
              }

              const alignment = bucket.pop();

              if (0 === bucket.length) {
                bucketList[index] = undefined;
              }

              alignmentRow.alignments.push(alignment);
              nextStart = showSoftClips ? alignment.scStart + alignment.scLengthOnRef + alignmentSpace : alignment.start + alignment.lengthOnRef + alignmentSpace;
              ++allocatedCount;
            } // while (nextStart)


            if (alignmentRow.alignments.length > 0) {
              packedAlignmentRows.push(alignmentRow);
            }

            nextStart = bucketStart;
            if (allocatedCount === lastAllocatedCount) break; // Protect from infinite loops

            lastAllocatedCount = allocatedCount;
          } // while (allocatedCount)

        } catch (e) {
          console.error(e);
          throw e;
        }

        return packedAlignmentRows;
      }
    }

    /*
     * The MIT License (MIT)
     *
     * Copyright (c) 2016 University of California San Diego
     * Author: Jim Robinson
     *
     * Permission is hereby granted, free of charge, to any person obtaining a copy
     * of this software and associated documentation files (the "Software"), to deal
     * in the Software without restriction, including without limitation the rights
     * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
     * copies of the Software, and to permit persons to whom the Software is
     * furnished to do so, subject to the following conditions:
     *
     * The above copyright notice and this permission notice shall be included in
     * all copies or substantial portions of the Software.
     *
     *
     * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
     * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
     * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
     * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
     * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
     * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
     * THE SOFTWARE.
     */

    class AlignmentContainer {
      //            this.config.samplingWindowSize, this.config.samplingDepth,
      //             this.config.pairsSupported, this.config.alleleFreqThreshold)
      constructor(chr, start, end, _ref) {
        let {
          samplingWindowSize,
          samplingDepth,
          pairsSupported,
          alleleFreqThreshold
        } = _ref;
        this.chr = chr;
        this.start = Math.floor(start);
        this.end = Math.ceil(end);
        this.length = end - start;
        this.alleleFreqThreshold = alleleFreqThreshold === undefined ? 0.2 : alleleFreqThreshold;
        this.coverageMap = new CoverageMap(chr, start, end, this.alleleFreqThreshold);
        this.alignments = [];
        this.downsampledIntervals = [];
        this.samplingWindowSize = samplingWindowSize === undefined ? 100 : samplingWindowSize;
        this.samplingDepth = samplingDepth === undefined ? 1000 : samplingDepth;
        this.pairsSupported = pairsSupported === undefined ? true : pairsSupported;
        this.paired = false; // false until proven otherwise

        this.pairsCache = {}; // working cache of paired alignments by read name

        this.downsampledReads = new Set();
        this.currentBucket = new DownsampleBucket(this.start, this.start + this.samplingWindowSize, this);

        this.filter = function filter(alignment) {
          // TODO -- pass this in
          return alignment.isMapped() && !alignment.isFailsVendorQualityCheck();
        };
      }

      push(alignment) {
        if (this.filter(alignment) === false) return;
        this.coverageMap.incCounts(alignment); // Count coverage before any downsampling

        if (this.pairsSupported && this.downsampledReads.has(alignment.readName)) {
          return; // Mate already downsampled -- pairs are treated as a single alignment for downsampling
        }

        if (alignment.start >= this.currentBucket.end) {
          this.finishBucket();
          this.currentBucket = new DownsampleBucket(alignment.start, alignment.start + this.samplingWindowSize, this);
        }

        this.currentBucket.addAlignment(alignment);
      }

      forEach(callback) {
        this.alignments.forEach(callback);
      }

      finish() {
        if (this.currentBucket !== undefined) {
          this.finishBucket();
        }

        this.alignments.sort(function (a, b) {
          return a.start - b.start;
        });
        this.pairsCache = undefined;
        this.downsampledReads = undefined;
      }

      contains(chr, start, end) {
        return this.chr === chr && this.start <= start && this.end >= end;
      }

      hasDownsampledIntervals() {
        return this.downsampledIntervals && this.downsampledIntervals.length > 0;
      }

      finishBucket() {
        this.alignments = this.alignments.concat(this.currentBucket.alignments);

        if (this.currentBucket.downsampledCount > 0) {
          this.downsampledIntervals.push(new DownsampledInterval(this.currentBucket.start, this.currentBucket.end, this.currentBucket.downsampledCount));
        }

        this.paired = this.paired || this.currentBucket.paired;
      }

      setViewAsPairs(bool) {
        let alignments;

        if (bool) {
          alignments = pairAlignments(this.packedAlignmentRows);
        } else {
          alignments = unpairAlignments(this.packedAlignmentRows);
        }

        this.packedAlignmentRows = packAlignmentRows(alignments, this.start, this.end);
      }

      setShowSoftClips(bool) {
        const alignments = this.allAlignments();
        this.packedAlignmentRows = packAlignmentRows(alignments, this.start, this.end, bool);
      }

      repack(bpPerPixel, showSoftClips) {
        const alignments = this.allAlignments();
        this.packedAlignmentRows = packAlignmentRows(alignments, this.start, this.end, showSoftClips);
      }

      allAlignments() {
        const alignments = [];

        for (let row of this.packedAlignmentRows) {
          for (let alignment of row.alignments) {
            alignments.push(alignment);
          }
        }

        return alignments;
      }

      getMax(start, end) {
        return this.coverageMap.getMax(start, end);
      }

    }

    class DownsampleBucket {
      constructor(start, end, alignmentContainer) {
        this.start = start;
        this.end = end;
        this.alignments = [];
        this.downsampledCount = 0;
        this.samplingDepth = alignmentContainer.samplingDepth;
        this.pairsSupported = alignmentContainer.pairsSupported;
        this.downsampledReads = alignmentContainer.downsampledReads;
        this.pairsCache = alignmentContainer.pairsCache;
      }

      addAlignment(alignment) {
        var idx, replacedAlignment, pairedAlignment;

        if (this.pairsSupported && canBePaired(alignment)) {
          pairedAlignment = this.pairsCache[alignment.readName];

          if (pairedAlignment) {
            // Not subject to downsampling, just update the existing alignment
            pairedAlignment.setSecondAlignment(alignment);
            this.pairsCache[alignment.readName] = undefined; // Don't need to track this anymore. NOTE: Don't "delete", causes runtime performance issues

            return;
          }
        }

        if (this.alignments.length < this.samplingDepth) {
          if (this.pairsSupported && canBePaired(alignment)) {
            // First alignment in a pair
            pairedAlignment = new PairedAlignment(alignment);
            this.paired = true;
            this.pairsCache[alignment.readName] = pairedAlignment;
            this.alignments.push(pairedAlignment);
          } else {
            this.alignments.push(alignment);
          }
        } else {
          idx = Math.floor(Math.random() * (this.samplingDepth + this.downsampledCount - 1));

          if (idx < this.samplingDepth) {
            // Keep the new item
            //  idx = Math.floor(Math.random() * (this.alignments.length - 1));
            replacedAlignment = this.alignments[idx]; // To be replaced

            if (this.pairsSupported && canBePaired(alignment)) {
              if (this.pairsCache[replacedAlignment.readName] !== undefined) {
                this.pairsCache[replacedAlignment.readName] = undefined;
              }

              pairedAlignment = new PairedAlignment(alignment);
              this.paired = true;
              this.pairsCache[alignment.readName] = pairedAlignment;
              this.alignments[idx] = pairedAlignment;
            } else {
              this.alignments[idx] = alignment;
            }

            this.downsampledReads.add(replacedAlignment.readName);
          } else {
            this.downsampledReads.add(alignment.readName);
          }

          this.downsampledCount++;
        }
      }

    }

    class CoverageMap {
      constructor(chr, start, end, alleleFreqThreshold) {
        this.chr = chr;
        this.bpStart = start;
        this.length = end - start;
        this.coverage = new Array(this.length);
        this.maximum = 0;
        this.threshold = alleleFreqThreshold;
        this.qualityWeight = true;
      }
      /**
       * Return the maximum coverage value between start and end.  This is used for autoscaling.
       * @param start
       * @param end
       */


      getMax(start, end) {
        let max = 0;
        const len = this.coverage.length;

        for (let i = 0; i < len; i++) {
          const pos = this.bpStart + i;
          if (pos > end) break;
          const cov = this.coverage[i];

          if (pos >= start && cov) {
            max = Math.max(max, cov.total);
          }
        }

        return max;
      }

      incCounts(alignment) {
        var self = this;

        if (alignment.blocks === undefined) {
          incBlockCount(alignment);
        } else {
          alignment.blocks.forEach(function (block) {
            incBlockCount(block);
          });
        }

        if (alignment.gaps) {
          for (let del of alignment.gaps) {
            if (del.type === 'D') {
              const offset = del.start - self.bpStart;

              for (let i = offset; i < offset + del.len; i++) {
                if (i < 0) continue;

                if (!this.coverage[i]) {
                  this.coverage[i] = new Coverage(self.threshold);
                }

                this.coverage[i].del++;
              }
            }
          }
        }

        if (alignment.insertions) {
          for (let del of alignment.insertions) {
            const i = del.start - this.bpStart;
            if (i < 0) continue;

            if (!this.coverage[i]) {
              this.coverage[i] = new Coverage(self.threshold);
            }

            this.coverage[i].ins++;
          }
        }

        function incBlockCount(block) {
          if ('S' === block.type) return;
          const seq = alignment.seq;
          const qual = alignment.qual;
          const seqOffset = block.seqOffset;

          for (let i = block.start - self.bpStart, j = 0; j < block.len; i++, j++) {
            if (!self.coverage[i]) {
              self.coverage[i] = new Coverage(self.threshold);
            }

            const base = seq == undefined ? "N" : seq.charAt(seqOffset + j);
            const key = alignment.strand ? "pos" + base : "neg" + base;
            const q = qual && seqOffset + j < qual.length ? qual[seqOffset + j] : 30;
            self.coverage[i][key] += 1;
            self.coverage[i]["qual" + base] += q;
            self.coverage[i].total += 1;
            self.coverage[i].qual += q;
            self.maximum = Math.max(self.coverage[i].total, self.maximum);
          }
        }
      }

    }

    class Coverage {
      constructor(alleleThreshold) {
        this.qualityWeight = true;
        this.posA = 0;
        this.negA = 0;
        this.posT = 0;
        this.negT = 0;
        this.posC = 0;
        this.negC = 0;
        this.posG = 0;
        this.negG = 0;
        this.posN = 0;
        this.negN = 0;
        this.pos = 0;
        this.neg = 0;
        this.qualA = 0;
        this.qualT = 0;
        this.qualC = 0;
        this.qualG = 0;
        this.qualN = 0;
        this.qual = 0;
        this.total = 0;
        this.del = 0;
        this.ins = 0;
        this.threshold = alleleThreshold;
      }

      isMismatch(refBase) {
        const threshold = this.threshold * (this.qualityWeight && this.qual ? this.qual : this.total);
        let mismatchQualitySum = 0;

        for (let base of ["A", "T", "C", "G"]) {
          if (base !== refBase) {
            mismatchQualitySum += this.qualityWeight && this.qual ? this["qual" + base] : this["pos" + base] + this["neg" + base];
          }
        }

        return mismatchQualitySum >= threshold;
      }

    }

    class DownsampledInterval {
      constructor(start, end, counts) {
        this.start = start;
        this.end = end;
        this.counts = counts;
      }

      popupData(genomicLocation) {
        return [{
          name: "start",
          value: this.start + 1
        }, {
          name: "end",
          value: this.end
        }, {
          name: "# downsampled:",
          value: this.counts
        }];
      }

    }

    class SupplementaryAlignment {
      constructor(rec) {
        const tokens = rec.split(',');
        this.chr = tokens[0];
        this.start = parseInt(tokens[1]);
        this.strand = tokens[2].charAt(0);
        this.mapQ = parseInt(tokens[4]);
        this.numMismatches = parseInt(tokens[5]);
        this.lenOnRef = BamUtils.computeLengthOnReference(tokens[3]);
      }

      printString() {
        return this.chr + ":" + numberFormatter$1(this.start) + "-" + numberFormatter$1(this.start + this.lenOnRef) + " (" + this.strand + ") = " + numberFormatter$1(this.lenOnRef) + "bp @MAPQ: " + this.mapQ + " NM: " + this.numMismatches;
      }

    }

    function createSupplementaryAlignments(str) {
      const tokens = str.split(';');
      return tokens.filter(t => t.length > 0).map(str => new SupplementaryAlignment(str));
    }

    /*
     * The MIT License (MIT)
     *
     * Copyright (c) 2014 Broad Institute
     *
     * Permission is hereby granted, free of charge, to any person obtaining a copy
     * of this software and associated documentation files (the "Software"), to deal
     * in the Software without restriction, including without limitation the rights
     * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
     * copies of the Software, and to permit persons to whom the Software is
     * furnished to do so, subject to the following conditions:
     *
     * The above copyright notice and this permission notice shall be included in
     * all copies or substantial portions of the Software.
     *
     *
     * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
     * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
     * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
     * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
     * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
     * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
     * THE SOFTWARE.
     */
    const READ_PAIRED_FLAG = 0x1;
    const PROPER_PAIR_FLAG = 0x2;
    const READ_UNMAPPED_FLAG = 0x4;
    const MATE_UNMAPPED_FLAG = 0x8;
    const READ_STRAND_FLAG$2 = 0x10;
    const MATE_STRAND_FLAG$2 = 0x20;
    const FIRST_OF_PAIR_FLAG = 0x40;
    const SECOND_OF_PAIR_FLAG = 0x80;
    const SECONDARY_ALIGNMNET_FLAG = 0x100;
    const READ_FAILS_VENDOR_QUALITY_CHECK_FLAG = 0x200;
    const DUPLICATE_READ_FLAG = 0x400;
    const SUPPLEMENTARY_ALIGNMENT_FLAG = 0x800;
    const ELEMENT_SIZE = {
      c: 1,
      C: 1,
      s: 2,
      S: 2,
      i: 4,
      I: 4,
      f: 4
    };
    const MAX_CIGAR = 50;
    /**
     * readName
     * chr
     * cigar
     * lengthOnRef
     * start
     * seq
     * qual
     * mq
     * strand
     * blocks
     */

    class BamAlignment {
      constructor() {
        this.hidden = false;
      }

      isMapped() {
        return (this.flags & READ_UNMAPPED_FLAG) === 0;
      }

      isPaired() {
        return (this.flags & READ_PAIRED_FLAG) !== 0;
      }

      isProperPair() {
        return (this.flags & PROPER_PAIR_FLAG) !== 0;
      }

      isFirstOfPair() {
        return (this.flags & FIRST_OF_PAIR_FLAG) !== 0;
      }

      isSecondOfPair() {
        return (this.flags & SECOND_OF_PAIR_FLAG) !== 0;
      }

      isSecondary() {
        return (this.flags & SECONDARY_ALIGNMNET_FLAG) !== 0;
      }

      isSupplementary() {
        return (this.flags & SUPPLEMENTARY_ALIGNMENT_FLAG) !== 0;
      }

      isFailsVendorQualityCheck() {
        return (this.flags & READ_FAILS_VENDOR_QUALITY_CHECK_FLAG) !== 0;
      }

      isDuplicate() {
        return (this.flags & DUPLICATE_READ_FLAG) !== 0;
      }

      isMateMapped() {
        return (this.flags & MATE_UNMAPPED_FLAG) === 0;
      }

      isNegativeStrand() {
        return (this.flags & READ_STRAND_FLAG$2) !== 0;
      }

      isMateNegativeStrand() {
        return (this.flags & MATE_STRAND_FLAG$2) !== 0;
      }

      hasTag(tag) {
        const tmpTags = this.tagDict || decodeTags(this.tagBA);
        return tmpTags.hasOwnProperty(tag);
      }

      tags() {
        if (!this.tagDict) {
          if (this.tagBA) {
            this.tagDict = decodeTags(this.tagBA);
            this.tagBA = undefined;
          } else {
            this.tagDict = {}; // Mark so we don't try again.  The record has no tags
          }
        }

        return this.tagDict;
      }
      /**
       * Does alignment (or alignment extended by soft clips) contain the genomic location?
       *
       * @param genomicLocation
       * @param showSoftClips
       * @returns {boolean|boolean}
       */


      containsLocation(genomicLocation, showSoftClips) {
        const s = showSoftClips ? this.scStart : this.start;
        const l = showSoftClips ? this.scLengthOnRef : this.lengthOnRef;
        return genomicLocation >= s && genomicLocation <= s + l;
      }

      popupData(genomicLocation) {
        // if the user clicks on a base next to an insertion, show just the
        // inserted bases in a popup (like in desktop IGV).
        const nameValues = []; // Consert genomic location to int

        genomicLocation = Math.floor(genomicLocation);

        if (this.insertions) {
          const seq = this.seq;

          for (let insertion of this.insertions) {
            var ins_start = insertion.start;

            if (genomicLocation === ins_start || genomicLocation === ins_start - 1) {
              nameValues.push({
                name: 'Insertion',
                value: seq.substr(insertion.seqOffset, insertion.len)
              });
              nameValues.push({
                name: 'Location',
                value: ins_start
              });
              return nameValues;
            }
          }
        }

        nameValues.push({
          name: 'Read Name',
          value: this.readName
        }); // Sample
        // Read group

        nameValues.push('<hr/>'); // Add 1 to genomic location to map from 0-based computer units to user-based units

        nameValues.push({
          name: 'Alignment Start',
          value: numberFormatter$1(1 + this.start),
          borderTop: true
        });
        nameValues.push({
          name: 'Read Strand',
          value: true === this.strand ? '(+)' : '(-)',
          borderTop: true
        }); // Abbreviate long cigar strings, keeping the beginning and end to show cliping

        let cigar = this.cigar;

        if (cigar && cigar.length > MAX_CIGAR) {
          const half = MAX_CIGAR / 2;
          cigar = `${cigar.substring(0, half - 2)} ... ${cigar.substring(cigar.length - half + 2)}`;
        }

        nameValues.push({
          name: 'Cigar',
          value: cigar
        });
        nameValues.push({
          name: 'Mapping Quality',
          value: this.mq
        });
        nameValues.push({
          name: 'Secondary',
          value: yesNo(this.isSecondary())
        });
        nameValues.push({
          name: 'Supplementary',
          value: yesNo(this.isSupplementary())
        });
        nameValues.push({
          name: 'Duplicate',
          value: yesNo(this.isDuplicate())
        });
        nameValues.push({
          name: 'Failed QC',
          value: yesNo(this.isFailsVendorQualityCheck())
        });

        if (this.isPaired()) {
          nameValues.push('<hr/>');
          nameValues.push({
            name: 'First in Pair',
            value: !this.isSecondOfPair(),
            borderTop: true
          });
          nameValues.push({
            name: 'Mate is Mapped',
            value: yesNo(this.isMateMapped())
          });

          if (this.pairOrientation) {
            nameValues.push({
              name: 'Pair Orientation',
              value: this.pairOrientation
            });
          }

          if (this.isMateMapped()) {
            nameValues.push({
              name: 'Mate Chromosome',
              value: this.mate.chr
            });
            nameValues.push({
              name: 'Mate Start',
              value: this.mate.position + 1
            });
            nameValues.push({
              name: 'Mate Strand',
              value: true === this.mate.strand ? '(+)' : '(-)'
            });
            nameValues.push({
              name: 'Insert Size',
              value: this.fragmentLength
            }); // Mate Start
            // Mate Strand
            // Insert Size
          } // First in Pair
          // Pair Orientation

        }

        const tagDict = this.tags();

        if (tagDict.hasOwnProperty('SA')) {
          nameValues.push('<hr/>');
          nameValues.push({
            name: 'Supplementary Alignments',
            value: ''
          });
          const sa = createSupplementaryAlignments(tagDict['SA']);

          if (sa) {
            nameValues.push('<ul>');

            for (let s of sa) {
              nameValues.push(`<li>${s.printString()}</li>`);
            }

            nameValues.push('</ul>');
          }
        }

        const hiddenTags = new Set(['SA', 'MD']);
        nameValues.push('<hr/>');

        for (let key in tagDict) {
          if (!hiddenTags.has(key)) {
            nameValues.push({
              name: key,
              value: tagDict[key]
            });
          }
        }

        nameValues.push({
          name: 'Hidden Tags',
          value: 'SA, MD'
        });
        nameValues.push('<hr/>');
        nameValues.push({
          name: 'Genomic Location: ',
          value: numberFormatter$1(1 + genomicLocation)
        });
        nameValues.push({
          name: 'Read Base:',
          value: this.readBaseAt(genomicLocation)
        });
        nameValues.push({
          name: 'Base Quality:',
          value: this.readBaseQualityAt(genomicLocation)
        });
        return nameValues;

        function yesNo(bool) {
          return bool ? 'Yes' : 'No';
        }
      }

      readBaseAt(genomicLocation) {
        const block = blockAtGenomicLocation(this.blocks, genomicLocation);

        if (block) {
          if ("*" === this.seq) {
            return "*";
          } else {
            const idx = block.seqIndexAt(genomicLocation); // if (idx >= 0 && idx < this.seq.length) {

            return this.seq[idx]; //  }
          }
        } else {
          return undefined;
        }
      }

      readBaseQualityAt(genomicLocation) {
        const block = blockAtGenomicLocation(this.blocks, genomicLocation);

        if (block) {
          if ("*" === this.qual) {
            return 30;
          } else {
            const idx = block.seqIndexAt(genomicLocation);

            if (idx >= 0 && this.qual && idx < this.qual.length) {
              return this.qual[idx];
            } else {
              return 30;
            }
          }
        } else {
          return undefined;
        }
      }

      gapSizeAt(genomicLocation) {
        if (this.gaps) {
          for (let gap of this.gaps) {
            if (genomicLocation >= gap.start && genomicLocation < gap.start + gap.len) {
              return gap.len;
            }
          }
        }

        return 0;
      }

    }

    function blockAtGenomicLocation(blocks, genomicLocation) {
      for (let i = 0; i < blocks.length; i++) {
        const block = blocks[i];

        if (genomicLocation >= block.start && genomicLocation < block.start + block.len) {
          return block;
        }
      }

      return undefined;
    }

    function decodeTags(ba) {
      let p = 0;
      const len = ba.length;
      const tags = {};

      while (p < len) {
        const tag = String.fromCharCode(ba[p]) + String.fromCharCode(ba[p + 1]);
        p += 2;
        const type = String.fromCharCode(ba[p++]);
        let value;

        if (type === 'A') {
          value = String.fromCharCode(ba[p]);
          p++;
        } else if (type === 'i' || type === 'I') {
          value = readInt$1(ba, p);
          p += 4;
        } else if (type === 'c') {
          value = readInt8(ba, p);
          p++;
        } else if (type === 'C') {
          value = readUInt8(ba, p);
          p++;
        } else if (type === 's' || type === 'S') {
          value = readShort(ba, p);
          p += 2;
        } else if (type === 'f') {
          value = readFloat(ba, p);
          p += 4;
        } else if (type === 'Z') {
          value = '';

          for (;;) {
            var cc = ba[p++];

            if (cc === 0) {
              break;
            } else {
              value += String.fromCharCode(cc);
            }
          }
        } else if (type === 'B') {
          const elementType = String.fromCharCode(ba[p++]);
          let elementSize = ELEMENT_SIZE[elementType];

          if (elementSize === undefined) {
            tags[tag] = `Error: unknown element type '${elementType}'`;
            break;
          }

          const numElements = readInt$1(ba, p);
          p += 4 + numElements * elementSize;
          value = '[not shown]';
        } else {
          //'Unknown type ' + type;
          value = 'Error unknown type: ' + type;
          tags[tag] = value;
          break;
        }

        tags[tag] = value;
      }

      return tags;
    }

    function readInt$1(ba, offset) {
      return ba[offset + 3] << 24 | ba[offset + 2] << 16 | ba[offset + 1] << 8 | ba[offset];
    }

    function readShort(ba, offset) {
      return ba[offset + 1] << 8 | ba[offset];
    }

    function readFloat(ba, offset) {
      const dataView = new DataView(ba.buffer);
      return dataView.getFloat32(offset);
    }

    function readInt8(ba, offset) {
      const dataView = new DataView(ba.buffer);
      return dataView.getInt8(offset);
    }

    function readUInt8(ba, offset) {
      const dataView = new DataView(ba.buffer);
      return dataView.getUint8(offset);
    }

    /*
     * The MIT License (MIT)
     *
     * Copyright (c) 2016-2017 The Regents of the University of California
     * Author: Jim Robinson
     *
     * Permission is hereby granted, free of charge, to any person obtaining a copy
     * of this software and associated documentation files (the "Software"), to deal
     * in the Software without restriction, including without limitation the rights
     * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
     * copies of the Software, and to permit persons to whom the Software is
     * furnished to do so, subject to the following conditions:
     *
     * The above copyright notice and this permission notice shall be included in
     * all copies or substantial portions of the Software.
     *
     *
     * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
     * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
     * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
     * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
     * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
     * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
     * THE SOFTWARE.
     */

    /**
     * Created by jrobinso on 4/5/18.
     */
    class AlignmentBlock {
      constructor(b) {
        if (b) {
          Object.assign(this, b);
        }
      }

      seqIndexAt(genomicLocation) {
        return Math.floor(genomicLocation) - this.start + this.seqOffset;
      }

    }

    class BamFilter {
      constructor(options) {
        if (!options) options = {};
        this.vendorFailed = options.vendorFailed === undefined ? true : options.vendorFailed;
        this.duplicates = options.duplicates === undefined ? true : options.duplicates;
        this.secondary = options.secondary || false;
        this.supplementary = options.supplementary || false;
        this.mqThreshold = options.mqThreshold === undefined ? 0 : options.mqThreshold;

        if (options.readgroups) {
          this.readgroups = new Set(options.readgroups);
        }
      }

      pass(alignment) {
        if (this.vendorFailed && alignment.isFailsVendorQualityCheck()) return false;
        if (this.duplicates && alignment.isDuplicate()) return false;
        if (this.secondary && alignment.isSecondary()) return false;
        if (this.supplementary && alignment.isSupplementary()) return false;
        if (alignment.mq < this.mqThreshold) return false;

        if (this.readgroups) {
          var rg = alignment.tags()['RG'];
          return this.readgroups.has(rg);
        }

        return true;
      }

    }

    /**
     * This code is based on the Biodalliance BAM reader by Thomas Down,  2011
     *
     * https://github.com/dasmoth/dalliance/blob/master/js/bam.js
     */

    const SEQ_DECODER = ['=', 'A', 'C', 'x', 'G', 'x', 'x', 'x', 'T', 'x', 'x', 'x', 'x', 'x', 'x', 'N'];
    const CIGAR_DECODER = ['M', 'I', 'D', 'N', 'S', 'H', 'P', '=', 'X', '?', '?', '?', '?', '?', '?', '?'];
    const READ_STRAND_FLAG$1 = 0x10;
    const MATE_STRAND_FLAG$1 = 0x20;
    const BAM1_MAGIC_BYTES = new Uint8Array([0x42, 0x41, 0x4d, 0x01]); // BAM\1

    const BAM1_MAGIC_NUMBER = readInt(BAM1_MAGIC_BYTES, 0);
    const DEFAULT_ALLELE_FREQ_THRESHOLD = 0.2;
    const DEFAULT_SAMPLING_WINDOW_SIZE = 100;
    const DEFAULT_SAMPLING_DEPTH = 500;
    const MAXIMUM_SAMPLING_DEPTH = 10000;
    const BamUtils = {
      readHeader: function (url, options, genome) {
        return igvxhr.loadArrayBuffer(url, options).then(function (compressedBuffer) {
          var header, unc, uncba;
          unc = unbgzf(compressedBuffer);
          uncba = unc;
          header = BamUtils.decodeBamHeader(uncba, genome);
          return header;
        });
      },

      /**
       *
       * @param ba  bytes to decode as a UInt8Array
       * @param genome  optional igv genome object
       * @returns {{ magicNumer: number, size: number, chrNames: Array, chrToIndex: ({}|*), chrAliasTable: ({}|*) }}
       */
      decodeBamHeader: function (ba, genome) {
        var magic, samHeaderLen, samHeader, chrToIndex, chrNames, chrAliasTable, alias;
        magic = readInt(ba, 0);

        if (magic !== BAM1_MAGIC_NUMBER) {
          throw new Error('BAM header errror: bad magic number.  This could be caused by either a corrupt or missing file.');
        }

        samHeaderLen = readInt(ba, 4);
        samHeader = '';

        for (var i = 0; i < samHeaderLen; ++i) {
          samHeader += String.fromCharCode(ba[i + 8]);
        }

        var nRef = readInt(ba, samHeaderLen + 8);
        var p = samHeaderLen + 12;
        chrToIndex = {};
        chrNames = [];
        chrAliasTable = {};

        for (i = 0; i < nRef; ++i) {
          var lName = readInt(ba, p);
          var name = '';

          for (var j = 0; j < lName - 1; ++j) {
            name += String.fromCharCode(ba[p + 4 + j]);
          }

          readInt(ba, p + lName + 4); //dlog(name + ': ' + lRef);

          chrToIndex[name] = i;
          chrNames[i] = name;

          if (genome) {
            alias = genome.getChromosomeName(name);
            chrAliasTable[alias] = name;
          }

          p = p + 8 + lName;
        }

        return {
          magicNumber: magic,
          size: p,
          chrNames: chrNames,
          chrToIndex: chrToIndex,
          chrAliasTable: chrAliasTable
        };
      },
      bam_tag2cigar: function (ba, block_end, seq_offset, lseq, al, cigarArray) {
        function type2size(x) {
          if (x === 'C' || x === 'c' || x === 'A') return 1;else if (x === 'S' || x === 's') return 2;else if (x === 'I' || x === 'i' || x === 'f') return 4;else return 0;
        } // test if the real CIGAR is encoded in a CG:B,I tag


        if (cigarArray.length !== 1 || al.start < 0) return false;
        var p = seq_offset + (lseq + 1 >> 1) + lseq;

        while (p + 4 < block_end) {
          var tag = String.fromCharCode(ba[p]) + String.fromCharCode(ba[p + 1]);
          if (tag === 'CG') break;
          var type = String.fromCharCode(ba[p + 2]);

          if (type === 'B') {
            // the binary array type
            type = String.fromCharCode(ba[p + 3]);
            var size = type2size(type);
            var len = readInt(ba, p + 4);
            p += 8 + size * len;
          } else if (type === 'Z' || type === 'H') {
            // 0-terminated string
            p += 3;

            while (ba[p++] !== 0) {}
          } else {
            // other atomic types
            p += 3 + type2size(type);
          }
        }

        if (p >= block_end) return false; // no CG tag

        if (String.fromCharCode(ba[p + 2]) !== 'B' || String.fromCharCode(ba[p + 3]) !== 'I') return false; // not of type B,I
        // now we know the real CIGAR length and its offset in the binary array

        var cigar_len = readInt(ba, p + 4);
        var cigar_offset = p + 8; // 4 for "CGBI" and 4 for length

        if (cigar_offset + cigar_len * 4 > block_end) return false; // out of bound
        // decode CIGAR

        var cigar = '';
        var lengthOnRef = 0;
        cigarArray.length = 0; // empty the old array

        p = cigar_offset;

        for (var k = 0; k < cigar_len; ++k, p += 4) {
          var cigop = readInt(ba, p);
          var opLen = cigop >> 4;
          var opLtr = CIGAR_DECODER[cigop & 0xf];
          if (opLtr === 'M' || opLtr === 'EQ' || opLtr === 'X' || opLtr === 'D' || opLtr === 'N' || opLtr === '=') lengthOnRef += opLen;
          cigar = cigar + opLen + opLtr;
          cigarArray.push({
            len: opLen,
            ltr: opLtr
          });
        } // update alignment record. We are not updating bin, as apparently it is not used.


        al.cigar = cigar;
        al.lengthOnRef = lengthOnRef;
        return true;
      },

      /**
       *
       * @param ba                 bytes to decode as an UInt8Array
       * @param offset             offset position of ba array to start decoding
       * @param alignmentContainer container to receive the decoded alignments
       * @param min                minimum genomic position
       * @param max                maximum genomic position
       * @param chrIdx             chromosome index
       * @param chrNames            array of chromosome names
       * @param filter             a BamFilter object
       *
       * @return true if we have moved beyond the right end of the genomic range.
       */
      decodeBamRecords: function (ba, offset, alignmentContainer, chrNames, chrIdx, min, max, filter) {
        while (offset < ba.length) {
          const blockSize = readInt(ba, offset);
          const blockEnd = offset + blockSize + 4;
          const alignment = new BamAlignment();
          const refID = readInt(ba, offset + 4);
          const pos = readInt(ba, offset + 8);

          if (blockEnd > ba.length) {
            return;
          }

          if (refID < 0) {
            offset = blockEnd;
            continue; // unmapped read
          } else if (chrIdx !== undefined && (refID > chrIdx || pos > max)) {
            return true; // off right edge, we're done
          } else if (chrIdx !== undefined && refID < chrIdx) {
            offset = blockEnd;
            continue; // ref ID to left of start, not sure this is possible
          }

          const bin_mq_nl = readInt(ba, offset + 12);
          const mq = (bin_mq_nl & 0xff00) >> 8;
          const nl = bin_mq_nl & 0xff;
          const flag_nc = readInt(ba, offset + 16);
          const flag = (flag_nc & 0xffff0000) >> 16;
          const nc = flag_nc & 0xffff;
          const lseq = readInt(ba, offset + 20);
          const mateChrIdx = readInt(ba, offset + 24);
          const matePos = readInt(ba, offset + 28);
          const fragmentLength = readInt(ba, offset + 32);
          let readName = [];

          for (let j = 0; j < nl - 1; ++j) {
            readName.push(String.fromCharCode(ba[offset + 36 + j]));
          }

          readName = readName.join('');
          let lengthOnRef = 0;
          let cigar = '';
          let p = offset + 36 + nl;
          const cigarArray = []; // concatenate M,=,EQ,and X

          let lastCigRecord;

          for (let c = 0; c < nc; ++c) {
            var cigop = readInt(ba, p);
            var opLen = cigop >> 4;
            var opLtr = CIGAR_DECODER[cigop & 0xf];
            if (opLtr === 'M' || opLtr === 'EQ' || opLtr === 'X' || opLtr === 'D' || opLtr === 'N' || opLtr === '=') lengthOnRef += opLen;
            cigar = cigar + opLen + opLtr;
            p += 4; // if(mOperators.has(opLtr) && mOperators.has(lastCigRecord.ltr)) {
            //     lastCigRecord.len += opLen;
            //     lastCigRecord.ltr = 'M'
            // }
            // else {

            lastCigRecord = {
              len: opLen,
              ltr: opLtr
            };
            cigarArray.push(lastCigRecord); //}
          }

          alignment.chr = chrNames[refID];
          alignment.start = pos;
          alignment.flags = flag;
          alignment.strand = !(flag & READ_STRAND_FLAG$1);
          alignment.readName = readName;
          alignment.cigar = cigar;
          alignment.lengthOnRef = lengthOnRef;
          alignment.fragmentLength = fragmentLength;
          alignment.mq = mq;
          BamUtils.bam_tag2cigar(ba, blockEnd, p, lseq, alignment, cigarArray);
          alignment.end = alignment.start + alignment.lengthOnRef;

          if (alignment.end < min) {
            offset = blockEnd;
            continue;
          } // Record out-of-range "to the left", skip to next one


          let seq = [];
          const seqBytes = lseq + 1 >> 1;

          for (let j = 0; j < seqBytes; ++j) {
            var sb = ba[p + j];
            seq.push(SEQ_DECODER[(sb & 0xf0) >> 4]);
            seq.push(SEQ_DECODER[sb & 0x0f]);
          }

          seq = seq.slice(0, lseq).join(''); // seq might have one extra character (if lseq is an odd number)

          p += seqBytes;
          const qualArray = [];

          for (let j = 0; j < lseq; ++j) {
            qualArray.push(ba[p + j]);
          }

          p += lseq;

          if (mateChrIdx >= 0) {
            alignment.mate = {
              chr: chrNames[mateChrIdx],
              position: matePos,
              strand: !(flag & MATE_STRAND_FLAG$1)
            };
          }

          alignment.seq = seq;
          alignment.qual = qualArray;
          alignment.tagBA = new Uint8Array(ba.buffer.slice(p, blockEnd)); // decode these on demand

          this.setPairOrientation(alignment);

          if (undefined === filter || filter.pass(alignment)) {
            makeBlocks(alignment, cigarArray);
            alignmentContainer.push(alignment);
          }

          offset = blockEnd;
        }
      },
      decodeSamRecords: function (sam, alignmentContainer, chr, min, max, filter) {
        var lines, i, j, len, tokens, qualString, rnext, lengthOnRef, alignment, cigarArray, started;
        lines = splitLines$5(sam);
        len = lines.length;
        started = false;

        for (i = 0; i < len; i++) {
          tokens = lines[i].split('\t');
          alignment = new BamAlignment();
          alignment.chr = tokens[2];
          alignment.start = Number.parseInt(tokens[3]) - 1;
          alignment.flags = Number.parseInt(tokens[1]);
          alignment.readName = tokens[0];
          alignment.strand = !(alignment.flags & READ_STRAND_FLAG$1);
          alignment.mq = Number.parseInt(tokens[4]);
          alignment.cigar = tokens[5];
          alignment.fragmentLength = Number.parseInt(tokens[8]);
          alignment.seq = tokens[9];
          if (alignment.chr === '*' || !alignment.isMapped()) continue; // Unmapped

          if (alignment.chr !== chr) {
            if (started) break; // Off the right edge, we're done
            else continue; // Possibly to the left, skip but keep looping
          } else if (alignment.start > max) {
            break; // off right edge, we're done
          }

          lengthOnRef = 0;
          cigarArray = buildOperators(alignment.cigar);
          cigarArray.forEach(function (op) {
            var opLen = op.len;
            var opLtr = op.ltr;
            if (opLtr === 'M' || opLtr === 'EQ' || opLtr === 'X' || opLtr === 'D' || opLtr === 'N' || opLtr === '=') lengthOnRef += opLen;
          });
          alignment.lengthOnRef = lengthOnRef; // TODO for lh3: parse the CG:B,I tag in SAM here

          if (alignment.start + lengthOnRef < min) {
            continue; // To the left, skip and continue
          }

          qualString = tokens[10];
          alignment.qual = [];

          for (j = 0; j < qualString.length; j++) {
            alignment.qual[j] = qualString.charCodeAt(j) - 33;
          }

          alignment.tagDict = tokens.length < 11 ? {} : decodeSamTags(tokens.slice(11));

          if (alignment.isMateMapped()) {
            rnext = tokens[6];
            alignment.mate = {
              chr: rnext === '=' ? alignment.chr : rnext,
              position: Number.parseInt(tokens[7]),
              strand: !(alignment.flags & MATE_STRAND_FLAG$1)
            };
          }

          this.setPairOrientation(alignment);

          if (undefined === filter || filter.pass(alignment)) {
            makeBlocks(alignment, cigarArray);
            alignmentContainer.push(alignment);
          }
        }
      },
      setReaderDefaults: function (reader, config) {
        reader.filter = new BamFilter(config.filter);

        if (config.readgroup) {
          reader.filter.readgroups = new Set([config.readgroup]);
        }

        reader.alleleFreqThreshold = config.alleleFreqThreshold === undefined ? DEFAULT_ALLELE_FREQ_THRESHOLD : config.alleleFreqThreshold;
        reader.samplingWindowSize = config.samplingWindowSize === undefined ? DEFAULT_SAMPLING_WINDOW_SIZE : config.samplingWindowSize;
        reader.samplingDepth = config.samplingDepth === undefined ? DEFAULT_SAMPLING_DEPTH : config.samplingDepth;

        if (reader.samplingDepth > MAXIMUM_SAMPLING_DEPTH) {
          console.log("Warning: attempt to set sampling depth > maximum value of " + MAXIMUM_SAMPLING_DEPTH);
          reader.samplingDepth = MAXIMUM_SAMPLING_DEPTH;
        }

        if (config.viewAsPairs) {
          reader.pairsSupported = true;
        } else {
          reader.pairsSupported = config.pairsSupported === undefined ? true : config.pairsSupported;
        }
      },
      setPairOrientation: function (alignment) {
        if (alignment.isMapped() && alignment.mate && alignment.isMateMapped() && alignment.mate.chr === alignment.chr) {
          var s1 = alignment.strand ? 'F' : 'R';
          var mate = alignment.mate;
          var s2 = mate.strand ? 'F' : 'R';
          var o1 = ' ';
          var o2 = ' ';

          if (alignment.isFirstOfPair()) {
            o1 = '1';
            o2 = '2';
          } else if (alignment.isSecondOfPair()) {
            o1 = '2';
            o2 = '1';
          }

          var tmp = [];
          var isize = alignment.fragmentLength;
          var estReadLen = alignment.end - alignment.start;

          if (isize === 0) {
            //isize not recorded.  Need to estimate.  This calculation was validated against an Illumina
            // -> <- library bam.
            var estMateEnd = alignment.start < mate.position ? mate.position + estReadLen : mate.position - estReadLen;
            isize = estMateEnd - alignment.start;
          } //if (isize > estReadLen) {


          if (isize > 0) {
            tmp[0] = s1;
            tmp[1] = o1;
            tmp[2] = s2;
            tmp[3] = o2;
          } else {
            tmp[2] = s1;
            tmp[3] = o1;
            tmp[0] = s2;
            tmp[1] = o2;
          } // }


          alignment.pairOrientation = tmp.join('');
        }
      },
      computeLengthOnReference: function (cigarString) {
        let len = 0;
        let buf = '';

        for (let i = 0; i < cigarString.length; i++) {
          const c = cigarString.charCodeAt(i);

          if (c > 47 && c < 58) {
            buf += cigarString.charAt(i);
          } else {
            switch (c) {
              case 78: // N

              case 68: // D

              case 77: // M

              case 61: // =

              case 88:
                // X
                len += parseInt(buf.toString());
            }

            buf = '';
          }
        }

        return len;
      }
    };
    /**
     * Split the alignment record into blocks as specified in the cigarArray.  Each aligned block contains
     * its portion of the read sequence and base quality strings.  A read sequence or base quality string
     * of "*" indicates the value is not recorded.  In all other cases the length of the block sequence (block.seq)
     * and quality string (block.qual) must == the block length.
     *
     * @param alignment
     * @param cigarArray
     * @returns array of blocks
     */

    function makeBlocks(alignment, cigarArray) {
      const blocks = [];
      let insertions;
      let gaps;
      let seqOffset = 0;
      let pos = alignment.start;
      alignment.scStart = alignment.start;
      alignment.scLengthOnRef = alignment.lengthOnRef;

      for (let c of cigarArray) {
        let scPos;

        switch (c.ltr) {
          case 'H':
            break;
          // ignore hard clips

          case 'P':
            break;
          // ignore pads

          case 'S':
            scPos = pos;
            alignment.scLengthOnRef += c.len;

            if (blocks.length === 0) {
              alignment.scStart -= c.len;
              scPos -= c.len;
            }

            blocks.push(new AlignmentBlock({
              start: scPos,
              seqOffset: seqOffset,
              len: c.len,
              type: 'S'
            }));
            seqOffset += c.len;
            break;
          // soft clip read bases

          case 'N':
          case 'D':
            if (gaps === undefined) {
              gaps = [];
            }

            gaps.push({
              start: pos,
              len: c.len,
              type: c.ltr
            });
            pos += c.len;
            break;

          case 'I':
            if (insertions === undefined) {
              insertions = [];
            }

            insertions.push(new AlignmentBlock({
              start: pos,
              len: c.len,
              seqOffset: seqOffset,
              type: 'I'
            }));
            seqOffset += c.len;
            break;

          case 'M':
          case 'EQ':
          case '=':
          case 'X':
            blocks.push(new AlignmentBlock({
              start: pos,
              seqOffset: seqOffset,
              len: c.len,
              type: 'M'
            }));
            seqOffset += c.len;
            pos += c.len;
            break;

          default:
            console.log('Error processing cigar element: ' + c.len + c.ltr);
        }
      }

      alignment.blocks = blocks;
      alignment.insertions = insertions;
      alignment.gaps = gaps;
    }

    function readInt(ba, offset) {
      return ba[offset + 3] << 24 | ba[offset + 2] << 16 | ba[offset + 1] << 8 | ba[offset];
    }
    /**
     * Build a list of cigar operators from a cigarString.  Removes padding operators and concatenates consecutive
     * operators of the same type
     *
     * @param cigarString
     * @return
     */


    function buildOperators(cigarString) {
      var operators, buffer, i, len, prevOp, next, op, nBases;
      operators = [];
      buffer = []; // Create list of cigar operators

      prevOp = null;
      len = cigarString.length;

      for (i = 0; i < len; i++) {
        next = cigarString.charAt(i);

        if (isDigit(next)) {
          buffer.push(next);
        } else {
          op = next;
          nBases = Number.parseInt(buffer.join(''));
          buffer = [];

          if (prevOp !== null && prevOp.ltr === op) {
            prevOp.len += nBases;
          } else {
            prevOp = {
              len: nBases,
              ltr: op
            };
            operators.push(prevOp);
          }
        }
      }

      return operators;
    }

    function isDigit(a) {
      var charCode = a.charCodeAt(0);
      return charCode >= 48 && charCode <= 57; // 0-9
    }

    function decodeSamTags(tags) {
      var tagDict = {};
      tags.forEach(function (tag) {
        var tokens = tag.split(':');
        tagDict[tokens[0]] = tokens[2];
      });
      return tagDict;
    }

    /**
     * Class for reading a bam file
     *
     * @param config
     * @constructor
     */

    class BamReaderNonIndexed {
      constructor(config, genome) {
        this.config = config;
        this.genome = genome;
        this.bamPath = config.url;
        this.isDataUri = isDataURL(config.url);
        BamUtils.setReaderDefaults(this, config);
      } // Return an alignment container


      async readAlignments(chr, bpStart, bpEnd) {
        if (this.alignmentCache) {
          const header = this.header;
          const queryChr = header.chrAliasTable.hasOwnProperty(chr) ? header.chrAliasTable[chr] : chr;
          const qAlignments = this.alignmentCache.queryFeatures(queryChr, bpStart, bpEnd);
          const alignmentContainer = new AlignmentContainer(chr, bpStart, bpEnd, this.config);

          for (let a of qAlignments) {
            alignmentContainer.push(a);
          }

          alignmentContainer.finish();
          return alignmentContainer;
        } else {
          if (this.isDataUri) {
            const data = decodeDataURI(this.bamPath);
            const unc = unbgzf(data.buffer);
            this.parseAlignments(unc);
            return this.fetchAlignments(chr, bpStart, bpEnd);
          } else {
            const arrayBuffer = await igvxhr.loadArrayBuffer(this.bamPath, buildOptions(this.config));
            const unc = unbgzf(arrayBuffer);
            this.parseAlignments(unc);
            return this.fetchAlignments(chr, bpStart, bpEnd);
          }
        }
      }

      parseAlignments(data) {
        const alignments = [];
        this.header = BamUtils.decodeBamHeader(data);
        BamUtils.decodeBamRecords(data, this.header.size, alignments, this.header.chrNames);
        this.alignmentCache = new FeatureCache$1(alignments, this.genome);
      }

      fetchAlignments(chr, bpStart, bpEnd) {
        const queryChr = this.header.chrAliasTable.hasOwnProperty(chr) ? this.header.chrAliasTable[chr] : chr;
        const features = this.alignmentCache.queryFeatures(queryChr, bpStart, bpEnd);
        const alignmentContainer = new AlignmentContainer(chr, bpStart, bpEnd, this.config);

        for (let feature of features) {
          alignmentContainer.push(feature);
        }

        alignmentContainer.finish();
        return alignmentContainer;
      }

    }

    function decodeDataURI(dataURI) {
      const split = dataURI.split(',');
      const info = split[0].split(':')[1];
      let dataString = split[1];

      if (info.indexOf('base64') >= 0) {
        dataString = atob(dataString);
      } else {
        dataString = decodeURI(dataString);
      }

      const bytes = new Uint8Array(dataString.length);

      for (var i = 0; i < dataString.length; i++) {
        bytes[i] = dataString.charCodeAt(i);
      }

      return bytes;
    }

    /*
     * The MIT License (MIT)
     *
     * Copyright (c) 2014 Broad Institute
     *
     * Permission is hereby granted, free of charge, to any person obtaining a copy
     * of this software and associated documentation files (the "Software"), to deal
     * in the Software without restriction, including without limitation the rights
     * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
     * copies of the Software, and to permit persons to whom the Software is
     * furnished to do so, subject to the following conditions:
     *
     * The above copyright notice and this permission notice shall be included in
     * all copies or substantial portions of the Software.
     *
     *
     * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
     * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
     * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
     * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
     * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
     * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
     * THE SOFTWARE.
     */
    // TODO -- big endian?
    class BinaryParser {
      constructor(dataView, littleEndian) {
        this.littleEndian = littleEndian !== undefined ? littleEndian : true;
        this.position = 0;
        this.view = dataView;
        this.length = dataView.byteLength;
      }

      available() {
        return this.length - this.position;
      }

      remLength() {
        return this.length - this.position;
      }

      hasNext() {
        return this.position < this.length - 1;
      }

      getByte() {
        var retValue = this.view.getUint8(this.position, this.littleEndian);
        this.position++;
        return retValue;
      }

      getShort() {
        var retValue = this.view.getInt16(this.position, this.littleEndian);
        this.position += 2;
        return retValue;
      }

      getUShort() {
        // var byte1 = this.getByte(),
        //     byte2 = this.getByte(),
        //     retValue = ((byte2 << 24 >>> 16) + (byte1 << 24 >>> 24));
        //     return retValue;
        //
        var retValue = this.view.getUint16(this.position, this.littleEndian);
        this.position += 2;
        return retValue;
      }

      getInt() {
        var retValue = this.view.getInt32(this.position, this.littleEndian);
        this.position += 4;
        return retValue;
      }

      getUInt() {
        var retValue = this.view.getUint32(this.position, this.littleEndian);
        this.position += 4;
        return retValue;
      }

      getLong() {
        // DataView doesn't support long. So we'll try manually
        var b = [];
        b[0] = this.view.getUint8(this.position);
        b[1] = this.view.getUint8(this.position + 1);
        b[2] = this.view.getUint8(this.position + 2);
        b[3] = this.view.getUint8(this.position + 3);
        b[4] = this.view.getUint8(this.position + 4);
        b[5] = this.view.getUint8(this.position + 5);
        b[6] = this.view.getUint8(this.position + 6);
        b[7] = this.view.getUint8(this.position + 7);
        var value = 0;

        if (this.littleEndian) {
          for (let i = b.length - 1; i >= 0; i--) {
            value = value * 256 + b[i];
          }
        } else {
          for (let i = 0; i < b.length; i++) {
            value = value * 256 + b[i];
          }
        }

        this.position += 8;
        return value;
      }

      getString(len) {
        var s = "";
        var c;

        while ((c = this.view.getUint8(this.position++)) !== 0) {
          s += String.fromCharCode(c);
          if (len && s.length === len) break;
        }

        return s;
      }

      getFixedLengthString(len) {
        var s = "";
        var i;
        var c;

        for (i = 0; i < len; i++) {
          c = this.view.getUint8(this.position++);

          if (c > 0) {
            s += String.fromCharCode(c);
          }
        }

        return s;
      }

      getFixedLengthTrimmedString(len) {
        var s = "";
        var i;
        var c;

        for (i = 0; i < len; i++) {
          c = this.view.getUint8(this.position++);

          if (c > 32) {
            s += String.fromCharCode(c);
          }
        }

        return s;
      }

      getFloat() {
        var retValue = this.view.getFloat32(this.position, this.littleEndian);
        this.position += 4;
        return retValue;
      }

      getDouble() {
        var retValue = this.view.getFloat64(this.position, this.littleEndian);
        this.position += 8;
        return retValue;
      }

      skip(n) {
        this.position += n;
        return this.position;
      }
      /**
       * Return a BGZip (bam and tabix) virtual pointer
       * TODO -- why isn't 8th byte used ?
       * @returns {*}
       */


      getVPointer() {
        var position = this.position,
            offset = this.view.getUint8(position + 1) << 8 | this.view.getUint8(position),
            byte6 = (this.view.getUint8(position + 6) & 0xff) * 0x100000000,
            byte5 = (this.view.getUint8(position + 5) & 0xff) * 0x1000000,
            byte4 = (this.view.getUint8(position + 4) & 0xff) * 0x10000,
            byte3 = (this.view.getUint8(position + 3) & 0xff) * 0x100,
            byte2 = this.view.getUint8(position + 2) & 0xff,
            block = byte6 + byte5 + byte4 + byte3 + byte2;
        this.position += 8; //       if (block == 0 && offset == 0) {
        //           return null;
        //       } else {

        return new VPointer(block, offset); //       }
      }

    }

    class VPointer {
      constructor(block, offset) {
        this.block = block;
        this.offset = offset;
      }

      isLessThan(vp) {
        return this.block < vp.block || this.block === vp.block && this.offset < vp.offset;
      }

      isGreaterThan(vp) {
        return this.block > vp.block || this.block === vp.block && this.offset > vp.offset;
      }

      print() {
        return "" + this.block + ":" + this.offset;
      }

    }

    // Represents a BAM index.
    const CSI1_MAGIC$1 = 21582659; // CSI\1

    const CSI2_MAGIC$1 = 38359875; // CSI\2

    async function parseCsiIndex(arrayBuffer, genome) {
      const idx = new CSIIndex();
      idx.parse(arrayBuffer, genome);
      return idx;
    }

    class CSIIndex {
      constructor(tabix) {
        this.tabix = true; // Means whatever is indexed is BGZipped
      }

      parse(arrayBuffer, genome) {
        const parser = new BinaryParser(new DataView(arrayBuffer));
        const magic = parser.getInt();

        if (magic !== CSI1_MAGIC$1) {
          if (magic === CSI2_MAGIC$1) {
            throw Error("CSI version 2 is not supported.  Please enter an issue at https://github.com/igvteam/igv.js");
          } else {
            throw Error("Not a CSI index");
          }
        }

        this.indices = [];
        this.blockMin = Number.MAX_SAFE_INTEGER;
        this.lastBlockPosition = [];
        this.sequenceIndexMap = {};
        this.minShift = parser.getInt();
        this.depth = parser.getInt();
        const lAux = parser.getInt();
        const seqNames = [];
        let bmax = 0;

        if (lAux >= 28) {
          // Tabix header parameters aren't used, but they must be read to advance the pointer
          parser.getInt();
          parser.getInt();
          parser.getInt();
          parser.getInt();
          parser.getInt();
          parser.getInt();
          const l_nm = parser.getInt();
          const nameEndPos = parser.position + l_nm;
          let i = 0;

          while (parser.position < nameEndPos) {
            let seq_name = parser.getString(); // Translate to "official" chr name.

            if (genome) {
              seq_name = genome.getChromosomeName(seq_name);
            }

            this.sequenceIndexMap[seq_name] = i;
            seqNames[i] = seq_name;
            i++;
          }
        }

        const MAX_BIN = this.bin_limit() + 1;
        const nref = parser.getInt();

        for (let ref = 0; ref < nref; ref++) {
          const binIndex = [];
          const loffset = [];
          const nbin = parser.getInt();

          for (let b = 0; b < nbin; b++) {
            const binNumber = parser.getInt();
            loffset[binNumber] = parser.getVPointer();

            if (binNumber > MAX_BIN) {
              // This is a psuedo bin, not used but we have to consume the bytes
              parser.getInt(); // # of chunks for this bin

              parser.getVPointer(); // unmapped beg

              parser.getVPointer(); // unmapped end

              parser.getLong();
              parser.getLong();
            } else {
              binIndex[binNumber] = [];
              const nchnk = parser.getInt(); // # of chunks for this bin

              for (let i = 0; i < nchnk; i++) {
                const cs = parser.getVPointer(); //chunk_beg

                const ce = parser.getVPointer(); //chunk_end

                if (cs && ce) {
                  if (cs.block < this.blockMin) {
                    this.blockMin = cs.block; // Block containing first alignment
                  }

                  if (ce.block > bmax) {
                    bmax = ce.block;
                  }

                  binIndex[binNumber].push([cs, ce]);
                }
              }
            }
          }

          if (nbin > 0) {
            this.indices[ref] = {
              binIndex: binIndex,
              loffset: loffset
            };
          }
        }

        this.lastBlockPosition = bmax;
      }

      get chromosomeNames() {
        return Object.keys(this.sequenceIndexMap);
      }
      /**
       * Fetch blocks for a particular genomic range.  This method is public so it can be unit-tested.
       *
       * @param refId  the sequence dictionary index of the chromosome
       * @param min  genomic start position
       * @param max  genomic end position
       * @param return an array of {minv: {filePointer, offset}, {maxv: {filePointer, offset}}
       */


      blocksForRange(refId, min, max) {
        const ba = this.indices[refId];

        if (!ba) {
          return [];
        } else {
          const overlappingBins = this.reg2bins(min, max); // List of bin #s that overlap min, max

          if (overlappingBins.length == 0) return [];
          const chunks = []; // Find chunks in overlapping bins.  Leaf bins (< 4681) are not pruned

          for (let binRange of overlappingBins) {
            for (let bin = binRange[0]; bin <= binRange[1]; bin++) {
              if (ba.binIndex[bin]) {
                const binChunks = ba.binIndex[bin];
                const nchnk = binChunks.length;

                for (let c = 0; c < nchnk; ++c) {
                  const cs = binChunks[c][0];
                  const ce = binChunks[c][1];
                  chunks.push({
                    minv: cs,
                    maxv: ce,
                    bin: bin
                  });
                }
              }
            }
          }

          const lowestOffset = ba.loffset[overlappingBins[0]];
          return optimizeChunks$1(chunks, lowestOffset);
        }
      } // reg2bins implementation adapted from GMOD/tabix-js  https://github.com/GMOD/tabix-js/blob/master/src/csi.ts


      reg2bins(beg, end) {
        beg -= 1; // < convert to 1-based closed

        if (beg < 1) beg = 1;
        if (end > 2 ** 50) end = 2 ** 34; // 17 GiB ought to be enough for anybody

        end -= 1;
        let l = 0;
        let t = 0;
        let s = this.minShift + this.depth * 3;
        const bins = [];

        for (; l <= this.depth; s -= 3, t += 1 << l * 3, l += 1) {
          const b = t + (beg >> s);
          const e = t + (end >> s);
          if (e - b + bins.length > this.maxBinNumber) throw new Error(`query ${beg}-${end} is too large for current binning scheme (shift ${this.minShift}, depth ${this.depth}), try a smaller query or a coarser index binning scheme`); //for (let i = b; i <= e; i += 1) bins.push(i)

          bins.push([b, e]);
        }

        return bins;
      } // function reg2bins(beg, end, min_shift, depth) {
      //     let l, t, n, s = min_shift + depth * 3;
      //     const bins = [];
      //     for (--end, l = n = t = 0; l <= depth; s -= 3, t += 1 << l * 3, ++l) {
      //         let b = t + (beg >> s), e = t + (end >> s), i;
      //         for (i = b; i <= e; ++i) bins[n++] = i;
      //     }
      //     return bins;
      // }


      bin_limit() {
        return ((1 << (this.depth + 1) * 3) - 1) / 7;
      }

    }

    function optimizeChunks$1(chunks, lowest) {
      const mergedChunks = [];
      let lastChunk = null;
      if (chunks.length === 0) return chunks;
      chunks.sort(function (c0, c1) {
        const dif = c0.minv.block - c1.minv.block;

        if (dif !== 0) {
          return dif;
        } else {
          return c0.minv.offset - c1.minv.offset;
        }
      });
      chunks.forEach(function (chunk) {
        if (!lowest || chunk.maxv.isGreaterThan(lowest)) {
          if (lastChunk === null) {
            mergedChunks.push(chunk);
            lastChunk = chunk;
          } else {
            if (canMerge$1(lastChunk, chunk)) {
              if (chunk.maxv.isGreaterThan(lastChunk.maxv)) {
                lastChunk.maxv = chunk.maxv;
              }
            } else {
              mergedChunks.push(chunk);
              lastChunk = chunk;
            }
          }
        }
      });
      return mergedChunks;
    }

    function canMerge$1(chunk1, chunk2) {
      return chunk2.minv.block - chunk1.maxv.block < 65000 && chunk2.maxv.block - chunk1.minv.block < 5000000; // lastChunk.minv.block === lastChunk.maxv.block &&
      // lastChunk.maxv.block === chunk.minv.block &&
      // chunk.minv.block === chunk.maxv.block
    }

    // Represents a BAM index.
    const BAI_MAGIC$1 = 21578050;
    const TABIX_MAGIC$1 = 21578324;
    const MB = 1000000;

    async function parseBamIndex(arrayBuffer, genome) {
      const index = new BamIndex();
      await index.parse(arrayBuffer, false, genome);
      return index;
    }

    async function parseTabixIndex(arrayBuffer, genome) {
      const index = new BamIndex();
      await index.parse(arrayBuffer, true, genome);
      return index;
    }

    class BamIndex {
      constructor() {}

      async parse(arrayBuffer, tabix, genome) {
        const indices = [];
        let blockMin = Number.MAX_SAFE_INTEGER;
        let blockMax = 0;
        const seqNames = [];
        const parser = new BinaryParser(new DataView(arrayBuffer));
        const magic = parser.getInt();
        const sequenceIndexMap = {};

        if (magic === BAI_MAGIC$1 || tabix && magic === TABIX_MAGIC$1) {
          const nref = parser.getInt();

          if (tabix) {
            // Tabix header parameters aren't used, but they must be read to advance the pointer
            parser.getInt();
            parser.getInt();
            parser.getInt();
            parser.getInt();
            parser.getInt();
            parser.getInt();
            parser.getInt();

            for (let i = 0; i < nref; i++) {
              let seq_name = parser.getString(); // Translate to "official" chr name.

              if (genome) {
                seq_name = genome.getChromosomeName(seq_name);
              }

              sequenceIndexMap[seq_name] = i;
              seqNames[i] = seq_name;
            }
          } // Loop through sequences


          for (let ref = 0; ref < nref; ref++) {
            const binIndex = {};
            const linearIndex = [];
            const nbin = parser.getInt();

            for (let b = 0; b < nbin; b++) {
              const binNumber = parser.getInt();

              if (binNumber === 37450) {
                // This is a psuedo bin, not used but we have to consume the bytes
                parser.getInt(); // # of chunks for this bin

                parser.getVPointer(); // unmapped beg

                parser.getVPointer(); // unmapped end

                parser.getLong();
                parser.getLong();
              } else {
                binIndex[binNumber] = [];
                const nchnk = parser.getInt(); // # of chunks for this bin

                for (let i = 0; i < nchnk; i++) {
                  const cs = parser.getVPointer(); //chunk_beg

                  const ce = parser.getVPointer(); //chunk_end

                  if (cs && ce) {
                    if (cs.block < blockMin) {
                      blockMin = cs.block; // Block containing first alignment
                    }

                    if (ce.block > blockMax) {
                      blockMax = ce.block;
                    }

                    binIndex[binNumber].push([cs, ce]);
                  }
                }
              }
            }

            const nintv = parser.getInt();

            for (let i = 0; i < nintv; i++) {
              const cs = parser.getVPointer();
              linearIndex.push(cs); // Might be null
            }

            if (nbin > 0) {
              indices[ref] = {
                binIndex: binIndex,
                linearIndex: linearIndex
              };
            }
          }

          this.firstBlockPosition = blockMin;
          this.lastBlockPosition = blockMax;
          this.indices = indices;
          this.sequenceIndexMap = sequenceIndexMap;
          this.tabix = tabix;
        } else {
          throw new Error(indexURL + " is not a " + (tabix ? "tabix" : "bai") + " file");
        }
      }

      get chromosomeNames() {
        return Object.keys(this.sequenceIndexMap);
      }
      /**
       * Fetch blocks for a particular genomic range.  This method is public so it can be unit-tested.
       *
       * @param refId  the sequence dictionary index of the chromosome
       * @param min  genomic start position
       * @param max  genomic end position
       * @param return an array of {minv: {filePointer, offset}, {maxv: {filePointer, offset}}
       */


      blocksForRange(refId, min, max) {
        const bam = this;
        const ba = bam.indices[refId];

        if (!ba) {
          return [];
        } else {
          const overlappingBins = reg2bins(min, max); // List of bin #s that overlap min, max

          const chunks = []; // Find chunks in overlapping bins.  Leaf bins (< 4681) are not pruned

          for (let binRange of overlappingBins) {
            for (let bin = binRange[0]; bin <= binRange[1]; bin++) {
              if (ba.binIndex[bin]) {
                const binChunks = ba.binIndex[bin],
                      nchnk = binChunks.length;

                for (let c = 0; c < nchnk; ++c) {
                  const cs = binChunks[c][0];
                  const ce = binChunks[c][1];
                  chunks.push({
                    minv: cs,
                    maxv: ce,
                    bin: bin
                  });
                }
              }
            }
          } // Use the linear index to find minimum file position of chunks that could contain alignments in the region


          const nintv = ba.linearIndex.length;
          let lowest = null;
          const minLin = Math.min(min >> 14, nintv - 1);
          const maxLin = Math.min(max >> 14, nintv - 1);

          for (let i = minLin; i <= maxLin; ++i) {
            const vp = ba.linearIndex[i];

            if (vp) {
              // todo -- I think, but am not sure, that the values in the linear index have to be in increasing order.  So the first non-null should be minimum
              if (!lowest || vp.isLessThan(lowest)) {
                lowest = vp;
              }
            }
          }

          return optimizeChunks(chunks, lowest);
        }
      }

    }

    function optimizeChunks(chunks, lowest) {
      const mergedChunks = [];
      let lastChunk = null;
      if (chunks.length === 0) return chunks;
      chunks.sort(function (c0, c1) {
        const dif = c0.minv.block - c1.minv.block;

        if (dif !== 0) {
          return dif;
        } else {
          return c0.minv.offset - c1.minv.offset;
        }
      });
      chunks.forEach(function (chunk) {
        if (!lowest || chunk.maxv.isGreaterThan(lowest)) {
          if (lastChunk === null) {
            mergedChunks.push(chunk);
            lastChunk = chunk;
          } else {
            if (canMerge(lastChunk, chunk)) {
              if (chunk.maxv.isGreaterThan(lastChunk.maxv)) {
                lastChunk.maxv = chunk.maxv;
              }
            } else {
              mergedChunks.push(chunk);
              lastChunk = chunk;
            }
          }
        }
      });
      return mergedChunks;
    }
    /**
     * Merge 2 blocks if the gap between them is < 1kb and the total resulting size < 100mb
     * @param chunk1
     * @param chunk2
     * @returns {boolean|boolean}
     */


    function canMerge(chunk1, chunk2) {
      const gap = chunk2.minv.block - chunk1.maxv.block;
      const total = chunk2.maxv.block - chunk1.minv.block;
      return gap < 30000 && total < 10 * MB;
    }
    /**
     * Calculate the list of bins that overlap with region [beg, end]
     *
     */


    function reg2bins(beg, end) {
      const list = [];
      if (end >= 1 << 29) end = 1 << 29;
      --end;
      list.push([0, 0]);
      list.push([1 + (beg >> 26), 1 + (end >> 26)]);
      list.push([9 + (beg >> 23), 9 + (end >> 23)]);
      list.push([73 + (beg >> 20), 73 + (end >> 20)]);
      list.push([585 + (beg >> 17), 585 + (end >> 17)]);
      list.push([4681 + (beg >> 14), 4681 + (end >> 14)]); // for (k = 1 + (beg >> 26); k <= 1 + (end >> 26); ++k) list.push(k);
      // for (k = 9 + (beg >> 23); k <= 9 + (end >> 23); ++k) list.push(k);
      // for (k = 73 + (beg >> 20); k <= 73 + (end >> 20); ++k) list.push(k);
      // for (k = 585 + (beg >> 17); k <= 585 + (end >> 17); ++k) list.push(k);
      // for (k = 4681 + (beg >> 14); k <= 4681 + (end >> 14); ++k) list.push(k);

      return list;
    }

    /*
     * The MIT License (MIT)
     *
     * Copyright (c) 2014 Broad Institute
     *
     * Permission is hereby granted, free of charge, to any person obtaining a copy
     * of this software and associated documentation files (the "Software"), to deal
     * in the Software without restriction, including without limitation the rights
     * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
     * copies of the Software, and to permit persons to whom the Software is
     * furnished to do so, subject to the following conditions:
     *
     * The above copyright notice and this permission notice shall be included in
     * all copies or substantial portions of the Software.
     *
     *
     * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
     * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
     * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
     * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
     * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
     * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
     * THE SOFTWARE.
     */

    async function parseTribbleIndex(arrayBuffer, genome) {
      const index = new TribbleIndex();
      index.parse(arrayBuffer, genome);
      return index;
    }

    class TribbleIndex {
      constructor() {}

      async parse(arrayBuffer, genome) {
        let blockMax = 0;
        this.chrIndex = {};
        this.lastBlockPosition = [];
        const parser = new BinaryParser(new DataView(arrayBuffer));
        readHeader(parser);
        let nChrs = parser.getInt();

        while (nChrs-- > 0) {
          // todo -- support interval tree index, we're assuming its a linear index
          let chr = parser.getString();
          if (genome) chr = genome.getChromosomeName(chr); // Translate to canonical name

          const binWidth = parser.getInt();
          const nBins = parser.getInt();
          const longestFeature = parser.getInt();
          parser.getInt() > 0;
          parser.getInt(); // note the code below accounts for > 60% of the total time to read an index

          let pos = parser.getLong();
          const blocks = [];

          for (let binNumber = 0; binNumber < nBins; binNumber++) {
            const nextPos = parser.getLong();
            blocks.push({
              min: pos,
              max: nextPos
            }); //        {position: pos, size: size});

            pos = nextPos;

            if (nextPos > blockMax) {
              blockMax = nextPos;
            }
          }

          this.chrIndex[chr] = {
            chr: chr,
            blocks: blocks,
            longestFeature: longestFeature,
            binWidth: binWidth
          };
        }

        this.lastBlockPosition = blockMax;
        /**
         * Read the header .   Data here is not used in igv.js but we need to read it to advance the pointer.
         * @param parser
         */

        function readHeader(parser) {
          parser.getInt(); //   view._getInt32(offset += 32, true);

          parser.getInt();
          const version = parser.getInt();
          parser.getString();
          parser.getLong();
          parser.getLong();
          parser.getString();
          parser.getInt();

          if (version >= 3) {
            let nProperties = parser.getInt();

            while (nProperties-- > 0) {
              parser.getString();
              parser.getString();
            }
          }
        }
      }

      get chromosomeNames() {
        return Object.keys(this.chrIndex);
      }
      /**
       * Fetch blocks for a particular genomic range.
       *
       * @param queryChr the sequence dictionary index of the chromosome
       * @param min  genomic start position
       * @param max  genomic end position
       */


      blocksForRange(queryChr, min, max) {
        const chrIdx = this.chrIndex[queryChr];

        if (chrIdx) {
          const blocks = chrIdx.blocks;
          const longestFeature = chrIdx.longestFeature;
          const binWidth = chrIdx.binWidth;
          const adjustedPosition = Math.max(min - longestFeature, 0);
          const startBinNumber = Math.floor(adjustedPosition / binWidth);
          if (startBinNumber >= blocks.length) // are we off the end of the bin list, so return nothing
            return [];else {
            const endBinNumber = Math.min(Math.floor((max - 1) / binWidth), blocks.length - 1); // By definition blocks are adjacent in the file for the liner index.  Combine them into one merged block

            const startPos = blocks[startBinNumber].min;
            const endPos = blocks[endBinNumber].max;
            const size = endPos - startPos;

            if (size === 0) {
              return [];
            } else {
              const mergedBlock = {
                minv: {
                  block: startPos,
                  offset: 0
                },
                maxv: {
                  block: endPos,
                  offset: 0
                }
              };
              return [mergedBlock];
            }
          }
        } else {
          return undefined;
        }
      }

    }

    const CSI1_MAGIC = 21582659; // CSI\1

    const CSI2_MAGIC = 38359875; // CSI\2

    const BAI_MAGIC = 21578050;
    const TABIX_MAGIC = 21578324;
    const TRIBBLE_MAGIC = 1480870228; //  byte[]{'T', 'I', 'D', 'X'};

    /**
     * @param indexURL
     * @param config
     * @param tabix
     *
     */

    async function loadIndex(indexURL, config, genome) {
      let arrayBuffer = await igvxhr.loadArrayBuffer(indexURL, buildOptions(config));
      let dv = new DataView(arrayBuffer); // Some indexs are bgzipped, specifically tabix, and csi.  Bam (bai) are not.  Tribble is usually not.
      // Check first 2 bytes of file for gzip magic number, and inflate if neccessary

      if (dv.getUint8(0) === 0x1f && dv.getUint8(1) === 0x8b) {
        // gzipped
        const inflate = unbgzf(arrayBuffer);
        arrayBuffer = inflate.buffer;
        dv = new DataView(arrayBuffer);
      }

      const magic = dv.getInt32(0, true);

      switch (magic) {
        case BAI_MAGIC:
          return parseBamIndex(arrayBuffer, genome);

        case TABIX_MAGIC:
          return parseTabixIndex(arrayBuffer, genome);

        case CSI1_MAGIC:
          return parseCsiIndex(arrayBuffer, genome);

        case TRIBBLE_MAGIC:
          return parseTribbleIndex(arrayBuffer, genome);

        case CSI2_MAGIC:
          throw Error("CSI version 2 is not supported.");

        default:
          throw Error(`Unrecognized index type: ${indexURL}`);
      }
    }

    /*
     * The MIT License (MIT)
     *
     * Copyright (c) 2016-2017 The Regents of the University of California
     * Author: Jim Robinson
     *
     * Permission is hereby granted, free of charge, to any person obtaining a copy
     * of this software and associated documentation files (the "Software"), to deal
     * in the Software without restriction, including without limitation the rights
     * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
     * copies of the Software, and to permit persons to whom the Software is
     * furnished to do so, subject to the following conditions:
     *
     * The above copyright notice and this permission notice shall be included in
     * all copies or substantial portions of the Software.
     *
     *
     * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
     * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
     * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
     * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
     * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
     * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
     * THE SOFTWARE.
     */
    /**
     * Class for reading a bam file
     *
     * @param config
     * @constructor
     */

    class BamReader {
      constructor(config, genome) {
        this.config = config;
        this.genome = genome;
        this.bamPath = config.url;
        this.baiPath = config.indexURL;
        BamUtils.setReaderDefaults(this, config);
      }

      async readAlignments(chr, bpStart, bpEnd) {
        const chrToIndex = await this.getChrIndex();
        const queryChr = this.chrAliasTable.hasOwnProperty(chr) ? this.chrAliasTable[chr] : chr;
        const chrId = chrToIndex[queryChr];
        const alignmentContainer = new AlignmentContainer(chr, bpStart, bpEnd, this.config);

        if (chrId === undefined) {
          return alignmentContainer;
        } else {
          const bamIndex = await this.getIndex();
          const chunks = bamIndex.blocksForRange(chrId, bpStart, bpEnd);

          if (!chunks || chunks.length === 0) {
            return alignmentContainer;
          }

          for (let c of chunks) {
            let lastBlockSize;

            if (c.maxv.offset === 0) {
              lastBlockSize = 0; // Don't need to read the last block.
            } else {
              const bsizeOptions = buildOptions(this.config, {
                range: {
                  start: c.maxv.block,
                  size: 26
                }
              });
              const abuffer = await igvxhr.loadArrayBuffer(this.bamPath, bsizeOptions);
              lastBlockSize = bgzBlockSize(abuffer);
            }

            const fetchMin = c.minv.block;
            const fetchMax = c.maxv.block + lastBlockSize;
            const range = {
              start: fetchMin,
              size: fetchMax - fetchMin + 1
            };
            const compressed = await igvxhr.loadArrayBuffer(this.bamPath, buildOptions(this.config, {
              range: range
            }));
            var ba = unbgzf(compressed); //new Uint8Array(BGZip.unbgzf(compressed)); //, c.maxv.block - c.minv.block + 1));

            const done = BamUtils.decodeBamRecords(ba, c.minv.offset, alignmentContainer, this.indexToChr, chrId, bpStart, bpEnd, this.filter);

            if (done) {
              //    console.log(`Loaded ${counter} chunks out of  ${chunks.length}`);
              break;
            }
          }

          alignmentContainer.finish();
          return alignmentContainer;
        }
      }

      async getHeader() {
        if (!this.header) {
          const genome = this.genome;
          const index = await this.getIndex();
          let len;

          if (index.firstBlockPosition) {
            const bsizeOptions = buildOptions(this.config, {
              range: {
                start: index.firstBlockPosition,
                size: 26
              }
            });
            const abuffer = await igvxhr.loadArrayBuffer(this.bamPath, bsizeOptions);
            const bsize = bgzBlockSize(abuffer);
            len = index.firstBlockPosition + bsize; // Insure we get the complete compressed block containing the header
          } else {
            len = 64000;
          }

          const options = buildOptions(this.config, {
            range: {
              start: 0,
              size: len
            }
          });
          this.header = await BamUtils.readHeader(this.bamPath, options, genome);
        }

        return this.header;
      }

      async getIndex() {
        const genome = this.genome;

        if (!this.index) {
          this.index = await loadIndex(this.baiPath, this.config, genome);
        }

        return this.index;
      }

      async getChrIndex() {
        if (this.chrToIndex) {
          return this.chrToIndex;
        } else {
          const header = await this.getHeader();
          this.chrToIndex = header.chrToIndex;
          this.indexToChr = header.chrNames;
          this.chrAliasTable = header.chrAliasTable;
          return this.chrToIndex;
        }
      }

    }

    /*
     * The MIT License (MIT)
     *
     * Copyright (c) 2016-2017 The Regents of the University of California
     * Author: Jim Robinson
     *
     * Permission is hereby granted, free of charge, to any person obtaining a copy
     * of this software and associated documentation files (the "Software"), to deal
     * in the Software without restriction, including without limitation the rights
     * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
     * copies of the Software, and to permit persons to whom the Software is
     * furnished to do so, subject to the following conditions:
     *
     * The above copyright notice and this permission notice shall be included in
     * all copies or substantial portions of the Software.
     *
     *
     * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
     * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
     * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
     * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
     * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
     * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
     * THE SOFTWARE.
     */

    class ShardedBamReader {
      constructor(config, genome) {
        this.config = config;
        this.genome = genome;
        const bamReaders = {};
        config.sources.sequences.forEach(function (chr) {
          const queryChr = genome ? genome.getChromosomeName(chr) : chr;
          bamReaders[queryChr] = getReader(config, genome, chr);
        });
        this.bamReaders = bamReaders;
        BamUtils.setReaderDefaults(this, config);
      }

      async readAlignments(chr, start, end) {
        if (!this.bamReaders.hasOwnProperty(chr)) {
          return new AlignmentContainer(chr, start, end, this.config);
        } else {
          let reader = this.bamReaders[chr];
          const a = await reader.readAlignments(chr, start, end);
          return a;
        }
      }

    }

    function getReader(config, genome, chr) {
      const tmp = {
        url: config.sources.url.replace("$CHR", chr)
      };

      if (config.sources.indexURL) {
        tmp.indexURL = config.sources.indexURL.replace("$CHR", chr);
      }

      const bamConfig = Object.assign(config, tmp); // TODO -- support non-indexed, htsget, etc

      return new BamReader(bamConfig, genome);
    }

    /*
     * The MIT License (MIT)
     *
     * Copyright (c) 2016-2017 The Regents of the University of California
     * Author: Jim Robinson
     *
     * Permission is hereby granted, free of charge, to any person obtaining a copy
     * of this software and associated documentation files (the "Software"), to deal
     * in the Software without restriction, including without limitation the rights
     * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
     * copies of the Software, and to permit persons to whom the Software is
     * furnished to do so, subject to the following conditions:
     *
     * The above copyright notice and this permission notice shall be included in
     * all copies or substantial portions of the Software.
     *
     *
     * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
     * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
     * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
     * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
     * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
     * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
     * THE SOFTWARE.
     */
    /**
     * Class for reading bam records from an igv.js-flask server backed by pysam.  Deprecated.
     *
     * @param config
     * @constructor
     */

    const BamWebserviceReader = function (config, genome) {
      this.config = config;
      this.genome = genome;
      BamUtils.setReaderDefaults(this, config);
    }; // Example http://localhost:5000/alignments/?reference=/Users/jrobinso/hg19mini.fa&file=/Users/jrobinso/cram_with_crai_index.cram&region=1:100-2000


    BamWebserviceReader.prototype.readAlignments = function (chr, bpStart, bpEnd) {
      var self = this;
      return getHeader.call(self).then(function (header) {
        var queryChr, url;
        queryChr = header.chrAliasTable.hasOwnProperty(chr) ? header.chrAliasTable[chr] : chr;
        url = self.config.url + "?reference=" + self.config.referenceFile + "&file=" + self.config.alignmentFile + "" + "&region=" + queryChr + ":" + bpStart + "-" + bpEnd;
        return igvxhr.loadString(url, buildOptions(self.config)).then(function (sam) {
          var alignmentContainer;
          header.chrToIndex[queryChr];
          alignmentContainer = new AlignmentContainer(chr, bpStart, bpEnd, self.config);
          BamUtils.decodeSamRecords(sam, alignmentContainer, queryChr, bpStart, bpEnd, self.filter);
          return alignmentContainer;
        });
      });
    }; // Example  http://localhost:5000/alignments/?reference=/Users/jrobinso/hg19mini.fa&file=/Users/jrobinso/cram_with_crai_index.cram&options=-b%20-H


    function getHeader() {
      const self = this;
      const genome = this.genome;

      if (this.header) {
        return Promise.resolve(this.header);
      } else {
        const url = this.config.url + "?file=" + this.config.alignmentFile + "&options=-b,-H";
        const options = buildOptions(this.config);
        return BamUtils.readHeader(url, options, genome).then(function (header) {
          self.header = header;
          return header;
        });
      }
    }

    class HtsgetReader {
      constructor(config, genome) {
        this.config = config;
        this.genome = genome;
        this.format = config.format ? config.format.toUpperCase() : "BAM"; // Backward compatibility

        if (!(this.format === "BAM" || this.format === "VCF")) {
          throw Error(`htsget format ${config.format} is not supported`);
        }
      }

      async readHeaderData() {
        const url = `${getUrl(this.config)}?class=header&format=${this.format}`;
        const ticket = await igvxhr.loadJson(url, buildOptions(this.config));
        return await this.loadUrls(ticket.htsget.urls);
      }

      async readData(chr, start, end) {
        const url = `${getUrl(this.config)}?format=${this.format}&referenceName=${chr}&start=${Math.floor(start)}&end=${Math.ceil(end)}`;
        const ticket = await igvxhr.loadJson(url, buildOptions(this.config));
        return this.loadUrls(ticket.htsget.urls);
      }

      async loadUrls(urls) {
        const promiseArray = [];

        for (let urlData of urls) {
          if (urlData.url.startsWith('data:')) {
            // this is a data-uri
            promiseArray.push(Promise.resolve(dataUriToBytes(urlData.url)));
          } else {
            const options = buildOptions(this.config || {});

            if (urlData.headers) {
              options.headers = Object.assign(options.headers || {}, urlData.headers);
            }

            promiseArray.push(igvxhr.loadArrayBuffer(urlData.url, options));
          }
        }

        const arrayBuffers = await Promise.all(promiseArray);
        return concatArrays(arrayBuffers);
      }

      static async inferFormat(config) {
        try {
          const url = getUrl(config);
          const headerURL = `${url}${url.includes("?") ? "&" : "?"}class=header`;
          const ticket = await igvxhr.loadJson(headerURL, buildOptions(config));

          if (ticket.htsget) {
            const format = ticket.htsget.format;

            if (!(format === "BAM" || format === "VCF")) {
              throw Error(`htsget format ${format} is not supported`);
            }

            config.format = format.toLowerCase();
            config.sourceType = "htsget";

            if (!config.name) {
              config.name = await getFilename(config.url);
            }
          }
        } catch (e) {// Errors => this is not an htsget source, not an application error.  Ignore
        }
      }

    }
    /**
     * Extract the full url from the config.  Striving for backward compatibility, "endpoint" and "id" are deprecated.
     *
     * @param config
     */


    function getUrl(config) {
      if (config.url && config.endpoint && config.id) {
        return config.url + config.endpoint + config.id; // Deprecated
      } else if (config.endpoint && config.id) {
        return config.endpoint + config.id; // Deprecated
      } else if (config.url) {
        if (config.url.startsWith("htsget://")) {
          return config.url.replace("htsget://", "https://"); // htsget -> http not supported
        } else {
          return config.url;
        }
      } else {
        throw Error("Must specify either 'url', or 'endpoint' and 'id");
      }
    }
    /**
     * Concatenate a list of array buffers, returning an UInt8Array
     * @param arrayBuffers
     */


    function concatArrays(arrayBuffers) {
      let len = 0;

      for (let a of arrayBuffers) {
        len += a.byteLength;
      }

      let offset = 0;
      const newArray = new Uint8Array(len);

      for (let buf of arrayBuffers) {
        const a = new Uint8Array(buf);
        newArray.set(a, offset);
        offset += a.length;
      }

      return newArray;
    }

    function dataUriToBytes(dataUri) {
      const split = dataUri.split(',');
      const info = split[0].split(':')[1];
      let dataString = split[1];

      if (info.indexOf('base64') >= 0) {
        dataString = atob(dataString);
      } else {
        dataString = decodeURI(dataString);
      }

      const bytes = new Uint8Array(dataString.length);

      for (var i = 0; i < dataString.length; i++) {
        bytes[i] = dataString.charCodeAt(i);
      }

      return bytes;
    }

    /*
     * The MIT License (MIT)
     *
     * Copyright (c) 2016-2017 The Regents of the University of California
     * Author: Jim Robinson
     *
     * Permission is hereby granted, free of charge, to any person obtaining a copy
     * of this software and associated documentation files (the "Software"), to deal
     * in the Software without restriction, including without limitation the rights
     * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
     * copies of the Software, and to permit persons to whom the Software is
     * furnished to do so, subject to the following conditions:
     *
     * The above copyright notice and this permission notice shall be included in
     * all copies or substantial portions of the Software.
     *
     *
     * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
     * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
     * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
     * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
     * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
     * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
     * THE SOFTWARE.
     */

    class HtsgetBamReader extends HtsgetReader {
      constructor(config, genome) {
        super(config, genome);
        BamUtils.setReaderDefaults(this, config);
      }

      async readAlignments(chr, start, end) {
        if (!this.header) {
          const compressedData = await this.readHeaderData();
          const ba = unbgzf(compressedData.buffer);
          this.header = BamUtils.decodeBamHeader(ba, this.genome);
          this.chrAliasTable = new Map();

          for (let key of Object.keys(this.header.chrAliasTable)) {
            this.chrAliasTable.set(key, this.header.chrAliasTable[key]);
          }
        }

        let queryChr = this.chrAliasTable.has(chr) ? this.chrAliasTable.get(chr) : chr;
        const compressedData = await this.readData(queryChr, start, end); // BAM decoding

        const ba = unbgzf(compressedData.buffer);
        const chrIdx = this.header.chrToIndex[chr];
        const alignmentContainer = new AlignmentContainer(chr, start, end, this.config);
        BamUtils.decodeBamRecords(ba, this.header.size, alignmentContainer, this.header.chrNames, chrIdx, start, end);
        alignmentContainer.finish();
        return alignmentContainer;
      }

    }

    var FunctionPrototype = Function.prototype;
    var apply = FunctionPrototype.apply;
    var call = FunctionPrototype.call; // eslint-disable-next-line es-x/no-reflect -- safe

    var functionApply = typeof Reflect == 'object' && Reflect.apply || (functionBindNative ? call.bind(apply) : function () {
      return call.apply(apply, arguments);
    });

    var bind = functionUncurryThis(functionUncurryThis.bind); // optional / simple context binding

    var functionBindContext = function (fn, that) {
      aCallable(fn);
      return that === undefined ? fn : functionBindNative ? bind(fn, that) : function
        /* ...args */
      () {
        return fn.apply(that, arguments);
      };
    };

    var arraySlice = functionUncurryThis([].slice);

    var TypeError$1 = global$1.TypeError;

    var validateArgumentsLength = function (passed, required) {
      if (passed < required) throw TypeError$1('Not enough arguments');
      return passed;
    };

    var engineIsIos = /(?:ipad|iphone|ipod).*applewebkit/i.test(engineUserAgent);

    var engineIsNode = classofRaw(global$1.process) == 'process';

    var set = global$1.setImmediate;
    var clear = global$1.clearImmediate;
    var process$1 = global$1.process;
    var Dispatch = global$1.Dispatch;
    var Function$1 = global$1.Function;
    var MessageChannel$1 = global$1.MessageChannel;
    var String$1 = global$1.String;
    var counter = 0;
    var queue = {};
    var ONREADYSTATECHANGE = 'onreadystatechange';
    var location, defer, channel, port;

    try {
      // Deno throws a ReferenceError on `location` access without `--location` flag
      location = global$1.location;
    } catch (error) {
      /* empty */
    }

    var run = function (id) {
      if (hasOwnProperty_1(queue, id)) {
        var fn = queue[id];
        delete queue[id];
        fn();
      }
    };

    var runner = function (id) {
      return function () {
        run(id);
      };
    };

    var listener = function (event) {
      run(event.data);
    };

    var post = function (id) {
      // old engines have not location.origin
      global$1.postMessage(String$1(id), location.protocol + '//' + location.host);
    }; // Node.js 0.9+ & IE10+ has setImmediate, otherwise:


    if (!set || !clear) {
      set = function setImmediate(handler) {
        validateArgumentsLength(arguments.length, 1);
        var fn = isCallable(handler) ? handler : Function$1(handler);
        var args = arraySlice(arguments, 1);

        queue[++counter] = function () {
          functionApply(fn, undefined, args);
        };

        defer(counter);
        return counter;
      };

      clear = function clearImmediate(id) {
        delete queue[id];
      }; // Node.js 0.8-


      if (engineIsNode) {
        defer = function (id) {
          process$1.nextTick(runner(id));
        }; // Sphere (JS game engine) Dispatch API

      } else if (Dispatch && Dispatch.now) {
        defer = function (id) {
          Dispatch.now(runner(id));
        }; // Browsers with MessageChannel, includes WebWorkers
        // except iOS - https://github.com/zloirock/core-js/issues/624

      } else if (MessageChannel$1 && !engineIsIos) {
        channel = new MessageChannel$1();
        port = channel.port2;
        channel.port1.onmessage = listener;
        defer = functionBindContext(port.postMessage, port); // Browsers with postMessage, skip WebWorkers
        // IE8 has postMessage, but it's sync & typeof its postMessage is 'object'
      } else if (global$1.addEventListener && isCallable(global$1.postMessage) && !global$1.importScripts && location && location.protocol !== 'file:' && !fails(post)) {
        defer = post;
        global$1.addEventListener('message', listener, false); // IE8-
      } else if (ONREADYSTATECHANGE in documentCreateElement('script')) {
        defer = function (id) {
          html.appendChild(documentCreateElement('script'))[ONREADYSTATECHANGE] = function () {
            html.removeChild(this);
            run(id);
          };
        }; // Rest old browsers

      } else {
        defer = function (id) {
          setTimeout(runner(id), 0);
        };
      }
    }

    var task = {
      set: set,
      clear: clear
    };

    var clearImmediate = task.clear; // `clearImmediate` method
    // http://w3c.github.io/setImmediate/#si-clearImmediate

    _export({
      global: true,
      bind: true,
      enumerable: true,
      forced: global$1.clearImmediate !== clearImmediate
    }, {
      clearImmediate: clearImmediate
    });

    var setImmediate = task.set; // `setImmediate` method
    // http://w3c.github.io/setImmediate/#si-setImmediate

    _export({
      global: true,
      bind: true,
      enumerable: true,
      forced: global$1.setImmediate !== setImmediate
    }, {
      setImmediate: setImmediate
    });

    const eval2 = eval;

    const gmodCRAM = function (t) {
      var e = {};

      function r(n) {
        if (e[n]) return e[n].exports;
        var i = e[n] = {
          i: n,
          l: !1,
          exports: {}
        };
        return t[n].call(i.exports, i, i.exports, r), i.l = !0, i.exports;
      }

      return r.m = t, r.c = e, r.d = function (t, e, n) {
        r.o(t, e) || Object.defineProperty(t, e, {
          enumerable: !0,
          get: n
        });
      }, r.r = function (t) {
        "undefined" != typeof Symbol && Symbol.toStringTag && Object.defineProperty(t, Symbol.toStringTag, {
          value: "Module"
        }), Object.defineProperty(t, "__esModule", {
          value: !0
        });
      }, r.t = function (t, e) {
        if (1 & e && (t = r(t)), 8 & e) return t;
        if (4 & e && "object" == typeof t && t && t.__esModule) return t;
        var n = Object.create(null);
        if (r.r(n), Object.defineProperty(n, "default", {
          enumerable: !0,
          value: t
        }), 2 & e && "string" != typeof t) for (var i in t) r.d(n, i, function (e) {
          return t[e];
        }.bind(null, i));
        return n;
      }, r.n = function (t) {
        var e = t && t.__esModule ? function () {
          return t.default;
        } : function () {
          return t;
        };
        return r.d(e, "a", e), e;
      }, r.o = function (t, e) {
        return Object.prototype.hasOwnProperty.call(t, e);
      }, r.p = "", r(r.s = 163);
    }([function (t, e, r) {

      var n = r(13),
          i = r(81).f,
          o = r(107),
          a = r(3),
          s = r(15),
          u = r(20),
          f = r(24),
          c = function (t) {
        var e = function (e, r, n) {
          if (this instanceof t) {
            switch (arguments.length) {
              case 0:
                return new t();

              case 1:
                return new t(e);

              case 2:
                return new t(e, r);
            }

            return new t(e, r, n);
          }

          return t.apply(this, arguments);
        };

        return e.prototype = t.prototype, e;
      };

      t.exports = function (t, e) {
        var r,
            l,
            h,
            d,
            p,
            g,
            v,
            y,
            m = t.target,
            b = t.global,
            _ = t.stat,
            w = t.proto,
            x = b ? n : _ ? n[m] : (n[m] || {}).prototype,
            E = b ? a : a[m] || (a[m] = {}),
            S = E.prototype;

        for (h in e) r = !o(b ? h : m + (_ ? "." : "#") + h, t.forced) && x && f(x, h), p = E[h], r && (g = t.noTargetGet ? (y = i(x, h)) && y.value : x[h]), d = r && g ? g : e[h], r && typeof p == typeof d || (v = t.bind && r ? s(d, n) : t.wrap && r ? c(d) : w && "function" == typeof d ? s(Function.call, d) : d, (t.sham || d && d.sham || p && p.sham) && u(v, "sham", !0), E[h] = v, w && (f(a, l = m + "Prototype") || u(a, l, {}), a[l][h] = d, t.real && S && !S[h] && u(S, h, d)));
      };
    }, function (t, e) {
      t.exports = function (t) {
        return t && t.__esModule ? t : {
          default: t
        };
      };
    }, function (t, e, r) {
      var n = r(14);

      t.exports = function (t) {
        if (!n(t)) throw TypeError(String(t) + " is not an object");
        return t;
      };
    }, function (t, e) {
      t.exports = {};
    }, function (t, e) {
      t.exports = !0;
    }, function (t, e) {
      t.exports = function (t) {
        if ("function" != typeof t) throw TypeError(String(t) + " is not a function");
        return t;
      };
    }, function (t, e, r) {
      var n = r(13),
          i = r(61),
          o = r(64),
          a = r(110),
          s = n.Symbol,
          u = i("wks");

      t.exports = function (t) {
        return u[t] || (u[t] = a && s[t] || (a ? s : o)("Symbol." + t));
      };
    }, function (t, e) {
      t.exports = function (t, e) {
        if (!(t instanceof e)) throw new TypeError("Cannot call a class as a function");
      };
    }, function (t, e, r) {
      var n = r(2),
          i = r(119),
          o = r(29),
          a = r(15),
          s = r(90),
          u = r(120),
          f = function (t, e) {
        this.stopped = t, this.result = e;
      };

      (t.exports = function (t, e, r, c, l) {
        var h,
            d,
            p,
            g,
            v,
            y,
            m = a(e, r, c ? 2 : 1);
        if (l) h = t;else {
          if ("function" != typeof (d = s(t))) throw TypeError("Target is not iterable");

          if (i(d)) {
            for (p = 0, g = o(t.length); g > p; p++) if ((v = c ? m(n(y = t[p])[0], y[1]) : m(t[p])) && v instanceof f) return v;

            return new f(!1);
          }

          h = d.call(t);
        }

        for (; !(y = h.next()).done;) if ((v = u(h, m, y.value, c)) && v instanceof f) return v;

        return new f(!1);
      }).stop = function (t) {
        return new f(!0, t);
      };
    }, function (t, e, r) {

      var n = r(1),
          i = n(r(7)),
          o = n(r(32)),
          a = n(r(27)),
          s = n(r(33)),
          u = n(r(265)),
          f = function (t) {
        function e() {
          return (0, i.default)(this, e), (0, o.default)(this, (0, a.default)(e).apply(this, arguments));
        }

        return (0, s.default)(e, t), e;
      }((0, u.default)(Error)),
          c = function (t) {
        function e() {
          return (0, i.default)(this, e), (0, o.default)(this, (0, a.default)(e).apply(this, arguments));
        }

        return (0, s.default)(e, t), e;
      }((0, u.default)(Error)),
          l = function (t) {
        function e() {
          return (0, i.default)(this, e), (0, o.default)(this, (0, a.default)(e).apply(this, arguments));
        }

        return (0, s.default)(e, t), e;
      }(f),
          h = function (t) {
        function e() {
          return (0, i.default)(this, e), (0, o.default)(this, (0, a.default)(e).apply(this, arguments));
        }

        return (0, s.default)(e, t), e;
      }(l),
          d = function (t) {
        function e() {
          return (0, i.default)(this, e), (0, o.default)(this, (0, a.default)(e).apply(this, arguments));
        }

        return (0, s.default)(e, t), e;
      }(f),
          p = function (t) {
        function e() {
          return (0, i.default)(this, e), (0, o.default)(this, (0, a.default)(e).apply(this, arguments));
        }

        return (0, s.default)(e, t), e;
      }(f);

      t.exports = {
        CramBufferOverrunError: h,
        CramMalformedError: l,
        CramUnimplementedError: c,
        CramSizeLimitError: d,
        CramArgumentError: p
      };
    }, function (t, e, r) {
      var n = r(196);

      function i(t, e) {
        for (var r = 0; r < e.length; r++) {
          var i = e[r];
          i.enumerable = i.enumerable || !1, i.configurable = !0, "value" in i && (i.writable = !0), n(t, i.key, i);
        }
      }

      t.exports = function (t, e, r) {
        return e && i(t.prototype, e), r && i(t, r), t;
      };
    }, function (t, e, r) {
      var n = r(3),
          i = r(24),
          o = r(95),
          a = r(21).f;

      t.exports = function (t) {
        var e = n.Symbol || (n.Symbol = {});
        i(e, t) || a(e, t, {
          value: o.f(t)
        });
      };
    }, function (t, e) {
      t.exports = function (t) {
        try {
          return !!t();
        } catch (t) {
          return !0;
        }
      };
    }, function (t, e, r) {
      (function (e) {
        var r = "object",
            n = function (t) {
          return t && t.Math == Math && t;
        };

        t.exports = n(typeof globalThis == r && globalThis) || n(typeof window == r && window) || n(typeof self == r && self) || n(typeof e == r && e) || Function("return this")();
      }).call(this, r(23));
    }, function (t, e) {
      t.exports = function (t) {
        return "object" == typeof t ? null !== t : "function" == typeof t;
      };
    }, function (t, e, r) {
      var n = r(5);

      t.exports = function (t, e, r) {
        if (n(t), void 0 === e) return t;

        switch (r) {
          case 0:
            return function () {
              return t.call(e);
            };

          case 1:
            return function (r) {
              return t.call(e, r);
            };

          case 2:
            return function (r, n) {
              return t.call(e, r, n);
            };

          case 3:
            return function (r, n, i) {
              return t.call(e, r, n, i);
            };
        }

        return function () {
          return t.apply(e, arguments);
        };
      };
    }, function (t, e, r) {
      t.exports = r(167);
    }, function (t, e, r) {
      var n = r(12);
      t.exports = !n(function () {
        return 7 != Object.defineProperty({}, "a", {
          get: function () {
            return 7;
          }
        }).a;
      });
    }, function (t, e, r) {
      var n = r(3);

      t.exports = function (t) {
        return n[t + "Prototype"];
      };
    }, function (t, e, r) {

      (function (t) {
        /*!
         * The buffer module from node.js, for the browser.
         *
         * @author   Feross Aboukhadijeh <feross@feross.org> <http://feross.org>
         * @license  MIT
         */
        var n = r(165),
            i = r(166),
            o = r(105);

        function a() {
          return u.TYPED_ARRAY_SUPPORT ? 2147483647 : 1073741823;
        }

        function s(t, e) {
          if (a() < e) throw new RangeError("Invalid typed array length");
          return u.TYPED_ARRAY_SUPPORT ? (t = new Uint8Array(e)).__proto__ = u.prototype : (null === t && (t = new u(e)), t.length = e), t;
        }

        function u(t, e, r) {
          if (!(u.TYPED_ARRAY_SUPPORT || this instanceof u)) return new u(t, e, r);

          if ("number" == typeof t) {
            if ("string" == typeof e) throw new Error("If encoding is specified then the first argument must be a string");
            return l(this, t);
          }

          return f(this, t, e, r);
        }

        function f(t, e, r, n) {
          if ("number" == typeof e) throw new TypeError('"value" argument must not be a number');
          return "undefined" != typeof ArrayBuffer && e instanceof ArrayBuffer ? function (t, e, r, n) {
            if (e.byteLength, r < 0 || e.byteLength < r) throw new RangeError("'offset' is out of bounds");
            if (e.byteLength < r + (n || 0)) throw new RangeError("'length' is out of bounds");
            e = void 0 === r && void 0 === n ? new Uint8Array(e) : void 0 === n ? new Uint8Array(e, r) : new Uint8Array(e, r, n);
            u.TYPED_ARRAY_SUPPORT ? (t = e).__proto__ = u.prototype : t = h(t, e);
            return t;
          }(t, e, r, n) : "string" == typeof e ? function (t, e, r) {
            "string" == typeof r && "" !== r || (r = "utf8");
            if (!u.isEncoding(r)) throw new TypeError('"encoding" must be a valid string encoding');
            var n = 0 | p(e, r),
                i = (t = s(t, n)).write(e, r);
            i !== n && (t = t.slice(0, i));
            return t;
          }(t, e, r) : function (t, e) {
            if (u.isBuffer(e)) {
              var r = 0 | d(e.length);
              return 0 === (t = s(t, r)).length ? t : (e.copy(t, 0, 0, r), t);
            }

            if (e) {
              if ("undefined" != typeof ArrayBuffer && e.buffer instanceof ArrayBuffer || "length" in e) return "number" != typeof e.length || (n = e.length) != n ? s(t, 0) : h(t, e);
              if ("Buffer" === e.type && o(e.data)) return h(t, e.data);
            }

            var n;
            throw new TypeError("First argument must be a string, Buffer, ArrayBuffer, Array, or array-like object.");
          }(t, e);
        }

        function c(t) {
          if ("number" != typeof t) throw new TypeError('"size" argument must be a number');
          if (t < 0) throw new RangeError('"size" argument must not be negative');
        }

        function l(t, e) {
          if (c(e), t = s(t, e < 0 ? 0 : 0 | d(e)), !u.TYPED_ARRAY_SUPPORT) for (var r = 0; r < e; ++r) t[r] = 0;
          return t;
        }

        function h(t, e) {
          var r = e.length < 0 ? 0 : 0 | d(e.length);
          t = s(t, r);

          for (var n = 0; n < r; n += 1) t[n] = 255 & e[n];

          return t;
        }

        function d(t) {
          if (t >= a()) throw new RangeError("Attempt to allocate Buffer larger than maximum size: 0x" + a().toString(16) + " bytes");
          return 0 | t;
        }

        function p(t, e) {
          if (u.isBuffer(t)) return t.length;
          if ("undefined" != typeof ArrayBuffer && "function" == typeof ArrayBuffer.isView && (ArrayBuffer.isView(t) || t instanceof ArrayBuffer)) return t.byteLength;
          "string" != typeof t && (t = "" + t);
          var r = t.length;
          if (0 === r) return 0;

          for (var n = !1;;) switch (e) {
            case "ascii":
            case "latin1":
            case "binary":
              return r;

            case "utf8":
            case "utf-8":
            case void 0:
              return D(t).length;

            case "ucs2":
            case "ucs-2":
            case "utf16le":
            case "utf-16le":
              return 2 * r;

            case "hex":
              return r >>> 1;

            case "base64":
              return q(t).length;

            default:
              if (n) return D(t).length;
              e = ("" + e).toLowerCase(), n = !0;
          }
        }

        function g(t, e, r) {
          var n = !1;
          if ((void 0 === e || e < 0) && (e = 0), e > this.length) return "";
          if ((void 0 === r || r > this.length) && (r = this.length), r <= 0) return "";
          if ((r >>>= 0) <= (e >>>= 0)) return "";

          for (t || (t = "utf8");;) switch (t) {
            case "hex":
              return O(this, e, r);

            case "utf8":
            case "utf-8":
              return A(this, e, r);

            case "ascii":
              return T(this, e, r);

            case "latin1":
            case "binary":
              return R(this, e, r);

            case "base64":
              return k(this, e, r);

            case "ucs2":
            case "ucs-2":
            case "utf16le":
            case "utf-16le":
              return I(this, e, r);

            default:
              if (n) throw new TypeError("Unknown encoding: " + t);
              t = (t + "").toLowerCase(), n = !0;
          }
        }

        function v(t, e, r) {
          var n = t[e];
          t[e] = t[r], t[r] = n;
        }

        function y(t, e, r, n, i) {
          if (0 === t.length) return -1;

          if ("string" == typeof r ? (n = r, r = 0) : r > 2147483647 ? r = 2147483647 : r < -2147483648 && (r = -2147483648), r = +r, isNaN(r) && (r = i ? 0 : t.length - 1), r < 0 && (r = t.length + r), r >= t.length) {
            if (i) return -1;
            r = t.length - 1;
          } else if (r < 0) {
            if (!i) return -1;
            r = 0;
          }

          if ("string" == typeof e && (e = u.from(e, n)), u.isBuffer(e)) return 0 === e.length ? -1 : m(t, e, r, n, i);
          if ("number" == typeof e) return e &= 255, u.TYPED_ARRAY_SUPPORT && "function" == typeof Uint8Array.prototype.indexOf ? i ? Uint8Array.prototype.indexOf.call(t, e, r) : Uint8Array.prototype.lastIndexOf.call(t, e, r) : m(t, [e], r, n, i);
          throw new TypeError("val must be string, number or Buffer");
        }

        function m(t, e, r, n, i) {
          var o,
              a = 1,
              s = t.length,
              u = e.length;

          if (void 0 !== n && ("ucs2" === (n = String(n).toLowerCase()) || "ucs-2" === n || "utf16le" === n || "utf-16le" === n)) {
            if (t.length < 2 || e.length < 2) return -1;
      