/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.das;

import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.xerces.parsers.DOMParser;
import org.biojava.bio.BioException;
import org.biojava.bio.program.das.DASSequence;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

class DASCapabilities {
    private static Map capabilityCache;
    public static final String CAPABILITY_FEATURETABLE = "featureTable";
    public static final String CAPABILITY_FEATURETABLE_DASGFF = "dasgff";
    public static final String CAPABILITY_FEATURETABLE_XFF = "xff";
    public static final String CAPABILITY_EXTENDED = "dasExtendedRequest";
    public static final String CAPABILITY_EXTENDED_FEATURES = "features";
    public static final String CAPABILITY_INDEX = "index";
    private static final Map DEFAULT_CAPABILITIES;

    static {
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
        hashMap.put(CAPABILITY_FEATURETABLE, Collections.nCopies(1, CAPABILITY_FEATURETABLE_DASGFF));
        DEFAULT_CAPABILITIES = Collections.unmodifiableMap(hashMap);
        capabilityCache = new HashMap();
    }

    DASCapabilities() {
    }

    public static boolean checkCapable(URL uRL, String string) {
        return DASCapabilities.getCapabilities(uRL).containsKey(string);
    }

    public static boolean checkCapable(URL uRL, String string, String string2) {
        List list = (List)DASCapabilities.getCapabilities(uRL).get(string);
        if (list == null) {
            return false;
        }
        return list.contains(string2);
    }

    private static Map fetchCapabilities(URL uRL) {
        try {
            URL uRL2 = new URL(uRL, "capabilities");
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL2.openConnection();
            httpURLConnection.connect();
            int n = httpURLConnection.getHeaderFieldInt("X-DAS-Status", 0);
            if (n == 0) {
                throw new BioException("Not a DAS server");
            }
            if (n != 200) {
                throw new BioException("DAS error (status code = " + n + ") connecting to " + uRL);
            }
            InputSource inputSource = new InputSource(httpURLConnection.getInputStream());
            DOMParser dOMParser = DASSequence.nonvalidatingParser();
            dOMParser.parse(inputSource);
            Element element = dOMParser.getDocument().getDocumentElement();
            HashMap hashMap = new HashMap();
            Node node = element.getFirstChild();
            while (node != null) {
                Element element2;
                if (node instanceof Element && (element2 = (Element)node).getTagName().equals("capability")) {
                    String string = element2.getAttribute("type");
                    String string2 = element2.getAttribute("value");
                    if (hashMap.containsKey(string)) {
                        ((List)hashMap.get(string)).add(string2);
                    } else {
                        ArrayList<String> arrayList = new ArrayList<String>();
                        arrayList.add(string2);
                        hashMap.put(string, arrayList);
                    }
                }
                node = node.getNextSibling();
            }
            return Collections.unmodifiableMap(hashMap);
        }
        catch (Exception exception) {
            return DEFAULT_CAPABILITIES;
        }
    }

    public static Map getCapabilities(URL uRL) {
        Map map = (Map)capabilityCache.get(uRL);
        if (map == null) {
            map = DASCapabilities.fetchCapabilities(uRL);
            capabilityCache.put(uRL, map);
        }
        return map;
    }
}

