/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.dp.onehead;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import org.biojava.bio.BioError;
import org.biojava.bio.BioException;
import org.biojava.bio.dist.Distribution;
import org.biojava.bio.dp.BackPointer;
import org.biojava.bio.dp.DP;
import org.biojava.bio.dp.DPMatrix;
import org.biojava.bio.dp.DotState;
import org.biojava.bio.dp.EmissionState;
import org.biojava.bio.dp.IllegalTransitionException;
import org.biojava.bio.dp.MagicalState;
import org.biojava.bio.dp.MarkovModel;
import org.biojava.bio.dp.ScoreType;
import org.biojava.bio.dp.SimpleStatePath;
import org.biojava.bio.dp.State;
import org.biojava.bio.dp.StatePath;
import org.biojava.bio.dp.onehead.DPCursor;
import org.biojava.bio.dp.onehead.MatrixCursor;
import org.biojava.bio.dp.onehead.SingleDPMatrix;
import org.biojava.bio.dp.onehead.SmallCursor;
import org.biojava.bio.symbol.DoubleAlphabet;
import org.biojava.bio.symbol.GappedSymbolList;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.SimpleAlignment;
import org.biojava.bio.symbol.SimpleSymbolList;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;

public class SingleDP
extends DP
implements Serializable {
    private final HashMap emissionsProb = new HashMap();
    private final HashMap emissionsOdds = new HashMap();
    private final HashMap emissionsNull = new HashMap();

    public SingleDP(MarkovModel markovModel) throws IllegalSymbolException, IllegalTransitionException, BioException {
        super(markovModel);
    }

    private double backward(DPCursor dPCursor, ScoreType scoreType) throws IllegalSymbolException {
        this.backward_initialize(dPCursor, scoreType);
        this.backward_recurse(dPCursor, scoreType);
        return this.backward_termination(dPCursor, scoreType);
    }

    public double backward(SymbolList[] symbolListArray, ScoreType scoreType) throws IllegalSymbolException, IllegalAlphabetException, IllegalSymbolException {
        if (symbolListArray.length != 1) {
            throw new IllegalArgumentException("seq must be 1 long, not " + symbolListArray.length);
        }
        this.lockModel();
        SmallCursor smallCursor = new SmallCursor(this.getStates(), symbolListArray[0], new DP.ReverseIterator(symbolListArray[0]));
        double d = this.backward(smallCursor, scoreType);
        this.unlockModel();
        return d;
    }

    public DPMatrix backwardMatrix(SymbolList[] symbolListArray, DPMatrix dPMatrix, ScoreType scoreType) throws IllegalArgumentException, IllegalSymbolException, IllegalAlphabetException, IllegalSymbolException {
        if (symbolListArray.length != 1) {
            throw new IllegalArgumentException("seq must be 1 long, not " + symbolListArray.length);
        }
        this.lockModel();
        SingleDPMatrix singleDPMatrix = (SingleDPMatrix)dPMatrix;
        MatrixCursor matrixCursor = new MatrixCursor(singleDPMatrix, new DP.ReverseIterator(symbolListArray[0]), -1);
        singleDPMatrix.setScore(this.backward(matrixCursor, scoreType));
        this.unlockModel();
        return singleDPMatrix;
    }

    public DPMatrix backwardMatrix(SymbolList[] symbolListArray, ScoreType scoreType) throws IllegalSymbolException, IllegalAlphabetException, IllegalSymbolException {
        if (symbolListArray.length != 1) {
            throw new IllegalArgumentException("seq must be 1 long, not " + symbolListArray.length);
        }
        this.lockModel();
        SingleDPMatrix singleDPMatrix = new SingleDPMatrix(this, symbolListArray[0]);
        MatrixCursor matrixCursor = new MatrixCursor(singleDPMatrix, new DP.ReverseIterator(symbolListArray[0]), -1);
        singleDPMatrix.setScore(this.backward(matrixCursor, scoreType));
        this.unlockModel();
        return singleDPMatrix;
    }

    private void backward_initialize(DPCursor dPCursor, ScoreType scoreType) throws IllegalSymbolException {
        double[] dArray = dPCursor.currentCol();
        State[] stateArray = this.getStates();
        int n = 0;
        while (n < stateArray.length) {
            dArray[n] = stateArray[n] == this.getModel().magicalState() ? 0.0 : Double.NEGATIVE_INFINITY;
            ++n;
        }
    }

    private void backward_recurse(DPCursor dPCursor, ScoreType scoreType) throws IllegalSymbolException {
        State[] stateArray = this.getStates();
        int n = stateArray.length;
        int[][] nArray = this.getBackwardTransitions();
        double[][] dArray = this.getBackwardTransitionScores(scoreType);
        double[] dArray2 = new double[this.getDotStatesIndex()];
        while (dPCursor.canAdvance()) {
            dPCursor.advance();
            Symbol symbol = dPCursor.lastRes();
            double[] dArray3 = this.getEmission(symbol, scoreType);
            double[] dArray4 = dPCursor.currentCol();
            double[] dArray5 = dPCursor.lastCol();
            int n2 = this.getDotStatesIndex() - 1;
            while (n2 >= 0) {
                dArray2[n2] = dArray3[n2];
                --n2;
            }
            int n3 = n - 1;
            while (n3 >= 0) {
                int n4;
                int[] nArray2 = nArray[n3];
                double[] dArray6 = dArray[n3];
                double d = 0.0;
                int n5 = 0;
                while (n5 < nArray2.length && dArray5[nArray2[n5]] == Double.NEGATIVE_INFINITY) {
                    ++n5;
                }
                double d2 = n5 < nArray2.length ? dArray5[nArray2[n5]] : 0.0;
                int n6 = nArray2.length - 1;
                while (n6 >= 0) {
                    n4 = nArray2[n6];
                    if (n4 < this.getDotStatesIndex()) {
                        double d3 = dArray2[n4];
                        if (dArray5[n4] != Double.NEGATIVE_INFINITY && d3 != Double.NEGATIVE_INFINITY) {
                            double d4 = dArray6[n6];
                            d += Math.exp(d4 + d3 + (dArray5[n4] - d2));
                        }
                    }
                    --n6;
                }
                n4 = nArray2.length - 1;
                while (n4 >= 0) {
                    int n7 = nArray2[n4];
                    if (n7 < this.getDotStatesIndex() || n7 <= n3) break;
                    if (dArray4[n7] != Double.NEGATIVE_INFINITY) {
                        d += Math.exp(dArray6[n4] + (dArray4[n7] - d2));
                    }
                    --n4;
                }
                dArray4[n3] = Math.log(d) + d2;
                --n3;
            }
        }
    }

    private double backward_termination(DPCursor dPCursor, ScoreType scoreType) throws IllegalSymbolException {
        double[] dArray = dPCursor.currentCol();
        State[] stateArray = this.getStates();
        int n = 0;
        while (stateArray[n] != this.getModel().magicalState()) {
            ++n;
        }
        return dArray[n];
    }

    private double forward(DPCursor dPCursor, ScoreType scoreType) throws IllegalSymbolException {
        this.forward_initialize(dPCursor, scoreType);
        this.forward_recurse(dPCursor, scoreType);
        return this.forward_termination(dPCursor, scoreType);
    }

    public double forward(SymbolList[] symbolListArray, ScoreType scoreType) throws IllegalSymbolException, IllegalAlphabetException, IllegalSymbolException {
        if (symbolListArray.length != 1) {
            throw new IllegalArgumentException("seq must be 1 long, not " + symbolListArray.length);
        }
        this.lockModel();
        SmallCursor smallCursor = new SmallCursor(this.getStates(), symbolListArray[0], symbolListArray[0].iterator());
        double d = this.forward(smallCursor, scoreType);
        this.unlockModel();
        return d;
    }

    public DPMatrix forwardMatrix(SymbolList[] symbolListArray, DPMatrix dPMatrix, ScoreType scoreType) throws IllegalArgumentException, IllegalSymbolException, IllegalAlphabetException, IllegalSymbolException {
        if (symbolListArray.length != 1) {
            throw new IllegalArgumentException("seq must be 1 long, not " + symbolListArray.length);
        }
        this.lockModel();
        SingleDPMatrix singleDPMatrix = (SingleDPMatrix)dPMatrix;
        MatrixCursor matrixCursor = new MatrixCursor(singleDPMatrix, symbolListArray[0].iterator(), 1);
        singleDPMatrix.setScore(this.forward(matrixCursor, scoreType));
        this.unlockModel();
        return singleDPMatrix;
    }

    public DPMatrix forwardMatrix(SymbolList[] symbolListArray, ScoreType scoreType) throws IllegalSymbolException, IllegalAlphabetException, IllegalSymbolException {
        if (symbolListArray.length != 1) {
            throw new IllegalArgumentException("seq must be 1 long, not " + symbolListArray.length);
        }
        this.lockModel();
        SingleDPMatrix singleDPMatrix = new SingleDPMatrix(this, symbolListArray[0]);
        MatrixCursor matrixCursor = new MatrixCursor(singleDPMatrix, symbolListArray[0].iterator(), 1);
        singleDPMatrix.setScore(this.forward(matrixCursor, scoreType));
        this.unlockModel();
        return singleDPMatrix;
    }

    private void forward_initialize(DPCursor dPCursor, ScoreType scoreType) throws IllegalSymbolException {
        double[] dArray = dPCursor.currentCol();
        State[] stateArray = this.getStates();
        int n = 0;
        while (n < this.getDotStatesIndex()) {
            dArray[n] = stateArray[n] == this.getModel().magicalState() ? 0.0 : Double.NEGATIVE_INFINITY;
            ++n;
        }
        int[][] nArray = this.getForwardTransitions();
        double[][] dArray2 = this.getForwardTransitionScores(scoreType);
        double[] dArray3 = dPCursor.currentCol();
        int n2 = this.getDotStatesIndex();
        while (n2 < stateArray.length) {
            double d = 0.0;
            int[] nArray2 = nArray[n2];
            double[] dArray4 = dArray2[n2];
            int n3 = 0;
            while (n3 < nArray2.length && dArray3[nArray2[n3]] == Double.NEGATIVE_INFINITY) {
                ++n3;
            }
            double d2 = n3 < nArray2.length ? dArray3[nArray2[n3]] : 0.0;
            int n4 = 0;
            while (n4 < nArray2.length) {
                int n5 = nArray2[n4];
                if (dArray3[n5] != Double.NEGATIVE_INFINITY) {
                    double d3 = dArray4[n4];
                    d += Math.exp(d3 + (dArray3[n5] - d2));
                }
                ++n4;
            }
            dArray3[n2] = Math.log(d) + d2;
            ++n2;
        }
    }

    private void forward_recurse(DPCursor dPCursor, ScoreType scoreType) throws IllegalSymbolException {
        State[] stateArray = this.getStates();
        int n = stateArray.length;
        int[][] nArray = this.getForwardTransitions();
        double[][] dArray = this.getForwardTransitionScores(scoreType);
        while (dPCursor.canAdvance()) {
            int n2;
            Object[] objectArray;
            dPCursor.advance();
            Symbol symbol = dPCursor.currentRes();
            double[] dArray2 = this.getEmission(symbol, scoreType);
            double[] dArray3 = dPCursor.currentCol();
            double[] dArray4 = dPCursor.lastCol();
            int n3 = 0;
            while (n3 < this.getDotStatesIndex()) {
                double d = dArray2[n3];
                if (d == Double.NEGATIVE_INFINITY) {
                    dArray3[n3] = Double.NEGATIVE_INFINITY;
                } else {
                    double d2 = 0.0;
                    objectArray = nArray[n3];
                    double[] dArray5 = dArray[n3];
                    int n4 = 0;
                    while (n4 < objectArray.length && dArray4[objectArray[n4]] == Double.NEGATIVE_INFINITY) {
                        ++n4;
                    }
                    double d3 = n4 < objectArray.length ? dArray4[objectArray[n4]] : 0.0;
                    n2 = 0;
                    while (n2 < objectArray.length) {
                        int n5 = objectArray[n2];
                        if (dArray4[n5] != Double.NEGATIVE_INFINITY) {
                            double d4 = dArray5[n2];
                            d2 += Math.exp(d4 + (dArray4[n5] - d3));
                        }
                        ++n2;
                    }
                    dArray3[n3] = d + Math.log(d2) + d3;
                }
                ++n3;
            }
            int n6 = this.getDotStatesIndex();
            while (n6 < stateArray.length) {
                double d = 0.0;
                int[] nArray2 = nArray[n6];
                objectArray = dArray[n6];
                int n7 = 0;
                while (n7 < nArray2.length && dArray3[nArray2[n7]] == Double.NEGATIVE_INFINITY) {
                    ++n7;
                }
                double d5 = n7 < nArray2.length ? dArray3[nArray2[n7]] : 0.0;
                int n8 = 0;
                while (n8 < nArray2.length) {
                    n2 = nArray2[n8];
                    if (dArray3[n2] != Double.NEGATIVE_INFINITY) {
                        int n9 = objectArray[n8];
                        d += Math.exp(n9 + (dArray3[n2] - d5));
                    }
                    ++n8;
                }
                dArray3[n6] = Math.log(d) + d5;
                ++n6;
            }
        }
    }

    private double forward_termination(DPCursor dPCursor, ScoreType scoreType) throws IllegalSymbolException {
        double[] dArray = dPCursor.currentCol();
        State[] stateArray = this.getStates();
        int n = 0;
        while (stateArray[n] != this.getModel().magicalState()) {
            ++n;
        }
        return dArray[n];
    }

    public double[] getEmission(Symbol symbol, ScoreType scoreType) throws IllegalSymbolException {
        HashMap hashMap;
        if (scoreType == ScoreType.PROBABILITY) {
            hashMap = this.emissionsProb;
        } else if (scoreType == ScoreType.ODDS) {
            hashMap = this.emissionsOdds;
        } else if (scoreType == ScoreType.NULL_MODEL) {
            hashMap = this.emissionsNull;
        } else {
            throw new BioError("Unknown ScoreType object: " + scoreType);
        }
        double[] dArray = (double[])hashMap.get(symbol);
        if (dArray == null) {
            int n = this.getDotStatesIndex();
            dArray = new double[n];
            State[] stateArray = this.getStates();
            int n2 = 0;
            while (n2 < n) {
                EmissionState emissionState = (EmissionState)stateArray[n2];
                Distribution distribution = emissionState.getDistribution();
                dArray[n2] = Math.log(scoreType.calculateScore(distribution, symbol));
                ++n2;
            }
            hashMap.put(symbol, dArray);
        }
        return dArray;
    }

    public void update() {
        super.update();
        if (this.emissionsProb != null) {
            this.emissionsProb.clear();
        }
        if (this.emissionsOdds != null) {
            this.emissionsOdds.clear();
        }
        if (this.emissionsNull != null) {
            this.emissionsNull.clear();
        }
    }

    private StatePath viterbi(DPCursor dPCursor, ScoreType scoreType) throws IllegalSymbolException {
        Object object;
        int n;
        int n2;
        double d;
        double d2;
        int n3;
        double[] dArray;
        Object object2;
        this.lockModel();
        int n4 = dPCursor.length();
        State[] stateArray = this.getStates();
        int[][] nArray = this.getForwardTransitions();
        double[][] dArray2 = this.getForwardTransitionScores(scoreType);
        int n5 = stateArray.length;
        Object object3 = new BackPointer[n5];
        BackPointer[] backPointerArray = new BackPointer[n5];
        double[] dArray3 = dPCursor.currentCol();
        double[] dArray4 = dPCursor.lastCol();
        int n6 = 0;
        while (n6 < this.getDotStatesIndex()) {
            if (stateArray[n6] == this.getModel().magicalState()) {
                dArray4[n6] = 0.0;
                dArray3[n6] = 0.0;
                object3[n6] = backPointerArray[n6] = new BackPointer(stateArray[n6]);
            } else {
                dArray4[n6] = Double.NEGATIVE_INFINITY;
                dArray3[n6] = Double.NEGATIVE_INFINITY;
            }
            ++n6;
        }
        int n7 = this.getDotStatesIndex();
        while (n7 < n5) {
            object2 = nArray[n7];
            dArray = dArray2[n7];
            double d3 = Double.NEGATIVE_INFINITY;
            double d4 = Double.NEGATIVE_INFINITY;
            n3 = -1;
            int n8 = 0;
            while (n8 < ((int[])object2).length) {
                d2 = dArray[n8];
                int n9 = object2[n8];
                d = dArray3[n9];
                double d5 = d2 + d;
                if (d5 > d3) {
                    d3 = d5;
                    n3 = n9;
                    d4 = d2;
                }
                ++n8;
            }
            if (n3 != -1) {
                dArray3[n7] = dArray4[n7] = d3;
                object3[n7] = backPointerArray[n7] = new BackPointer(stateArray[n7], backPointerArray[n3], d4);
            } else {
                dArray4[n7] = Double.NEGATIVE_INFINITY;
                dArray3[n7] = Double.NEGATIVE_INFINITY;
                backPointerArray[n7] = null;
                object3[n7] = null;
            }
            ++n7;
        }
        while (dPCursor.canAdvance()) {
            dPCursor.advance();
            object2 = dPCursor.currentRes();
            dArray = this.getEmission((Symbol)object2, scoreType);
            double[] dArray5 = dPCursor.currentCol();
            double[] dArray6 = dPCursor.lastCol();
            int n10 = 0;
            while (n10 < stateArray.length) {
                double d6 = n10 < this.getDotStatesIndex() ? dArray[n10] : 0.0;
                int[] nArray2 = nArray[n10];
                double[] dArray7 = dArray2[n10];
                if (d6 == Double.NEGATIVE_INFINITY) {
                    dArray5[n10] = Double.NEGATIVE_INFINITY;
                    backPointerArray[n10] = null;
                } else {
                    d2 = Double.NEGATIVE_INFINITY;
                    d = Double.NEGATIVE_INFINITY;
                    int n11 = -1;
                    n2 = 0;
                    while (n2 < nArray2.length) {
                        n = nArray2[n2];
                        double d7 = dArray7[n2];
                        double d8 = n10 < this.getDotStatesIndex() ? dArray6[n] : dArray5[n];
                        double d9 = d7 + d8;
                        if (d9 > d2) {
                            d2 = d9;
                            n11 = n;
                            d = d7;
                        }
                        ++n2;
                    }
                    if (n11 != -1) {
                        dArray5[n10] = d2 + d6;
                        backPointerArray[n10] = new BackPointer(stateArray[n10], n10 < this.getDotStatesIndex() ? object3[n11] : backPointerArray[n11], d + d6);
                    } else {
                        dArray5[n10] = Double.NEGATIVE_INFINITY;
                        backPointerArray[n10] = null;
                    }
                }
                ++n10;
            }
            object = backPointerArray;
            backPointerArray = object3;
            object3 = object;
        }
        object2 = null;
        double d10 = Double.NaN;
        int n12 = 0;
        while (n12 < n5) {
            if (stateArray[n12] == this.getModel().magicalState()) {
                object2 = object3[n12].back;
                d10 = dPCursor.currentCol()[n12];
                break;
            }
            ++n12;
        }
        int n13 = 0;
        object = object2;
        n3 = 0;
        int n14 = 0;
        while (object.back != object) {
            ++n13;
            if (object.state instanceof EmissionState) {
                ++n14;
            } else {
                ++n3;
            }
            object = object.back;
        }
        HashMap<SymbolList, SymbolList> hashMap = new HashMap<SymbolList, SymbolList>();
        hashMap.put(dPCursor.symList(), dPCursor.symList());
        SimpleAlignment simpleAlignment = new SimpleAlignment(hashMap);
        GappedSymbolList gappedSymbolList = new GappedSymbolList(simpleAlignment);
        double[] dArray8 = new double[n13];
        ArrayList<State> arrayList = new ArrayList<State>(n13);
        int n15 = 0;
        while (n15 < n13) {
            arrayList.add(null);
            ++n15;
        }
        object = object2;
        n2 = dPCursor.symList().length() + 1;
        n = n13;
        int n16 = 0;
        while (object.back != object) {
            --n;
            if (object.state instanceof MagicalState) {
                object = object.back;
                continue;
            }
            arrayList.set(n, object.state);
            if (object.state instanceof DotState) {
                gappedSymbolList.addGapInSource(n2);
                ++n16;
            } else {
                --n2;
            }
            dArray8[n] = object.score;
            object = object.back;
        }
        this.unlockModel();
        return new SimpleStatePath(d10, gappedSymbolList, new SimpleSymbolList(this.getModel().stateAlphabet(), arrayList), DoubleAlphabet.fromArray(dArray8));
    }

    public StatePath viterbi(SymbolList[] symbolListArray, ScoreType scoreType) throws IllegalSymbolException {
        SymbolList symbolList = symbolListArray[0];
        SmallCursor smallCursor = new SmallCursor(this.getStates(), symbolList, symbolList.iterator());
        return this.viterbi(smallCursor, scoreType);
    }
}

