## ----echo=FALSE, results="hide"-----------------------------------------------
options("knitr.graphics.auto_pdf"=TRUE)

## ----eval=FALSE---------------------------------------------------------------
# if (!require("BiocManager", quietly = TRUE))
#     install.packages("BiocManager")
# 
# BiocManager::install(version="devel")
# BiocManager::install("crisprScore")

## ----eval=FALSE---------------------------------------------------------------
# options(reticulate.useImportHook=FALSE)

## ----warnings=FALSE, message=FALSE--------------------------------------------
library(crisprScore)

## -----------------------------------------------------------------------------
data(scoringMethodsInfo)
print(scoringMethodsInfo)

## ----echo=FALSE,fig.cap="Sequence inputs for Cas9 scoring methods"------------
knitr::include_graphics("./figures/sequences_cas9_v2.svg")

## ----eval=TRUE----------------------------------------------------------------
flank5 <- "ACCT" #4bp
spacer <- "ATCGATGCTGATGCTAGATA" #20bp
pam    <- "AGG" #3bp 
flank3 <- "TTG" #3bp
input  <- paste0(flank5, spacer, pam, flank3) 
results <- getRuleSet1Scores(input)

## ----eval=FALSE---------------------------------------------------------------
# flank5 <- "ACCT" #4bp
# spacer <- "ATCGATGCTGATGCTAGATA" #20bp
# pam    <- "AGG" #3bp
# flank3 <- "TTG" #3bp
# input  <- paste0(flank5, spacer, pam, flank3)

## ----eval=FALSE---------------------------------------------------------------
# condaEnv <- "/Users/fortin946/miniforge3/envs/rs3-env"
# results <- getRuleSet3Scores(input, tracrRNA="Hsu2013", condaEnv=condaEnv)

## ----eval=FALSE---------------------------------------------------------------
# spacer  <- "ATCGATGCTGATGCTAGATA" #20bp
# pam     <- "AGG" #3bp
# input   <- paste0(spacer, pam)
# condaEnv <- "/Users/fortin946/miniforge3/envs/deephf-env"
# results <- getDeepHFScores(input, condaEnv=condaEnv)

## ----eval=TRUE----------------------------------------------------------------
flank5 <- "ACCTAA" #6bp
spacer <- "ATCGATGCTGATGCTAGATA" #20bp
pam    <- "AGG" #3bp 
flank3 <- "TTGAAT" #6bp
input  <- paste0(flank5, spacer, pam, flank3) 
results <- getCRISPRscanScores(input)

## ----eval=TRUE----------------------------------------------------------------
spacer <- "ATCGATGCTGATGCTAGATA" #20bp
results <- getCRISPRaterScores(spacer)

## ----echo=FALSE, fig.cap="Sequence inputs for Cas12a scoring methods"---------
knitr::include_graphics("./figures/sequences_cas12a_v2.svg")

## ----eval=FALSE---------------------------------------------------------------
# flank5 <- "ACCG" #4bp
# pam    <- "TTTT" #4bp
# spacer <- "AATCGATGCTGATGCTAGATATT" #23bp
# flank3 <- "AAG" #3bp
# input  <- paste0(flank5, pam, spacer, flank3)
# condaEnv <- "/Users/fortin946/miniforge3/envs/enpamgb-env"
# results <- getEnPAMGBScores(input, condaEnv=condaEnv)

## ----eval=FALSE---------------------------------------------------------------
# fasta <- file.path(system.file(package="crisprScore"),
#                    "casrxrf/test.fa")
# mrnaSequence <- Biostrings::readDNAStringSet(filepath=fasta
#                                              format="fasta",
#                                              use.names=TRUE)
# results <- getCasRxRFScores(mrnaSequence)

## -----------------------------------------------------------------------------
spacer   <- "ATCGATGCTGATGCTAGATA"
protospacers  <- c("ACCGATGCTGATGCTAGATA",
                   "ATCGATGCTGATGCTAGATT",
                   "ATCGATGCTGATGCTAGATA")
pams <- c("AGG", "AGG", "AGA")
getMITScores(spacers=spacer,
             protospacers=protospacers,
             pams=pams)

## -----------------------------------------------------------------------------
spacer   <- "ATCGATGCTGATGCTAGATA"
protospacers  <- c("ACCGATGCTGATGCTAGATA",
                   "ATCGATGCTGATGCTAGATT",
                   "ATCGATGCTGATGCTAGATA")
pams <- c("AGG", "AGG", "AGA")
getCFDScores(spacers=spacer,
             protospacers=protospacers,
             pams=pams)

## ----eval=FALSE---------------------------------------------------------------
# flank5 <- "ACCTTTTAATCGA" #13bp
# spacer <- "TGCTGATGCTAGATATTAAG" #20bp
# pam    <- "TGG" #3bp
# flank3 <- "CTTTTAATCGATGCTGATGCTAGATATTA" #29bp
# input <- paste0(flank5, spacer, pam, flank3)
# condaEnv <- "/Users/fortin946/miniforge3/envs/lindel-env"
# results <- getLindelScores(input, condaEnv=condaEnv)

## -----------------------------------------------------------------------------
sessionInfo()

