% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PAC_analyze.R
\name{PAC_analyze}
\alias{PAC_analyze}
\title{PAC_analyze}
\usage{
PAC_analyze(
  PAC,
  pheno_target = NULL,
  norm = NULL,
  anno_target = NULL,
  model = NULL
)
}
\arguments{
\item{PAC}{PAC-object containing Anno and a summary list-folder with
summarized dataframe(s) for example generated by PAC_summary. The function
can also be applied on a dataframe containing a column with annotation
groupings (e.g. biotype) and a column with summarized data (e.g. log2 fold
changes). Rows should be unique sequences as the rownames of a PAC summary
object.}

\item{pheno_target}{List with: 1st object being a character vector
of target column in Pheno and 2nd object being a character vector of the target
group(s) in the target Pheno column (1st object).}

\item{norm}{Character indicating what type of data to be used. If 'counts',
the raw counts in Counts will be used (default). If "cpm", cpm values will 
be used. As of now, only "counts" and "cpm" may be used for this wrapper.}

\item{anno_target}{Character vector with the name of the target column in
Anno or the name of the annotation column in case of input being a
dataframe.}

\item{model}{Character of model used to run \code{PAC_deseq}.}
}
\value{
a list of plots in R, and a pdf file in home directory called
"Results_seqpac.pdf".
}
\description{
Given a PAC object and targets, this wrapper will perform several analyses of 
the PAC object and return a PDF with plots. More specifically, the plot
will contain a jitterplot of fold changes, stack bar of mean counts/cpm,
size distribution stack bars, piecharts, PCA plots, and if  specified, a 
volcano plot based off adjusted p-values and fold changes from a DESeq2 analysis.
}
\examples{

load(system.file("extdata", "drosophila_sRNA_pac_filt_anno.Rdata", 
                 package = "seqpac", mustWork = TRUE))

                 
result_list <- PAC_analyze(pac, 
  pheno_target=list("stage"),
  norm="cpm", 
  anno_target=list("Biotypes_mis0"),
  model=~stage+batch)

}
