## ----echo=FALSE, results="hide", warning=FALSE--------------------------------
suppressPackageStartupMessages({
library('highthroughputassays')
})

## ----echo=FALSE, results="hide", warning=FALSE--------------------------------
suppressPackageStartupMessages(library(flowCore))
suppressPackageStartupMessages(library(flowStats))
suppressPackageStartupMessages(library(flowWorkspace))
suppressPackageStartupMessages(library(ggcyto))
suppressPackageStartupMessages(library(scales))

## -----------------------------------------------------------------------------
## Load packages
library(flowCore)
library(flowStats)
library(flowWorkspace)
library(ggcyto)
library(scales)

## Load data
data(ITN)
ITN

## -----------------------------------------------------------------------------
## Create a workflow instance and transform data using asinh
gs <- GatingSet(ITN)
trans.obj <- trans_new("myAsinh", transform=asinh, inverse=sinh)
tl <- transformerList(colnames(ITN)[3:7], trans.obj)
gs <- transform(gs, tl)


## -----------------------------------------------------------------------------
## Identify T-cells population
lg <- lymphGate(gs_cyto_data(gs), channels=c("CD3", "SSC"),
                preselection="CD4", filterId="TCells",
                scale=2.5)
gs_pop_add(gs, lg)
recompute(gs)

ggcyto(gs, aes(x = CD3, y = SSC)) + geom_hex(bins = 32) + geom_gate("TCells")


## ----eval=FALSE---------------------------------------------------------------
# if (!"BiocManager" %in% rownames(installed.packages()))
#      install.packages("BiocManager")
# BiocManager::install("flowCore")

## ----eval=FALSE---------------------------------------------------------------
# library("flowCore")

## ----eval=FALSE---------------------------------------------------------------
# browseVignettes(package="flowCore")

## ----eval=FALSE---------------------------------------------------------------
# help.start()

## -----------------------------------------------------------------------------
sessionInfo()

