% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prvaco.R
\name{pvcAnaly}
\alias{pvcAnaly}
\title{Principal variance Component Analysis}
\usage{
pvcAnaly(exp_datObj, pct_threshold, batch_factors)
}
\arguments{
\item{exp_datObj}{an expression set class object}

\item{pct_threshold}{PVCA Threshold Value (a value between 0 and 1) is the percentile
value of the minimum amount of the variabilities that the selected principal components need to explain}

\item{batch_factors}{a list of covariates whose effect size on the expression data  is to be determined}
}
\value{
dat A numerical vector that contains the percentile of sources of batch effect for each covariate term

label A character vector containing the name for each covariate term
}
\description{
PVCA estimates the variance in the expression dataset  due to 
each of the given covariates and attributes the remaining fraction to residual.
It efficiently combines principal component analysis
}
\note{
The return values of the function can be accessed as <variable>$<parameter>
}
\author{
Karthikeyan  Murugesan <karthikeyanm60 at yahoo.com>
}
\references{
Bushel P (2013). pvca: Principal Variance Component Analysis (PVCA).R package version 1.6.0.
}
\seealso{
\code{\link{pvcaBatchAssess}}
#@examples
pvcAnaly(exp_datObj, pct_threshold, batch_factors)
}
\keyword{Analysis,}
\keyword{Component}
\keyword{PCA}
\keyword{Principal}
\keyword{VCA,}
\keyword{Variance}

