% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io_handling.R
\name{target_generation}
\alias{target_generation}
\title{Function to generate targets file
Load target file if it exists, otherwise use the -C and -T flags.
Note target takes precedence over target.}
\usage{
target_generation(from_file = NULL, ctrl_samples = NULL, treat_samples = NULL)
}
\arguments{
\item{from_file}{input targets file}

\item{ctrl_samples}{control samples}

\item{treat_samples}{target samples}
}
\value{
targets info loaded
}
\description{
Function to generate targets file
Load target file if it exists, otherwise use the -C and -T flags.
Note target takes precedence over target.
}
\examples{
# To generate target or load from file. 
# Example shows generation based on names of treament/control samples.
# These should match the column names in the table of counts.
case_sample_names <- paste("case", seq(5), sep="_")
control_sample_names <- paste("control", seq(5), sep="_")
target <- target_generation(ctrl_samples=control_sample_names, 
                            treat_samples=case_sample_names)
}
\keyword{design}
