% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vis_image.R
\name{vis_image}
\alias{vis_image}
\title{Sample image visualization}
\usage{
vis_image(
  spe,
  sampleid = unique(spe$sample_id)[1],
  image_id = "lowres",
  auto_crop = TRUE,
  is_stitched = FALSE,
  title_suffix = NULL
)
}
\arguments{
\item{spe}{A
\link[SpatialExperiment:SpatialExperiment]{SpatialExperiment-class}
object. See \code{\link[=fetch_data]{fetch_data()}} for how to download some example objects or
\code{\link[=read10xVisiumWrapper]{read10xVisiumWrapper()}} to read in \code{spaceranger --count} output files and
build your own \code{spe} object.}

\item{sampleid}{A \code{character(1)} specifying which sample to plot from
\code{colData(spe)$sample_id} (formerly \code{colData(spe)$sample_name}).}

\item{image_id}{A \code{character(1)} with the name of the image ID you want to
use in the background.}

\item{auto_crop}{A \code{logical(1)} indicating whether to automatically crop
the image / plotting area, which is useful if the Visium capture area is
not centered on the image and if the image is not a square.}

\item{is_stitched}{A \code{logical(1)} vector: If \code{TRUE}, expects a
\link[SpatialExperiment:SpatialExperiment]{SpatialExperiment-class} built
with \code{visiumStitched::build_spe()}.
\url{http://research.libd.org/visiumStitched/reference/build_spe.html}; in
particular, expects a logical colData column \code{exclude_overlapping}
specifying which spots to exclude from the plot. Sets \code{auto_crop = FALSE}.}

\item{title_suffix}{A \code{character(1)} passed to \link[base:paste]{paste()} to
modify the title of the plot following the \code{sampleid}.}
}
\value{
A \link[ggplot2:ggplot]{ggplot2} object.
}
\description{
This function visualizes the histology image for selected sample. Matches
crop and settings of \code{\link[=vis_clus]{vis_clus()}} and \code{\link[=vis_gene]{vis_gene()}}.
}
\details{
This function subsets \code{spe} to the given sample and prepares the
data and title for \code{\link[=vis_clus_p]{vis_clus_p()}}.
}
\examples{

if (enough_ram()) {
  ## Obtain the necessary data
  if (!exists("spe")) spe <- fetch_data("spe")

  ## Print the "lowres" image for sample 151673
  p1 <- vis_image(
    spe = spe,
    sampleid = "151673"
  )
  print(p1)

  ## Without auto-cropping the image
  p2 <- vis_image(
    spe = spe,
    sampleid = "151673",
    auto_crop = FALSE
  )
  print(p2)
}
}
\seealso{
Other Spatial cluster visualization functions: 
\code{\link{frame_limits}()},
\code{\link{vis_clus}()},
\code{\link{vis_clus_p}()},
\code{\link{vis_grid_clus}()}
}
\concept{Spatial cluster visualization functions}
