% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/img_update.R
\name{img_update}
\alias{img_update}
\title{Update the image for one sample}
\usage{
img_update(
  spe,
  sampleid,
  image_id = "lowres",
  new_image_id = paste0("edited_", image_id),
  overwrite = FALSE,
  ...
)
}
\arguments{
\item{spe}{A
\link[SpatialExperiment:SpatialExperiment]{SpatialExperiment-class}
object. See \code{\link[=fetch_data]{fetch_data()}} for how to download some example objects or
\code{\link[=read10xVisiumWrapper]{read10xVisiumWrapper()}} to read in \code{spaceranger --count} output files and
build your own \code{spe} object.}

\item{sampleid}{A \code{character(1)} specifying which sample to plot from
\code{colData(spe)$sample_id} (formerly \code{colData(spe)$sample_name}).}

\item{image_id}{A \code{character(1)} with the name of the image ID you want to
use in the background.}

\item{new_image_id}{A \code{character(1)} specifying the new \code{image_id} to use.}

\item{overwrite}{A \code{logical(1)} specifying whether to overwrite the
\code{image_id} if it already exists.}

\item{...}{Parameters passed to \code{img_edit()}.}
}
\value{
A
\link[SpatialExperiment:SpatialExperiment]{SpatialExperiment-class}  object
with an updated \code{imgData()} slot.
}
\description{
Edit the image with \code{img_edit()} then update the \code{imgData()}.
}
\examples{
if (enough_ram()) {
    ## Obtain the necessary data
    if (!exists("spe")) spe <- fetch_data("spe")

    ## Reduce brightness to 25\% and update the imgData()
    imgData(img_update(spe, sampleid = "151507", brightness = 25))
}
}
\seealso{
Other Image editing functions: 
\code{\link{img_edit}()},
\code{\link{img_update_all}()}
}
\concept{Image editing functions}
