% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/img_edit.R
\name{img_edit}
\alias{img_edit}
\title{Edit a background image}
\usage{
img_edit(
  spe,
  sampleid,
  image_id = "lowres",
  channel = NA,
  brightness = 100,
  saturation = 100,
  hue = 100,
  enhance = FALSE,
  contrast_sharpen = NA,
  quantize_max = NA,
  quantize_dither = TRUE,
  equalize = FALSE,
  normalize = FALSE,
  transparent_color = NA,
  transparent_fuzz = 0,
  background_color = NA,
  median_radius = NA,
  negate = FALSE
)
}
\arguments{
\item{spe}{A
\link[SpatialExperiment:SpatialExperiment]{SpatialExperiment-class}
object. See \code{\link[=fetch_data]{fetch_data()}} for how to download some example objects or
\code{\link[=read10xVisiumWrapper]{read10xVisiumWrapper()}} to read in \code{spaceranger --count} output files and
build your own \code{spe} object.}

\item{sampleid}{A \code{character(1)} specifying which sample to plot from
\code{colData(spe)$sample_id} (formerly \code{colData(spe)$sample_name}).}

\item{image_id}{A \code{character(1)} with the name of the image ID you want to
use in the background.}

\item{channel}{A \code{character(1)} passed to
\link[magick:color]{magick::image_channel}. If \code{NA} this step is skipped.}

\item{brightness}{A \code{numeric(1)} passed to
\link[magick:color]{magick::image_modulate}.}

\item{saturation}{A \code{numeric(1)} passed to
\link[magick:color]{magick::image_modulate}.}

\item{hue}{A \code{numeric(1)} passed to \link[magick:color]{magick::image_modulate}.}

\item{enhance}{A \code{logical(1)} controlling whether to use
\link[magick:color]{magick::enhance}.}

\item{contrast_sharpen}{A \code{numeric(1)} passed to
\link[magick:color]{magick::image_contrast}. If \code{NA} this step is skipped.}

\item{quantize_max}{A \code{numeric(1)} passed to
\link[magick:color]{magick::image_quantize}. If \code{NA} this step is skipped.}

\item{quantize_dither}{A \code{logical(1)} passed to
\link[magick:color]{magick::image_quantize}.}

\item{equalize}{A \code{logical(1)} controlling whether to use
\link[magick:color]{magick::equalize}.}

\item{normalize}{A \code{logical(1)} controlling whether to use
\link[magick:color]{magick::normalize}.}

\item{transparent_color}{A \code{character(1)} passed to
\link[magick:color]{magick::image_transparent}. If \code{NA} this step is skipped.}

\item{transparent_fuzz}{A \code{numeric(1)} passed to
\link[magick:color]{magick::image_transparent}.}

\item{background_color}{A \code{character(1)} passed to
\link[magick:color]{magick::image_background}. If \code{NA} this step is skipped.}

\item{median_radius}{A \code{numeric(1)} passed to
\link[magick:color]{magick::image_median}. If \code{NA} this step is skipped.}

\item{negate}{A \code{logical(1)} controlling whether to use
\link[magick:color]{magick::negate}.}
}
\value{
A \code{magick} image object such as the one returned by
\link[magick:editing]{magick::image_read}.
}
\description{
This function uses the \code{magick} package to edit the color and perform other
image manipulations on a background image. It can be useful if you want to
highlight certain features of these images.
}
\details{
The \code{magick} functions are used in the sequence represented by the arguments
to this function. You can alternatively use this function sequentially. Or
directly use the \code{magick} package.
}
\examples{
if (enough_ram()) {
    ## Obtain the necessary data
    if (!exists("spe")) spe <- fetch_data("spe")

    ## Reduce brightness to 25\%
    x <- img_edit(spe, sampleid = "151507", brightness = 25)
    plot(x)
}
}
\seealso{
Other Image editing functions: 
\code{\link{img_update}()},
\code{\link{img_update_all}()}
}
\concept{Image editing functions}
