% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_images.R
\name{add_images}
\alias{add_images}
\title{Add non-standard images with the same dimensions as current ones}
\usage{
add_images(
  spe,
  image_dir,
  image_pattern,
  image_id_current = "lowres",
  image_id = image_pattern,
  image_paths = locate_images(spe, image_dir, image_pattern)
)
}
\arguments{
\item{spe}{A
\link[SpatialExperiment:SpatialExperiment]{SpatialExperiment-class}
object. See \code{\link[=fetch_data]{fetch_data()}} for how to download some example objects or
\code{\link[=read10xVisiumWrapper]{read10xVisiumWrapper()}} to read in \code{spaceranger --count} output files and
build your own \code{spe} object.}

\item{image_dir}{A \code{character(1)} specifying a path to a directory containing
image files with the pattern \code{sampleID_pattern.png}.}

\item{image_pattern}{A \code{character(1)} specifying the pattern for the image
files.}

\item{image_id_current}{A \code{character(1)} specifying the name of the current
existing image in \code{spe} that has the same scaling factor that to be used
with the additional images.}

\item{image_id}{A \code{character(1)} specifying the name to use in the new
images. It cannot be the same as one used for existing images in \code{spe} for a
given sample. It equals \code{image_pattern} by default.}

\item{image_paths}{A named \code{character()} vector with the paths to the images.
The names have to match the \code{spe$sample_id} and cannot be repeated. By
default \code{locate_images()} is used but you can alternatively specify
\code{image_paths} and ignore \code{image_dir} and \code{image_pattern}.}
}
\value{
A
\link[SpatialExperiment:SpatialExperiment]{SpatialExperiment-class} object
with the additional image data in \code{imgData(spe)}.
}
\description{
This function re-uses the \code{SpatialExperiment::scaleFactors()} from current
images when adding new images. This is useful if you take for example a
multi-channel VisiumIF image and break into several single-channel images
that all have the same dimensions. So you could have a set of images such as
\code{channel_01_lowres} and \code{channel_02_lowres} that have the same dimensions
and viewing area as the \code{lowres} image produced by SpaceRanger, each with
only one channel. Similarly, you might have done some image manipulation for
a given image and generated one or more images with the same dimensions as
existing images.
}
\examples{
if (enough_ram()) {
    ## Obtain the necessary data
    if (!exists("spe")) spe <- fetch_data("spe")

    ## Add an image
    SpatialExperiment::imgData(add_images(
        spe,
        image_id_current = "lowres",
        image_id = "lowres_aws",
        image_paths = c("151507" = "https://spatial-dlpfc.s3.us-east-2.amazonaws.com/images/151507_tissue_lowres_image.png")
    ))
}
}
\seealso{
Other Functions for adding non-standard images: 
\code{\link{locate_images}()}
}
\concept{Functions for adding non-standard images}
