% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getKdModels.R
\name{getKdModels}
\alias{getKdModels}
\title{getKdModels}
\usage{
getKdModels(species = c("hsa", "mmu", "rno"), categories = NULL)
}
\arguments{
\item{species}{Either "hsa" (human), "mmu" (mouse) or "rno" (rat)}

\item{categories}{The categories of miRNAs to return. Any
combination of "Low-confidence", "Poorly conserved",
"Conserved across mammals", "Conserved across vertebrates". If NULL
(default), all categories are returned. miRNAs with NA as
conservation are not returned  unless `categories==NULL`.}
}
\value{
An object of class \code{\link[scanMiR]{KdModelList}}
}
\description{
Returns a collection of miRNA KdModels for the requested species.
\emph{Note that by default, low-confidence miRNAs are not returned}
(see `categories`).
}
\examples{
mods <- getKdModels("rno")
summary(mods)
}
