#' @rdname KdModels-hsa
#' @name KdModels-hsa
#' @aliases KdModels-hsa, hsa
#'
#' @title KdModelList for human miRNAs
#'
#' @description
#' A list of binding affinity models (\code{\link[scanMiR]{KdModel}}) for human
#' ('hsa'), mouse ('mmu'), or rat ('rno') miRbase 21.1 miRNAs. These represent
#' the miRNA 12-mer binding affinities predicted using the CNN from
#' McGeary, Lin et al. (2019).
#'
#' @return a \code{\link[scanMiR]{KdModelList}} list.
NULL

#' @rdname KdModels-mmu
#' @name KdModels-mmu
#' @aliases KdModels-mmu, mmu
#'
#' @title KdModelList for mouse miRNAs
#'
#' @description
#' A list of binding affinity models (\code{\link[scanMiR]{KdModel}}) for mouse
#' miRbase 21.1 miRNAs. These represent the miRNA 12-mer binding affinities
#' predicted using the CNN from McGeary, Lin et al. (2019).
#'
#' @return a \code{\link[scanMiR]{KdModelList}} list.
NULL

#' @rdname KdModels-rno
#' @name KdModels-rno
#' @aliases KdModels-rno, rno
#'
#' @title KdModelList for rat miRNAs
#'
#' @description
#' A list of binding affinity models (\code{\link[scanMiR]{KdModel}}) for rat
#' miRbase 21.1 miRNAs. These represent the miRNA 12-mer binding affinities
#' predicted using the CNN from McGeary, Lin et al. (2019).
#'
#' @return a \code{\link[scanMiR]{KdModelList}} list.
NULL
