% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ZhaoImmuneLiverData.R
\name{ZhaoImmuneLiverData}
\alias{ZhaoImmuneLiverData}
\title{Obtain the Zhao immune liver data}
\usage{
ZhaoImmuneLiverData(location = TRUE, filter = FALSE, legacy = FALSE)
}
\arguments{
\item{location}{Logical scalar indicating whether genomic coordinates should be returned.}

\item{filter}{Logical scalar indicating if the filtered subset should be returned.}

\item{legacy}{Logical scalar indicating whether to pull data from ExperimentHub.
By default, we use data from the gypsum backend.}
}
\value{
A \link[SingleCellExperiment]{SingleCellExperiment} object with a single matrix of UMI counts.
}
\description{
Obtain the human liver immune single-cell RNA-seq data from Zhao et al. (2020).
}
\details{
Column metadata contains various cell labels as provided by the authors.
Some of these labels required assembly on our part:
\itemize{
\item The \code{broad} label was assigned to each barcode based on whether that barcode was present in each \code{*_identities.tsv.gz} in GSE125188's supplementary files.
\item For each cell barcode that was present in one of these files, the \code{fine} label was generated from the \code{Group} annotations inside that file.
}
We guessed the \code{sample} for each cell by assuming that the GEM group numbers match the order of samples in GSE125188.
We also assumed that \dQuote{donor 4} is a typo, given that the paper only mentions 3 donors.

If \code{location=TRUE}, the coordinates of the Ensembl gene models are stored in the \code{\link[SummarizedExperiment]{rowRanges}} of the output.
Note that this is only performed if \code{ensembl=TRUE}.

If \code{filter=TRUE}, only cells that have been used in the original analysis are returned.
Otherwise, the cells used are specified in the \code{retained} column of the \code{\link[SummarizedExperiment]{colData}}.

All data are downloaded from ExperimentHub and cached for local re-use.
Specific resources can be retrieved by searching for \code{scRNAseq/zhao-immune-liver}.
}
\examples{
sce.zhao <- ZhaoImmuneLiverData()

}
\references{
Zhao J et al. (2020). 
Single-cell RNA sequencing reveals the heterogeneity of liver-resident immune cells in human.
\emph{Cell Discov} 6, 22.
}
\author{
Aaron Lun
}
