% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/XinPancreasData.R
\name{XinPancreasData}
\alias{XinPancreasData}
\title{Obtain the Xin pancreas data}
\usage{
XinPancreasData(ensembl = FALSE, location = TRUE, legacy = FALSE)
}
\arguments{
\item{ensembl}{Logical scalar indicating whether the output row names should contain Ensembl identifiers.}

\item{location}{Logical scalar indicating whether genomic coordinates should be returned.}

\item{legacy}{Logical scalar indicating whether to pull data from ExperimentHub.
By default, we use data from the gypsum backend.}
}
\value{
A \link[SingleCellExperiment]{SingleCellExperiment} object with a single matrix of RPKMs.
}
\description{
Obtain the human pancreas single-cell RNA-seq dataset from Xin et al. (2016).
}
\details{
Row data contains fields for the Entrez ID and symbol for each gene.
Column metadata was obtained from the authors (indirectly, via the Hemberg group) 
and contains information such as the cell type labels and donor status.

If \code{ensembl=TRUE}, the Entrez IDs are converted to Ensembl IDs in the row names of the output object.
Rows with missing Ensembl IDs are discarded, and only the first occurrence of duplicated IDs is retained.

If \code{location=TRUE}, the coordinates of the Ensembl gene models are stored in the \code{\link[SummarizedExperiment]{rowRanges}} of the output.
Note that this is only performed if \code{ensembl=TRUE}.

All data are downloaded from ExperimentHub and cached for local re-use.
Specific resources can be retrieved by searching for \code{scRNAseq/xin-pancreas}.
}
\examples{
sce <- XinPancreasData()

}
\references{
Xin A et al. (2016).
RNA sequencing of single human islet cells reveals type 2 diabetes genes.
\emph{Cell Metab.} 24(4), 608-615.
}
\author{
Aaron Lun,
using additional metadata obtained by Vladimir Kiselev.
}
