% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RomanovBrainData.R
\name{RomanovBrainData}
\alias{RomanovBrainData}
\title{Obtain the Romanov brain data}
\usage{
RomanovBrainData(ensembl = FALSE, location = TRUE, legacy = FALSE)
}
\arguments{
\item{ensembl}{Logical scalar indicating whether the output row names should contain Ensembl identifiers.}

\item{location}{Logical scalar indicating whether genomic coordinates should be returned.}

\item{legacy}{Logical scalar indicating whether to pull data from ExperimentHub.
By default, we use data from the gypsum backend.}
}
\value{
A \link[SingleCellExperiment]{SingleCellExperiment} object with a single matrix of UMI counts.
}
\description{
Obtain the mouse brain single-cell RNA-seq dataset from Romanov et al. (2017).
}
\details{
Column metadata is provided in the same form as supplied in GSE74672.
This contains information such as the reporter gene expressed in each cell, the mouse line, dissection type and so on.

Counts for ERCC spike-ins are stored in the \code{"ERCC"} entry of the \code{\link[SingleCellExperiment]{altExps}}.
Note that some of the spike-in rows have \code{NA} observations for some (but not all) cells.

If \code{ensembl=TRUE}, the gene symbols are converted to Ensembl IDs in the row names of the output object.
Rows with missing Ensembl IDs are discarded, and only the first occurrence of duplicated IDs is retained.

If \code{location=TRUE}, the coordinates of the Ensembl gene models are stored in the \code{\link[SummarizedExperiment]{rowRanges}} of the output.
Note that this is only performed if \code{ensembl=TRUE}.

All data are downloaded from ExperimentHub and cached for local re-use.
Specific resources can be retrieved by searching for \code{scRNAseq/romanov-brain}.
}
\examples{
sce <- RomanovBrainData()

}
\references{
Romanov RA et al. (2017).
Molecular interrogation of hypothalamic organization reveals distinct dopamine neuronal subtypes. 
\emph{Nat. Neurosci.} 20, 176-188.
}
\author{
Aaron Lun,
based on code by Vladimir Kiselev and Tallulah Andrews.
}
