meta <- data.frame(
  Title = c("DHSA549Hg38",
            "hg19_10kb_bins","hg19_10kb_ctcfBoundBinPairs",
            "exclude_hg38_all","seg_cbs","seg_hmm",
            "hg38_10kb_bins","hg38_10kb_ctcfBoundBinPairs"),
  Description =
    c("DNase hypersensitive peaks in A549 cell example data, lifted to hg38",
      "10Kb bins from hg19 with GM12878 metadata annotation features",
      "CTCF-bound 10Kb paired genomic interactions for hg19",
      "Excluded regions for hg38 including Kundaje et al, telomeres, and centromeres",
      "nullranges::segmentDensity segmentation for hg38 using CBS",
      "nullranges::segmentDensity segmentation for hg38 using HMM",
      "10Kb bins from hg38 with GM12878 metadata annotation features",
      "CTCF-bound 10Kb paired genomic interactions for hg38"),
  BiocVersion = c("3.14","3.14","3.14","3.15","3.15","3.15","3.15","3.15"),
  Genome = c("hg38","hg19","hg19","hg38","hg38","hg38","hg38","hg38"),
  SourceType = c("BED","TXT","TXT","BED","GTF","GTF","TXT","TXT"),
  SourceUrl =
    c("http://hgdownload.cse.ucsc.edu/goldenpath/hg19/encodeDCC/wgEncodeAwgDnaseUniform/wgEncodeAwgDnaseUwdukeA549UniPk.narrowPeak.gz",
      "https://www.ncbi.nlm.nih.gov/geo/query/acc.cgi?acc=GSE63525",
      "https://www.ncbi.nlm.nih.gov/geo/query/acc.cgi?acc=GSE63525",
      "https://www.encodeproject.org/annotations/ENCSR636HFF/",
      "https://bioconductor.org/packages/nullranges",
      "https://bioconductor.org/packages/nullranges",
      "https://www.ncbi.nlm.nih.gov/geo/query/acc.cgi?acc=GSE63525",
      "https://www.ncbi.nlm.nih.gov/geo/query/acc.cgi?acc=GSE63525"),
  SourceVersion = c("v1","v1","v1","v1","v1","v1","v1","v1"),
  Species = rep("Homo sapiens", 8),
  TaxonomyId = rep(9606, 8),
  Coordinate_1_based = rep(TRUE, 8),
  DataProvider = c("UCSC","Aiden Lab","Aiden Lab","Kundaje lab","Love lab","Love lab","Aiden Lab","Aiden Lab"),
  Maintainer = rep("Michael Love <michaelisaiahlove@gmail.com>", 8),
  RDataClass = c("GenomicRanges","InteractionSet")[c(1,1,2,1,1,1,1,2)],
  DispatchClass = rep("Rda", 8),
  RDataPath = file.path("nullrangesData","v1",
                        c("DHSA549Hg38.rda","hg19_10kb_bins.rda","hg19_10kb_ctcfBoundBinPairs.rda",
                          "exclude_hg38_all.rda","seg_cbs.rda","seg_hmm.rda",
                          "hg38_10kb_bins.rda","hg38_10kb_ctcfBoundBinPairs.rda")),
  Tags = c("wgEncode:DnaseSeq:A549 cell","DnaseSeq:CTCF:GM12878 cell","HiC:CTCF:GM12878 cell",
           "excluded:exclusion","segmentation","segmentation",
           "DnaseSeq:CTCF:GM12878 cell","HiC:CTCF:GM12878 cell"),
  Notes = rep("",8)
)

write.csv(meta, file="metadata-jan2019.csv", row.names=FALSE)
