% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_data.R
\name{loadPartialCorMetabolites}
\alias{loadPartialCorMetabolites}
\title{Load PartialCorMetabolites data}
\source{
FloresData_K_TK study. Original data processed for iModMix.
}
\usage{
loadPartialCorMetabolites()
}
\value{
A \code{data.frame} with metabolites as rows and samples as columns.
}
\description{
Loads the PartialCorMetabolites dataset from ExperimentHub.
}
\details{
The dataset contains partial correlation values between metabolites derived
from the FloresData_K_TK study.
Data were preprocessed similarly to genes:
\itemize{
\item Filtering features with >10\% missing values
\item Removing features with low variance
\item Scaling and KNN imputation of missing values
}

Partial correlations were calculated using \code{partial_cors()} with rho = 0.25.

Rows correspond to metabolites, columns correspond to samples. Each entry
represents the partial correlation of the metabolite with other metabolites,
adjusted for covariates.
}
\examples{
metabolites <- loadPartialCorMetabolites()
head(metabolites)
dim(metabolites)
}
