% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_data.R
\name{loadPartialCorGenes}
\alias{loadPartialCorGenes}
\title{Load PartialCorGenes data}
\source{
ccRCC4 study. Original data processed for iModMix.
}
\usage{
loadPartialCorGenes()
}
\value{
A \code{data.frame} with genes as rows and samples as columns.
}
\description{
Loads the PartialCorGenes dataset from ExperimentHub.
}
\details{
The dataset contains partial correlation values between genes derived from
the ccRCC4 study.
The original expression data were preprocessed using \code{load_data()}
which includes:
\itemize{
\item Filtering features with >10\% missing values
\item Removing features with low variance
\item Scaling and KNN imputation of missing values
}

Partial correlations were then calculated using \code{partial_cors()}: rho = 0.25.

Rows correspond to genes, columns correspond to samples. Each entry
represents the partial correlation of the gene with other genes,
adjusted for covariates.
}
\examples{
genes <- loadPartialCorGenes()
head(genes)
dim(genes)
}
