\name{syntren300.data}
\docType{data}
\alias{syntren300.data}
\title{Simulated Gene Expression Data}
\description{
    Dataset containing 800 samples and 300 genes generated by the publicly 
    available SynTReN generator using an ecoli source network. 
}
\usage{data(syntren300.data)}
\format{
    \code{syntren300.data} is a data frame containing 800 rows and 300 columns. 
    Each row contains a simulated microarray experiment and each column 
    contains a gene.
}
\source{
    SynTReN 1.1.3 with source network : ecoli\_nn.sif
}
\references{
    Van den Bulcke, Tim, et al. "SynTReN: a generator of synthetic gene 
    expression data for design and analysis of structure learning algorithms." 
    BMC Bioinformatics 7.1 (2006): 43.
}
\value{
    \code{data.frame} containg the data.
}
\seealso{
    \code{\link{syntren300.net}}, \code{\link{syntren1000.data}}, 
    \code{\link{rogers1000.data}}, \code{\link{gnw1565.data}}, 
    \code{\link{gnw2000.data}}
}
\examples{
    data(syntren300.data)
    # Print size
    print(dim(syntren300.data))
}
\keyword{datasets}
