\docType{data}
\name{gnw2000.data}
\alias{gnw2000.data}
\title{Simulated Gene Expression Data}
\description{
    Dataset containing 2000 samples and 2000 genes generated by the publicly 
    available GNW generator using a yeast source network with no added noise.
}
\usage{data(gnw2000.data)}
\format{
    \code{gnw2000.data} is a data frame containing 2000 rows and 2000 columns. 
    Each row contains a simulated microarray experiment and each column contains 
    a gene. The dataset was generated with GNW generator which relies on ODEs 
    for modeling gene regulation.
}
\source{
    GNW v3.1  with source network : Yeast
}
\references{
    Schaffter, Thomas, Daniel Marbach, and Dario Floreano. "GeneNetWeaver: 
    in silico benchmark generation and performance profiling of network 
    inference methods." Bioinformatics 27.16 (2011): 2263-2270.
}
\value{
    \code{data.frame} containg the data.
}
\seealso{
    \code{\link{gnw2000.net}}, \code{\link{gnw1565.data}},
    \code{\link{rogers1000.data}}, \code{\link{syntren300.data}},
    \code{\link{syntren1000.data}}
}
\examples{
    data(gnw2000.data)
    # Print size
    print(dim(gnw2000.data))
}
\keyword{datasets}
