% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zzz.r
\name{cursons2018_se}
\alias{cursons2018_se}
\title{Combinatorial miRNAs in breast cancer EMT from Cursons et al. (2018)}
\format{
A SummarizedExperiment object, containing gene expression data of
the Human Mammary Epithelial Cells (HMLE) cell line. The
\code{\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment::colData()}} function can be used to access the sample
annotations.
}
\description{
Cursons et al. used the Human Mammary Epithelial Cells (HMLE) cell line dataset.
A mesenchymal HMLE (mesHMLE) phenotype was induced following treatment with
transforming growth factors (TGFb). The mesHMLE subline was then treated with
mir200c to reinduce an epithelial phenotype. All mRNA RNA-seq was collected
using the Illumina HiSeq 2500 with a paired end read length of 100bp.
}
\details{
Data from this publication were downloaded from the European Nucleotide
Archive (ENA) and processed into a SummarizedExperiment object. Sample
annotations were modified from the original publication.
}
\examples{
library(ExperimentHub)
eh <- ExperimentHub()
emt_datasets <- query(eh, "emtdata")
}
\references{
Cursons, J., Pillman, K. A., Scheer, K. G., Gregory, P. A.,
Foroutan, M., Hediyeh-Zadeh, S., ... & Davis, M. J. (2018). Combinatorial
targeting by microRNAs co-ordinates post-transcriptional control of EMT. Cell
systems, 7(1), 77-91.
}
