% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/easierData_retrieval.R
\name{get_opt_models}
\alias{get_opt_models}
\title{Get the cancer-specific model feature parameters}
\usage{
get_opt_models()
}
\value{
A list containing for each cancer type and quantitative
descriptor, a matrix of feature coefficient values across
different tasks. The cancer types, for which a cancer-specific
model is available, are: "BLCA", "BRCA", "CESC", "CRC", "GBM",
"HNSC", "KIRC", "KIRP", "LIHC", "LUAD", "LUSC", "NSCLC", "OV",
"PAAD", "PRAD", "SKCM", "STAD", "THCA" and "UCEC".
}
\description{
Obtain the cancer-specific model feature parameters learned in
Lapuente-Santana et al. (2021).
For each quantitative descriptor, models were trained using
multi-task learning with randomized cross-validation repeated
100 times. For each quantitative descriptor, 1000 models are
available (100 per task).
}
\examples{
if (interactive()) {
    opt_models <- get_opt_models()
}
}
\references{
Óscar Lapuente-Santana, Maisa van Genderen, Peter A. J. Hilbers,
Francesca Finotello, and Federica Eduati. 2021. Interpretable Systems
Biomarkers Predict Response to Immune-Checkpoint Inhibitors.
Patterns, 100293. https://doi.org/10.1016/j.patter.2021.100293.
}
