#' depmap: Cancer Dependency Map Data Package
#'
#' The depmap package is a data package that accesses datsets from the Broad
#' Institute DepMap cancer dependency study using ExperimentHub. Datasets from
#' the most current release are available, including RNAI and CRISPR-Cas9 gene
#' knockout screens quantifying the genetic dependency for select cancer cell
#' lines. Additional datasets are also available pertaining to the log copy
#' number of genes for select cell lines, protein expression of cell lines as
#' measured by reverse phase protein lysate microarray (RPPA), 'Transcript Per
#' Million' (TPM) data, chemical dependecy (drug_sensativity), mass spectrometry
#' proteomic quantification (proteomic) as well as supplementary datasets which
#' contain metadata and mutation calls for the other datasets found in the
#' current release. This package will be updated on a quarterly basis to
#' incorporate the latest Broad Institute DepMap Public cancer dependency
#' datasets. All data made available in this package was generated by the Broad
#' Institute DepMap for research purposes and not intended for clinical use.
#' This data is distributed under the Creative Commons license
#' (Attribution 4.0 International (CC BY 4.0)).
#'
#' See the package vignettes and respective man pages for details.
#'
#' @name depmap
"_PACKAGE"

##' @title Returns the depmap release
##' @return `character(1)` with the depmap release
##' @md
##' @export
depmap_release <- function() "22Q2"

#' @import methods
NULL
