#' geneset.GOBP.hsa genesets for Homo sapiens
#'
#' Gene Ontology Biological Process (GOBP) genesets for Homo sapiens. All genesets are required to have >= 10 Entrez IDs.
#' Built on Mon Oct 16 16:22:22 2017.
#'
#' @format A \code{GeneSet} object with the following slots:
#' \describe{
#'     \item{type}{A \code{character} indicating the type of genesets, e.g. GOBP.}
#'     \item{dburl}{A \code{character} of the URL of the database underlying the genesets.}
#'     \item{organism}{A \code{character} of the organism, e.g. Homo sapiens.}
#'     \item{set.gene}{An \code{environment} containing a \code{list} whose keys are database specific accessions (e.g. GO IDs for GO terms), and whose elements are \code{character} vectors of Entrez Gene IDs.}
#'     \item{all.genes}{A \code{character} vector of all the Entrez Gene IDs contained over all the genesets in this \code{type}.}
#'     \item{set.name}{An \code{environment} containing a \code{list} whose keys are database specific accessions, and whose elements are human readable geneset names.}
#' }
#' @source org.Hs.eg.db_3.4.2 and GO.db_3.4.2
"geneset.GOBP.hsa"

#' geneset.GOCC.hsa genesets for Homo sapiens
#'
#' Gene Ontology Cellular Component (GOCC) genesets for Homo sapiens. All genesets are required to have >= 10 Entrez IDs.
#' Built on Mon Oct 16 16:22:22 2017.
#'
#' @format A \code{GeneSet} object with the following slots:
#' \describe{
#'     \item{type}{A \code{character} indicating the type of genesets, e.g. GOBP.}
#'     \item{dburl}{A \code{character} of the URL of the database underlying the genesets.}
#'     \item{organism}{A \code{character} of the organism, e.g. Homo sapiens.}
#'     \item{set.gene}{An \code{environment} containing a \code{list} whose keys are database specific accessions (e.g. GO IDs for GO terms), and whose elements are \code{character} vectors of Entrez Gene IDs.}
#'     \item{all.genes}{A \code{character} vector of all the Entrez Gene IDs contained over all the genesets in this \code{type}.}
#'     \item{set.name}{An \code{environment} containing a \code{list} whose keys are database specific accessions, and whose elements are human readable geneset names.}
#' }
#' @source org.Hs.eg.db_3.4.2 and GO.db_3.4.2
"geneset.GOCC.hsa"

#' geneset.GOMF.hsa genesets for Homo sapiens
#'
#' Gene Ontology Molecular Function (GOMF) genesets for Homo sapiens. All genesets are required to have >= 10 Entrez IDs.
#' Built on Mon Oct 16 16:22:22 2017.
#'
#' @format A \code{GeneSet} object with the following slots:
#' \describe{
#'     \item{type}{A \code{character} indicating the type of genesets, e.g. GOBP.}
#'     \item{dburl}{A \code{character} of the URL of the database underlying the genesets.}
#'     \item{organism}{A \code{character} of the organism, e.g. Homo sapiens.}
#'     \item{set.gene}{An \code{environment} containing a \code{list} whose keys are database specific accessions (e.g. GO IDs for GO terms), and whose elements are \code{character} vectors of Entrez Gene IDs.}
#'     \item{all.genes}{A \code{character} vector of all the Entrez Gene IDs contained over all the genesets in this \code{type}.}
#'     \item{set.name}{An \code{environment} containing a \code{list} whose keys are database specific accessions, and whose elements are human readable geneset names.}
#' }
#' @source org.Hs.eg.db_3.4.2 and GO.db_3.4.2
"geneset.GOMF.hsa"

#' geneset.GOBP.mmu genesets for Mus musculus
#'
#' Gene Ontology Biological Process (GOBP) genesets for Mus musculus. All genesets are required to have >= 10 Entrez IDs.
#' Built on Mon Oct 16 16:23:23 2017.
#'
#' @format A \code{GeneSet} object with the following slots:
#' \describe{
#'     \item{type}{A \code{character} indicating the type of genesets, e.g. GOBP.}
#'     \item{dburl}{A \code{character} of the URL of the database underlying the genesets.}
#'     \item{organism}{A \code{character} of the organism, e.g. Homo sapiens.}
#'     \item{set.gene}{An \code{environment} containing a \code{list} whose keys are database specific accessions (e.g. GO IDs for GO terms), and whose elements are \code{character} vectors of Entrez Gene IDs.}
#'     \item{all.genes}{A \code{character} vector of all the Entrez Gene IDs contained over all the genesets in this \code{type}.}
#'     \item{set.name}{An \code{environment} containing a \code{list} whose keys are database specific accessions, and whose elements are human readable geneset names.}
#' }
#' @source org.Mm.eg.db_3.4.2 and GO.db_3.4.2
"geneset.GOBP.mmu"

#' geneset.GOCC.mmu genesets for Mus musculus
#'
#' Gene Ontology Cellular Component (GOCC) genesets for Mus musculus. All genesets are required to have >= 10 Entrez IDs.
#' Built on Mon Oct 16 16:23:23 2017.
#'
#' @format A \code{GeneSet} object with the following slots:
#' \describe{
#'     \item{type}{A \code{character} indicating the type of genesets, e.g. GOBP.}
#'     \item{dburl}{A \code{character} of the URL of the database underlying the genesets.}
#'     \item{organism}{A \code{character} of the organism, e.g. Homo sapiens.}
#'     \item{set.gene}{An \code{environment} containing a \code{list} whose keys are database specific accessions (e.g. GO IDs for GO terms), and whose elements are \code{character} vectors of Entrez Gene IDs.}
#'     \item{all.genes}{A \code{character} vector of all the Entrez Gene IDs contained over all the genesets in this \code{type}.}
#'     \item{set.name}{An \code{environment} containing a \code{list} whose keys are database specific accessions, and whose elements are human readable geneset names.}
#' }
#' @source org.Mm.eg.db_3.4.2 and GO.db_3.4.2
"geneset.GOCC.mmu"

#' geneset.GOMF.mmu genesets for Mus musculus
#'
#' Gene Ontology Molecular Function (GOMF) genesets for Mus musculus. All genesets are required to have >= 10 Entrez IDs.
#' Built on Mon Oct 16 16:23:23 2017.
#'
#' @format A \code{GeneSet} object with the following slots:
#' \describe{
#'     \item{type}{A \code{character} indicating the type of genesets, e.g. GOBP.}
#'     \item{dburl}{A \code{character} of the URL of the database underlying the genesets.}
#'     \item{organism}{A \code{character} of the organism, e.g. Homo sapiens.}
#'     \item{set.gene}{An \code{environment} containing a \code{list} whose keys are database specific accessions (e.g. GO IDs for GO terms), and whose elements are \code{character} vectors of Entrez Gene IDs.}
#'     \item{all.genes}{A \code{character} vector of all the Entrez Gene IDs contained over all the genesets in this \code{type}.}
#'     \item{set.name}{An \code{environment} containing a \code{list} whose keys are database specific accessions, and whose elements are human readable geneset names.}
#' }
#' @source org.Mm.eg.db_3.4.2 and GO.db_3.4.2
"geneset.GOMF.mmu"

#' geneset.GOBP.rno genesets for Rattus norvegicus
#'
#' Gene Ontology Biological Process (GOBP) genesets for Rattus norvegicus. All genesets are required to have >= 10 Entrez IDs.
#' Built on Mon Oct 16 16:24:10 2017.
#'
#' @format A \code{GeneSet} object with the following slots:
#' \describe{
#'     \item{type}{A \code{character} indicating the type of genesets, e.g. GOBP.}
#'     \item{dburl}{A \code{character} of the URL of the database underlying the genesets.}
#'     \item{organism}{A \code{character} of the organism, e.g. Homo sapiens.}
#'     \item{set.gene}{An \code{environment} containing a \code{list} whose keys are database specific accessions (e.g. GO IDs for GO terms), and whose elements are \code{character} vectors of Entrez Gene IDs.}
#'     \item{all.genes}{A \code{character} vector of all the Entrez Gene IDs contained over all the genesets in this \code{type}.}
#'     \item{set.name}{An \code{environment} containing a \code{list} whose keys are database specific accessions, and whose elements are human readable geneset names.}
#' }
#' @source org.Rn.eg.db_3.4.2 and GO.db_3.4.2
"geneset.GOBP.rno"

#' geneset.GOCC.rno genesets for Rattus norvegicus
#'
#' Gene Ontology Cellular Component (GOCC) genesets for Rattus norvegicus. All genesets are required to have >= 10 Entrez IDs.
#' Built on Mon Oct 16 16:24:10 2017.
#'
#' @format A \code{GeneSet} object with the following slots:
#' \describe{
#'     \item{type}{A \code{character} indicating the type of genesets, e.g. GOBP.}
#'     \item{dburl}{A \code{character} of the URL of the database underlying the genesets.}
#'     \item{organism}{A \code{character} of the organism, e.g. Homo sapiens.}
#'     \item{set.gene}{An \code{environment} containing a \code{list} whose keys are database specific accessions (e.g. GO IDs for GO terms), and whose elements are \code{character} vectors of Entrez Gene IDs.}
#'     \item{all.genes}{A \code{character} vector of all the Entrez Gene IDs contained over all the genesets in this \code{type}.}
#'     \item{set.name}{An \code{environment} containing a \code{list} whose keys are database specific accessions, and whose elements are human readable geneset names.}
#' }
#' @source org.Rn.eg.db_3.4.2 and GO.db_3.4.2
"geneset.GOCC.rno"

#' geneset.GOMF.rno genesets for Rattus norvegicus
#'
#' Gene Ontology Molecular Function (GOMF) genesets for Rattus norvegicus. All genesets are required to have >= 10 Entrez IDs.
#' Built on Mon Oct 16 16:24:10 2017.
#'
#' @format A \code{GeneSet} object with the following slots:
#' \describe{
#'     \item{type}{A \code{character} indicating the type of genesets, e.g. GOBP.}
#'     \item{dburl}{A \code{character} of the URL of the database underlying the genesets.}
#'     \item{organism}{A \code{character} of the organism, e.g. Homo sapiens.}
#'     \item{set.gene}{An \code{environment} containing a \code{list} whose keys are database specific accessions (e.g. GO IDs for GO terms), and whose elements are \code{character} vectors of Entrez Gene IDs.}
#'     \item{all.genes}{A \code{character} vector of all the Entrez Gene IDs contained over all the genesets in this \code{type}.}
#'     \item{set.name}{An \code{environment} containing a \code{list} whose keys are database specific accessions, and whose elements are human readable geneset names.}
#' }
#' @source org.Rn.eg.db_3.4.2 and GO.db_3.4.2
"geneset.GOMF.rno"

#' geneset.GOBP.dme genesets for Drosophila melanogaster
#'
#' Gene Ontology Biological Process (GOBP) genesets for Drosophila melanogaster. All genesets are required to have >= 10 Entrez IDs.
#' Built on Mon Oct 16 16:24:38 2017.
#'
#' @format A \code{GeneSet} object with the following slots:
#' \describe{
#'     \item{type}{A \code{character} indicating the type of genesets, e.g. GOBP.}
#'     \item{dburl}{A \code{character} of the URL of the database underlying the genesets.}
#'     \item{organism}{A \code{character} of the organism, e.g. Homo sapiens.}
#'     \item{set.gene}{An \code{environment} containing a \code{list} whose keys are database specific accessions (e.g. GO IDs for GO terms), and whose elements are \code{character} vectors of Entrez Gene IDs.}
#'     \item{all.genes}{A \code{character} vector of all the Entrez Gene IDs contained over all the genesets in this \code{type}.}
#'     \item{set.name}{An \code{environment} containing a \code{list} whose keys are database specific accessions, and whose elements are human readable geneset names.}
#' }
#' @source org.Dm.eg.db_3.4.2 and GO.db_3.4.2
"geneset.GOBP.dme"

#' geneset.GOCC.dme genesets for Drosophila melanogaster
#'
#' Gene Ontology Cellular Component (GOCC) genesets for Drosophila melanogaster. All genesets are required to have >= 10 Entrez IDs.
#' Built on Mon Oct 16 16:24:38 2017.
#'
#' @format A \code{GeneSet} object with the following slots:
#' \describe{
#'     \item{type}{A \code{character} indicating the type of genesets, e.g. GOBP.}
#'     \item{dburl}{A \code{character} of the URL of the database underlying the genesets.}
#'     \item{organism}{A \code{character} of the organism, e.g. Homo sapiens.}
#'     \item{set.gene}{An \code{environment} containing a \code{list} whose keys are database specific accessions (e.g. GO IDs for GO terms), and whose elements are \code{character} vectors of Entrez Gene IDs.}
#'     \item{all.genes}{A \code{character} vector of all the Entrez Gene IDs contained over all the genesets in this \code{type}.}
#'     \item{set.name}{An \code{environment} containing a \code{list} whose keys are database specific accessions, and whose elements are human readable geneset names.}
#' }
#' @source org.Dm.eg.db_3.4.2 and GO.db_3.4.2
"geneset.GOCC.dme"

#' geneset.GOMF.dme genesets for Drosophila melanogaster
#'
#' Gene Ontology Molecular Function (GOMF) genesets for Drosophila melanogaster. All genesets are required to have >= 10 Entrez IDs.
#' Built on Mon Oct 16 16:24:38 2017.
#'
#' @format A \code{GeneSet} object with the following slots:
#' \describe{
#'     \item{type}{A \code{character} indicating the type of genesets, e.g. GOBP.}
#'     \item{dburl}{A \code{character} of the URL of the database underlying the genesets.}
#'     \item{organism}{A \code{character} of the organism, e.g. Homo sapiens.}
#'     \item{set.gene}{An \code{environment} containing a \code{list} whose keys are database specific accessions (e.g. GO IDs for GO terms), and whose elements are \code{character} vectors of Entrez Gene IDs.}
#'     \item{all.genes}{A \code{character} vector of all the Entrez Gene IDs contained over all the genesets in this \code{type}.}
#'     \item{set.name}{An \code{environment} containing a \code{list} whose keys are database specific accessions, and whose elements are human readable geneset names.}
#' }
#' @source org.Dm.eg.db_3.4.2 and GO.db_3.4.2
"geneset.GOMF.dme"

#' geneset.GOBP.dre genesets for Danio rerio
#'
#' Gene Ontology Biological Process (GOBP) genesets for Danio rerio. All genesets are required to have >= 10 Entrez IDs.
#' Built on Mon Oct 16 16:25:08 2017.
#'
#' @format A \code{GeneSet} object with the following slots:
#' \describe{
#'     \item{type}{A \code{character} indicating the type of genesets, e.g. GOBP.}
#'     \item{dburl}{A \code{character} of the URL of the database underlying the genesets.}
#'     \item{organism}{A \code{character} of the organism, e.g. Homo sapiens.}
#'     \item{set.gene}{An \code{environment} containing a \code{list} whose keys are database specific accessions (e.g. GO IDs for GO terms), and whose elements are \code{character} vectors of Entrez Gene IDs.}
#'     \item{all.genes}{A \code{character} vector of all the Entrez Gene IDs contained over all the genesets in this \code{type}.}
#'     \item{set.name}{An \code{environment} containing a \code{list} whose keys are database specific accessions, and whose elements are human readable geneset names.}
#' }
#' @source org.Dr.eg.db_3.4.2 and GO.db_3.4.2
"geneset.GOBP.dre"

#' geneset.GOCC.dre genesets for Danio rerio
#'
#' Gene Ontology Cellular Component (GOCC) genesets for Danio rerio. All genesets are required to have >= 10 Entrez IDs.
#' Built on Mon Oct 16 16:25:08 2017.
#'
#' @format A \code{GeneSet} object with the following slots:
#' \describe{
#'     \item{type}{A \code{character} indicating the type of genesets, e.g. GOBP.}
#'     \item{dburl}{A \code{character} of the URL of the database underlying the genesets.}
#'     \item{organism}{A \code{character} of the organism, e.g. Homo sapiens.}
#'     \item{set.gene}{An \code{environment} containing a \code{list} whose keys are database specific accessions (e.g. GO IDs for GO terms), and whose elements are \code{character} vectors of Entrez Gene IDs.}
#'     \item{all.genes}{A \code{character} vector of all the Entrez Gene IDs contained over all the genesets in this \code{type}.}
#'     \item{set.name}{An \code{environment} containing a \code{list} whose keys are database specific accessions, and whose elements are human readable geneset names.}
#' }
#' @source org.Dr.eg.db_3.4.2 and GO.db_3.4.2
"geneset.GOCC.dre"

#' geneset.GOMF.dre genesets for Danio rerio
#'
#' Gene Ontology Molecular Function (GOMF) genesets for Danio rerio. All genesets are required to have >= 10 Entrez IDs.
#' Built on Mon Oct 16 16:25:08 2017.
#'
#' @format A \code{GeneSet} object with the following slots:
#' \describe{
#'     \item{type}{A \code{character} indicating the type of genesets, e.g. GOBP.}
#'     \item{dburl}{A \code{character} of the URL of the database underlying the genesets.}
#'     \item{organism}{A \code{character} of the organism, e.g. Homo sapiens.}
#'     \item{set.gene}{An \code{environment} containing a \code{list} whose keys are database specific accessions (e.g. GO IDs for GO terms), and whose elements are \code{character} vectors of Entrez Gene IDs.}
#'     \item{all.genes}{A \code{character} vector of all the Entrez Gene IDs contained over all the genesets in this \code{type}.}
#'     \item{set.name}{An \code{environment} containing a \code{list} whose keys are database specific accessions, and whose elements are human readable geneset names.}
#' }
#' @source org.Dr.eg.db_3.4.2 and GO.db_3.4.2
"geneset.GOMF.dre"

