% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ImmGenData.R
\name{ImmGenData}
\alias{ImmGenData}
\title{Obtain mouse bulk expression data from the Immunologic Genome Project}
\usage{
ImmGenData(
  ensembl = FALSE,
  cell.ont = c("all", "nonna", "none"),
  legacy = FALSE
)
}
\arguments{
\item{ensembl}{Logical scalar indicating whether to convert row names to Ensembl IDs.
Genes without a mapping to a non-duplicated Ensembl ID are discarded.}

\item{cell.ont}{String specifying whether Cell Ontology terms should be included in the \code{\link{colData}}.
If \code{"nonna"}, all samples without a valid term are discarded;
if \code{"all"}, all samples are returned with (possibly \code{NA}) terms;
if \code{"none"}, terms are not added.}

\item{legacy}{Logical scalar indicating whether to pull data from ExperimentHub.
By default, we use data from the gypsum backend.}
}
\value{
A \linkS4class{SummarizedExperiment} object with a \code{"logcounts"} assay
containing the log-normalized expression values, along with cell type labels in the 
\code{\link{colData}}.
}
\description{
Download and cache the normalized expression values of 830 microarray samples of
pure mouse immune cells, generated by the Immunologic Genome Project (ImmGen).
}
\details{
This function provides normalized expression values of 830 microarray samples
generated by ImmGen from pure populations of murine immune cells (<http://www.immgen.org/>).
The samples were processed and normalized as described in Aran, Looney and
Liu et al. (2019), i.e., CEL files from the Gene Expression Omnibus (GEO; GSE15907 and GSE37448), 
were downloaded, processed, and normalized using the robust multi-array average
(RMA) procedure on probe-level data.

This dataset consists of 20 broad cell types (\code{"label.main"}) and 253
finely resolved cell subtypes (\code{"label.fine"}).
The subtypes have also been mapped to the Cell Ontology (\code{"label.ont"},
if \code{cell.ont} is not \code{"none"}), which can be used for further programmatic
queries.
}
\examples{
ref.se <- ImmGenData()

}
\references{
Heng TS, Painter MW, Immunological Genome Project Consortium (2008).
The Immunological Genome Project: networks of gene expression in immune cells.
\emph{Nat. Immunol.} 9, 1091-1094. 

Aran D, Looney AP, Liu L et al. (2019). 
Reference-based analysis of lung single-cell sequencing reveals a transitional profibrotic macrophage.
\emph{Nat. Immunol.} 20, 163–172.
}
\author{
Friederike Dündar
}
