\alias{TENxPBMCData}
\name{TENxPBMCData}

\title{10X PBMC Data}

\description{Various single-cell RNA-seq data on PBMC, generated by 10X Genomics.}

\usage{
TENxPBMCData(dataset = c("pbmc4k", "pbmc68k",
                         "frozen_pbmc_donor_a", "frozen_pbmc_donor_b",
                         "frozen_pbmc_donor_c", "pbmc33k", "pbmc3k",
                         "pbmc6k", "pbmc8k", "pbmc5k-CITEseq"),
             as.sparse = TRUE)

}

\arguments{
  \item{dataset}{Which PBMC dataset from 10X Genomics should be retrieved?}
  \item{as.sparse}{Logical, specifies whether the underlying HDF5 dataset should
    be treated as sparse or not - will be passed to the call to 
    \code{HDF5Array()}.
    Defaults to TRUE, i.e. by using the \code{DelayedArray} infrastructure.}
}
\value{
A SingleCellExperiment object with a HDF5Matrix in the \code{counts}
assay, which contains UMI counts for each gene in each cell. 
Row- and column-level metadata are also provided. 
In case of CITE-seq data, the "Antibody Capture" counts are stored in 
the \code{altExp} of the SingleCellExperiment.
}

\details{
Single-cell RNA-seq and CITE-seq data were generated by 10X Genomics at various
times, using different versions of CellRanger, different chemistries and
different genome builds. For details, see the 10X website.

We obtained \sQuote{filtered} data and generated
\code{SingleCellExperiment} containers with data stored as an HDF5
Assay.

As \code{rowData} we include \code{ENSEMBL} and \code{Symbol_TENx} which
are ENSEMBL gene ID and gene symbol provided by TENx genomics and a
remapping of the Ensembl identifier to a Hugo gene symbol as columns
\code{Symbol} using the \code{org.Hs.eg.db} package. The difference
between \code{Symbol} and \code{Symbol_TENx} is that the former has many
missing values (for non-protein coding genes) whereas the later is
technically not a Hugo gene symbol.
In case of CITE-seq data, the \code{rowData} has an additional column \code{Type} specifying if the counts are "Gene Expression" or "Antibody Capture". Note that there is a separate \code{rowData} for the \code{altExp}.
}

\seealso{
\code{\link[SingleCellExperiment]{SingleCellExperiment}}
}

\author{
  Kasper D. Hansen,
  Stephanie Hicks,
  Davide Risso
}

\references{
10X Genomics (2017).
1.3 Million PBMC Cells from E18 Mice.
\url{https://support.10xgenomics.com/single-cell-gene-expression/datasets/1.3.0/1M_neurons}
}

\examples{
sce <- TENxPBMCData()
sce
lib.size <- colSums(assay(sce))
hist(log10(lib.size))

# CITE-seq data
sce <- TENxPBMCData(dataset = "pbmc5k-CITEseq")
sce
altExp(sce)
}
