\alias{TENxBrainData}
\alias{TENxBrainData20k}
\name{TENxBrainData}

\title{10X Brain Data}

\description{Single-cell RNA-seq data for 1.3 million brain cells from E18 mice, generated by 10X Genomics.}

\usage{
TENxBrainData()

TENxBrainData20k()
}

\value{
A SingleCellExperiment object with a HDF5Matrix in the \code{counts} assay, which contains UMI counts for each gene in each cell.
Row- and column-level metadata are also provided.
}

\details{
Single-cell RNA-seq data were generated by 10X Genomics using the Cromium Megacell technology and processed using CellRanger 1.3.0.
Cells were obtained from the cortex, hippocampus and subventricular zone of two E18 mice.
Each count represents the number of unique molecular identifiers (UMIs) assigned to each gene in the Ensembl annotation (27998 genes in total).

The \code{TENxBrainData} will return a SingleCellExperiment object containing the full data set, i.e., 1306127 cells.
The \code{TENxBrainData20k} will return a subset of 20,000 cells from this full data set, as described on the 10X Genomics website.
The latter is often useful for quickly testing scripts prior to running them on the full data set.

The Ensembl ID and gene symbol are provided in the row-level metadata.
The barcode sequence, sequencing library ID and mouse of origin are provided in the column-level metadata.
All libraries with IDs greater than 69 are derived from the second mouse.
}

\seealso{
\code{\link[SingleCellExperiment]{SingleCellExperiment}}
}

\author{
Aaron Lun
}

\references{
10X Genomics (2017).
1.3 Million Brain Cells from E18 Mice.
\url{https://support.10xgenomics.com/single-cell-gene-expression/datasets/1.3.0/1M_neurons}
}

\examples{
sce <- TENxBrainData()
sce
sce[, 10000 + seq_len(10000)]
lib.size.10k <- colSums(assay(sce)[,seq_len(10000)])
hist(log10(lib.size.10k))
}
