
\name{SomaticCancerAlterations-package}
     
\docType{package}

\alias{SomaticCancerAlterations}
\alias{SomaticCancerAlterations-package}

\title{Somatic Cancer Alterations}

\description{
  A collection of studies with somatic cancer alterations.
}

\details{
  The 'SomaticCancerAlterations' package provides a collection of the
  mutational calls for different cancer studies, aiming for a tight
  integration with R and Bioconductor.  At the moment, this covers
  somatic single nucleotide variants (SNVs) and indels for several TCGA
  studies.  Over time, this colletion will be updated to include additional
  studies.
  
  The Cancer Genome Atlas (TCGA) is a consortium effort to analyze a
  variety of tumor types at multiple levels, including gene
  expression, methylation, copy number alterations and somatic
  mutations [\url{http://cancergenome.nih.gov}]. Most of this data is
  publically available, and offers a rich resource in understanding
  cancer-related data sets and experiments
  [\url{https://wiki.nci.nih.gov/display/TCGA/TCGA+Home}].
}

\references{
  \url{https://tcga-data.nci.nih.gov/tcga/}
  
  \url{https://tcga-data.nci.nih.gov/docs/publications/}
}

\author{
  Julian Gehring, with suggestions and contributions
  from Bernd Fischer
  
  Maintainer: Julian Gehring
}
   
\seealso{
  \code{\link[SomaticCancerAlterations]{SomaticCancerAlterations-functions}}
  
  \code{\link[SomaticCancerAlterations]{SomaticCancerAlterations-data}}
 }
 
\keyword{package}
\keyword{datasets}
