#' 
#' @title mRNA datasets from TCGA project
#'
#' @description
#' Package provides mRNA datasets from The Cancer Genome Atlas Project for
#' all cohorts types from \url{http://gdac.broadinstitute.org/}.
#' Data were downloaded using \link{RTCGA-package} and contain snapshots for
#' the date: \code{2015-11-01}. The process is described here:
#' \url{http://rtcga.github.io/RTCGA/}.
#' Use cases, examples and information about datasets in \pkg{RTCGA.data}
#' family can be found here: \code{browseVignettes("RTCGA")}. mRNA data format
#' is explained here \url{https://wiki.nci.nih.gov/display/TCGA/Gene+expression+data}.
#' Converting \pkg{RTCGA.mRNA} datasets from \code{data.frames} to Bioconductor classes is explained here \link{convertTCGA}.
#' 
#' @details \code{browseVignettes("RTCGA")}
#' 
#' @examples
#' 
#' \dontrun{
#' browseVignettes("RTCGA")
#' }
#'
#' 
#' @return Data frames with mRNA data.
#' 
#' @import RTCGA
#' @format NULL
#' @source \url{http://gdac.broadinstitute.org/}
#' 
#' 
#' @name mRNA
#' @rdname mRNA
#' @aliases BRCA.mRNA,COAD.mRNA,COADREAD.mRNA,GBMLGG.mRNA,KIPAN.mRNA,KIRC.mRNA,KIRP.mRNA,LGG.mRNA,LUAD.mRNA,LUSC.mRNA,OV.mRNA,READ.mRNA,UCEC.mRNA
#'
"BRCA.mRNA"
#' @name mRNA
#' @rdname mRNA
#' @format NULL
#' 
"COAD.mRNA"
#' @name mRNA
#' @rdname mRNA
#' @format NULL
#' 
"COADREAD.mRNA"
#' @name mRNA
#' @rdname mRNA
#' @format NULL
#' 
"GBMLGG.mRNA"  
#' @name mRNA
#' @rdname mRNA
#' @format NULL
#' 
"KIPAN.mRNA"
#' @name mRNA
#' @rdname mRNA
#' @format NULL
#' 
"KIRC.mRNA"    
#' @name mRNA
#' @rdname mRNA
#' @format NULL
#' 
"KIRP.mRNA"
#' @name mRNA
#' @rdname mRNA
#' @format NULL
#' 
"LGG.mRNA"
#' @name mRNA
#' @rdname mRNA
#' @format NULL
#' 
"LUAD.mRNA"
#' @name mRNA
#' @rdname mRNA
#' @format NULL
#' 
"LUSC.mRNA"
#' @name mRNA
#' @rdname mRNA
#' @format NULL
#' 
"OV.mRNA"      
#' @name mRNA
#' @rdname mRNA
#' @format NULL
#' 
"READ.mRNA"
#' @name mRNA
#' @rdname mRNA
#' @format NULL
#' 
"UCEC.mRNA"