% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_zeroshot_heatmap.R
\name{plot_zeroshot_heatmap}
\alias{plot_zeroshot_heatmap}
\title{Visualize Zero Shot Scores Along a Protein}
\usage{
plot_zeroshot_heatmap(
  assay_name,
  model_data,
  model = NULL,
  start_pos = NULL,
  end_pos = NULL,
  exact_coord = FALSE,
  cluster_rows = FALSE,
  cluster_columns = FALSE,
  color_scheme,
  ...
)
}
\arguments{
\item{assay_name}{\code{character()} a valid assay name. For the full list of
available assays, run \code{names()} on the list object loaded with
\code{ProteinGymR::zeroshot_substitutions()}. Alternatively, the name of a
user-defined DMS assay.}

\item{model_data}{\code{list()} object of zero-shot assays loaded with
\code{ProteinGymR::zeroshot_substitutions()}.
Alternatively, a user-defined list of assays with names corresponding
to \code{assay_name} param.}

\item{model}{\code{character()} one of the 79 zero-shot models to plot. To view
the list of models, runs \code{ProteinGymR::available_models()}.}

\item{start_pos}{\code{integer()} first amino acid position to plot. If missing,
default start is at the first position along the protein where zero shot
scores are available.}

\item{end_pos}{\code{integer()} last amino acid position to plot. If missing,
default end is at the last position along the protein where zero shot
scores are available.}

\item{exact_coord}{\code{logical()} TRUE will plot the precise \code{start_pos}
and \code{end_pos} coordinates defined. By default, \code{exact_coord} is set to
FALSE, plotting only amino acid positions with available data in the
chosen assay.}

\item{cluster_rows}{\code{logical()} defaults to FALSE. See argument details in
\link[ComplexHeatmap:Heatmap]{ComplexHeatmap::Heatmap}.}

\item{cluster_columns}{\code{logical()} defaults to FALSE. See argument details in
\link[ComplexHeatmap:Heatmap]{ComplexHeatmap::Heatmap}.}

\item{color_scheme}{\code{character()} defaults to blue, white, and red to
represent positive, neutral, negative scores. Set argument equal to "EVE"
to use the color scheme consistent with the popEVE portal.}

\item{...}{additional arguments passed to internal plotting functions.}
}
\value{
Returns a \link[ComplexHeatmap:Heatmap]{ComplexHeatmap::Heatmap} plot of zero-shot model scores
for each position along a protein in a chosen DMS substitution assay.
The x-axis shows amino acid positions where a DMS mutation exist, and the
y-axis represents possible amino acid residues, ordered by default based
on the physiochemical groupings. Higher and lower DMS scores indicate a
more positive or negative fitness effect after the mutation, respectively.
}
\description{
\code{plot_zeroshot_heatmap()} plots predicted model scores under the
zero-shot model for amino acid substitutions along a protein in a defined
DMS assay.
}
\details{
For \code{plot_zeroshot_heatmap()},
\code{model_data} must be a \code{list()} object with set names for each assay
element matching \code{assay_name} parameter.

Each assay in the \code{model_data()} must include the following columns:
\itemize{
\item \code{mutant}: Mutant identifier string matching.
Specifically, the set of substitutions to apply on the reference sequence
to obtain the mutated sequence (e.g., A1P:D2N implies the amino acid 'A'
at position 1 should be replaced by 'P', and 'D' at position 2 should be
replaced by 'N').
\item A column with predicted model scores for each substitution. Column name
should match \code{model} argument string.
}
}
\examples{

available_models()

plot_zeroshot_heatmap(assay_name = "A0A192B1T2_9HIV1_Haddox_2018", 
    model = "GEMME",
    start_pos = 600,
    end_pos = 700, 
    color_scheme = "EVE")
    
plot_zeroshot_heatmap(assay_name = "SRC_HUMAN_Nguyen_2022",
    model = "CARP_38M")

}
