/*
 * Decompiled with CFR 0.152.
 */
package slib.utils.threads;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import slib.utils.ex.SLIB_Ex_Critic;
import slib.utils.threads.PoolLocker;
import slib.utils.threads.ThreadManager;

public class PoolWorker
extends PoolLocker {
    ExecutorService pool;

    protected PoolWorker(int size) {
        super(size);
        this.pool = Executors.newFixedThreadPool(size);
    }

    public ExecutorService getPool() {
        return this.pool;
    }

    public void forceShutdown() {
        this.pool.shutdownNow();
    }

    public void shutdown() throws SLIB_Ex_Critic {
        this.shutdown(Long.MAX_VALUE, TimeUnit.DAYS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(long timeout, TimeUnit timeunit) throws SLIB_Ex_Critic {
        boolean alreadyShutDown = this.pool.isShutdown();
        try {
            this.pool.shutdown();
            this.pool.awaitTermination(timeout, timeunit);
        }
        catch (InterruptedException e) {
            new SLIB_Ex_Critic(e.getMessage());
        }
        finally {
            if (!alreadyShutDown) {
                ThreadManager.getSingleton().freeResource(this.capacity);
            }
        }
    }
}

