/*
 * Decompiled with CFR 0.152.
 */
package slib.sml.sm.core.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openrdf.model.URI;
import org.openrdf.model.vocabulary.RDFS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import slib.graph.algo.extraction.rvf.RVF_TAX;
import slib.graph.algo.traversal.classical.DFS;
import slib.graph.model.graph.G;
import slib.graph.model.graph.utils.Direction;
import slib.graph.model.graph.utils.WalkConstraint;
import slib.graph.utils.WalkConstraintGeneric;
import slib.sml.sm.core.engine.SM_Engine;
import slib.sml.sm.core.utils.LCAFinder;
import slib.utils.ex.SLIB_Ex_Critic;
import slib.utils.ex.SLIB_Exception;
import slib.utils.impl.SetUtils;

public class LCAFinderImpl
implements LCAFinder {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    G graph;
    SM_Engine engine;

    public LCAFinderImpl(SM_Engine engine) {
        this.engine = engine;
        this.graph = engine.getGraph();
    }

    private URI getNextUnvisited(List<URI> ancestorsOrdered, Map<URI, Boolean> visited) {
        for (int i = ancestorsOrdered.size() - 1; i >= 0; --i) {
            if (!visited.get(ancestorsOrdered.get(i)).equals(Boolean.FALSE)) continue;
            return ancestorsOrdered.get(i);
        }
        return null;
    }

    private boolean containsUnvisitedVertices(Map<URI, Boolean> visited) {
        for (URI v : visited.keySet()) {
            if (!visited.get(v).equals(Boolean.FALSE)) continue;
            return true;
        }
        return false;
    }

    private void printStackStatus(List<URI> ancestorsOrdered, Map<URI, Boolean> visited) {
        for (int i = ancestorsOrdered.size() - 1; i >= 0; --i) {
            System.out.println(ancestorsOrdered.get(i) + "\t" + visited.get(ancestorsOrdered.get(i)));
        }
    }

    @Override
    public Set<URI> getLCAs(URI a, URI b) throws SLIB_Exception {
        if (!this.graph.containsVertex(a)) {
            throw new SLIB_Ex_Critic("Graph " + this.graph.getURI() + " doesn't contain vertice " + a);
        }
        if (!this.graph.containsVertex(b)) {
            throw new SLIB_Ex_Critic("Graph " + this.graph.getURI() + " doesn't contain vertice " + b);
        }
        Set<Object> lca = new HashSet();
        Set<URI> ancA = this.engine.getAncestorsInc(a);
        Set<URI> ancB = this.engine.getAncestorsInc(b);
        if (ancA.contains(b)) {
            lca = SetUtils.buildSet(b);
        } else if (ancB.contains(a)) {
            lca = SetUtils.buildSet(a);
        } else {
            Set<URI> intersection = SetUtils.intersection(this.engine.getAncestorsInc(a), this.engine.getAncestorsInc(b));
            Set<URI> queries = SetUtils.buildSet(a);
            queries.add(b);
            WalkConstraintGeneric wc = new WalkConstraintGeneric(RDFS.SUBCLASSOF, Direction.OUT);
            DFS dfs = new DFS(this.graph, queries, (WalkConstraint)wc);
            List<URI> to = dfs.getTraversalOrder();
            to.remove(a);
            to.remove(b);
            ArrayList<URI> ancestorsOrdered = new ArrayList<URI>(to.size());
            for (URI uRI : to) {
                if (!intersection.contains(uRI)) continue;
                ancestorsOrdered.add(uRI);
            }
            HashMap<URI, Boolean> isVisited = new HashMap<URI, Boolean>(ancestorsOrdered.size());
            for (URI v : ancestorsOrdered) {
                isVisited.put(v, Boolean.FALSE);
            }
            RVF_TAX rVF_TAX = new RVF_TAX(this.graph, Direction.OUT);
            while (this.containsUnvisitedVertices(isVisited)) {
                URI v;
                v = this.getNextUnvisited(ancestorsOrdered, isVisited);
                lca.add(v);
                isVisited.put(v, Boolean.TRUE);
                Set<URI> ancestorsV = rVF_TAX.getRV(v);
                for (URI anc : ancestorsV) {
                    isVisited.put(anc, Boolean.TRUE);
                }
            }
        }
        return lca;
    }
}

