/*
 * Decompiled with CFR 0.152.
 */
package slib.sml.sm.core.measures.graph.pairwise.dag.node_based;

import org.openrdf.model.URI;
import slib.sml.sm.core.engine.SM_Engine;
import slib.sml.sm.core.measures.graph.pairwise.dag.node_based.Sim_DAG_node_abstract;
import slib.sml.sm.core.utils.SMconf;
import slib.utils.ex.SLIB_Ex_Critic;
import slib.utils.ex.SLIB_Exception;

public class Sim_pairwise_DAG_node_IC_Tversky_Ratio_Model
extends Sim_DAG_node_abstract {
    public static final String alpha_param_name = "alpha";
    public static final String beta_param_name = "beta";
    protected double alpha = 0.5;
    protected double beta = 0.5;

    public Sim_pairwise_DAG_node_IC_Tversky_Ratio_Model() {
    }

    public Sim_pairwise_DAG_node_IC_Tversky_Ratio_Model(double alpha, double beta) {
        this.alpha = alpha;
        this.beta = beta;
    }

    @Override
    public double compare(URI a, URI b, SM_Engine c, SMconf conf) throws SLIB_Exception {
        if (conf != null && conf.containsParam(alpha_param_name)) {
            this.alpha = conf.getParamAsDouble(alpha_param_name);
        }
        if (conf != null && conf.containsParam(beta_param_name)) {
            this.beta = conf.getParamAsDouble(beta_param_name);
        }
        if (conf == null || conf.getICconf() == null) {
            throw new IllegalArgumentException("Measure " + this.getClass().getSimpleName() + " requires a configuration to be specified an IC to be specified");
        }
        double ic_a = c.getIC(conf.getICconf(), a);
        double ic_b = c.getIC(conf.getICconf(), b);
        double ic_MICA = c.getIC_MICA(conf.getICconf(), a, b);
        return Sim_pairwise_DAG_node_IC_Tversky_Ratio_Model.sim(ic_a, ic_b, ic_MICA, this.alpha, this.beta);
    }

    public static double sim(double ic_a, double ic_b, double ic_mica, double alpha, double beta) throws SLIB_Ex_Critic {
        if (ic_mica > ic_a || ic_mica > ic_b) {
            throw new SLIB_Ex_Critic("Wrong parameters used with Tversky measure. IC MICA must be inferior to IC(a) and IC(b)");
        }
        double j = 0.0;
        if (ic_mica != 0.0) {
            j = ic_mica / (alpha * (ic_a - ic_mica) + beta * (ic_b - ic_mica) + ic_mica);
        }
        return j;
    }

    @Override
    public Boolean isSymmetric() {
        return this.alpha == this.beta;
    }
}

