/*
 * Decompiled with CFR 0.152.
 */
package slib.indexer.snomed_ct;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashSet;
import java.util.regex.Pattern;
import org.openrdf.model.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import slib.graph.model.graph.G;
import slib.graph.model.repo.URIFactory;
import slib.indexer.IndexHash;
import slib.indexer.URIDescriptionBasic;
import slib.utils.ex.SLIB_Ex_Critic;
import slib.utils.ex.SLIB_Exception;

public class IndexerSNOMEDCT_RF2 {
    private static final int DESCRIPTION_CONCEPT_ID = 4;
    private static final int DESCRIPTION_ACTIVE = 2;
    private static final int DESCRIPTION_TERM = 7;
    private static final int DESCRIPTION_DATE = 1;
    static Logger logger = LoggerFactory.getLogger(IndexerSNOMEDCT_RF2.class);
    static Pattern p_tab = Pattern.compile("\\t");
    static URIFactory repo;

    public static IndexHash buildIndex(URIFactory factory, G graph, String description_file, String defaultNamespace, boolean EXCLUDE_INACTIVE_DESCRIPTIONS) throws SLIB_Exception {
        repo = factory;
        logger.info("Building Index");
        logger.info("Description file: " + description_file);
        logger.info("EXCLUDE_INACTIVE_DESCRIPTIONS: " + EXCLUDE_INACTIVE_DESCRIPTIONS);
        IndexHash index = new IndexHash();
        try {
            String line;
            FileInputStream fstream = new FileInputStream(description_file);
            DataInputStream in = new DataInputStream(fstream);
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            boolean header = true;
            while ((line = br.readLine()) != null) {
                URI cURI;
                if (header) {
                    header = false;
                    continue;
                }
                String[] split = p_tab.split(line);
                boolean active = split[2].trim().equals("1");
                if (!active && EXCLUDE_INACTIVE_DESCRIPTIONS || !graph.containsVertex(cURI = repo.getURI(defaultNamespace + split[4]))) continue;
                if (!index.getMapping().containsKey(cURI)) {
                    URIDescriptionBasic i = new URIDescriptionBasic(cURI, split[7]);
                    index.getMapping().put(cURI, i);
                    continue;
                }
                index.getMapping().get(cURI).addDescription(split[7]);
            }
            in.close();
            logger.info("Process Done");
        }
        catch (IOException ex) {
            throw new SLIB_Ex_Critic(ex.getMessage());
        }
        return index;
    }

    public static IndexHash buildIndex(URIFactory factory, String description_file, String defaultNamespace, G graph, boolean EXCLUDE_INACTIVE_DESCRIPTIONS) throws SLIB_Exception {
        logger.info("Building Index");
        IndexHash index = IndexerSNOMEDCT_RF2.buildIndex(factory, graph, description_file, defaultNamespace, EXCLUDE_INACTIVE_DESCRIPTIONS);
        logger.info("Cleaning Index");
        HashSet<URI> toRemove = new HashSet<URI>();
        for (URI k : index.getMapping().keySet()) {
            if (graph.containsVertex(k)) continue;
            toRemove.add(k);
        }
        for (URI v : toRemove) {
            index.getMapping().remove(v);
        }
        logger.info("Done");
        return index;
    }
}

