/*
 * Decompiled with CFR 0.152.
 */
package slib.graph.io.loader.csv;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.openrdf.model.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import slib.graph.io.conf.GDataConf;
import slib.graph.io.loader.GraphLoader;
import slib.graph.io.loader.csv.CSV_Mapping;
import slib.graph.io.loader.csv.CSV_StatementTemplate;
import slib.graph.io.loader.csv.CSV_StatementTemplate_Constraint;
import slib.graph.io.loader.csv.StatementTemplateElement;
import slib.graph.io.loader.csv.StatementTemplate_Constraint_Type;
import slib.graph.model.graph.G;
import slib.graph.model.impl.repo.URIFactoryMemory;
import slib.utils.ex.SLIB_Ex_Critic;
import slib.utils.ex.SLIB_Exception;
import slib.utils.impl.Util;

public class GraphLoader_CSV
implements GraphLoader {
    boolean skipHeader = false;
    URIFactoryMemory dataRepo = URIFactoryMemory.getSingleton();
    Map<Integer, CSV_Mapping> mappings = new HashMap<Integer, CSV_Mapping>();
    Map<Integer, CSV_StatementTemplate> statementTemplates = new HashMap<Integer, CSV_StatementTemplate>();
    Pattern pattern = null;
    G g;
    Logger logger = LoggerFactory.getLogger(this.getClass());

    public void addMapping(int id, String prefix) {
        if (prefix == null) {
            prefix = "";
        }
        this.mappings.put(id, new CSV_Mapping(id, prefix));
    }

    public void addStatementTemplate(int src_id, int target_id, URI predicate_URI) {
        assert (predicate_URI != null);
        this.statementTemplates.put(src_id, new CSV_StatementTemplate(src_id, target_id, predicate_URI));
    }

    @Override
    public void populate(GDataConf conf, G g) throws SLIB_Exception {
        this.logger.info("-------------------------------------");
        this.logger.info("Loading CSV.");
        this.logger.info("-------------------------------------");
        this.g = g;
        this.loadConf(conf);
        this.loadCSV(conf.getLoc());
        this.logger.info("CSV specification loaded.");
        this.logger.info("-------------------------------------");
    }

    private void loadConf(GDataConf conf) throws SLIB_Ex_Critic {
        String header = (String)conf.getParameter("header");
        if (header == null || Util.stringToBoolean(header)) {
            this.skipHeader = true;
        }
        this.logger.info("Skipping header " + this.skipHeader);
        String separator = (String)conf.getParameter("separator");
        this.pattern = separator == null ? Pattern.compile("\\t") : Pattern.compile(separator);
        HashMap mappingsLocal = (HashMap)conf.getParameter("mappings");
        HashMap statementTemplatesLocal = (HashMap)conf.getParameter("statementTemplates");
        if (mappingsLocal != null) {
            this.mappings.putAll(mappingsLocal);
        }
        if (statementTemplatesLocal != null) {
            this.statementTemplates.putAll(statementTemplatesLocal);
        }
        if (this.mappings.isEmpty()) {
            throw new SLIB_Ex_Critic("Please specify a mapping for CSV loader");
        }
        if (this.statementTemplates.isEmpty()) {
            throw new SLIB_Ex_Critic("Please specify a statement template for CSV loader");
        }
    }

    private void loadCSV(String filepath) throws SLIB_Exception {
        long evaluated = 0L;
        long rejected = 0L;
        try {
            String line;
            FileInputStream fstream = new FileInputStream(filepath);
            DataInputStream in = new DataInputStream(fstream);
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            while ((line = br.readLine()) != null) {
                if (this.skipHeader) {
                    this.skipHeader = false;
                    continue;
                }
                line = line.trim();
                String[] data = this.pattern.split(line);
                for (CSV_StatementTemplate t : this.statementTemplates.values()) {
                    if (!this.buildStatement(t, data)) {
                        ++rejected;
                    }
                    ++evaluated;
                }
            }
            in.close();
        }
        catch (IOException e) {
            throw new SLIB_Ex_Critic(e.getMessage());
        }
        this.logger.info("Number of statements rejected due to constraint: " + rejected + "/" + evaluated);
        this.logger.info("CSV Loading ok.");
    }

    private boolean buildStatement(CSV_StatementTemplate t, String[] data) throws SLIB_Ex_Critic {
        URI subject = this.buildURI(t.src_id, data);
        URI object = this.buildURI(t.target_id, data);
        boolean valid = true;
        for (CSV_StatementTemplate_Constraint c : t.constraints) {
            if (c.type == StatementTemplate_Constraint_Type.EXISTS) {
                if (c.onElement == StatementTemplateElement.SUBJECT && !this.g.containsVertex(subject)) {
                    valid = false;
                }
                if (c.onElement == StatementTemplateElement.OBJECT && !this.g.containsVertex(object)) {
                    valid = false;
                }
            }
            if (valid) continue;
            break;
        }
        if (valid) {
            this.g.addE(subject, t.predicate, object);
            return true;
        }
        return false;
    }

    private URI buildURI(int id, String[] data) throws SLIB_Ex_Critic {
        CSV_Mapping vmap = this.mappings.get(id);
        if (vmap == null || data.length - 1 < id) {
            throw new SLIB_Ex_Critic("Cannot load statement considering the given configuration. Error parsing " + Arrays.toString(data));
        }
        String uriAsString = data[id];
        if (vmap.prefix != null) {
            uriAsString = vmap.prefix + uriAsString;
        }
        return this.dataRepo.getURI(uriAsString);
    }
}

